
//=========================================================
// ଠ 室 ப: [h[[[:]m][:]s]],  h, m  s (hour, minute 
// second)  ᨬ '@', '!',    㧭 ᫮;
// ६  24-ᮢ ଠ, ࠧ⥫ (᫨ )    ':',
// '.',   ;  '!' 祭    tdef,  '@'
// ᮮ⢥饥   ts  , 騥  ,
// ᫨ ⮫쪮 ப   (⮣ ts ⠪  )

static byte FAST_ t2v(PCStr &s, byte def){
	register char ch = *s; s++;
	if(ch == '@') return UNDEF + '@';
	if(ch == '!') return def;
	if(!isdigit(ch)) return UNDEF;
	def = ch - '0'; ch = *s;
	if(isdigit(ch)) { def = 10 * def + ch - '0', s++; }
	return def;
}

#define timesep(ch, def) ((ch) == ':' || (ch) == '.' || (ch) == def)

bool parsetime(PCStr s, TIME tdef, TIME &ts){
	//---  -ࠧ⥫,  㪠  ன ࠭
	COUNTRY cp; char ch;
	if(country(0, &cp)){
		ch = cp.co_tmsep[0]; if(ch == '@' || ch == '!') ch = ':';
	}else	ch = ':';
	char tmsep = ch;

	byte hr, mn = 0; count sc = 0;

	//--- ᪠஢  ।  ᮢ, , ᥪ㭤
	if(*s == EOS) return true;
	if((hr = t2v(s, tdef.hour)) == UNDEF) return false; ch = *s;
	if(ch){	if(timesep(ch, tmsep)) s++; else ch = EOS; tmsep = ch;
		if((mn = t2v(s, tdef.minute)) == UNDEF) return false; ch = *s;
		if(ch){	if(ch == tmsep) s++;
			if((sc = t2v(s, tdef.second)) == UNDEF) return false;
			if(*s != EOS) return false;
	}	}
	if(hr < UNDEF) ts.hour = hr;
	if(mn < UNDEF) ts.minute = mn;
	if(sc < UNDEF) ts.second = sc;
	return true;
}
