-- sha1.e - Secure Hash Algorithm (SHA-1) for Euphoria - version 1.33
-- Copyright (C) 2002  Davi Tassinari de Figueiredo
--
-- If you wish to contact me, send an e-mail to davitf@eml.cc .
--
-- You can get the latest version of this program from my Euphoria page:
-- http://www16.brinkster.com/davitf/
--
--
-- License terms and disclaimer:
--
-- Permission is granted to anyone to use this software for any purpose,
-- including commercial applications, and to alter it and redistribute it
-- freely, subject to the following restrictions:
--
-- 1. The origin of this software must not be misrepresented; you must not
--    claim that you wrote the original software or remove the original
--    authors' names.
-- 2. Altered source versions must be plainly marked as such, and must not
--    be misrepresented as being the original software.
-- 3. All source distributions, with or without modifications, must be
--    distributed under this license. You may also opt to distribute the
--    software under the GNU General Public License, version 2 or (at your
--    option) any later version, in which case you should replace this
--    notice with an appropriate one. If this software's source code is
--    distributed as part of a larger product, this item does not apply to
--    the rest of the product.
-- 4. If you use this software in a product, an acknowledgment in the
--    product documentation is required. If the source code for the product
--    is not freely distributed, you must include information on how to
--    freely obtain the original software's source code.
--
-- This software is provided 'as-is', without any express or implied
-- warranty.  In no event will the authors be held liable for any damages
-- arising from the use of this software.
--
-- If you want to distribute this software in a way not allowed by this
-- license, or distribute the source under different license terms, contact
-- the authors for permission.


include machine.e


-- 'General-purpose' routines

-- Reversed versions of int_to_bytes and bytes_to_int
-- (most-significant byte first)

function rev_int_to_bytes(atom x)
    -- adapted and optimized from int_to_bytes, in machine.e

    integer a,b,c

    a = and_bits(x, #FF)
    x = floor(x / #100)
    b = and_bits(x, #FF)
    x = floor(x / #100)
    c = and_bits(x, #FF)
    x = floor(x / #100)
    return {x,c,b,a}
end function

function rev_bytes_to_int(sequence s)
    -- adapted from bytes_to_int, in machine.e
    return s[4] +
	   s[3] * #100 +
	   s[2] * #10000 +
	   s[1] * #1000000
end function

-- End of 'general-purpose' routines


constant words_address=allocate(20),h_address=allocate(20)
constant A_address=words_address,B_address=A_address+4,C_address=B_address+4,
D_address=C_address+4,E_address=D_address+4,w_address=allocate(4*80)

constant sha_1_code = allocate(624)


-- This is an Assembly routine compiled with Pete Eberlein's ASM to
-- Euphoria converter and transformed into a string to save space.
-- Its source is in the file sha1.asm .

poke(sha_1_code, and_bits(#FF,
"-tttt?_w_w_w_|wE4u5xmttttO-tttt.ttttuv5x6xuv"-116&
"__ge__ge__geޕ}eӯ}ܝݴ"+36&
"zZc;ljljlᢣjljdb"+31&
">[Wm̍ͤm:WUWU"+52&
"gܝege_]Np}eg"+36&
"괂ᢡ潝pljljlᢣjl"+31&
"UoOM>SWm̍ͤѢ.WU"+52&
"ljlᢣjljdbSul"+31&
"~~~~~~~~UTVS"+5))
poke4(sha_1_code + 5, w_address+64)
poke4(sha_1_code + 40, w_address+320)
poke4(sha_1_code + 47, h_address)
poke4(sha_1_code + 52, words_address)
poke4(sha_1_code + 101, w_address)
poke4(sha_1_code + 106, B_address)
poke4(sha_1_code + 116, C_address)
poke4(sha_1_code + 122, D_address)
poke4(sha_1_code + 129, A_address)
poke4(sha_1_code + 140, E_address)
poke4(sha_1_code + 153, D_address)
poke4(sha_1_code + 159, E_address)
poke4(sha_1_code + 165, C_address)
poke4(sha_1_code + 171, D_address)
poke4(sha_1_code + 177, B_address)
poke4(sha_1_code + 186, C_address)
poke4(sha_1_code + 192, A_address)
poke4(sha_1_code + 198, B_address)
poke4(sha_1_code + 203, A_address)
poke4(sha_1_code + 212, w_address+80)
poke4(sha_1_code + 220, B_address)
poke4(sha_1_code + 226, C_address)
poke4(sha_1_code + 232, D_address)
poke4(sha_1_code + 237, A_address)
poke4(sha_1_code + 248, E_address)
poke4(sha_1_code + 261, D_address)
poke4(sha_1_code + 267, E_address)
poke4(sha_1_code + 273, C_address)
poke4(sha_1_code + 279, D_address)
poke4(sha_1_code + 285, B_address)
poke4(sha_1_code + 294, C_address)
poke4(sha_1_code + 300, A_address)
poke4(sha_1_code + 306, B_address)
poke4(sha_1_code + 311, A_address)
poke4(sha_1_code + 320, w_address+160)
poke4(sha_1_code + 327, B_address)
poke4(sha_1_code + 335, C_address)
poke4(sha_1_code + 343, D_address)
poke4(sha_1_code + 349, D_address)
poke4(sha_1_code + 358, A_address)
poke4(sha_1_code + 369, E_address)
poke4(sha_1_code + 382, D_address)
poke4(sha_1_code + 388, E_address)
poke4(sha_1_code + 394, C_address)
poke4(sha_1_code + 400, D_address)
poke4(sha_1_code + 406, B_address)
poke4(sha_1_code + 415, C_address)
poke4(sha_1_code + 421, A_address)
poke4(sha_1_code + 427, B_address)
poke4(sha_1_code + 432, A_address)
poke4(sha_1_code + 441, w_address+240)
poke4(sha_1_code + 449, B_address)
poke4(sha_1_code + 455, C_address)
poke4(sha_1_code + 461, D_address)
poke4(sha_1_code + 466, A_address)
poke4(sha_1_code + 477, E_address)
poke4(sha_1_code + 490, D_address)
poke4(sha_1_code + 496, E_address)
poke4(sha_1_code + 502, C_address)
poke4(sha_1_code + 508, D_address)
poke4(sha_1_code + 514, B_address)
poke4(sha_1_code + 523, C_address)
poke4(sha_1_code + 529, A_address)
poke4(sha_1_code + 535, B_address)
poke4(sha_1_code + 540, A_address)
poke4(sha_1_code + 549, w_address+320)
poke4(sha_1_code + 556, h_address)
poke4(sha_1_code + 561, words_address)



constant c_H_words={#67452301,#EFCDAB89,#98BADCFE,#10325476,#C3D2E1F0}


function invert_word_end(sequence data)
    -- Inverts the order of the atoms inside each 4-atom block
    -- {1,2,3,4,5,6,7,8} becomes {4,3,2,1,8,7,6,5}

    atom a
    for temp=1 to length(data) by 4 do
	a=data[temp]
	data[temp]=data[temp+3]
	data[temp+3]=a
	a=data[temp+1]
	data[temp+1]=data[temp+2]
	data[temp+2]=a
    end for
    return data
end function


procedure process_block(sequence block)
    -- Updates the H words according to the contents of the block

    poke(w_address,invert_word_end(block))

    call(sha_1_code)             -- Call machine code routine

end procedure


function pad_message(sequence message)
    -- Add bytes to the end of the message so it can be divided
    -- in an exact number of 64-byte blocks.

    atom bytes_to_add
    bytes_to_add=64-remainder(length(message)+9,64)
    if bytes_to_add=64 then bytes_to_add=0 end if

    message=message&128&repeat(0,bytes_to_add)&
      {0,0,0,0}&rev_int_to_bytes(length(message)*8)

    return message
end function


global function sha_1(sequence message)
    -- Given a string, returns a 20-byte hash of it.

    poke4(h_address,c_H_words)      -- Write initial words in memory

    message=pad_message(message)    -- Add bytes to the message

    -- Process each 64-byte block
    for pos_in_message=1 to length(message) by 64 do
       process_block(message[pos_in_message..pos_in_message+63])
    end for

    -- Read hash from memory and invert the byte order
    return invert_word_end(peek({h_address,20}))

end function

