-- rand_cln.e - PRNG ('clean' version) - HIP 2.1
-- Copyright (C) 2001  Davi Tassinari de Figueiredo
--
-- This program is distributed under the terms of the GNU General
-- Public License. Please read the documentation for more information.
--
-- This file works the same as rand.e, but it does not use any
-- machine code routines, so it should be easier to understand and port.
--
-- The code in this file is based on arcf_old.e.

atom a,b
sequence state

a=1 b=1 state={}
constant numbers_per_call = 1024,
	 bytes_per_call = numbers_per_call * 4

procedure arcfour_init_encrypt(sequence key)
    -- Initialize the state array
    atom temp

    state=repeat(0,256)
    for pos=1 to length(state) do
	state[pos]=pos-1
    end for

    a=1     b=1

    for n=1 to 256 do
	b=and_bits(b+key[a]+state[n],#FF)
	if b=0 then b=256 end if

	-- Swap state[n] and state[b]
	temp=state[n]
	state[n]=state[b]
	state[b]=temp
	a=remainder(a,length(key))+1
    end for

    a=1     b=1

end procedure


constant byte_vals = {#1, #100, #10000, #1000000}

function arcfour_32bit_number ()
    atom index, number

    number = 0

    for byte=1 to 4 do
	a=and_bits(a,#FF)+1
	b=and_bits(b+state[a],#FF)
	if b=0 then b=256 end if

	-- Swap state[a] and state[b]
	index=state[a]
	state[a]=state[b]
	state[b]=index

	number = number +
	 state[and_bits(state[a]+state[b],#FF)+1] * byte_vals [byte]
    end for

    return number
end function

atom divisor
atom numbers_used
sequence numbers

procedure gen_random()
    -- Clean memory for writing the data
    numbers = repeat (-1, numbers_per_call)

    for n=1 to numbers_per_call do
	numbers[n] = remainder (arcfour_32bit_number(), divisor) + 1
    end for

    -- No numbers have been used yet
    numbers_used = 0
end procedure



global function random ()

    -- Have all of the computed numbers been used?
    -- If so, generate more numbers
    if numbers_used >= numbers_per_call then gen_random() end if

    -- One more number has been used
    numbers_used += 1

    return numbers [numbers_used]   -- Return number

end function

global procedure init_random (sequence key, atom max)
    atom junk

    -- Call initialization routine
    arcfour_init_encrypt (key)

    -- Set divisor
    divisor = max

    -- Force number generation on the first call to random()
    numbers_used = numbers_per_call


    -- Discard the first 256 numbers generated, further initializing the generator
    for n = 1 to 256 do
	junk = random()
    end for


end procedure


global function rand_bytes ()
    -- returns a sequence of bytes_per_call random bytes

    atom index, number
    sequence data

    data = repeat(-1, bytes_per_call)

    for byte=1 to length(data) do
	a=and_bits(a,#FF)+1
	b=and_bits(b+state[a],#FF)
	if b=0 then b=256 end if

	-- Swap state[a] and state[b]
	index=state[a]
	state[a]=state[b]
	state[b]=index

	-- store result
	data [byte] =
	 state[and_bits(state[a]+state[b],#FF)+1]
    end for

    -- return data
    return data

end function

