{
    This file is the source for a series of utility functions for dealing
    with strings.
    Copyright (C) 1998 by Phil Brutsche

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA  02111-1307  USA.
}

unit strs;

interface

uses crt;

type
  string15 = string [15];
  string20 = string [20];

function lowcase (character : char) : char;
function strlwr (str : string) : string;
function strdate (y, m, d, dow : word) : string20;
function numberCommas (number : longint) : string15;
function strupr (str : string) : string;
function trimspaces (str : string) : string;
function skipspaces (str : string) : string;
function countwords (str : string) : byte;
function getword (num : byte; str : string) : string;
function getstring (prompt : string) : string;
function spaces (numspaces : byte) : string;
function dectohex8 (decimal : longint) : string;
function dectohex16 (decimal : longint) : string;
function dectohex32 (decimal : longint) : string;
function numstr (number : longint) : string;
function strcommas (str : string) : string;

implementation

const
  space = #32;
  tab = #9;
  nul = #0;
  leftarrow = #75;
  rightarrow = #77;
  endkey = #79;
  home = #71;
  cr = #10;
  lf = #13;
  crlf = #10#13;
  backspace = #8;
  delkey = #83;
  prompt : string [2] = '% ';
  uparrow = #72;
  downarrow = #80;

function strcommas (str : string) : string;
var
  index : integer;
  temp : string;
  final : string;
  decimal : string;
begin
  final := '';
  decimal := '';
  index := pos ('.', str);
  if index <> 0 then begin
    decimal := copy (str, index, length (str) - index + 1);
    delete (str, index, length (str) - index + 1);
  end;
  index := length (str) - 2;
  repeat
    final := ',' + copy (str, index, 3) + final;
    if length (str) < 3 then
      str := ''
    else
      delete (str, index, 3);
    index := index - 3;
  until index < 0;
  if str = '' then
    delete (final, 1, 1)
  else
    final := str + final;
  strcommas := final + decimal;
end;

function numstr (number : longint) : string;
var
  temp : string [10];
begin
  str (number, temp);
  numstr := temp;
end;

function spaces (numspaces : byte) : string;
var
  rv : string;
  i : byte;
begin
  rv := '';
  for i := 1 to numspaces do
    rv := rv + ' ';
  spaces := rv;
end;

function lowcase (character : char) : char;
begin
  if character in ['A'..'Z'] then
    lowcase := chr (ord (character) + 32)
  else
    lowcase := character;
end;

function strlwr (str : string) : string;
var i : byte;
begin
  for i := 1 to length (str) do begin
    if str [i] in ['A'..'Z'] then begin
      str [i] := chr (ord (str [i]) + 32);
    end;
  end;
  strlwr := str;
end;

function strdate (y, m, d, dow : word) : string20;
var output : string [20];
    temp : string [4];
begin
  output := '';
  if dow <> 8 then begin
    case dow + 1 of
      1 : output := 'Sun';
      2 : output := 'Mon';
      3 : output := 'Tue';
      4 : output := 'Wed';
      5 : output := 'Thu';
      6 : output := 'Fri';
      7 : output := 'Sat';
    end;
    output := output + ' ';
  end;
  if m < 10 then
    output := output + '0';
  str (m, temp);
  output := output + temp + '/';
  if d < 10 then
    output := output + '0';
  str (d, temp);
  output := output + temp + '/';
  str (y, temp);
  output := output + temp;
  strdate := output;
end;

function numberCommas (number : longint) : string15;
var temp : longint;
    temp2, output : string15;
    addzero : boolean;
    temp3 : char;
begin
  output := '';
  temp := number div 1000000000;
  addzero := false;
  if temp <> 0 then begin
    str (temp, temp2);
    output := output + temp2 + ',';
    number := number mod 1000000000;
    addzero := true;
  end else begin
    if addzero then
      output := output + '000,';
  end;
  temp := number div 1000000;
  if temp <> 0 then begin
    str (temp, temp2);
    output := output + temp2 + ',';
    number := number mod 1000000;
    addzero := true;
  end else begin
    if addzero then
      output := output + '000,';
  end;
  temp := number div 1000;
  if temp <> 0 then begin
    str (temp, temp2);
    if (length (temp2) = 2) and (addzero) then
      temp2 := '0' + temp2;
    if (length (temp2) = 1) and (addzero) then
      temp2 := '00' + temp2;
    output := output + temp2 + ',';
    number := number mod 1000;
    addzero := true;
  end else begin
    if addzero then
      output := output + '000,';
  end;
  str (number, temp2);
  if (length (temp2) = 2) and (addzero) then
    temp2 := '0' + temp2;
  if (length (temp2) = 1) and (addzero) then
    temp2 := '00' + temp2;
  output := output + temp2;
  numberCommas := output;
end;

function strupr (str : string) : string;
var i : byte;
begin
  for i := 1 to length (str) do begin
    str [i] := upcase (str [i]);
  end;
  strupr := str;
end;

function trimspaces (str : string) : string;
var
  i : byte;
begin
  i := length (str);
  while (str [i] = #32) do begin
    delete (str, i, i);
    i := length (str);
  end;
  trimspaces := str;
end;

function skipspaces (str : string) : string;
var i : byte;
    found : boolean;
begin
  i := 1;
  found := false;
  while (str [i] = #32) do begin
    inc (i);
    if str [i] = #32 then found := true;
  end;
  if (str [1] = #32) and (str [2] <> #32) then begin
    delete (str, 1, 1);
    skipspaces := str;
  end else if found = false then begin
    skipspaces := str;
  end else begin
    delete (str, 1, i - 1);
    skipspaces := str;
  end;
end;

function countwords (str : string) : byte;
var
  result : string;
  totalwords, index : byte;
begin
  str := skipspaces (trimspaces (str));
  totalwords := 0;
  if str = '' then begin
    countwords := 0;
    exit;
  end;
  index := pos (' ', str);
  repeat
    result := copy (str, 1, index - 1);
    delete (str, 1, index);
    inc (totalwords);
    str := skipspaces (str);
    index := pos (' ', str);
  until result = '';
  countwords := totalwords;
end;

function getword (num : byte; str : string) : string;
var
  result : string;
  i, index : byte;
  temp : char;
begin
  str := skipspaces (trimspaces (str));
  for i := 1 to num do begin
    index := pos (' ', str);
    if index = 0 then begin
      index := length (str);
    end;
    result := copy (str, 1, index);
    delete (str, 1, index);
    str := skipspaces (str);
  end;
  getword := skipspaces (trimspaces (result));
end;

function getstring (prompt : string) : string;
var
  character : char;
  commandline : string [128];
  i, index : byte;

begin
  commandline := '';
  index := 0;
  write (prompt, commandline);
  repeat
    character := readkey;
    if character = nul then begin
      character := readkey;
      case character of
        leftarrow : begin
          if index <> 0 then begin
            dec (index);
            write (lf);
            clreol;
            write (prompt, commandline, lf, prompt);
            for i := 1 to index do
              write (commandline [i]);
          end;
        end;
        rightarrow : begin
          if index <> length (commandline) then begin
            inc (index);
            write (lf);
            clreol;
            write (prompt, commandline, lf, prompt);
            for i := 1 to index do
              write (commandline [i]);
          end;
        end;
        delkey : begin
          inc (index);
          delete (commandline, index, 1);
          dec (index);
        end;
        home : begin
          index := 0;
          write (lf);
          clreol;
          write (prompt, commandline, lf, prompt);
        end;
        endkey : begin
          index := length (commandline);
          write (lf);
          clreol;
          write (prompt, commandline);
        end;
      end
    end else begin
      if character = backspace then begin
        if index <> 0 then begin
          delete (commandline, index, 1);
          dec (index);
        end
      end else if character <> lf then begin
        inc (index);
        insert (character, commandline, index);
      end;
    end;
    write (lf);
    clreol;
    write (prompt, commandline, lf, prompt);
    for i := 1 to index do
      write (commandline [i]);
  until character = lf;
  getstring := commandline;
end;

function dectohex8 (decimal : longint) : string;
var
  rv : string [2];
  temp, i, shiftval: byte;
  place : word;
  hex_val : char;
begin
  place := $f0;
  shiftval := 4;
  rv := '';
  for i := 1 to 2 do begin
    temp := (decimal and place) shr shiftval;
    place := place shr 4;
    shiftval := shiftval - 4;
    case temp of
       0 : hex_val := '0';
       1 : hex_val := '1';
       2 : hex_val := '2';
       3 : hex_val := '3';
       4 : hex_val := '4';
       5 : hex_val := '5';
       6 : hex_val := '6';
       7 : hex_val := '7';
       8 : hex_val := '8';
       9 : hex_val := '9';
      10 : hex_val := 'A';
      11 : hex_val := 'B';
      12 : hex_val := 'C';
      13 : hex_val := 'D';
      14 : hex_val := 'E';
      15 : hex_val := 'F';
    end;
    rv := rv + hex_val;
  end;
  dectohex8 := rv;
end;

function dectohex16 (decimal : longint) : string;
var
  rv : string [4];
  temp, i, shiftval : integer;
  place : word;
  hex_val : char;
begin
  place := $f000;
  shiftval := 12;
  rv := '';
  for i := 1 to 4 do begin
    temp := (decimal and place) shr shiftval;
    place := place shr 4;
    shiftval := shiftval - 4;
    case temp of
       0 : hex_val := '0';
       1 : hex_val := '1';
       2 : hex_val := '2';
       3 : hex_val := '3';
       4 : hex_val := '4';
       5 : hex_val := '5';
       6 : hex_val := '6';
       7 : hex_val := '7';
       8 : hex_val := '8';
       9 : hex_val := '9';
      10 : hex_val := 'A';
      11 : hex_val := 'B';
      12 : hex_val := 'C';
      13 : hex_val := 'D';
      14 : hex_val := 'E';
      15 : hex_val := 'F';
    end;
    rv := rv + hex_val;
  end;
  dectohex16 := rv;
end;

function dectohex32 (decimal : longint) : string;
var
  rv : string [8];
  temp, i, shiftval : integer;
  place : longint;
  hex_val : char;
begin
  place := $f0000000;
  shiftval := 28;
  rv := '';
  for i := 1 to 8 do begin
    temp := (decimal and place) shr shiftval;
    place := place shr 4;
    shiftval := shiftval - 4;
    case temp of
       0 : hex_val := '0';
       1 : hex_val := '1';
       2 : hex_val := '2';
       3 : hex_val := '3';
       4 : hex_val := '4';
       5 : hex_val := '5';
       6 : hex_val := '6';
       7 : hex_val := '7';
       8 : hex_val := '8';
       9 : hex_val := '9';
      10 : hex_val := 'A';
      11 : hex_val := 'B';
      12 : hex_val := 'C';
      13 : hex_val := 'D';
      14 : hex_val := 'E';
      15 : hex_val := 'F';
    end;
    rv := rv + hex_val;
  end;
  dectohex32 := rv;
end;

begin
  writeln ('STRS.TPU initializing...Done');
end.
