{
    This file is the source for a series of routines to ease the probing of
    the MCA bus found on IBM PS/2s.
    Copyright (C) 1998 by Phil Brutsche

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA  02111-1307  USA.
}

unit mca;

interface

function mca_resolve_desc (device : word) : string;
function mca_count_devices : byte;
function mca_probe_slot (slot : byte) : word;

implementation

uses dos, crt, strs;

type
  string127 = string [127];
  string4 = string [4];
  string80 = string [80];

var
  dir : dirstr;
  name : ^namestr;
  ext : ^extstr;

function mca_count_devices : byte;
var
  i : byte;
  count : byte;
begin
  port [$94] := $ff;
  i := 0;
  count := 0;
  for i := 0 to 7 do begin
    port [$96] := $08 + i;
    if portw [$100] <> $ffff then
      inc (count);
    inc (i);
  end;
  mca_count_devices := count;
  port [$96] := $00;
  port [$94] := $00;
end;

function mca_probe_slot (slot : byte) : word;
begin
  port [$94] := $ff;
  port [$96] := $08 + slot;
  mca_probe_slot := portw [$100];
  port [$96] := $00;
  port [$94] := $00;
end;

function mca_resolve_desc (device : word) : string;
var
  mca_desc_file : text;
  input_line : string127;
  device_number : string4;
  device_name : string80;
  found : boolean;
  i : word;
begin
  assign (mca_desc_file, dir + 'mca.dat');
  {$I-}reset (mca_desc_file);{$I+}
  if ioresult <> 0 then begin
    mca_resolve_desc := '???';
    exit;
  end;
  i := 0;
  repeat
    i := i + 1;
    readln (mca_desc_file, input_line);
    {device_number := getword (1, input_line);}
    device_number := copy (input_line, 1, 4);
    device_name := copy (input_line, 6, length (input_line) - 5);
  until (strupr (device_number) = 'FFFF') or
        (strupr (dectohex16 (device)) = strupr (device_number));
  if strupr (device_number) = 'FFFF' then
    mca_resolve_desc := '???'
  else
    mca_resolve_desc := device_name;
end;

begin
  new (name);
  new (ext);
  fsplit (paramstr (0), dir, name^, ext^);
  dispose (name);
  dispose (ext);
end.
