DEFINT A-Z
REM $DYNAMIC

TYPE trackinfo
 cmd AS STRING * 1
 track AS STRING * 1
 tframe AS STRING * 1
 tsec AS STRING * 1
 tmin AS STRING * 1
 dummy AS STRING * 1
 control AS STRING * 1
 absframe AS LONG
END TYPE

TYPE cdInfoTYPE
 status AS INTEGER      ' status of the driver
 track AS INTEGER       ' current track number
 frame AS LONG          ' current absolute frame number
 cdMin AS INTEGER       ' cd position (minutes)
 cdSec AS INTEGER       ' cd position (seconds)
 cdFrame AS INTEGER     ' cd position (frames)
 TrackMin AS INTEGER    ' track position (mins)
 TrackSec AS INTEGER    ' track position (seconds)
 TrackFrame AS INTEGER  ' track position (frames)
 cdMins AS INTEGER      ' cd length (mins)
 cdSecs AS INTEGER      ' cd length (seconds)
 cdFrames AS INTEGER    ' cd length (frames)
 TrackMins AS INTEGER   ' track length (mins)
 TrackSecs AS INTEGER   ' track length (seconds)
 TrackFrames AS INTEGER ' track length (frames)
END TYPE

TYPE RegType
 ax AS INTEGER
 bx AS INTEGER
 cx AS INTEGER
 dx AS INTEGER
 bp AS INTEGER
 si AS INTEGER
 di AS INTEGER
 flags AS INTEGER
END TYPE

'--- DSE Audio library subs and functions
DECLARE SUB cdGetInfo (BYVAL drive%, BYVAL track%, cd AS cdInfoTYPE, tracklist() AS trackinfo)
DECLARE SUB cdDoor (BYVAL drive%, BYVAL cmd%)
DECLARE SUB cdPause (BYVAL drive%)
DECLARE SUB cdPlayFrames (BYVAL drive%, BYVAL frame&, BYVAL lframe&)
DECLARE SUB cdPlayMSF (BYVAL drive%, BYVAL mins%, BYVAL secs%, BYVAL frame%, BYVAL lmin%, BYVAL lsec%, BYVAL lframe%)
DECLARE SUB cdPlay (BYVAL drive%, BYVAL track%, BYVAL tracks%, tracklist() AS trackinfo)
DECLARE SUB cdInit (BYVAL drive%, tracklist() AS trackinfo)
DECLARE SUB cdReset (BYVAL drive%)
DECLARE SUB cdResume (BYVAL drive%)
DECLARE SUB cdSeek (BYVAL drive%, BYVAL track%, tracklist() AS trackinfo)
DECLARE SUB cdSeekFrame (BYVAL drive%, BYVAL frame&)
DECLARE SUB cdSeekMSF (BYVAL drive%, BYVAL mins%, BYVAL secs%, BYVAL frame%)
DECLARE SUB cdStop (BYVAL drive%)
DECLARE SUB cdGetVolume (BYVAL source%, left1%, right1%, left2%, right2%)
DECLARE SUB cdSetVolume (BYVAL source%, BYVAL left1%, BYVAL right1%, BYVAL left2%, BYVAL right2%)
DECLARE SUB sbGetVolume (BYVAL source%, leftV%, rightV%)
DECLARE SUB sbSetVolume (BYVAL source%, BYVAL leftV%, BYVAL rightV%)
DECLARE SUB FrameToMSF (BYVAL frame&, mins%, secs%, frames%)
DECLARE FUNCTION cdMediaChanged% (BYVAL drive%)
DECLARE FUNCTION cdStatus% (BYVAL drive%)
DECLARE FUNCTION GetFirstCdrom% ()
DECLARE FUNCTION GetMscdexVersion% ()
DECLARE FUNCTION GetNumCdroms% ()
DECLARE FUNCTION IsAudio% (BYVAL drive%)
DECLARE FUNCTION IsMscdex% ()
DECLARE FUNCTION IsSB% ()
DECLARE FUNCTION MSFtoFrame& (BYVAL mins%, BYVAL secs%, BYVAL frame%)

'----- My Subs and functions
DECLARE SUB INTERRUPT (IntNo AS INTEGER, InRegs AS RegType, OutRegs AS RegType)
DECLARE SUB Author (Ver$)
DECLARE SUB BPrat (Row%, Col%, Wid%, H%, A$)
DECLARE SUB Calc ()
DECLARE SUB Calendar (K%)
DECLARE SUB ClrWin (A$)
DECLARE SUB ConfigText ()
DECLARE SUB CPrat (Row, Col, A$)
DECLARE SUB DispTime ()
DECLARE SUB EditLyrics ()
DECLARE SUB FontEd (K%)
DECLARE SUB Freq (BRow%, Bar1%, Bar2%, BWid%, NumS%)
DECLARE SUB Help ()
DECLARE SUB LoadConfig (F$)
DECLARE SUB MakeAlbum ()
DECLARE SUB MouseInfo (Row, Col, MB)
DECLARE SUB NoButtons ()
DECLARE SUB Prat (Row, Col, A$)
DECLARE SUB ReadFont (F$)
DECLARE SUB SaveFont (F$)
DECLARE SUB SaveLyrics (F$)
DECLARE SUB SaveConfig (F$)
DECLARE SUB Scope (Delay%)
DECLARE SUB ShowEPage ()
DECLARE SUB ShowStatus ()
DECLARE SUB SyncHelp ()
DECLARE SUB SyncLyrics ()
DECLARE SUB Utils ()
DECLARE SUB VUMeter (Row)

DECLARE FUNCTION Day$ (TD$)
DECLARE FUNCTION Dec& (H$)
DECLARE FUNCTION DoJoy ()
DECLARE FUNCTION Exists (A$)
DECLARE FUNCTION GetSKey$ (A$)
DECLARE FUNCTION GetYN$ ()
DECLARE FUNCTION Mouse (N)
DECLARE FUNCTION Msg$ (A%)
DECLARE FUNCTION ShowErr$ ()
DECLARE FUNCTION SuppIn$ (Row, Col, Max, P$, W$)
DECLARE FUNCTION TimeStr$ (BYVAL mins, BYVAL secs)
DECLARE FUNCTION Trim$ (A$)
DECLARE FUNCTION Words$ (A$)

CONST CDINSTALLED% = &H1
CONST CDPLAYING% = &H2
CONST CDPAUSED% = &H4
CONST CDOPEN% = &H8
CONST CDLOCKED% = &H10
CONST FALSE = 0, TRUE = NOT FALSE

COMMON SHARED InRegs AS RegType, OutRegs AS RegType
COMMON SHARED Font$(), FontP(), FontW(), Lyric$(), Sync&(), Song$()
COMMON SHARED Config(), Cfg$(), cdu AS INTEGER
COMMON SHARED tlist()  AS trackinfo, cd AS cdInfoTYPE
COMMON SHARED FontH, MaxChr, LF1$, LF2$, SP$, CR$, ESC$, Nul$, CF$, ESCS$, BCKSPC$
COMMON SHARED WTop, WH, TMode, Full, ITop, IDnum$, Ref, FPS, DD$, DL$
COMMON SHARED TotF&, StartF&, EFrame&, NumF&, track, Spin
COMMON SHARED LyricTrack%, MaxLyric, LyricLines, NoSync&, PMode, PStp
COMMON SHARED Mode, LastMd, LastTop, LastT, NumT, BFlag, MFlag, BTop, BBot, Top
COMMON SHARED FC!(), FB!(), SBBase, WPort, RPort, Ptr$, SPtr$, AlbumF
COMMON SHARED CfgName$, Editor$, Joy$, Path$, SongName$, CDTitle$

DIM SHARED Font$(16), FontP%(224), FontW%(224), Lyric$(500), Sync&(500), Song$(100)
DIM SHARED Config(16), Cfg$(16), CRange(16, 1)
DIM SHARED tlist(0) AS trackinfo
DIM SHARED FC!(255), FB!(255)

