//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2013 by PDSoft (Attila Padar)                *
//*                http://mpxplay.sourceforge.net                          *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function:jukebox

#include "mpxplay.h"
#include "display\display.h"

extern unsigned int refdisp,playcontrol,playrand;

void playlist_jukebox_add_entry(struct mainvars *mvp,struct playlist_side_info *psi_src)
{
 struct playlist_side_info *psi_dest=psi_src->psio;
 if((psi_src->editloadtype&PLL_JUKEBOX) || !(psi_dest->editloadtype&PLL_JUKEBOX))
  return;
 if((mvp->newsong>=psi_src->firstsong) && (mvp->newsong<=psi_src->lastentry)){ // if the doomlist-side and the newsong-side match (they don't match at album-skip)
  unsigned int sideused=psi_dest->editsidetype&PLT_ENABLED;
  playlist_editlist_addfile_one(psi_src,psi_dest,mvp->newsong,NULL,EDITLIST_MODE_ALL);
  if(!sideused && !(playcontrol&PLAYC_RUNNING)){
   /*if(playcontrol&PLAYC_RUNNING){
    if(pds_strcmp(mvp->pei0->filename,mvp->newsong->filename)==0) // hack
     mvp->aktfilenum--;            // (else it's deleted at jukebox_skip)
    mvp->adone=ADONE_RESTART;
   }else*/
    playlist_start_sideplay(mvp,psi_dest);
  }else
   refdisp|=RDT_BROWSER|RDT_EDITOR;
  mvp->newsong=NULL;
 }
}

unsigned int playlist_jukebox_skip(struct mainvars *mvp)
{
 struct playlist_side_info *psi=mvp->psip;
 struct playlist_entry_info *peiakt,*peinew;
 unsigned int retcode=1;

 if(mvp->direction==0)
  mvp->direction=1;

 if(psi->firstentry && (psi->lastentry>=psi->firstentry)){
  if(mvp->aktfilenum>=psi->firstentry){
   if(mvp->aktfilenum>psi->lastentry)
    mvp->aktfilenum=psi->lastentry;
   peinew=mvp->newfilenum;
   peiakt=mvp->aktfilenum;
   if(peiakt!=peinew){ // do not delete if newfilenum==aktfilenum
    if(peiakt->entrytype<DFT_AUDIOFILE)
     peiakt->entrytype=DFT_UNKNOWN;              // else delfile will not delete HFT_DFT
    playlist_editlist_delfile_one(psi,peiakt,EDITLIST_MODE_ALL);
    if(playrand && !peinew)
     mvp->newfilenum=NULL;
   }
  }

  playlist_skip(mvp);

  if(mvp->aktfilenum>psi->lastentry)
   mvp->aktfilenum=psi->lastentry;
  if(mvp->aktfilenum<psi->firstentry)
   mvp->aktfilenum=psi->firstentry;
 }
 if(!psi->firstentry || (psi->lastentry<psi->firstentry))
  retcode=0;

 return retcode;
}
