//**************************************************************************
//*                     This file is part of the                           *
//*                MMC - Mpxplay Multimedia Commander                      *
//*                   The source code of MMC is                            *
//*        (C) copyright 1998-2020 by PDSoft (Attila Padar)                *
//*                http://mpxplay.sourceforge.net                          *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: video render QWdiget/QPaint

//#define MPXPLAY_USE_DEBUGF 1
#define DISPQT_DEBUG_OUTPUT stdout

#include "moc_config.h"

#if MPXPLAY_DISPQT_ENABLE_RENDER_QPAINT

#include "moc_video_qt.h"
#include "moc_mainwindow.h"

MMCDispQtVideoRendererQPaint::MMCDispQtVideoRendererQPaint(MainWindow *mainwindow, QWidget *parent) : MMCDispQtVideoRendererBase(mainwindow, parent)
{
	mpxplay_video_render_infos.hwdevice_avpixfmt = AV_PIX_FMT_NONE;
}

void MMCDispQtVideoRendererQPaint::videorenderer_videoframe_render(QPainter *p, struct dispqt_video_surface_info_s *video_surface_infos, ffmpegvideo_subtitle_info_s *subtitle_infos)
{
	if(video_surface_infos->videoout_surface_clearpic || !video_surface_infos->ffmpeg_output_frame)
	{
		video_surface_infos->videoout_surface_clearpic = false; // cleared here, because sometimes QWidget rendering is delayed (called update, not repaint)
		p->fillRect(0, 0, video_surface_infos->window_size_x, video_surface_infos->window_size_y, Qt::black);
		mpxplay_debugf(DISPQT_DEBUG_OUTPUT, "paintEvent CLEARPIC");
	}
	if(video_surface_infos->ffmpeg_output_frame)
	{
		p->setRenderHint(QPainter::SmoothPixmapTransform, true);

		QImage image(video_surface_infos->ffmpeg_output_frame->data[0], video_surface_infos->ffmpeg_output_frame->width, video_surface_infos->ffmpeg_output_frame->height,
				video_surface_infos->ffmpeg_output_frame->linesize[0], DISPQT_VIDEO_QIMAGE_OUTPUT_QFORMAT);
		p->drawImage(QRectF(video_surface_infos->sws_dst_pos_x, video_surface_infos->sws_dst_pos_y, video_surface_infos->sws_dst_width, video_surface_infos->sws_dst_height), image,
				QRectF(video_surface_infos->sws_crop_x, video_surface_infos->sws_crop_y, video_surface_infos->sws_crop_w, video_surface_infos->sws_crop_h),
				Qt::NoFormatConversion);
	}

	this->renderbase_subtitle_qpaint(video_surface_infos, subtitle_infos, p, DISPQT_RENDERBASE_SUBTITLE_CTRLFLAG_FULLSCREEN | DISPQT_RENDERBASE_SUBTITLE_CTRLFLAG_DRAWEVERY | DISPQT_RENDERBASE_SUBTITLE_CTRLFLAG_CLEARBORDERS);
}

void MMCDispQtVideoRendererQPaint::videorenderer_get_surface_attribs(struct dispqt_video_surface_info_s *video_surface_infos, AVFrame *decoded_frame)
{
	video_surface_infos->videoout_surface_pix_fmt = DISPQT_VIDEO_QIMAGE_OUTPUT_AVFORMAT;
	video_surface_infos->video_render_infos->renderer_capabilities = DISPQT_VIDEORENDERER_CAPFLAG_WIDGET;
}

#endif // MPXPLAY_DISPQT_ENABLE_RENDER_QPAINT
