//**************************************************************************
//*                     This file is part of the                           *
//*                MMC - Mpxplay Multimedia Commander                      *
//*                   The source code of MMC is                            *
//*        (C) copyright 1998-2020 by PDSoft (Attila Padar)                *
//*                http://mpxplay.sourceforge.net                          *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY{} without even the implied warranty of       *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function:

#ifndef moc_config_h
#define moc_config_h

#include <QtWidgets>
#include <QDialog>
#include <QString>
#include "disp_qt.h"
#include "moc_dialog_elems.h"

QT_BEGIN_NAMESPACE
class MainWindow;
QT_END_NAMESPACE

#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
#include <libavfilter/version.h>
#define MPXPLAY_DISPQT_ENABLE_RENDER_QPAINT  1
#define MPXPLAY_DISPQT_ENABLE_RENDER_VULKAN  1
//#ifdef MPXPLAY_WIN32
 #define MPXPLAY_DISPQT_ENABLE_RENDER_D3D11   1
 #define MPXPLAY_DISPQT_ENABLE_RENDER_D3D9    1
 #define MPXPLAY_DISPQT_ENABLE_RENDER_GDI     0
//#endif // MPXPLAY_WIN32
#endif // MPXPLAY_LINK_ORIGINAL_FFMPEG
#define MPXPLAY_DISPQT_ENABLE_OPENCL 0 // replaced with D3D11

#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
#define DISPQT_MMC_VERSION_STRING "3.22"
#else
#define DISPQT_MMC_VERSION_STRING "2.22"
#endif

#define DISPQT_MAINWIN_INITSIZE_X 400
#define DISPQT_MAINWIN_INITSIZE_Y 550

enum dispqt_gui_layout_ids {
	DISPQT_GUILAYOUT_OSDEF_CLASSIC,    // operating system's classic layout without any effect or colorization
	DISPQT_GUILAYOUT_BLUE_CLASSIC,     // operating system's classic layout with blue gui elems
	DISPQT_GUILAYOUT_CLASSIC_MAX,
	DISPQT_GUILAYOUT_TRANSPARENT_TYPE = 128,
	DISPQT_GUILAYOUT_BLUE_TRANSPARENT = DISPQT_GUILAYOUT_TRANSPARENT_TYPE, // transparent/translucent windows with blue gui elems
	DISPQT_GUILAYOUT_MAX
};

enum dispqt_gui_background_types {
	DISPQT_GUIBKGTYPE_BLUR,
	DISPQT_GUIBKGTYPE_TRANSPARENT,
	DISPQT_GUIBKGTYPE_OPAQUE,
	DISPQT_GUIBKGTYPE_MAX
};

enum dispqt_gui_background_transparent_effects {
	DISPQT_GUIBKGEFCT_NONE,
	DISPQT_GUIBKGEFCT_COLORIZED,
	DISPQT_GUIBKGEFCT_GLASS_PNG,
	DISPQT_GUIBKGEFCT_MAX
};

//#define DISPQT_COLORTEXTID_CONFIGURE_TEXTCOLORS 1 // TODO: text colors are currently hard-coded into style-sheets

enum dispt_colortext_window_ids {
	DISPQT_COLORTEXTID_WINDOW_BASE,
	DISPQT_COLORTEXTID_WINDOW_TRANSPARENT,
#ifdef DISPQT_COLORTEXTID_CONFIGURE_TEXTCOLORS
	DISPQT_COLORTEXTID_WINDOW_TEXT_BASE,
	DISPQT_COLORTEXTID_WINDOW_TEXT_TRANSP,
#endif
	DISPQT_COLORTEXTID_WINDOW_MAX
};

enum dispt_colortext_editor_ids {
	DISPQT_COLORTEXTID_EDITOR_FONT,
	DISPQT_COLORTEXTID_EDITOR_BACK1,
	DISPQT_COLORTEXTID_EDITOR_BACK2,
	DISPQT_COLORTEXTID_EDITOR_CURSOR,
	DISPQT_COLORTEXTID_EDITOR_MARK,
	DISPQT_COLORTEXTID_EDITOR_CURRSONG,
	DISPQT_COLORTEXTID_EDITOR_NEXTSONG,
	DISPQT_COLORTEXTID_EDITOR_PLAYED,
	DISPQT_COLORTEXTID_EDITOR_NOTPLAYED,
	DISPQT_COLORTEXTID_EDITOR_MAX
};

enum dispt_fonttext_ids {
	DISPQT_FONTTEXTID_EDITOR,
	DISPQT_FONTTEXTID_MAINWIN,
	DISPQT_FONTTEXTID_DIALOG,
	DISPQT_FONTTEXTID_SUBTITLE,
	DISPQT_FONTTEXTID_MAX
};

enum dispqt_video_renderer_types {
	DISPQT_VIDEORENDERTYPE_QPAINT = 0,
#if MPXPLAY_DISPQT_ENABLE_RENDER_D3D11
	DISPQT_VIDEORENDERTYPE_D3D11 = 1,
#endif
#if MPXPLAY_DISPQT_ENABLE_RENDER_D3D9
	DISPQT_VIDEORENDERTYPE_D3D9 = 2,
#endif
#if MPXPLAY_DISPQT_ENABLE_RENDER_VULKAN
	DISPQT_VIDEORENDERTYPE_VULKAN = 3,
#endif
#if MPXPLAY_DISPQT_ENABLE_RENDER_GDI
	DISPQT_VIDEORENDERTYPE_GDI = 4,
#endif
	DISPQT_VIDEORENDERTYPE_MAX
};

enum dispqt_video_fullscreen_ar_types {
	DISPQT_VIDEOFULLSCREENARTYPE_NONE = 0,
	DISPQT_VIDEOFULLSCREENARTYPE_FIRST = 1,
	DISPQT_VIDEOFULLSCREENARTYPE_VIDEO = 1,
	DISPQT_VIDEOFULLSCREENARTYPE_FILL = 2,
	DISPQT_VIDEOFULLSCREENARTYPE_4_3 = 3,
	DISPQT_VIDEOFULLSCREENARTYPE_16_9 = 4,
	DISPQT_VIDEOFULLSCREENARTYPE_235_1 = 5,
	DISPQT_VIDEOFULLSCREENARTYPE_1_1 = 6,
	DISPQT_VIDEOFULLSCREENARTYPE_CUSTOM = 7,
	DISPQT_VIDEOFULLSCREENARTYPE_PIXEL = 8,
	DISPQT_VIDEOFULLSCREENARTYPE_MAX
};

enum dispqt_video_windowed_ar_types {
	DISPQT_VIDEOWINDOWEDARTYPE_EQFULLSCREEN = 0,
	DISPQT_VIDEOWINDOWEDARTYPE_VIDEO = DISPQT_VIDEOFULLSCREENARTYPE_VIDEO, // 1 (shall match)
	DISPQT_VIDEOWINDOWEDARTYPE_FILL = DISPQT_VIDEOFULLSCREENARTYPE_FILL,   // 2 (shall match)
	DISPQT_VIDEOWINDOWEDARTYPE_MAX
};

enum dispqt_video_source_crop_types {
	DISPQT_VIDEOSCRCROPTYPE_NONE = 0,
	DISPQT_VIDEOSCRCROPTYPE_AUTO = 1,
	DISPQT_VIDEOSCRCROPTYPE_4_3 = 2,
	DISPQT_VIDEOSCRCROPTYPE_16_9 = 3,
	DISPQT_VIDEOSCRCROPTYPE_235_1 = 4,
	DISPQT_VIDEOSCRCROPTYPE_CUSTOM = 5,
	DISPQT_VIDEOSCRCROPTYPE_MAX
};

enum dispqt_video_fullscreen_zoom_types {
	DISPQT_VIDEOFULLSCREENZOOMTYPE_TOUCHINSIDE = 0,
	DISPQT_VIDEOFULLSCREENZOOMTYPE_TOUCHOUTSIDE = 1,
	DISPQT_VIDEOFULLSCREENZOOMTYPE_1_1 = 2,
	DISPQT_VIDEOFULLSCREENZOOMTYPE_2_1 = 3,
	DISPQT_VIDEOFULLSCREENZOOMTYPE_4_1 = 4,
	DISPQT_VIDEOFULLSCREENZOOMTYPE_CUSTOM = 5,
	DISPQT_VIDEOFULLSCREENZOOMTYPE_SETTINGS = DISPQT_VIDEOFULLSCREENZOOMTYPE_CUSTOM,
	DISPQT_VIDEOFULLSCREENZOOMTYPE_ZOOMIN = 6,  // for menu event only
	DISPQT_VIDEOFULLSCREENZOOMTYPE_ZOOMOUT = 7, //
	DISPQT_VIDEOFULLSCREENZOOMTYPE_MENUACTIONS = DISPQT_VIDEOFULLSCREENZOOMTYPE_ZOOMOUT,
	DISPQT_VIDEOFULLSCREENZOOMTYPE_MANUAL = 8,  // controlled with mouse wheel only
	DISPQT_VIDEOFULLSCREENZOOMTYPE_MAX
};

enum dispqt_video_deinterlace_types {
	DISPQT_VIDEO_DEINTERLACETYPE_AUTO = 0,  // aka setting comes from the decoder
	DISPQT_VIDEO_DEINTERLACETYPE_DISABLE,
	DISPQT_VIDEO_DEINTERLACETYPE_ENABLE,
	DISPQT_VIDEO_DEINTERLACETYPE_MAX
};

enum dispqt_video_rotation_types {
	DISPQT_VIDEO_ROTATIONTYPE_AUTO = 0,   // comes from the decoder (exif)
	DISPQT_VIDEO_ROTATIONTYPE_ROT000 = 1, // rotation is disabled
	DISPQT_VIDEO_ROTATIONTYPE_ROTL90 = 2, // rotate left 90 (rotate right 270) degrees
	DISPQT_VIDEO_ROTATIONTYPE_ROTR90 = 3, // rotate right 90 degreees
	DISPQT_VIDEO_ROTATIONTYPE_ROT180 = 4, // rotate 180 degrees
	DISPQT_VIDEO_ROTATIONTYPE_MAX
};

enum dispqt_video_mixer_types {
	DISPQT_VIDEO_VMIXERTYPE_BRIGHTNESS = 0,
	DISPQT_VIDEO_VMIXERTYPE_CONTRAST,
	DISPQT_VIDEO_VMIXERTYPE_SATURATION,
	DISPQT_VIDEO_VMIXERTYPE_HUE,
	DISPQT_VIDEO_VMIXERTYPE_MAX
};

enum dispqt_audiovisualization_types {
	DISPQT_AUDIOVISUALIZATIONTYPE_NONE = 0,
	DISPQT_AUDIOVISUALIZATIONTYPE_AVECTORSCOPE, // FFmpeg audio visualizations
	DISPQT_AUDIOVISUALIZATIONTYPE_SHOWFREQS,
	DISPQT_AUDIOVISUALIZATIONTYPE_SHOWCQT,
	DISPQT_AUDIOVISUALIZATIONTYPE_SHOWSPECTRUM,
	DISPQT_AUDIOVISUALIZATIONTYPE_SHOWWAVES,
	DISPQT_AUDIOVISUALIZATIONTYPE_MAX
};

#ifdef MPXPLAY_WIN32
 #define DISPQT_CONFIG_VIDEORENDERTYPE_DEFAULT DISPQT_VIDEORENDERTYPE_D3D11
 #define DISPQT_CONFIG_VIDEORENDERTYPE_DEF_XP  DISPQT_VIDEORENDERTYPE_QPAINT
#else
 #define DISPQT_CONFIG_VIDEORENDERTYPE_DEFAULT DISPQT_VIDEORENDERTYPE_QPAINT
 #define DISPQT_CONFIG_VIDEORENDERTYPE_DEF_XP DISPQT_VIDEORENDERTYPE_QPAINT
#endif

#define DISPQT_CONFIG_VIDEOFULLSCREENARTYPE_DEFAULT  DISPQT_VIDEOFULLSCREENARTYPE_VIDEO
#define DISPQT_CONFIG_VIDEOWINDOWEDARTYPE_DEFAULT    DISPQT_VIDEOWINDOWEDARTYPE_EQFULLSCREEN
#define DISPQT_CONFIG_VIDEOSRCCROPTYPE_DEFAULT       DISPQT_VIDEOSCRCROPTYPE_NONE
#define DISPQT_CONFIG_VIDEOZOOMTYPE_DEFAULT          DISPQT_VIDEOFULLSCREENZOOMTYPE_TOUCHINSIDE
#define DISPQT_CONFIG_AUDIOVISUALIZATIONTYPE_DEFAULT DISPQT_AUDIOVISUALIZATIONTYPE_SHOWCQT

#define DISPQT_CONFIG_VIDEO_AUTOCROP_SKIPDELAY       1  // in frames  (duration between the checkings, if crop detect was failed last time)
#define DISPQT_CONFIG_VIDEO_AUTOCROP_SHORTDELAY      2  // in frames  (duration between the checkings, if crop was modified last time)
#define DISPQT_CONFIG_VIDEO_AUTOCROP_LONGDELAY      25  // in frames  (duration between the checkings, if crop was NOT modified last time)
#define DISPQT_CONFIG_VIDEO_AUTOCROP_CHECK_RANGE    25  // in percent (range of the checking on one side (left/right/top/bottom), if one of the checking fails, then skip crop)
#define DISPQT_CONFIG_VIDEO_AUTOCROP_MAX_SIDE_DIFF  10  // in percent of width/height (max crop difference between the sides (left/right, top/bottom), else skip crop)
#define DISPQT_CONFIG_VIDEO_AUTOCROP_SKIP_BORDER     6  // don't check this area (may contain some garbage lines / draws)
#define DISPQT_CONFIG_VIDEO_AUTOCROP_SENSITIVITY     6  // in pixels (don't modify crop, if change is less)
#define DISPQT_CONFIG_VIDEO_AUTOCROP_STEP            1  // in pixels (modify crop in this step)

#define DISPQT_CONFIG_VIDEOAR_DIVISORCHAR ':'
#define DISPQT_CONFIG_VIDEOARCUSTOM_DEFAULTSTR   "5:4"
#define DISPQT_CONFIG_VIDEOCROPCUSTOM_DEFAULTSTR "5:4"
#define DISPQT_CONFIG_VIDEOZOOMCUSTOM_DEFAULTSTR "10:1"

#define DISPQT_CONFIG_SCREEN_SELECT_AUTO -1

#define DISPQT_CONFIG_VIDEOZOOM_SCALE   10000  // TODO: means max 8K resolution support
#define DISPQT_CONFIG_VIDEOZOOM_MIN     10000
#define DISPQT_CONFIG_VIDEOZOOM_CENTER  10000
#define DISPQT_CONFIG_VIDEOZOOM_MAX    100000
#define DISPQT_CONFIG_VIDEOZOOM_STEP     1000

#define DISPQT_VMIXER_VALUE_MIN      ((int)-100)
#define DISPQT_VMIXER_VALUE_CENTER   ((int)0)
#define DISPQT_VMIXER_VALUE_MAX      ((int)100)

// mainwin_control
#define DISPQT_CONFIG_MAINWINCTRL_HIDE_MENU            (1<< 0)
#define DISPQT_CONFIG_MAINWINCTRL_SHOW_VIDEO           (1<< 2)
#define DISPQT_CONFIG_MAINWINCTRL_SHOW_SEEKBAR         (1<< 4)
#define DISPQT_CONFIG_MAINWINCTRL_SHOW_TOOLBAR         (1<< 6)
#define DISPQT_CONFIG_MAINWINCTRL_SHOW_AVMIXER         (1<<10)
#define DISPQT_CONFIG_MAINWINCTRL_EMBEDD_AVMIXER       (1<<11)
#define DISPQT_CONFIG_MAINWINCTRL_SHOW_DVBEPG          (1<<12)
#define DISPQT_CONFIG_MAINWINCTRL_SHOW_EDITOR          (1<<14)
#define DISPQT_CONFIG_MAINWINCTRL_SHOW_STATUSLINE      (1<<17)
#define DISPQT_CONFIG_MAINWINCTRL_TRANSLUCENT          (1<<20) // TODO: keeped for backward compatibility (to not disable it after config reset)
#define DISPQT_CONFIG_MAINWINCTRL_ALWAYS_ON_TOP        (1<<21)
#define DISPQT_CONFIG_MAINWINCTRLS_DEFAULT 	( DISPQT_CONFIG_MAINWINCTRL_SHOW_VIDEO | DISPQT_CONFIG_MAINWINCTRL_SHOW_SEEKBAR \
											| DISPQT_CONFIG_MAINWINCTRL_SHOW_TOOLBAR | DISPQT_CONFIG_MAINWINCTRL_SHOW_AVMIXER \
											| DISPQT_CONFIG_MAINWINCTRL_EMBEDD_AVMIXER | DISPQT_CONFIG_MAINWINCTRL_SHOW_EDITOR \
											| DISPQT_CONFIG_MAINWINCTRL_SHOW_STATUSLINE | DISPQT_CONFIG_MAINWINCTRL_TRANSLUCENT)

// (mainwin) transparent_control
#define DISPQT_CONFIG_TRANSCTRL_DESKTOPTRANS_FRAMELESS (1<<27) // frameless main window
#define DISPQT_CONFIG_TRANSCTRL_DESKTOPTRANS_AUTOMAXI  (1<<28) // automatically maximize
#define DISPQT_CONFIG_TRANSCTRL_EXIT_TO_FULLVIDEO      (1<<29) // automatically switch to fullscreen video at exit from transparency
#define DISPQT_CONFIG_TRANSCTRL_DESKTOPTRANS_RESTORE   (1<<30) // save & restore transparent desktop (startup)
#define DISPQT_CONFIG_TRANSCTRL_DESKTOPTRANS_ENABLED   (1<<31) // enable(d) trasnparent desktop (video)
#define DISPQT_CONFIG_TRANSCTRLS_DEFAULT (DISPQT_CONFIG_MAINWINCTRL_HIDE_MENU | DISPQT_CONFIG_MAINWINCTRL_SHOW_VIDEO \
										| DISPQT_CONFIG_TRANSCTRL_DESKTOPTRANS_AUTOMAXI)
#define DISPQT_CONFIG_TRANSCTRLS_COPYMASK_TRANSCTRL   ((1<<27) - 1)  // transparent_control to new mainwin_control
#define DISPQT_CONFIG_TRANSCTRLS_COPYMASK_MAINWINCTRL (DISPQT_CONFIG_MAINWINCTRL_ALWAYS_ON_TOP) // curr to new mainwin_control

// editor_flags
#define DISPQT_CONFIG_EDITORFLAG_SHOWPANEL_LEFT       (1<< 0) // !!! keep them here
#define DISPQT_CONFIG_EDITORFLAG_SHOWPANEL_RIGHT      (1<< 1) //
#define DISPQT_CONFIG_EDITORFLAG_SHOWPANELS_ALL       0x0F
#define DISPQT_CONFIG_EDITORFLAG_SHOWPANELS_DEFAULT   (DISPQT_CONFIG_EDITORFLAG_SHOWPANEL_LEFT | DISPQT_CONFIG_EDITORFLAG_SHOWPANEL_RIGHT)
#define DISPQT_CONFIG_EDITORFLAG_SHOW_DRIVELINE       (1<< 6)
#define DISPQT_CONFIG_EDITORFLAG_TOOLTIP_FILEINFOS    (1<<10)
#define DISPQT_CONFIG_EDITORFLAG_COLUMNS_SEPARTTITLE  (1<<15) // separate artist and title
#define DISPQT_CONFIG_EDITORFLAG_COLUMNS_MANUALSIZE   (1<<16)
#define DISPQT_CONFIG_EDITORFLAG_DISABLE_SCROLLBAR    (1<<17)
#define DISPQT_CONFIG_EDITORFLAG_TRANSPARENT_INWINDOW (1<<20) // depending on DISPQT_GUILAYOUT_ and DISPQT_GUIBKGTYPE_
#define DISPQT_CONFIG_EDITORFLAG_TRANSPARENT_ONVIDEO  (1<<21) //
#define DISPQT_CONFIG_EDITORFLAG_TRANSPARENT_INACTIVE (1<<22) // losing focus at non-fullscreen video
#define DISPQT_CONFIG_EDITORFLAG_WIDGET_ADDED         (1<<28) //
#define DISPQT_CONFIG_EDITORFLAG_TRANSPARENT_BACK     (1<<31) // internal flag
#define DISPQT_CONFIG_EDITORFLAGS_DEFAULT             (DISPQT_CONFIG_EDITORFLAG_SHOWPANELS_DEFAULT | DISPQT_CONFIG_EDITORFLAG_SHOW_DRIVELINE \
                                                       | DISPQT_CONFIG_EDITORFLAG_TRANSPARENT_ONVIDEO | DISPQT_CONFIG_EDITORFLAG_TRANSPARENT_INACTIVE)

// video_control
#define DISPQT_CONFIG_VIDEOCTRL_ENABLE_VIDEO            (1<< 0)  // enable QT based video playing
#define DISPQT_CONFIG_VIDEOCTRL_ENABLE_CONTROLBAR       (1<< 3)  // enable bottom video control bar
#define DISPQT_CONFIG_VIDEOCTRL_CONTROLBAR_FADEOUT      (1<< 4)  // enable fade-out for video control bar
#define DISPQT_CONFIG_VIDEOCTRL_CONTROLBAR_HEADERLESS   (1<< 5)  // use headerless transparent (non-Aero, black) control bar
#define DISPQT_CONFIG_VIDEOCTRL_SHOW_MAINWIN_ON_VIDEO   (1<< 6)  // show main window over video
#define DISPQT_CONFIG_VIDEOCTRL_AUTO_HIDE_MAINWIN       (1<< 8)  // hide main window over fullscreen video (after fadeout time)
#define DISPQT_CONFIG_VIDEOCTRL_POPUP_MAINWIN_BY_KEYS   (1<<10)  // popup main window by editor keys
#define DISPQT_CONFIG_VIDEOCTRL_PLAYSTART_FULLSCREEN    (1<<16)  // switch to fullscreen at start of videos (prg start, play start)
#define DISPQT_CONFIG_VIDEOCTRL_ENTERKEY_FULLSCREEN     (1<<17)  // switch to fullscreen at pressing ENTER
#define DISPQT_CONFIG_VIDEOCTRL_EXIT_FULLSCREEN_AT_STOP (1<<18)  // exit from fullscreen at play-stop
#define DISPQT_CONFIG_VIDEOCTRL_FULLSCREEN_ESC_PAUSE    (1<<19)  // ESC key pauses playing exiting from fullscreen
#define DISPQT_CONFIG_VIDEOCTRL_FULLSCREEN_FROM_TRANSP  (1<<20)  // switch to fullscreen from transparent mode (flag)
#define DISPQT_CONFIG_VIDEOCTRL_SEEKPREVIEW_ENABLE      (1<<24)  // enable control bar seek preview window
#define DISPQT_CONFIG_VIDEOCTRLS_DEFAULT (DISPQT_CONFIG_VIDEOCTRL_ENABLE_VIDEO | DISPQT_CONFIG_VIDEOCTRL_ENABLE_CONTROLBAR \
										| DISPQT_CONFIG_VIDEOCTRL_CONTROLBAR_FADEOUT \
										| DISPQT_CONFIG_VIDEOCTRL_SEEKPREVIEW_ENABLE | DISPQT_CONFIG_VIDEOCTRL_SHOW_MAINWIN_ON_VIDEO \
										| DISPQT_CONFIG_VIDEOCTRL_AUTO_HIDE_MAINWIN | DISPQT_CONFIG_VIDEOCTRL_POPUP_MAINWIN_BY_KEYS \
										| DISPQT_CONFIG_VIDEOCTRL_PLAYSTART_FULLSCREEN | DISPQT_CONFIG_VIDEOCTRL_EXIT_FULLSCREEN_AT_STOP)

// HDR control bits
#define DISPQT_CONFIG_VIDEO_HDR_TO_SDR_CONV   (1 << 0)  // enable HDR to SDR conversion
#define DISPQT_CONFIG_VIDEO_HDR_DYN_LUMINANCE (1 << 1)  // enable dynamic luminance update
#define DISPQT_CONFIG_VIDEO_HDR_DYN_COLORS    (1 << 2)  // enable dynamic (custom) color primaries update
#define DISPQT_CONFIG_VIDEO_HDR_DYN_LUM_SLOW  (1 << 3)  // use slow dynamic luminance update
#define DISPQT_CONFIG_VIDEO_HDR_CONTROL_DEFAULT   (DISPQT_CONFIG_VIDEO_HDR_TO_SDR_CONV)

//main window opacity values (0=100) and onvideo timeouts in ms
#define DISPQT_CONFIG_MAINWIN_OPACITY_GENERAL_MIN         50
#define DISPQT_CONFIG_MAINWIN_OPACITY_GENERAL_MAX        100
#define DISPQT_CONFIG_MAINWIN_OPACITY_GENERAL_DEFAULT    100
#define DISPQT_CONFIG_MAINWIN_OPACITY_INACTIVE_DEFAULT    90
#define DISPQT_CONFIG_MAINWIN_OPACITY_DIALOG_DEFAULT      90  // used for dialogs, if OS doesn't support any transparency
#define DISPQT_CONFIG_MAINWIN_OPACITY_TRANSPARENT_MIN     10
#define DISPQT_CONFIG_MAINWIN_OPACITY_TRANSPARENT_MAX     80
#define DISPQT_CONFIG_MAINWIN_OPACITY_TRANSPARENT_DEFAULT 45
#define DISPQT_CONFIG_MAINWIN_OPACITY_ONVIDEO_SHOW_MIN    10
#define DISPQT_CONFIG_MAINWIN_OPACITY_ONVIDEO_SHOW_MAX   100
#define DISPQT_CONFIG_MAINWIN_OPACITY_ONVIDEO_SHOW_DEF_WIN7    DISPQT_CONFIG_MAINWIN_OPACITY_INACTIVE_DEFAULT // set it equal to INACTIVE_DEFAULT to avoid flickering
#define DISPQT_CONFIG_MAINWIN_OPACITY_ONVIDEO_SHOW_DEF_WIN10   100 // TODO: we should separate by glass/classic layout too
#define DISPQT_CONFIG_MAINWIN_OPACITY_ONVIDEO_HIDE_MIN     0
#define DISPQT_CONFIG_MAINWIN_OPACITY_ONVIDEO_HIDE_MAX    50
#define DISPQT_CONFIG_MAINWIN_OPACITY_ONVIDEO_HIDE_DEF     0
#define DISPQT_CONFIG_MAINWIN_OPACITY_SHOWKEEP_TIMEMS_MIN      200
#define DISPQT_CONFIG_MAINWIN_OPACITY_SHOWKEEP_TIMEMS_MAX    10000
#define DISPQT_CONFIG_MAINWIN_OPACITY_SHOWKEEP_TIMEMS_DEFAULT 4000
#define DISPQT_CONFIG_MAINWIN_OPACITY_FADEIN_TIMEMS_MIN        100
#define DISPQT_CONFIG_MAINWIN_OPACITY_FADEIN_TIMEMS_MAX       3000
#define DISPQT_CONFIG_MAINWIN_OPACITY_FADEIN_TIMEMS_DEFAULT    500
#define DISPQT_CONFIG_MAINWIN_OPACITY_FADEOUT_TIMEMS_MIN       200
#define DISPQT_CONFIG_MAINWIN_OPACITY_FADEOUT_TIMEMS_MAX     10000
#define DISPQT_CONFIG_MAINWIN_OPACITY_FADEOUT_TIMEMS_DEFAULT  2000

#define DISPQT_CONFIG_MAINWIN_COLOR_ALPHA_DEFAULT       40   // in percent (0 = full transparent, no color; 100 = no transparent, full color)
#define DISPQT_CONFIG_MAINWIN_COLOR_ALPHA_MAX          100   // in percent (opaque: no transparent, full color)

#define DISPQT_CONFIG_VIDEO_CONTROLBAR_SIZE_MIN         35   // in percent of display horizontal (x) size
#define DISPQT_CONFIG_VIDEO_CONTROLBAR_SIZE_MAX        100
#define DISPQT_CONFIG_VIDEO_CONTROLBAR_SIZE_DEF_HALF    50   // half width with header (WinXp, Win7, Win11)
#define DISPQT_CONFIG_VIDEO_CONTROLBAR_SIZE_DEF_FULL   100   // full width for headerless control bar (Win8/10)

#define DISPQT_CONFIG_VIDEO_SEEKPREVIEW_SIZE_MIN         5   // in percent of display vertical (y) size
#define DISPQT_CONFIG_VIDEO_SEEKPREVIEW_SIZE_MAX        90
#define DISPQT_CONFIG_VIDEO_SEEKPREVIEW_SIZE_DEFAULT    20
#define DISPQT_CONFIG_VIDEO_SEEKPREVIEW_INTERVAL_MIN     0   // in msecs
#define DISPQT_CONFIG_VIDEO_SEEKPREVIEW_INTERVAL_MAX  1000
#define DISPQT_CONFIG_VIDEO_SEEKPREVIEW_INTERVAL_DEFAULT  0  // fast as possible by default
#define DISPQT_CONFIG_VIDEO_SEEKPREVIEW_AR_DEFAULT    DISPQT_VIDEOFULLSCREENARTYPE_NONE // means: equals with fullscreen setting

#define DISPQT_CONFIG_DVBEPG_PASTEVENTS_HOURS_MIN       1
#define DISPQT_CONFIG_DVBEPG_PASTEVENTS_HOURS_MAX     999

struct mmc_dispqt_config_s {
	unsigned long mainwin_control;                            // DISPQT_CONFIG_MAINWINCTRL_
	unsigned long mainwin_state;                              // Qt::WindowState excluding WindowMinimized
	unsigned long transparent_control;                        // DISPQT_CONFIG_TRANSCTRL_
	unsigned long gui_layout_type;                            // DISPQT_GUILAYOUT_
	unsigned long gui_background_type;                        // DISPQT_GUIBKGTYPE_
	unsigned long gui_background_effect;                      // DISPQT_GUIBKGEFCT_
	unsigned long gui_background_color_alpha;                 // TODO: unused yet

	unsigned long editor_flags;                               // DISPQT_CONFIG_EDITORFLAG_
	int editor_size_y;

	unsigned long video_control;                              // DISPQT_CONFIG_VIDEOCTRL_
	unsigned long video_renderer_type;                        // DISPQT_VIDEORENDERTYPE_
	unsigned long video_fullscreen_ar_type;                   // DISPQT_VIDEOFULLSCREENARTYPE_
	unsigned long video_windowed_ar_type;                     // DISPQT_VIDEOWINDOWEDARTYPE_
	unsigned long video_crop_type;                            // DISPQT_VIDEOSCRCROPTYPE_
	unsigned long video_zoom_type;                            // DISPQT_VIDEOFULLSCREENZOOMTYPE_
	unsigned long video_deinterlace_type;                     // DISPQT_VIDEO_DEINTERLACETYPE_
	unsigned long video_rotation_type;                        // DISPQT_VIDEO_ROTATIONTYPE_
	unsigned long video_autocrop_limit;                       // in the height of the video
	unsigned long video_hdr_control;                          // DISPQT_CONFIG_VIDEO_HDR_
	unsigned long selected_videoplayer_type, selected_videoplayer_control, selected_videorenderer_type;

	unsigned long videocontrolbar_size_percent;
	unsigned long videoseekpreview_size_percent;
	unsigned long videoseekpreview_aspect_ratio_type;
	unsigned long videoseekpreview_refresh_interval_ms;
	int video_zoom_value;

	int epgdialogwin_pos_x, epgdialogwin_pos_y, epgdialogwin_size_x, epgdialogwin_size_y;

	int mainwin_pos_x, mainwin_pos_y, mainwin_size_x, mainwin_size_y;
	unsigned long mainwin_opacity_general, mainwin_opacity_inactive, mainwin_opacity_transparent;
	unsigned long mainwin_opacity_onvideo_show, mainwin_opacity_onvideo_hide;
	unsigned long mainwin_opacity_showkeep_time, mainwin_opacity_fadein_time, mainwin_opacity_fadeout_time;

	int video_mixer_values[DISPQT_VIDEO_VMIXERTYPE_MAX];
	char *font_text_name[DISPQT_FONTTEXTID_MAX]; // font.toString() -> UTF8 string
	char *color_window_text_name[DISPQT_COLORTEXTID_WINDOW_MAX]; // color.name() -> UTF8 string
	char *color_text_name[DISPQT_COLORTEXTID_EDITOR_MAX]; // color.name() -> UTF8 string
	char video_ar_custom[16], video_crop_custom[16], video_zoom_custom[16];
	char video_screen_select_name[MPXINI_MAX_CHARDATA_LEN];
};

extern struct mmc_dispqt_config_s mmc_config;

//--------------------------------------------------------------------------------------------
//config_ini.cpp global C functions

extern void mpxplay_dispqt_configini_init(void);
extern void mpxplay_dispqt_configini_reset_configurables(void);
extern void mpxplay_dispqt_configini_set_default_fonts(void);
extern struct mmc_dispqt_config_s *mpxplay_dispqt_configini_get(void);
extern void mpxplay_dispqt_configini_load_from_file(void);
extern void mpxplay_dispqt_configini_save_to_file(void);

//===========================================================================================
class DispQtConfigpageMainwin : public DispQtDialogElemTabWidget
{
public:
	DispQtConfigpageMainwin(MainWindow *main_window = 0, QWidget *parent = 0);
	void configpage_mainwin_applyall(void);

private:
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_mainwin_normal_layout;
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_mainwin_transparent_layout;
};

//-------------------------------------------------------------------------------------------
class DispQtConfigpageDisplay : public QWidget
{
public:
	DispQtConfigpageDisplay(MainWindow *main_window = 0, QWidget *parent = 0);
	void configpage_display_applyall(void);

private:
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_editor;
	MainWindow *main_window;
};

//------------------------------------------------------------------------------------------
class DispQtConfigpageColorCfgline : public QWidget
{
Q_OBJECT
public:
	DispQtConfigpageColorCfgline(MainWindow *mainwindow = 0, QWidget *parent = 0, QString line_text = "", char **colortext_ptr = NULL);
	void colorcfgline_apply();
public Q_SLOTS:
	void colorcfgline_getcolor();
private:
	void colorcfgline_setcolor(void);
	QLabel *label_colorname, *label_colorbar;
	char **color_text_ptr;
	QColor color_selected;
};

class DispQtConfigpageColor : public DispQtDialogElemTabWidget
{
public:
	DispQtConfigpageColor(MainWindow *main_window = 0, QWidget *parent = 0);
	void configpage_color_applyall(void);

private:
	DispQtConfigpageComboboxGroupbox *combobox_gui_general_colorization_control;
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_editor_transparent;
	DispQtConfigpageColorCfgline *colorcfgline_window[DISPQT_COLORTEXTID_WINDOW_MAX];
	DispQtConfigpageColorCfgline *colorcfgline_editor[DISPQT_COLORTEXTID_EDITOR_MAX];
};

//--------------------------------------------------------------------------------------------
class DispQtConfigpageFontBox : public QGroupBox
{
Q_OBJECT
public:
	DispQtConfigpageFontBox(MainWindow *mainwindow = 0, QWidget *parent = 0, QString box_text = "", char **fonttext_ptr = NULL);
	void pagefontbox_apply();
public Q_SLOTS:
	void pagefontbox_getfont();
private:
	QLabel *font_label;
	char **font_text_ptr;
	QFont font_selected;
};

class DispQtConfigpageFont : public QWidget
{
public:
	DispQtConfigpageFont(MainWindow *main_window = 0, QWidget *parent = 0);
	void configpage_font_applyall(void);

private:
	DispQtConfigpageFontBox *fontcfgbox[DISPQT_FONTTEXTID_MAX];
};

//------------------------------------------------------------------------------------------
class DispQtConfigpageOpacity : public QWidget
{
public:
	DispQtConfigpageOpacity(MainWindow *main_window = 0, QWidget *parent = 0);
	void configpage_opacity_applyall(void);

private:
	MainWindow *main_window;
	DispQtConfigpageSpinboxGroupbox *groupspinboxes_mainwin_opacity;
	DispQtConfigpageSpinboxGroupbox *groupspinboxes_mainwin_opacity_time;
};

//-------------------------------------------------------------------------------------------
class DispQtConfigpagePlayList : public QWidget
{
public:
	DispQtConfigpagePlayList(MainWindow *main_window = 0, QWidget *parent = 0);
	void configpage_playlist_applyall(void);

private:
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_playlistcontrol;
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_loadid3tag;
	DispQtConfigpageComboboxGroup *groupcomboxes_preloadinfo;
	DispQtConfigpageCheckboxGroup *groupchkboxes_preloadinfo;
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_sortcontrol;
};

//-------------------------------------------------------------------------------------------
class DispQtConfigpagePlayControl : public QWidget
{
public:
	DispQtConfigpagePlayControl(MainWindow *main_window = 0, QWidget *parent = 0);
	void configpage_playcontrol_applyall(void);

private:
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_playcontrol;
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_startup;
	DispQtConfigpageEditlineGroupbox *groupeditlines_hilitescan;
};

//-------------------------------------------------------------------------------------------
class DispQtConfigpageProgram : public QWidget
{
public:
	DispQtConfigpageProgram(MainWindow *main_window = 0, QWidget *parent = 0);
	void configpage_program_applyall(void);

private:
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_programcontrol;
	DispQtConfigpageEditlineGroupbox *groupeditlines_extrafiletypes;
	DispQtConfigpageEditlineGroupbox *groupeditlines_executetime;
};

//-------------------------------------------------------------------------------------------
class DispQtConfigpageAudio : public DispQtDialogElemTabWidget
{
public:
	DispQtConfigpageAudio(MainWindow *main_window = 0, QWidget *parent = 0);
	void configpage_audio_applyall(void);

private:
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	DispQtConfigpageComboboxGroupbox *combobox_audio_language_config;
	DispQtConfigpageComboboxGroupbox *combobox_audio_extfile_config;
	DispQtConfigpageComboboxGroupbox *groupeditlines_audio_format_priority;
#endif
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_audio;
	DispQtConfigpageSpinboxGroupbox *groupspinboxes_loudness;
	DispQtConfigpageComboboxGroupbox *groupcomboxes_soundcard;
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_soundcard;
};

//-------------------------------------------------------------------------------------------
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG

class DispQtConfigpageSubtitle : public QWidget
{
public:
	DispQtConfigpageSubtitle(MainWindow *main_window = 0, QWidget *parent = 0);
	void configpage_subtitle_applyall(void);

private:
	DispQtConfigpageComboboxGroupbox *combobox_subtitle_language_config;
	DispQtConfigpageComboboxGroupbox *combobox_subtitle_extfile_config;
	DispQtConfigpageCheckboxGroupbox *checkbox_subtitle_switches;
	DispQtConfigpageCheckboxGroupbox *checkbox_other_switches;
};

#endif // MPXPLAY_LINK_ORIGINAL_FFMPEG

//-------------------------------------------------------------------------------------------
class DispQtConfigpageVideo : public DispQtDialogElemTabWidget
{
public:
	DispQtConfigpageVideo(MainWindow *main_window = 0, QWidget *parent = 0);
	void configpage_video_applyall(void);

private:
	MainWindow *main_window;

	DispQtConfigpageCheckboxGroupbox *groupchkboxes_videocontrol_mainwindowcontrol;
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_videocontrol_fullscreencontrol;
	DispQtConfigpageComboboxGroupbox *combobox_videocontrol_bottomcontrolbar;
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	DispQtConfigpageComboboxGroupbox *combobox_videocontrol_seekpreview;
	DispQtConfigpageComboboxGroupbox *combobox_videocontrol_videostreamlanguage;
#endif

	DispQtConfigpageComboboxGroupbox *groupcomboxes_videoconfig_videoconfig;
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_videoconfig_videoplayercontrol;
	DispQtConfigpageCheckboxGroupbox *groupcomboxes_videoconfig_hdrcontrol;
	DispQtConfigpageEditlineGroupbox *groupeditlines_videoconfig_custompicturesettings;
#endif

#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	DispQtConfigpageCheckboxGroupbox *groupchkboxes_dvbepg_videowall;
	DispQtConfigpageComboboxGroupbox *groupcomboxes_dvbepg_programlistcontrol;
#endif
};

//-------------------------------------------------------------------------------------------
class DispQtConfigWindow : public DispQtDialogElemWindow
{
Q_OBJECT
public:
	DispQtConfigWindow(MainWindow *main_window = 0, QWidget *parent = 0);

public Q_SLOTS:
	void config_apply();
	void config_ok_close();
	void config_reset_close();
    void changePage(QListWidgetItem *current, QListWidgetItem *previous);

protected:
    void closeEvent(QCloseEvent *e);
    void keyPressEvent(QKeyEvent *event);

private:
    void config_create_listlines();

	MainWindow *main_window;
	QWidget *parent_widget;
	QListWidget *contentsWidget;
	QStackedWidget *pagesWidget;
	QMutex mutex_cfg;

	DispQtConfigpageMainwin *configpage_mainwin;
	DispQtConfigpageDisplay *configpage_display;
	DispQtConfigpageColor *configpage_color;
	DispQtConfigpageFont *configpage_font;
	DispQtConfigpageOpacity *configpage_opacity;
	DispQtConfigpagePlayList *configpage_playlist;
	DispQtConfigpagePlayControl *configpage_playcontrol;
	DispQtConfigpageProgram *configpage_program;
	DispQtConfigpageAudio *configpage_audio;
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	DispQtConfigpageSubtitle *configpage_subtitle;
#endif
	DispQtConfigpageVideo *configpage_video;
};

#endif // moc_config_h
