{DOS port of Neofetch}
{$E+}
{$M 16384,0,12800}
{$DEFINE VNUT_XT}
uses Dos,Crt,Lacrt;

const
maxlines = 25;
maxcol = 80;


type
TScrBuf = array[1..maxcol,1..maxlines] of char;
PScrBuf = ^TScrBuf;
str40 = string[40];

var
Hbuf:PScrBuf;
Abuf:PScrBuf;
maxy,maxx:byte;
isredir:boolean;
myout:text;
forcelang:string[3];

const
msg_ram1:str40 = 'Memory: ';
msg_ram2:str40 = 'MB RAM';
msg_disks:str40 = 'Installed disks: ';
msg_percfree:str40 = 'free';
msg_dosver:str40 = 'Reported DOS version: ';
msg_codepage:str40 = 'Current code page: ';
msg_country:str40 = 'Country code: ';
msg_fs_gb:str40 = 'GB';
msg_fs_mb:str40 = 'MB';
msg_fs_kb:str40 = 'KB';
msg_fs_B:str40 = 'bytes';
msg_newer_than_p3:str40 = 'CPU newer than Pentium III';

Function GetCPU_Type_386_486: Byte; Assembler;
Asm
  MOV DX, 2 {Cpu80386}
  {"DB 66h" indicates '386 extended instruction}
  DB 66h; MOV   BX, SP      {MOV EBX, ESP}
  DB 66h, 83h, 0E4h, 0FCh   {AND ESP, FFFC}
  DB 66h; PUSHF             {PUSHFD}
  DB 66h; POP AX            {POP EAX}
  DB 66h; MOV   CX, AX      {MOV ECX, EAX}
  DB 66h, 35h, 00h
  DB 00h, 04h, 00           {XOR EAX, 00040000}
  DB 66h; PUSH   AX     {PUSH EAX}
  DB 66h; POPF              {POPFD}
  DB 66h; PUSHF             {PUSHFD}
  DB 66h; POP   AX     {POP EAX}
  DB 66h, 25h, 00h
  DB 00h, 04h, 00h          {AND EAX, 00040000}
  DB 66h, 81h, 0E1h, 00h
  DB 00h, 04h, 00h          {AND ECX, 00040000}
  DB 66h; CMP   AX, CX      {CMP EAX, ECX}
  JE @Not486
  MOV DX, 3 {Cpu80486}
@Not486:
  DB 66h; PUSH   CX         {PUSH EXC}
  DB 66h; POPF              {POPFD}
  DB 66h; MOV   SP, BX      {MOV ESP, EBX}
@Out:
  MOV AX, DX
end;


Function CPU_Identification:string;
const
cpu8086 = 'CPU 8086/8088 (PC/XT)';
cpu286 = 'CPU 80286 (PC/AT)';
cpu386 = 'CPU 80386';
cpu486 = 'CPU 80486';
cpu586 = 'Pentium class';
cpuPentpro = 'Pentium Pro';
cpuPent2 = 'Pentium II';
cpuPent3 = 'Pentium III';


var i:byte;
    b:boolean;
    s,t:string;
    fax,fbx,fcx,fdx:longint;
    ffax,d:longint;
    mfam,mmod:byte;

begin
if Test8086>1 then i:=GetCPU_Type_386_486 else i:=Test8086;

case i of
  0:s:=cpu8086;
  1:s:=cpu286;
  2:s:=cpu386;
  3:s:=cpu486;
end; {case}

if i>2 then  {386 or better}
   begin
   b:=CallCPUID(0,fax,fbx,fcx,fdx); {try to obtain vendor string}
   if b=true then             {some 486's and all Pentiums know CPUID}
      begin
      t[0]:=#12;
      Move(fbx,t[1],4);
      Move(fdx,t[5],4);
      Move(fcx,t[9],4);
      ffax:=fax;

      CallCPUID($80000000,fax,fbx,fcx,fdx);

      if (fax>=$80000004) and (fax<>0) then
         begin
         t[0]:=#48;
         CallCPUID($80000002,fax,fbx,fcx,fdx);
         Move(fax,t[1],4);
         Move(fbx,t[5],4);
         Move(fcx,t[9],4);
         Move(fdx,t[13],4);

         CallCPUID($80000003,fax,fbx,fcx,fdx);
         Move(fax,t[17],4);
         Move(fbx,t[21],4);
         Move(fcx,t[25],4);
         Move(fdx,t[29],4);

         CallCPUID($80000004,fax,fbx,fcx,fdx);
         Move(fax,t[33],4);
         Move(fbx,t[37],4);
         Move(fcx,t[41],4);
         Move(fdx,t[45],4);
         for d:=1 to Length(t) do
             if t[d]=#0 then t[d]:=#32;
         s:=PackSpaces(t);
         end
         else
         begin

      if ffax>0 then
         begin
         CallCPUID(1,fax,fbx,fcx,fdx);
         d:=(fax shr 8) and 15;
         mfam:=d;

         d:=(fax shr 4) and 15;
         mmod:=d;

         if (mfam=6) or (mfam=15) then
            begin
            d:=(fax shr 16) and 15;
            mmod:=mmod + (d shl 4);
            end;

         case mfam of
         3:t:=cpu386;
         4:t:=cpu486;
         5:t:=cpu586;
         6:begin
           case mmod of
           0,1: t:=cpuPentpro;
           3,5,6: t:=cpuPent2;
           7,8,$a,$b: t:=cpuPent3;
           else t:=msg_newer_than_p3;
           end; {case}
           end;
         end; {case}

         s:=t;
         end;
         end;
      end;
   end;

CPU_Identification:=s;
end;


Function GetCursorParam:word;assembler;
asm
mov ah,3
mov bh,0
int 10h
mov ax,dx
end;


Function IsRedirectedOutPut:boolean;
var a1,a2:word;
begin
a1:=GetCursorParam;
write(stdout,' ');
a2:=GetCursorParam;
IsRedirectedOutPut:=a1=a2;
if a1<>a2 then write(stdout,char(8))
end;



Procedure InitBufs;
begin
maxy:=0;
maxx:=0;
New(Hbuf);
New(Abuf);
FillChar(Hbuf^,SizeOf(TScrBuf),32);
FillChar(Abuf^,SizeOf(TScrBuf),7);
isredir:=IsRedirectedOutPut;
end;


Procedure KillBufs;
begin
Dispose(Hbuf);
Dispose(Abuf);
Close(myout);
end;


Procedure WriteBufs(x,y:byte;s:string;col:byte);
var xs,ls,a,b,mxs:byte;
    specbyte:boolean;
begin
xs:=x-1;
ls:=Length(s);

if y>maxy then maxy:=y;
if x+ls>maxcol then ls:=maxcol-x;
mxs:=x+ls-1;
if mxs>maxx then maxx:=mxs;

specbyte:=false;
b:=1;
for a:=1 to ls do
    begin
    if (s[a]=char(1)) and (specbyte=false) then
       begin
       specbyte:=true;
       end
    else
    if specbyte=false then
       begin
       HBuf^[xs+b,y]:=s[a];
       ABuf^[xs+b,y]:=char(col);
       inc(b);
       end
       else begin
       col:=byte(s[a]);
       specbyte:=false;
       end;
    end;
end;




Procedure PrintBufs;
var x,y:byte;
    h:char;
    a:byte;
begin
for y:=1 to maxy do
    begin
    for x:=1 to maxx do
        begin
        h:=HBuf^[x,y];
        a:=byte(ABuf^[x,y]);
        TextColor(a and 15);
        write(myout,h);
        end;
    writeln(myout);
    end;
end;


Procedure Write_DOS_Logo_D(x,y,c:byte);
begin
WriteBufs(x,y+0,'8888888ba,  ',c);
WriteBufs(x,y+1,'88     `"8b ',c);
WriteBufs(x,y+2,'88       `8b',c);
WriteBufs(x,y+3,'88        88',c);
WriteBufs(x,y+4,'88        88',c);
WriteBufs(x,y+5,'88        8P',c);
WriteBufs(x,y+6,'88     .a8P ',c);
WriteBufs(x,y+7,'8888888Y"'' ',c);
end;


Procedure Write_DOS_Logo_O(x,y,c:byte);
begin
WriteBufs(x,y+0,'  ,ad888ba,   ',c);
WriteBufs(x,y+1,' d8"''   `"8b ',c);
WriteBufs(x,y+2,'d8''       `8b',c);
WriteBufs(x,y+3,'88         88 ',c);
WriteBufs(x,y+4,'88         88 ',c);
WriteBufs(x,y+5,'Y8,       ,8P ',c);
WriteBufs(x,y+6,' Y8a.   .a8P  ',c);
WriteBufs(x,y+7,'  `"Y888Y"'' ',c);
end;

Procedure Write_DOS_Logo_S(x,y,c:byte);
begin
WriteBufs(x,y+0,'  ad88888ba  ',c);
WriteBufs(x,y+1,' d8"     "8b ',c);
WriteBufs(x,y+2,' Y8,         ',c);
WriteBufs(x,y+3,'`Y8aaaaa,   ',c);
WriteBufs(x,y+4,'  `"""""8b, ',c);
WriteBufs(x,y+5,'        `8b ',c);
WriteBufs(x,y+6,'Y8a     a8P ',c);
WriteBufs(x,y+7,'  "Y88888P"',c);
end;


Procedure Write_DOS_Logo;
begin
Write_DOS_Logo_D(1,2,4);
Write_DOS_Logo_O(14,2,14);
Write_DOS_Logo_S(27,2,1);
end;


Procedure ReadLine(var t:text;var s:string);
var g:string;
    b:byte;
begin
readln(t,g);
b:=Pos('}',g);
if b>0 then Delete(g,b,255);
b:=Pos('{',g);
if b>0 then Delete(g,1,b);
s:=g;
end;


Procedure ZeSouboru(s:string);
var t:text;
begin
{$I-}
Assign(t,s);
Reset(t);
{$I+}
if IOresult<>0 then Exit;
ReadLine(t,msg_ram1);
ReadLine(t,msg_ram2);
ReadLine(t,msg_disks);
ReadLine(t,msg_percfree);
ReadLine(t,msg_dosver);
ReadLine(t,msg_codepage);
ReadLine(t,msg_country);
ReadLine(t,msg_fs_gb);
ReadLine(t,msg_fs_mb);
ReadLine(t,msg_fs_kb);
ReadLine(t,msg_fs_B);
ReadLine(t,msg_newer_than_p3);
Close(t);
end;


Procedure ReadMessages;
var nlspath,lang:string;
    n,a1,a3,prg:string;
begin
n:=ParamStr(0);
FSplit(n,a1,prg,a3);

nlspath:=GetEnv('NLSPATH');

if forcelang=''
   then lang:=GetEnv('LANG')
   else begin
   lang:=forcelang;
   if nlspath='' then nlspath:=a1;
   end;


if nlspath<>'' then
   if nlspath[Length(nlspath)]<>'\' then nlspath:=nlspath+'\';

if (nlspath<>'') and (lang<>'') then
   begin
   n:=nlspath+prg+'.'+lang;
   ZeSouboru(n);
   end;
end;


Function Parser:byte;
var i:byte;
    s:string;
begin
forcelang:='';
for i:=1 to ParamCount do
    begin
    s:=Convert_Up(ParamStr(i));
    if (s='/?') or (s='/H') or (s='/I') then
       begin
       writeln('FETCH4FD  (DOS implementation of Linux utility NEOFETCH)');
       writeln('version 1.0');
       writeln('written by Laaca');
       writeln('Laaca@seznam.cz');
       writeln;
       writeln('Parameters:');
       writeln('/? /H /I : this help');
       writeln;
       writeln('/L:<language code>');
       writeln('<language code> is a file with translated program messages.');
       writeln('Example: ');
       writeln('FETCH4FD /L:cz    Loads file FETCH4FD.CZ and switches');
       writeln('                  program messages to Czech language.');
       Halt(0);
       end;

    if Copy(s,1,3)='/L:' then
       begin
       delete(s,1,3);
       s:=SkipAllSpaces(s);
       forcelang:=s;
       end;

    end;
end;


{MAIN PROGRAM}


var a,b,yy:byte;
    w,cp,ccode:word;
    lds:str40;
    pds:str40;
    fdr:char;
    mgd:char;
    l:longint;
    i,j:array[1..2] of real;
    f:real;
    s:array[1..2] of string[15];

begin
Parser;
ReadMessages;

InitBufs;
if isredir
   then Move(stdout,myout,SizeOf(text))
   else Move(output,myout,SizeOf(text));


ZjistiCodePage(ccode,cp);
lds:=LogDisk;
fdr:=Get_Fantom_Drive;

mgd:=char(MyGetDisk+64);

a:=Pos(fdr,lds);
if a>0 then
   begin
   Insert(')',lds,a+1);
   Insert('(',lds,a);
   end;

a:=Pos(mgd,lds);
if a>0 then
   begin
   Insert(#1#7,lds,a+1);
   Insert(#1#15,lds,a);
   end;

i[1]:=FreeDiskSpace(mgd);
i[2]:=TotaldiskSpace(mgd);

for b:=1 to 2 do
    if i[b]>1024*1024*1024 {GB} then begin j[b]:=i[b]/(1024*1024*1024);s[b]:=FormNum(j[b],2)+msg_fs_gb;end else
       if i[b]>1024*1024 {MB} then begin j[b]:=i[b]/(1024*1024);s[b]:=FormNum(j[b],2)+msg_fs_mb;end else
          if i[b]>1024 {KB} then begin j[b]:=i[b]/(1024);s[b]:=FormNum(j[b],2)+msg_fs_kb;end else
                          begin j[b]:=i[b];s[b]:=MyStr(round(j[b]))+msg_fs_b;end;

if i[2]=0
   then f:=0
   else f:=(i[1] / i[2] * 100);
l:=round(f);

pds:='['+mgd+']: '+#1#7+s[1]+' / '+s[2]+' ('+mystr(l)+'% '+msg_percfree+')';

WriteBufs(42,1,' ',7);
yy:=2;

Write_DOS_Logo;
WriteBufs(40,yy,Get_OS_type,7);inc(yy);
WriteBufs(40,yy,msg_dosver+#1#7+MyStr(Lo(DOSversion))+'.'+MyStr(Hi(DOSversion)),15);inc(yy);
WriteBufs(40,yy,msg_codepage+#1#7+MyStr(cp),15);inc(yy);
WriteBufs(40,yy,msg_country+#1#7+MyStr(ccode),15);inc(yy);
WriteBufs(40,yy,msg_disks+#1#7+lds,15);inc(yy);
WriteBufs(40,yy,pds,15);inc(yy);




w:=DetectMemory;
WriteBufs(40,yy,msg_ram1+#1#7+MyStr(w)+msg_ram2,15);inc(yy);


pds:=CPU_Identification;

WriteBufs(40,yy,pds,7);inc(yy);

PrintBufs;
KillBufs;
end.