#define USEWATTCP
/* Snuz -- an NNTP News Reader for the IBM-PC  */


/*
 * This program is a vastly enlarged and improved version of the program
 * "red" from the pcip distribution. The new parts are written by J.D.
 * McDonald and are public domain. The older parts are also freely
 * distributable. See the pcip distribution for more details. The version of
 * pcip this compiles with was obtained from husc6.harvard.edu. It probably
 * will not work with other versions. To compile this, use Microsoft C 5.1
 * and the include files provided with pcip - not Microsoft's ones. It is
 * small model and probably needs the /Gs switch. The picp libraries needed
 * are tcp, domain, udp, packet, ip, net, task, and pc. Also needed is the
 * file proto.c.
 */

/*
 * Further note: I don't really understand how the Internet works, or the
 * internals of pcip, at least not completely. NNTP itself is fairly easy to
 * understand. Basically, this was cooked up using by expanding on code
 * somebody else had written.
 */



#include <stdio.h>
#include <ctype.h>
#include <process.h>
#include <string.h>

#ifdef USEWATTCP

#include <tcp.h>

#include <time.h>	/* standard C libraries */
#include <stdlib.h>
#include <conio.h>
#include <dos.h>

tcp_Socket nntpsock;	/* the tcp socket for the NNTP connection */

#else /* PCIP version */
long            time(long *);
char           *malloc(unsigned);
int             kbhit(void);
int             rename(char *, char *);
int             remove(char *);
void            perror(char *);
int             atoi(char *);

extern int      errno;
#endif /* USEWATTCP */

#define NGROUPS 600
#define STRING 512
#define STR    128


char            serverhost[STR] = "none";
char            newsrc[STR] = "snuz.rc";
char            fromline[STR] = "";
char            editorpath[STR] = "";
char            smtppath[STR] = "";
char            tmpdir[STR] = "c:";

#ifdef USEWATTCP
char           *version = "\nSnuz (WATTCP) beta ver. 0.98\n\n";
#else  /* PCIP version */
char           *version = "\nSnuz beta ver. 0.98\n\n";
#endif /* USEWATTCP */

char            tmpfil[STR];
struct servent *ser;
struct hostent *hp;

FILE           *server;
int             serverfd;

int             reply;
unsigned long   reparticle;

char            cur_gname[STRING];
int             cur_group;
unsigned long   cur_numa, cur_first, cur_last;

unsigned long   cur_article;
unsigned long   follow_up_article;
char            cur_articleid[STRING];
char            cur_path[STRING], cur_from[STRING], cur_subject[STRING], cur_replyto[STRING];
char            cur_newsgroups[STRING], cur_message_ID[STRING], cur_references[STRING];
char            cur_date[STRING];

char           *groups[NGROUPS];
unsigned long   firsts[NGROUPS];
int             ngroups;
int             bogus = 0;

char           *servp;
int             servf;
char            servb[2048];

void            startup(int, char **);
void            compactgroups(void);
void            qexit(int);
int             cstat(unsigned long);
void            docommand(void);
void            dumpnewsrc(void);
int             postnews(void);
void            sendmail(void);
int             extract(char *, char *, char *);
void            pcip_exit(void);
int             netsocket(void);
void            getserv(char *, int);
int             saveactive(char *);
void            getnewsrc(void);
int             cgroup(char *);
int             cnext(void);
int             chead(void);
int             checkx(void);
int             ngetc(void);
int             showbody(void);
int             savebody(int);
int             getgroup(char *);
void            putserv(char *);
int             tcpwrite(int, char *, int);
void            usleep(void);
void            xabort(void);
void            clearscreen(void);
int             showindex(int);
void            listgroups(void);
int             getpost(int);
void            reversevideo(char *);
void            normalvideo(void);
void            backline(void);
void            shellout(void);
void            backgroundon(void);
void            backgroundoff(void);

#ifdef USEWATTCP
void            snuzinit(void);
#else /*PCIP */
int             tcpread(int, char *, int);
int             tcpopen(char *, int);
else
#endif /* USEWATTCP */

int             valid_header(char *);


#ifdef USEWATTCP
int
tcpwrite( int fd, char *s, int len )
{
    int tlen = 0;

    while ( tlen < len ) {
	if (!tcp_tick(&nntpsock)) {
	    puts("\n\nConnection was reset");
	    exit( 11 );
	}
	tlen += sock_fastwrite( &nntpsock, &s[ tlen ], len - tlen );
	kbhit();	/* process control breaks if necessary */
    }
    return( len );
}
void
usleep()
{
    tcp_tick(NULL);	/* occasionally process something */
}
#endif USEWATTCP

int
main(int argc, char **argv)
{
    startup(argc, argv);
    docommand();
    dumpnewsrc();
    postnews();
    qexit(0);
#ifndef USEWATTCP 	/* unnecessary under WATTCP */
    pcip_exit();   /* this routine does all the 'onexit' processing which has
		    * been called for when initializing the pcip package */
#endif /* USEWATTCP */
    sendmail();	   /* this routine never returns */
    return 0;
}


void
startup(int argc, char **argv)
{
char            buf[STRING];
FILE           *cfgfile;
char           *ptr;
int             i;

#ifdef USEWATTCP
    snuzinit();
#else /* PCIP */
    if (argc == 2 || argc > 3 || (argc == 3 && (!argv[2] ||
				 argv[1][0] != '-' || argv[1][1] != 'S'))) {
	printf("Useage: snuz [-S filename] (-S makes list of newsgroups)\n");
	exit(1);
    }
    ptr = argv[0];
    while (*ptr)
	*ptr++;
    while (*ptr != ':' && *ptr != '\\' && *ptr != '/' && ptr != argv[0])
	*(ptr--) = 0;

    strcpy(buf, argv[0]);
    strcat(buf, "snuz.cfg");
    if ((cfgfile = fopen(buf, "r")) == NULL) {
	printf("can't open snuz.cfg file %s\n", buf);
	exit(1);
    }
    while (1) {
	if (fgets(buf, 126, cfgfile) == NULL)
	    break;
	extract(newsrc, "SNUZRC=", buf);
	extract(serverhost, "NNTPHOST=", buf);
	extract(fromline, "NNTPFROM=", buf);
	extract(editorpath, "EDITOR=", buf);
	extract(tmpdir, "TMP=", buf);
	extract(smtppath, "SMTPPATH=", buf);
    }
    fclose(cfgfile);
    for (i = 0; i < STR; i++) {
	if (newsrc[i] == '\n')
	    newsrc[i] = 0;
	if (serverhost[i] == '\n')
	    serverhost[i] = 0;
	if (fromline[i] == '\n')
	    fromline[i] = 0;
	if (editorpath[i] == '\n')
	    editorpath[i] = 0;
	if (tmpdir[i] == '\n')
	    tmpdir[i] = 0;
	if (smtppath[i] == '\n')
	    smtppath[i] = 0;
    }
    if (!(*serverhost) || !(*fromline) || !(*editorpath) || !(*smtppath)) {
	printf("incomplete snuz.cfg file\n");
	exit(1);
    }
    strcat(tmpdir, "\\");
#endif /* USEWATTCP */

    printf(version);

    if (argc == 3) {
	serverfd = netsocket();
	servf = 0;
	getserv(buf, sizeof buf);
	saveactive(argv[2]);
	qexit(1);
    }
    getnewsrc();
    if (ngroups < 2) {
	printf("You need at least two newsgroups\n");
	exit(1);
    }

    serverfd = netsocket();	/* Note: this call does a lot, including
				 * setting up some important onexit routines. */
    servf = 0;
    getserv(buf, sizeof buf);
    buf[77] = '\0';
    printf("[%s]\n", buf);
}

void
docommand()
{
char            buf[STR];
char           *ptr;
int             cug, nug;
int             ch, i, qhead;
int             skipgroup = 0;
int             noquery = 0;
int             oldquery = 0;
int             noxpost = 1;
int             skipalready = 0;
FILE           *qfile, *ifile;
long            xtime;
unsigned long   ltemp;

    cug = 0;
    cur_article = firsts[0];
    cur_group = -1;
    nug = 1;
    while (1) {
	if (nug) {
	    nug = 0;
	    follow_up_article = 0xffffffff;
	    if (cug < 0) {
		printf(" trying to read before first group  *\n");
		cug = 0;
		cur_article = firsts[cug];
		cur_group = -1;

	    }
	    if (cug >= ngroups) {
		printf(" trying to read after last group  \n");
		cug = ngroups - 1;
		cur_article = firsts[cug];
		cur_group = -1;
	    }
	    if (cug != cur_group) {
		printf("\n %s \n", groups[cug]);
		if (cgroup(groups[cug])) {
		    printf("[invalid or deleted group]\n");
		    if (++bogus >= 30) {
			qexit(10);
		    }
		    groups[cug] = NULL;
		    firsts[cug] = 0;
		    compactgroups();
		    cug++;
		    cur_group = -1;
		    if (cug >= ngroups)
			cug = 0;
		    nug++;
		    continue;
		}
        printf("First: %lu  Last: %lu  Current: %lu\n\n",
		    cur_first, cur_last, firsts[cug] > cur_last ? cur_last :
		       firsts[cug]);
	    }
	    cur_group = cug;
	    if (firsts[cug] < cur_first)
		firsts[cug] = cur_first;
	    if (firsts[cug] > cur_last + 1)
		firsts[cug] = cur_last + 1;
	    if (cur_numa == 0) {
		if (!skipalready || cug >= ngroups - 1 || kbhit()) {
		    printf(" no articles in this group \n");
		    skipgroup = 2;
		} else {
		    cug++;
		    nug++;
		    continue;
		}

	    } else if (cstat(firsts[cug]) && cstat(cur_last)) {
		if (!skipalready || cug >= ngroups - 1 || kbhit()) {
		    printf(" group inaccessible \n");
		    skipgroup = 2;
		} else {
		    cug++;
		    nug++;
		    continue;
		}
	    } else if (firsts[cug] > cur_last) {
		if (!skipalready || cug >= ngroups - 1 || kbhit()) {
		    printf(
			   " already read last article - <RETURN> will skip group \n");
		    skipgroup = 1;
		} else {
		    cug++;
		    nug++;
		    continue;
		}
	    }
	} else {
	    if (cnext()) {
		printf(" End of group %s \n", groups[cug]);
		skipgroup = 2;
		firsts[cug] = cur_last + 1;
	    }
	}
	qhead = chead();
	if (!skipgroup) {
	    if (qhead) {
        printf("[article %lu: bad header]\n", cur_article);
		firsts[cug] = cur_article + 1;
		continue;
	    }
	    if (noxpost && checkx()) {
		firsts[cug] = cur_article + 1;
		continue;
	    }
	}
query:
	{
	    if (noquery)
		ch = 'y';
	    else if (oldquery)
		ch = oldquery;
	    else {
		printf(">");
		ch = ngetc();
	    }
	    oldquery = 0;
	    noquery = 0;
	    if ((skipgroup && ch == '\r') || (skipgroup == 2 && ch == 'y'))
		ch = 'N';

	    skipgroup = 0;


	    switch (ch) {
	    case '?':
	    case 'H':
	    case 'h':
		printf("\n<RETURN> or y - read next article\n");
		printf("= - reread current article\n");
		printf("- - read previous article\n");
		printf("g - go to article #\n");
		printf("q - quit\n");
		printf("e - exit without changing .rc file\n");
		printf("s - save article in file\n");
		printf("a - append article to file\n");
		printf("c - mark all articles in group as read\n");
		printf("P - go to previous newsgroup\n");
		printf("N - go to next newsgroup\n");
		printf("G - go to specified new group \n");
		printf("L - list news groups subscribed to \n");
		printf("i - list index \n");
		printf("I - list index with keyword\n");
		printf("X - toggle reading cross posts\n");
		printf("Z - toggle reading already read groups\n");
		printf("F or f - followup, [F includes text] \n");
		printf("S - Subscribe to new group\n");
                printf("U - unsubscribe current group\n");
                printf("! - shell out to the command shell\n");
                break;
	    case 'q':
		return;
	    case 'X':
		noxpost ^= 1;
		if (noxpost)
		    printf("No cross posts\n");
		else
		    printf("Read cross posts\n");
		break;
	    case 'Z':
		skipalready ^= 1;
		if (skipalready)
		    printf("Skip already read groups\n");
		else
		    printf("Don't skip already read groups\n");
		nug++;
		continue;
	    case 'e':
#ifdef USEWATTCP
                printf("Warning - you selected exit without saving\n");
                printf("          press y if you really wish to do this...");
                if ( toupper( ngetc() ) != 'Y' )
                    break;
#endif USEWATTCP
		qexit(1);
	    case 'y':
	    case '\r':
		strncpy(buf, cur_subject, 80);
		buf[80] = 0;
		do {
		    clearscreen();
            printf("****** (%lu/%lu) [%s]******\n%s\n(%s)    %s\n\n",
		    cur_article, cur_last, groups[cur_group], buf, cur_from,
			   cur_date);
		    follow_up_article = cur_article;
		} while ((oldquery = showbody()) == 'a');
		if (oldquery == 'q' || oldquery < 0 ||
		    (oldquery == '\r' && cur_article == cur_last))
		    oldquery = 0;
		firsts[cug] = cur_article + 1;
		continue;
	    case 's':
	    case 'a':
		if (follow_up_article == 0xffffffff) {
		    printf("Not on an article\n");
		} else {
		    cstat(follow_up_article);
		    chead();
		    (void) savebody(ch == 'a' ? 1 : 0);
		    cstat(cur_article);
		    chead();
		}
		break;
	    case 'c':
		firsts[cug] = cur_last + 1;
		cug++;
		nug++;
		continue;
	    case 'P':
		cug--;
		nug++;
		continue;
	    case 'N':
		cug++;
		nug++;
		continue;
	    case '-':
	    case '=':
		if (follow_up_article != 0xffffffff) {
		    if (ch == '-') {
			if (cur_first != follow_up_article)
			    noquery = 1;
			if (follow_up_article > cur_first)
			    firsts[cug]
				= follow_up_article - 1;
		    } else {
			noquery = 1;
			firsts[cug] = follow_up_article;
		    }
		    nug++;
		    continue;
		}
		printf("Not on an article\n");
		break;
	    case 'g':
		fflush(stdin);
		fflush(stdout);
		printf("Article number >");
		fgets(buf, 20, stdin);
        sscanf(buf, "%lu", &ltemp);
		if ((ltemp <= cur_last)) {
		    firsts[cug] = ltemp;
		    nug++;
		    noquery = 1;
		    continue;
		}
		printf("[article out of range]\n");
		break;
	    case 'S':
		i = getgroup(buf);
		if (i == -2)
		    break;
		if (i != -1) {
		    printf("Already subscribed!!\n");
		} else if ((ptr = malloc(strlen(buf) + 1)) == NULL ||
			   ngroups >= NGROUPS - 2) {
		    printf("Out of memory\n");
		} else {
		    groups[ngroups] = ptr;
		    ptr = buf;
		    while (*ptr == ' ')
			ptr++;
		    strcpy(groups[ngroups], ptr);
		    firsts[ngroups] = 1;
		    cug = ngroups++;
		    cur_group = -1;
		    groups[ngroups] = NULL;
		    nug++;
		    continue;
		}
		break;
	    case 'U':
		if (ngroups <= 2) {
		    printf("too few groups to delete one\n");
		    break;
		}
		groups[cur_group] = NULL;
		firsts[cur_group] = 0;
		compactgroups();
		cug++;
		nug++;
		cur_group = -1;
		if (cug >= ngroups)
		    cug = 0;
		continue;
	    case 'G':
		i = getgroup(buf);
		if (i == -2)
		    break;
		if (i != -1) {
		    cug = i;
		    nug++;
		    continue;
		}
		printf("group not found");
		break;
	    case 'i':
	    case 'I':
		showindex((ch == 'I') ? 1 : 0);
		if (chead())
		    continue;
		break;
	    case 'L':
		listgroups();
		break;
	    case 'F':
	    case 'f':
	    case 'M':
	    case 'm':
		if (follow_up_article == 0xffffffff) {
		    printf("Not on an article\n");
		} else {
		    cstat(follow_up_article);
		    chead();
		    if (!getpost(ch)) {
                        backgroundon();
			errno = 0;
			i = spawnl(P_WAIT, editorpath,
				   editorpath, tmpfil,
				   NULL);
			if (i)
                        printf("error number from spawn = %d (%s)\n",
                                   errno, editorpath);
                        backgroundoff();
			printf("Type y to actually %s article\n",
			       (ch == 'M' || ch == 'm') ? "mail" : "post");
			if ((i = ngetc()) == 'y' || i == 'Y') {
			    /* postnews(); */

			    strcpy(buf, tmpdir);
			    if (ch == 'M' || ch == 'm')
                                strcat(buf, "sendmail.lst");
			    else
				strcat(buf, "postnews.lst");

			    qfile = fopen(buf, "a");
			    if (!qfile) {
				printf("failed\n");
			    } else {
				ifile = NULL;
				strcpy(buf, tmpfil);
				xtime = time(NULL) & 4194303l;
				do {
				    xtime++;
				    if (ifile)
					fclose(ifile);
				    sprintf(tmpfil, "%sx%ld.nuz", tmpdir, xtime);
				} while (ifile = fopen(tmpfil, "r"));
				rename(buf, tmpfil);
				fprintf(qfile, "%s\n", tmpfil);
				fclose(qfile);
			    }
			} else
			    remove(tmpfil);
		    }
		    cstat(cur_article);
		    chead();
		}
		break;
            case '!' :
                shellout();
                break;
	    default:
		printf("[illegal command, try ?]\n");
		break;
	    }
	}
	goto query;
    }
}

void
getserv(char *b, int sb)
{
#ifdef USEWATTCP
    int status;

    /* we are in ascii mode, so it waits for a complete line */
    sock_wait_input( &nntpsock, 45 /* seconds */, NULL, &status );
    sock_gets( &nntpsock, b, sb );
    return( 1 );

sock_err:
    fprintf( stderr, "\n\nSNUZ stopped : %s\n", sockerr( &nntpsock ));
    exit( 20 );
#else /* PCIP */
char           *p = b;
    sb--;
    while (sb > 0) {
	while (!servf) {
	    servp = servb;
	    servf = tcpread(serverfd, servb, sizeof servb);
	}
	if (*servp == '\n') {
	    *b++ = 0;
	    servp++, servf--;
	    break;
	} else if (*servp == '\r')
	    servp++, servf--;
	else
	    *b++ = *servp++, servf--;
    }
#endif /* USEWATTCP */
}
void
putserv(char *b)
{
#ifdef USEWATTCP
    sock_puts( &nntpsock, b );
#else /* PCIP */
    tcpwrite(serverfd, b, strlen(b));
#endif /* USEWATTCP */
}

void
compactgroups()
{
int             i;
    for (i = 0; i < ngroups; i++)
	if (groups[i] == NULL)
	    break;
    if (i != ngroups - 1) {
	for (i++; i < ngroups; i++) {
	    groups[i - 1] = groups[i];
	    firsts[i - 1] = firsts[i];
	}
    }
    ngroups--;
}

void
getnewsrc(void)
{
char            group[STRING];
unsigned long   first;
int             i;
char           *ptr, *ptr2;
FILE           *rec;

    rec = fopen(newsrc, "r");
    if (!rec) {
	perror(newsrc);
	exit(1);
    }
    i = 0;
    while ((i < NGROUPS) && (fscanf(rec, "%s %lu", group, &first) == 2)) {
	ptr2 = group;
	while (*ptr2 == ' ')
	    ptr2++;
	ptr = malloc(strlen(ptr2) + 1);
	if (!ptr) {
	    printf("Out of memory for groups\n");
	    break;
	}
	groups[i] = strcpy(ptr, ptr2);
	firsts[i] = first;
	i++;
    }
    ngroups = i;
}

void 
dumpnewsrc(void)
{
int             i;
FILE           *rec;

    rec = fopen(newsrc, "w");
    for (i = 0; i < ngroups; i++)
	if (groups[i])
        fprintf(rec, "%s %lu\n", groups[i], firsts[i]);
    fclose(rec);
}

int
cgroup(char *s)
{
char            buf[STRING];

    sprintf(buf, "GROUP %s\n", s);
    putserv(buf);
    getserv(buf, sizeof buf);
    sscanf(buf, "%d %lu", &reply, &reparticle);
    if (reply == 411)
	return -1;
    else if (reply == 211) {
    sscanf(buf, "%d %lu %lu %lu %s",
	       &reply, &cur_numa, &cur_first, &cur_last, cur_gname);
	return 0;
    } else
	printf("cgroup: %s\n", buf);
    return -1;
}

cstat(i)
    unsigned long   i;
{
char            buf[STRING], *p, *q;

    sprintf(buf, "STAT %lu\n", i);
    putserv(buf);
    getserv(buf, sizeof buf);
    sscanf(buf, "%d %lu", &reply, &reparticle);
    if (reply == 423)
	return -1;
    else if (reply == 223) {
	cur_article = reparticle;
	p = buf;
	q = cur_articleid;
	while ((p < buf + STRING - 2) && (*p != '<'))
	    p++;
	while ((p < buf + STRING - 2) && (*p != '>'))
	    *q++ = *p++;
	*q++ = '>';
	*q++ = '\0';
	return 0;
    } else
	printf("cstat: %s\n", buf);
    return -1;
}

#if 0
int
current(void)
{
char            buf[STRING], *p, *q;

    sprintf(buf, "STAT\n");
    putserv(buf);
    getserv(buf, sizeof buf);
    sscanf(buf, "%d %lu", &reply, &reparticle);
    if (reply == 423)
	return -1;
    else if (reply == 412)
	return -1;
    else if (reply == 223) {
	cur_article = reparticle;
	p = buf;
	q = cur_articleid;
	while ((p < buf + STRING - 2) && (*p != '<'))
	    p++;
	while ((p < buf + STRING - 2) && (*p != '>'))
	    *q++ = *p++;
	*q++ = '>';
	*q++ = '\0';
	return 0;
    } else
	printf("current: %s\n", buf);
    return -1;
}
#endif

int
cnext(void)
{
char            buf[STRING], *p, *q;

    sprintf(buf, "NEXT\n");
    putserv(buf);
    getserv(buf, sizeof buf);
    sscanf(buf, "%d %lu", &reply, &reparticle);
    if (reply == 421)
	return -1;
    else if (reply == 223) {
	cur_article = reparticle;
	p = buf;
	q = cur_articleid;
	while ((p < buf + STRING - 2) && (*p != '<'))
	    p++;
	while ((p < buf + STRING - 2) && (*p != '>'))
	    *q++ = *p++;
	*q++ = '>';
	*q++ = '\0';
	return 0;
    } else
	printf("cnext: %s\n", buf);
    return -1;
}

int
extract(char *to, char *key, char *from)
{
    if (!strncmp(from, key, strlen(key))) {
	from += strlen(key);
	while (*from == ' ')
	    from++;
	strcpy(to, from);
	return 1;
    } else
	return 0;
}

chead()
{
char            buf[STRING];

    *cur_path = 0;
    *cur_from = 0;
    *cur_replyto = 0;
    *cur_subject = 0;
    *cur_newsgroups = 0;
    *cur_message_ID = 0;
    *cur_references = 0;
    *cur_date = 0;

    sprintf(buf, "HEAD %lu\n", cur_article);
    putserv(buf);
    getserv(buf, sizeof buf);
    sscanf(buf, "%d %lu", &reply, &reparticle);
    if (reply == 423)
	return -1;
    else if (reply == 221)
	while (1) {
	    getserv(buf, sizeof buf);
	    if (!strcmp(buf, ".")) {
		if (!*cur_replyto)
		    strcpy(cur_replyto, cur_from);
		return 0;
	    }
	    extract(cur_path, "Path:", buf) ||
		extract(cur_from, "From:", buf) ||
		extract(cur_subject, "Subject:", buf) ||
		extract(cur_replyto, "Reply-To:", buf) ||
		extract(cur_newsgroups, "Newsgroups:", buf) ||
                extract(cur_message_ID, "Message-ID:", buf) ||
		extract(cur_references, "References:", buf) ||
		extract(cur_date, "Date:", buf);
    } else
	printf("chead: %s\n", buf);
    return -1;
}
int
showbody(void)
{
char            buf[STRING];
int             line = 0;
int             ch;

    sprintf(buf, "BODY %lu\n", cur_article);
    putserv(buf);
    getserv(buf, sizeof buf);
    sscanf(buf, "%d %lu", &reply, &reparticle);
    if (reply == 423)
	return -1;
    else if (reply == 222)
	while (1) {
	    if (line == 18) {
		reversevideo("more(<SPACE> to continue)?");
		fflush(stdout);
		ch = ngetc();
		if (ch != ' ') {
		    while (getserv(buf, sizeof buf), strcmp(buf, "."));
		    normalvideo();
		    return ch;
		}
		backline();
		line = 0;
	    }
	    getserv(buf, sizeof buf);
	    if (strcmp(buf, ".")) {
		printf("%s", buf);
		if (strlen(buf) != 80)
		    printf("\n");
	    } else {
		reversevideo(" End of article ");
		printf("\n");
		normalvideo();
		return 0;
	    }
	    line++;
    } else
	printf("showbody: %d %s\n", reply, buf);
    return -1;
}

int
savebody(int type)
{
char            buf[STRING];
FILE           *f;
char            sss[72];
char           *s, *ss;


    s = &sss[0];
    fflush(stdin);
    fflush(stdout);
    printf("Filename >");
    fgets(s, 70, stdin);

    sss[71] = '\n';
    while (*s == ' ')
	s++;
    ss = s;
    while (*ss != '\n')
	ss++;
    *ss = 0;
    if (!(f = fopen(s, type ? "a" : "w"))) {
	perror(s);
	return -1;
    }
    sprintf(buf, "BODY %lu\n", cur_article);
    putserv(buf);
    getserv(buf, sizeof buf);
    sscanf(buf, "%d %lu", &reply, &reparticle);
    if (reply == 423)
	goto badsave;
    else if (reply == 222) {
	fprintf(f, "Subject: %s\n", cur_subject);
	fprintf(f, "From: %s\n", cur_from);
	fprintf(f, "Path: %s\n", cur_path);
	fprintf(f, "Reply-To: %s\n", cur_replyto);
	fprintf(f, "Newsgroups: %s\n", cur_newsgroups);
	fprintf(f, "Message-ID: %s\n", cur_message_ID);
	fprintf(f, "References: %s\n", cur_references);
	fprintf(f, "Date: %s\n", cur_date);
	fprintf(f, "\n");
	while (1) {
	    getserv(buf, sizeof buf);
	    if (strcmp(buf, "."))
		fprintf(f, "%s\n", buf);
	    else
		break;
	}
	fclose(f);
	return 0;
    } else
	printf("savebody: %d %s\n", reply, buf);
badsave:
    fclose(f);
    return -1;
}

int
saveactive(char *s)
{
char            buf[256];
FILE           *f;

    if (!(f = fopen(s, "w"))) {
	perror(s);
	return -1;
    }
    sprintf(buf, "LIST\n");
    putserv(buf);
    getserv(buf, sizeof buf);
    sscanf(buf, "%d %lu", &reply, &reparticle);
    if (reply == 215) {
	while (1) {
char            group[256];
unsigned long   to, from;
char            act;

	    getserv(buf, sizeof buf);
	    if (!strcmp(buf, "."))
		break;
        sscanf(buf, "%s %lu %lu %c", group, &to, &from, &act);
        fprintf(f, "%s %lu\n", group, to);
	}
	fclose(f);
	return 0;
    } else
	printf("saveactive: %d %s\n", reply, buf);
    fclose(f);
    return -1;
}

int
netsocket(void)
{
#ifdef USEWATTCP
longword host;

    if (!(host = resolve( serverhost ))) {
	fprintf(stderr, "Could not resolve '%s'\n", serverhost );
	exit(9);
    }
    if ( !tcp_open( &nntpsock, 0, host, 119, NULL )) {
	fprintf(stderr, "tcpopen failed\n");
	exit(9);
    }
    sock_mode( &nntpsock, TCP_MODE_ASCII );
    return( 1 );	/* bogus serverfd */

#else /* PCIP */
int             fd;

    if ((fd = tcpopen(serverhost, 119)) < 0) {
	fprintf(stderr, "tcpopen failed\n");
	exit(9);
    }
    return (fd);
#endif /* USEWATTCP */
}

int
getgroup(char *buf)
{
char           *s, *ss;
int             i;

    fflush(stdin);
    fflush(stdout);
    printf("New group >");
    fgets(buf, 70, stdin);
    if (*buf == 0 || *buf == '\n')
	return -2;

    s = &buf[0];

    buf[71] = '\n';
    while (*s == ' ')
	s++;
    ss = s;
    while (*ss != '\n')
	ss++;
    *ss = 0;

    for (i = 0; i < ngroups; i++) {
	if (!strcmp(s, groups[i]))
	    return i;
    }
    return -1;
}

void
listgroups(void)
{
int             line = 0;
int             ch, i;

    printf("\n\n");
    for (i = 0; i < ngroups; i++) {
	if (line == 18) {
	    reversevideo("more(<RETURN> or <SPACE> to continue, q or . to quit)?");
	    fflush(stdout);
	    ch = ngetc();
	    if (ch == 'q' || ch == '.') {
		normalvideo();
		return;
	    }
	    backline();
	    line = 0;
	}
    printf(" %s   %lu\n", groups[i], firsts[i]);
	line++;
    }
}

int
showindex(int flag)
{
char            buf[80], test_string[80], test_string2[150];
int             line = 0;
int             ch, i, j;
unsigned long   save_article;

    if (flag) {
	printf("Enter matching string: ");
	fgets(test_string, 78, stdin);
	for (i = 0; test_string[i] != 0; i++) {
	    if (test_string[i] == '\n')
		test_string[i] = 0;
	    if (test_string[i] >= 'a' && test_string[i] <= 'z')
		test_string[i] -= 'a' - 'A';
	}
    }
    save_article = cur_article;
    if (cur_article < cur_first)
	cur_article = cur_first;
    printf("\n\n");
    for (; cur_article <= cur_last; cur_article++) {
	if (line == 18) {
	    reversevideo("more(<RETURN> or <SPACE> to continue, q or . to quit)?");
	    fflush(stdout);
	    ch = ngetc();
	    if (ch == 'q' || ch == '.') {
		cur_article = save_article;
		normalvideo();
		return 0;
	    }
	    backline();
	    line = 0;
	}
	if (chead())
	    continue;
	strncpy(buf, cur_subject, 70);
	buf[70] = 0;


	if (flag) {
	    strcpy(test_string2, buf);
	    strncat(test_string2, cur_from, 70);
	    for (j = 0; j < 145 && test_string2[j] != 0; j++) {
		if (test_string2[j] >= 'a' && test_string2[j] <= 'z')
		    test_string2[j] -= 'a' - 'A';
	    }
	}
	test_string2[j] = 0;
	if (!flag || strstr(test_string2, test_string)) {
        printf("%lu%c %s\n",
		   cur_article, checkx() ? '*' : ' ', buf);
	    fflush(stdout);
	    line++;
	}
    }
    cur_article = save_article;
    return 0;
}

int
getpost(int f)
{

char            buf[STRING];
FILE           *ifile = NULL;

    sprintf(tmpfil, "%stmp.nuz", tmpdir);

    ifile = fopen(tmpfil, "w");
    if (!ifile) {
	printf("Can't open temporary file \n");
	return 1;
    }
    fprintf(ifile, "From: %s\n", fromline);
    if (f == 'm' || f == 'M') {
	fprintf(ifile, "To: %s\n", (cur_replyto != NULL) ?
		cur_replyto : cur_from);
    }
    if (!strncmp(cur_subject, "Re:", 3))
	fprintf(ifile, "Subject: %s\n", cur_subject);
    else
	fprintf(ifile, "Subject: Re: %s\n", cur_subject);

    if (f == 'f' || f == 'F') {
	fprintf(ifile, "Newsgroups: %s\n", cur_newsgroups);
	fprintf(ifile, "Summary: \nFollowup-To: \nDistribution: \n");
	/* fprintf(ifile, "Date: %s\n", cur_date); */
	fprintf(ifile, "References: %s", cur_message_ID);
	if (cur_references)
	    fprintf(ifile, " %s", cur_references);
	fprintf(ifile, "\n");
    }
    fprintf(ifile, "\n\n");


    if (f == 'F' || f == 'M') {
	fprintf(ifile, "In article %s %s writes:\n", cur_message_ID, cur_from);

    sprintf(buf, "BODY %lu\n", cur_article);
	putserv(buf);
	getserv(buf, sizeof buf);
    sscanf(buf, "%d %lu", &reply, &reparticle);
	if (reply == 222) {
	    while (1) {
		getserv(buf, sizeof buf);
		if (strcmp(buf, ".")) {
		    fprintf(ifile, ">%s\n", buf);
		} else
		    break;
	    }
	} else {
	    printf("savebody error: %d %s\n", reply, buf);
	    fclose(ifile);
	    return 1;
	}
    }
    fclose(ifile);
    return 0;
}




int
postnews(void)
{

char            buf[STRING], s[STRING], fbuf[STR];
int             seen_fromline, in_header, seen_header;
FILE           *ifile, *pfile;
char           *cp, *bp;
int             count, i;
char            curmessageid[ STRING ];
long            clock;


    strcpy(fbuf, tmpdir);
    strcat(fbuf, "postnews.lst");
    pfile = fopen(fbuf, "r");
    if (!pfile) {
	printf("No News to post\n");
	return 1;
    } else
	printf("Now trying to post your News\n");

    while (1) {
	if (fgets(fbuf, 126, pfile) == NULL)
	    break;
	for (i = 0; fbuf[i]; i++)
	    if (fbuf[i] == '\n')
		fbuf[i] = 0;

	ifile = fopen(fbuf, "r");
	if (!ifile) {
	    printf("Can't open temporary file %s\n", fbuf);
	    continue;
	}
	putserv("POST\n");
	getserv(buf, sizeof buf);
printf("POSTING: %s\n", buf );
	if (*buf != '3') {
	    if (atoi(buf) == 440) {
		printf("No posting!\n");
	    } else {
		printf("Remote error: %s\n", buf);
	    }
	    fclose(pfile);
	    fclose(ifile);
	    return 0;
	}
        printf("Sending file\n");


	in_header = 1;
	seen_header = 0;
	seen_fromline = 0;

#ifdef USEWATTCP
        while (fgets(s, 510, ifile) != NULL ) {
            if (s[0] == '.' && s[1] == 0 ) {
                s[1] = '.';
                s[2] = 0;
            }
            strcat( s, "\n");
            tcpwrite(serverfd, s, strlen(s));

            if (in_header && !strnicmp(s, "From:", sizeof("From:") - 1)) {
		seen_header = 1;
		seen_fromline = 1;
	    }

            if (in_header && s[0] == 0) {
		if (seen_header) {
		    in_header = 0;
		    if (!seen_fromline) {
			strcpy(s, "From: ");
			strcpy(s, fromline);
                        strcat(s, "\n");
                        tcpwrite(serverfd, s, strlen(s));
		    }
#ifdef USEWATTCP
                    /* add message id */
                    time( &clock );
                    inet_ntoa( s, gethostid());
                    sprintf( curmessageid,"Message-ID: <%lu@%s>\n", clock,s );
                    tcpwrite( serverfd, curmessageid, strlen( curmessageid ));
#endif USEWATTCP
		} else {
		    continue;
		}
	    } else if (in_header) {
		if (valid_header(s))
		    seen_header = 1;
		else
		    continue;
	    }
	}

	fclose(ifile);

        tcpwrite(serverfd, ".\n", 2 );

#else /* PCIP */

	count = 0;
	bp = buf;
	while (fgets(s, 510, ifile) != NULL) {
	    s[511] = '\n';
	    cp = s;
	    while (*cp != '\n')
		cp++;
	    *cp = 0;
	    if (s[0] == '.') {	/* Single . is eof, so put in extra one */
		*bp++ = '.';
		if (++count == 512) {
		    tcpwrite(serverfd, buf, 512);
		    count = 0;
		    bp = buf;
		}
	    }
	    if (in_header && !strnicmp(s, "From:", sizeof("From:") - 1)) {
		seen_header = 1;
		seen_fromline = 1;
	    }
	    if (in_header && s[0] == '\0') {
		if (seen_header) {
		    in_header = 0;
		    if (!seen_fromline) {
			strcpy(s, "From: ");
			strcpy(s, fromline);
			strcat(s, "\r\n");
		    }
		} else {
		    continue;
		}
	    } else if (in_header) {
		if (valid_header(s))
		    seen_header = 1;
		else
		    continue;
	    }
	    cp = s;
	    while (*cp) {
		*bp++ = *cp++;
		if (++count == 512) {
		    tcpwrite(serverfd, buf, 512);
		    count = 0;
		    bp = buf;
		}
	    }
	    cp = "\r\n";
	    while (*cp) {
		*bp++ = *cp++;
		if (++count == 512) {
		    tcpwrite(serverfd, buf, 512);
		    count = 0;
		    bp = buf;
		}
	    }
	}

	fclose(ifile);

	cp = ".\r\n";
	while (*cp) {
	    *bp++ = *cp++;
	    if (++count == 512) {
		tcpwrite(serverfd, buf, 512);
		count = 0;
		bp = buf;
	    }
	}

	if (count) {
	    tcpwrite(serverfd, buf, count);
	}
#endif /* USEWATTCP */
	printf("waiting for reply\n");
	(void) getserv(buf, sizeof(buf));
	printf("got reply\n");
printf("POSTING: %s\n", buf );

	if (*buf != '2') {
	    if (atoi(buf) == 441) {
		printf("Article not accepted by server; not post*ed.\n");
		for (cp = buf + 4; *cp && *cp != '\r'; cp++)
		    if (*cp == '\\')
			putchar('\n');
		    else
			putchar(*cp);
		fclose(pfile);
		return 0;
	    } else {
		printf("Remote error: %s\n", buf);
		fclose(pfile);
		return 0;
	    }
	}
	remove(fbuf);
    }
    strcpy(fbuf, tmpdir);
    strcat(fbuf, "postnews.lst");
    remove(fbuf);
    return 0;
}




int
valid_header(char *h)
{
char           *colon, *space;

    /*
     * blank or tab in first position implies this is a continuation header
     */
    if (h[0] == ' ' || h[0] == '\t')
	return (1);

    /*
     * just check for initial letter, colon, and space to make sure we
     * discard only invalid headers
     */
    colon = strchr(h, ':');
    space = strchr(h, ' ');
    if (isalpha(h[0]) && colon && space == colon + 1)
	return (1);

    /*
     * anything else is a bad header -- it should be ignored
     */
    return (0);
}



void
qexit(int n)
{
char            buf[512];

    if (n >= 10)
	printf("Horrible error: read manual \n");
    fflush(stdout);
    putserv("QUIT\n");
    getserv(buf, sizeof buf);
    if (*buf != '2')
	printf("Tried to quit, but failed\n");
    if (n)
	exit(n);
}


int
checkx(void)
{
char            buf[256];
int             i, k;
char           *ptr, *ptr2, *ptr3;

    if (cur_group == 0)
	return 0;
    ptr = cur_newsgroups;
    while (*ptr == ' ')
	ptr++;
    k = 0;
    while (1) {
	if (*ptr == 0)
	    break;
	if (*ptr == ',')
	    ptr++;
	while (*ptr == ' ')
	    ptr++;
	ptr2 = ptr;
	ptr3 = buf;
	while (*ptr2 != 0 && *ptr2 != ',')
	    *ptr3++ = *ptr2++;
	*ptr3 = 0;
	while (*(--ptr3) == ' ')
	    *ptr3 = 0;
	ptr = ptr2;
	for (i = 0; i < cur_group; i++) {
	    if (strcmp(buf, groups[i]) == 0)
		return 1;
	}
    }
    return 0;
}
void
sendmail()
{
char            buf[STR];
FILE           *mfile;
int             i;

    strcpy(buf, tmpdir);
    strcat(buf, "sendmail.lst");

    mfile = fopen(buf, "r");
    fclose(mfile);

    if (mfile != NULL) {
	printf("Sending mail\n");
	for (i = 0; i < 10; i++)
	    usleep();
	spawnl(P_OVERLAY, smtppath, smtppath, buf, serverhost, NULL);
	/* this does not normally return, but might if some spawn error */
    } else {
	printf("No mail to process\n");
	for (i = 0; i < 4; i++)
	    usleep();
    }
    xabort();	   /* don't do onexit processing, we already did it */
}

char tempstack[ 4096 ];
int oldss, oldsp;
void interrupt (*oldinterrupt)();
static int inside = 0;
void interrupt newinterrupt()
{
    (*oldinterrupt)();
    disable();
    if (!inside) {
        inside = 1;
        oldss = _SS;
        oldsp = _SP;
        _SP = FP_OFF( &tempstack[ sizeof( tempstack ) - 4 ] );
        _SS = FP_SEG( tempstack );
        enable();
        tcp_tick( NULL );
        disable();
        _SP = oldsp;
        _SS = oldss;
        inside = 0;
    }
    enable();
}

void
backgroundon(void)
{
    oldinterrupt = getvect( 0x08 );
    setvect( 0x08, newinterrupt );
}
void
backgroundoff(void)
{
    setvect( 0x08, oldinterrupt );
}


void
shellout(void)
{
    char *temp;

    backgroundon();
    temp = getenv( "COMSPEC");
    if ( system(temp) == -1 )
        printf("\nUnable to shell out to dos (%s)",temp);
    backgroundoff();
    return;
}


void (*oldinit)();
localinit( char *name, char *value)
{
    if (!strcmp( name, "SNUZ.RC"))   strcpy(newsrc, value );
    else if (!strcmp( name, "SNUZ.HOST")) strcpy(serverhost, value );
    else if (!strcmp( name, "SNUZ.FROM")) strcpy(fromline, value );
    else if (!strcmp( name, "SNUZ.EDITOR")) strcpy(editorpath, value );
    else if (!strcmp( name, "SNUZ.TMPDIR")) strcpy(tmpdir, value );
    else if (!strcmp( name, "SNUZ.SMTP")) strcpy(smtppath, value );
    else if (!strcmp( name, "SNUZ.RC")) strcpy( newsrc, value );
    else (*oldinit)(name,value);
}
void
snuzinit(void)
{
    oldinit = usr_init;
    usr_init = localinit;

    *serverhost = *fromline = *editorpath = *tmpdir = *smtppath = 0;

    printf("Configuring...\n");
    sock_init();
    clrscr();
    if (!*serverhost || !*fromline || !*editorpath || !*smtppath || !*newsrc) {
        fprintf(stderr, "incomplete configuration missing WATTCP.CFG line:\n");
        if (!*serverhost) fprintf(stderr,"SNUZ.HOST=... must be ip address or name of news server\n");
        if (!*fromline)   fprintf(stderr,"SNUZ.FROM=... must be the user's name\n");
        if (!*editorpath) fprintf(stderr,"SNUZ.EDITOR=... must specify an editor and path\n");
        if (!*smtppath)   fprintf(stderr,"SNUZ.SMTP=...\n");
        if (!*newsrc)     fprintf(stderr,"SNUZ.RC=... must point to a news.rc file\n");
        exit(1);
    }
}

