#!/bin/bash
set -e

if [[ "$1" =~ ^[0-9]{8}$ ]] ; then
  VERSION="$1"
fi


if [ "x$VERSION" = "x" ] ; then
  echo "./release.sh version_string (example: ./release.sh 20250101)"
  exit 1
fi

rm -f ethflop-$VERSION-dos.zip ethflop-$VERSION-src.zip ethflop-$VERSION.svp

zip -9rkDX ethflop-$VERSION-dos.zip ethflop.com ethflop.txt history.txt
zip -9rkDX ethflop-$VERSION-src.zip *.asm *.bat *.sh *.txt

mkdir -p drivers/ethflop
cp ethflop.com drivers/ethflop
cp ethflop.txt drivers/ethflop
cp history.txt drivers/ethflop
mkdir appinfo
echo "version: $VERSION" > appinfo/ethflop.lsm
echo "description: emulates a floppy disk from a diskette image over Ethernet" >> appinfo/ethflop.lsm

zip -9rkDX -m ethflop-$VERSION.svp appinfo drivers

rmdir appinfo
rmdir -p drivers/ethflop
