; E100PKT, packet driver for DOS
; Copyright (C) 2018, Seth Simon (sethsimon@sdf.org)
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see
; <https://www.gnu.org/licenses/>.

;===========================
;=======             =======
;       F_DRIVER_INFO
;=======             =======
;===========================
f_driver_info:
    ; AL = 255
    ; BX = handle (optional)
    ;
    ; On error, returns CF=1 and DH=error code
    ; Otherwise returns
    ;   BX = version
    ;   CH = class
    ;   DX = type
    ;   CL = number
    ;   DS:SI = name
    ;   AL = functionality
    cmp     al, 255
    mov     bl, ERROR_BAD_COMMAND
    jc      .done
    push    cs
    pop     ds

    mov     ax, 1
    xchg    ax, word [bp]       ; Version 0.1. AX := optional handle
    mov     dx, -1              ; Type = wildcard

    ; Use the handle's if_class if available, else DIX
    call    verify_handle   ; CF=0 if valid
    cmc
    sbb     ch, ch          ; -1 if valid, else 0
    xchg    ax, si
    inc     si
    and     ch, byte [si]   ; handle's if_class if valid, else 0
    mov     ax, 0x0101      ; Restore AH, AL = functionality = basic
    or      ch, ah          ; no change if valid, else 1

    mov     cl, 0           ; if_number = 0
    mov     si, tsr.sig2    ; DS:SI = name
.done:
    ret

