; E100PKT, packet driver for DOS
; Copyright (C) 2018, Seth Simon (sethsimon@sdf.org)
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see
; <https://www.gnu.org/licenses/>.

;==============================
;=======                =======
;       GET_ARGS_OR_QUIT
;=======                =======
;==============================
get_args_or_quit:
    ; Returns AL = number (0 means unload, 1 means dump), AH = 0
    
    ; 0x80 has strlen of args, 0x81 has args
    mov     dx, usage_str
    mov     si, 0x80
    lodsb
    cmp     al, 0
    je      print_message_and_quit

    call    eat_spaces
    or      ax, 0x2002  ; 10.1101 (-) becomes 10.1111 (/)
                        ; Lowercase or mangle the second character
    cmp     al, '/'
    jne     print_message_and_quit

    cmp     ah, 'h'
    je      print_message_and_quit_okay
    cmp     ah, '?'
    je      print_message_and_quit_okay

    ; /V => Do nothing since the copyright message has the version
    cmp     ah, 'v'
    je      quit_okay

    cmp     ah, 'd'
    je      .dump

    cmp     ah, 'u'
    jne     .parse_install_args_or_quit
    call    eat_spaces
    cmp     al, 0xd
    jne     print_message_and_quit
    xor     ax, ax
    ret

.dump:
    mov     ax, 1
    ret

.parse_install_args_or_quit:
    cmp     ah, 'i'
    jne     print_message_and_quit

    ; Get int_no
    call    eat_spaces
    call    atoi
    jc      print_message_and_quit
    sub     ah, ah
    mov     byte [pkt_int], al

    ; Make sure int_no is 60-66, 68-6f, or 7b-7e
    cmp     al, 0x60
    jb      print_message_and_quit
    cmp     al, 0x67
    je      print_message_and_quit
    cmp     al, 0x6f
    jbe     .ok

    cmp     al, 0x7b
    jb      print_message_and_quit
    cmp     al, 0x7e
    jnbe    print_message_and_quit

.ok:
    push    ax
    call    eat_spaces
    cmp     al, 0xd
    jne     print_message_and_quit
    pop     ax
    ret

;========================
;=======          =======
;       EAT_SPACES
;=======          =======
;========================
eat_spaces:
    ; DS:SI = pointer to possible space (in/out)
    ; Returns AL = first char after space
    ;         AH = second char after space
    dec     si
.loop:
    inc     si
    cmp     byte [si], ' '
    je      .loop

    lodsw
    ret


usage_str:
    db `Usage: e100pkt <option>\r\n`
    db `\r\n`
    db `Options are case-insensitive, but must begin with / or -.\r\n`
    db `All numbers are in hex, without a leading 0x.\r\n`
    db `\r\n`
    db `Options:\r\n`
    db `    /h\r\n`
    db `    /?\r\n`
    db `        Show help\r\n`
    db `\r\n`
    db `    /v\r\n`
    db `        Show version\r\n`
    db `\r\n`
    db `    /u\r\n`
    db `        Unload the packet driver\r\n`
    db `\r\n`
    db `    /i <int_no>\r\n`
    db `        Install the packet driver.\r\n`
    db `        <int_no> is 60-66, 68-6f, or 7b-7e (inclusive).\r\n`
    db `\r\n`
    db `    /d\r\n`
    db `        Dump PCI Configuration Space to E100.PCI\r\n`
    db `        Dump EEPROM to E100.EEP\r\n`
    db `        Dump CSR to E100.CSR\r\n`
    db `$`

