/**
*	Global variables
*/
p_bitmap GSWallpaper		= NULL;

PLabel Lbl = NULL;

/**
*	NAME: WallpaperDraw
*	DESCRIPTION: Draws the wallpaper to screen
*	RETURN: NONE
*/
void WDraw ( PWidget o, p_bitmap buffer, PRect w )
{
	if (!w)
	{
		w = &o->Absolute;
	}

	blit(GSWallpaper, buffer, w->a.x, w->a.y, w->a.x, w->a.y, w->b.x-w->a.x+1, w->b.y-w->a.y+1);
}

l_bool WEventHandler ( PWidget o, PEvent Event )
{
	if (Event->Type == EV_MESSAGE)
	{
		if (Event->Message == DM_PROPERTIES)
		{
			FileRun("xapps/setwall.app", 0);
		}
	}

	if (Event->Type == EV_MOUSE)
	{
		if (Event->Message == WEvMouseRUp)
		{
			PMenu DeskMenu = NewMenu(NewMenuItem("Properties", NULL, DM_PROPERTIES, NULL, NULL, NULL));

			PopUpMenu(&Me, Mouse->State.p, DeskMenu, WIDGET(DeskTop), 1);

			return true;
		}
	}


	return false;
}


/**
*	NAME: WallpaperInit
*	DESCRIPTION: Loads the wallpaper, blits it on the wallpaper bitmap with the
*					selected Style.
*	RETURN: NONE
*/
void WallpaperInit ( void )
{
	l_int Style = KeyGetInt("/USER/DESKTOP/alignment", 0);
	l_text wallpaper = KeyGetText("/USER/DESKTOP/wallpaper", "");
	p_bitmap BMP;

	if ( TextLen(wallpaper) )
		BMP = LoadImage(wallpaper);
	else
		BMP = NULL;

	if (BMP)
	{
		GSWallpaper = create_bitmap(GSScreenWidth, GSScreenHeight);

		if ( Style == 1 )
		{
			/**
			*	Tile wallpaper
			*/
			l_int x;
			l_int y;

			for ( x = 0; x < GSScreenWidth; x += BMP->w)
				for ( y = 0; y < GSScreenHeight; y += BMP->h)
    				blit(BMP, GSWallpaper, 0, 0, x, y, BMP->w, BMP->h);
		}
		else if ( Style == 2 )
		{
			/**
			*	Stretch wallpaper
			*/

			stretch_blit (BMP, GSWallpaper, 0, 0, BMP->w, BMP->h, 0, 0, GSWallpaper->w, GSWallpaper->h);
		}
		else
		{
    		/**
			*	Draw normal size
			*/
			blit(BMP , GSWallpaper, 0,0, (GSScreenWidth - BMP->w  )/2 , (GSScreenHeight -BMP->h  )/2, GSScreenWidth, GSScreenHeight );
		}

		destroy_bitmap(BMP);



		textprintf(GSWallpaper, default_font, GSScreenWidth-350, GSScreenHeight-62, makecol(0,0,0),"%s %d.%d.%d.%d",KernelName,ULID_A(SystemApp.Version),ULID_B(SystemApp.Version),ULID_C(SystemApp.Version),ULID_D(SystemApp.Version));
		textprintf(GSWallpaper, default_font, GSScreenWidth-350, GSScreenHeight-47, makecol(0,0,0),KernelCopyright);

		textprintf(GSWallpaper, default_font, GSScreenWidth-350, GSScreenHeight-60, makecol(0,0,0),"%s %d.%d.%d.%d",KernelName,ULID_A(SystemApp.Version),ULID_B(SystemApp.Version),ULID_C(SystemApp.Version),ULID_D(SystemApp.Version));
		textprintf(GSWallpaper, default_font, GSScreenWidth-350, GSScreenHeight-45, makecol(0,0,0),KernelCopyright);

		textprintf(GSWallpaper, default_font, GSScreenWidth-351, GSScreenHeight-61, makecol(0,0,0),"%s %d.%d.%d.%d",KernelName,ULID_A(SystemApp.Version),ULID_B(SystemApp.Version),ULID_C(SystemApp.Version),ULID_D(SystemApp.Version));
		textprintf(GSWallpaper, default_font, GSScreenWidth-351, GSScreenHeight-46, makecol(0,0,0),KernelCopyright);

		textprintf(GSWallpaper, default_font, GSScreenWidth-349, GSScreenHeight-61, makecol(0,0,0),"%s %d.%d.%d.%d",KernelName,ULID_A(SystemApp.Version),ULID_B(SystemApp.Version),ULID_C(SystemApp.Version),ULID_D(SystemApp.Version));
		textprintf(GSWallpaper, default_font, GSScreenWidth-349, GSScreenHeight-46, makecol(0,0,0),KernelCopyright);

		textprintf(GSWallpaper, default_font, GSScreenWidth-350, GSScreenHeight-61, makecol(250,250,250),"%s %d.%d.%d.%d",KernelName,ULID_A(SystemApp.Version),ULID_B(SystemApp.Version),ULID_C(SystemApp.Version),ULID_D(SystemApp.Version));
		textprintf(GSWallpaper, default_font, GSScreenWidth-350, GSScreenHeight-46, makecol(250,250,250),KernelCopyright);

		DeskTop->Draw = &WDraw;

		if ( Lbl )
			WidgetDispose(WIDGET(Lbl));

		Lbl = NULL;


	} else {
		TRect r;

		DeskTop->BackgroundColor = GetColorFromHex(KeyGetText("/USER/DESKTOP/color", "3D61AD"));

		if ( !Lbl ) {
			RectAssign(&r,GSScreenWidth-350,GSScreenHeight-60,GSScreenWidth-1,GSScreenHeight-35);
			Lbl = CreateLabel(&Me, r, "");
			WIDGET(Lbl)->BackgroundColor = DeskTop->BackgroundColor;
			Lbl->FontColor = makecol(250,250,250);
			InsertWidget(DeskTop, WIDGET(Lbl));
		}


		LabelSetText(Lbl,"%s %d.%d.%d.%d\n%s",
		SystemApp.Name,ULID_A(SystemApp.Version),ULID_B(SystemApp.Version),
		ULID_C(SystemApp.Version),ULID_D(SystemApp.Version),KernelCopyright);

		DeskTop->Draw = NULL;

		WidgetDraw(WIDGET(Lbl), NULL);
	}

	DeskTop->EventHandler = &WEventHandler;

		WidgetDraw(DeskTop, NULL);

}

void WallpaperReLoad ( void ) {
	if ( GSWallpaper ) destroy_bitmap(GSWallpaper);
	WallpaperInit();
}

void GSWallpaperDestroy()
{
	if ( GSWallpaper ) destroy_bitmap(GSWallpaper);
}
