unit menucode;

interface

function InputString(X, Y, Color : Byte) : String;
function MainMenu : Boolean;

Const
  Diff : Array[0..2] of String = ('easy', 'normal', 'hard');

implementation

uses
  graphics, grafdata, smallcrt, hiscores, gamecode, dos;

Const
  c_CursorSpeed = 10;

  { enumeration of shift codes }
  sc_Insert     = 128;
  sc_CapsLock   = 64;
  sc_NumLock    = 32;
  sc_ScrollLock = 16;
  sc_Alt        = 8;
  sc_Ctrl       = 4;
  sc_LeftShift  = 2;
  sc_RightShift = 1;

function Shiftstate(ShiftCode : Byte) : boolean;
var
  regs : Registers;
begin
  FillChar (regs, SizeOf(regs), 0);
  regs.ah := $02;
  Intr ($16, regs);
  Shiftstate := (regs.al and ShiftCode) = ShiftCode;
end;

Function IsSmiley(First, Second : Char) : Char;
{ evaluates if a string[2] is a smiley,
  if so it returns the charactercode of that smiley
  if not it returns the charactercode of the second char. }
Var
 tmpSmiley : String;
Begin
  IsSmiley := Second;
  { for reference: = =:) =;) =:( =:D =:o =:| =8) =heart }
  tmpSmiley := First + Second; {combine the two characters for easy compare }
  If (tmpSmiley = ':)') Then IsSmiley := ''; { chr(128) }
  If (tmpSmiley = ';)') Then IsSmiley := ''; { chr(129) }
  If (tmpSmiley = ':(') Then IsSmiley := ''; { chr(130) }
  If (tmpSmiley = ':D') Then IsSmiley := ''; { chr(131) }
  If (tmpSmiley = ':o') Then IsSmiley := ''; { chr(132) }
  If (tmpSmiley = ':|') Then IsSmiley := ''; { chr(133) }
  If (tmpSmiley = '8)') Then IsSmiley := ''; { chr(134) }
  If (tmpSmiley = '8>') Then IsSmiley := ''; { chr(135) }
End;

Function InputString(X, Y, Color : Byte) : String;
{ accept text input from user, the string will be displayed
  as it is entered on the graphical screen pos X, Y.
  Pressing ENTER (or ESC) will act as an accept of the string. }

{ small bug: when pressing F1..F12 of cursor,
  it looks as if a character gets stuck in chache }
var
  StringComplete, BlinkFlip : Boolean;
  i, BlinkTimer : Byte;
  TmpString, StringWithCursor : String;
  GetChar, SmileyChar : Char;
begin
  {initialise variables}
  TmpString := '';
  StringComplete := false;
  BlinkTimer := 0;
  { draw a surrounding box }
  Drawbox((X*8)-2, (Y*8)-2, (c_MaxChars*8)+4, 8+4, cl_White);
  Drawbox((X*8)-1, (Y*8)-1, (c_MaxChars*8)+2, 8+2, 0);

  repeat
    {wait for user to press a key}
    repeat
      {put text}
      StringWithCursor := TmpString;
      BlinkTimer := (BlinkTimer + 1) mod c_CursorSpeed;
      if (BlinkTimer = 0) then BlinkFlip := not (BlinkFlip);
      if (BlinkFlip = true) then
      begin
        if (Length(TmpString) >= c_MaxChars) then
          {at max character, place cursor over last character}
          StringWithCursor[c_MaxChars] := ''
        else {not at max character, place cursor after last character}
          StringWithCursor := StringWithCursor + '';
      end;
      WriteText(X, Y, StringWithCursor, Color);
      WaitForRetrace;
      V_Flip; {actual display virtual screen}
      {erase previous text incl shadow(+1), with color <1>}
      Drawbox(X*8, Y*8, (Length(StringWithCursor)*8)+1, 8+1, 0);

    until KeyPressed;
    GetChar := readkey;
    {examine which key the user pressed}
    Case Ord(GetChar) of
    {Enter or Escape}
    13, 27 : StringComplete := true;
    {backspace}
    8 : begin
        i := Length(TmpString);
        Delete(TmpString, i, 1); {erase last character}
      end;
    { only accept valid characters }
    32..(31+c_NrOfLetters) :
      begin;
        { add character to string }
        i := Length(TmpString);
        SmileyChar := IsSmiley(TmpString[i], GetChar);
        { if smiley character, then delete one character }
        If (GetChar <> SmileyChar) Then
        Begin
          Delete(TmpString, i, 1);
          Dec(i);
          GetChar := SmileyChar;
        End;
        if (i >= c_MaxChars) then {max length of string reached}
          TmpString[i] := GetChar {overwrite last character}
        else
          TmpString := TmpString + GetChar; {add after last character}
      end;
    end; {case}

    {update screen}
    WriteText(X, Y, TmpString, Color);
    WaitForRetrace;
    V_Flip; {actual display virtual screen}
  until StringComplete;
  {return the string}
  InputString := TmpString;
end;

procedure DisplayOptions;
var
  strTemp : String;
begin
  { erase previous difficulty }
  Drawbox((19*8), (14*8), 48+1, 8+1, cl_DBlue);
  { erase previous starting level }
  Drawbox((19*8), (15*8), 16+1, 8+1, cl_DBlue);

  { diaplsy current difficulty }
  WriteText(19, 14, Diff[Difficulty], cl_White);

  { display current starting level }
  Str(StartLevel, strTemp);
  WriteText(19, 15, strTemp, cl_White)
end;

procedure DisplayHiscores;
const
  ShadowColors : Array[0..2] of byte = (cl_Dgreen2, cl_DBlue2, cl_DRed2);
var
  i : Byte;
  strName, strScore : String;
begin

  for i := 0 to 2 do
  Begin
    { get name and score }
    strName := HiScoresArray[i].Name;
    Str(HiScoresArray[i].Score:5,  strScore);
    { set shadow color according to difficulty }
    SetFontShadow(ShadowColors[i]);
    { display name, score }
    WriteText( 1, 18+i, Diff[i], cl_White);
    WriteText( 8, 18+i, strName, cl_White);
    WriteText(23, 18+i, strScore, cl_White);
  end;
end;

procedure DisplayHeader(strText : String; Ypos : Byte);
var
  i : Byte;
  strName, strScore : String;
begin
  { draw a white bar }
  Drawbox(0, (Ypos*8)-1, 38*8, 8+1, cl_White);
  { write triangle at end of bar }
  PutLetter((38*8), (Ypos*8)-1, 104, cl_White);
  { write header text }
  WriteText(1, Ypos, strText, cl_DBlue);
end;

function MainMenu : Boolean;
var
  FlushKey : Char;
  Choice, KeyCode : Byte;
begin
  { clear virtual sceen }
{  V_Cls;}
  DrawBox(0, 0, VGAx, VGAy, cl_DBlue);

  { display logo }
  PutLogoSprite;
  { display hiscores }
  DisplayHiscores;
  { display headers }
  SetFontShadow(0); {no text-shadow }
  DisplayHeader('Instructions',  8);
  DisplayHeader('Options',  13);
  DisplayHeader('High scores',  17);
  { display text }
  SetFontShadow(1); { black shadow }

  WriteText(1, 9, 'Guide the urthwurm through 10 caves.', cl_White);
  WriteText(1,10, 'Press SPACEBAR to rise, release', cl_White);
  WriteText(1,11, 'SPACEBAR to dive. ESC or P pauses game', cl_White);

  WriteText(1, 14, '1) Difficulty    :', cl_White);
  WriteText(1, 15, '2) Start on level:', cl_White);

  WriteText(1, 22, 'Press 1 or 2 for options, Esc to quit', cl_White);
  WriteText(1, 23, 'or any other key to start game', cl_White);

{  WriteText(1, 24, 'beta test10 (final build)', cl_White);}

  { show start level and difficulty }
  DisplayOptions;

  { accept user input }
  Choice := 0;
  repeat
    { flip virtual screen on actual screen, else user won't see it }
    V_Flip;

    repeat until keypressed;

    KeyCode := Ord(ReadKey);

    Case KeyCode of
    { '1' }
    49 : Begin
           Difficulty := (Difficulty + 1) mod 3;
           DisplayOptions;
         End;
    { '2' }
    50 : Begin
           StartLevel := StartLevel + 1;
           if (StartLevel > 5) Then StartLevel := 1;
           DisplayOptions;
         End;
    { Esc }
    27 : Choice := 2;

    { Shift-S unlocks hidden scrolling text (83='S' 115='s')}
    83, 115 :
         Begin
           if (Shiftstate(sc_LeftShift) = True)
           or (Shiftstate(sc_RightShift) = True) then
             SpecialMode := sm_Scroll
           else
             SpecialMode := sm_None;

           Choice := 1;
         End;
    { Shift-I unlocks secret inverse-direction mode }
    73, 105 :
         begin
           if (Shiftstate(sc_LeftShift) = True)
           or (Shiftstate(sc_RightShift) = True) then
             SpecialMode := sm_InverseDir
           else
             SpecialMode := sm_None;

           Choice := 1;
         end;
    { Shift-M unlocks secret mission-impossible mode }
    77, 109 :
         begin
           if (Shiftstate(sc_LeftShift) = True)
           or (Shiftstate(sc_RightShift) = True) then
             SpecialMode := sm_Extrahard
           else
             SpecialMode := sm_None;

           Choice := 1;
         end;
    else
      begin
        SpecialMode := sm_None;
        Choice := 1;
      end;
    end; { case }
  until (Choice=1) or (Choice=2);

  { return user choice, 1=start game, 2=quit to dos }
  MainMenu := (Choice = 1);
end;

end.