/*
 * mouse support for bcc
 * Copyright (c) 2017 Andreas K. Foerster <info@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "bcc-syst.h"

#if !defined(__BCC__) || !defined(__AS386_16__) || !defined(__MSDOS__)
#error "Just for Bruce's C compiler (bcc), 16-bit, DOS"
#endif

/* *INDENT-OFF* */

int
bcc_check_mouse ()
{
#asm
  xor ax, ax
  int $33
#endasm
}


void
bcc_show_mouse (on)
{
#asm
  mov bx, sp
  mov cx, [bx+2]
  mov ax, #1  ; show
  test cx, cx
  jnz .1
  mov ax, #2  ; hide
.1:
  int $33
#endasm
}


int
bcc_mouse_status (x, y)
{
#asm
  push bp
  mov bp, sp

  ; clear all values
  xor bx, bx
  xor cx, cx
  xor dx, dx

  mov ax, #3
  int $33
  mov ax, bx    ; return button state
  mov bx, 4[bp] ; x position
  mov [bx], cx
  mov bx, 6[bp] ; y position
  mov [bx], dx

  pop bp
#endasm
}
