#!/bin/awk -f
BEGIN {
  ASM="inv-oct.asm"; INC="inv-oct.inc"; LANG="LANG OCTASM,0.1"
  print LANG >INC
  print LANG,"use16 file_out \\inv-oct.com\n" \
    "define eq define\neq OFFSET\neq Offset\neq LEA mov\n" \
    "eq segcs db 2Eh\neq seges db 26h\n" \
    "eq movtoal() db 0A0h dw #1\neq movalto() db 0A2h dw #1\n" \
    "eq movtoax() db 0A1h dw #1\neq movaxto() db 0A3h dw #1\n" \
    "\\" INC >ASM
}

/^;|^ *$|CODE_SEG|END/ { next }
/ES:/ { sub("ES:\\[","[es+") }
/[+]BX/ { gsub("\\[|\\]","") }
/ PROC / { sub(" *PROC .*",":") }
/\[[1-9]\]/ { for(i=1;i <= 9;i++) sub("\\["i"\\]","+"i) }
/[+][A-Z][A-Z]/ {
  n=index($0,"+")
  $0 = substr($0,1,n-1) tolower(substr($0,n,3)) substr($0,n+3)
}

$2 ~ /^D[BWD]$/ {
  sub(" DD "," dw 0,"); gsub("\"","'")
  sub(" DB "," db "); sub(" DW "," dw ")
  print "eq s_" $1,tolower(substr($2,2,1)) >INC
  print "#" $0 >ASM; next
}

{
  sub(";.*|\\[0\\]|40:|Word Ptr",""); sub(","," ")

  if ($1 ~ /:$/) {
    sub(":","",$1); label=$1; print "#" $1 >ASM
    for(i=2;i <= NF;i++)$(i-1)=$i; $NF=""; NF--
  }

  if (($1 ~ /[A-Z][A-Z]*/) && ($1 != "LEA"))
    $1 = tolower($1)
  for (i=2; i < 4; i++)
    if ($i ~ /^[A-Z][A-Z]$/)
      if (($1=="LEA") && (i > 2))
        break
      else
        $i = tolower(substr($i,1,2)) substr($i,3)

  if ($1 != "LEA")
    if (((NF > 2) && ($2 ~ /^[A-Z][^ ][^ ][^ ]*/)) ||
       (($1 ~ /dec|inc/) && ($2 ~ /^[A-Z][^ ][^ ][^ ]*/)))
      $2="s_"$2"["$2"]"
    else if (($3 ~ /^[A-Z][^ ][^ ][^ ]*/) && ($3 !~ /^O[fF]/))
      $3="s_"$3"["$3"]"

  sub("[+].*\\[","[")

  if ((label=="RemoveNewInt9")&&(!cseg))cseg++;else if($1=="clc")cseg--
  if (cseg && ($0 !~ /\[0/)) sub("\\[","[cs+")

  if (($1=="mov") && ($0 !~ /[+]bx/)) {
    if ($3=="OFFSET") $3=""

    if (($2 ~ /a[lx]/) && ($3 ~ /\[../) && ($3 !~ /di\]$/))
      $0 = "movtoa" substr($2,2,1) "(" $3 ")" ";" $0
    else if (($3 ~ /a[lx]/) && ($2 ~ /\[../))
      $0 = "mova" substr($3,2,1) "to(" $2 ")" ";" $0

    if ($0 ~ /[ce]s[+]/) {
      n=index($0,"s+")-1
      $0 = "seg" substr($0,n,2) " " substr($0,1,n-1) substr($0,n+3)
    }

    if ($3 ~ /^0 *$/)
      if      ($2 == "ax") sub(".*","db 0B8h,0,0")
      else if ($2 == "di") sub(".*","db 0BFh,0,0")
    if (($2 == "bx") && ($3 ~ /^0*h* *$/)) sub(".*","db 0BBh,0,0")
  }

  if ($1 ~ /^seg.s/) print $1,$2,$3 "," $4 >ASM
  else
  for(i=1;i <= NF;i++)
    printf "%s%c%s",$i,(i==2 && NF > 2)?",":" ",(i==NF)?"\n":"" >ASM
}
# EOF
