# GNUmakefile
.RECIPEPREFIX := _

#=== fix1.sed begins ===
# /^ *\([^ ]\+\) \+D\([BWD]\) .\+/!d
# s||s/\\<\1\\>/\2[\&]/|
# s/B\[/byte[/
# s/W\[/word[/
# s/D\[/dword[/
#=== fix1.sed ends ===

#=== fix2.sed begins ===
# /^;/b
# /CODE_SEG/d
# /END /d
# / ENDP/d
# s/40://
# s/LEA /MOV /
# s/\]\[/+/
# /\[[bw][a-z]\+\[/s/\[//
# s/\[0\]//
# s/\]+BX/+BX/
# s/ES:\[/[ES:/
# s/ \+PROC .*/:/
# s/Word Ptr dword//
# s/,O[fF][^ ]\+/,/
# s/ORG \+100h/[&]/
#=== fix2.sed ends ===

#=== fix3.sed begins ===
# /RemoveNewInt9:/,/ RET/s/OldInt9Addr/cs:&/
# /NewInt9Handler:/,/NotIntercept:/s/\[/[cs:/
# /NotIntercept:/,/CLC/s/StoreAX/cs:&/
#=== fix3.sed ends ===

.PHONY: all check clean cleanall

PROG=inv-nasm
GAMEZIP=invadr11.zip
OLDASM=INVADERS.ASM
SED=sed
NASM=nasm
NASMFLAGS=-fbin -O9 -a
MD5SUM=md5sum
WGET=wget
WGETOPT=-q
UNZIPPER=unzip
UNZIPFLAGS=-qjan

#GAMEURL=ftp.lanet.lv/ftp/mirror/x2ftp/msdos/programming/gamesrc/
GAMEURL=www.ibiblio.org/pub/micro/pc-stuff/freedos/files/games/invaders/

all: $(PROG).com check

$(PROG).com: $(PROG).asm
_@$(NASM) $(NASMFLAGS) $< -o $@

fix1.sed fix2.sed fix3.sed: $(lastword $(MAKEFILE_LIST))
_@$(SED) -n -e '/$@ begins ===/,/$@ ends ===/s/^# \+//w $@' $<

asmvars.sed: fix1.sed $(OLDASM)
_@$(SED) -f $^ >$@

$(PROG).asm: $(OLDASM) asmvars.sed fix2.sed fix3.sed
_@$(SED) -e '/^;/b' -e '/ D[BWD] /b' -e '/,OFFSET/b' -e '/LEA /b'\
 -f asmvars.sed $< | $(SED) -f fix2.sed -f fix3.sed >$@

$(GAMEZIP):
_@$(WGET) $(WGETOPT) $(GAMEURL)$(GAMEZIP)

$(OLDASM): $(GAMEZIP)
_@$(UNZIPPER) $(UNZIPFLAGS) $< INVADERS/$@ >/dev/null

check: $(PROG).com
_@$(MD5SUM) $<
_@echo 5d6fa26af01606feb90f17e014390139 \ $<

clean:
_@$(RM) $(PROG).asm fix?.sed asmvars.sed

cleanall: clean
_@$(RM) $(PROG).com

# EOF
