# GNUmakefile
.RECIPEPREFIX := _

#=== fix1.sed begins ===
# /^ *\([^ ]\+\) \+D\([BWD]\) .\+/!d
# s||\1\\>/\2[\&]/|
# s/B\[/byte[/
# s/W\[/word[/
# s/D\[/dword[/
# s|^|s/\\<|
#=== fix1.sed ends ===

#=== fix2.sed begins ===
# /^ *;/b
# s/LEA \+\([^ ]\+\), *\([^ ]\+\)/MOV \1,\2/
# /CODE_SEG/d
# /^ *END/d
# s/\]\[\([1-9]\)\]/+\1]/
# s/\[0\]//
# s/\]\(+BX\)/\1/
# s/\[\([^ ]\+ *\[\)/\1/
# s/\(ES:\)\(\[\)/\2\1/
# s/ \+PROC/: ;&/
# / ENDP/s/^/;/
# s/Word Ptr dword/word/
# s/\<O[fF][fF][sS][eE][tT]\>//g
# s/ORG \+100h/[&]/
#=== fix2.sed ends ===

#=== fix3.sed begins ===
# /RemoveNewInt9:/,/ RET/s/OldInt9Addr/cs:&/
# /NewInt9Handler:/,/NotIntercept:/{
# s/byte\[/&cs:/
# /cs:/!s/\(MOV \+\)\([^,]\+\)/\1cs:\2/
# }
# /NotIntercept:/,/^ *$/{
# s/StoreAX/cs:&/
# s/40://
# }
#=== fix3.sed ends ===

.PHONY: all check clean cleanall

unexport UNZIP

PROG=inv-nasm
OLDASM=invaders.asm

SED=sed
NASM=nasm
NASMFLAGS=-fbin -O9v -a
MD5SUM=md5sum
WGET=wget
WGETOPT=-q
UNZIP=unzip
UNZIPOPT=-qjLan

GAMEZIP=invadr11.zip

#GAMEURL=ftp.lanet.lv/ftp/mirror/x2ftp/msdos/programming/gamesrc/
GAMEURL=www.ibiblio.org/pub/micro/pc-stuff/freedos/files/games/invaders/

all: $(PROG).com check

$(PROG).com: $(PROG).asm
_@$(NASM) $(NASMFLAGS) $< -o $@

fix1.sed fix2.sed fix3.sed: $(lastword $(MAKEFILE_LIST))
_@$(SED) -e '/$@ begins ===/,/$@ ends ===/!d' $< | $(SED) -e 's/^#  *//' >$@

asmvars.sed: fix1.sed $(OLDASM)
_@$(SED) -f $^ >$@

$(PROG).asm: $(OLDASM) asmvars.sed fix2.sed fix3.sed
_@$(SED) -e '/^ *;/b' -e '/ D[BWD] /b' -e '/, *OFFSET/b' -e '/LEA /b'\
 -f asmvars.sed $< | $(SED) -f fix2.sed -f fix3.sed >$@

$(GAMEZIP):
_@$(WGET) $(WGETOPT) $(GAMEURL)$(GAMEZIP)

$(OLDASM): $(GAMEZIP)
_@$(UNZIP) $(UNZIPOPT) $< "*/$@"

check: $(PROG).com
_@$(MD5SUM) $<
_@echo 5d6fa26af01606feb90f17e014390139 \ $<

clean:
_@$(RM) $(PROG).asm fix?.sed asmvars.sed

cleanall: clean
_@$(RM) $(PROG).com

# EOF
