/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#include "Head.h"
#include "Level.h"

//---------------------------------------------------------------------------
int Head::OnEvent(LevelHeader *lev) {

 int i;
 int headX,headY,headW,headH;

 switch(direction) {

  case DIR_DOWN:  headX=x-1;
                  headY=y+GraphData[3].H;
                  headW=GraphData[3].W;
                  headH=GraphData[3].H;

                   for(i=0;i<lev->NumBlock;i++) {
                     if(lev->Block[i].Check(headX,headY,headW,headH,1))
                      return WORM_DEATH;
                   }

                   if(ImEatingMySelf(headX,headY,headW,headH,1))
                    return WORM_DEATH;

                   for(i=0;i<lev->NumFood;i++) {
                    if(!(lev->Food[i].checked)) {
                     if(lev->Food[i].Check(headX,headY,headW,headH,1))
                      return WORM_EAT;
                    }
                   }

                  break;

  case DIR_RIGHT: headX=x+GraphData[0].W;
                  headY=y;
                  headW=GraphData[0].W;
                  headH=GraphData[0].H;

                   for(i=0;i<lev->NumBlock;i++) {
                     if(lev->Block[i].Check(headX,headY,headW,headH,0))
                      return WORM_DEATH;
                   }

                   for(i=0;i<lev->NumFood;i++) {
                    if(!(lev->Food[i].checked)) {
                     if(lev->Food[i].Check(headX,headY,headW,headH,0))
                      return WORM_EAT;
                    }
                   }

                   if(ImEatingMySelf(headX,headY,headW,headH,0))
                    return WORM_DEATH;

                  break;

  case DIR_LEFT:  headX=x-2;
                  headY=y;
                  headW=GraphData[2].W;
                  headH=GraphData[2].H;

                   for(i=0;i<lev->NumBlock;i++) {
                     if(lev->Block[i].Check(headX,headY,headW,headH,0))
                       return WORM_DEATH;
                    }

                    for(i=0;i<lev->NumFood;i++) {
                     if(!(lev->Food[i].checked)) {
                      if(lev->Food[i].Check(headX,headY,headW,headH,0))
                       return WORM_EAT;
                     }
                   }

                    if(ImEatingMySelf(headX,headY,headW,headH,0))
                     return WORM_DEATH;

                  break;

  case DIR_UP:    headX=x-1;
                  headY=y;
                  headW=GraphData[1].W;
                  headH=GraphData[1].H;

                  for(i=0;i<lev->NumBlock;i++) {
                     if(lev->Block[i].Check(headX,headY,headW,headH,1))
                      return WORM_DEATH;
                   }

                  for(i=0;i<lev->NumFood;i++) {
                   if(!(lev->Food[i].checked)) {
                     if(lev->Food[i].Check(headX,headY,headW,headH,1))
                      return WORM_EAT;
                   }
                  }

                   if(ImEatingMySelf(headX,headY,headW,headH,1))
                    return WORM_DEATH;

                  break;

  }

 return NOTHING_TO_DO;

}
//---------------------------------------------------------------------------




