/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#include <stdio.h>
#include <pc.h>
#include <unistd.h>
#include <string.h>
#include <dos.h>
#include <conio.h>

#include "Vga256.h"
#include "Sprite.h"
#include "Font.h"
//---------------------------------------------------------------------------
#define   MODIFY 1
#define   NEW    2
//---------------------------------------------------------------------------
DblBuf *DBuffer;
unsigned char pal[768],openmode;

Sprite   *ptrFont;
FontBMP  *OutFNT;
FontBMP  *SystemFNT;

char *srcfile,*fntfile;
//---------------------------------------------------------------------------
struct GrabRect {

  int x,y,W,H;

};

GrabRect Rect;
//---------------------------------------------------------------------------
void UpDateRect() {

  DBuffer->Rect(Rect.x,Rect.y,Rect.W,Rect.H);

}
//---------------------------------------------------------------------------
void print_help() {

 printf("\n");
 printf("                             **Font Grabber** v1.0\n");
 printf("              Nibbles font grabber Copyright (C) 2000 Andrea Fazzi\n");
 printf("\n");
 printf(" usage: fntgrab -options sourcefile.raw outputfile.fnt\n");
 printf(" options:\n");
 printf(" \n");
 printf(" -n create a new fnt output file outputfile.fnt\n");
 printf(" -m modify an existing fnt file outputfile.fnt\n");
 printf("\n");

}
//---------------------------------------------------------------------------
int parse(int argcnt,char *argstring[]) {

 if(argcnt==1) return 0;

  else if(argcnt<2) {
   srcfile=argstring[1];
   fntfile=argstring[1];
   return NEW;
  }

  else if(argcnt==4) {

   srcfile=argstring[2];
   fntfile=argstring[3];

    if(strcmp(argstring[1],"-m")==0) openmode=MODIFY;
     else if(strcmp(argstring[1],"-n")==0) openmode=NEW;

   return openmode;

 }

 else return 0;

}
//---------------------------------------------------------------------------
int main(int argc,char *argv[]) {

 int c=0,grabch=0;
 int i=0,cnt=0;

 unsigned char *scr;

 switch(parse(argc,argv)) {

  case 0: print_help();
          return 0;

  case MODIFY: OutFNT= new FontBMP;
               OutFNT->Init(255);
               OutFNT->LoadFromFile(fntfile);
               break;

  case NEW:    OutFNT= new FontBMP;
               OutFNT->Init(255);
               break;

 }

 SystemFNT=new FontBMP;
 SystemFNT->Init(255);
 SystemFNT->LoadFromFile("calisto.fnt");

 SetVgaMode(GRAPH256_MODE);
 scr=GrabScreenPtr();

 LoadPalette("system.pal",&pal[0]);
 SetPalette(&pal[0]);

 DBuffer=new DblBuf;
 ptrFont= new Sprite;

  DBuffer->Init(scr);
  DBuffer->ClearBuf(0);

  ptrFont->LoadFrom_RAW_File(srcfile);
  DBuffer->ClearBufPat(ptrFont->PtrSprite);


  Rect.x=0;Rect.y=0;
  Rect.W=10;Rect.H=10;


    while(c!=27) {

     DBuffer->ClearBufPat(ptrFont->PtrSprite);

     SystemFNT->GotoXY(0,160);
     SystemFNT->CharsData[122].DrawChr(160,160,15,DBuffer->FrameBuf);
//     OutFNT->CharsData[122].DrawChr(160,160,15,DBuffer);

      switch(c) {

       case '.': Rect.x++;
                 break;
       case ',': Rect.x--;
                 break;
       case 'a': Rect.y--;
                 break;
       case 'z': Rect.y++;
                 break;

       case 'm': Rect.W++;
                 break;
       case 'n': Rect.W--;
                 break;
       case 's': Rect.H--;
                 break;
       case 'x': Rect.H++;
                 break;

       case 13 : SystemFNT->GotoXY(0,180);
                 SystemFNT->ChangeCol(63);
                 SystemFNT->Print("z",DBuffer->FrameBuf);
                 DBuffer->Flip();
                 grabch=getch();
                 OutFNT->CharsData[grabch].ReadChr(Rect.x,Rect.y,Rect.W,Rect.H,DBuffer->FrameBuf,grabch);

                 break;

       case '1': OutFNT->SaveToFile(fntfile);
                 //OutFNT->GotoXY(0,170);
                 //OutFNT->Print("Prova",DBuffer);

                 break;


     }
        UpDateRect();

        WaitForRetrace();
        DBuffer->Flip();
        c=getch();

  }


   Release();
   SetVgaMode(TEXT_MODE);

   return 0;

}
//---------------------------------------------------------------------------