//
//    MARAUDER
//
//    sprite.cpp: sprite objects and movement code
//
//    By Shawn Hargreaves, 1995.
//
//    C++ source code for djgpp, using the 
//    Allegro game programming library.


#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <allegro.h>
#include "sprite.h"
#include "marauder.h"
#include "mgr.h"
#include "bullet.h"
#include "genes.h"
#include "alien.h"


extern DATAFILE *dat;

extern spritemgr *explosions;
extern spritemgr *bullets;
extern exploder *explode;

extern int dead;

extern int cheat;

extern char *msg_str;



multidir::multidir(BITMAP *b, int num, void (*callback)(void))
{
    number = num;
    switch(num) {
	case 8: shift = 5; round = 16; break;
	case 16: shift = 4; round = 8; break;
	case 32: shift = 3; round = 4; break;
	case 64: shift = 2; round = 2; break;
    }

    int c;

    s = (BITMAP **)malloc(sizeof(BITMAP *)*num);
    for (c=0; c<=num/4; c++) {
	s[c] = rotate_sprite(b, c<<shift);
	if (((c&7)==0) && (callback))
	    callback();
    }

    for (c=num/4+1; c<=num/2; c++) {
	s[c] = create_bitmap(b->w, b->w);
	for (int y=0; y<b->w; y++)
	    for (int x=0; x<b->w; x++)
		putpixel(s[c], x, y, getpixel(s[c-num/4], y, b->w-x-1));
    }

    for (c=num/2+1; c<num; c++) {
	s[c] = create_bitmap(b->w, b->w);
	for (int y=0; y<b->w; y++)
	    for (int x=0; x<b->w; x++)
		putpixel(s[c], x, y, getpixel(s[c-num/2], b->w-x-1, b->w-y-1));
    }
}



multidir::~multidir()
{
    if (s) {
	for (int c=0; c<number; c++)
	    if (s[c])
		destroy_bitmap(s[c]);
	free(s);
    }
}



BITMAP *multidir::rotate_sprite(BITMAP *b, fixed angle)
{
    BITMAP *s = create_bitmap(b->w, b->w);

    if (s) {
	clear(s);
	::rotate_sprite(s, b, 0, 0, itofix(angle));
    }

    return s;
}



int checkpixel(BITMAP *s, int x, int y)
{
    if ((x<0) || (y<0) || (x>=s->w) || (y>=s->h))
	return 0;

    if (getpixel(s, x, y))
	return 1;
    else
	return -1;
}



int calculate_bound(BITMAP *s)
{
    int x = s->w / 2;
    int y = s->h / 2;
    int make_smaller = TRUE;
    int orig;
    int bound;

    orig = bound = MIN(x, y);

    while (make_smaller) {
	int cx = 0;
	int cy = bound;
	int d = 3 - (bound << 1);
	int count = 0;

	do {
	    count += checkpixel(s, x+cx, y+cy);
	    count += checkpixel(s, x+cx, y-cy);
	    count += checkpixel(s, x-cx, y-cy);
	    count += checkpixel(s, x-cx, y+cy);
	    count += checkpixel(s, x+cy, y+cx);
	    count += checkpixel(s, x+cy, y-cx);
	    count += checkpixel(s, x-cy, y-cx);
	    count += checkpixel(s, x-cy, y+cx);
	    count += checkpixel(s, x-cy, y+cx);

	    if (d < 0)
		d += (cx << 2) + 6;
	    else {
		d += ((cx - cy) << 2) + 10;
		cy--;
	    }

	    cx++;

	} while (cx <= cy);

	if ((count < 0) && (bound > 1))
	    bound--;
	else
	    make_smaller = FALSE;
    }

    if (bound < orig/2)
	bound = orig/2;

    return bound;
}



void item::draw(BITMAP *b, int x, int y)
{ 
    int _w = (w >> FIX_TO_PIX_SHIFT) * 2 + 1;
    int _h = (h >> FIX_TO_PIX_SHIFT) * 2 + 1;
    int _x = x - _w/2;
    int _y = y - _h/2;

    if ((_x > SCREEN_W-80) || (_y > SCREEN_H) || (_x+_w < 0) || (_y+_h < 0))
	return;

    draw_sprite(b, current_sprite, _x, _y); 
    dirty.add(_x, _y, _w, _h);
}



playership::playership(SHIP_STATE *initial_state, multidir *go,
		       multidir *burn, multidir *still)
{
    state = *initial_state;
    go_spr = go;
    burn_spr = burn;
    still_spr = still;
    current_sprite = still_spr->sprite(0);
    set_dim();
    bound = calculate_bound(current_sprite);
    esc = FALSE;

    if (SCREEN_W == 320)
	ander = 0xfffffff;
    else if (SCREEN_W == 640)
	ander = 0x1fffffff;
    else
	ander = 0x3fffffff;

    for (int s=0; s<STAR_COUNT; s++) {
	star[s].x = (rand()&(ander>>20)) << FIX_TO_PIX_SHIFT;
	star[s].y = (rand()&(ander>>20)) << FIX_TO_PIX_SHIFT;
    }
    wpn = WEAPON_LASER;
    draw_stat_flag = FALSE;
    rcol = 240;
    shootdelay = 0;
    recent_mine = NULL;
    recent_flag = 0;
    kill_count = 0;
}



void playership::collide(item *other)
{
    extern int dying;

    if (!cheat) {
	int ded = (damage >= 100);
	if ((other->get_type()==ITEM_PLANET) || (other->get_type()==ITEM_ALIEN)) {
	    int dmg;
	    if (other->get_type()==ITEM_PLANET)
		dmg = ((myabs(xc)+myabs(yc)) >> (FIX_TO_PIX_SHIFT-3) + 1);
	    else 
		dmg = ((myabs(xc)+myabs(yc)) >> (FIX_TO_PIX_SHIFT-2) + 1);
	    damage += dmg / (1+state.shields);
	    x -= xc * 4;
	    y -= yc * 4;
	    for (int s=0; s<STAR_COUNT; s++) {
		star[s].x = (star[s].x + xc*4) & ander;
		star[s].y = (star[s].y + yc*4) & ander;
	    }
	    xc = (-xc) >> 3;
	    yc = (-yc) >> 3;
	    if ((!burn_delay) || (damage >= 100)) {
		explosions->add(new explosion(explode, (damage >= 100)), getx(), gety());
		burn_delay = 24;
		play_sample((SAMPLE *)dat[EXPLODE_WAV].dat, 255, 128,
		    (other->get_type() == ITEM_PLANET) ? 1000 : 2000, FALSE);
	    }
	}
	else if (other->get_type()==ITEM_BULLET) {
	    if (((bullet *)other)->get_parent() == this)
		return;
	    if (other == recent_mine) {
		recent_flag = 8;
		return;
	    }
	    damage += ((bullet *)other)->get_harm() / (1+state.shields);
	    ((bullet *)other)->kill(); 
	    if ((!burn_delay) || (damage >= 100)) {
		explosions->add(new explosion(explode, (damage >= 100)), other->getx(), other->gety());
		play_sample((SAMPLE *)dat[EXPLODE_WAV].dat, 255, 128, 1000, FALSE);
		burn_delay = 12;
	    }
	}
	if ((damage >= 100) && (!ded))
	    play_midi((MIDI *)dat[FUNERAL_MID].dat, FALSE);
    }
    if (other->get_type()==ITEM_TREASURE) {
	state.money += ((treasure *)other)->get_money();
	state.cargo += ((treasure *)other)->get_cargo();
	if (state.cargo > 100)
	    state.cargo = 100;
	explosions->add(new yippee("$%d", ((treasure *)other)->get_money()), other->getx(), other->gety());
	((treasure *)other)->kill();
	play_sample((SAMPLE *)dat[WAIL_WAV].dat, 255, 128, 800, FALSE);
    }

    if (damage >= 100) {
	damage = 100;
	dying = TRUE;
    }

    draw_stat_flag = TRUE;
}



int playership::move()
{
    static int ec = 0;

    esc = key[KEY_ESC];

    if ((key[KEY_LEFT]) || (joy_left))
	dir = (dir-4)&0xff;

    if ((key[KEY_RIGHT]) || (joy_right))
	dir = (dir+4)&0xff;

    if ((key[KEY_UP]) || (joy_up)) {
	if (state.afterburner)
	    current_sprite = burn_spr->sprite(dir);
	else
	    current_sprite = go_spr->sprite(dir);
	if (state.afterburner) {
	    xc += fsin(itofix(dir))<<2;
	    yc += -fcos(itofix(dir))<<2;
	    xc -= (xc>>8);
	    yc -= (yc>>8);
	}
	else {
	    xc += fsin(itofix(dir));
	    yc += -fcos(itofix(dir));
	}

	if (ec <= 0) { 
	    play_sample((SAMPLE *)dat[ENGINE_WAV].dat, 32, 128,
			     state.afterburner ? 1500 : 1100, FALSE);
	    ec = 6;
	}
	else
	    ec--;
    }
    else {
	ec = 0;
	current_sprite = still_spr->sprite(dir);
    }

    xc -= (xc>>8);
    yc -= (yc>>8);

    x += xc;
    y += yc;

    for (int s=0; s<STAR_COUNT; s++) {
	star[s].x = (star[s].x - xc) & ander;
	star[s].y = (star[s].y - yc) & ander;
    }

    if (key[KEY_1]) {
	if (wpn != WEAPON_LASER) {
	    wpn = WEAPON_LASER;
	    draw_stat_flag = TRUE;
	}
    }
    else if (key[KEY_2]) {
	if ((wpn != WEAPON_PROTON_GUN) && state.proton_gun) {
	    wpn = WEAPON_PROTON_GUN;
	    draw_stat_flag = TRUE;
	}
    }
    else if (key[KEY_3]) {
	if ((wpn != WEAPON_MATTER_CANNON) && state.matter_cannon) {
	    wpn = WEAPON_MATTER_CANNON;
	    draw_stat_flag = TRUE;
	}
    }
    else if (key[KEY_4]) {
	if ((wpn != WEAPON_MISSILE) && state.missiles) {
	    wpn = WEAPON_MISSILE;
	    draw_stat_flag = TRUE;
	}
    }
    else if (key[KEY_5]) {
	if ((wpn != WEAPON_TORPEDO) && state.torpedoes) {
	    wpn = WEAPON_TORPEDO;
	    draw_stat_flag = TRUE;
	}
    }
    else if (key[KEY_6]) {
	if ((wpn != WEAPON_MINE) && state.mines) {
	    wpn = WEAPON_MINE;
	    draw_stat_flag = TRUE;
	}
    }

    if (shootdelay) {
	if (shootdelay < 0) {
	    if ((!key[KEY_SPACE]) && (!joy_b1))
		shootdelay = 0;
	}
	else
	    shootdelay--;
    }
    else {
	if ((key[KEY_SPACE]) || (joy_b1)) {
	    switch(wpn) {

		case WEAPON_LASER:
		    bullets->add(new laser(dir, xc, yc, this),
				 getx()+fsin(itofix(dir))*128,
				 gety()-fcos(itofix(dir))*128);
		    shootdelay = 10;
		    play_sample((SAMPLE *)dat[L1_WAV].dat, 255, 128, 600, FALSE);
		    break;

		case WEAPON_PROTON_GUN:
		    bullets->add(new proton_gun(dir, xc, yc, this),
				 getx()+fsin(itofix(dir))*128,
				 gety()-fcos(itofix(dir))*128);
		    shootdelay = 5;
		    play_sample((SAMPLE *)dat[L2_WAV].dat, 255, 128, 1000, FALSE);
		    break;

		case WEAPON_MATTER_CANNON:
		    bullets->add(new matter_cannon(dir, xc, yc, this),
				 getx()+fsin(itofix(dir))*128,
				 gety()-fcos(itofix(dir))*128);
		    shootdelay = 8;
		    play_sample((SAMPLE *)dat[L3_WAV].dat, 255, 128, 1000, FALSE);
		    break;

		case WEAPON_MISSILE:
		    bullets->add(new missile(dir, xc, yc, this),
				 getx()+fsin(itofix(dir))*128,
				 gety()-fcos(itofix(dir))*128);
		    shootdelay = -1;
		    state.missiles--;
		    if (state.missiles <= 0)
			wpn = WEAPON_LASER;
		    draw_stat_flag = TRUE;
		    play_sample((SAMPLE *)dat[MISSILE_WAV].dat, 255, 128, 1000, FALSE);
		    break;

		case WEAPON_TORPEDO:
		    bullets->add(new torpedo(dir, xc, yc, this),
				 getx()+fsin(itofix(dir))*128,
				 gety()-fcos(itofix(dir))*128);
		    shootdelay = -1;
		    state.torpedoes--;
		    if (state.torpedoes <= 0)
			wpn = WEAPON_LASER;
		    draw_stat_flag = TRUE;
		    play_sample((SAMPLE *)dat[MISSILE_WAV].dat, 255, 128, 800, FALSE);
		    break;

		case WEAPON_MINE:
		    if (!recent_flag) {
			if (bullets->get_count() >= 50)
			    msg_str = "Too many mines!";
			else {
			    recent_mine = bullets->add(new mine(dir, xc, yc),
						       getx(), gety());
			    recent_flag = 8;
			    shootdelay = -1;
			    state.mines--;
			    if (state.mines <= 0)
				wpn = WEAPON_LASER;
			    draw_stat_flag = TRUE;
			}
		    }
		    play_sample((SAMPLE *)dat[CRASH_WAV].dat, 255, 128, 1600, FALSE);
		    break;
	    }
	}
    }

    if (burn_delay)
	burn_delay--;

    if (recent_flag)
	recent_flag--;
    else
	recent_mine = NULL;

    return 0;
}



void playership::draw_stars(BITMAP *b)
{
    for (int s=0; s<STAR_COUNT; s++) {
	int x = star[s].x>>FIX_TO_PIX_SHIFT;
	int y = star[s].y>>FIX_TO_PIX_SHIFT;
	putpixel(b, x, y, 135+s);
	dirty.add(x, y, 1, 1);
    }
}



static int planet_type = PLANET_EARTH;


planet::planet()
{
    itemtype = ITEM_PLANET;
    type = planet_type;
    planet_type++;
    if (planet_type > PLANET_WATER)
	planet_type = PLANET_ASTEROID;

    switch(type) {

	case PLANET_ASTEROID:
	    current_sprite = (BITMAP *)dat[PLANET1].dat;
	    rcol = 236;
	    break; 

	case PLANET_EARTH:
	    current_sprite = (BITMAP *)dat[PLANET2].dat;
	    rcol = 217;
	    break; 

	case PLANET_JUPITER:
	    current_sprite = (BITMAP *)dat[PLANET3].dat;
	    rcol = 15;
	    break; 

	case PLANET_SUN:
	    current_sprite = (BITMAP *)dat[PLANET4].dat;
	    rcol = 15;
	    break; 

	case PLANET_WATER:
	    current_sprite = (BITMAP *)dat[PLANET5].dat;
	    rcol = 217;
	    break; 
    }

    set_dim();
    bound = calculate_bound(current_sprite);
}



int planet::price()
{
    switch(type) {

	case PLANET_ASTEROID:
	    return 1;

	case PLANET_EARTH:
	    return 100;

	case PLANET_JUPITER:
	    return 1;

	case PLANET_WATER:
	    return 100;

	default:
	    return 0;
    }
}



exploder::exploder(int hotcount, int explode_size, void (*callback)())
{
    int c, c2;
    struct hotspt {
	int x, y;
	int xc, yc;
    } *hot;
    int flag = 0;

    hot = (hotspt *)malloc(sizeof(hotspt)*hotcount);

    for (c=0; c<hotcount; c++) {
	hot[c].x = hot[c].y = (explode_size/2)<<16;
	hot[c].xc = (rand()&0xffff)-0x7fff;
	hot[c].yc = (rand()&0xffff)-0x7fff;
    }

    for (c=0; c<EXPLODER_COUNT; c++) {

	flag ^= 1;
	if (flag)
	    callback();

	s[c] = create_bitmap(explode_size, explode_size);
	clear(s[c]);

	int color = ((c<16) ? c*4 : (80-c)) >> 2;

	for (c2=0; c2<hotcount; c2++) {
	    for (int x=-6; x<=6; x++) {
		for (int y=-6; y<=6; y++) {
		    int xx = (hot[c2].x>>16) + x;
		    int yy = (hot[c2].y>>16) + y;
		    if ((xx>0) && (yy>0) && (xx<explode_size) && (yy<explode_size)) {
			unsigned char *p = s[c]->line[yy] + xx;
			*p += color >> ((myabs(x)+myabs(y))/4);
			if (*p > 64)
			    *p = 64;
		    }
		}
	    }
	    hot[c2].x += hot[c2].xc;
	    hot[c2].y += hot[c2].yc;
	}

	for (int x2=0; x2<explode_size; x2++)
	    for (int y2=0; y2<explode_size; y2++)
		if (getpixel(s[c], x2, y2) < 8)
		    putpixel(s[c], x2, y2, 0);
    }

    free(hot);
}



exploder::~exploder()
{
    for (int c=0; c<EXPLODER_COUNT; c++)
	destroy_bitmap(s[c]);
}



explosion::explosion(exploder *e, int flag)
{
    die_flag = flag;
    count = 0;
    expl = e;
    current_sprite = expl->sprite(count);
    set_dim();
}



int explosion::move()
{
    if (++count >= EXPLODER_COUNT) {
	if (die_flag)
	    dead = TRUE;
	return -1;
    }

    current_sprite = expl->sprite(count);
    return 0;
}



extern multidir *treasure_sprite;
extern int treasure_bound;



treasure::treasure(int c, int m)
{
    cargo = c;
    money = m;
    dir = 0;
    life = 1000;
    bound = treasure_bound;
    itemtype = ITEM_TREASURE;
    spr = treasure_sprite;
    current_sprite = spr->sprite(0);
    set_dim();
}



int treasure::move()
{
    current_sprite=spr->sprite(dir++);
    return (--life > 0) ? 0 : -1;
}



yippee::yippee(char *fmt, ...)
{
    va_list args;
    char buf[64];

    va_start(args, fmt);
    vsprintf(buf, fmt, args);
    va_end(args);

    life = 64;
    BITMAP *b = create_bitmap(strlen(buf)*8,8);
    text_mode(0);
    textout(b, (FONT *)dat[MYFONT].dat, buf, 0, 0, 100);
    current_sprite = b;
    set_dim();
}



yippee::~yippee()
{
    destroy_bitmap(current_sprite);
}


