//
//    MARAUDER
//
//    marauder.cpp: Title screen and startup code.
//
//    By Shawn Hargreaves, 1995.
//
//    C++ source code for djgpp, using the 
//    Allegro game programming library.


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <allegro.h>
#include "marauder.h"
#include "fire.h"


void play_game();
void data_init();
void data_cleanup();


int profile = FALSE;

DATAFILE *dat = NULL;
BITMAP *s2 = NULL;


volatile int title_flag;



void title_int(void)
{
    title_flag = TRUE;
}



void show_title()
{
   blit((BITMAP *)dat[TITLE_BMP].dat, screen, 0, 0, 0, 64, 640, 128);
}



void remove_screen()
{
    fade_out(6);
    clear(screen);
    set_pallete((RGB *)dat[PAL].dat);
}



int title_screen()
{
    burner fire(screen, SCREEN_W, 128);
    int ret = TRUE;
    int done = FALSE;

    play_midi((MIDI *)dat[TITLE_MID].dat, TRUE);
    set_pallete(black_pallete);
    clear(s2);
    clear(screen);
    show_title();
    fade_in((RGB *)dat[TITLE_PAL].dat, 2);
    title_flag = FALSE;
    install_int_ex(title_int, BPS_TO_TIMER(70));
    clear_keybuf();

    do {
	fire.animate();

	do {
	} while (!title_flag);

	title_flag = FALSE;

	poll_joystick();

	if (key[KEY_ESC]) {
	    ret = FALSE;
	    done = TRUE;
	}
	else if (key[KEY_SPACE] || key[KEY_ENTER] || joy_b1)
	    done = TRUE;

    } while (!done);

    remove_int(title_int);
    remove_screen();
    return ret;
}



void calibrate_the_joystick()
{
    if (install_joystick(JOY_TYPE_AUTODETECT) != 0)
	printf("\nJoystick not present");
   else
	printf("\nJoystick detected");
}



int main()
{
    char buf[80];

    allegro_init();
    install_keyboard();
    install_timer();

    if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {
	allegro_message("Error setting up sound hardware (check sound.cfg settings)\n");
	exit(1);
    }

    calibrate_the_joystick();

    get_executable_name(buf, sizeof(buf));
    strcpy(get_filename(buf), "marauder.dat");
    printf("\nLoading %s\n", buf);
    dat = load_datafile(buf);
    if (!dat) {
	allegro_message("Fatal error loading marauder.dat!\n");
	exit(1);
    }

    data_init();

    fade_out(6);

    if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) != 0) {
	set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
	allegro_message("Error setting graphics mode\n");
	exit(1);
    }

    s2 = create_bitmap(SCREEN_W, SCREEN_H);

    while (title_screen())
	play_game();

    destroy_bitmap(s2);
    data_cleanup();
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message((char *)dat[END_TXT].dat);
    unload_datafile(dat);
    allegro_exit();

    return 0;
}

END_OF_MAIN();

