' вставка текста из буфера обмена
sub PasteText()
	
	dim as zstring ptr psz = GetTextClipBoard() ' получаем текст из буфера обмена
	
	if psz then ' если что-то получили
		
		dim as string s = replacestring(*psz , chr(13) , "" , ,1) ' убираем символ 13
		
		's = replacestring(s , chr(9) , " " , ,1) ' заменяем символ табуляции на пробел
		
        Dim As Wstring Ptr pws = Utf8tounicode(s) ' преобразуем в юникод
		
		if pws then ' если преобразование в юникод удачно
			
			if pObj.iMarkerSelectionStart then ' если есть выделение
				
				BackSpace() ' удаляем текст выделения
				
			EndIf
			
			InsertText(pws) ' вставляем текст
			
			deallocate(pws) ' удаляем указатель 
			
		EndIf
		
		if pObj.iParametersClipBoard then ' если используется стандартный буфер обмена
			
			deallocate(psz) ' удаляем указатель
			
		EndIf
		
	EndIf
	
End Sub

' копирование или вырезание текста в буфер обмена
' параметр:
' iParamCut - если 0 , то простое копирование , если 1 , то вырезание
sub CopyText(iParamCut as Long = 0)
	
	' если есть выделение
	if pObj.iMarkerSelectionStart then
		
		dim as long iStartMarker = pObj.iMarkerSelectionStart ' сохраняем начальный маркер
		
		dim as long iEndMarker = GetPosition() ' сохраняем конечный маркер
		
		' начальная и конечная строка выделения , а так же 
		' начальная и конечная позиция в строке выделения		
		dim as long iStartRow , iEndRow , iStartPos , iEndPos , iStartPosTab , iEndPosTab
		
		dim as string sText ' буфер для строки в UTF8
		
		' если выделение снизу-вверх
		if iStartMarker > iEndMarker then
			
			' меняем местами значения сохраненных маркеров
			swap iStartMarker , iEndMarker
			
		EndIf
		
		' получаем начальную строку и начальную позицию в этой строке для выделения
		GetRowsAndPosFromPosition(iStartMarker , iStartRow , iStartPos , iStartPosTab)
		' получаем конечную строку и конечную позицию в этой строке для выделения
		GetRowsAndPosFromPosition(iEndMarker , iEndRow , iEndPos , iEndPosTab)
		
		if iStartRow = iEndRow then ' если выделение на одной строке
			
			' получаем указатель на строку
			dim as wstring ptr pwText = pObj.pList.GetValueIndex(iStartRow-1)
			
			' получаем текст выделения и преобразуем его в UTF8
			sText = Unicodetoutf8(mid(*pwText , iStartPos , iEndPos-iStartPos+1))
			
		else
			
			' получаем указатель на строку начального маркера
			dim as wstring ptr pwText = pObj.pList.GetValueIndex(iStartRow-1)
			
			' получаем часть текста из строки начального маркера
			' и преобразуем его в UTF8 , добавляя символ окончания строки
			sText = Unicodetoutf8(mid(*pwText , iStartPos)) & chr(10) 
			
			' в цикле работаем со всеми строками,  кроме строк начального и конечного маркера
			for i as Long  = iStartRow+1 to iEndRow-1
				
				' получаем и преобразуем строку в UTF8 , добавляя символ окончания строки
				sText &= Unicodetoutf8(pObj.pList.GetValueIndex(i-1)) & chr(10)
				
			Next
			
			' получаем указатель на строку конечного маркера
			pwText = pObj.pList.GetValueIndex(iEndRow-1)
			
			' получаем часть текста из строки конечного маркера
			' и преобразуем его в UTF8			
			sText &= Unicodetoutf8(mid(*pwText , 1 , iEndPos))
			
		EndIf
		
		' если задан параметр для вырезки текста
		if iParamCut then
			
			' удаляем выделенный текст
			BackSpace()
			
		EndIf
		
		SetMarkerSelection(1) ' сбросим маркер
		
		' выводим все строки на экран
		DrawRowsEditor()
		
		' текст в буфер обмена
		SetTextClipBoard(strptr(sText))
		
	EndIf
	
End Sub