' ***********colors*************
'0 black 
'1 blue  
'2 green 
'3 cyan  
'4 red 
'5 pink 
'6 yellow 
'7 grey 
'8 dark grey 
'9 bright blue
'10 bright green 
'11 bright cyan
'12 bright red 
'13 bright pink 
'14 bright yellow 
'15 white
' *****************************

#include "crt.bi"

#ifdef __UNIX_SYSTEM__
	
	#include "X11/Xlib.bi"
	#inclib "X11"
	
	#ifdef __FB_LINUX__
		#define NCCS 32
	#EndIf
	#ifdef __FB_FREEBSD__
		#define NCCS 19
		type dev_t as ULONGINT
		type blkcnt_t as integer
		type ino_t as UINTEGER
		type mode_t as ULONG
		type nlink_t as UINTEGER
		type uid_t as ULOng
		type gid_t as ULONG
		type off_t as Integer
		#define O_RDONLY 0
		#define O_NDELAY 4
		#define F_SETFL 4
		#define F_GETFL 3
	#EndIf
	
	type tcflag_t as ulong
	type cc_t as Ubyte
	type speed_t as ulong
	
	#define ICANON  0000002
	#define ECHO    0000010
	#define INLCR	0000100
	#define IGNCR	0000200
	#define ICRNL	0000400
	#define IXON	0002000
	#define IXOFF	0010000
	#define TCSANOW     0
	#define ISIG	0000001
	
	type termios
		as tcflag_t c_iflag     ' input mode flags
		as tcflag_t c_oflag     ' output mode flags
		as tcflag_t c_cflag     ' control mode flags
		as tcflag_t c_lflag     ' local mode flags
		#ifdef __FB_LINUX__
			as cc_t c_line          ' line discipline
		#endif
		as cc_t c_cc(NCCS)      ' control characters
		as speed_t c_ispeed     ' input speed
		as speed_t c_ospeed     ' output speed
		#ifdef __FB_LINUX__
			#define _HAVE_STRUCT_TERMIOS_C_ISPEED 1
			#define _HAVE_STRUCT_TERMIOS_C_OSPEED 1
		#endif
	end type
	
	extern "C"
		
		declare function tcgetattr ( __fd as long, __termios_p as termios ptr) as long
		declare function tcsetattr (__fd as long, __optional_actions as long, __termios_p as termios ptr) as long
		declare function signal( signum as long, handler as any ptr) as any ptr
		declare function read_ alias "read" (byval __fd as long, byval __buf as any ptr, byval __nbytes as size_t) as ssize_t
		#ifdef __FB_FREEBSD__
			declare function open_ alias "open" (as zstring ptr , as long , ...) as long
			declare function fcntl alias "fcntl" (as long , as long , ...) as Long
		#EndIf
		
		#define S_IFDIR  &o40000
		#define S_IFMT  &o170000
		#define S_ISDIR(m)	(((m) And S_IFMT) = S_IFDIR)
		
		Type _stat
			
			st_dev As dev_t
			
			#ifndef __fb_64bit__
				
				pad1 As Long
				
				st_ino As ino_t
				
				st_mode As mode_t
				
				st_nlink As nlink_t
				
			#else
				
				st_ino As ino_t
				
				st_nlink As nlink_t
				
				st_mode As mode_t	
				
			#endif
			
			st_uid As uid_t
			
			st_gid As gid_t
			
			st_rdev As dev_t
			
			#ifndef __fb_64bit__
				
				pad2 As Long
				
			#endif
			
			st_size As off_t
			
			st_atime As time_t
			
			st_atime_usec As time_t
			
			st_mtime As time_t
			
			st_mtime_usec As time_t
			
			st_ctime As time_t
			
			st_ctime_usec As time_t
			
			st_blksize As Uinteger 'blksize_t
			
			st_blocks As blkcnt_t
			
			reserve(200) as Byte
			
		End Type
		
		Declare Function stat (Byval As Zstring Ptr, Byval As _stat Ptr) As Long	
		
	End Extern
	
	type TypeCommentsArraySavedRows as wstring
	
#endif

#ifdef __FB_DOS__
	
	#include "dos\dpmi.bi"
	#include "dos\dos.bi"
	#include "dos\sys\farptr.bi"
	#include "dos\sys\exceptn.bi"
	#include "dos\bios.bi"
	#include "dos\conio.bi"
	#include "crt\dos\unistd.bi"
	
	type TypeCommentsArraySavedRows as Short
	
#EndIf

#ifdef __FB_WIN32__
	
	type w32FILETIME
		dwLowDateTime as long
		dwHighDateTime as long
	end type
	type w32FIND_DATAA
		dwFileAttributes as long
		ftCreationTime as w32FILETIME
		ftLastAccessTime as w32FILETIME
		ftLastWriteTime as w32FILETIME
		nFileSizeHigh as long
		nFileSizeLow as long
		dwReserved0 as long
		dwReserved1 as long
		cFileName as zstring * 260
		cAlternateFileName as zstring * 14
	end type
	type w32COORD
		X as SHORT
		Y as SHORT
	end type
	type w32MOUSE_EVENT_RECORD
		dwMousePosition as w32COORD
		dwButtonState as long
		dwControlKeyState as long
		dwEventFlags as long
	end type
	union w32KEY_EVENT_RECORD_uChar
		UnicodeChar as Ushort
		AsciiChar as ubyte
	end union
	type w32KEY_EVENT_RECORD
		bKeyDown as long
		wRepeatCount as short
		wVirtualKeyCode as short
		wVirtualScanCode as short
		uChar as w32KEY_EVENT_RECORD_uChar
		dwControlKeyState as long
	end type
	type w32WINDOW_BUFFER_SIZE_RECORD
		dwSize as w32COORD
	end type
	type w32MENU_EVENT_RECORD
		dwCommandId as ULong
	end type
	type w32FOCUS_EVENT_RECORD
		bSetFocus as long
	end type
	union w32INPUT_RECORD_Event
		KeyEvent as w32KEY_EVENT_RECORD
		MouseEvent as w32MOUSE_EVENT_RECORD
		WindowBufferSizeEvent as w32WINDOW_BUFFER_SIZE_RECORD
		MenuEvent as w32MENU_EVENT_RECORD
		FocusEvent as w32FOCUS_EVENT_RECORD
	end union
	
	type w32INPUT_RECORD
		EventType as short
		Event as w32INPUT_RECORD_Event
	end type
	
	type w32CHAR_INFO
		Char as w32KEY_EVENT_RECORD_uChar
		Attributes as short
	end type
	
	type w32CONSOLE_CURSOR_INFO
		dwSize as long
		bVisible as long
	end type
	
	type TConcoleParams
		
		hStdin as any ptr ' хендл консоли для чтения
		hNewStdOut AS any ptr ' указатель на новый буфер для консоли
		hStdOutOld as Any ptr ' указатель на текущий буфер , для востановления после работы редактора
		
		'chiBuffer(3000) AS w32CHAR_INFO ' буфер для данных
		
		'coordBufSize задает размер в символьных ячейках буфера, на который указывает параметр lpBuffer. 
		'Член X структуры COORD — это количество столбцов; член Y — это количество строк.    
		'coordBufSize AS w32COORD
		'Задает координаты верхней левой ячейки буфера, на которую указывает параметр lpBuffer для записи данных. 
		'Член X структуры COORD является столбцом, а член Y — строкой.
		'coordBufCoord AS w32COORD
		
	End Type
	
	const w32FILE_ATTRIBUTE_DIRECTORY = &h00000010
	const w32STD_INPUT_HANDLE = cast(long, -10)
	const w32STD_OUTPUT_HANDLE = cast(long, -11)
	const w32CP_ACP  = 0
	const w32CP_OEM  = 1
	const w32CF_UNICODETEXT = 13
	const w32GMEM_MOVEABLE = &h2
	const w32GMEM_SHARE = &h2000
	const w32KEY_EVENT = &h1
	const w32WINDOW_BUFFER_SIZE_EVENT = &h4
	const w32GENERIC_READ = &h80000000
	const w32GENERIC_WRITE = &h40000000
	const w32FILE_SHARE_READ = &h00000001
	const w32FILE_SHARE_WRITE = &h00000002
	const w32CONSOLE_TEXTMODE_BUFFER = 1
	const w32GWL_STYLE = -16
	const w32WS_MAXIMIZEBOX = &h00010000
	const w32WS_SIZEBOX = &h00040000
	dim shared as short iChineseBytes(7)=>{25991,12435,12423,37329,12461,12531,12462,12519}
	declare function w32IsDBCSLeadByte alias "IsDBCSLeadByte"(as UByte) as Long
	declare function w32FindFirstFile alias "FindFirstFileA"(byval lpFileName as zstring ptr, byval lpFindFileData as w32FIND_DATAA ptr) as any ptr
	declare function w32FindClose alias "FindClose"(byval hFindFile as any ptr) as long
	declare function w32GetStdHandle alias "GetStdHandle"(byval nStdHandle as long) as any ptr
	#ifdef Win9x
		declare function w32ReadConsoleInput alias "ReadConsoleInputA"(byval hConsoleInput as any ptr, byval lpBuffer as w32INPUT_RECORD ptr, byval nLength as long, byval lpNumberOfEventsRead as long ptr) as long
		declare function w32WriteConsoleOutputCharacter alias "WriteConsoleOutputCharacterA"(byval hConsoleOutput as any ptr, byval lpCharacter as Zstring ptr,byval nLength as long, byval dwWriteCoord as w32COORD, byval lpNumberOfCharsWritten as any ptr) as long
	#else
		declare function w32ReadConsoleInput alias "ReadConsoleInputW"(byval hConsoleInput as any ptr, byval lpBuffer as w32INPUT_RECORD ptr, byval nLength as long, byval lpNumberOfEventsRead as long ptr) as long
		declare function w32WriteConsoleOutputCharacter alias "WriteConsoleOutputCharacterW"(byval hConsoleOutput as any ptr, byval lpCharacter as wstring ptr,byval nLength as long, byval dwWriteCoord as w32COORD, byval lpNumberOfCharsWritten as any ptr) as long
	#endif
	declare function w32SetConsoleMode alias "SetConsoleMode"(byval hConsoleHandle as any ptr, byval dwMode as long) as long
	declare function w32GetConsoleWindow alias "GetConsoleWindow"() as any ptr
	declare function w32SetWindowLong alias "SetWindowLongW"(byval hWnd as any ptr, byval nIndex as long, byval dwNewLong as LONG) as LONG
	declare function w32GetWindowLong alias "GetWindowLongW"(byval hWnd as any ptr, byval nIndex as long) as LONG
	declare function w32MultiByteToWideChar alias "MultiByteToWideChar"(byval CodePage as UINTEGER, byval dwFlags as long, byval lpMultiByteStr as any ptr, byval cbMultiByte as long, byval lpWideCharStr as any ptr, byval cchWideChar as long) as long
	declare function w32WideCharToMultiByte alias "WideCharToMultiByte"(byval CodePage as UINTEGER, byval dwFlags as long, byval lpWideCharStr as any ptr, byval cchWideChar as long, byval lpMultiByteStr as any ptr, byval cbMultiByte as long, byval lpDefaultChar as any ptr, byval lpUsedDefaultChar as any ptr) as long
	declare function w32OpenClipboard alias "OpenClipboard" (byval hWndNewOwner as any ptr) as long
	declare function w32CloseClipboard alias "CloseClipboard" () as long
	declare function w32EmptyClipboard alias "EmptyClipboard"() as long
	declare function w32SetClipboardData alias "SetClipboardData"(byval uFormat as UINTeger, byval hMem as any ptr) as any ptr
	declare function w32GetClipboardData alias "GetClipboardData"(byval uFormat as UINTeger) as any ptr
	declare function w32CreateConsoleScreenBuffer alias "CreateConsoleScreenBuffer"(byval dwDesiredAccess as long, byval dwShareMode as long, byval lpSecurityAttributes as const any ptr, byval dwFlags as long, byval lpScreenBufferData as any ptr) as any ptr
	declare function w32SetConsoleActiveScreenBuffer alias "SetConsoleActiveScreenBuffer"(byval hConsoleOutput as any ptr) as long
	declare function w32WriteConsoleOutputAttribute alias "WriteConsoleOutputAttribute"(byval hConsoleOutput as any ptr, byval lpAttribute as const short ptr, byval nLength as long, byval dwWriteCoord as w32COORD, byval lpNumberOfAttrsWritten as any ptr ) as long
	declare function w32SetConsoleCursorPosition alias "SetConsoleCursorPosition"(byval hConsoleOutput as any ptr, byval dwCursorPosition as w32COORD) as long
	declare function w32SetConsoleCursorInfo alias "SetConsoleCursorInfo"(byval hConsoleOutput as any ptr, byval lpConsoleCursorInfo as const w32CONSOLE_CURSOR_INFO ptr) as long
	declare function w32SetConsoleCP alias "SetConsoleCP"(byval wCodePageID as UINTeger) as long
	declare function w32GetAsyncKeyState alias "GetAsyncKeyState"(byval vKey as long) as SHORT
	declare function w32CloseHandle alias "CloseHandle"(byval hObject as any ptr) as Long
	declare function w32GlobalLock alias "GlobalLock"(byval hMem as any ptr) as any ptr
	declare function w32GlobalUnlock alias "GlobalUnlock"(byval hMem as any ptr) as long
	declare function w32SendMessage alias "SendMessageA"(hw as integer , msg as long , w as integer , l as any ptr) as long
	#ifdef __FB_64BIT__
		declare function w32GlobalAlloc alias "GlobalAlloc"(byval uFlags as UINTeger, byval dwBytes as ulongint) as any ptr
		declare function w32GlobalSize alias "GlobalSize"(byval hMem as any ptr) as ulongint
	#else
		declare function w32GlobalAlloc alias "GlobalAlloc"(byval uFlags as UINTeger, byval dwBytes as ulong) as any ptr
		declare function w32GlobalSize alias "GlobalSize"(byval hMem as any ptr) as ulong
	#EndIf
	Redim shared as byte bReDrawRows()
	type TypeCommentsArraySavedRows as wstring
#EndIf

'#macro Debug(s)
'
'w32SendMessage(66562 , 194 , 1 , s)
'
'#EndMacro

declare function GetPosition() as long
declare sub CursorInNewLine(iKeyFlag as Long = 0)
declare sub SetPositionWithPosAndRow(iPos as Long , iRow as Long , iStartRow as Long , iPosInConsole as Long, iAnywayScroll as Long = 0)
declare sub GetRowsAndPosFromPosition(iPosition as Long , Byref iRow as Long , Byref iPosInLine as Long , Byref iPosInLineTab as Long)
declare function GetWordFromPosition(iPos as Long , byref iRetRow as long , byref iRetPos as Long) as wstring ptr
declARE sub SetFileName(sFile as string , pwsFile as wstring ptr = 0)
declare function GetAllBuffer() as string
declare sub InsertText(pwsText as wstring ptr)
declare sub SetMarkerSelection(iClear as Long = 0)
declare sub DeleteSelection()
declare sub SetPosition(iPos as Long)
declare sub SetLenghtNumbers()
declare sub BackSpace()
declare sub SelectAll()
declare sub DeleteKey()
declare sub Comment(pSavedUndoRows as TypeCommentsArraySavedRows ptr = 0 , iSavedPrevPos as Long = 1)
declare sub UnComment(pSavedUndoRows as TypeCommentsArraySavedRows ptr = 0 , iSavedPrevPos as Long = 1)
declare function GetLenAfterScrollPos(pWstr as Wstring ptr  , iStartPos as Long ,  byref iMaxLen as Long , iLen_pWstr as Long) as LONG
declare function GetStartPosAfterScroll(pWstr as Wstring ptr  , iStartPos as Long , iLenWStr as long) as LONG
Declare sub DrawRowsEditor(iFlagNoDrawStatusBar as Long = 0)
declare sub DrawRowsExamineFiles(Byref iIndex as Long , iFoldersCount as Long)
declare sub DrawRowFileCommand(pwsCurentDir as wstring ptr , iCursor as Long , iScroll as long = 0)
declare sub DrawInitFind(pwsText as Wstring ptr , iRows as Long , iPos as Long , iCursorPosAfter as Long = 0)
declare sub DrawInPos(pwsbuf as wstring ptr , sBuf as string , iRow as Long = 0 , iPos as Long = 0 , iColor as long = -1 ,_
iRowAfter as Long  = 0 , iPosAfter as Long = 0)
declare sub DrawEncoding(iFlagSave as Long)
declare sub DrawFileExists()
declare sub SetDrawsRowsFlags(iRow1 as Long , iRow2 as Long)
#ifdef __UNIX_SYSTEM__
	declare sub execute_highlight(pwsFull as wstring ptr  , psz as zstring ptr , iRowNumber as Long , sBufLinux as string)
	declare function GetPartStringForDraw(pWstr as Wstring ptr  , iStartPos as Long , byref iMaxLen as Long , iSpaces as Long , iLen_pWstr as Long) as STRING
	declare function GetPartStringAndLen(pWstr as Wstring ptr  , iStartPos as Long , byref iLen as Long) as STRING
#else
	declare sub execute_highlight(pwsFull as wstring ptr  , pws as Wstring ptr , iRowNumber as Long , pColors as short ptr , iIndexColors as Long)
	declare function GetPartStringForDraw(pWstr as Wstring ptr  , iStartPos as Long , byref iMaxLen as Long , iSpaces as Long , iLen_pWstr as Long) as wSTRING ptr
	declare function GetPartStringAndLen(pWstr as Wstring ptr  , iStartPos as Long , byref iLen as Long) as wSTRING ptr
#EndIf
declare sub ClearLine(iRow as Long)
declare sub GetWHConsole()
declare sub CopyText(iParamCut as Long = 0)
declare Sub FileDlgNotSave()
declare Sub FileBoxSave()
declare Sub FileBoxOpen()
declare Sub FileBoxDrawTips(iFlagSave As Long)
declare sub CursorOnOff(iOn as long)
declare function File_Exitsts(sFile as string) as long
declare function File_Open(sFile as string , iMode as Long = 1) as FILE ptr
declare sub File_Close(fp as File ptr)
declare function File_Size (fp as File ptr) as long
declare function File_Eof(fp as File ptr) as Long
declare Sub File_Read_Data(fp as File ptr , pMem as any ptr , lenght as Long)
declare function File_Read_String(fp as FILE ptr) as string
declare sub File_Write_Data(fp as File ptr , Buf as aNy ptr , Lenght as Long)
declare Sub File_Write_String(fp As File ptr , s As String)

Type ConsoleParameters
	iWidthSimbols As Long ' текущее значение размера по ширине буфера консоли
	iHeightRows As Long ' текущее значение размера по высоте буфера консоли
	iPrevWidthConsole as long ' прошлое значение размера по ширине буфера консоли
	iPrevHeightConsole as long ' прошлое значение размера по высоте буфера консоли
	iCurentCursorPosInWindow As Long ' позиция курсора в окне (по ширине)
	iCurentCursorRowInWindow As Long ' позиция курсора в окне (по высоте)
	iCurentPosInRow as Long ' позиция в реальной строке
	iStartRowInWindow as Long ' значение отображаемого номера строки в верху экрана
	iScrollWidth as Long ' значение прокрутки при строке длинее ширины экрана
	iLenghtNumbers as Long ' длина чисел в номерах строк
	iCursorSafePosForUpDown as long ' позиция в строке для сохранения при нажатиях клавиш вверх\вниз
	iCursorSafePosInWindowForUpDown as long ' позиция в экране для сохранения при нажатиях клавиш вверх\вниз
	iBackupLenghtNumbers as long ' длина номеров строк для сохранения при нажатиях клавиш вверх\вниз
	iMarkerSelectionStart as Long ' начальный маркер выделения
	iColorBackGround as Long = 7 ' фон
	iColorNumbersFore as Long ' цвет текста для номеров строк
	iColorSelection as Long ' цвет выделения (когда выделение завершено)
	iColorStatusBar as Long ' цвет статусбара
	iColorFindWord as Long ' цвет выделения слова при поиске
	iColorText as Long ' цвет основного текста
	iColorFiles as Long ' цвет перечисляемых файлов
	iColorFolders as Long ' цвет перечисляемых папок
	iColorWarning as Long ' цвет предупреждающих сообщений
	iColorKeyWords as long ' цвет для подсветки ключевых слов
	iColorComments as long ' цвет для подсветки комментариев
	iColorStrings as long ' цвет для подсветки строковых литералов
	iFlagHighlight as Long ' флаг , определящий включена ли подсветка
	iInsertMode as Long ' режим редактирования (0 - замена , 1 - вставка)
	iParametersClipBoard as Long ' параметр , если 1 - стандартный буфер обмена , если 0 - свой буфер
	pszClipBuffer as zstring ptr ' буфер для буфера обмена (linux not graphics tty , dos)
	bFlagExecuteUndo as Byte ' флаг , сигнализирующий о начале операции откатов
	pList as TLISTWSTRPTR ' связный список для всех строк (wstrings)
End Type

type UTF8STRUCT
	' просто разбивка по байтам
	as ubyte b1
	as ubyte b2
	as ubyte b3
	as ubyte b4
End Type

type TFILEBOX
	
	pszFileName as zstring ptr ' указатель на строку с именем файла
	iFlagSave as Long ' сохранен ли файл
	szEncoding as zstring*15 ' кодировка файла 
	pListDir as TLISTWSTRPTR ' связный список для всех строк директорий и файлов (wstrings)
	
End Type

' структура для многострочных комментариев
type TMultiComments
	
	iBeginRow as LONG = -1 ' начальная строка комментария
	
	iBeginPos as LONg = -1 ' начальная позиция в строке
	
	iEndRow as LONG = -1 ' конечная строка комментария
	
	iEndPos as LONG = -1 ' конечная позиция в строке
	
End Type

dim shared pObj as CONSOLEPARAMETERS ' общий указатель для большинства параметров редактора

dim shared pObjFB as TFILEBOX ' общий указатель для файлового дилога

dim shared as Long iMode_F2_Selection ' флаг для установки режима выделения , требуется в основном в TTY линукса

dim shared as Byte bRepaintAnyway ' флаг устанавливаемый , когда обязательно нужно весь экран перерисовать

dim shared as Byte bFlagNoRePaintStatusBar ' флаг , определяющий когда не нужно делать перерисовку StatusBar

' массив с флагом , показывающий куда двигался курсор 
'0 ячейка (0 - не используется , 1 - влево , 2 вправо)
'1 ячейка (на сколько знакомест сдвинулся курсор)
dim shared as Byte bLeftOrRightMove(1)

redim shared pMultiComment(10) as TMultiComments ' массив многострочных комментариев

#ifdef __UNIX_SYSTEM__	
	dim shared iDimConsoleColors(16) as long = _ ' цвета в линуксе для сопоставления с цветами dos и windows
	{30 , 34 , 32 , 36 , 31 , 35 , 33 , 37 , 90 , 94 , 92 , 96, 91 , 95 , 93 , 97 , 39}
	
	dim shared as zstring*2 sSeparatorPath = "/"
	dim shared as zstring*3 sCHR10 = chr(10)
	
	type TCustomKeys
		
		as Short shKey ' код клавиши
		as Byte b(7) ' сырые данные клавиши
		
	End Type
	
	dim shared as TCustomKeys Customkeys(25) = {_ ' массив идентификации расширенных клавиш
	(CVK_HOME , {79 , 72 , 0}) ,_
	(CVK_END , {79 , 70 , 0}) ,_
	(CVK_PAGEUP , {91 , 53 , 126 , 0}) ,_
	(CVK_PAGEDOWN , {91 , 54 , 126 , 0}) ,_
	(CVK_DELETE , {91 , 51 , 126 , 0}) ,_
	(CVK_LEFT , {79 , 68 , 0}) ,_
	(CVK_RIGHT , {79 , 67 , 0}) ,_
	(CVK_UP , {79 , 65 , 0}) ,_
	(CVK_DOWN , {79 , 66 , 0}) ,_
	(CVK_INSERT , {91 , 50 , 126 , 0}) ,_
	(CVK_F1 , {79 , 80 , 0}) ,_
	(CVK_F2 , {79 , 81 , 0}) ,_
	(CVK_F3 , {79 , 82 , 0}) ,_
	(CVK_F4 , {79 , 83 , 0}) ,_
	(CVK_F5 , {91 , 49 , 53 , 126 , 0}) ,_
	(CVK_F6 , {91 , 49 , 55 , 126 , 0}) ,_
	(CVK_F7 , {91 , 49 , 56 , 126 , 0}) ,_
	(CVK_F8 , {91 , 49 , 57 , 126 , 0}) ,_
	(CVK_F9 , {91 , 50 , 48 , 126 , 0}) ,_
	(CVK_F12 , {91 , 50 , 52 , 126 , 0}) ,_
	(CVK_SHIFT_LEFT , {91 , 49 , 59 , 50  , 68 , 0}) ,_
	(CVK_SHIFT_RIGHT , {91 , 49 , 59 , 50  , 67 , 0}) ,_
	(CVK_SHIFT_UP , {91 , 49 , 59 , 50  , 65 , 0}) ,_
	(CVK_SHIFT_DOWN , {91 , 49 , 59 , 50  , 66 , 0}) ,_
	(CVK_CTRL_HOME , {91 , 49 , 59 , 53  , 72 , 0}) ,_
	(CVK_CTRL_END , {91 , 49 , 59 , 53  , 70 , 0}) _
	}
	dim shared as Long tty_fd ' хендл для терминала
	dim shared as termios save_stdin ' старые настройки терминала
	
#else
	dim shared as zstring*2 sSeparatorPath = "\"
	dim shared as zstring*3 sCHR10 = chr(13) & chr(10)
	#ifdef __FB_WIN32__
		dim shared pTConsole as TCONCOLEPARAMS ' хендл для консольных параметров
	#endif
#EndIf

dim as Short iInkey ' буфер для клавиши

dim shared as zstring*30 szKeyWords(...) = {"__date__" , "__date_iso__" , "__fb_64bit__" , "__fb_argc__" ,_
"__fb_argv__" , "__fb_arm__" , "__fb_asm__" , "__fb_backend__" , "__fb_bigendian__" , "__fb_build_date__" ,_
"__fb_cygwin__" , "__fb_darwin__" , "__fb_debug__" , "__fb_dos__" , "__fb_err__" , "__fb_fpmode__" ,_
"__fb_fpu__" , "__fb_freebsd__" , "__fb_gcc__" , "__fb_lang__" , "__fb_linux__" , "__fb_main__" ,_
"__fb_min_version__" , "__fb_mt__" , "__fb_netbsd__" , "__fb_openbsd__" , "__fb_option_byval__" ,_
"__fb_option_dynamic__" , "__fb_option_escape__" , "__fb_option_explicit__" , "__fb_option_gosub__" ,_
"__fb_option_private__" , "__fb_out_dll__" , "__fb_out_exe__" , "__fb_out_lib__" , "__fb_out_obj__" ,_
"__fb_pcos__" , "__fb_signature__" , "__fb_sse__" , "__fb_unix__" , "__fb_vectorize__" , "__fb_ver_major__" ,_
"__fb_ver_minor__" , "__fb_ver_patch__" , "__fb_version__" , "__fb_win32__" , "__fb_xbox__" , "__file__" ,_
"__file_nq__" , "__function__" , "__function_nq__" , "__line__" , "__path__" , "__time__" , "#assert" ,_
"#define" , "#else" , "#elseif" , "#endif" , "#endmacro" , "#error" , "#if" , "#ifdef" , "#ifndef" ,_
"#inclib" , "#include" , "#lang" , "#libpath" , "#line" , "#macro" , "#pragma" , "#print" , "#undef" ,_
"$dynamic" , "$include" , "$static" , "$lang" , "any" , "boolean" , "byte" , "double" , "integer" ,_
"long" , "longint" , "pointer" , "ptr" , "short" , "single" , "string" , "ubyte" , "uinteger" , "ulong" ,_
"ulongint" , "unsigned" , "ushort" , "wstring" , "zstring" , "abs" , "abstract" , "access" , "acos" ,_
"add" , "alias" , "allocate" , "alpha" , "and" , "andalso" , "append" , "as" , "assert" , "assertwarn" ,_
"asc" , "asin" , "asm" , "atan2" , "atn" , "base" , "beep" , "bin" , "binary" , "bit" , "bitreset" ,_
"bitset" , "bload" , "bsave" , "byref" , "byval" , "call" , "callocate" , "case" , "cast" , "cbyte" ,_
"cdbl" , "cdecl" , "chain" , "chdir" , "chr" , "cint" , "circle" , "class" , "clear" , "clng" , "clngint" ,_
"close" , "cls" , "color" , "command" , "common" , "condbroadcast" , "condcreate" , "conddestroy" ,_
"condsignal" , "condwait" , "const" , "constructor" , "continue" , "cos" , "cptr" , "cshort" , "csign" ,_
"csng" , "csrlin" , "cubyte" , "cuint" , "culng" , "culngint" , "cunsg" , "curdir" , "cushort" , "custom" ,_
"cvd" , "cvi" , "cvl" , "cvlongint" , "cvs" , "cvshort" , "data" , "date" , "dateadd" , "datediff" ,_
"datepart" , "dateserial" , "datevalue" , "day" , "deallocate" , "declare" , "defbyte" , "defdbl" ,_
"defined" , "defint" , "deflng" , "deflongint" , "defshort" , "defsng" , "defstr" , "defubyte" ,_
"defuint" , "defulongint" , "defushort" , "delete" , "destructor" , "dim" , "dir" , "do" , "draw" ,_
"dylibfree" , "dylibload" , "dylibsymbol" , "else" , "elseif" , "encoding" , "end" , "endif" ,_
"enum" , "environ" , "eof" , "eqv" , "erase" , "erfn" , "erl" , "ermn" , "err" , "error" , "event" ,_
"exec" , "exepath" , "exit" , "exp" , "export" , "extends" , "extern" , "false" , "field" , "fileattr" ,_
"filecopy" , "filedatetime" , "fileexists" , "filelen" , "fix" , "flip" , "for" , "format" , "frac" ,_
"fre" , "freefile" , "function" , "get" , "getjoystick" , "getkey" , "getmouse" , "gosub" , "goto" ,_
"hex" , "hibyte" , "hiword" , "hour" , "if" , "iif" , "imageconvertrow" , "imagecreate" , "imagedestroy" ,_
"imageinfo" , "imp" , "implements" , "import" , "inkey" , "inp" , "input" , "instr" , "instrrev" , "int" ,_
"is" , "isdate" , "isredirected" , "kill" , "lbound" , "lcase" , "left" , "len" , "let" , "lib" , "line" ,_
"lobyte" , "loc" , "local" , "locate" , "lock" , "lof" , "log" , "loop" , "loword" , "lpos" , "lprint" ,_
"lset" , "ltrim" , "mid" , "minute" , "mkd" , "mkdir" , "mki" , "mkl" , "mklongint" , "mks" , "mkshort" ,_
"mod" , "month" , "monthname" , "multikey" , "mutexcreate" , "mutexdestroy" , "mutexlock" , "mutexunlock" ,_
"naked" , "name" , "namespace" , "next" , "new" , "not" , "now" , "object" , "oct" , "offsetof" , "on" ,_
"once" , "open" , "operator" , "option" , "or" , "orelse" , "out" , "output" , "overload" , "override" ,_
"paint" , "palette" , "pascal" , "pcopy" , "peek" , "pmap" , "point" , "pointcoord" , "poke" , "pos" ,_
"preserve" , "preset" , "print" , "private" , "procptr" , "property" , "protected" , "pset" , "public" ,_
"put" , "random" , "randomize" , "read" , "reallocate" , "redim" , "rem" , "reset" , "restore" , "resume" ,_
"return" , "rgb" , "rgba" , "right" , "rmdir" , "rnd" , "rset" , "rtrim" , "run" , "sadd" , "scope" ,_
"screen" , "screencopy" , "screencontrol" , "screenevent" , "screeninfo" , "screenglproc" , "screenlist" ,_
"screenlock" , "screenptr" , "screenres" , "screenset" , "screensync" , "screenunlock" , "second" , "seek" ,_
"select" , "setdate" , "setenviron" , "setmouse" , "settime" , "sgn" , "shared" , "shell" , "shl" , "shr" ,_
"sin" , "sizeof" , "sleep" , "space" , "spc" , "sqr" , "static" , "stdcall" , "step" , "stick" , "stop" ,_
"str" , "strig" , "strptr" , "sub" , "swap" , "system" , "tab" , "tan" , "then" , "this" , "threadcall" ,_
"threadcreate" , "threaddetach" , "threadwait" , "time" , "timeserial" , "timevalue" , "timer" , "to" ,_
"trans" , "trim" , "true" , "type" , "typeof" , "ubound" , "ucase" , "union" , "unlock" , "until" ,_
"using" , "va_arg" , "va_first" , "va_next" , "val" , "vallng" , "valint" , "valuint" , "valulng" ,_
"var" , "varptr" , "view" , "virtual" , "wait" , "wbin" , "wchr" , "weekday" , "weekdayname" ,_
"wend" , "while" , "whex" , "width" , "window" , "windowtitle" , "winput" , "with" , "woct" , "write" ,_
"wspace" , "wstr" , "xor" , "year"}
