unit Konfig;
{$I defines.inc}
interface
uses Ovaznik;
const
cmDekodujSoubor = 1;
cmZahladStopy   = 2;

type

PKFpolozka = ^KFPolozka;
KFPolozka = object
   z:pstring;
   c:pstring;
   k:pstring;
   i:byte;
   end;

const
KFG_OK       = 0;
KFG_NOTFOUND = 1;

type
PKonfig = ^TKonfig;
TKonfig = object
     cfg:PVaznik; {na nem polozky typu PKFpolozka}
     error_code:byte;
     ignore:boolean;
     ukazatel:integer;
     orig:string;
     Constructor Init;
     Destructor Done;
     Function Zapis(s:string):boolean;virtual;
     Procedure DefinujPolozku(z,c,k:string);virtual;
     Procedure DefinujPolozku(z,c,k:string;i:byte);
     Procedure PovolNovySoubor(b:boolean);
     Procedure NactiKonfiguraci(s:string);virtual;
     Function NactiPolozku(polozka,default:string):string;virtual;
     Function NactiMultiPolozku(polozka,default,oddelovac:string):string;
     {Nacte zretezene polozky. Priklad v tele metody}
     Function Je_v_komentari(s:string):PVaznik;virtual;
     Function Vrat_ID_polozky(z:string):PVaznik;
     Function Chyba(s:string;b:byte):byte;virtual;
     Procedure Dekoduj(x:byte);virtual;
     Procedure Zakoduj;virtual;
     end;

implementation
uses Lacrt;

Procedure ZlikvidujZaznam(var p:pointer);
var v:PKFpolozka;
begin
v:=p;
ZrusPString(v^.z);
ZrusPString(v^.c);
ZrusPString(v^.k);
Dispose(v);
end;

Constructor TKonfig.Init;
var a:byte;
begin
ignore:=false;
cfg:=New(PVaznik,Init(nil,nil));
end;

Destructor TKonfig.Done;
var a:byte;
begin
Vaznik_Done_All(cfg,@ZlikvidujZaznam);
end;

Procedure TKonfig.DefinujPolozku(z,c,k:string;i:byte);
var a:byte;
    v:PKFpolozka;
begin
a:=1;
New(v);
v^.z:=Napstring(z);
v^.c:=Napstring(c);
v^.k:=Napstring(k);
v^.i:=i;
cfg^.InitNext(v);
end;

Procedure TKonfig.DefinujPolozku(z,c,k:string);
var j:byte;
begin
j:=Length(z)+Length(' = ')+Length(c);
DefinujPolozku(z,c,k,j+7);
end;

Function TKonfig.Vrat_ID_polozky(z:string):PVaznik;
var a:byte;
    p:Pvaznik;
    v:PKFpolozka;
begin
a:=1;
z:=Convert_Down(z);
p:=cfg^.dalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   if v^.z<> nil then
      if v^.z^=z then Exit(p);
   p:=p^.dalsi;
   end;
Vrat_ID_polozky:=nil;
end;

Function TKonfig.Zapis(s:string):boolean;
var f:text;
    p:PVaznik;
    v:PKFpolozka;
    t:string;
    j:byte;
begin
Assign(f,s);
Rewrite(f);
p:=cfg^.dalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   if v^.z=nil then t:=v^.k^
      else begin
      t:=v^.z^+' = ';
      if v^.c<>nil then t:=t+v^.c^;
      j:=Length(t);
      if v^.k<>nil then
         if j>v^.i then t:=t+' '+v^.k^ else t:=t+Xmezer(v^.i-j-1)+v^.k^;
      end;
   writeln(f,t);
   p:=p^.dalsi;
   end;
Close(f);
Zapis:=true;
end;

Procedure TKonfig.PovolNovySoubor(b:boolean);
begin
ignore:=b;
end;

Procedure TKonfig.Dekoduj(x:byte);
begin
end;

Procedure TKonfig.Zakoduj;
begin
end;

Function NajdiVyznamnyStrednik(t:string):longint;
var a:longint;
    c:char;
    v_tagu:boolean;
begin
v_tagu:=false;
for a:=1 to Length(t) do
    begin
    c:=t[a];
    if (c=';') and (v_tagu=false) then Exit(a);
    if c='>' then v_tagu:=false;
    if c='<' then v_tagu:=not v_tagu;
    end;
NajdiVyznamnyStrednik:=0;
end;

Procedure Tkonfig.NactiKonfiguraci(s:string);
var f:text;
    t,u:string;
    a,b:longint;
    v:PKFpolozka;
begin
orig:=s;
Dekoduj(cmDekodujSoubor);
Assign(f,orig);
Reset(f);
a:=0;
while not Eof(f) do
   begin
   readln(f,t);
   New(v);
   cfg^.InitNext(v);
   a:=Pos('=',t);
   b:=NajdiVyznamnyStrednik(t);
   v^.i:=b;
   if (a=0) or ((a>b) and (b>0))then  {v teto radce je pouze komentar}
      begin
      v^.z:=nil;
      v^.c:=nil;
      v^.k:=NaPstring(t);
      end                  {v teto radce je prirazena promenna}
      else begin
      v^.z:=NaPstring(SkipAllSpaces(Copy(t,1,a-1))); { to pred rovnasem }
      if b=0 then
         begin
         u:=SkipBegSpaces(Copy(t,a+1,255));
         if u=''
            then v^.c:=nil                {vyraz konci rovnasem a nic za nim}
            else v^.c:=NaPstring(u);      {to za rovnasem}
         v^.k:=nil;                                            {bez komentare}
         end else
         begin
         {to za rovnasem}
         u:=SkipEndSpaces(SkipBegSpaces(Copy(t,a+1,b-(a+1))));
         if u=''
            then begin beep;v^.c:=nil;end                {vyraz konci rovnasem a nic za nim}
            else v^.c:=NaPstring(u);      {to za rovnasem}
         v^.k:=NaPstring(Copy(t,b,255));                       {komentar}
         end;
      end;
   end;
Close(f);
Dekoduj(cmZahladStopy);
end;

Function TKonfig.NactiPolozku(polozka,default:string):string;
var p:PVaznik;
    v:PKFpolozka;
    cp:string;
begin
error_code:=kfg_ok;
cp:=Convert_down(polozka);
p:=cfg^.dalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   if (v^.z<>nil) and (cp=Convert_Down(v^.z^)) then
      if v^.c=nil then Exit('') else Exit(v^.c^);
   p:=p^.dalsi;
   end;

error_code:=kfg_notfound;
if default<>'' then
   NactiPolozku:=default else
   begin
     Chyba('Chyba v konfiguracnim souboru !'+#13#10+
           'Nenalezena promenna [ '+polozka+' ]',0);
   end;
end;


Function PorovnaniMultiPolozek(s,pol:string):boolean;
var a:byte;
begin
if s=pol then Exit(true);
for a:=0 to 9 do if s+Mystr(a)=pol then Exit(true);
PorovnaniMultiPolozek:=false;
end;


Function TKonfig.NactiMultiPolozku(polozka,default,oddelovac:string):string;
{Priklad:
 s:=NactiMultiPolozku('Info','?',',')

Nacte do S vsechny polozky z Info, Info0, Info1, Info2, Info3 az Info9
Jednotlive podretezce oddeli oddelovacem ","}
var p:PVaznik;
    v:PKFpolozka;
    cp,n,i:string;
begin
error_code:=kfg_ok;
cp:=Convert_down(polozka);
i:='';
p:=cfg^.dalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   if (v^.z<>nil) then
      begin
      n:=Convert_Down(v^.z^);
      if PorovnaniMultiPolozek(cp,n) then
         if v^.c<>nil then i:=i+oddelovac+v^.c^;
      end;
   p:=p^.dalsi;
   end;

if i='' then
   begin
   error_code:=kfg_notfound;
   if default<>'' then
      NactiMultiPolozku:=default else
         begin
         Chyba('Chyba v konfiguracnim souboru !'+#13#10+
               'Nenalezena promenna [ '+polozka+' ]',0);
         end;
   end
   else begin
   Delete(i,1,Length(oddelovac));
   NactiMultiPolozku:=i;
   end;
end;

Function TKonfig.Je_v_komentari(s:string):PVaznik;
var p:PVaznik;
    v:PKFpolozka;
    i:string;
begin
s:=Convert_down(s);
p:=cfg^.dalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   i:='';
   if v^.z<>nil then i:=i+v^.z^;
   if v^.c<>nil then i:=i+v^.c^;
   if v^.k<>nil then i:=i+v^.k^;
   if s=Copy(Convert_down(i),1,Length(s)) then Exit(p);
   p:=p^.dalsi;
   end;
Je_v_komentari:=nil;
end;


Function TKonfig.Chyba(s:string;b:byte):byte;
begin
asm mov ax,3;int 10h;end;
writeln(s);
Halt(b);
end;

end.
