unit tedradky;

interface
uses dos;
type

PEdRadek = ^TEdRadek;
TEdRadek = object
       p:pchar;                  {buffer na znaky radku}
       pp:longint;               {velikost bufferu}
       spp:longint;              {skutecne zaplneny pocet bajtu}
       y1,y2:longint;            {Y-ova pozice na pomyslne strance (pocita se od 0)}
       yy:longint;               {cislo radku}
       gd:longint;               {delka radku v pixelech}
       smezerou:boolean;         {pri zalamovani - jestli je v retezci mezera, tak zalomim podle mezery. Jestli ne, zalomim natrvrdo}
                                 {pri nacitani se sem, uklada, jestli je radek uz ukoncen nebo zatim ne}
       crlf:boolean;             {je radek ukoncen natvrdo? DEFAULTNE TRUE}
       Constructor Init;
       Procedure Vloz(s:pchar;poz:longint);
       Procedure Vloz(s:pchar;sd,poz:longint);
       Procedure VlozS(s:string;poz:longint);
       Procedure Vyjmi(poz,l:longint);
       Function Delka:longint;
       Function VratZnak(n:longint):char;
       Function VratString(poz,delk:longint):string;
       Function ExportujPchar:pchar;
       Procedure Rozdel(var nv:TEdRadek;pozice,vypust:longint);
       {rozdeli retezec na dve casti. nedela zadnou realokaci ani presuny pameti}
       {pri tom muze ze zacatku druheho radku vypustit VYPUST znaku}
       Procedure Rozdel(var nv:TEdRadek;pozice:longint);
       Destructor Done;
       end;

implementation
Constructor TEdRadek.Init;
begin
spp:=1;
pp:=ED_GRANULARITA;
GetMem(p,pp);
p[0]:=#0;
crlf:=true;
gd:=0;
end;

Function TEdRadek.VratZnak(n:longint):char;
begin
VratZnak:=p[n-1];
end;

Function TEdRadek.Delka:longint;
begin
Delka:=PLength(p);
end;

Function TEdRadek.VratString(poz,delk:longint):string;
var i:longint;
    s:string;
begin
s:='';
dec(poz);
if poz+delk>=spp then delk:=spp-poz+1;  {blbuvzdorna ochrana}
for i:=poz to poz+delk-1 do s:=s+p[i];
VratString:=s;
end;

Function TEdRadek.ExportujPchar:pchar;
var s:pchar;
begin
GetMem(s,spp);
Move(p^,s^,spp);
ExportujPchar:=s;
end;

Procedure TEdRadek.Vloz(s:pchar;sd,poz:longint);
var np:Pchar;
    opp:longint;
    ddd:string;
begin
if poz<1 then poz:=1;
if poz>spp then poz:=spp;
dec(poz);              {pozici budu cislovat od 1, tak jako u typu string}
if sd=0 then Exit;      {diskutabilni. snad je to OK}
if spp+sd>pp then       {bude treba provest realokaci pameti}
   begin
   opp:=pp;
   pp:=((spp+sd) div ED_GRANULARITA+1)*ED_GRANULARITA;
   GetMem(np,pp);      {pripravim novy buffer}
   Move(p[0],np[0],poz);    {cast stareho pred vlozenim noveho}
   Move(s[0],np[poz],sd+1); {novy kus dam za stary a zkopiruju i #0}
   if spp-1>poz then
      Move(p[poz],np[poz+sd],spp-poz+1); {cast stareho, ktera ted bude}
                                             {za novym. Znovu kupiruju i s #0}
   inc(spp,sd);
   FreeMem(p,opp);
   p:=np;
   end
   else begin          {realokace pameti nebude treba}
   Move(p[poz],p[poz+sd],spp-poz); {posun textu vpravo od vlozeneho}
   Move(s[0],p[poz],sd);          {a vlozeni S}
   inc(spp,sd);
   end;
if spp=0 then beep;
end;

Procedure TEdRadek.Vloz(s:pchar;poz:longint);
var i:longint;
begin
i:=PLength(s);
Vloz(s,i,poz);
end;


Procedure TEdRadek.VlozS(s:string;poz:longint);
var qq:pchar;
    i:longint;
begin
i:=Length(s);
s:=s+#0;
qq:=@s[1];
Vloz(qq,i,poz);
end;

Procedure TEdRadek.Vyjmi(poz,l:longint);
var t1,t2:Pchar;
    np:longint;
begin
dec(poz);
t1:=p;inc(t1,poz);
t2:=p;inc(t2,poz+l);
Move(t2^,t1^,spp-poz-1);
dec(spp,l);
np:=(spp div ED_GRANULARITA+1)*ED_GRANULARITA;
if np<>pp then ReAllocMem(p,np);  {P uz ale muze ukazovat jinam (obsah P se muze zmenit)}
pp:=np;
if spp=0 then writeln(#7);
end;

Procedure TEdRadek.Rozdel(var nv:TEdRadek;pozice,vypust:longint);
var n:pchar;
    i:longint;
begin
n:=p;
dec(pozice);
inc(n,pozice+vypust);
i:=spp-pozice-1;
nv.Vloz(n,i-vypust,1);
Vyjmi(pozice+1,i);
end;

Procedure TEdRadek.Rozdel(var nv:TEdRadek;pozice:longint);
begin
Rozdel(nv,pozice,0);
end;

Destructor TEdRadek.Done;
begin
if p<>nil then FreeMem(p);
pp:=0;
spp:=0;
end;
end.
