;
; WDe Copyright(C)2004 - Ben Cadieux
;
; Welcome to the code.  It's a bit of a mess still, but it's gradually
; getting a little cleaner.  Some of the comments still around were
; written back when I never intended anyone to see the source, so they
; may not be particularly readable by anyone besides me for now.
;
; You might notice "\Fix" in a few spots; this refers to my having
; hard-coded 512 bytes for sector sizes, not necessarily a bug.  Often
; I just need to go over the code and make sure it doesn't need to be fixed.
;
; I assemble the source with tasmx 4.1 and tlink 7.1.32.2
; I'll probably convert the source to NASM when I get used to the syntax.
;
; for lfn/undelete:
;  if (spot < 33), then a calculation needs to be done to check
;  if it's the first sector of the current cluster or start of the root.
;  for fat32, ((currentsector - datastart % spc) = 0) should be true if 
;  at cluster start
;
; Future Optimizations:
;  - repne can possibly be used to optimize finding strings
;  - fix openfile and createfile to ax=6C00h for over 2GB
;
; for CD-rom drives/bootsector:
; offset:
;
;  50 (4); total sectors on drive
;  80 (2); bytes per sector
;  8C (4): type L path table location
;  94 (4); type M path table location
;
; for NTFS partitions/bootsector:
; offset:
;
;  0B (2): bytes per sector
;  0D (1): sectors per cluster
;  0E (1): reserved sectors
;  10 (5): 0
;  15 (1): media descriptor (F8h)
;  16 (2): 0
;  1C (4): LBA partition start
;  18 (2): sectors per track
;  1A (2): # of heads
;  20 (4): 0
;  28 (8): total number of sectors
;  24 (1): drive # (80h)
;  30 (8): logical cluster for file $MFT
;  38 (8): logical cluster for file $MFTmirr
;  40 (4): bytes per file record segment 2^(-1*this value, signed)
;  44 (4): clusters per index block (ie directories)
;  50 (4): checksum?
;
; MFT: first 16 entries are inaccessible to OS, known as metafiles
; each entry is ~1k - the first one is the MFT itself. others:
;
; calculation in bootsector for bytes per file record is to negate the
; value (two's complement), then shift the value 1 stored in eax left by
; that value. eax = 10000000000 = 1024
;
;
; $logfile:     list of steps used for file recovery
; $volume:      volume info
; $attrdef:     table of attribute names, numbers & descriptions
; $:            root folder
; $bitmap:      cluster bitmap?
; $boot:        bpb copy?
; $badclus:     bad cluster table
; $secure:      security descriptors for all files
; $upcase:      converts lowercase chars to matching unicode chars
; $quota:       info like quotas, reparse point data, object identifiers?
;
; backup bootsector is in the middle of the drive
;
; possible future functions:
;  - validcluster: clear/set carry flag depending on whether or not a
;                  cluster stored in eax is within the boundaries of the
;                  logical partition
;  - validsector:  same as above but for sectors
;

locals
assume ds:WDE, cs:WDE
WDE segment public word 'CODE'
org 100h
.386p

;        DEBUG            EQU 1   ; comment out to assemble in regular mode
        UNDEFINED        EQU 0

; "fattype" variable
        FAT32            EQU 4
        FAT16            EQU 2
        FAT12            EQU 1

; "viewmode" (low byte)
        MBRVIEW          EQU 1
        BOOTSECTORVIEW   EQU 2
        FAT12VIEW        EQU 3
        FAT16VIEW        EQU 4
        FAT32VIEW        EQU 5
        ROOTVIEW         EQU 6
        DEBUGVIEW        EQU 7
        DATAVIEW         EQU 98      ; not manually set modes
        FSINFOVIEW       EQU 100     
        PICKFATVIEW      EQU 101

; "viewmode" (high byte)
        AUTODETECT       EQU 0
        STATIC           EQU 1

; colors for the display
        EDITCOLOR        EQU 0cah        ; light green on red
        DEFAULTCOLOR     EQU 1fh         ; white on blue
        HIGHLIGHTCOLOR   EQU 30h         ; black on dark cyan

; "editmode" variable
        DEFAULTEDIT      EQU 0
        ASCIIEDIT        EQU 1

; "displaymode" variable
        HEX              EQU 0
        BINARY           EQU 1

; "drivetype" variable
        PHYSICAL         EQU 00000001b
        FAT              EQU 00000010b
        CDROM            EQU 00000011b

; "rwfunction" variable
        OLDINT13         EQU 00000001b
        NEWINT13         EQU 00000010b
        OLDINT25         EQU 00000100b
        NEWINT21         EQU 00001000b
        CDCOOKED         EQU 00010000b
        CDRAW            EQU 00100000b
        FILEFUNC         EQU 01000000b


        PRW              EQU 11111100b
        LRW              EQU 11110011b
        CRW              EQU 11001111b
        ; these few above can be used with the 'test' instruction
        ; to check a particular read/write function being used
        ; for specific things

; "status" variable
        SUCCESS          EQU 0
        ERROR            EQU 1

; "rw" variable
        READ             EQU 0
        WRITE            EQU 1

; attribute bits
        READONLY         EQU 00000001b
        HIDDEN           EQU 00000010b
        SYSTEM           EQU 00000100b
        VOLUME           EQU 00001000b
        DIRECTORY        EQU 00010000b
        ARCHIVE          EQU 00100000b

; ascii
        BACKSPACE_KEY    EQU 8
        CTRLENTER_KEY    EQU 10
        ENTER_KEY        EQU 13
        ESCAPE_KEY       EQU 27
        SPACE            EQU 32
        QUOTATION        EQU 34
        PERCENT          EQU 37
        COMMA            EQU 44
        FORWARD_SLASH    EQU 47
        SEMICOLON        EQU 59
        LESS_THAN        EQU 60
        GREATER_THAN     EQU 62
        QUESTION_MARK    EQU 63
        PIPE             EQU 124


; scan codes
        TAB_KEY          EQU 15
        F1_KEY           EQU 59
        F2_KEY           EQU 60
        F3_KEY           EQU 61
        F4_KEY           EQU 62
        F5_KEY           EQU 63
        F6_KEY           EQU 64
        F7_KEY           EQU 65
        F8_KEY           EQU 66
        PAGEUP_KEY       EQU 73
        LEFT_KEY         EQU 75
        RIGHT_KEY        EQU 77
        UP_KEY           EQU 72
        DOWN_KEY         EQU 80
        PAGEDOWN_KEY     EQU 81
        DEL_KEY          EQU 83
        CTRLPAGEDOWN_KEY EQU 118
        CTRLPAGEUP_KEY   EQU 132
        CTRLLEFT_KEY     EQU 115
        CTRLRIGHT_KEY    EQU 116
        CTRLHOME_KEY     EQU 119
        CTRLEND_KEY      EQU 117

        ; it's far more code efficient to use scan codes
        ; instead of checking for both upper/lower case letters
        ; when the case is not significant
        LETTER_A         EQU 30
        LETTER_B         EQU 48
        LETTER_C         EQU 46
        LETTER_F         EQU 33
        LETTER_H         EQU 35
        LETTER_I         EQU 23
        LETTER_L         EQU 38
        LETTER_N         EQU 49
        LETTER_O         EQU 24
        LETTER_P         EQU 25
        LETTER_S         EQU 31
        LETTER_Y         EQU 21
        LETTER_Z         EQU 44

; "handling" variable
        ABORT_OPERATION  EQU 0
        QUERY_FILL       EQU 1
        QUERY_SKIP       EQU 2
        IGNORE_ERRORS    EQU 3

; "fillflag" variable - low byte (type of fill)
        RANDOM           EQU 0
        INVERSE          EQU 1
        BIT8             EQU 2
        BIT12            EQU 3
        BIT16            EQU 4
        BIT32            EQU 5
;                     - high byte (for BIT fills)
        INCREMENT        EQU 0
        DECREMENT        EQU 1

; "fileflag" variable
;        LIMIT2GB         EQU '2'
;        LIMIT4GB         EQU '4'



Start:

  call init                     ; init: - set video mode
                                ;       - set default byte to edit
                                ;       - print copyright info
                                ;       - seed random timer
                                ;       - wipe variables
                                ;       - set some defaults
                                ;       - replace int24h

setdrive:                       ; sets the drive being edited

  cmp byte ptr [driveflag], 0
  jne displayfnreq
  mov dx, offset drivemsg       ; "Drive:"
  call printbottom              ; print on the bottom of the screen

  getkeyagain3:
  call cursorgetkey             ; cursorgetkey turns the cursor on, gets
                                ; a key and then shuts the cursor back off
                                ; again (for normal editing)
  abortsetdrive:
  cmp byte ptr [viewmode], UNDEFINED
                                ; if the low byte of viewmode is 0 then 
  jne notfirstset               ; the program hasn't been run before
    cmp al, ESCAPE_KEY
    jne notfirstset             ; if it's not been run then we're
    call quit                   ; in the initial screen, so hitting
    jmp setdrive                ; escape should start the quit sequence
  displayfnreq:
    call getfilename
    cmp ah, TAB_KEY
    jne dstdrive
    mov byte ptr [driveflag], 0 ; switch to reading drive letters with tab
    jmp setdrive

    dstdrive:
    mov al, ESCAPE_KEY
    cmp cx, 68
    je abortsetdrive
    call findfile
    jc setdrive
    call getfilesize
    mov eax, dword ptr [filesize]       ; file must be 1+ sectors in size
    cmp eax, 512
    jb toosmalltomount
    mov dword ptr [rwfilesize], eax
    call openfile
    mov ax, word ptr [filehandle]
    mov word ptr [rwhandle], ax
    mov bx, PHYSICAL*100h+FILEFUNC      ; bh = physical, bl=filefunc
    mov al, 0FFh
    jmp doreaddevice
  toosmalltomount:
    mov dx, offset toosmall
    call printerror
    jmp setdrive
  notfirstset:                  ; otherwise it should go back to the menu

  cmp al, ESCAPE_KEY
  je mainmenu

  cmp ah, TAB_KEY
  jne noswitch2f
    mov byte ptr [driveflag], 1
    jmp setdrive
  noswitch2f:

  cmp al, '0'                   ; any key below '0' should be ignored
  jb getkeyagain3               ; since the user should be typing
                                ; a drive letter/number to edit
  cmp al, '9'
  jbe hdphysical                ; read a physical drive

  cmp al, 'A'                   ; ignore anything below 'A'
  jb getkeyagain3

  cmp al, 'Z'                   ; logical drive (capital letter)
  jbe capitaldrive

  cmp al, 'z'                   ; ignore anything above 'z'
  ja getkeyagain3

  cmp al, 'a'                   ; ignore anything below 'a'
  jb getkeyagain3

  sub al, 32                    ; a-A = 32.  All lowercase letters
                                ; are converted to uppercase in this
                                ; manner.

  capitaldrive:

  sub al, 64                    ; A = 65, so subtracting 64 would
                                ; make it 1, the first drive letter
                                ; for function ax=7305h/21h
  mov bx, FAT*100h + NEWINT21   ; bh = FAT, bl = NEWINT21
  doreaddevice:
  mov dx, offset readingdrive
  call printbottom

  push dword ptr [sector]               ; if drive switching is unsuccessful
  push word ptr [drive]                 ; the original drive/sector has to
  push word ptr [rwfunction]            ; be restored
  push dword ptr [drivestart]
  mov byte ptr [subsector], 0           ; rwfunction is the 'read/write'
  mov dword ptr [sector], 0             ; function being used.  2 for CDrom,
  mov dword ptr [drivestart], 0
  mov word ptr [rwfunction], bx         ; 3 for int 13h/ah=48h

  setdrivevar:

  mov byte ptr [drive], al      ; attempt to read sector 0
  call rwsect

  cmp byte ptr [status], ERROR   ; failed?
  je driveerror

  pop edx
  pop edx                       ; if the drive could be set just fine,
  pop edx                       ; then the pushed data (last drive, etc)
                                ; is no longer needed
  jmp readnext



  hdphysical:                           ; this is for setting up the
                                        ; editing for a physical
                                        ; rather than logical drive

    mov cl, al                          ; back up drive number
    mov dx, offset fhdmsg               ; choose between floppy and HD
    call printbottom
          getfh:
          call cursorgetkey

          cmp ah, LETTER_F
          je readasfloppy

          cmp ah, LETTER_H
          je readashd

          cmp al, ESCAPE_KEY
          je setdrive

          jmp getfh
          readashd:
          add cl, 80h                   ; physical hard drive.
          readasfloppy:
          sub cl, 30h
    mov al, cl
;    al: 80h+ = hard drive
;    al: 00h+ = floppy
    dophysicalread:
    push dword ptr [sector]
    push word ptr [drive]
    push word ptr [rwfunction]
    push dword ptr [drivestart]
    mov dword ptr [drivestart], 0
    mov dword ptr [sector], 0           ; qword for sector to edit
    mov dword ptr [sector2], 0          ; sector2 is the high dword
                                        ; WDe doesn't support it
    mov byte ptr [subsector], 0
    mov byte ptr [rwfunction], NEWINT13
    mov byte ptr [drivetype], PHYSICAL
  jmp setdrivevar

  driveerror:

  pop word ptr [rwfunction]             ; restore original drive settings
  pop word ptr [drive]                  ; if reading the new drive failed
  pop dword ptr [sector]

  cmp byte ptr [viewmode], UNDEFINED
  je setdrive

  jmp mainmenu

 readnext:
  call setvariables         ; sets all the variables obtained from bootsect

 redraw:
  call cleardisplay
  call printoffset          ; prints the current offset
 mainmenu:
 mov byte ptr [handling], ABORT_OPERATION
 call updatescreen
 mov dx, offset menu
 call printbottom
 getkeyagain:

   call printview
   mov ax, word ptr [cxy]       ; set [xy] to cursor coordinates so that
   mov word ptr [xy], ax        ; functions like changemode color the right
                                ; spot on the screen
 call getkey

 cmp al, ESCAPE_KEY
 jne noquit0
   call quit
   jmp mainmenu
 noquit0:

 cmp ah, PAGEDOWN_KEY
 je nextsect

 cmp ah, PAGEUP_KEY
 je lastsect

 cmp ah, CTRLPAGEDOWN_KEY
 je nextsect1000

 cmp ah, CTRLPAGEUP_KEY
 je lastsect1000

 cmp al, ENTER_KEY
 je entercluster

 cmp al, CTRLENTER_KEY
 je retfat

 cmp ah, CTRLLEFT_KEY
 je recursechain

 cmp ah, CTRLRIGHT_KEY
 je jumpcluster

 cmp ah, CTRLHOME_KEY
 je jumptobootsector

 cmp ah, CTRLEND_KEY
 je jumptolastsect

 cmp ah, LEFT_KEY
 je moveleft

 cmp ah, RIGHT_KEY
 je moveright

 cmp ah, UP_KEY
 je moveup

 cmp ah, DOWN_KEY
 je movedown

 cmp ah, F1_KEY
 je savetodisk

 cmp byte ptr [drivetype], CDROM
 je cdromfileopts
   cmp ah, F2_KEY
   je fileoperations
 cdromfileopts:
   cmp ah, F2_KEY
   je savefileoptions

 cmp ah, F3_KEY
 je jumpto

 cmp ah, F4_KEY
 je viewoptions

 cmp ah, F5_KEY
 je searchoptions

 cmp ah, F6_KEY
 je functions

 cmp ah, F7_KEY
 je setdrive

 cmp ah, TAB_KEY
 je changemode

 cmp ah, DEL_KEY
 je domod
 cmp al, 0
 je skipmod
 domod:
 cmp byte ptr [editmode], ASCIIEDIT
 je modascii
 skipmod:
 cmp byte ptr [displaymode], BINARY
 je modbinary

 cmp al, 'f'
 ja getkeyagain

 cmp al, '0'
 jb getkeyagain

 cmp al, '9'
 jbe number

 cmp al, 'a'
 jae mletter

 cmp al, 'F'
 ja getkeyagain

 cmp al, 'A'
 jae cletter

 jmp getkeyagain
;-------------------------------------------------------
displaybinary:
  push ax
  mov dh, 8
  printbitsloop:
    cmp dh, 4
    jne dontaddspace
      inc byte ptr [xy]
    dontaddspace:
    shl al, 1
    mov dl, '0'
    jnc bitnotone
      inc dl
    bitnotone:
    call printchar
    dec dh
  jnz printbitsloop
  pop ax
  ret
;-------------------------------------------------------
spotinbx:                               ; this function figures out what
  mov bx, word ptr [spot]               ; byte [spot] should actually be
  push cx                               ; pointing to within the buffer.
  mov cl, byte ptr [subsector]
  shl cx, 9
  add bx, cx
  pop cx
  ret
;-------------------------------------------------------
functions:
  mov dx, offset funcmenu
  call printbottom
  mov al, 1
  cmp byte ptr [drivetype], FAT
  jne nlfdf

ifdef DEBUG
  add byte ptr [xy], 3
  mov dx, offset unformenu
  call printstring
endif

  mov si, offset readbuffer
  xor bx, bx
  call finddirectory 
  mov al, 1
  jc nlfdf                      ; dir not found
    call spotinbx               ; if a directory is found, check to see if
    and bl, 11100000b           ; the very first entry of the current file
                                ; we're in (cur_byte / 32) is equal to
                                ; E5h, if so, we should display the option
                                ; to undelete

    cmp byte ptr [readbuffer+bx], 0E5h
    jne nlfdf
    mov al, 0
  nlfdf:
  mov byte ptr [dirflag], al

  cmp al, 1
  je getkeyagain13
  add byte ptr [xy], 3
  mov dx, offset undelmenu
  call printstring

  getkeyagain13:
  call getkey

  cmp al, ESCAPE_KEY
  je mainmenu

  cmp ah, F1_KEY
  je fillfunctions

  cmp ah, F2_KEY
  je restrictsectors

  cmp byte ptr [drivetype], FAT
  jne getkeyagain13

  ifdef DEBUG                             ; extra view for registers
    cmp ah, F3_KEY
    je unformat
  endif

  cmp byte ptr [dirflag], 1
  je getkeyagain13
    ifdef DEBUG                             ; extra view for registers
      cmp ah, F4_KEY
      else
      cmp ah, F3_KEY
    endif
    je undelete
  jmp getkeyagain13
;------------------------------------------------------
ifdef DEBUG                             ; extra view for registers
 include UNFORMAT.WDE
endif
;------------------------------------------------------
restrictsectors:
  mov dx, offset abmsg
  call printbottom
  rsgetkeys:
  call cursorgetkey
  cmp al, ESCAPE_KEY
  je functions
  cmp ah, LETTER_A
  je restrictabove
  cmp ah, LETTER_B
  je restrictbelow
  jmp rsgetkeys
  restrictabove:
    mov eax, dword ptr [sector]
    add dword ptr [drivestart], eax
    xor eax, eax
    mov dword ptr [sector], eax
      mov dx, offset plmsg
      call printbottom
      rsgetkeys2:
      call cursorgetkey
      cmp al, ESCAPE_KEY
      je functions
      cmp ah, LETTER_P
      je physrestr
      cmp ah, LETTER_F
      je fatrestr
      jmp rsgetkeys2
    fatrestr:
      mov dl, FAT
      jmp donesetpl
    physrestr:
      mov dl, PHYSICAL
    donesetpl:
      mov byte ptr [drivetype], dl
      call setvariables
    jmp mainmenu
  restrictbelow:
    mov eax, dword ptr [sector]
    mov dword ptr [dataend], eax
    jmp mainmenu
;------------------------------------------------------
undelete:
  mov byte ptr [fromfat], 1
  call spotinbx                         ; move to the beginning of the
    and bl, 11100000b                   ; file entry
    add bx, offset readbuffer
  mov eax, dword ptr [bx+1Ch]
  mov dword ptr [filesize], eax
  mov ax, word ptr [bx+14h]             ; get start cluster (high 16-bits)
  shl eax, 16
  mov ax, word ptr [bx+1Ah]             ; get start cluster (low 16-bits)
  ; bounds check
  cmp eax, 2
  jb invclust                           ; not a valid cluster if it's below 2
  mov dword ptr [cluster], eax
  call getfatentry
  cmp byte ptr [status], ERROR          ; i don't recall why i did this
  jne filenoexceed
    mov dx, offset fileexceeded
    call printerror
    jmp functions
    invclust:
    mov dx, offset greatmsg
    call printerror
    jmp functions
  filenoexceed:
  test eax, eax
  jz undel1good
  mov dx, offset nofirstcluster
  call printerror
  jmp functions
  undel1good:

  mov dx, offset firstcharmsg
  call printbottom
  getkeyagain16:
  call cursorgetkey
  cmp al, ESCAPE_KEY
  je functions
  cmp al, '0'
  jb getkeyagain16
  cmp al, '9'
  jbe unok1
  cmp al, 'a'
  jb kci
  sub al, 32
  kci:
  cmp al, 'A'
  jb getkeyagain16
  cmp al, 'Z'
  jbe unok1
  jmp getkeyagain16
  unok1:
    call spotinbx
    and bl, 11100000b
    add bx, offset readbuffer
    mov byte ptr [bx], al
    call copybuffer
    mov byte ptr [rw], WRITE
    call rwsect

    mov dx, offset undeletingmsg
    call printbottom

    xor eax, eax
    mov ax, word ptr [bps]                ; \Fixed?/
    xor ebx, ebx
    mov bl, byte ptr [spc]
    mul ebx
    mov dword ptr [bpc], eax

    undelloop:
    mov eax, dword ptr [bpc]
    cmp dword ptr [filesize], eax
    jbe writeeof
      sub dword ptr [filesize], eax
      mov ebx, dword ptr [cluster]
    getnextentry:
      inc ebx
      mov eax, ebx
    call getfatentry
  cmp byte ptr [status], ERROR
  jne filenoexceed2
    mov dx, offset fileexceeded
    call printerror
    jmp functions
  filenoexceed2:
     test eax, eax
     jnz getnextentry

    mov eax, ebx
    mov ebx, dword ptr [cluster]
    mov dword ptr [cluster], eax
    call putfatentry
    jmp undelloop
    writeeof:
    mov ebx, dword ptr [cluster]
    mov eax, 0FFFFFFFh
    call putfatentry

    call updatescreen
    mov dx, offset doneudmsg
    call printerror
  jmp functions
;------------------------------------------------------
fillfunctions:
  mov dx, offset fillmenu
  call printbottom

  getkeyagain14:
  call getkey

  cmp al, ESCAPE_KEY
  je functions

  cmp ah, F1_KEY
  je fillhex

  cmp ah, F2_KEY
  je fillstring

  cmp ah, F4_KEY
  je decremental

  mov byte ptr [fillflag+1], INCREMENT

  cmp ah, F3_KEY
  je incremental

  mov byte ptr [fillflag], INVERSE

  cmp ah, F5_KEY
  je fillinvrand

  mov byte ptr [fillflag], RANDOM

  cmp ah, F6_KEY
  je fillinvrand

  jmp getkeyagain14
;-----------------------------------------------------
decremental:
  mov byte ptr [fillflag+1], DECREMENT
incremental:
  mov dx, offset idmenu
  call printbottom
  getkeyagain15:
  call getkey

  cmp al, ESCAPE_KEY
  je fillfunctions

  mov byte ptr [valuebuffer], 1
  mov dx, offset hexmsg

  cmp al, ESCAPE_KEY
  jne notesc
    cmp byte ptr [fillflag+1], DECREMENT
    je decremental
    jmp incremental
  notesc:

  mov byte ptr [fillflag], BIT8

  cmp ah, F1_KEY
  je incbyte

  mov byte ptr [fillflag], BIT12

  cmp ah, F2_KEY
  je inc12

  mov byte ptr [fillflag], BIT16

  cmp ah, F3_KEY
  je incword

  mov byte ptr [fillflag], BIT32

  cmp ah, F4_KEY
  je incdword

  jmp getkeyagain15

;---------------------------------------------------
fillcommon:                     ; zero flag set if no more sectors to fill
  call checkabort               ; carry flag set if there's an error
  je commonfillerror
  call copybuffer
  mov byte ptr [rw], WRITE
  call rwsect
  cmp byte ptr [status], ERROR
  je commonfillerror
  dec dword ptr [value]
  jz donefillinc
  inc dword ptr [sector]
  pushad
  call printcounts
  popad
  push cs
  pop es
  mov di, offset readbuffer
  test di, 0FFFFh
donefillinc:
  clc
  ret
commonfillerror:
  stc
  ret
;-----------------------------------------------------
do12fill:
  stosb
  dec cx                            ; ran out of bytes to this sector?
  jnz n1s22
   call fillcommon
   jc fillerror
   jz donefillrand
   mov cx, word ptr [bps]              ; \Fixed?/
  n1s22:
   mov bh, ah
   call cax12
   mov dx, ax
   shl al, 4
   or al, bh
   stosb
   dec cx
  jnz n2s22
   call fillcommon
   jc fillerror
   jz donefillrand
   mov cx, word ptr [bps]              ; \Fixed?/
  n2s22:
   mov ax, dx
   shr ax, 4
   stosb
   dec cx
  jnz n3s22
   call fillcommon
   jc fillerror
   jz donefillrand
   mov cx, word ptr [bps]              ; \Fixed?/
  n3s22:
   mov ax, dx
   call cax12
  jmp do12fill
;-----------------------------------------------------
cax12:
  cmp byte ptr [fillflag+1], INCREMENT
  je doinc12
    dec ax
  cmp ax, 0FFFFh
  jne loopdi12
    and ah, 0Fh
  jmp loopdi12

  doinc12:
    inc ax
  cmp ax, 0FFFh
  jbe loopdi12
    xor ax, ax
  loopdi12:
ret
;-----------------------------------------------------
inc12:
  mov eax, 0FFFh
jmp fillamount
;-----------------------------------------------------
incbyte:
  mov eax, 0FFh
jmp fillamount
;-----------------------------------------------------
incdword:
  mov eax, 0FFFFFFFFh
jmp fillamount
;-----------------------------------------------------
incword:
  mov eax, 0FFFFh
;-----------------------------------------------------
fillamount:
  call gethex                    ; valuebuffer gets set in menu section
;-----------------------------------------------------
fillinvrand:
  call getnos
  je fillfunctions
    mov dx, offset readingmsg
    call printbottom
  mov eax, ebx
  push cs
  pop es

  push dword ptr [sector]
  mov di, offset readbuffer
  keeprandomfill:
  mov cx, word ptr [bps]                ; \Fixed?/

  cmp byte ptr [fillflag], BIT12
  je do12fill
  cmp byte ptr [fillflag], BIT8         ; writing byte at a time?
  je dontshift                          ; then dont divide by 2
    shr cx, 1                           ; divide by 2 to write words
  cmp byte ptr [fillflag], BIT32        ; if we're writing 32-bits at a time
  jne dontshift
    shr cx, 1                           ; divide by 2 again
  dontshift:
  cmp byte ptr [fillflag], INVERSE
  jne randomloop                        ; inverse function requires reading
    mov si, di                          ; every sector to reverse that data
    call rwsect
    cmp byte ptr [status], ERROR
  je fillerror

  randomloop:
    cmp byte ptr [fillflag], INVERSE
    jne tryrandfill
      lodsw                             ; reverse a word at a time
      not ax
    jmp continuerandinv
    tryrandfill:
    cmp byte ptr [fillflag], RANDOM
    jne continuerandinv
      push cx
      call rand                         ; generate random numbers
      pop cx
    continuerandinv:
    cmp byte ptr [fillflag], BIT32
    je fill32bit
    cmp byte ptr [fillflag], BIT8
    je fill8bit
    stosw

    cmp byte ptr [fillflag], BIT16
    jne doriloop                        ; word
      cmp byte ptr [fillflag+1], DECREMENT
      je decword
      inc ax                            ; increment word
      jmp doriloop
      decword:
      dec ax                            ; decrement word
      jmp doriloop

    fill32bit:                          ; dword
      stosd
      cmp byte ptr [fillflag+1], DECREMENT
      je decdword
      inc eax
      jmp doriloop
      decdword:
      dec eax
      jmp doriloop

    fill8bit:                           ; byte
      stosb
      cmp byte ptr [fillflag+1], DECREMENT
      je decbyte
      inc al
      jmp doriloop
      decbyte:
      dec al
    doriloop:
  loop randomloop

    call fillcommon
    jc fillerror
    jnz keeprandomfill
donefillrand:
  pop dword ptr [sector]
  call rwsect
  call updatescreen
   mov dx, offset donermsg
   call printerror
  jmp fillfunctions
;-----------------------------------------------------
fillerror:
  pop dword ptr [sector]
  push word ptr [status]
  call rwsect
  call updatescreen
  pop word ptr [status]
  cmp byte ptr [status], ERROR
  je fillfunctions
    mov dx, offset abortdmsg
    call printerror
  jmp fillfunctions
;-----------------------------------------------------
getnos:                                 ; 'get number of sectors' from the
  pushad                                ; user; zf=0 if the operation
  mov dx, offset sectorsmsg             ; wasn't aborted.
  call printbottom
  mov eax, dword ptr [dataend]
  inc eax
  sub eax, dword ptr [sector]
  mov dword ptr [maxvalue], eax
  call inputvalue
  cmp dword ptr [value], 0
  jne goodval
    mov byte ptr [status], ERROR
  goodval:
  cmp byte ptr [status], ERROR
  popad
  ret
;-----------------------------------------------------
fillhex:
  mov byte ptr [valuebuffer], 0
  mov dx, offset hexmsg
  call gethex
  cmp al, 0
  je fillfunctions
  test bx, bx
  jz fillfunctions
  call getnos
  je fillfunctions
  mov ax, bx
  jmp dofill
;-----------------------------------------------------
fillstring:
  call getstring

  cmp cx, 70
  je fillfunctions
  call getnos
  je fillfunctions

    mov ax, 70
    sub ax, cx
    mov word ptr [stringbuffer+74], ax

dofill:
    mov dx, offset readingmsg
    call printbottom
  push dword ptr [sector]
  push cs
  pop es
  mov di, offset readbuffer
  mov cx, ax
  mov ax, 512                                   ; \Fix?/
  kfi:

  mov si, offset stringbuffer
  mov dx, cx
  fillstringloop:
    movsb
    dec ax
    jz dfs
    cfloop:
  loop fillstringloop
  mov cx, dx
  jmp kfi
  dfs:

    call fillcommon
    jc fillerror
    jz donefillrand

    mov ax, 512
  jmp cfloop
;-------------------------------------------------------
modbinary:
  call spotinbx
  mov cl, byte ptr [hl]
  cmp cl, 5
  jb skipbinadjust
    dec cl
  skipbinadjust:
  mov dl, 10000000b
  shr dl, cl

  cmp al, '1'
  je onebin
  cmp al, SPACE
  je reversebin
  cmp al, '0'
  jne getkeyagain
  not dl
    and byte ptr [readbuffer+bx], dl
  jmp donefixbin
  reversebin:
    xor byte ptr [readbuffer+bx], dl
    mov al, '0'
    test byte ptr [readbuffer+bx], dl
    jz donefixbin
    mov al, '1'
  jmp donefixbin
  onebin:
    or byte ptr [readbuffer+bx], dl
  donefixbin:

  mov dl, al
  call printchar

  mov dx, bx
  call aspotcalc
  mov word ptr [xy], dx
  mov dl, byte ptr [readbuffer+bx]
  call printchar
  jmp moveright
;-------------------------------------------------------
modascii:
  call spotinbx
  mov byte ptr [readbuffer+bx], al
  push word ptr [xy]
  mov bx, word ptr [spot]
  mov dx, bx
  call spotcalc
  mov word ptr [xy], dx

  cmp byte ptr [displaymode], HEX
  je dofixhex
  call displaybinary
  jmp donefixscreen
  dofixhex:
  call printhex
  mov dx, offset valuebuffer+6
  call printstring
  donefixscreen:
  mov dx, bx
  call aspotcalc
  mov word ptr [xy], dx

  mov cl, 1
  call printchar2
  pop word ptr [xy]
  jmp moveright
;-------------------------------------------------------
changemode:
  cmp al, 0                     ; shift+tab
  je changedispmode
  inc byte ptr [editmode]
  cmp byte ptr [editmode], ASCIIEDIT
  jbe dosetmode
  mov byte ptr [editmode], DEFAULTEDIT
  dosetmode:
  call colorchar
  jmp getkeyagain
;-------------------------------------------------------
changedispmode:
  inc byte ptr [displaymode]

  xor dl, dl
  mov ax, word ptr [spot]
  call movecursor

  cmp byte ptr [displaymode], BINARY
  jbe redraw

  mov byte ptr [displaymode], HEX
  jmp redraw
;-------------------------------------------------------
; sets viewmode to DL
checksetview:
  cmp byte ptr [viewmode], dl                   ; check if the "view" mode
  je abortviewmode0                             ; is already set.
  call clearview                                ; if it isn't set, then
  mov byte ptr [viewmode], dl                   ; clear the "view" area
  abortviewmode0:                               ; and set the new mode
  ret
;-------------------------------------------------------
log2phys:                                       ; jump from logical drive
  mov al, byte ptr [hdnumber]                   ; to parent physical drive
  jmp dophysicalread
;-------------------------------------------------------
retfat:
  cmp byte ptr [drivetype], FAT      ; won't work with non-logical drives
  jne getkeyagain
  mov eax, dword ptr [sector]
  test eax, eax                      ; if we're on a logical drive, attempt
  jz log2phys                        ; to jump to respective phys. drive

  cmp eax, dword ptr [datastart]     ; if we're in the data area
  jae retcluster                     ; return to respective fat entry

  cmp byte ptr [fattype], FAT16      ; done if it's fat12/fat16
  jbe getkeyagain

  cmp eax, dword ptr [root]          ; if it's fat32, there's entries in
  jae retcluster                     ; the fat for the root too, so jump
  jmp getkeyagain
;-------------------------------------------------------
checkabort:             ; sets equal flag if escape key was pressed
    push ax
    push dx
    mov ah, 06h                   ; direct input is used since it takes
    mov dl, 0ffh                  ; keys off the keybuffer
    int 21h
    cmp al, ESCAPE_KEY
    pop dx
    pop ax
    ret
;-------------------------------------------------------
recursechain:
  cmp byte ptr [drivetype], FAT       ; doesn't work for CDs/physicals
  jne getkeyagain

  mov eax, dword ptr [sector]           ; the data start on cds should
  cmp eax, dword ptr [datastart]        ; be 0 so checking is unnecessary
  jae getkeyagain
  cmp eax, dword ptr [root]
  jae getkeyagain
  xor ebx, ebx
  mov bx, word ptr [reserved]
  cmp eax, ebx
  jb getkeyagain

  call getcurrententry          ; ebx now has the current entry number

  mov eax, ebx                  ; no where to recurse to if it's the starting
  cmp ebx, 2                    ; (2nd) cluster
  jbe mainmenu

  push word ptr [xy]
  mov dx, offset recursemsg
  call printbottom
  pop word ptr [xy]

    recurse:

    call checkabort
    je mainmenu

    dec eax
    cmp eax, 1
    je chainnotfound
    push eax
    call getfatentry
    cmp ebx, eax
    pop eax
  jne recurse
  mov bp, 1
  jmp dochainjump
  chainnotfound:
  mov dx, offset nochainmsg
  call printerror
  jmp mainmenu
;-------------------------------------------------------
jumpcluster:
  cmp byte ptr [drivetype], FAT       ; doesn't work for CDs/physicals
  jne getkeyagain

  mov eax, dword ptr [sector]
  cmp eax, dword ptr [datastart]
  jae jumpdatacluster
  cmp byte ptr [fattype], FAT16
  jbe jumpfatcluster
  cmp eax, dword ptr [root]
  jae jumpdatacluster
;  cmp byte ptr [fattype], FAT32        ; no other options, so this check
;  je jumpfatcluster                    ; is unnecessary
;  jmp getkeyagain
  jmp jumpfatcluster
;-------------------------------------------------------
retcluster:
  mov byte ptr [valuebuffer], 0
  call eax2clust

  xor dl, dl
  call movecursor

  call rwsect
  jmp mainmenu
;-------------------------------------------------------
movecursor:             ; IN:   ax = new [spot]
                        ;       dl = new [hl]
  push word ptr [cxy]
  pop word ptr [xy]
  call decolorchar
  mov word ptr [spot], ax
  mov byte ptr [hl], dl
  mov dx, ax
  call spotcalc
  add dl, byte ptr [hl]
  mov word ptr [cxy], dx
  call printoffset
  ret
;-------------------------------------------------------
eax2clust:
;
; IN:   dd:eax           sector number
;       db:[valuebuffer] instruction
;
; instruction 0:
; OUT:  sector is changed to corresponding fat entry sector
;
; instruction 1:
; OUT:  eax              corresponding cluster number
;

  xor ecx, ecx
  mov cl, byte ptr [fats]
;  cmp cl, 0                            ; fix?
;  jne subfats
;  inc cl

  subfats:
    sub eax, dword ptr [spf]
  loop subfats

  cmp byte ptr [fattype], FAT32
  je dontsubroot
    mov cx, word ptr [rootsectors]
    sub eax, ecx
  dontsubroot:

    mov cx, word ptr [reserved]
    sub eax, ecx

    xor ecx, ecx
    xor edx, edx
    mov cl, byte ptr [spc]
    cmp cl, 0
    je nocdiv
      div ecx
    nocdiv:
    
    xor ebx, ebx
    add eax, 2
  cmp byte ptr [valuebuffer], 0
  je itsallgood
    ret
  itsallgood:
  cmp byte ptr [fattype], FAT12
  jne nosmd
    mov ecx, 3
    mul ecx
    test eax, 1b
    jz noinc12
      inc edx
    noinc12:
    shr eax, 1
    add eax, edx
    jmp sub512
  nosmd:
  mov cl, byte ptr [fattype]
  shr cl, 1
  shl eax, cl
  sub512:

  xor edx, edx
  mov dx, word ptr [bps]        ; \Fixed?/
  xor ecx, ecx
  loopfindsect:
  cmp eax, edx
  jb donesub
    sub eax, edx
    inc ecx
  jmp loopfindsect
  donesub:

  mov dword ptr [sector], ecx
  xor ecx, ecx
  mov cx, word ptr [reserved]
  add dword ptr [sector], ecx
  ret
;-------------------------------------------------------
jumpdatacluster:
  mov byte ptr [fromfat], 1
  mov byte ptr [valuebuffer], 1
  call eax2clust
  call getfatentry
  cmp byte ptr [status], ERROR
  je mainmenu
  cmp eax, 2
  jb mainmenu
  cmp eax, 0FFFFFFFh
  je mainmenu

  mov ebx, eax
  call eaxm2mul

  cmp eax, dword ptr [dataend]
  ja mainmenu
  mov dword ptr [sector], eax
  call rwsect
  jmp mainmenu
;-------------------------------------------------------
jumpfatcluster:
  mov ebx, dword ptr [sector]
  cmp ebx, dword ptr [root]
  jae getkeyagain
;  cmp ebx, dword ptr [datastart]       ; handled by jumpcluster
;  jae getkeyagain

  xor ebx, ebx
  mov bx, word ptr [reserved]
  cmp dword ptr [sector], ebx
  jb getkeyagain

  call getcurrententry
  cmp byte ptr [status], ERROR
  je mainmenu

;  mov bp, 2
  dochainjump:
  mov ebx, eax          ; disregard ebx, which is the current entry #
  cmp ebx, 2            ; we only care about eax, the value stored there.
  jb mainmenu
  cmp ebx, 0FFFFFFFh
  je mainmenu
  call eaxm2mul

  cmp eax, dword ptr [dataend]
  ja mainmenu
  push dword ptr [sector]
  mov byte ptr [valuebuffer], 0
  call eax2clust
  pop edx
  cmp edx, dword ptr [fatend]           ; bad coding.  doesn't support 3+ fats
  jb nsf
    mov ecx, dword ptr [spf]
    add dword ptr [sector], ecx
  nsf:

  cmp dword ptr [sector], edx           ; don't read the same sector twice
  je drsfj
    call rwsect
  drsfj:

  xor dl, dl
  call movecursor

  jmp mainmenu
;-------------------------------------------------------
entercluster:

  ; see "viewmode" definition in variable area at end of source

  cmp byte ptr [drivetype], FAT
  jne getkeyagain

  cmp byte ptr [viewmode], ROOTVIEW
  je enterfiledir
  cmp byte ptr [viewmode], FAT12VIEW
  je enterfat
  cmp byte ptr [viewmode], FAT16VIEW
  je enterfat
  cmp byte ptr [viewmode], FAT32VIEW
  je enterfat

  jmp getkeyagain
;-------------------------------------------------------
enterfiledir:                           ; this code is set up so that
  call spotinbx                         ; if you hit enter on the 32
  and bl, 11100000b                     ; bytes belonging to a file entry
                                        ; the editor will jump to its
  mov ax, word ptr [readbuffer+bx+14h]  ; starting cluster
  shl eax, 16
  mov ax, word ptr [readbuffer+bx+1Ah]
  test eax, eax
  jz jumptoroot
  cmp eax, 2
  jb jumptoroot
  jmp jumptoeax
;-------------------------------------------------------
enterfat:
  call calcentry
jumptoeax:
  cmp eax, 2
  jb getkeyagain
  mov ebx, eax
  call eaxm2mul
  cmp eax, dword ptr [dataend]
  ja getkeyagain
  mov dword ptr [sector], eax
  call rwsect
  jmp mainmenu
;-------------------------------------------------------
viewoptions:
  mov dx, offset viewmenu
  call printbottom

  getkeyagain1:
  call getkey

  cmp al, ESCAPE_KEY
  je mainmenu

  cmp ah, F1_KEY
  je defaultview

mov al, ah
sub al, 59

  cmp ah, F2_KEY
  je setview

  cmp ah, F3_KEY        ; (bootsect)
  je setview

  cmp ah, F4_KEY        ; (fat12)
  je setview

  cmp ah, F5_KEY        ; (fat16)
  je setview

  cmp ah, F6_KEY        ; (fat32)
  je setview

  cmp ah, F7_KEY        ; (dir)
  je setview

ifdef DEBUG                             ; extra view for registers
  cmp ah, F8_KEY        ; (debug)
  je setview
endif

  jmp getkeyagain1
;-------------------------------------------------------
; IN: al = mode
setview:                         ; the high byte of viewmode, if set to 1,
  mov byte ptr [viewmode+1], STATIC
  mov dl, al                     ; will force the current viewmode.
  cmp dl, FAT12VIEW              ; if zeroed, the default viewmode will be
  jne dsf12s                     ; used on the drive

  mov eax, dword ptr [sector]
  mov dword ptr [fat12start], eax

  dsf12s:
  call checksetview
  jmp mainmenu
;-------------------------------------------------------
defaultview:
  mov byte ptr [viewmode+1], AUTODETECT
  call printcounts
  jmp mainmenu
;-------------------------------------------------------
searchoptions:
  mov dx, offset searchmenu
  call printbottom

  mov byte ptr [handling], QUERY_SKIP

  getkeyagain8:
  call getkey

  cmp al, ESCAPE_KEY
  je mainmenu

  cmp ah, F1_KEY
  je findstring
  
  cmp ah, F2_KEY
  je findhex

  cmp ah, F3_KEY
  je findmbr

  cmp ah, F4_KEY
  je findbs

  cmp ah, F5_KEY
  je findfat

  cmp ah, F6_KEY
  je finddir

  jmp getkeyagain8
;-------------------------------------------------------
finddir:
  mov si, offset readbuffer

  finddirnext:
  xor bx, bx

  call finddirectory
  jnc foundstring

  call findcommon
  jmp finddirnext
;-------------------------------------------------------
finddirectory:                  ;IN: SI=readbuffer
  push cx                       ;    BX=offset in readbuffer

                                ; not found: carry set
  mov al, byte ptr [si+bx]      ; found    : carry cleared
  cmp al, 01
  je flok
  cmp al, 02
  je flok
  cmp al, 0e5h
  je flok
  cmp al, 20h
  jbe notfound
  cmp al, 7eh
  ja notfound

  flok:
;  mov ch, byte ptr [bps+1]              ; 16 entries every 512 bytes
;  shl ch, 4                             ; this puts 16 in ch if bps is 512
  mov ch, 16

  nextentry:

;  cmp byte ptr [si+12+bx], 0           ; NT series *does* use this byte,
;  jne notfound                         ; so it may not be 0 on drives that
;                                       ; have been messed with by NT
  mov cl, 10

  cmp byte ptr [si+bx], 0               ; first byte zero?
  je allzero

  test byte ptr [si+11+bx], 11000000b   ; top two bits of attribute are
  jnz notfound                          ; reserved.  if used, then not dir.

  cmp byte ptr [si+11+bx], 0fh          ; if attribute is 0F, then it's lfn
  jne notlfn

  cmp word ptr [si+1Ah+bx], 0
  jne notfound
  jmp lfn

  notlfn:

    push bx
    push cx
      mov cx, 11
      kctfn:
      cmp byte ptr [si+bx], 0
      je popnotfound
      inc bx
      loop kctfn
    pop cx
    pop bx

    cmp byte ptr [si+0Dh+bx], 199               ; tenth of a second for
    ja notfound                                 ; creation time (0-199)
    
    mov ax, word ptr [si+18h+bx]                ; test the date
                                                ; to see if it exceeds any
                                                ; hour/minute/etc boundaries
    push ax
    and al, 00011111b
    cmp al, 0
    pop ax
    je notfound
    shr ax, 5
    and al, 00001111b
    jz notfound
    cmp al, 12
    ja notfound

    mov ax, word ptr [si+10h+bx]                ; test the date
    test ax, ax
    jz dontcheckseconddate
    push ax
    and al, 00011111b
    cmp al, 0
    pop ax
    je notfound
    shr ax, 5
    and al, 00001111b
    jz notfound
    cmp al, 12
    ja notfound
    dontcheckseconddate:

    mov ax, word ptr [si+14h+bx]
    shl eax, 16
    mov ax, word ptr [si+1Ah+bx]

    cmp eax, 0FFFFFF7h                          ; cluster can't be EOC and
    jae notfound                                ; the top nibble must = 0
    cmp dword ptr [si+16h+bx], 0
    je notfound

  lfn:

  mov al, byte ptr [si+bx]
  inc bx

  cmp al, 06
  jb nextletter
  cmp al, 0e5h
  je nextletter
  cmp al, 0ffh
  je nextletter
  cmp al, 20h
  jbe notfound
  cmp al, 7eh
  ja notfound

  nextletter:

    mov al, byte ptr [si+bx]
    cmp al, 0
    je letterok
    cmp al, 0ffh
    je letterok
    cmp al, 20h
    je letterok
    cmp al, 7eh
    ja notfound
    cmp al, 20h
    jb notfound

    letterok:
    ; this is where we need code to check if its a directory or not

    ; the very first character of the first filename can be:
    ;           01/02/E5 or any valid letter/number

    ; the very first character of other filenames:
    ;           00/01/02/E5 or any valid letter/number

    ; other letters:
    ;           00/20 or any valid letter/number

  inc bx
  dec cl
  jnz nextletter
;  mov ax, bx                            ; odd sector size support
;  shr ax, 9
;  mov byte ptr [subsector], al

  add bx, 21
  dec ch
  jnz nextentry

  founddir:
    pop cx
    clc
  ret
  popnotfound:
    pop cx
    pop bx
  notfound:
    pop cx
    stc
  ret

  allzero:
    mov al, byte ptr [si+bx]
    cmp al, 0
    jne notfound
    inc bx
    dec cl
    jnz allzero
    mov cl, 11
    add bx, 21
    dec ch
    jnz allzero
    jmp founddir
;-------------------------------------------------------
findcommon:
  pop word ptr [calladdress]
  mov dx, offset searchingmsg
  call printbottom

  call checkabort
  je abortfindstring

  call printcounts
  mov si, offset readbuffer
  mov ax, word ptr [bps]
  dec ax
  shr ax, 9
  cmp byte ptr [subsector], al
  jb dontrw
    mov eax, dword ptr [dataend]
    cmp dword ptr [sector], eax
    je stringnotfound
    inc dword ptr [sector]
    call rwsect
    cmp byte ptr [status], ERROR
    je abortfindstring

  jmp dontinc
  dontrw:

  inc byte ptr [subsector]
  mov al, byte ptr [subsector]
  shl ax, 9
  add si, ax

  dontinc:
  push word ptr [calladdress]
  ret
;-------------------------------------------------------
findbs:
  mov si, offset readbuffer
findbsnext:
  cmp dword ptr [si+1fch], 0AA550000h
  jne findbs2
  cmp byte ptr [si], 0EBh
  je foundstring
  findbs2:
  call findcommon
  jmp findbsnext
;-------------------------------------------------------
findfat:
  mov si, offset readbuffer
  findfatnext:
  cmp byte ptr [si], 0F0h       ; fat12
  je if12
  cmp byte ptr [si], 0F8h       ; fat16/fat32
  jne findfat2
  fatok:
  mov bx, 3
  cmp byte ptr [si+bx], 0Fh     ; fat32
  jne if16

  ; likely fat32

  lfatloop:
    add bx, 4
    test byte ptr [si+bx], 0F0h
    jnz findfat2
  cmp bx, 511
  jne lfatloop
  jmp dfstests

  ; likely fat12

  if12:
    mov ax, word ptr [si+bx]
    and ax, 0FFFh
    cmp ax, 001h
    je findfat2
    cmp ax, 0FF0h
    jae n12sfl
    cmp ah, 0Fh                         ; don't remember this
    je findfat2
    n12sfl:
    mov al, byte ptr [si+bx+2]
    mov ah, byte ptr [si+bx+1]
    rol ax, 4
    and ax, 0FFFh
    cmp ax, 001h
    je findfat2
    cmp ax, 0FF0h
    jae d12sw
    cmp ah, 0Fh
    je findfat2
    d12sw:
    add bx, 3
    cmp bx, 510
  jb if12

  cmp byte ptr [si+5], 00h
  je dfstests
  cmp byte ptr [si+5], 0FFh
  jne findfat2
  jmp dfstests

  ; likely fat16

  if16:
  cmp byte ptr [si+bx], 0FFh
  jne findfat2
  inc bx

  lfatloop2:
    cmp word ptr [si+bx], 0001h
    je findfat2
    cmp word ptr [si+bx], 0FFF0h
    jae nf16lt
    cmp word ptr [si+bx], 0E800h
    jae findfat2
    nf16lt:
    add bx, 2
  cmp bx, 512
  jne lfatloop2

  cmp byte ptr [si+5], 00h
  je dfstests
  cmp byte ptr [si+5], 0FFh
  jne findfat2

  dfstests:
  cmp word ptr [si+1], 0FFFFh
  je foundstring
  findfat2:
  call findcommon
  jmp findfatnext
;-------------------------------------------------------
findmbr:
  mov si, offset readbuffer
  findmbrnext:

  cmp byte ptr [si], 0EBh
  je findmbr2

  mov bx, 1AEh

  xor al, al
  mov cl, 4
  checkactiveloop:
    dec cl
    jz donecheckactives
    add bx, 10h
    test byte ptr [si+bx], 01111111b
    jnz findmbr2
    cmp byte ptr [si+bx], 80h
    jne checkactiveloop
    inc al
  donecheckactives:

  cmp al, 1
  jne findmbr2

  cmp dword ptr [si+1fch], 0AA550000h   ; mbr signature
  jne findmbr2
  cmp dword ptr [si+1e4h], 061417272h   ; fsinfo sector signature
  jne foundstring                       ; annoying of microsoft to
                                        ; give it an MBR signature
  findmbr2:
  call findcommon
  jmp findmbrnext
;-------------------------------------------------------
findhex:
  mov byte ptr [valuebuffer], 0
  mov dx, offset hexmsg
  call gethex
  cmp al, 0
  je searchoptions
;-------------------------------------------------------
dohexsearch:
    test bx, bx
    jz searchoptions

  mov ax, bx
  mov dx, offset searchingmsg
  call printbottom
  jmp stringsearch
;-------------------------------------------------------
updatescreen:
  call printcounts
  call printscreen
   cmp byte ptr [viewmode+1], AUTODETECT        ; detect the view type
   jne continueprintview
   mov dl, byte ptr [region]
   cmp dl, PICKFATVIEW
   je choosefatview
   cmp dl, DATAVIEW
   jne dontscanfordir
     mov si, offset readbuffer
     xor bx, bx
     call finddirectory
     jnc settodir
     cmp byte ptr [drivetype], FAT
     jne dontscanfordir
     mov eax, dword ptr [backupbs]
     cmp dword ptr [sector], eax
     je setbsview
     xor edx, edx
     mov dx, word ptr [fsinfo]
     cmp dword ptr [sector], edx        ; in the fsinfo sector?
     je setfsview                       ; then set fsinfo view
     add edx, eax                       ; checks if we're in the backup
     cmp dword ptr [sector], edx        ; fsinfo sector...but it assumes
     je setfsview                       ; it's the same distance from the backupbs
     mov dl, DATAVIEW                   ; as the main fsinfo is the main
     jmp dontscanfordir                 ; bootsector, which is wrong.
     settodir:
     mov dl, ROOTVIEW
   dontscanfordir:

     call checksetview

   continueprintview:
  jmp printview
;-------------------------------------------------------
findstring:
  call getstring

  cmp cx, 70
  je abortfindstring
    mov dx, offset searchingmsg
    call printbottom
    mov ax, 70
    sub ax, cx
    stringsearch:
    mov word ptr [stringbuffer+74], ax
    xor bx, bx
    xor si, si

    nextbyte:
    mov al, byte ptr [stringbuffer+si]
    cmp al, byte ptr [readbuffer+bx]
    je comparenextbyte
    cmp bx, si
    jae dontgolastsect
      add bx, 512
      dec byte ptr [subsector]
      cmp byte ptr [subsector], 255
      jne dontgolastsect
      dec dword ptr [sector]
      call rwsect
    dontgolastsect:
    sub bx, si
    xor si, si
    continuefindstring0:
    inc bx

    cmp bx, word ptr [bps]
    je nextfindsector
    mov ah, bh
    shr ah, 1
    mov byte ptr [subsector], ah

    jmp nextbyte
stringnotfound:
  call updatescreen
  mov dx, offset stringerror
  call printerror
  jmp searchoptions
abortfindstring:
  call updatescreen
  jmp searchoptions

comparenextbyte:
  inc si 
  cmp si, word ptr [stringbuffer+74]
  je foundstring
  jmp continuefindstring0
nextfindsector:
  mov eax, dword ptr [dataend]
  cmp eax, dword ptr [sector]
  je stringnotfound
  inc dword ptr [sector]
  call rwsect
  cmp byte ptr [status], ERROR
  je abortfindstring

  call checkabort
  je abortfindstring

  push si
  call printcounts
  pop si
  xor bx, bx
  jmp nextbyte
foundstring:
  call updatescreen
  jmp mainmenu
;-------------------------------------------------------
getstring:
  mov dx, offset stringmsg
  call printbottom
  mov di, offset stringbuffer
  mov cx, 70
  getkeyagain9:
  call cursorgetkey

  cmp al, BACKSPACE_KEY
  je backspacestring

  cmp al, ESCAPE_KEY
  je abortgetstring

  cmp al, ENTER_KEY
  je donegetstring

  test cx, cx
  jz getkeyagain9

  cmp al, 0
  je getkeyagain9

  mov dl, al
  call printchar
  call setxy

  push cs
  pop es
  stosb

  dec cx
  jmp getkeyagain9
  abortgetstring:
  mov cx, 70
  donegetstring:
  ret
;-------------------------------------------------------
backspacestring:
  cmp byte ptr [xy], 9
  je getkeyagain9
  inc cx

  call backcommon

  dec di
  jmp getkeyagain9
;-------------------------------------------------------
backcommon:
  push cx
  dec byte ptr [xy]
  call setxy
  mov al, SPACE
  mov cl, 1
  call printchar2
  pop cx
  ret
;-------------------------------------------------------
fileoperations:

  mov dx, offset filemenu
  call printbottom

  getkeyagain5:
  call getkey

  cmp al, ESCAPE_KEY
  je mainmenu

    cmp ah, F1_KEY
    je savefileoptions
    cmp ah, F2_KEY
    je restfileoptions

  jmp getkeyagain5
;-------------------------------------------------------
printfilemenu:
  mov byte ptr [chainflag], 0
  mov dx, offset filemenu2
  call printbottom
  add byte ptr [xy], 2
  cmp byte ptr [drivetype], PHYSICAL
  jne logicalrfo
    mov dx, offset pdfilemenu
    jmp printstring
  logicalrfo:
  mov dx, offset ldfilemenu
  xor eax, eax
  mov ax, word ptr [reserved]
  cmp dword ptr [sector], eax
  jb printstring

  mov eax, dword ptr [spf]
  xor ebx, ebx
  mov bl, byte ptr [fats]
  mul ebx
  mov dx, offset ldfilemenu
  mov bx, word ptr [reserved]
  add eax, ebx
  cmp dword ptr [sector], eax
  jb dochain

  checkdir:
  mov si, offset readbuffer
  xor bx, bx
  call finddirectory
  jc printstring                ; dir not found

  mov byte ptr [chainflag], 1
  jmp dochain2

  dochain:
  mov byte ptr [chainflag], 2

  dochain2:
    call printstring
    add byte ptr [xy], 2
    mov dx, offset chainmenu
  jmp printstring
;-------------------------------------------------------
restfileoptions:
  call printfilemenu

  getkeyagain12:
    call getkey

    cmp al, ESCAPE_KEY
    je fileoperations

    cmp ah, F1_KEY
    je restfile

    cmp ah, F2_KEY
    je restsector0

    cmp byte ptr [drivetype], PHYSICAL
    je hdrfcheck

    cmp ah, F3_KEY
    je restfat1
    cmp ah, F4_KEY
    je restfat2
    cmp ah, F5_KEY
    je restroot
    cmp ah, F6_KEY
    je restdrive

    cmp byte ptr [chainflag], 0
    je getkeyagain12
    cmp ah, 65
    je restchain
    jmp getkeyagain12
    hdrfcheck:

    mov bx, 1CAh
    mov cx, 4
    mov al, F3_KEY
    mov si, offset p1

    csp2:
    cmp ah, al
    je restpartition
    inc al
    add bx, 10h
    add si, 4
    loop csp2

  jmp getkeyagain12
;-------------------------------------------------------
savechain:
  mov byte ptr [fromfat], 1
  call getfilename
  cmp cx, 68
  je savefileoptions

;  mov eax, dword ptr [sector]
;  mov dword ptr [sbackup2], eax

  mov dword ptr [filesize], 0
  cmp byte ptr [chainflag], 2
  je begincsave

    call spotinbx
    and bl, 11100000b                   ; chop off 0-31 bytes to set bx to
    add bx, offset readbuffer           ; the start of the current entry
    mov eax, dword ptr [bx+1Ch]         ; filesize
    mov dword ptr [filesize], eax
    mov ax, word ptr [bx+14h]           ; high cluster word
    shl eax, 16
    mov ax, word ptr [bx+1Ah]           ; low cluster word
    mov dword ptr [sbackup], eax
    mov ebx, eax
    cmp ebx, 2
    jb f2great
    call eaxm2mul
    cmp eax, dword ptr [dataend]
    ja f2great
    push eax
    mov eax, dword ptr [sbackup]
    call getfatentry
    mov dword ptr [sbackup], eax
    pop eax
    jmp startchainsavin

  begincsave:
  call getcurrententry
  cmp ebx, 2
  jb f2great
;  cmp ebx, 0FFFFFFFh   ; unnecessary - see eaxm2mul's mul/jc instructions
;  je f2great
  mov dword ptr [sbackup], eax          ; current entry's data
  call eaxm2mul
  cmp eax, dword ptr [dataend]
  ja f2great                            ; current entry is beyond data end

  startchainsavin:
  push ax
;  mov byte ptr [fileflag], UNDEFINED
  call createfile
  pop ax
  cmp byte ptr [status], ERROR
  je savefileoptions

  chainsaveloop:
;  mov dword ptr [sector], eax
  xor ebx, ebx
  mov bl, byte ptr [spc]
  mov dword ptr [value], ebx
  call writefile
  cmp byte ptr [status], ERROR
  je savefileoptions

  mov ebx, dword ptr [sbackup]
  call eaxm2mul
  cmp eax, dword ptr [dataend]
  ja donechainsave
  pushad
  mov edx, dword ptr [dataend]
;  call storedebugdata
  popad

  push eax
  mov eax, dword ptr [sbackup]
  call getfatentry
  mov dword ptr [sbackup], eax
  pop eax
  jmp chainsaveloop

  donechainsave:
  cmp dword ptr [filesize], 0
  je notruncate

  mov ax, 4201h
  mov bx, word ptr [filehandle]
  xor cx, cx
  xor dx, dx
  int 21h

  shl edx, 16
  mov dx, ax

  cmp edx, dword ptr [filesize]
  jbe notruncate

  mov dx, offset truncatemsg
  call printbottom
  call getyn
  cmp al, 0
  je notruncate

  mov ax, 4200h                         ; seek file
  mov bx, word ptr [filehandle]
  mov dx, word ptr [filesize]
  mov cx, word ptr [filesize+2]
  int 21h

  xor cx, cx
  mov ah, 40h
  mov bx, word ptr [filehandle]
  int 21h

  notruncate:


  call closefile
;  mov eax, dword ptr [sbackup2]
;  mov dword ptr [sector], eax
  call rwsect
  call updatescreen
  mov dx, offset donemsg
  call printerror

  jmp savefileoptions
;-------------------------------------------------------
f2great:
  mov dx, offset greatmsg
  call printerror
  jmp savefileoptions
;-------------------------------------------------------
  ; chainflag 1: file save/restore
  ;           2: cluster save/restore
restchain:
  mov byte ptr [fromfat], 1
  call getfilename
  cmp cx, 68
  je restfileoptions
  mov eax, dword ptr [sector]
  mov dword ptr [sbackup], eax
  call findfile
  jc restfileoptions

  call getcurrententry
  cmp byte ptr [chainflag], 2
  je restclusts
    call getfilesize
    call spotinbx
     and bl, 11100000b
;    cmp eax, dword ptr [readbuffer+bx+1Ch]
;    jb toosmallerr
   mov ax, word ptr [readbuffer+bx+14h]
   shl eax, 16
   mov ax, word ptr [readbuffer+bx+1Ah]
   mov ebx, eax
  restclusts:

  call openfile

  rbuhs:

  mov dword ptr [cluster], ebx
  call eaxm2mul                         ; fix?  checking needed for sector.
  mov dword ptr [sector], eax
  mov al, byte ptr [spc]
  mov byte ptr [spcc], al

  dornsb:

  mov ah, 3Fh
  mov bx, word ptr [filehandle]
  mov cx, word ptr [bps]
  mov dx, offset writebuffer
  int 21h
  jc disperread
  cmp ax, cx
  je docwrite
    call rwsect
    cmp byte ptr [status], ERROR
    je restfileoptions
    push cs
    pop es
    sub cx, ax
    mov si, offset readbuffer
    add si, ax
    mov di, offset writebuffer
    add di, ax
    rep movsb
  docwrite:
  mov byte ptr [rw], WRITE
  call rwsect
  cmp byte ptr [status], ERROR
  je restfileoptions
  cmp ax, cx
  jne donerestchain

  dec byte ptr [spcc]
  jz restnextclust
  inc dword ptr [sector]
  jmp dornsb
  restnextclust:

  mov eax, dword ptr [cluster]
  call getfatentry
  cmp eax, 0FFFFFF7h
  jae donerestchain
  cmp eax, 2
  jb donerestchain
  mov ebx, eax
  jmp rbuhs

  donerestchain:

   mov eax, dword ptr [sbackup]
   mov dword ptr [sector], eax
   call rwsect

   call updatescreen
   mov dx, offset donermsg
   call printerror

  jmp restfileoptions
  disperread:
    mov dx, offset errorread
    call printerror
    jmp restfileoptions
;-------------------------------------------------------
getcurrententry:                ; IN:  nothing
                                ; OUT: eax = data stored at current entry
                                ;      ebx = current entry #
                                ;      other reg's corrupted
  call calcentry
  push eax
  call getfatentry
  pop ebx
  ret
;-------------------------------------------------------
savefileoptions:

  cmp byte ptr [drivetype], CDROM
  jne startfileops
    mov dx, offset cdfilemenu
    call printbottom
    jmp getkeyagain0
  startfileops:
    call printfilemenu
  getkeyagain0:
    call getkey

    cmp ah, F1_KEY
    je savefile

  cmp byte ptr [drivetype], CDROM
  je cdf2check

    cmp al, ESCAPE_KEY
    je fileoperations

    cmp ah, F2_KEY      ; bootsect
    je savesector0

    cmp byte ptr [drivetype], PHYSICAL
    je hdsfcheck

    cmp ah, F3_KEY
    je savefat1
    cmp ah, F4_KEY
    je savefat2
    cmp ah, F5_KEY
    je saveroot
    cmp ah, F6_KEY
    je dumpiso

    cmp byte ptr [chainflag], 0
    je getkeyagain12
    cmp ah, F7_KEY
    je savechain
    jmp getkeyagain12
    hdsfcheck:

    mov bx, 1CAh
    mov cx, 4
    mov al, F3_KEY
    mov si, offset p1

    csp:
    cmp ah, al
    je savepartition
    inc al
    add bx, 10h
    add si, 4
    loop csp

  cdf2check:
    cmp ah, F2_KEY
    je dumpiso

    cmp al, ESCAPE_KEY
    je mainmenu

  jmp getkeyagain0
;-------------------------------------------------------
restroot:
  xor eax, eax

 cmp byte ptr [fattype], FAT32
 jne userootsectsr
    mov al, byte ptr [spc]
    jmp dorootrest
  userootsectsr:
    mov ax, word ptr [rootsectors]
  dorootrest:

  mov dword ptr [value], eax
  mov eax, dword ptr [root]
  jmp restsectors
;-------------------------------------------------------
saveroot:
  call getfilename
  cmp cx, 68
  je savefileoptions

    mov eax, dword ptr [root]
    xor edx, edx

    cmp byte ptr [fattype], FAT32
    jne userootsects
      mov dl, byte ptr [spc]
      jmp dorootsave
    userootsects:
      mov dx, word ptr [rootsectors]

    dorootsave:
    mov dword ptr [value], edx
    jmp endsavedrive
;-------------------------------------------------------
restdrive:
  mov eax, dword ptr [dataend]
  mov dword ptr [value], eax
  xor eax, eax
  jmp restsectors
;-------------------------------------------------------
restfat1:
  mov eax, dword ptr [spf]
  mov dword ptr [value], eax
  xor eax, eax
  mov ax, word ptr [reserved]
  jmp restsectors
;-------------------------------------------------------
restfat2:
  mov eax, dword ptr [spf]
  mov dword ptr [value], eax
  mov eax, dword ptr [fatend]
  jmp restsectors
;-------------------------------------------------------
restsectors:
  pusha
  call getfilename
  cmp cx, 68
  popa
  je restfileoptions
  call findfile
  jc restfileoptions

endrestsectors:
  call readfile
  jmp restfileoptions
;-------------------------------------------------------
restpartition:
  mov eax, dword ptr [si]
  test eax, eax
  jz restfileoptions
  pusha
  call getfilename
  cmp cx, 68
  popa
  je restfileoptions
  call findfile
  jc restfileoptions

  push dword ptr [sector]
  xor edx, edx
  mov dword ptr [sector], edx
  call rwsect
  mov ebx, dword ptr [readbuffer+bx]
  dec ebx
  mov dword ptr [value], ebx
  pop dword ptr [sector]
  jmp endrestsectors
;-------------------------------------------------------
savepartition:
  mov eax, dword ptr [si]
  test eax, eax
  jz savefileoptions
  push eax
  push bx
  call getfilename
  cmp cx, 68
  pop bx
  pop eax
  je savefileoptions

  push dword ptr [sector]
  xor eax, eax
  mov dword ptr [sector], eax
  call rwsect
  mov ebx, dword ptr [readbuffer+bx]
  dec ebx
  mov dword ptr [value], ebx
  pop dword ptr [sector]
;-------------------------------------------------------
endsavedrive:
  call savedata
  jmp savefileoptions
;-------------------------------------------------------
savefat1:
  xor eax, eax
  mov ax, word ptr [reserved]
  jmp savefat
;-------------------------------------------------------
savefat2:
  mov eax, dword ptr [fatend]
  jmp savefat
;-------------------------------------------------------
savefat:
  push eax
  call getfilename
  cmp cx, 68
  pop eax
  je savefileoptions

    mov edx, dword ptr [spf]
    mov dword ptr [value], edx
  jmp endsavedrive
;-------------------------------------------------------
savedata:
;
; IN:   dd:[value]      number of sectors to save
;       eax             starting sector
;
; OUT:  disk is read and sectors are dumped to [filehandle]
;       dw:[filehandle] handle of file to write to
;

;  mov byte ptr [fileflag], LIMIT4GB
  mov edx, dword ptr [value]    ; the plan here is to convert
  mov cx, word ptr [bps]        ; "value" into the number of 512-byte
  shr cx, 10                    ; pieces it contains by shifting it left
  shl edx, cl                   ; if BPS is > 512
;  cmp edx, 800000h
;  ja limitset
;  mov byte ptr [fileflag], LIMIT2GB
;  cmp edx, 400000h
;  ja limitset
;  mov byte ptr [fileflag], UNDEFINED
;  limitset:

  cmp edx, 400000h
  ja toobig

;  push dword ptr [sector]
;  mov dword ptr [sector], eax
  push ax
  call createfile
  pop ax
  cmp byte ptr [status], ERROR
  jne dosavedata
;    pop dword ptr [sector]
    donesavedata:
    ret
  dosavedata:
  call writefile
  call closefile

;  pop dword ptr [sector]
  push word ptr [status]
  call rwsect
  call updatescreen
  pop word ptr [status]

  cmp byte ptr [status], ERROR
  je donesavedata

  mov dx, offset donemsg
  jmp printerror
;-------------------------------------------------------
savesector0:
  call getfilename
  cmp cx, 68
  je savefileoptions

  xor eax, eax
  mov dword ptr [value], 1
  jmp endsavedrive
;-------------------------------------------------------
restsector0:
  call getfilename
  cmp cx, 68
  je restfileoptions
  call findfile
  jc restfileoptions

  xor eax, eax
  mov dword ptr [value], 1
  jmp endrestsectors
;-------------------------------------------------------
restfile:
  call getfilename
  cmp cx, 68
  je restfileoptions
  call findfile
  jc restfileoptions

  call getfilesize
  xor edx, edx
  mov dx, word ptr [bps]
  cmp dword ptr [filesize], edx
  jae filesizeok
  toosmallerr:

  mov dx, offset toosmall
  call printerror

  jmp restfileoptions

  filesizeok:  

  mov eax, dword ptr [filesize]
  xor edx, edx
  xor ebx, ebx
  mov bx, word ptr [bps]
  div ebx
  mov dword ptr [maxvalue], eax
  mov eax, dword ptr [dataend]
  inc eax
  sub eax, dword ptr [sector]
  cmp dword ptr [maxvalue], eax
  jbe mvok
    mov dword ptr [maxvalue], eax
  mvok:
  mov dx, offset sectorsmsg
  call inputvalue
  cmp byte ptr [status], ERROR
  je restfileoptions

  mov eax, dword ptr [sector]
  jmp endrestsectors
;-------------------------------------------------------
backvalue:
  mov al, byte ptr [maxleft]
  cmp byte ptr [xy], al
  je getkeyagain7

  call backcommon

  xor edx, edx
  mov eax, ecx
  mov ecx, 10
  div ecx
  mov ecx, eax

  jmp getkeyagain7
;-------------------------------------------------------
backspacefile:
  cmp byte ptr [xy], 11
  je getkeyagain6
  inc cx

  call backcommon

  dec di
  jmp getkeyagain6
;-------------------------------------------------------
jumptocluster:
  mov byte ptr [valuebuffer], 1
  mov eax, dword ptr [dataend]
  call eax2clust
  mov dx, offset clustermsg
  call gethex
  cmp al, 0
  je jumpto
  cmp ebx, 2
  jb jumpto
  call eaxm2mul
  mov ebx, eax
  jmp donejump
;-------------------------------------------------------
jumpto2:
  mov dx, offset filemenu2
  call printbottom
  add byte ptr [xy], 2
  mov dx, offset pdfilemenu
  call printstring


  getkeyagain11:
  call getkey

  cmp al, ESCAPE_KEY
  je mainmenu
  cmp ah, F1_KEY
  je jumptosector
  cmp ah, F2_KEY
  je jumptobootsector

  mov ebx, dword ptr [p1]
  cmp ah, F3_KEY
  je donejump

  mov ebx, dword ptr [p2]
  cmp ah, F4_KEY
  je donejump

  mov ebx, dword ptr [p3]
  cmp ah, F5_KEY
  je donejump

  mov ebx, dword ptr [p4]
  cmp ah, F6_KEY
  je donejump

  jmp getkeyagain11
;-------------------------------------------------------
jumpto:
  cmp byte ptr [drivetype], PHYSICAL
  je jumpto2

  cmp byte ptr [drivetype], CDROM
  jne doregularjumps
  mov dx, offset cdjumpmenu
  jmp docdjumps

  doregularjumps:
  mov dx, offset jumpmenu

  docdjumps:
  call printbottom

  getkeyagain2:
  call getkey

  xor ebx, ebx
  cmp al, ESCAPE_KEY
  je mainmenu
  cmp ah, F1_KEY
  je jumptosector

  cmp byte ptr [drivetype], CDROM
  je getkeyagain2

  cmp ah, F2_KEY
  je jumptocluster
  cmp ah, F3_KEY
  je donejump
  cmp ah, F4_KEY
  je jumptofat1
  cmp ah, F5_KEY
  je jumptofat2
  cmp ah, F6_KEY
  je jumptoroot
  cmp ah, F7_KEY
  je jumptodata

  jmp getkeyagain2

  jumptobootsector:
    xor ebx, ebx
    jmp donejump
  jumptofat1:
    mov bx, word ptr [reserved]
    jmp donejump
  jumptofat2:
    cmp byte ptr [fats], 2
    jb jumptofat1
    mov ebx, dword ptr [fatend]
    jmp donejump
  jumptoroot:
    mov ebx, dword ptr [root]
    jmp donejump
  jumptodata:
    mov ebx, dword ptr [datastart]

  donejump:
  cmp dword ptr [dataend], ebx
  jb mainmenu 
  mov dword ptr [sector], ebx
  call rwsect
  
  jmp mainmenu
;-------------------------------------------------------
jumptosector:
  mov eax, dword ptr [dataend]
  mov dword ptr [maxvalue], eax
  mov dx, offset sectormsg
  call inputvalue
  cmp byte ptr [status], ERROR
  je jumpto

  mov ebx, dword ptr [value]
  jmp donejump
;-------------------------------------------------------
jumptolastsect:
  mov ebx, dword ptr [dataend]
  jmp donejump
;-------------------------------------------------------
mletter:
 sub al, 32
cletter:
 mov cl, 1
 call printchar2
 sub al, 55
 jmp modifybuffer
;-------------------------------------------------------
number:
 mov cl, 1
 call printchar2
 sub al, 48

modifybuffer:
  mov dx, word ptr [spot]

  call aspotcalc
  mov word ptr [xy], dx
  call spotinbx
  mov dl, byte ptr [readbuffer+bx]      ; get the byte to be edited from
                                        ; the buffer

  cmp byte ptr [hl], 0
  jne lowmodify
   and dl, 0Fh                  ; remove the top nibble
   shl al, 4                    ; set the typed in hex value
   or dl, al                    ; as being the new top nibble
  jmp donemodify

  lowmodify:
   and dl, 0F0h                 ; remove the bottom nibble
   or dl, al                    ; set typed in hex as new bottom nibble

  donemodify:
   mov byte ptr [readbuffer+bx], dl     ; display the new character
   call printchar                       ; on the right side of the screen
  jmp moveright
;-------------------------------------------------------
moveup:
 mov al, byte ptr [hl]
 mov dx, word ptr [spot]
 cmp byte ptr [editmode], ASCIIEDIT
 je hexmoveup
 cmp byte ptr [displaymode], HEX
 je hexmoveup
   sub dx, 4
 jmp domove
 hexmoveup:
   sub dx, 16
 jmp domove
;-------------------------------------------------------
movedown:
 mov al, byte ptr [hl]
 mov dx, word ptr [spot]
 cmp byte ptr [editmode], ASCIIEDIT
 je hexmovedown
 cmp byte ptr [displaymode], HEX
 je hexmovedown
   add dx, 4
 jmp domove
 hexmovedown:
   add dx, 16
 jmp domove
;-------------------------------------------------------
moveleft:
 mov al, byte ptr [hl]
 mov dx, word ptr [spot]
 cmp byte ptr [editmode], ASCIIEDIT
 je deconly
 cmp al, 0
 je zero_left
   cmp al, 5
   jne skipbinspecial
     dec al
   skipbinspecial:
   dec al
 jmp domove

 zero_left:
   cmp byte ptr [displaymode], HEX
   je dohexaddonly
     add al, 7
   dohexaddonly:
   inc al
   deconly:
   dec dx
 jmp domove
;-------------------------------------------------------
moveright:
 mov al, byte ptr [hl]
 mov dx, word ptr [spot]
 cmp byte ptr [editmode], DEFAULTEDIT
 je defright
  inc dx
  jmp domove
 defright:

 cmp byte ptr [displaymode], HEX
 je dohexrightcheck
   cmp al, 8
 jmp rightcheck
 dohexrightcheck:
   cmp al, 1
 rightcheck:
 je none_right

   cmp al, 3
   jne skiprightadjust
     inc al
   skiprightadjust:
     inc al
   jmp domove
 none_right:
   mov al, 0
   inc dx
;-------------------------------------------------------
domove:
  cmp dx, 512
  jae getkeyagain
  cmp dx, word ptr [rembytes]
  jae getkeyagain

  push word ptr [spot]          ; back old cursor spot up
  xchg ax, dx
  call movecursor               ; spot is changed to ax
  pop ax

  cmp byte ptr [displaymode], BINARY
  jne dontchangescreens
    mov bx, word ptr [spot]     ; figures out if we've crossed a 128-byte
    shl ax, 1                   ; barrier by checking if the high bits have
    shl bx, 1                   ; changed.  if so, then we need to redraw,
    cmp bh, ah                  ; otherwise there's no need to waste CPU.
    je dontchangescreens
    call printscreen
  dontchangescreens:
  call printoffset
 jmp getkeyagain
;-------------------------------------------------------
spotcalc:
  push ax
  cmp byte ptr [displaymode], BINARY
  je binaryspotcalc
    mov ax, dx                    ; for use with hex view
    shr dx, 4                     ; ---calculates where the current
    inc dl                        ; hex byte should be put on the
    mov dh, dl                    ; screen for the buffer offset ax

    and al, 00001111b

    mov dl, al
    add dl, al
    add dl, al
    shr al, 2
    add dl, al
    add dl, 10
    jmp donespotcalc
  binaryspotcalc:
    mov ax, dx
    shr dx, 2
    and dx, 11111b
    mov dh, dl
    inc dh
    and al, 11b
    mov ah, 13
    mul ah
    mov dl, al
    add dl, 11
  donespotcalc:
  pop ax
  ret
;-------------------------------------------------------
getyn:
  mov dx, offset ynmsg
  call printstring
  getyn2:
  call cursorgetkey
  cmp ah, LETTER_Y
  je returny
  cmp al, ENTER_KEY
  je returny
  cmp ah, LETTER_N
  je returnn
  cmp al, ESCAPE_KEY
  je returnn
  jmp getyn2
  returnn:
  mov al, 0
  ret
  returny:
  mov al, 1
  doret:
  ret
;-------------------------------------------------------
quit:
  mov dx, offset quitmsg
  call printbottom
  call getyn
  cmp al, 0
  je doret
  doquit:

  mov ax, 500h
  int 10h
  mov ax, 1200h
  mov bl, 10h
  xor cx, cx
  int 10h
  or cx, cx
  jz doneset
  mov bl, 30h
  mov ax, 1202h
  int 10h
  mov ax, 7
  or bh, bh
  jnz label2
  mov al, 3
label2:
  int 10h

  doneset:

  mov ax, 2524h
  mov dx, word ptr [old24h]
  mov ds, word ptr [old24h+2]
  int 21h

  mov ax, 4c00h
  int 21h
;-------------------------------------------------------




;-------------------------------------------------------
choosefatview:

  cmp byte ptr [fattype], FAT12
  jne tryfat16view

    xor eax, eax
    mov ax, word ptr [reserved]
    add eax, dword ptr [spf]
    cmp eax, dword ptr [sector]
    jbe okasis12
      sub eax, dword ptr [spf]
    okasis12:
    mov dword ptr [fat12start], eax

    mov dl, FAT12VIEW
  tryfat16view:
  cmp byte ptr [fattype], FAT16
  jne tryfat32view
    mov dl, FAT16VIEW
  tryfat32view:
  cmp byte ptr [fattype], FAT32
  jne donechoosingfat
    mov dl, FAT32VIEW
  donechoosingfat:

jmp dontscanfordir  
setbsview:
  mov dl, BOOTSECTORVIEW
jmp dontscanfordir
setfsview:
  mov dl, FSINFOVIEW
jmp dontscanfordir
;-------------------------------------------------------
; viewmode; see the variable definition for details

printview:

  mov bx, offset viewmode
  cmp byte ptr [bx], BOOTSECTORVIEW
  je bsview
  cmp byte ptr [bx], FAT12VIEW
  je fat12viewmode
  cmp byte ptr [bx], FAT16VIEW
  je fat16viewmode
  cmp byte ptr [bx], FAT32VIEW
  je fat32viewmode
  cmp byte ptr [bx], ROOTVIEW
  je dirview
  cmp byte ptr [bx], MBRVIEW
  je hd0view
  cmp byte ptr [bx], FSINFOVIEW
  je fsinfoviewmode

ifdef DEBUG
  cmp byte ptr [bx], DEBUGVIEW
  je debugviewmode
endif

;  call clearview

  ; [highlight]: 11223333h
  ;
  ;        11: Number of bytes to highlight on screen
  ;        22: Number of bytes deviating from [spot] to highlight for
  ;        3333: Starting [spot] to highlight from

  ret
;-------------------------------------------------------
fsinfoviewmode:
  mov word ptr [xy], 2201h

  mov al, byte ptr [subsector]
  xor ah, ah

  shl eax, 9
  mov si, offset readbuffer
  add si, ax

  mov dword ptr [highlight], 0A0401E9h
  mov dx, offset fcs

  dofcssfc: 
  call printstring
  mov bx, word ptr [highlight]
  dec bx

  mov eax, dword ptr [si+bx]
  cmp eax, 0FFFFFFFFh
  jne vbik
    mov byte ptr [highlight+3], 07h
    call bshighlight
    mov dx, offset unknownmsg
    call printstring
    mov al, 00h
    mov cl, 3
    call printchar2
    jmp dtsc
  vbik:
  call bshighlight

  call printcount
  mov dx, offset valuebuffer
  call printstring
  dtsc:
  cmp byte ptr [highlight], 0EDh
  jne dosfc
  ret

  dosfc:
  call gotonextline

  mov byte ptr [highlight+3], 0Ah
  mov byte ptr [highlight], 0EDh
  mov dx, offset sfc
  jmp dofcssfc
;-------------------------------------------------------
dirview:
  mov word ptr [xy], 2201h

  mov al, byte ptr [subsector]
  xor ah, ah

  shl eax, 9
  mov si, offset readbuffer
  add si, ax
  mov cx, word ptr [spot]

  xor bx, bx

  cmp cx, 64
  jb dirviewok
  dirviewnotok:
    sub cx, 32
    add bx, 32
  cmp bx, 416
  jae dirviewok
  cmp cx, 64
  jae dirviewnotok
  dirviewok:

  mov ch, 7

  processentry:

  cmp bx, 512          ; when we're looking at the very last entry in
  jb ncll1             ; a directory...an extra line may be displayed.
    cmp ch, 1          ; this wipes it.
    jne ncll1
    mov al, SPACE      ; it might be wiser just to never display that
    mov cl, 78         ; last line.
    call printchar2
    jmp doneentry
  ncll1:

  mov dx, offset attributesmsg
  call printstring

  mov dword ptr [highlight], 0601000Ch
  add word ptr [highlight], bx
  call bshighlight

  mov al, byte ptr [si+bx+0Bh]

  mov ah, READONLY
  mov dl, 'R'
  call testattrib

  mov ah, HIDDEN
  mov dl, 'H'
  call testattrib

  mov ah,SYSTEM
  mov dl, 'S'
  call testattrib
  
  mov ah, VOLUME
  mov dl, 'V'
  call testattrib

  mov ah, DIRECTORY
  mov dl, 'D'
  call testattrib

  mov ah, ARCHIVE
  mov dl, 'A'
  call testattrib

  add byte ptr [xy], 9

  mov dx, offset createdmsg
  call printstring

  push bx
  add bx, 10h
  call printdate

  xor dh, dh
  xor ah, ah
  mov dl, byte ptr [si+bx-03h]
  cmp dl, 199
  jb msok
    mov dl, 199
  msok:

  sub bx, 02h
  mov ax, word ptr [si+bx]
  call printtime
  pop bx

  mov dl, '.'
  call printchar

  mov dword ptr [highlight], 0101000Eh
  add word ptr [highlight], bx
  call bshighlight

  xor ah, ah
  mov al, byte ptr [si+bx+0Dh]
  cmp al, 199
  jbe msecok
    mov al, 199
  msecok:
  xor dx, dx
  push bx
  mov bx, 10
  div bx
  pop bx
  add dl, 48
  call printchar


  add byte ptr [xy], 5

  mov dx, offset clustermsg
  call printstring

  mov dword ptr [highlight], 03020015h
  add word ptr [highlight], bx
  call bshighlight

  mov ax, word ptr [si+bx+14h]
  call printhex
  mov dx, offset valuebuffer+5
  call printstring

  mov byte ptr [highlight+3], 04
  add word ptr [highlight], 6
  call bshighlight

  mov ax, word ptr [si+bx+1Ah]
  call printhex
  mov dx, offset valuebuffer+4
  call printstring

  dec ch
  jz doneentry

  call gotonextline

  halfdir:

  mov dx, offset accessedmsg    ; last accessed
  call printstring

  push bx
  add bx, 12h
  call printdate
  pop bx

  add byte ptr [xy], 5

  mov dx, offset modifiedmsg    ; last modified
  call printstring

  push bx
  add bx, 18h
  call printdate
  xor dx, dx
  sub bx, 02h
  call printtime
  pop bx


  add byte ptr [xy], 7

  mov dx, offset sizemsg
  call printstring

  mov dword ptr [highlight], 0A04001Dh
  add word ptr [highlight], bx
  call bshighlight

  mov eax, dword ptr [si+bx+1Ch]
  call printcount
  mov dx, offset valuebuffer
  call printstring

  call gotonextline
  add bx, 32
  dec ch
  jnz processentry
  doneentry:
  ret
;-------------------------------------------------------
printdate:
  mov ax, word ptr [si+bx]
  mov word ptr [highlight], bx
  inc word ptr [highlight]
  mov word ptr [highlight+2], 0202h
  call bshighlight
  and eax, 0FFFFh
  push ax
  shr ax, 5
  and ax, 1111b
    jnz monthok1
      inc ax
    monthok1:
    cmp ax, 12
    jbe monthok2
      mov ax, 12
    monthok2:
    call printcount
    mov dx, offset valuebuffer+8
    call printstring
  mov dl, '-'
  call printchar

  mov byte ptr [highlight+2], 01h
  call bshighlight
  pop ax
  push ax
    and ax, 11111b
    jnz dayok
      inc ax
    dayok:
    call printcount
    mov dx, offset valuebuffer+8
    call printstring
  mov dl, '-'
  call printchar
  inc byte ptr [highlight]
  mov byte ptr [highlight+3], 04h
  call bshighlight
  pop ax
  shr ax, 9
  add ax, 1980
  call printcount
  mov dx, offset valuebuffer+6
  call printstring
  inc byte ptr [xy]
  ret
;-------------------------------------------------------
printtime:
  mov ax, word ptr [si+bx]
  mov word ptr [highlight], bx
  add word ptr [highlight], 2
  mov word ptr [highlight+2], 0201h
  call bshighlight

  and eax, 0FFFFh
  push dx
  push ax
    shr ax, 11
    cmp ax, 23
     jbe hourok
     mov ax, 23
     hourok:
    call printcount
    mov dx, offset valuebuffer+8
    call printstring
  mov dl, ':'
  call printchar
  dec word ptr [highlight]
  inc byte ptr [highlight+2]
  call bshighlight
  pop ax
  push ax
    shr ax, 5
    and ax, 111111b
    cmp ax, 59
     jbe minok
     mov ax, 59
     minok:
    call printcount
    mov dx, offset valuebuffer+8
    call printstring
  mov dl, ':'
  call printchar
  pop ax
  pop dx

;  inc word ptr [highlight]
  push ax                               ; \Fix/
  mov ax, word ptr [spot]
  and ax, 0000000000011111b
  cmp ax, 15h
  pop ax
  je nodec
  dec word ptr [highlight]
  jmp dobshl
  nodec:
  dec byte ptr [highlight+2]
  dobshl:
  call bshighlight

    and ax, 11111b
    cmp ax, 29
     jbe secok
     mov ax, 29
     secok:
    shl ax, 1

  push ax
  push bx
    mov ax, dx
    xor dx, dx
    mov bx, 10
    div bx
    mov dx, ax
  pop bx
  pop ax
    add ax, dx
    cmp ax, 59
    jbe secok2
      mov ax, 59
    secok2:

    call printcount
    mov dx, offset valuebuffer+8
    jmp printstring
;-------------------------------------------------------
testattrib:
  test al, ah
  jz noattribute
    jmp printchar
  noattribute:
    mov dl, '-'
    jmp printchar
;-------------------------------------------------------
fat32viewmode:
  mov word ptr [xy], 2204h
  mov dword ptr [highlight], 07040001h

  mov al, byte ptr [subsector]
  xor ah, ah
  shl eax, 9
  mov si, offset readbuffer
  add si, ax

  mov bx, 144

  loopline2:
  cmp word ptr [spot], bx
  jb donesetline2

    add si, 36
    add bx, 36
    add word ptr [highlight], 36

  cmp bx, 432
  jne loopline2

  donesetline2:

  mov cl, 9
  mov ch, 7

  fat32loop:

  call bshighlight
  add word ptr [highlight], 4

  lodsd
  call printhex
  mov dx, offset valuebuffer+1
  call printstring

  mov dl, SPACE
  call printchar

  cmp ch, 1
  jne skipskip2
  cmp cl, 8
  jne skipskip2
    cmp bx, 432
    jne skipskip2
    mov al, SPACE
    mov cl, 55
    jmp printchar2
  skipskip2:

  dec cl
  jnz fat32loop

  inc byte ptr [xy+1]
  mov byte ptr [xy], 4
  mov cl, 9

  dec ch
  jnz fat32loop

ret
;-------------------------------------------------------
fat16viewmode:
  mov word ptr [xy], 2203h
  mov dword ptr [highlight], 04020001h

  mov al, byte ptr [subsector]
  xor ah, ah
  shl eax, 9
  mov si, offset readbuffer
  add si, ax

  mov bx, 120

  loopline:
  cmp word ptr [spot], bx
  jb donesetline

    add si, 30
    add bx, 30
    add word ptr [highlight], 30

  cmp bx, 450
  jne loopline

  donesetline:

  mov cl, 15
  mov ch, 7

  fat16loop:

  call bshighlight
  add word ptr [highlight], 2

  lodsw

  call printhex
  mov dx, offset valuebuffer+4
  call printstring

  mov dl, SPACE
  call printchar

  cmp ch, 1
  jne skipskip
    cmp bx, 450
    jne skipskip
    mov al, SPACE
    mov cl, 69
    jmp printchar2
  skipskip:

  dec cl
  jnz fat16loop

  inc byte ptr [xy+1]
  mov byte ptr [xy], 3
  mov cl, 15

  dec ch
  jnz fat16loop

ret
;-------------------------------------------------------
fat12viewmode:

  mov dword ptr [highlight], 03020001h

  xor ax, ax                            ; this little loop figures out
  mov bx, word ptr [spot]               ; where to start displaying
  buf12fix:                             ; fat12 entries, since an entire
  cmp bx, 108                           ; subsector (512 bytes) of 3-nibbles
  jb donebuffix                         ; won't fit in the view area.
    sub bx, 27
    add ax, 27
    add word ptr [highlight], 27
    cmp ax, 300
    ja donebuffix
    jmp buf12fix
  donebuffix:

  xor dh, dh                            ; displaying fat12 entries, we
  mov dl, byte ptr [subsector]          ; need to figure out what subsector
  mov si, offset readbuffer             ; we're looking at. (subsector*512)
  shl dx, 9
  add si, dx
    call ffat12fix

  add si, ax

  mov eax, dword ptr [sector]

  mov ebx, dword ptr [fat12start]
  cmp ebx, eax
  ja dodec12
  sub eax, ebx
  jmp donesub12
  dodec12:
    dec eax
  donesub12:

    xor ebx, ebx
    mov bl, byte ptr [subsector]
    add eax, ebx
    mov cx, word ptr [bps]
    shr cx, 10
    shl eax, cl

  xor edx, edx
  mov ebx, 3
  div ebx

  mov word ptr [xy], 2203h

  cmp dl, 0
  je fat12loop
  dec word ptr [highlight]
  dec si
  cmp dl, 1
  je ssection
  
  fat12loop:

    lodsw
    call print12bits
    dec si
    ssection:
    lodsw
    xchg al, ah
    rol ax, 4
    call print12bits
    inc word ptr [highlight]

  jmp fat12loop
print12bits:
  mov dl, SPACE
  call printchar
  call bshighlight
  inc word ptr [highlight]
  call printhex
  mov dx, offset valuebuffer+5
  call printstring
  cmp byte ptr [xy], 75
  jne rp12
    inc byte ptr [xy+1]
    mov byte ptr [xy], 3
  rp12:
  mov cx, 2903h
  cmp word ptr [xy], cx
  jb rp13
    mov al, SPACE
    mov cl, 4
    pop dx
    jmp printchar2
  rp13:
  ret
;-------------------------------------------------------
hd0common:
  mov al, 20
  mul cl
  inc al
  mov byte ptr [xy], al
  inc byte ptr [xy+1]
  ret
;-------------------------------------------------------
hd0view:
  mov byte ptr [xy], 01h
  xor cx, cx

  mov al, byte ptr [subsector]
  xor ah, ah
  shl eax, 9
  mov si, offset readbuffer
  add si, ax

  nextpart:
  mov byte ptr [xy+1], 22h

  mov dx, offset partition
  call printstring
  mov ax, 10h
  mul cx
  mov bx, 1BEh
  add bx, ax
  mov dx, cx
  add dl, '1'
  call printchar
  mov dl, ':'
  call printchar
  mov dl, SPACE
  call printchar

  call hd0common

  mov dx, offset mboot
  call printstring

  mov word ptr [highlight+2], 0201h
  mov word ptr [highlight], bx
  inc word ptr [highlight]
  call bshighlight

  mov al, byte ptr [si+bx]
  call printhex
  mov dx, offset valuebuffer+6
  call printstring

  mov dl, SPACE
  call printchar
  cmp al, 80h
  je partactive

  push cx
  mov al, SPACE
  mov cl, 8
  call printchar2
  pop cx
  jmp donepart

  partactive:
  mov dl, '('
  call printchar
    mov dx, offset active
    call printstring
    mov dl, ')'
    call printchar
  donepart:

  call hd0common

  mov dx, offset startchs
  call printchs

  call hd0common

  mov dx, offset mtype
  call printstring

  mov word ptr [highlight+2], 0201h
  mov word ptr [highlight], bx
  add word ptr [highlight], 5

  call bshighlight

  mov al, byte ptr [si+bx+4]
  call printhex
  mov dx, offset valuebuffer+6
  call printstring

  mov dl, SPACE
  call printchar

  cmp al, 00h
  je unusedpart

  cmp al, 01h
  je fat12part

  cmp al, 04h
  je fat16part
  cmp al, 06h
  je fat16part
  cmp al, 0Eh
  je fat16part

  cmp al, 0Bh
  je fat32part
  cmp al, 0Ch
  je fat32part

  cmp al, 05h
  je extfatpart
  cmp al, 0Fh
  je extfatpart

;11,14,16,1B,1C,1E,8D,90,91,92,97,98,9A,9B are all hidden fat

  cmp al, 11h
  je hidfatpart
  cmp al, 14h
  je hidfatpart
  cmp al, 16h
  je hidfatpart
  cmp al, 1Bh
  je hidfatpart
  cmp al, 1Ch
  je hidfatpart
  cmp al, 1Eh
  je hidfatpart
  cmp al, 8Dh
  je hidfatpart
  cmp al, 90h
  je hidfatpart
  cmp al, 91h
  je hidfatpart
  cmp al, 92h
  je hidfatpart
  cmp al, 97h
  je hidfatpart
  cmp al, 98h
  je hidfatpart
  cmp al, 9Ah
  je hidfatpart
  cmp al, 9Bh
  je hidfatpart

  push cx
  mov al, SPACE
  mov cl, 9
  call printchar2
  pop cx

  jmp dontshowpart

  unusedpart:
    mov dx, offset part00
    jmp showpart

  hidfatpart:
    mov dx, offset parthid
    jmp showpart

  extfatpart:
    mov dx, offset part050F
    jmp showpart

  fat32part:
    mov dx, offset part0B0C
    jmp showpart

  fat16part:
    mov dx, offset part04060E
    jmp showpart

  fat12part:
    mov dx, offset part01

  showpart:
    push dx
    mov dl, '('
    call printchar
    pop dx
    call printstring
    mov dl, ')'
    call printchar
    mov dl, SPACE
    call printchar
    call printchar

  dontshowpart:

  call hd0common
  mov dx, offset endchs

  add bx, 4

  call printchs
  call hd0common

  mov dx, offset startlba
  call printstring
  mov dl, SPACE
  call printchar

  mov word ptr [highlight+2], 0A04h
  mov word ptr [highlight], bx
  add word ptr [highlight], 5
  call bshighlight

  mov eax, dword ptr [si+bx+04h]
  call printcount
  mov dx, offset valuebuffer
  call printstring

  call hd0common

  mov dx, offset psize
  call printstring

  mov word ptr [highlight+2], 0A04h
  mov word ptr [highlight], bx
  add word ptr [highlight], 9
  call bshighlight

  mov eax, dword ptr [si+bx+08h]
  call printcount
  mov dx, offset valuebuffer
  call printstring

  inc cx

  call hd0common
  cmp cx, 4
  jb nextpart

  ret
;-------------------------------------------------------
printchs:
  call printstring
  mov dl, SPACE
  call printchar
  xor eax, eax
  mov al, byte ptr [si+bx+3]
  mov ah, byte ptr [si+bx+2]
  shr ah, 6

  mov word ptr [highlight+2], 0402h
  mov word ptr [highlight], bx
  add word ptr [highlight], 3

  call bshighlight

  call printcount
  mov dx, offset valuebuffer+6
  call printstring

  mov dl, '/'
  call printchar

  mov word ptr [highlight+2], 0301h
  dec word ptr [highlight]

  call bshighlight

  xor eax, eax
  mov al, byte ptr [si+bx+1]
  call printcount
  mov dx, offset valuebuffer+7
  call printstring
  mov dl, '/'
  call printchar

  mov byte ptr [highlight+3], 02h
  inc word ptr [highlight]
  call bshighlight

  xor eax, eax
  mov al, byte ptr [si+bx+2]
  and al, 00111111b
  call printcount
  mov dx, offset valuebuffer+8
  jmp printstring
;-------------------------------------------------------
bsview:
  mov word ptr [xy], 2201h

  mov al, byte ptr [subsector]
  xor ah, ah
  shl eax, 9
  mov bx, offset readbuffer
  add bx, ax

  mov si, offset highlight
  xor eax, eax
  mov ax, word ptr [0Bh+bx]
  mov dx, offset mbps
  mov dword ptr [si], 0502000Ch

  call basicbs

  mov al, byte ptr [0Dh+bx]
  mov dx, offset mspc
  mov dword ptr [si], 0301000Eh

  call basicbs

  mov ax, word ptr [bx+0Eh]
  mov dx, offset mreserved
  mov dword ptr [si], 0502000Fh

  call basicbs

  mov dx, offset mfats
  mov al, byte ptr [bx+10h]
  mov dword ptr [si], 03010011h

  call basicbs

  mov ax, word ptr [bx+11h]
  mov dx, offset mrootentries
  mov dword ptr [si], 05020012h

  call basicbs

  mov ax, word ptr [bx+13h]
  mov word ptr [si], 0014h
  test ax, ax
  jnz sipcorrect
  mov eax, dword ptr [bx+20h]
  mov dword ptr [si], 0A040021h
  sipcorrect:
  mov dx, offset msip

  call basicbs

  mov al, byte ptr [bx+15h]
  mov dx, offset mdb
  mov dword ptr [si], 03010016h

  call basicbs

  mov ax, word ptr [bx+16h]
  mov dword ptr [si], 0A020017h
  test ax, ax
  jnz spfcorrect
  mov eax, dword ptr [bx+24h]
  mov dword ptr [si], 0A040025h
  spfcorrect:
  mov dx, offset mspf

  call basicbs

  mov eax, dword ptr [bx+1ch]
  mov dx, offset mhs
  mov dword ptr [si], 0A04001Dh

  call basicbs

  mov eax, dword ptr [bx+2ch]
  mov dx, offset mrootc
  mov word ptr [si], 002Dh

  call basicbs

  mov ax, word ptr [bx+30h]
  mov dx, offset mfsis
  mov dword ptr [si], 05020031h

  call basicbs

  mov ax, word ptr [bx+32h]
  mov dx, offset mbackup
  mov word ptr [si], 0033h

  call basicbs

  mov al, byte ptr [bx+24h]
  mov dword ptr [si], 03010025h
  cmp word ptr [bx+16h], 0
  jne ldncorrect
  mov al, byte ptr [bx+40h]
  mov word ptr [si], 0041h
  ldncorrect:
  mov dx, offset mldn

  jmp basicbs
;-------------------------------------------------------
basicbs:
  call printstring
  call spaceandcolon
  call printcount
  push bx
  mov bx, offset valuebuffer
  mov cl, 0Ah
  locateloop:
    cmp cl, 01h
    je doneshift
    cmp byte ptr [bx], '0'
    jne doneshift
      inc bx
    loop locateloop
  doneshift:

  mov byte ptr [highlight+3], cl
  mov dx, bx
  pop bx

  call bshighlight


  call printstring

;  mov al, byte ptr [bx+15h]
;  mov dx, offset mdb
;  mov dword ptr [si], 03010016h

  cmp word ptr [highlight], 0016h
  jne npldn2
  mov al, byte ptr [bx+15h]
  cmp al, 0F0h
  jb npldn2
    mov dx, offset mfixed
    cmp al, 0F8h
    je itisfixed
      mov dx, offset mremovable
    itisfixed:
    call printstring

    add cl, 5
  npldn2:

  cmp word ptr [highlight], 0025h
  jne isldn
  mov al, byte ptr [bx+24h]
  jmp isldn2
  isldn:
  cmp word ptr [highlight], 0041h
  jne npldn
  mov al, byte ptr [bx+40h]
  isldn2:
  cmp al, 80h
  jb npldn
  cmp al, 89h
  ja npldn
    mov dl, SPACE
    call printchar
    mov dl, '('
    call printchar
    mov dl, al
    sub dl, 80h-48
    call printchar
    mov dl, ')'
    call printchar
    add cl, 4
  npldn:

  xchg ch, cl
  mov cl, 0Ch
  sub cl, ch
  xor ch, ch
  mov dl, SPACE
  printbsspace:
  call printchar
  loop printbsspace

  xor eax, eax
  jmp nextviewline
;-------------------------------------------------------
bshighlight:
  pusha
  call cbuffer_offset
  xor cx, cx

  mov al, DEFAULTCOLOR

  mov cl, 0Ah
  dehighlightentry:
  inc di
  stosb
  dec cx
  jnz dehighlightentry

  xor cx, cx
  mov cl, byte ptr [highlight+2]
  xor bx, bx
  xor dx, dx
  highlightloop:
    mov dx, word ptr [highlight]
    add dx, bx
    dec dx
    cmp word ptr dx, [spot]
    jne notonspot
      xor si, si

      call cbuffer_offset
      xor cx, cx
      mov cl, byte ptr [highlight+3]

      mov al, HIGHLIGHTCOLOR

      highlightentry:
      inc di
      stosb
      dec cx
      jnz highlightentry
      mov cx, 1
    notonspot:
    inc bx
  loop highlightloop
  popa
  ret
;-------------------------------------------------------
cbuffer_offset:                 ; take what's in [xy] and set di to offset
  push 0b800h                   ; to the respective byte in the screen buffer
  pop es
  mov al, byte ptr [xy+1]
  mov bx, 80
  mul bl
  mov bl, byte ptr [xy]
  add ax, bx
  shl ax, 1
  mov di, ax
  ret
;-------------------------------------------------------
spaceandcolon:
  mov dl, ':'
  call printchar
  mov dl, SPACE
  cmp byte ptr [xy], 47
  ja rightside
  loopwipeview:
  call printchar
  cmp byte ptr [xy], 23
  jb loopwipeview
  ret
  rightside:
  call printchar
  cmp byte ptr [xy], 62
  jne rightside
  ret
;-------------------------------------------------------
nextviewline:
  cmp byte ptr [xy], 55
  ja gotonextline
  mov byte ptr [xy], 40
  ret

gotonextline:
  inc byte ptr [xy+1]
  mov byte ptr [xy], 1
  ret
;-------------------------------------------------------
getfilename:
  mov dx, offset filenamemsg
  call printbottom

  mov cx, 68
  mov di, offset filename
  getkeyagain6:
  call cursorgetkey

  cmp al, BACKSPACE_KEY
  je backspacefile

  cmp al, ENTER_KEY
  je donegetfilename

  cmp al, ESCAPE_KEY
  je abortgetfilename

  test cx, cx
  jz getkeyagain6

  cmp ah, TAB_KEY
  je abortgetfilename

  cmp al, 21h           ; exclamation mark.  anything below it is
  jb getkeyagain6       ; completely invalid in filenames

  cmp al, QUOTATION
  je getkeyagain6

  cmp al, PERCENT
  je getkeyagain6

  cmp al, COMMA
  je getkeyagain6

  cmp al, FORWARD_SLASH
  je getkeyagain6

  cmp al, SEMICOLON
  je getkeyagain6

  cmp al, LESS_THAN
  je getkeyagain6

  cmp al, GREATER_THAN
  je getkeyagain6

  cmp al, QUESTION_MARK
  je getkeyagain6

  cmp al, PIPE
  je getkeyagain6

  cmp al, 7Eh                   ; anything above the tilde is invalid
  ja getkeyagain6

  mov dl, al
  call printchar
  call setxy

  push cs
  pop es
  stosb

  dec cx
  jmp getkeyagain6
  donegetfilename:

  mov al, 0
  stosb
;  xor bx, bx
;  mov bl, byte ptr [xy]
;  sub bl, 11
;  mov si, offset filename
;  mov byte ptr [si+bx], 0
  ret
  abortgetfilename:
  mov cx, 68
  ret
;-------------------------------------------------------
checklimit:
  push eax
  mov eax, dword ptr [maxvalue]
  xor edx, edx
  mov ebx, 10   
  div ebx
  mov ebx, eax  ; 287

  pop eax
  cmp ecx, ebx
  jbe oklimit
  mov al, 0
  oklimit:
  ret
;-------------------------------------------------------
inputvalue:
  call printbottom
  mov dl, byte ptr [xy]
  mov byte ptr [maxleft], dl
  call clearbottom
  xor ecx, ecx
  mov byte ptr [status], SUCCESS
  getkeyagain7:
  mov dword ptr [value], ecx
  call cursorgetkey

  cmp al, ESCAPE_KEY
  je abortvalue

  cmp al, ENTER_KEY
  je donevalue

  cmp al, BACKSPACE_KEY
  je backvalue

  cmp al, '0'
  jne non0jump

  test ecx, ecx
  jz getkeyagain7

  non0jump:

  cmp al, '0'
  jb getkeyagain7

  cmp al, '9'
  ja getkeyagain7

  call checklimit
  cmp al, 0
  je getkeyagain7

  mov dl, al
  sub dl, 48

  push ecx
  lea ecx, [ecx][ecx*4]
  lea ecx, [ecx][ecx]
  and edx, 0fh
  add ecx, edx

  cmp ecx, dword ptr [maxvalue]
  pop ecx
  ja getkeyagain7

  lea ecx, [ecx][ecx*4]
  lea ecx, [ecx][ecx]
  add ecx, edx
  mov dl, al
  call printchar
  call setxy

  jmp getkeyagain7
  abortvalue:
  mov byte ptr [status], ERROR
  donevalue:
  ret
;------------
eaxm2mul:       ; in: ebx: cluster number
                ; out: eax: sector number
  mov eax, ebx
  xor ebx, ebx
  sub eax, 2
  mov bl, byte ptr [spc]
  mul ebx
  jnc noerr
    errem2:
    mov eax, 0FFFFFFFFh         ; invalid cluster number was sent
    ret
  noerr:
  add eax, dword ptr [datastart]
  jc errem2
  cmp byte ptr [fattype], FAT32
  jne skipfat32adjust
  cmp dword ptr [rootc], 2
  ja skipfat32adjust
    sub eax, ebx
    jc errem2
  skipfat32adjust:
  ret
;-------------------------------------------------------
printcounts:
  mov word ptr [xy], 21        ; print the current sector
  mov byte ptr [region], UNDEFINED
  mov eax, dword ptr [sector]  ; note that the string "Sector:"
  call printcount              ; isn't printed for efficiency
  mov dx, offset valuebuffer
  call printstring

  inc byte ptr [xy]            ; prints subsector in this manner: [1]
  mov dl, '['
  call printchar
  mov dl, byte ptr [subsector]
  add dl, '1'
  call printchar
  mov dl, ']'
  call printchar

  mov byte ptr [xy], 36

  mov eax, dword ptr [sector]

  cmp byte ptr [drivetype], PHYSICAL
  je inphysical
  cmp byte ptr [drivetype], CDROM
  je indata

  xor edx, edx
  mov dx, word ptr [reserved]
  cmp eax, edx
  jb inreserved

  xor ch, ch
  mov cl, byte ptr [fats]
  test cl, cl
  jz notinfat
  anotherfat:
    add edx, dword ptr [spf]
  loop anotherfat
  cmp eax, edx
  jb infat

  notinfat:
  mov edx, dword ptr [root]
  cmp eax, edx
  jb indata
  xor ebx, ebx
  mov bx, word ptr [rootsectors]
  add edx, ebx
  cmp eax, edx
  jae indata

  mov byte ptr [region], ROOTVIEW
  mov dx, offset inrootmsg

  cmp byte ptr [fattype], FAT32
  je dispclust

  continuecount:
  call printstring
  abortdc:

  mov al, 61
  sub al, byte ptr [xy]
  mov dl, SPACE
  cleantop:
  call printchar
  dec al
  jnz cleantop

  cmp byte ptr [drivetype], PHYSICAL
  jne doneprintcounts
    call getchs
    xor eax, eax
    mov ah, cl                           ; the following block of code
    shr ah, 6                            ; prints "CHS: xx/xxx/xxxx" in the
    mov al, ch                           ; top right corner for ah=02h/int13h

    push dx
    mov word ptr [xy], 003Fh
    mov dx, offset chsmsg
    call printstring
    call printcount
    mov dx, offset valuebuffer+6
    call printstring
    mov dl, '/'
    call printchar
    pop dx

    mov al, dh
    call printcount
    mov dx, offset valuebuffer+7
    call printstring
    mov dl, '/'
    call printchar

    mov al, cl
    and al, 00111111b
    call printcount
    mov dx, offset valuebuffer+8
    call printstring


  doneprintcounts:
  ret

  inreserved:
    mov byte ptr [region], DATAVIEW
    test eax, eax
    jnz setbsview2
    mov byte ptr [region], BOOTSECTORVIEW
  setbsview2:
    mov dx, offset inreservedmsg
    jmp continuecount

  infat:
    mov byte ptr [region], PICKFATVIEW
    push word ptr [xy]
    call printentry
    pop word ptr [xy]
    mov dx, offset infatmsg 
    call printstring
    mov dl, 49
    mov eax, dword ptr [fatend]
    cmp dword ptr [sector], eax
    jb firstfat
    mov dl, 50
    firstfat:
    call printchar
    mov dl, ']'
    call printchar
    mov al, SPACE
    mov cl, 2
    call printchar2

    cmp byte ptr [fattype], UNDEFINED
    je abortdc

    mov byte ptr [xy], 2Dh
    mov dx, offset entrymsg
    call printstring
    mov byte ptr [xy], 3Ch
  jmp abortdc

  setmbrview:
    mov byte ptr [region], MBRVIEW
    mov dx, offset inmbrmsg
    call printstring
  jmp abortdc


  inphysical:
   cmp byte ptr [drive], 80h                   ; lower than 80h?
   jb indata                                   ; not an hd - no mbr.
    test eax, eax
    jz setmbrview
    mov cx, 4
    mov si, offset p1
    checkpxloop:
    cmp eax, dword ptr [si]
    je setbsview2
    add si, 4
    loop checkpxloop

  indata:
    mov byte ptr [region], DATAVIEW
    mov dx, offset indatamsg
    dispclust:
    cmp byte ptr [spc], 0
    je continuecount

    call printstring
    mov dl, SPACE
    call printchar

    cmp byte ptr [drivetype], FAT
    jne abortdc

      mov dx, offset clustermsg         ; display cluster number
      call printstring
      xor edx, edx
      mov eax, dword ptr [sector]
      sub eax, dword ptr [datastart]
      xor ebx, ebx
      mov bl, byte ptr [spc]
      div ebx
      cmp byte ptr [fattype], FAT32
      jne dontadjust
      cmp dword ptr [rootc], 2
      ja dontadjust
        inc eax
      dontadjust:
      add eax, 2

      mov dx, offset valuebuffer
      call printhex
    jmp continuecount
;-------------------------------------------------------
printhex:                               ; takes whats it's eax
  pusha                                 ; and sticks the equivalent
  mov si, offset hexstr                 ; hex into valuebuffer
  mov bp, offset valuebuffer
  mov byte ptr [bp+8], 0
  mov di, 7

  xor bh, bh
  shl eax, 4
  clusterloop:
  shr al, 4
  mov bl, al
  mov al, byte ptr [si+bx]
  mov byte ptr [bp+di], al
  shr eax, 4
  dec di
  jnz clusterloop
  popa
  ret
;-------------------------------------------------------
cursorgetkey:
  pusha
  mov ah, 01h
  mov cx, 0808h
  int 10h
  popa
call getkey
  pusha
  mov ah, 01h
  mov cx, 2000h
  int 10h
  popa
  ret
;-------------------------------------------------------
printstring:
  pusha
  mov si, dx
  call cbuffer_offset
  printstrloop:
  lodsb

  cmp al, 0
  je abortprintstr

  inc byte ptr [xy]
  stosb
  inc di
  jmp printstrloop

  abortprintstr:
  call setxy

  popa
  ret
;-------------------------------------------------------
savetodisk:
 mov dx, offset readingmsg
 call printbottom
  call copybuffer
  mov byte ptr [rw], WRITE
  push word ptr [subsector]
  call rwsect
  pop word ptr [subsector]
  cmp byte ptr [status], ERROR
  je mainmenu
  mov dx, offset donermsg
 call printerror
 jmp mainmenu
;-------------------------------------------------------
nextsect1000:
  mov eax, dword ptr [sector]
  add eax, 100
  jmp donextsect
;-------------------------------------------------------
nextsect:
  inc byte ptr [subsector]
  checkcursorbounds:
  xor dh, dh
  mov dl, byte ptr [subsector]  ; subsector * 512
  shl dx, 9
  mov ax, word ptr [bps]        ; if (subsector*512 <= bps)
  cmp ax, dx                    ; then we've not paged down to see all bytes
  jbe dorns
    sub ax, dx
    dec ax
    cmp word ptr [spot], ax
    jbe incursorbounds
      call movecursor
    incursorbounds:
    jmp mainmenu
  dorns:
  mov eax, dword ptr [sector]
  inc eax
  jmp donextsect
;-------------------------------------------------------
donextsect:
  cmp eax, dword ptr [dataend]
  jbe gonextsect
  sub eax, dword ptr [dataend]
  dec eax
  gonextsect:
  mov dword ptr [sector], eax
  call rwsect
  jmp mainmenu
;-------------------------------------------------------
lastsect:
  dec byte ptr [subsector]
  cmp byte ptr [subsector], 255
  jne mainmenu
  mov eax, dword ptr [sector]
  dec eax
jmp dolastsect
;-------------------------------------------------------
lastsect1000:
  mov eax, dword ptr [sector]
  sub eax, 100
;-------------------------------------------------------
dolastsect:
  cmp eax, dword ptr [sector]
  jb golastsect
  not eax

  mov ebx, dword ptr [dataend]
  sub ebx, eax
  mov eax, ebx
  golastsect:
  mov dword ptr [sector], eax
  call rwsect
  mov dx, word ptr [bps]
  dec dx
  shr dx, 9
  mov byte ptr [subsector], dl
  jmp checkcursorbounds
;-------------------------------------------------------
copybuffer:
  pusha
  mov si, offset readbuffer
  mov di, offset writebuffer
  push cs
  pop es

  mov cx, 2352
  keepmoving:
  rep movsb
  popa
  ret
;-------------------------------------------------------
getkey:
  mov ah, 00h
  int 16h
  ret
;-------------------------------------------------------
aspotcalc:                      ; ascii spot calculator
      and dh, 00000001b
      shl dx, 4
      shr dl, 4
      add dl, 3Fh
      inc dh
      ret
;-------------------------------------------------------
printscreen:                    ; this routine prints out all the
                                ; bytes in the read buffer

  mov si, offset readbuffer
  mov al, byte ptr [subsector]  ; adjust si to point to the current 512-byte
  shl ax, 9                     ; block ("subsector") within the current
  add si, ax                    ; sector if it exceeds 512 bytes.

  mov dx, word ptr [bps]
  sub dx, ax
  mov word ptr [rembytes], dx

  cmp word ptr [spot], dx
  jb notsignificant

    dec dx

    mov ax, dx
    mov dl, byte ptr [hl]

  notsignificant:

  xor eax, eax
  xor cx, cx

  displaynextchar:
    lodsb

      mov dx, cx
      call aspotcalc
      mov word ptr [xy], dx
      mov dl, al
      cmp cx, word ptr [rembytes]
      jb nntps
        mov dl, SPACE
      nntps:
      call printchar


    mov dx, cx
    call spotcalc
    mov word ptr [xy], dx


    cmp byte ptr [displaymode], BINARY
    je displaybinval
            cmp cx, word ptr [rembytes]
            jb pscontinue
              mov dl, '-'
              call printchar
              call printchar
            jmp donextdispbyte

           pscontinue:

            call printhex
            mov dx, offset valuebuffer+6
            call printstring
            jmp donextdispbyte
    displaybinval:
            mov dx, word ptr [spot]
            and dl, 10000000b
            add dx, 128
            cmp cx, dx
            jae donextdispbyte
            mov dx, word ptr [spot]
            and dl, 10000000b
            cmp cx, dx
            jb donextdispbyte

            cmp cx, word ptr [rembytes]
            jb pscontinue2
              mov al, '-'
              push cx
              mov cl, 4
              call printchar2
              add byte ptr [xy], 5
              call printchar2
              pop cx
            jmp donextdispbyte

           pscontinue2:

           call displaybinary

    donextdispbyte:

    cmp cx, 511
      jne keepps2
        jmp printaddresses       ; print hex addresses to left of screen
      keepps2:
    inc cx
  jmp displaynextchar
;---------------------------------------------------------------
printaddresses:
  mov byte ptr [xy+1], 00h
  mov byte ptr [xy], 1
  mov dx, offset offsetmsg
  call printstring
  mov byte ptr [xy], 13
  mov dx, offset sectormsg
  call printstring
  xor eax, eax
  mov al, byte ptr [subsector]
  shl ax, 9

  mov cx, 32
  cmp byte ptr [displaymode], BINARY
  je binaryprintoffsets
  nextaddress:
    call gotonextline
    call printhex
    mov dx, offset valuebuffer+2
    call printstring
    add eax, 10h
    loop nextaddress
  ret
  binaryprintoffsets:
  mov dx, word ptr [spot]
  and dl, 10000000b
  add ax, dx
  nextaddress2:
    call gotonextline
    call printhex
    mov dx, offset valuebuffer+2
    call printstring
    add eax, 4
    loop nextaddress2
  ret
;---------------------------------------------------------------
colorchar:
  pusha
  call cbuffer_offset
  mov byte ptr es:[di+1], EDITCOLOR
  cmp byte ptr [editmode], DEFAULTEDIT
  je ecolor1
    mov byte ptr es:[di+1], HIGHLIGHTCOLOR
  ecolor1:
  push word ptr [xy]

  mov dx, word ptr [spot]
  call aspotcalc
  mov word ptr [xy], dx

  call cbuffer_offset
  mov byte ptr es:[di+1], EDITCOLOR
  cmp byte ptr [editmode], ASCIIEDIT
  je ecolor2
    mov byte ptr es:[di+1], HIGHLIGHTCOLOR
  ecolor2:
  pop word ptr [xy]
  popa
  ret
;-------------------------------------------------------
decolorchar:
  pusha
  call cbuffer_offset
  mov byte ptr es:[di+1], DEFAULTCOLOR

  mov dx, word ptr [spot]
  call aspotcalc
  mov word ptr [xy], dx

  call cbuffer_offset
  mov byte ptr es:[di+1], DEFAULTCOLOR
  
  popa
  ret
;-------------------------------------------------------
printchar2:
  pusha
  push ax
  call cbuffer_offset
  pop ax

  printchar2loop:
    stosb
    inc di
  dec cl
  jnz printchar2loop
  popa
  ret
;-------------------------------------------------------
printchar:
  pusha
  call cbuffer_offset

  mov byte ptr es:[di], dl
  inc byte ptr [xy]
  popa
  ret
;-------------------------------------------------------
init:
  cld                           ; following code sets video mode

  mov ax, 1200h
  mov bl, 10h
  xor cx, cx
  int 10h
  or cx, cx
  jz fth
  mov bl, 30h
  mov ax, 1201h
  int 10h
  mov ax, 7
  or bh, bh
  jnz skipacd
  mov al, 3
  skipacd:
  int 10h
  mov ax, 1112h
  mov bl, 0
  int 10h
  fth:

    push 0b800h                   ; color the screen
    pop es
    xor di, di
    mov al, DEFAULTCOLOR
    mov cx, 3999
    colordisplay:
    inc di
    stosb
    loop colordisplay

  mov word ptr [xy], 131Ah      ; print out copyright info
  mov dx, offset introtext
  call printstring
  mov word ptr [xy], 161Ah      ; print out copyright info
  mov dx, offset copyright
  call printstring


    mov ax, 3524h                       ; back up old int 24h
    int 21h
    mov word ptr [old24h], bx
    mov word ptr [old24h+2], es
   
    mov ax, 2524h                       ; set up new int 24h
    mov dx, offset int24h
    int 21h

  call wipemem
  call seed

  mov word ptr [drivepacket2], 1                ; read in 1 sector at a time
  mov word ptr [drivepacket4], ds               ; set segment


  mov byte ptr [hl], 0          ; default to editing nibble 0
  xor dx, dx                    ; y = (spot-1)/16
  mov word ptr [spot], 0        ; default to editing byte 1
  call spotcalc
  mov word ptr [cxy], dx
  ret
;-------------------------------------------------------
setxy:                  ; set the current x/y coordinate of the cursor
 pusha                  ; this is mainly for the cursor when receiving
 xor bh, bh             ; input since we use direct text output
 mov dh, byte ptr [xy+1]
 mov dl, byte ptr [xy]
 mov ah, 02h
 int 10h
 popa
ret
;-------------------------------------------------------
printcount:                     ; takes whats in eax and puts it in valuebuffer
  pushad
  mov di, offset valuebuffer
  mov byte ptr [di+10], 0
  mov ebx, 10
  mov ch, 10

  loop5:
    xor edx, edx
    div ebx
    mov si, offset valuebuffer+8
    add dl, 30h

    mov cl, 9                      ; shifts the whole buffer left by 1 byte
    miniloop:                      ; to add new values on the right
      shl word ptr [si], 8
      dec si
      dec cl
    jnz miniloop

    mov byte ptr [di], dl
    dec ch
  jnz loop5
  popad
  ret
;-------------------------------------------------------
getchs:
   xor eax, eax
   xor ebx, ebx
   mov al, byte ptr [heads]
   mov bl, byte ptr [sectors]
   mul ebx

     test eax, eax
     jz zeroall

   mov ebx, eax
   mov eax, dword ptr [sector]
   xor edx, edx
   div ebx
   mov cl, ah
   shl cl, 6
   mov ch, al

   mov eax, edx
   xor dx, dx
   xor bh, bh
   mov bl, byte ptr [sectors]
   cmp bl, 0
   je skipdiv
   div bx
   skipdiv:
   mov dh, al
   inc dl
   and dl, 00111111b
   or cl, dl
   ret
   zeroall:
      mov cx, 1
      xor dh, dh
   ret
;-------------------------------------------------------
rwsect:
   push dword ptr [sector]
   pushad
   mov eax, dword ptr [drivestart]
   add dword ptr [sector], eax
   push cs
   pop es
   mov ax, word ptr [rwfunction]
   mov word ptr [oldfunction], ax
   mov ax, word ptr [bps]
   mov word ptr [oldbps], ax
   mov dl, byte ptr [drive]
   mov byte ptr [olddrive], dl
   mov byte ptr [status], SUCCESS
   mov word ptr [drivepacket3], offset readbuffer
   mov word ptr [diskbuffer+4], offset readbuffer
   xor si, si

   cmp byte ptr [rw], WRITE             ; unless the read write flag is
   jne reading                          ; WRITE, we'll read; just in
                                        ; case this value ever got corrupted,
                                        ; chances are it wouldn't be 'WRITE'

   mov word ptr [drivepacket3], offset writebuffer
   mov word ptr [diskbuffer+4], offset writebuffer
   inc si

   reading:

   mov byte ptr [subsector], 0
   mov eax, dword ptr [sector]
   mov dword ptr [drivepacket1], eax
   mov cx, 0FFFFh
   mov bx, offset drivepacket1

  test byte ptr [rwfunction], CRW
  jz cdromread
  mov word ptr [bps], 512
  cmp byte ptr [rwfunction], FILEFUNC
  je fileread
  cmp byte ptr [rwfunction], OLDINT25
  je oldread3
  cmp byte ptr [rwfunction], NEWINT13
  je hdread
  cmp byte ptr [rwfunction], OLDINT13
  je tryoldint13

     mov dl, byte ptr [drive]
     mov ax, 7305h                         ; extended sector read/write
     int 21h
     jc oldread2
     jmp nosectorerror
   ;-------------

   fileread:
     mov edx, dword ptr [dataend]
     add edx, dword ptr [drivestart]
     cmp eax, edx
     ja sectorerror


     shl eax, 9                           ; \Fix/

     mov edx, dword ptr [rwfilesize]
     sub edx, 512
     cmp eax, edx
     ja sectorerror

     mov bx, word ptr [rwhandle]
     mov dx, ax
     shr eax, 16
     mov cx, ax
     mov ax, 4200h
     int 21h

     push cs
     pop ds

     mov ah, 3fh
     mov dx, offset readbuffer
     cmp byte ptr [rw], WRITE
     jne dofread
       mov dx, offset writebuffer
       inc ah
     dofread:
     mov bx, word ptr [rwhandle]
     mov cx, 512
     int 21h
     jc sectorerror
     jmp nosectorerror

   ;-------------
     trycdrom:                ; drive check for mscdex
       mov ax, 150Bh
       xor ch, ch
       mov cl, byte ptr [drive]
       int 2Fh
       cmp bx, 0ADADh
       jne sectorerror
       test ax, ax
       jz sectorerror

       mov byte ptr [rwfunction], CDCOOKED
       mov byte ptr [drivetype], CDROM

       mov word ptr [bps], 2048
       mov byte ptr [cdheader], 13              ; size of header
       mov word ptr [cdheader+14], offset readbuffer
       mov word ptr [cdheader+16], cs
       mov word ptr [cdheader+18], 1
       mov byte ptr [cdheader+24], 0           ; cooked mode

    mov dx, offset cdrcmsg              ; choose between raw/cooked
    call printbottom
          getrc:
          call cursorgetkey
          cmp al, 'R'
          je readraw
          cmp al, 'r'
          je readraw
          cmp al, 'C'
          je cdromread
          cmp al, 'c'
          je cdromread
          cmp al, ESCAPE_KEY
          jne getrc
          mov byte ptr [status], ERROR
          jmp secterrhandle
          readraw:
          mov byte ptr [cdheader+24], 1            ; raw
          mov word ptr [bps], 2352
         mov byte ptr [rwfunction], CDRAW
       cdromread:

        mov eax, dword ptr [sector]
        add eax, 10h
        mov byte ptr [cdheader+2], 128          ; read long
        cmp byte ptr [rw], READ
        je docdread
        mov byte ptr [cdheader+2], 134          ; write long
        docdread:
        mov dword ptr [cdheader+20], eax
        push cs
        pop es
        mov bx, offset cdheader
        xor ch, ch
        mov cl, byte ptr [drive]
        mov ax, 1510h                     ; cd-rom send device driver request
        int 2Fh
        jc sectorerror
        mov ah, byte ptr [cdheader+4]
        test ah, 10000000b
        jz nosectorerror

   ;-------------

       sectorerror:
       mov dx, offset sectorrerror
       cmp byte ptr [rw], WRITE
       jne werror
         mov dx, offset sectorwerror
       werror:

       cmp byte ptr [handling], IGNORE_ERRORS
       je nosectorerror
       cmp byte ptr [handling], ABORT_OPERATION
       je sectorerror2
        mov bx, word ptr [lastbottomtext]
           call printbottom
             mov dx, offset sectorrerror3
           cmp byte ptr [handling], QUERY_SKIP
           je printabortskip
             mov dx, offset sectorrerror2
           printabortskip:
           call printstring
           gak:
           call cursorgetkey
           cmp al, ESCAPE_KEY
           je itsA
           cmp ah, LETTER_A
           je itsA
           cmp byte ptr [handling], QUERY_SKIP
           je checkskip
             cmp ah, LETTER_Z
             je itsZ
           jmp gak
           checkskip:
             cmp ah, LETTER_S
             je itsS
             cmp ah, LETTER_I
             je itsI
           jmp gak
        itsZ:
        push cs
        pop es
        mov di, offset readbuffer
        xor al, al
        mov cx, 2352
        rep stosb
        itsS:
          mov dx, bx
          call printbottom
        jmp nosectorerror
        itsI:
          mov byte ptr [handling], IGNORE_ERRORS
        jmp itsS
        sectorerror2:
          call printerror
        itsA:
        mov byte ptr [status], ERROR
    secterrhandle:
       mov al, byte ptr [oldfunction]
       mov byte ptr [rwfunction], al
       mov al, byte ptr [olddrive]
       mov byte ptr [drive], al
       mov ax, word ptr [oldbps]
       mov word ptr [bps], ax


    jmp nosectorerror

   ;-------------

   hdread:
     mov si, offset diskbuffer
     mov byte ptr [si], 10h
     mov word ptr [si+2], 1
     mov word ptr [si+6], ds
     mov eax, dword ptr [sector]
     mov dword ptr [si+8], eax
     mov eax, dword ptr [sector2]
     mov dword ptr [si+0ch], eax
     mov dl, byte ptr [drive]

     cmp byte ptr [rw], WRITE
     je int13write

       mov ah, 42h

     jmp exint13
     int13write:

       mov ax, 4300h

     exint13:

     int 13h
     jc tryoldint13                ; try older int13h functions (ah=02h)
   jmp nosectorerror

   ;-------------

   tryoldint13:
   mov byte ptr [rwfunction], OLDINT13

   call getchs

   mov dl, byte ptr [drive]
   mov ax, 0201h
   cmp byte ptr [rw], READ
   je old13hread
     inc ah
   old13hread:
   mov bx, offset readbuffer
   int 13h

   jc sectorerror
   jmp nosectorerror

   oldread2:
   mov byte ptr [rwfunction], OLDINT25
   dec byte ptr [drive]
   oldread3:
   mov al, byte ptr [drive]

   cmp byte ptr [rw], WRITE
   je dooldwrite

     int 25h
     pop ax                             ; pop original flags left on stack
     jc trycdrom
     jmp nosectorerror

   dooldwrite:

     int 26h
     pop ax                             ; pop original flags left on stack
     jc trycdrom

   nosectorerror:

   mov byte ptr [rw], READ
   popad
   pop dword ptr [sector]
   ret
;-------------------------------------------------------
printerror:
   call printbottom
   mov dx, offset errormsg
   call printstring
   call getkey

   mov byte ptr [status], ERROR
   ret
;-------------------------------------------------------
printbottom:
   mov word ptr [xy], 2a01h
   mov word ptr [lastbottomtext], dx
   call printstring
   call setxy
   jmp clearbottom
;-------------------------------------------------------
setcdvar:
  mov bx, 50h
  cmp byte ptr [rwfunction], CDCOOKED
  je norawadjust
    add bx, 18h
  norawadjust:
  mov eax, dword ptr [readbuffer+bx]
  sub eax, 11h
  mov dword ptr [dataend], eax

  ret
;-------------------------------------------------------
setvariables:
   cmp byte ptr [drivetype], CDROM
   je setcdvar

   cmp byte ptr [drivetype], PHYSICAL
   jne logicalsetvars

     push cs                            ; sets variables p1-p4
     pop es                             ; for jumping to partitions
     mov di, offset p1                  ; on physical drives
     mov si, offset readbuffer + 1c6h
     mov cx, 4
     partition_data_fill:
     movsd
     add si, 0Ch
     loop partition_data_fill

   cmp byte ptr [rwfunction], FILEFUNC
   je setffparam

     mov ah, 08h
     push 0000h                                 ; damn bios bug
     pop es                                     ; circumvention
     xor di, di
     mov dl, byte ptr [drive]
     int 13h
     inc dh
     mov byte ptr [heads], dh
     mov byte ptr [sectors], cl
     and byte ptr [sectors], 00111111b
     mov byte ptr [cylinders], cl
     shl word ptr [cylinders], 2
     mov byte ptr [cylinders], ch

     xor eax, eax                       ; CHS -> LBA
     xor ebx, ebx
     mov ax, word ptr [cylinders]
     mov bl, dh
     mul ebx
     add eax, ebx
     mov bl, byte ptr [sectors]
     mul ebx
     dec eax
     sub eax, dword ptr [drivestart]
     mov dword ptr [dataend], eax

   cmp byte ptr [rwfunction], NEWINT13
   jne donesetphysvars

     mov word ptr [diskbuffer], 1ah
     mov dl, byte ptr [drive]
     mov si, offset diskbuffer
     mov ah, 48h                        ; get drive parameters

     int 13h                            ; call bios code

     mov eax, dword ptr [diskbuffer+10h]
     dec eax                                    ; remove for HUGE hd support
     sub eax, dword ptr [drivestart]
     mov dword ptr [dataend], eax

;     mov eax, dword ptr [diskbuffer+14h]
;     mov dword ptr [dataend2], eax             ; uncomment for (some) support
;     dec dword ptr [dataend]                   ; for HDs that are HUGE
;     sbb dword ptr [dataend2], 0               ; this should never be required
;                                               ; as it goes beyond 2tb
   donesetphysvars:
   ret
   logicalsetvars:
    push cs
    pop es
    mov si, offset readbuffer+0Dh
    mov di, offset spc
    movsb                                       ; sectors per cluster
    movsw                                       ; reserved
    movsb                                       ; fat copies
    movsw                                       ; root entries

    xor eax, eax
    mov dword ptr [rootc], eax
    mov ax, word ptr [readbuffer+16h]           ; sectors per fat
    mov word ptr [spf], ax
    mov al, byte ptr [readbuffer+40h]
    mov byte ptr [hdnumber], al

    lodsw                                       ; sectors in partition
    test ax, ax
    jnz lessthan32mb
      mov eax, dword ptr [readbuffer+20h]
    lessthan32mb:
      dec eax
      mov dword ptr [dataend], eax
      sub eax, dword ptr [spf]
      cmp byte ptr [fats], 2
      je skipsub2
        sub eax, dword ptr [spf]
      skipsub2:
      xor ecx, ecx
      mov cx, word ptr [reserved]
      sub eax, ecx

      xor edx, edx                      ; calculates total clusters from
      xor cx, cx                        ; sectors in partition.
      cmp byte ptr [spc], 0
      je spc0dontdiv
      mov cl, byte ptr [spc]            ; if total clusters < 4085
      div ecx                           ; then it's a fat12 drive, otherwise
      spc0dontdiv:
      mov byte ptr [fattype], FAT32
      cmp eax, 65525
      jae goodnumcluster                ; jump if not fat16 or less
      mov byte ptr [fattype], FAT16
      cmp eax, 4085
      jae goodnumcluster                ; jump if not fat12
        mov byte ptr [fattype], FAT12
      goodnumcluster:

    cmp byte ptr [fattype], FAT32
    jne notfat32
      mov ax, word ptr [readbuffer+32h]
      mov word ptr [backupbs], ax
      mov ax, word ptr [readbuffer+30h]
      mov word ptr [fsinfo], ax
      mov eax, dword ptr [readbuffer+44]
      mov dword ptr [rootc], eax
      mov eax, dword ptr [readbuffer+36]
      mov dword ptr [spf], eax
      mov byte ptr [fattype], FAT32
    notfat32:

    xor ah, ah
    mov al, byte ptr [spc]
    mov word ptr [rootsectors], ax

    mov eax, dword ptr [spf]
    xor ebx, ebx
    mov bl, byte ptr [fats]
    mul ebx
    mov bx, word ptr [reserved]
    add eax, ebx                       ; spf * fats + reserved = root
    mov dword ptr [root], eax

    cmp byte ptr [fattype], FAT32
    jne not_fat32_1
      push eax
      mov al, byte ptr [readbuffer+40h]  ; hard drive number
      mov byte ptr [hdnumber], al
      mov eax, dword ptr [rootc]
      sub eax, 2
      jc wrongrootc
      xor bx, bx
      mov bl, byte ptr [spc]
      mul ebx
      add dword ptr [root], eax
      wrongrootc:
      pop eax
      jmp isfat32
    not_fat32_1:

    mov al, byte ptr [readbuffer+24h]  ; hard drive number
    mov byte ptr [hdnumber], al
    xor eax, eax
    mov ax, word ptr [rootentries]     ; calculates number of root sectors
    shr ax, 4                          ; 16 entries in one sector
    mov word ptr [rootsectors], ax     ; # of entries/16 = # of sectors
    
    add eax, dword ptr [root]          ; calculate start of data area

   isfat32:

   cmp eax, dword ptr [root]
   jne datastartiscorrect
    xor bx, bx
    mov bl, byte ptr [spc]
    add eax, ebx
   datastartiscorrect:
    mov dword ptr [datastart], eax

    mov bx, word ptr [reserved]
    add ebx, dword ptr [spf]
    mov dword ptr [fatend], ebx                  ; calculate end of fat area


    test byte ptr [rwfunction], LRW
    jnz donegetvars
    ; unlock partition
    mov ax, 440Dh
    mov bl, byte ptr [drive]
    cmp byte ptr [rwfunction], OLDINT25
    jne dontincbl
      inc bl
    dontincbl:
    mov cx, 086Ah
    cmp byte ptr [fattype], FAT32
    jne fat1xlock
      mov ch, 48h
    fat1xlock:

    mov ax, 440Dh       ; lock the drive for windows
    mov dx, 1
    mov bh, 1
    sub cl, 20h
    int 21h

    mov bh, 04h         ; locks the drive for real dos
    mov ax, 440Dh       ; i don't quite understand why i must lock it twice
    int 21h             ; some sort of OS bug i guess
   donegetvars:
   ret
   setffparam:
     mov eax, dword ptr [rwfilesize]
     shr eax, 9                         ; \Fix/ ?
     jz donesetff
     dec eax
     donesetff:
     mov dword ptr [dataend], eax
   ret
;-------------------------------------------------------
printoffset:
   mov word ptr [xy], 9
   xor eax, eax
   call spotinbx
   mov ax, bx

   call printhex
   mov dx, offset valuebuffer+5
   call printstring

   call printentry

   mov ax, word ptr [cxy]
   mov word ptr [xy], ax
   jmp colorchar
;-------------------------------------------------------
printentry:                             ; prints the fat entry the cursor
    cmp byte ptr [fattype], UNDEFINED   ; is currently in, in the top
    je abortentry                       ; right of the screen
    mov eax, dword ptr [sector]
    xor edx, edx
    mov dx, word ptr [reserved]
    cmp eax, edx
    jb abortentry
    cmp eax, dword ptr [root]
    jae abortentry
    cmp eax, dword ptr [datastart]
    jae abortentry

        call calcentry

        call printhex

        mov byte ptr [xy], 34h
        mov dx, offset valuebuffer
        call printstring

    abortentry:
    ret
;-------------------------------------------------------
calcentry:                              ; IN: nothing
      xor ebx, ebx                      ; OUT: eax = current cluster #
      mov bx, word ptr [reserved]

      mov eax, dword ptr [sector]
      sub eax, ebx

      mov byte ptr [fromfat], 1
      cmp eax, dword ptr [spf]
      jb getfromfirstfat
        sub eax, dword ptr [spf]
        inc byte ptr [fromfat]
      getfromfirstfat:
      mov cx, word ptr [bps]
      shr cx, 9
      add cl, 8

      shl eax, cl
      mov bx, word ptr [spot]
      add eax, ebx

      mov cl, byte ptr [fattype]
      shr cl, 1
      shr eax, cl
      cmp cl, 0
      jne dlfe13
        xor edx, edx
        shl eax, 1
        mov bx, 3
        div ebx
      dlfe13:
      ret
;-----------------------------------------------------------
openfile:
;  mov ax, 6c00h
;  mov bx, 2002h
;  cmp byte ptr [fattype], FAT32
;  jne not4gblimit
;    or bh, 10000b
;  not4gblimit:
;  mov dx, 1
;  mov si, offset filename
;  xor cx, cx
;  int 21h

  mov ax, 3d02h
  mov dx, offset filename
  xor cx, cx
  int 21h

  mov word ptr [filehandle], ax
  ret
;-------------------------------------------------------
readfile:                       ; IN: eax start sector
                                ;     d:[value] # of sectors to write
  mov dx, offset readingmsg     ; OUT: sectors written to disk from file
  call printbottom

  pushad
  call getfilesize
    mov eax, dword ptr [value]
    xor edx, edx
    mov dx, word ptr [bps]
    mul edx
    cmp dword ptr [filesize], eax
  popad

  jae filebigenough

    mov dx, offset toosmall
    call printerror
    jmp doretfromfr

  filebigenough:

  mov byte ptr [handling], QUERY_SKIP
  push dword ptr [sector]
  mov dword ptr [sector], eax
  call openfile

  readfileloop:

  mov ah, 3fh                           ; read 512 bytes of the file
  mov bx, word ptr [filehandle]         ; directly into the write buffer
  mov cx, word ptr [bps]                ; bad idea?
  mov dx, offset writebuffer
  int 21h

  jnc noreaderror
                                                                           
    mov dx, offset errorread
    call printerror
    jmp donefileread

  noreaderror:

  call checkabort
  jne keepreadingfile
    mov dx, offset abortdmsg
    call printerror
    jmp donefileread
  keepreadingfile:

  mov byte ptr [rw], WRITE
  call rwsect

  cmp byte ptr [status], ERROR
  je donefileread

  inc dword ptr [sector]
  call printcounts

  dec dword ptr [value]
  jnz readfileloop

  donefileread:
  call closefile
  mov byte ptr [handling], ABORT_OPERATION
  pop dword ptr [sector]
  push word ptr [status]
  call rwsect
  pop word ptr [status]
  call updatescreen
  cmp byte ptr [status], ERROR
  je doretfromfr
    mov dx, offset donermsg
    call printerror
  doretfromfr:
  ret
;-------------------------------------------------------
getfilesize:
  mov ah, 2fh                           ; gets the current dta
  int 21h
  mov eax, dword ptr es:[bx+1Ah]
  mov dword ptr [filesize], eax
  ret
;-------------------------------------------------------
clearbottom:
  pusha
  mov cl, 4fh
  sub cl, byte ptr [xy]
  inc cl
  mov al, SPACE
  call printchar2
  popa
  ret
;-------------------------------------------------------
findfile:
  pusha
  mov byte ptr [status], SUCCESS
  mov ax, 4e00h
  mov cx, 47h
  mov dx, offset filename
  int 21h
  jnc filefound

  mov dx, offset filenotfound
  call printerror
  stc

  filefound:
  popa
  ret
;-------------------------------------------------------
dumpiso:
  call getfilename
  cmp cx, 68
  je savefileoptions
;  mov byte ptr [fileflag], UNDEFINED
  call createfile
  cmp byte ptr [status], ERROR
  je savefileoptions
  cmp byte ptr [drivetype], CDROM
  jne drivedump

  push cs
  pop es
  mov di, offset readbuffer
  mov cx, word ptr [bps]
  mov al, 0
  rep stosb

  mov cx, word ptr [bps]
  mov dx, offset readbuffer
  mov bx, word ptr [filehandle]
  mov si, 10h
  isoloop:
  mov ah, 40h                           ; write 10 blank sectors
  int 21h                               ; to the beginning of the iso
  jnc noisoerror                        ; since we can't read the first 10
                                        ; sectors on a CD
    mov dx, offset filewerror
    call printerror
  jmp savefileoptions

  noisoerror:

  dec si
  jnz isoloop

  drivedump:

;  push dword ptr [sector]
  xor eax, eax
;  mov dword ptr [sector], eax
;  call rwsect
  mov edx, dword ptr [dataend]
  inc edx
  mov dword ptr [value], edx
  call writefile
;  pop dword ptr [sector]
  cmp byte ptr [status], ERROR
  pushf
  call rwsect

  call closefile
  call updatescreen
  popf
  je savefileoptions

   mov dx, offset donemsg
   call printerror

  jmp savefileoptions
;-------------------------------------------------------
savefile:
  call getfilename
  cmp cx, 68
  je savefileoptions

  mov eax, dword ptr [dataend]
  mov ebx, dword ptr [sector]
  sub eax, ebx
  inc eax
  mov dword ptr [maxvalue], eax
  mov dx, offset sectorsmsg
  call inputvalue

  cmp byte ptr [status], ERROR
  je savefileoptions

  cmp dword ptr [value], 0
  je savefileoptions

  mov eax, dword ptr [sector]
  jmp endsavedrive
;-------------------------------------------------------
closefile:
  mov ah, 3eh
  mov bx, word ptr [filehandle]
  int 21h
  ret
;-------------------------------------------------------
writefile:                      ; in: dword [value] = number of sectors
  push dword ptr [sector]       ;                     to save
  mov dword ptr [sector], eax   ;     eax           = start sector
   mov dx, offset writingmsg 
   call printbottom          
   writefileloop:

  call checkabort
  jne keepwritingfile

     mov dx, offset abortfmsg
     call printerror
     jmp errorwritefile

  keepwritingfile:

   call printcounts
   mov byte ptr [handling], QUERY_FILL
   call rwsect
   mov byte ptr [handling], ABORT_OPERATION
   cmp byte ptr [status], ERROR
   je errorwritefile

   mov cx, word ptr [bps]       ; bytes to write
   mov byte ptr [status], SUCCESS
   mov bx, word ptr [filehandle]
   mov dx, offset readbuffer
   mov ah, 40h                 ; write to file
   int 21h
   jnc donewritefile

     mov dx, offset filewerror
     call printerror
     jmp errorwritefile

   donewritefile:

   inc dword ptr [sector]
   dec dword ptr [value]
   jnz writefileloop
   errorwritefile:
   pop dword ptr [sector]

   push word ptr [status]
   call rwsect
   pop word ptr [status]
   ret
;-------------------------------------------------------
createfile:
  mov byte ptr [status], SUCCESS
  xor cx, cx
  mov ax, 4e00h
  mov dx, offset filename
  int 21h
  jnc fileexists

  ccreatefile:
;  mov byte ptr [fileflag], 1
;  mov ax, 6c00h
;  mov bx, 3002h
;  mov dx, 10010b
;  mov si, offset filename

;  xor cx, cx
;  int 21h
;  jnc noerrorcreating
;    mov ax, 6c00h
;    and bh, 11101111b
;    mov byte ptr [fileflag], 0
;    int 21h
;    jc createerror
;  noerrorcreating:

  mov ax, 3c00h
  xor cx, cx
  mov dx, offset filename
  int 21h

  jc createerror
  mov word ptr [filehandle], ax
  ret
  createerror:
  mov dx, offset fileerror
  jmp printerror

  fileexists:
  mov dx, offset owmsg
  call printbottom

  getaoc:
    call cursorgetkey
    cmp al, ESCAPE_KEY
    je doabortf
    cmp ah, LETTER_C
    je doabortf
    cmp ah, LETTER_A
    je doappend
    cmp ah, LETTER_O
    je ccreatefile
    jmp getaoc
  doappend:
  call openfile
   mov bx, ax     ; seek file (end)
   xor dx, dx
   xor cx, cx
   mov ax, 4202h
  int 21h
  ret
  doabortf:
  mov dx, offset abortfmsg
  jmp printerror
;-------------------------------------------------------
  toobig:
;    mov bx, offset filetoobig
;    mov al, byte ptr [fileflag]
;    mov byte ptr [bx+24], al
;    mov dx, bx
  mov dx, offset filetoobig
  jmp printerror
;-------------------------------------------------------
; IN:  nothing
; OUT: "view" area is wiped
clearview:
  pusha
  push 0b800h
  pop es
  mov di, 1541h
  mov ah, SPACE
  mov al, DEFAULTCOLOR
  mov cx, 559
  rep stosw
  popa
  ret
;-------------------------------------------------------
; IN:  nothing
; OUT: variables are wiped
wipemem:
   mov al, 0
   mov di, offset rw            ; wipe mem
   push cs
   pop es
   mov cx, offset dirarray-offset rw
   rep stosb
   ret
;-------------------------------------------------------
cleardisplay:
    push 0b800h                   ; clear the screen
    pop es
    mov di, 178
    mov ah, DEFAULTCOLOR
    xor al, al
    mov dl, 32
    continuewipescreen:
    mov cx, 52
      wipescreenloop:
      stosw
      loop wipescreenloop
    add di, 56
    dec dl
    jnz continuewipescreen
    ret
;-------------------------------------------------------
; IN:  nothing
; OUT: seed1-4 variables are filled with the time
seed:
 mov ah, 00h
 int 01ah

 mov ax, dx
 mov bx, cx

 mov word ptr [seed1], ax

 xchg al, ah
 sbb ah, al
 adc ax, ax
 ror bx, cl

 mov word ptr [seed2], ax

 ror ax, cl

 mov word ptr [seed3], ax

 mov cx, ds

 adc cx, bx
 adc ax, bx
 xchg ah, bl
 xchg al, ah
 adc al, ah

 mov word ptr [seed4], ax
 ret
;-----------------------------------------------------------------
rand:
  mov ax, word ptr [seed1]
  mov bx, word ptr [seed2]
  mov cx, word ptr [seed3]
  mov dx, word ptr [seed4]

  add ax, bx
  xchg cl, ch
  sbb dx, ax

  adc cl, al
  adc ah, bl
  adc ax, dx

  ror dx, cl
  rol ax, cl
  adc ax, cx

  xchg dl, ch
  xchg dx, bx
  xchg ch, al
  xchg bl, dh

  sbb ax, cx
  adc ax, bx

  mov word ptr [seed1], ax
  mov word ptr [seed2], bx
  mov word ptr [seed3], cx
  mov word ptr [seed4], dx
  ret
;-----------------------------------------------------------------
;
; Returns the hex value obtained from the user.
;
; IN:           Valuebuffer[0] 0: String (return in stringbuffer)
;                              1: Dword  (return in ebx)
;               EAX:           maxvalue (for valuebuffer=1 only)
;
; OUT:          Valuebuffer[1] X-coord starting byte
;
gethex:
  mov dword ptr [valuebuffer+2], eax
  call printbottom
  mov dl, byte ptr [xy]
  mov byte ptr [valuebuffer+1], dl
  xor eax, eax
  xor ebx, ebx
  xor si, si
  getkeyagain10:
    call cursorgetkey
    cmp al, BACKSPACE_KEY
    je backhex
    cmp al, ENTER_KEY
    je donegethex
    cmp al, ESCAPE_KEY
    je abortgetkey10

  cmp byte ptr [xy], 79
  je getkeyagain10

  cmp byte ptr [valuebuffer], 0
  je notestnec
  mov dl, byte ptr [xy]
  cmp byte ptr [valuebuffer+1], dl
  jne notestnec
    cmp al, '0'
    je getkeyagain10
  notestnec:

  mov dl, al

  cmp al, '0'
  jb getkeyagain10

  cmp al, '9'
  jbe numhex

  cmp al, 'A'
  jb getkeyagain10

  cmp al, 'F'
  jbe lethex

  sub dl, 32

  cmp al, 'a'
  jb getkeyagain10

  cmp al, 'f'
  jbe lethex

    jmp getkeyagain10
  donegethex:
    cmp byte ptr [valuebuffer], 0
    je stringchecks
      ret
    stringchecks:
    cmp bl, 0
    je noadjust
;      mov bx, offset stringbuffer      ; AAB -> AAB0
;      add bx, si                       ; instead of
;      mov cx, si                       ; AAB -> 0AAB
;      shr word ptr [bx], 4
      inc si
    noadjust:
    mov bx, si
    mov word ptr [stringbuffer+74], bx
  ret
    abortgetkey10:
    mov al, 0
  ret
;-----------------------------------------------------------------
backhex:
  mov dl, byte ptr [xy]
  cmp byte ptr [valuebuffer+1], dl
  je getkeyagain10
  dec byte ptr [xy]
  mov dl, SPACE
  call printchar
  dec byte ptr [xy]
  call setxy
  cmp byte ptr [valuebuffer], 0
  je backstring
  shr ebx, 4
  jmp getkeyagain10
  backstring:
  cmp bl, 0
  je loworder2
    mov bl, 0
  jmp getkeyagain10
  loworder2:
    dec si
    and byte ptr [stringbuffer+si], 0F0h
    mov bl, 1
  jmp getkeyagain10
;-----------------------------------------------------------------
lethex:
  add al, 9

numhex:
  and ax, 0Fh
  cmp byte ptr [valuebuffer], 0
  je stringhex

  test ebx, 0F0000000h
  jnz getkeyagain10
  shl ebx, 4
  or ebx, eax

  cmp ebx, dword ptr [valuebuffer+2]
  jbe hexok
  shr ebx, 4
  jmp getkeyagain10
  hexok:

  call printchar
  call setxy

  jmp getkeyagain10

stringhex:
  cmp bl, 1
  je loworder
    shl al, 4
    mov byte ptr [stringbuffer+si], al
    mov bl, 1
  jmp hexok
  loworder:
    or byte ptr [stringbuffer+si], al
    xor bl, bl
    inc si
  jmp hexok
;-----------------------------------------------------------------
putfatentry:
; EBX = cluster number
; EAX = data to stick into entry
  push dword ptr [sector]
  push edx
  mov edx, ebx
  and eax, 0FFFFFFFh
  call locatefatentry
  mov si, offset readbuffer
  cmp byte ptr [fattype], FAT12
  jne dof132

  call ffat12fix
;  cmp bx, 511
;  jne nf12a                             ; this function assumes we want
;    inc dword ptr [sector]
;    xor bx, bx
;    mov si, offset fat12fix+4
;  nf12a:

    and ax, 0FFFh
    test edx, 1b
    jnz pmethod2
    pmethod1:
      mov dx, word ptr [si+bx]
      and dx, 0F000h
      or ax, dx
      mov word ptr [si+bx], ax
    jmp dpfe
    pmethod2:
      shl ax, 4
      mov dx, word ptr [si+bx]
      and dx, 0Fh
      or ax, dx
      mov word ptr [si+bx], ax
    jmp dpfe
  dof132:
  xor edx, edx
cmp byte ptr [fattype], FAT32
je fat32pfe
  mov word ptr [si+bx], ax
  jmp dpfe
fat32pfe:
  mov edx, dword ptr [si+bx]    ; preserve the highest nibble in fat32 fat
  and edx, 0F0000000h           ; tables as it is not part of the entry
  or eax, edx
  mov dword ptr [si+bx], eax
  dpfe:
  call copybuffer
  mov byte ptr [rw], WRITE
  call rwsect

  cmp bx, 511
  jne fat12fixdone
    inc dword ptr [sector]
    call rwsect
    mov al, byte ptr [si+bx+1]
    mov byte ptr [si], al
    xor bx, bx
    jmp dpfe
  fat12fixdone:
  pop edx
  pop dword ptr [sector]
  jmp rwsect
;-----------------------------------------------------------------
locatefatentry:                 ; IN:
  mov byte ptr [status], SUCCESS         ; EBX = cluster number
  push edx                      ; OUT:
  push eax                              ; [sector] to the entry's sector
  push ecx                              ; sets EBX to the # bytes to the entry
                                        ;    within the set sector
          

  mov cl, byte ptr [fattype]    ; convert cluster number to # of bytes
  shr cl, 1                     ; since the start of the fat table
  shl ebx, cl
  cmp cl, 0
  jne donelfe13
    mov eax, ebx        ; adjustment for fat12
    shr eax, 1
    add ebx, eax
  donelfe13:

                        ; ebx = # of bytes since fat start
  xor ecx, ecx
  mov cx, word ptr [bps]
  push cx
  shr cx, 9
  add cl, 8
                                ; divides ebx by bps in order to find what
  mov eax, ebx                  ; sector the fat entry is in
  shr eax, cl
  pop cx

  shr ch, 1
  or cx, 111111111b
  and ebx, ecx 

  mov cx, word ptr [reserved]
  add eax, ecx
  cmp byte ptr [fromfat], 1
  je locationinfirstfat
    add eax, dword ptr [spf]
  locationinfirstfat:

  cmp dword ptr [sector], eax   ; sets [sector] to that sector
  je nntri
  mov dword ptr [sector], eax
  call rwsect
  nntri:
                                ; returns [status] = ERROR if the sector is 
  add eax, dword ptr [spf]      ; outside the fat table we're working with
  cmp dword ptr [sector], eax
  jb fatsectok
    mov byte ptr [status], ERROR
  fatsectok:

  pop ecx
  pop eax
  pop edx
  ret
;-----------------------------------------------------------------
ffat12fix:                              ; IN: ebx = bytes to fat entry
  push edx                              ;     si = readbuffer pointer
  push bx                               ; OUT: bytes put around sector
  push word ptr [status]
  push word ptr [subsector]
  mov byte ptr [handling], IGNORE_ERRORS
  mov edx, dword ptr [sector]           ; did we call this function
  cmp dword ptr [fat12fix], edx         ; from the same sector?  then
  je nf12b2                             ; we already have the correct data
  mov dword ptr [fat12fix], edx         ; ...this would be a tiny bug if
                                        ; we switch drives on sector 0

  mov bx, word ptr [bps]
  test edx, edx                         ; if the current sector is 0
  jz donttrylastsect                    ; then we can't read the previous
  dec dword ptr [sector]
  call rwsect
  mov dl, byte ptr [si+bx-1]            ; copy last byte of previous sector
  mov byte ptr [fat12fix+4], dl
  inc dword ptr [sector]

  mov edx, dword ptr [sector]           ; similarly, we don't want to read
  cmp edx, dword ptr [dataend]          ; the next sector if it's past the
  jae nf12b                             ; end of the drive

  donttrylastsect:
  inc dword ptr [sector]                ; copy first byte of next sector
  call rwsect
  mov dl, byte ptr [si]
  mov byte ptr [si+bx], dl

  dec dword ptr [sector]
  nf12b:
  call rwsect
  nf12b2:
  mov byte ptr [handling], ABORT_OPERATION
  pop word ptr [subsector]
  pop word ptr [status]
  pop bx
  pop edx
  ret
;-----------------------------------------------------------------
getfatentry:                    ; IN EAX = cluster number to get
  push ebx                      ; OUT EAX = value gotten
  push dword ptr [sector]
  push si

  and eax, 0FFFFFFFh
  mov ebx, eax
  call locatefatentry
  mov si, offset readbuffer
  cmp byte ptr [fattype], FAT12
  jne dof13

  call ffat12fix

    test eax, 1b
    jnz method2
    method1:
      xor eax, eax
      mov ax, word ptr [si+bx]
      and ax, 0FFFh
    jmp f12gfs
    method2:
      xor eax, eax
      mov ax, word ptr [si+bx]
      shr ax, 4
  f12gfs:
      and ah, 0Fh
      cmp ax, 0FF0h
      jb f32gfd
      or eax, 0FFFF000h
      jmp f32gfd
  dof13:
  mov eax, dword ptr [si+bx]
  cmp byte ptr [fattype], FAT32
  je f32gfd
    and eax, 0FFFFh
    cmp ax, 0FFF0h
    jb f32gfd
    or eax, 0FFF0000h
  f32gfd:
  and eax, 0FFFFFFFh
  pop si
  pop ebx
  cmp dword ptr [sector], ebx
  je oefgf
  mov dword ptr [sector], ebx
;  push word ptr [status]
  cmp byte ptr [status], ERROR
  je oefgf
  call rwsect
;  pop word ptr [status]
  oefgf:
  pop ebx
  ret
;-----------------------------------------------------------------

ifdef DEBUG

debugviewmode:
  push edx

  mov word ptr [xy], 2201h
  mov dx, offset eaxmsg
  call printstring
  call printregister

  mov word ptr [xy], 2301h
  mov dx, offset ebxmsg
  call printstring
  mov eax, ebx
  call printregister

  mov word ptr [xy], 2401h
  mov dx, offset ecxmsg
  call printstring
  mov eax, ecx
  call printregister

  mov word ptr [xy], 2501h
  mov dx, offset edxmsg
  call printstring
  pop eax
  call printregister


  mov word ptr [xy], 2222h
  mov dx, offset storedeaxmsg
  call printstring
  mov eax, dword ptr [storedeax]
  call printregister

  mov word ptr [xy], 2322h
  mov dx, offset storedebxmsg
  call printstring
  mov eax, dword ptr [storedebx]
  call printregister

  mov word ptr [xy], 2422h
  mov dx, offset storedecxmsg
  call printstring
  mov eax, dword ptr [storedecx]
  call printregister

  mov word ptr [xy], 2522h
  mov dx, offset storededxmsg
  call printstring
  mov eax, dword ptr [storededx]
  call printregister

  ret


printregister:
  call printcount
  mov dx, offset valuebuffer
  call printstring
  mov dl, SPACE
  call printchar
  mov dl, '('
  call printchar
  call printhex
  mov dx, offset valuebuffer
  call printstring
  mov dl, ')'
  call printchar
  ret


storedebugdata:
  mov dword ptr [storedeax], eax
  mov dword ptr [storedebx], ebx
  mov dword ptr [storedecx], ecx
  mov dword ptr [storededx], edx
  ret


endif

;-------------------------------------------------------
  int24h:        ; this is the new int 24h to catch any critical errors
    iret         ; that would otherwise crash WDe (Abort/Retry/Fail)
;-----------------------------------------------------------------
introtext       db 'WDe V0.21b (FreeDOS Edition)',00h
copyright       db 'Copyright(C)2004 Ben Cadieux',00h
quitmsg         db 'Quit',00h
truncatemsg     db 'Truncate To Filesize',00h
owmsg           db 'File Exists - Append/Overwrite/Cancel [A/O/C]? ',00h
fhdmsg          db 'Floppy/Hard Disk [F/H]? ',00h
cdrcmsg         db 'Raw/Cooked Mode [R/C]? ',00h
plmsg           db 'Physical/Fat [P/F]? ',00h
abmsg           db 'Above/Below [A/B]? ',00h
ynmsg           db ' [Y/N]? ',00h

unknownmsg      db 'Unknown',00h
active          db 'Active',00h
part00          db 'Unused',00h
part01          db 'Fat12',00h
part04060E      db 'Fat16',00h
part0B0C        db 'Fat32',00h
part050F        db 'Ext Fat',00h
parthid         db 'Hid Fat',00h ;11,14,16,1B,1C,1E,8D,90,91,92,97,98,9A,9B

menu            db 'F1-Save   F2-File Ops   F3-Goto   F4-View   F5-Find   F6-Functions   F7-Disk',00h
jumpmenu        db 'F1-Sector  F2-Cluster  F3-Boot Sector  F4-Fat1  F5-Fat2  F6-Root  F7-Data Area',00h
cdjumpmenu      db 'F1-Sector',00h
filemenu        db 'F1-Save Sectors To File   F2-Restore Sectors From File',00h
filemenu2       db 'F1-Input',00h
pdfilemenu      db 'F2-MBR  F3-Partition1  F4-Partition2  F5-Partition3  F6-Partition4',00h
ldfilemenu      db 'F2-Boot Sector  F3-Fat1  F4-Fat2  F5-Root  F6-Entire Drive',00h
chainmenu       db 'F7-Chain',00h
cdfilemenu      db 'F1-Save Sectors To File   F2-Dump CD As ISO',00h
viewmenu        db 'F1-Default  F2-MBR  F3-Boot Sector  F4-Fat12  F5-Fat16  F6-Fat32  F7-Directory',00h
searchmenu      db 'F1-String   F2-Hex   F3-MBR   F4-Boot Sector   F5-Fat   F6-Directory',00h
funcmenu        db 'F1-Fill   F2-Restrict',00h

ifdef DEBUG
  unformenu       db 'F3-UnFormat',00h
  undelmenu       db 'F4-UnDelete',00h
  else
  undelmenu       db 'F3-UnDelete',00h
endif

fillmenu        db 'F1-Hex   F2-String   F3-Incremental   F4-Decremental   F5-Inverse   F6-Random',00h
idmenu          db 'F1-8Bit   F2-12Bit   F3-16Bit   F4-32Bit',00h

mbps            db 'Bytes Per Sector',00h
mspc            db 'Sectors Per Cluster',00h
mreserved       db 'Reserved Sectors',00h
mfats           db 'Number Of Fats',00h
mrootentries    db 'Maximum Root Entries',00h      ; FAT1x only
msip            db 'Sectors In Partition',00h      ; bootsector & mbr
mspf            db 'Sectors Per Fat',00h
mhs             db 'Partition Start',00h
mrootc          db 'Root Start Cluster',00h        ; FAT32 only
mfsis           db 'FSInfo Sector Number',00h      ; FAT32 only
mbackup         db 'Backup B.S. Location',00h
mldn            db 'Hard Disk Number',00h
mdb             db 'Media Descriptor',00h

fcs             db 'Total Free Clusters: ',00h
sfc             db 'First Free Cluster:  ',00h

mfixed          db ' (HD)',00h
mremovable      db ' (FD)',00h

partition       db 'Partition ',00h
startchs        db 'S-CHS',00h
endchs          db 'E-CHS',00h
startlba        db 'S-LBA',00h
mboot           db 'Boot  ',00h
mtype           db 'Type  ',00h
psize           db 'Sects ',00h

searchingmsg    db 'Searching...',00h
undeletingmsg   db 'UnDeleting...',00h
writingmsg      db 'Writing File...',00h
readingdrive    db 'Reading Drive...',00h
readingmsg      db 'Writing To Disk...',00h
recursemsg      db 'Recursing Chain...',00h

ifdef DEBUG
  scanningfatmsg  db 'Scanning Fat...',00h
  ffilesmsg       db 'Recovering Files...',00h
  fdirsmsg        db 'Recovering Directories...',00h
  doneufmsg       db 'Finished UnFormatting Drive',00h
  dnfmsg          db 'Fat Table Not Blank',00h
endif

stringerror     db 'No Matches Found',00h
donemsg         db 'Finished Writing File',00h
fileexceeded    db 'File Chain Exceeds FAT',00h
abortdmsg       db 'Aborted Writing to Disk',00h
donermsg        db 'Finished Writing to Disk',00h
doneudmsg       db 'Finished UnDeleting File',00h
filetoobig      db 'File Size Cannot Exceed 2GB',00h
abortfmsg       db 'Aborted Writing File',00h

toosmall        db 'File Too Small',00h
filenotfound    db 'File Not Found',00h
nofirstcluster  db 'File Too Corrupt',00h

errorread       db 'Error Reading File',00h
filewerror      db 'Error Writing File',00h
fileerror       db 'Error Creating File',00h

sectorrerror    db 'Error Reading Sector',00h
sectorrerror2   db ' - Abort/Zero-Fill [A/Z]? ',00h
sectorrerror3   db ' - Abort/Skip/Ignore All [A/S/I]? ',00h
;sectorrerror    db 'Error Reading Sector',00h
sectorwerror    db 'Error Writing Sector',00h
greatmsg        db 'Invalid Start Cluster',00h
nochainmsg      db 'Recursive Link Not Found',00h
rnbmsg          db 'Root Not Blank',00h
nodirsmsg       db 'No Directories Found',00h
errormsg        db ' - Press Any Key',00h
inmbrmsg        db '[MBR]',00h
infatmsg        db '[Fat-',00h
inrootmsg       db '[Root]',00h
indatamsg       db '[Data]',00h
inreservedmsg   db '[Boot/Reserved]',00h
hexmsg          db 'Hex: ',00h
chsmsg          db 'CHS: ',00h
partmsg         db 'Part: ',00h
sizemsg         db 'Size: ',00h
entrymsg        db 'Entry:',00h
drivemsg        db 'Drive: ',00h
offsetmsg       db 'Offset: ',00h
stringmsg       db 'String: ',00h
sectormsg       db 'Sector: ',00h
createdmsg      db 'Created: ',00h
clustermsg      db 'Cluster: ',00h
accessedmsg     db 'Accessed: ',00h
modifiedmsg     db 'Modified: ',00h
filenamemsg     db 'Filename: ',00h
attributesmsg   db 'Attributes: ',00h
sectorsmsg      db 'Number Of Sectors: ',00h
firstcharmsg    db 'New First Character: ',00h
hexstr          db '0123456789ABCDEF'

ifdef DEBUG
  eaxmsg        db 'EAX: ',00h
  ebxmsg        db 'EBX: ',00h
  ecxmsg        db 'ECX: ',00h
  edxmsg        db 'EDX: ',00h
  storedeaxmsg  db 'Stored EAX: ',00h
  storedebxmsg  db 'Stored EBX: ',00h
  storedecxmsg  db 'Stored ECX: ',00h
  storededxmsg  db 'Stored EDX: ',00h
  storedeax     dd ?
  storedebx     dd ?
  storedecx     dd ?
  storededx     dd ?
endif




old24h          dd ?

; drivepacket is for use with int 25h/26h and int 21h/ax=7305h
drivepacket1    dd ? ; sector number to start reading at read
drivepacket2    dw ? ; number of sectors to read
drivepacket3    dw ? ; offset of sector memory
drivepacket4    dw ? ; segment of sector memory

cxy             dw ? ; cursor xy position
drive           db ? ; drive number
subsector       db ? ; because [spot] goes from 0-511, if we have sectors
                     ; that are >512 bytes, subsector keeps track of what
                     ; 512-byte peice we're working with

hl              db ? ; keeps track of whether we're editing high or low nibble
spot            dw ? ; keeps count of what byte we're editing 0-511
rw              db ? ; distinguish between read/write
fattype         db ? ; type of fat
spf             dd ? ; sectors per fat
fatend          dd ? ; end of fat
spc             db ? ; sectors per cluster
reserved        dw ? ; reserved sectors (start of fat)
fats            db ? ; number of fats
rootentries     dw ? ; number of root entries
hdnumber        db ? ; hard drive number partition belongs to
sector          dd ? ; sector for read/writes
sector2         dd ? ; for int13h
backupbs        dd ? ; backup boot sector location
rootsectors     dw ? ; number of root sectors
dataend         dd ? ; end of data
; dataend2        dd ? ; for int13h HUGE hds
datastart       dd ? ; start of data
root            dd ? ; root directory
rootc           dd ? ; root cluster
fsinfo          dw ? ; fsinfo sector
rwfunction      db ? ; what read/write function to use
drivetype       db ? ; logical/physical/etc
xy              dw ? ; xy position on screen
fromfat         db ? ; fat to use for getfatentry/putfatentry
region          db ? ; what part of the disk we're in
value           dd ?
maxvalue        dd ?
status          db ? ; error in called function?
maxleft         db ?
filesize        dd ?
lastbottomtext  dw ? ; printbottom backs up string pointer for rwsect
                     ; to reprint it when there's a sector error

; "viewmode" defines what the section at the bottom of the screen just above
; the menu is used to display (for additional information)
;          0: unset
;          1: bootsector
;          2: fat12
;          3: fat16
;          4: fat32
;          5: root
;          6: data (scan for directory)
;          7: mbr
;          9: fsinfo

; viewmode+1:            0 = dynamically choose view mode
;                        1 = force current view
viewmode        dw ?
displaymode     db ? ; hex or binary

highlight       dd ? ; area to highlight with viewmode

oldfunction     dw ? ; when changing drives to edit, we need to keep
olddrive        db ? ; track of these variables in case the drive can't
oldbps          dw ? ; be accessed (has to default to previous drive)

editmode        db ?
cluster         dd ?
ldcluster       dd ?
bpc             dd ?
bps             dw ?
spcc            db ? ; sectors per cluster counter
sbackup         dd ? ; sector backup
sbackup2        dd ? ; sector backup
handling        db ? ; how to handle errors:
                     ;  3: ignore errors
                     ;  2: query user with "skip"
                     ;  1: query user with "fill with zero"
                     ;  0: abort by default

seed1 dw ?
seed2 dw ?
seed3 dw ?
seed4 dw ?

p1 dd ?
p2 dd ?
p3 dd ?
p4 dd ?

filename        db 69 dup(?)
stringbuffer    db 76 dup(?)
diskbuffer      db 1Ah dup(?)       ; buffer for int13h "get drive info"
fat12fix        db 5 dup(?)         ; stores first borrowed byte for fat12
readbuffer      db 2352 dup(?)      ; read buffer for sector reading
fat12fix2       db ?                ; stores last borrowed byte for fat12/CD
writebuffer     db 2352 dup(?)      ; write buffer for sector writing
cdheader        db 27 dup(?)        ; cd device request header
cblock          db 5 dup(?)

drivestart      dd ?                ; used for sector restriction
fat12start      dd ?                ; stores the sector number when fat12
                                    ; view mode was selected
cylinders       dw ?
heads           db ?
sectors         db ?

valuebuffer     db 11 dup(?)
rembytes        dw ?                ; remaining bytes when dealing with
                                    ; non-standard sized sectors

rwhandle        dw ?            ; read/write file handle
rwfilesize      dd ?            ; read/write filesize
filehandle      dw ?
calladdress     dw ?
fillflag        dw ?
dirflag         db ?
driveflag       db ?            ; setdrive gets File or Drive? 0/1 respective
;fileflag        db ?           ; max file size flag 0=2GB 1=4GB
chainflag       db ?            ; dictates what type of chain to save
                                ; fat links/file

; unformat
rootdirs        dw ?            ; total root directories found
dirs            dw ?            ; total dirs found
files           dd ?            ; total files found
maxsize         dd ?            ; maximum filesize to recover
minsize         dd ?            ; smallest size bigger than nrsize found
                                ; this is used to figure out what the next
                                ; mrsize should be.
dirarray        db ?

WDE ends
END Start
