; Copyright (C) 2018 Jerome Shidel
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License along
;   with this program; if not, write to the Free Software Foundation, Inc.,
;   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

; NASM 2.14rc0 for DOS

; -----------------------------------------------------------------------------
; Primary Includes Section
; -----------------------------------------------------------------------------

; %warning BEGIN CODE_STAGE

; NASM CPU Instruction Extensions
%include "NASMEXT.INC"

%ifidn PLATFORM, FREEDOS
    ; DOS Specific OS Macros and Constants
    %include "DOSSYS.INC"
    %include "BIOS.INC"
%endif

%ifidn PLATFORM,  MACINTOSH
    ; macOS Specific OS Macros and Constants
    %include "MACSYS.INC"
%endif

%ifidn PLATFORM,  LINUX
    ; Linux Specific OS Macros and Constants
    %include "LINSYS.INC"
%endif

%ifidn PLATFORM,  WINDOWS
    ; Windows Specific OS Macros and Constants
    %include "WINSYS.INC"
%endif

; Generic AsciiZ String procedures
%include "STRINGS.INC"

; Generic Memory Management and Utilities
%include "MEMORY.INC"

; Generic Buffered File I/O
%include "FILEIO.INC"

; Generic Standard I/O
%include "STDIO.INC"

; Generic Command Line Parser
%include "CMDLINE.INC"

; Generic Program Macros
%include "GENERIC.INC"

; OS & System level bug workaround definitions
%include "BUGPATCH.INC"

