; Copyright (C) 2017 Jerome Shidel
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License along
;   with this program; if not, write to the Free Software Foundation, Inc.,
;   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

; NASM 2.14rc0 for DOS

; -----------------------------------------------------------------------------
; FORWARD
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_FORWARD

%imacro Option 0-3 end
    %ifidni %1, end
        dw 0
    %elifnum %1 = 0
        dw 0
    %else
        dw %1   ; Handler
        %ifnum %3 > 0
            db %2
            db %3 ; Option Param Count
        %else
            db %2
            db 0
        %endif
    %endif
%endmacro

%imacro ParseCommandLine 0-2
    %idefine Need_ParseCommandLine
    %if %0 = 0
        mpush           si, di
        OS_CommandLine
        mov             di, Options
        call            Func_ParseCommandLine
        mpop            si, di
    %elif %0 = 1
        push            di
        mov             di, Options
        %ifnidni %1, si
            push        si
        %endif
        %ifnidni %1, si
            mov         si, %1
        %endif
        call            Func_ParseCommandLine
        %ifnidni %1, si
            pop         si
        %endif
        pop             di
    %else
        %ifnidni %2, di
            push        di
        %endif
        %ifnidni %1, si
            push        si
        %endif
        %ifnidni %1, si
            mov         si, %1
        %endif
        %ifnidni %2, di
            mov         di, %2
        %endif
        call            Func_ParseCommandLine
        %ifnidni %1, si
            pop         si
        %endif
        %ifnidni %2, di
            pop        di
        %endif
    %endif
%endmacro

%imacro ParseCommandOptions 4
    %ifnidni %1, si
        push        si
        mov         si, %1
    %endif
    %ifnidni %2, di
        push        di
        mov         di, %2
    %endif
    push            bx
    mov             bl, %3
    mov             bh, %4
    call            Func_ParseCommandOptions
    pop             bx
    %ifnidni %2, di
        pop         di
    %endif
    %ifnidni %1, si
        pop        si
    %endif
%endmacro

%endif

; -----------------------------------------------------------------------------
; CODE - Forward macro support code
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_CODE

%ifdef Need_ParseCommandLine
Func_ParseCommandLine:
    OS_SwitchChar
    mov         bh, al
    mov         bl, 0x20
Func_ParseCommandOptions:
    mpush       ax, bx, cx, dx, si, di, bp
.Reset:
    xor         dh, dh
    xor         ah, ah
.Next:
    xor         cx, cx
    mov         bp, si
.Loopy:
    lodsb

    ; Command Line Terminators
    cmp         al, CR
    je          .DoneMaybe
    cmp         al, 0x00
    je          .DoneMaybe
    cmp         al, LF
    je          .DoneMaybe

    ; Quote Characters
    cmp         al, 0x22
    je          .Quote
    cmp         al, 0x27
    je          .Quote
    cmp         al, 0x60
    je          .Quote

    ; Parameter Separators
    cmp         al, 0x20
    je          .Spaced
    cmp         al, bl
    je          .Spaced

    cmp         al, bh
    je          .Switch

    inc         cx
    jmp         .Loopy

.Spaced:
    cmp         cx, 0
    jne         .UnQuoted
    jmp         .Next

.Switch:
    cmp         dh, 0
    retne
    lodsb
    mov         ah, al
    call        .FindSwitch
    jc          .ReturnError
    jmp         .Reset

.ReturnError:
    stc
    jmp         .Error

.Quote:
    call        .Quoted
.UnQuoted:
    cmp         dh, 0
    retne
    mov         al, 0x00
    call        .FindSwitch
    jmp         .Reset

.Quoted:
    mov         dl, al
    mov         bp, si
    clc
.QuoteScan:
    lodsb
    cmp         al, dl
    rete
    cmp         al, CR
    je          .ReturnError
    cmp         al, 0x00
    je          .ReturnError
    inc         cx
    jmp         .QuoteScan

.FindSwitch:
    push        di
    push        cx
.FindLoop:
    mov         cx, [di]
    mov         dl, [di+2]
    cmp         cx, 0x0000
    je          .NotFound
    cmp         dl, al
    je          .Found
    push        ax
    cmp         al, 0x61
    jb          .NotLower
    sub         al, 0x20
    cmp         dl, al
.NotLower:
    pop         ax
    je          .Found
    add         di, 0x0004
    jmp         .FindLoop
.Found:
    pop         cx
    push        ax
    mov         ah, [di+3]
    cmp         ah, 0x01
    pop         ax
    je          .ParamStr
    jb          .ParamNone
.ParamToggle:
    mov         dl, [si]
    inc         si
    mov         dh, 0x02
    cmp         dl, '+'
    je          .ToggleDone
    dec         dh
    cmp         dl, '-'
    je          .ToggleDone
    dec         dh
    dec         si
.ToggleDone:
    jmp         .Process
.ParamStr:
    mpush       ax, dx
    mov         dh, 1
    call        .Next
    mpop        ax, dx
    jc          .RecurseError
.ParamNone:
.Process:
    mpush       ax, bx, cx, dx, si, di, bp
    mov         dl, [di+3]
    mov         si, bp
    mov         bp, [di]
    mov         di, si
    add         di, cx
    call        bp
    mpop        ax, bx, cx, dx, si, di, bp
    pop         di
    ret
.RecurseError:
    pop         di
    stc
    ret

.NotFound:
    pop         cx
    pop         di
    cmp         al, 0xff
    je          .ReturnError
    mov         al, 0xff
    call        .FindSwitch
    ret

.DoneMaybe:
    cmp         dh, 0
    retne
    cmp         cx, 0
    jne         .UnQuoted

.Done:
    ; StdOutCRLF
.Error:
    mpop        ax, bx, cx, dx, si, di, bp
    ret
%endif

%endif
