/*
 *  wininet.h   Win32 Internet functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WININET_
#define _WININET_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Macros to specify Internet functions */
#define INTERNETAPI         EXTERN_C DECLSPEC_IMPORT HRESULT STDAPICALLTYPE
#define INTERNETAPI_( x )   EXTERN_C DECLSPEC_IMPORT x STDAPICALLTYPE
#define URLCACHEAPI         EXTERN_C DECLSPEC_IMPORT HRESULT STDAPICALLTYPE
#define URLCACHEAPI_( x )   EXTERN_C DECLSPEC_IMPORT x STDAPICALLTYPE
#define BOOLAPI             INTERNETAPI_( BOOL )

/* Internet primitive data types */
typedef LPVOID          HINTERNET;
typedef HINTERNET       *LPHINTERNET;
typedef WORD            INTERNET_PORT;
typedef INTERNET_PORT   *LPINTERNET_PORT;
typedef LONGLONG        GROUPID;

/* Internet ports */
#define INTERNET_INVALID_PORT_NUMBER    0
#define INTERNET_DEFAULT_FTP_PORT       21
#define INTERNET_DEFAULT_GOPHER_PORT    70
#define INTERNET_DEFAULT_HTTP_PORT      80
#define INTERNET_DEFAULT_HTTPS_PORT     443
#define INTERNET_DEFAULT_SOCKS_PORT     1080

/* Maximum string lengths */
#define INTERNET_MAX_HOST_NAME_LENGTH   256
#define INTERNET_MAX_USER_NAME_LENGTH   128
#define INTERNET_MAX_PASSWORD_LENGTH    128
#define INTERNET_MAX_PORT_NUMBER_LENGTH 5
#define INTERNET_MAX_PORT_NUMBER_VALUE  65535
#define INTERNET_MAX_PATH_LENGTH        2048
#define INTERNET_MAX_SCHEME_LENGTH      32
#define INTERNET_MAX_URL_LENGTH \
    (INTERNET_MAX_SCHEME_LENGTH + sizeof( "://" ) + INTERNET_MAX_PATH_LENGTH)
#define MAX_GOPHER_DISPLAY_TEXT         128
#define MAX_GOPHER_SELECTOR_TEXT        256
#define MAX_GOPHER_HOST_NAME            INTERNET_MAX_HOST_NAME_LENGTH
#define MAX_GOPHER_LOCATOR_LENGTH \
    (MAX_GOPHER_DISPLAY_TEXT + MAX_GOPHER_SELECTOR_TEXT + MAX_GOPHER_HOST_NAME + \
    INTERNET_MAX_PORT_NUMBER_LENGTH + 8)
#define MAX_GOPHER_CATEGORY_NAME        128
#define MAX_GOPHER_ATTRIBUTE_NAME       128
#define MAX_GOPHER_ATTRIBUTE_LENGTH     256
#define GROUPNAME_MAX_LENGTH            120
#define GROUP_OWNER_STORAGE_SIZE        4

/* InternetQueryOption() return values for INTERNET_OPTION_KEEP_CONNECTION */
#define INTERNET_KEEP_ALIVE_UNKNOWN     0xFFFFFFFFL
#define INTERNET_KEEP_ALIVE_ENABLED     0x00000001L
#define INTERNET_KEEP_ALIVE_DISABLED    0x00000000L

/* InternetQueryOption() return values for INTERNET_OPTION_REQUEST_FLAGS */
#define INTERNET_REQFLAG_FROM_CACHE             0x00000001L
#define INTERNET_REQFLAG_ASYNC                  0x00000002L
#define INTERNET_REQFLAG_VIA_PROXY              0x00000004L
#define INTERNET_REQFLAG_NO_HEADERS             0x00000008L
#define INTERNET_REQFLAG_PASSIVE                0x00000010L
#define INTERNET_REQFLAG_CACHE_WRITE_DISABLED   0x00000040L
#define INTERNET_REQFLAG_NET_TIMEOUT            0x00000080L

/* InternetQueryOption() return values for INTERNET_OPTION_IDN */
#define INTERNET_FLAG_IDN_DIRECT    0x00000001L
#define INTERNET_FLAG_IDN_PROXY     0x00000002L

/* Internet flags */
#define INTERNET_FLAG_RELOAD                    0x80000000L
#define INTERNET_FLAG_RAW_DATA                  0x40000000L
#define INTERNET_FLAG_EXISTING_CONNECT          0x20000000L
#define INTERNET_FLAG_ASYNC                     0x10000000L
#define INTERNET_FLAG_PASSIVE                   0x08000000L
#define INTERNET_FLAG_NO_CACHE_WRITE            0x04000000L
#define INTERNET_FLAG_DONT_CACHE                INTERNET_FLAG_NO_CACHE_WRITE
#define INTERNET_FLAG_MAKE_PERSISTENT           0x02000000L
#define INTERNET_FLAG_FROM_CACHE                0x01000000L
#define INTERNET_FLAG_OFFLINE                   INTERNET_FLAG_FROM_CACHE
#define INTERNET_FLAG_SECURE                    0x00800000L
#define INTERNET_FLAG_KEEP_CONNECTION           0x00400000L
#define INTERNET_FLAG_NO_AUTO_REDIRECT          0x00200000L
#define INTERNET_FLAG_READ_PREFETCH             0x00100000L
#define INTERNET_FLAG_NO_COOKIES                0x00080000L
#define INTERNET_FLAG_NO_AUTH                   0x00040000L
#define INTERNET_FLAG_RESTRICTED_ZONE           0x00020000L
#define INTERNET_FLAG_CACHE_IF_NET_FAIL         0x00010000L
#define INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP   0x00008000L
#define INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS  0x00004000L
#define INTERNET_FLAG_IGNORE_CERT_DATE_INVALID  0x00002000L
#define INTERNET_FLAG_IGNORE_CERT_CN_INVALID    0x00001000L
#define INTERNET_FLAG_RESYNCHRONIZE             0x00000800L
#define INTERNET_FLAG_HYPERLINK                 0x00000400L
#define INTERNET_FLAG_NO_UI                     0x00000200L
#define INTERNET_FLAG_PRAGMA_NOCACHE            0x00000100L
#define INTERNET_FLAG_CACHE_ASYNC               0x00000080L
#define INTERNET_FLAG_FORMS_SUBMIT              0x00000040L
#define INTERNET_FLAG_FWD_BACK                  0x00000020L
#define INTERNET_FLAG_NEED_FILE                 0x00000010L
#define INTERNET_FLAG_MUST_CACHE_REQUEST        INTERNET_FLAG_NEED_FILE

/* Internet flags for FTP */
#define INTERNET_FLAG_TRANSFER_ASCII            FTP_TRANSFER_TYPE_ASCII
#define INTERNET_FLAG_TRANSFER_BINARY           FTP_TRANSFER_TYPE_BINARY

/* Internet flag masks */
#define SECURITY_INTERNET_MASK \
    (INTERNET_FLAG_IGNORE_CERT_CN_INVALID | INTERNET_FLAG_IGNORE_CERT_DATE_INVALID | \
    INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS | INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP)
#define SECURITY_IGNORE_ERROR_MASK \
    (INTERNET_FLAG_IGNORE_CERT_CN_INVALID | INTERNET_FLAG_IGNORE_CERT_DATE_INVALID | \
    SECURITY_FLAG_IGNORE_UNKNOWN_CA | SECURITY_FLAG_IGNORE_REVOCATION)
#define INTERNET_FLAGS_MASK \
    (INTERNET_FLAG_RELOAD | INTERNET_FLAG_RAW_DATA | INTERNET_FLAG_EXISTING_CONNECT | \
    INTERNET_FLAG_ASYNC | INTERNET_FLAG_PASSIVE | INTERNET_FLAG_NO_CACHE_WRITE | \
    INTERNET_FLAG_MAKE_PERSISTENT | INTERNET_FLAG_FROM_CACHE | INTERNET_FLAG_SECURE | \
    INTERNET_FLAG_KEEP_CONNECTION | INTERNET_FLAG_NO_AUTO_REDIRECT | \
    INTERNET_FLAG_READ_PREFETCH | INTERNET_FLAG_NO_COOKIES | INTERNET_FLAG_NO_AUTH | \
    INTERNET_FLAG_CACHE_IF_NET_FAIL | SECURITY_INTERNET_MASK | \
    INTERNET_FLAG_RESYNCHRONIZE | INTERNET_FLAG_HYPERLINK | INTERNET_FLAG_NO_UI | \
    INTERNET_FLAG_PRAGMA_NOCACHE | INTERNET_FLAG_CACHE_ASYNC | \
    INTERNET_FLAG_FORMS_SUBMIT | INTERNET_FLAG_NEED_FILE | \
    INTERNET_FLAG_RESTRICTED_ZONE | INTERNET_FLAG_TRANSFER_BINARY | \
    INTERNET_FLAG_TRANSFER_ASCII | INTERNET_FLAG_FWD_BACK | INTERNET_FLAG_BGUPDATE)
#define INTERNET_OPTIONS_MASK                   (~INTERNET_FLAGS_MASK)

/* Internet error masks */
#define INTERNET_ERROR_MASK_INSERT_CDROM                        0x00000001L
#define INTERNET_ERROR_MASK_COMBINED_SEC_CERT                   0x00000002L
#define INTERNET_ERROR_MASK_NEED_MSN_SSPI_PKG                   0x00000004L
#define INTERNET_ERROR_MASK_LOGON_FAILURE_DISPLAY_ENTITY_BODY   0x00000008L

/* Internet API flags */
#define WININET_API_FLAG_ASYNC          0x00000001L
#define WININET_API_FLAG_SYNC           0x00000004L
#define WININET_API_FLAG_USE_CONTEXT    0x00000008L

/* Internet context special value */
#define INTERNET_NO_CALLBACK    0L

/* Internet diagnostic socket information flags */
#define IDSI_FLAG_KEEP_ALIVE    0x00000001L
#define IDSI_FLAG_SECURE        0x00000002L
#define IDSI_FLAG_PROXY         0x00000004L
#define IDSI_FLAG_TUNNEL        0x00000008L

/* Internet per connection options */
#define INTERNET_PER_CONN_FLAGS                         1L
#define INTERNET_PER_CONN_PROXY_SERVER                  2L
#define INTERNET_PER_CONN_PROXY_BYPASS                  3L
#define INTERNET_PER_CONN_AUTOCONFIG_URL                4L
#define INTERNET_PER_CONN_AUTODISCOVERY_FLAGS           5L
#define INTERNET_PER_CONN_AUTOCONFIG_SECONDARY_URL      6L
#define INTERNET_PER_CONN_AUTOCONFIG_RELOAD_DELAY_MINS  7L
#define INTERNET_PER_CONN_AUTOCONFIG_LAST_DETECT_TIME   8L
#define INTERNET_PER_CONN_AUTOCONFIG_LAST_DETECT_URL    9L
#define INTERNET_PER_CONN_FLAGS_UI                      10L

/* Proxy types */
#define PROXY_TYPE_DIRECT           0x00000001L
#define PROXY_TYPE_PROXY            0x00000002L
#define PROXY_TYPE_AUTO_PROXY_URL   0x00000004L
#define PROXY_TYPE_AUTO_DETECT      0x00000008L

/* Automatic proxy flags */
#define AUTO_PROXY_FLAG_USER_SET                0x00000001L
#define AUTO_PROXY_FLAG_ALWAYS_DETECT           0x00000002L
#define AUTO_PROXY_FLAG_DETECTION_RUN           0x00000004L
#define AUTO_PROXY_FLAG_MIGRATED                0x00000008L
#define AUTO_PROXY_FLAG_DONT_CACHE_PROXY_RESULT 0x00000010L
#define AUTO_PROXY_FLAG_CACHE_INIT_RUN          0x00000020L
#define AUTO_PROXY_FLAG_DETECTION_SUSPECT       0x00000040L

/* Internet connected information flags */
#define ISO_FORCE_DISCONNECTED  0x00000001L

/* InternetTimeFromSystemTime() RFC formats */
#define INTERNET_RFC1123_FORMAT     0L
#define INTERNET_RFC1123_BUFSIZE    30L

/* Flags for InternetCrackUrl(), etc. */
#define ICU_ESCAPE              0x80000000L
#define ICU_USERNAME            0x40000000L
#define ICU_NO_ENCODE           0x20000000L
#define ICU_DECODE              0x10000000L
#define ICU_NO_META             0x08000000L
#define ICU_ENCODE_SPACES_ONLY  0x04000000L
#define ICU_BROWSER_MODE        0x02000000L
#define ICU_ENCODE_PERCENT      0x00001000L

/* InternetOpen() access types */
#define INTERNET_OPEN_TYPE_PRECONFIG                    0L
#define INTERNET_OPEN_TYPE_DIRECT                       1L
#define INTERNET_OPEN_TYPE_PROXY                        3L
#define INTERNET_OPEN_TYPE_PRECONFIG_WITH_NO_AUTOPROXY  4L

/* Old InternetOpen() access type names for compatibility */
#define PRE_CONFIG_INTERNET_ACCESS  INTERNET_OPEN_TYPE_PRECONFIG
#define LOCAL_INTERNET_ACCESS       INTERNET_OPEN_TYPE_DIRECT
#define CERN_PROXY_INTERNET_ACCESS  INTERNET_OPEN_TYPE_PROXY

/* InternetConnect() service types */
#define INTERNET_SERVICE_FTP    1L
#define INTERNET_SERVICE_GOPHER 2L
#define INTERNET_SERVICE_HTTP   3L

/* InternetReadFileEx() flags */
#define IRF_ASYNC       WININET_API_FLAG_ASYNC
#define IRF_SYNC        WININET_API_FLAG_SYNC
#define IRF_USE_CONTEXT WININET_API_FLAG_USE_CONTEXT
#define IRF_NO_WAIT     0x00000008L

/* InternetSetOptionEx() flags */
#define ISO_GLOBAL      0x00000001L
#define ISO_REGISTRY    0x00000002L
#define ISO_VALID_FLAGS (ISO_GLOBAL | ISO_REGISTRY)

/* Internet options */
#define INTERNET_OPTION_CALLBACK                        1L
#define INTERNET_OPTION_CONNECT_TIMEOUT                 2L
#define INTERNET_OPTION_CONNECT_RETRIES                 3L
#define INTERNET_OPTION_CONNECT_BACKOFF                 4L
#define INTERNET_OPTION_SEND_TIMEOUT                    5L
#define INTERNET_OPTION_CONTROL_SEND_TIMEOUT            INTERNET_OPTION_SEND_TIMEOUT
#define INTERNET_OPTION_RECEIVE_TIMEOUT                 6L
#define INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT         INTERNET_OPTION_RECEIVE_TIMEOUT
#define INTERNET_OPTION_DATA_SEND_TIMEOUT               7L
#define INTERNET_OPTION_DATA_RECEIVE_TIMEOUT            8L
#define INTERNET_OPTION_HANDLE_TYPE                     9L
#define INTERNET_OPTION_LISTEN_TIMEOUT                  11L
#define INTERNET_OPTION_READ_BUFFER_SIZE                12L
#define INTERNET_OPTION_WRITE_BUFFER_SIZE               13L
#define INTERNET_OPTION_ASYNC_ID                        15L
#define INTERNET_OPTION_ASYNC_PRIORITY                  16L
#define INTERNET_OPTION_PARENT_HANDLE                   21L
#define INTERNET_OPTION_KEEP_CONNECTION                 22L
#define INTERNET_OPTION_REQUEST_FLAGS                   23L
#define INTERNET_OPTION_EXTENDED_ERROR                  24L
#define INTERNET_OPTION_OFFLINE_MODE                    26L
#define INTERNET_OPTION_CACHE_STREAM_HANDLE             27L
#define INTERNET_OPTION_USERNAME                        28L
#define INTERNET_OPTION_PASSWORD                        29L
#define INTERNET_OPTION_ASYNC                           30L
#define INTERNET_OPTION_SECURITY_FLAGS                  31L
#define INTERNET_OPTION_SECURITY_CERTIFICATE_STRUCT     32L
#define INTERNET_OPTION_DATAFILE_NAME                   33L
#define INTERNET_OPTION_URL                             34L
#define INTERNET_OPTION_SECURITY_CERTIFICATE            35L
#define INTERNET_OPTION_SECURITY_KEY_BITNESS            36L
#define INTERNET_OPTION_REFRESH                         37L
#define INTERNET_OPTION_PROXY                           38L
#define INTERNET_OPTION_SETTINGS_CHANGED                39L
#define INTERNET_OPTION_VERSION                         40L
#define INTERNET_OPTION_USER_AGENT                      41L
#define INTERNET_OPTION_END_BROWSER_SESSION             42L
#define INTERNET_OPTION_PROXY_USERNAME                  43L
#define INTERNET_OPTION_PROXY_PASSWORD                  44L
#define INTERNET_OPTION_CONTEXT_VALUE                   45L
#define INTERNET_OPTION_CONNECT_LIMIT                   46L
#define INTERNET_OPTION_SECURITY_SELECT_CLIENT_CERT     47L
#define INTERNET_OPTION_POLICY                          48L
#define INTERNET_OPTION_DISCONNECTED_TIMEOUT            49L
#define INTERNET_OPTION_CONNECTED_STATE                 50L
#define INTERNET_OPTION_IDLE_STATE                      51L
#define INTERNET_OPTION_OFFLINE_SEMANTICS               52L
#define INTERNET_OPTION_SECONDARY_CACHE_KEY             53L
#define INTERNET_OPTION_CALLBACK_FILTER                 54L
#define INTERNET_OPTION_CONNECT_TIME                    55L
#define INTERNET_OPTION_SEND_THROUGHPUT                 56L
#define INTERNET_OPTION_RECEIVE_THROUGHPUT              57L
#define INTERNET_OPTION_REQUEST_PRIORITY                58L
#define INTERNET_OPTION_HTTP_VERSION                    59L
#define INTERNET_OPTION_RESET_URLCACHE_SESSION          60L
#define INTERNET_OPTION_ERROR_MASK                      62L
#define INTERNET_OPTION_FROM_CACHE_TIMEOUT              63L
#define INTERNET_OPTION_BYPASS_EDITED_ENTRY             64L
#define INTERNET_OPTION_HTTP_DECODING                   65L
#define INTERNET_OPTION_DIAGNOSTIC_SOCKET_INFO          67L
#define INTERNET_OPTION_CODEPAGE                        68L
#define INTERNET_OPTION_CACHE_TIMESTAMPS                69L
#define INTERNET_OPTION_DISABLE_AUTODIAL                70L
#define INTERNET_OPTION_MAX_CONNS_PER_SERVER            73L
#define INTERNET_OPTION_MAX_CONNS_PER_1_0_SERVER        74L
#define INTERNET_OPTION_PER_CONNECTION_OPTION           75L
#define INTERNET_OPTION_DIGEST_AUTH_UNLOAD              76L
#define INTERNET_OPTION_IGNORE_OFFLINE                  77L
#define INTERNET_OPTION_IDENTITY                        78L
#define INTERNET_OPTION_REMOVE_IDENTITY                 79L
#define INTERNET_OPTION_ALTER_IDENTITY                  80L
#define INTERNET_OPTION_SUPPRESS_BEHAVIOR               81L
#define INTERNET_OPTION_AUTODIAL_MODE                   82L
#define INTERNET_OPTION_AUTODIAL_CONNECTION             83L
#define INTERNET_OPTION_CLIENT_CERT_CONTEXT             84L
#define INTERNET_OPTION_AUTH_FLAGS                      85L
#define INTERNET_OPTION_COOKIES_3RD_PARTY               86L
#define INTERNET_OPTION_DISABLE_PASSPORT_AUTH           87L
#define INTERNET_OPTION_SEND_UTF8_SERVERNAME_TO_PROXY   88L
#define INTERNET_OPTION_EXEMPT_CONNECTION_LIMIT         89L
#define INTERNET_OPTION_ENABLE_PASSPORT_AUTH            90L
#define INTERNET_OPTION_HIBERNATE_INACTIVE_WORKER_THREADS   91L
#define INTERNET_OPTION_ACTIVATE_WORKER_THREADS         92L
#define INTERNET_OPTION_RESTORE_WORKER_THREAD_DEFAULTS  93L
#define INTERNET_OPTION_SOCKET_SEND_BUFFER_LENGTH       94L
#define INTERNET_OPTION_PROXY_SETTINGS_CHANGED          95L
#define INTERNET_OPTION_DATAFILE_EXT                    96L
#define INTERNET_OPTION_CODEPAGE_PATH                   100L
#define INTERNET_OPTION_CODEPAGE_EXTRA                  101L
#define INTERNET_OPTION_IDN                             102L
#define INTERNET_OPTION_MAX_CONNS_PER_PROXY             103L
#define INTERNET_OPTION_SUPPRESS_SERVER_AUTH            104L
#define INTERNET_OPTION_SERVER_CERT_CHAIN_CONTEXT       105L
#define INTERNET_FIRST_OPTION                           INTERNET_OPTION_CALLBACK
#define INTERNET_LAST_OPTION \
    INTERNET_OPTION_SERVER_CERT_CHAIN_CONTEXT

/* Internet priorities */
#define INTERNET_PRIORITY_FOREGROUND    1000L

/* Internet handle types */
#define INTERNET_HANDLE_TYPE_INTERNET           1L
#define INTERNET_HANDLE_TYPE_CONNECT_FTP        2L
#define INTERNET_HANDLE_TYPE_CONNECT_GOPHER     3L
#define INTERNET_HANDLE_TYPE_CONNECT_HTTP       4L
#define INTERNET_HANDLE_TYPE_FTP_FIND           5L
#define INTERNET_HANDLE_TYPE_FTP_FIND_HTML      6L
#define INTERNET_HANDLE_TYPE_FTP_FILE           7L
#define INTERNET_HANDLE_TYPE_FTP_FILE_HTML      8L
#define INTERNET_HANDLE_TYPE_GOPHER_FIND        9L
#define INTERNET_HANDLE_TYPE_GOPHER_FIND_HTML   10L
#define INTERNET_HANDLE_TYPE_GOPHER_FILE        11L
#define INTERNET_HANDLE_TYPE_GOPHER_FILE_HTML   12L
#define INTERNET_HANDLE_TYPE_HTTP_REQUEST       13L
#define INTERNET_HANDLE_TYPE_FILE_REQUEST       14L

/* Authentication flags */
#define AUTH_FLAG_DISABLE_NEGOTIATE             0x00000001L
#define AUTH_FLAG_ENABLE_NEGOTIATE              0x00000002L
#define AUTH_FLAG_DISABLE_BASIC_CLEARCHANNEL    0x00000004L

/* Security flags */
#define SECURITY_FLAG_SECURE                    0x00000001L
#define SECURITY_FLAG_SSL                       0x00000002L
#define SECURITY_FLAG_SSL3                      0x00000004L
#define SECURITY_FLAG_PCT                       0x00000008L
#define SECURITY_FLAG_PCT4                      0x00000010L
#define SECURITY_FLAG_IETFSSL4                  0x00000020L
#define SECURITY_FLAG_IGNORE_REVOCATION         0x00000080L
#define SECURITY_FLAG_IGNORE_UNKNOWN_CA         0x00000100L
#define SECURITY_FLAG_IGNORE_WRONG_USAGE        0x00000200L
#define SECURITY_FLAG_FORTEZZA                  0x08000000L
#define SECURITY_FLAG_STRENGTH_WEAK             0x10000000L
#define SECURITY_FLAG_STRENGTH_STRONG           0x20000000L
#define SECURITY_FLAG_STRENGTH_MEDIUM           0x40000000L
#define SECURITY_FLAG_UNKNOWNBIT                0x80000000L
#define SECURITY_FLAG_NORMALBITNESS             SECURITY_FLAG_STRENGTH_WEAK
#define SECURITY_FLAG_40BIT                     SECURITY_FLAG_STRENGTH_WEAK
#define SECURITY_FLAG_128BIT                    SECURITY_FLAG_STRENGTH_STRONG
#define SECURITY_FLAG_56BIT                     SECURITY_FLAG_STRENGTH_MEDIUM
#define SECURITY_FLAG_IGNORE_CERT_CN_INVALID    INTERNET_FLAG_IGNORE_CERT_CN_INVALID
#define SECURITY_FLAG_IGNORE_CERT_DATE_INVALID  INTERNET_FLAG_IGNORE_CERT_DATE_INVALID
#define SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTPS  INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS
#define SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTP   INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP
#define SECURITY_SET_MASK \
    (SECURITY_FLAG_IGNORE_REVOCATION | SECURITY_FLAG_UNKNOWN_CA | \
    SECURITY_FLAG_IGNORE_CERT_CN_INVALID | SECURITY_FLAG_IGNORE_CERT_DATE_INVALID | \ 
    SECURITY_FLAG_IGNORE_WRONG_USAGE)

/* Autodial modes */
#define AUTODIAL_MODE_NEVER                 1L
#define AUTODIAL_MODE_ALWAYS                2L
#define AUTODIAL_MODE_NO_NETWORK_PRESENT    3L

/* Internet status values */
#define INTERNET_STATUS_RESOLVING_NAME          10L
#define INTERNET_STATUS_NAME_RESOLVED           11L
#define INTERNET_STATUS_CONNECTING_TO_SERVER    20L
#define INTERNET_STATUS_CONNECTED_TO_SERVER     21L
#define INTERNET_STATUS_SENDING_REQUEST         30L
#define INTERNET_STATUS_REQUEST_SENT            31L
#define INTERNET_STATUS_RECEIVING_RESPONSE      40L
#define INTERNET_STATUS_RESPONSE_RECEIVED       41L
#define INTERNET_STATUS_CTL_RESPONSE_RECEIVED   42L
#define INTERNET_STATUS_PREFETCH                43L
#define INTERNET_STATUS_CLOSING_CONNECTION      50L
#define INTERNET_STATUS_CONNECTION_CLOSED       51L
#define INTERNET_STATUS_HANDLE_CREATED          60L
#define INTERNET_STATUS_HANDLE_CLOSING          70L
#define INTERNET_STATUS_DETECTING_PROXY         80L
#define INTERNET_STATUS_REQUEST_COMPLETE        100L
#define INTERNET_STATUS_REDIRECT                110L
#define INTERNET_STATUS_INTERMEDIATE_RESPONSE   120L
#define INTERNET_STATUS_USER_INPUT_REQUIRED     140L
#define INTERNET_STATUS_STATE_CHANGE            200L
#define INTERNET_STATUS_COOKIE_SENT             320L
#define INTERNET_STATUS_COOKIE_RECEIVED         321L
#define INTERNET_STATUS_PRIVACY_IMPACTED        324L
#define INTERNET_STATUS_P3P_HEADER              235L
#define INTERNET_STATUS_P3P_POLICYREF           326L
#define INTERNET_STATUS_COOKIE_HISTORY          327L

/* Internet states */
#define INTERNET_STATE_CONNECTED            0x00000001L
#define INTERNET_STATE_DISCONNECTED         0x00000002L
#define INTERNET_STATE_DISCONNECTED_BY_USER 0x00000010L
#define INTERNET_STATE_IDLE                 0x00000100L
#define INTERNET_STATE_BUSY                 0x00000200L

/* FTP transfer types */
#define FTP_TRANSFER_TYPE_UNKNOWN   0x00000000L
#define FTP_TRANSFER_TYPE_ASCII     0x00000001L
#define FTP_TRANSFER_TYPE_BINARY    0x00000002L
#define FTP_TRANSFER_TYPE_MASK      (FTP_TRANSFER_TYPE_ASCII | FTP_TRANSFER_TYPE_BINARY)

/* Gopher types */
#define GOPHER_TYPE_TEXT_FILE       0x00000001L
#define GOPHER_TYPE_DIRECTORY       0x00000002L
#define GOPHER_TYPE_CSO             0x00000004L
#define GOPHER_TYPE_ERROR           0x00000008L
#define GOPHER_TYPE_MAC_BINHEX      0x00000010L
#define GOPHER_TYPE_DOS_ARCHIVE     0x00000020L
#define GOPHER_TYPE_UNIX_UUENCODED  0x00000040L
#define GOPHER_TYPE_INDEX_SERVER    0x00000080L
#define GOPHER_TYPE_TELNET          0x00000100L
#define GOPHER_TYPE_BINARY          0x00000200L
#define GOPHER_TYPE_REDUNDANT       0x00000400L
#define GOPHER_TYPE_TN3270          0x00000800L
#define GOPHER_TYPE_GIF             0x00001000L
#define GOPHER_TYPE_IMAGE           0x00002000L
#define GOPHER_TYPE_BITMAP          0x00004000L
#define GOPHER_TYPE_MOVIE           0x00008000L
#define GOPHER_TYPE_SOUND           0x00010000L
#define GOPHER_TYPE_HTML            0x00020000L
#define GOPHER_TYPE_PDF             0x00040000L
#define GOPHER_TYPE_CALENDAR        0x00080000L
#define GOPHER_TYPE_INLINE          0x00100000L
#define GOPHER_TYPE_UNKNOWN         0x20000000L
#define GOPHER_TYPE_ASK             0x40000000L
#define GOPHER_TYPE_GOPHER_PLUS     0x80000000L
#define GOPHER_TYPE_FILE_MASK \
    (GOPHER_TYPE_TEXT_FILE | GOPHER_TYPE_MAC_BINHEX | GOPHER_TYPE_DOS_ARCHIVE | \
    GOPHER_TYPE_UNIX_UUENCODED | GOPHER_TYPE_BINARY | GOPHER_TYPE_GIF | \
    GOPHER_TYPE_IMAGE | GOPHER_TYPE_BITMAP | GOPHER_TYPE_MOVIE | GOPHER_TYPE_SOUND | \
    GOPHER_TYPE_HTML | GOPHER_TYPE_PDF | GOPHER_TYPE_CALENDAR | GOPHER_TYPE_INLINE)

/* Macros to test for Gopher types */
#define IS_GOPHER_FILE( x ) \
    (BOOL)(((x) & GOPHER_TYPE_FILE_MASK) ? TRUE : FALSE)
#define IS_GOPHER_DIRECTORY( x ) \
    (BOOL)(((x) & GOPHER_TYPE_DIRECTORY) ? TRUE : FALSE)
#define IS_GOPHER_PHONE_SERVER( x ) \
    (BOOL)(((x) & GOPHER_TYPE_CSO) ? TRUE : FALSE)
#define IS_GOPHER_ERROR( x ) \
    (BOOL)(((x) & GOPHER_TYPE_ERROR) ? TRUE : FALSE)
#define IS_GOPHER_INDEX_ERROR( x ) \
    (BOOL)(((x) & GOPHER_TYPE_INDEX_SERVER) ? TRUE : FALSE)
#define IS_GOPHER_TELNET_SESSION( x ) \
    (BOOL)(((x) & GOPHER_TYPE_TELNET) ? TRUE : FALSE)
#define IS_GOPHER_BACKUP_SERVER( x ) \
    (BOOL)(((x) & GOPHER_TYPE_REDUNDANT) ? TRUE : FALSE)
#define IS_GOPHER_TN3270_SESSION( x ) \
    (BOOL)(((x) & GOPHER_TYPE_TN3270) ? TRUE : FALSE)
#define IS_GOPHER_ASK( x ) \
    (BOOL)(((x) & GOPHER_TYPE_ASK) ? TRUE : FALSE)
#define IS_GOPHER_PLUS( x ) \
    (BOOL)(((x) & GOPHER_TYPE_GOPHER_PLUS) ? TRUE : FALSE)
#define IS_GOPHER_TYPE_UNKNOWN( x ) \
    (BOOL)(((x) & GOPHER_TYPE_UNKNOWN) ? FALSE : TRUE)

/* Minimum and maximum Gopher string lengths */
#define MAX_GOPHER_CATEGORY_NAME    128
#define MAX_GOPHER_ATTRIBUTE_NAME   128
#define MIN_GOPHER_ATTRIBUTE_LENGTH 256

/* Gopher categories */
#define GOPHER_INFO_CATEGORY        TEXT( "+INFO" )
#define GOPHER_ADMIN_CATEGORY       TEXT( "+ADMIN" )
#define GOPHER_VIEWS_CATEGORY       TEXT( "+VIEWS" )
#define GOPHER_ABSTRACT_CATEGORY    TEXT( "+ABSTRACT" )
#define GOPHER_VERONICA_CATEGORY    TEXT( "+VERONICA" )

/* Gopher attributes */
#define GOPHER_ADMIN_ATTRIBUTE      TEXT( "Admin" )
#define GOPHER_MOD_DATE_ATTRIBUTE   TEXT( "Mod-Date" )
#define GOPHER_TTL_ATTRIBUTE        TEXT( "TTL" )
#define GOPHER_SCORE_ATTRIBUTE      TEXT( "Score" )
#define GOPHER_RANGE_ATTRIBUTE      TEXT( "Score-range" )
#define GOPHER_SITE_ATTRIBUTE       TEXT( "Site" )
#define GOPHER_ORG_ATTRIBUTE        TEXT( "Org" )
#define GOPHER_LOCATION_ATTRIBUTE   TEXT( "Loc" )
#define GOPHER_GEOG_ATTRIBUTE       TEXT( "Geog" )
#define GOPHER_TIMEZONE_ATTRIBUTE   TEXT( "TZ" )
#define GOPHER_PROVIDER_ATTRIBUTE   TEXT( "Provider" )
#define GOPHER_VERSION_ATTRIBUTE    TEXT( "Version" )
#define GOPHER_ABSTRACT_ATTRIBUTE   TEXT( "Abstract" )
#define GOPHER_VIEW_ATTRIBUTE       TEXT( "View" )
#define GOPHER_TREEWALK_ATTRIBUTE   TEXT( "treewalk" )

/* Gopher attribute identifiers */
#define GOPHER_ATTRIBUTE_ID_BASE        0xABCCCC00L
#define GOPHER_CATEGORY_ID_ALL          (GOPHER_ATTRIBUTE_ID_BASE + 1)
#define GOPHER_CATEGORY_ID_INFO         (GOPHER_ATTRIBUTE_ID_BASE + 2)
#define GOPHER_CATEGORY_ID_ADMIN        (GOPHER_ATTRIBUTE_ID_BASE + 3)
#define GOPHER_CATEGORY_ID_VIEWS        (GOPHER_ATTRIBUTE_ID_BASE + 4)
#define GOPHER_CATEGORY_ID_ABSTRACT     (GOPHER_ATTRIBUTE_ID_BASE + 5)
#define GOPHER_CATEGORY_ID_VERONICA     (GOPHER_ATTRIBUTE_ID_BASE + 6)
#define GOPHER_CATEGORY_ID_ASK          (GOPHER_ATTRIBUTE_ID_BASE + 7)
#define GOPHER_CATEGORY_ID_UNKNOWN      (GOPHER_ATTRIBUTE_ID_BASE + 8)
#define GOPHER_ATTRIBUTE_ID_ALL         (GOPHER_ATTRIBUTE_ID_BASE + 9)
#define GOPHER_ATTRIBUTE_ID_ADMIN       (GOPHER_ATTRIBUTE_ID_BASE + 10)
#define GOPHER_ATTRIBUTE_ID_MOD_DATE    (GOPHER_ATTRIBUTE_ID_BASE + 11)
#define GOPHER_ATTRIBUTE_ID_TTL         (GOPHER_ATTRIBUTE_ID_BASE + 12)
#define GOPHER_ATTRIBUTE_ID_SCORE       (GOPHER_ATTRIBUTE_ID_BASE + 13)
#define GOPHER_ATTRIBUTE_ID_RANGE       (GOPHER_ATTRIBUTE_ID_BASE + 14)
#define GOPHER_ATTRIBUTE_ID_SITE        (GOPHER_ATTRIBUTE_ID_BASE + 15)
#define GOPHER_ATTRIBUTE_ID_ORG         (GOPHER_ATTRIBUTE_ID_BASE + 16)
#define GOPHER_ATTRIBUTE_ID_LOCATION    (GOPHER_ATTRIBUTE_ID_BASE + 17)
#define GOPHER_ATTRIBUTE_ID_GEOG        (GOPHER_ATTRIBUTE_ID_BASE + 18)
#define GOPHER_ATTRIBUTE_ID_TIMEZONE    (GOPHER_ATTRIBUTE_ID_BASE + 19)
#define GOPHER_ATTRIBUTE_ID_PROVIDER    (GOPHER_ATTRIBUTE_ID_BASE + 20)
#define GOPHER_ATTRIBUTE_ID_VERSION     (GOPHER_ATTRIBUTE_ID_BASE + 21)
#define GOPHER_ATTRIBUTE_ID_ABSTRACT    (GOPHER_ATTRIBUTE_ID_BASE + 22)
#define GOPHER_ATTRIBUTE_ID_VIEW        (GOPHER_ATTRIBUTE_ID_BASE + 23)
#define GOPHER_ATTRIBUTE_ID_TREEWALK    (GOPHER_ATTRIBUTE_ID_BASE + 24)
#define GOPHER_ATTRIBUTE_ID_UNKNOWN     (GOPHER_ATTRIBUTE_ID_BASE + 25)

/* HTTP version number */
#define HTTP_MAJOR_VERSION  1
#define HTTP_MINOR_VERSION  0
#define HTTP_VERSIONA       "HTTP/1.0"
#define HTTP_VERSIONW       L"HTTP/1.0"
#ifdef UNICODE
    #define HTTP_VERSION    HTTP_VERSIONW
#else
    #define HTTP_VERSION    HTTP_VERSIONA
#endif

/* HttpQueryInfo() indices */
#define HTTP_QUERY_MIME_VERSION                 0L
#define HTTP_QUERY_CONTENT_TYPE                 1L
#define HTTP_QUERY_CONTENT_TRANSFER_ENCODING    2L
#define HTTP_QUERY_CONTENT_ID                   3L
#define HTTP_QUERY_CONTENT_DESCRIPTION          4L
#define HTTP_QUERY_CONTENT_LENGTH               5L
#define HTTP_QUERY_CONTENT_LANGUAGE             6L
#define HTTP_QUERY_ALLOW                        7L
#define HTTP_QUERY_PUBLIC                       8L
#define HTTP_QUERY_DATE                         9L
#define HTTP_QUERY_EXPIRES                      10L
#define HTTP_QUERY_LAST_MODIFIED                11L
#define HTTP_QUERY_MESSAGE_ID                   12L
#define HTTP_QUERY_URI                          13L
#define HTTP_QUERY_DERIVED_FROM                 14L
#define HTTP_QUERY_COST                         15L
#define HTTP_QUERY_LINK                         16L
#define HTTP_QUERY_PRAGMA                       17L
#define HTTP_QUERY_VERSION                      18L
#define HTTP_QUERY_STATUS_CODE                  19L
#define HTTP_QUERY_STATUS_TEXT                  20L
#define HTTP_QUERY_RAW_HEADERS                  21L
#define HTTP_QUERY_RAW_HEADERS_CRLF             22L
#define HTTP_QUERY_CONNECTION                   23L
#define HTTP_QUERY_ACCEPT                       24L
#define HTTP_QUERY_ACCEPT_CHARSET               25L
#define HTTP_QUERY_ACCEPT_ENCODING              26L
#define HTTP_QUERY_ACCEPT_LANGUAGE              27L
#define HTTP_QUERY_AUTHORIZATION                28L
#define HTTP_QUERY_CONTENT_ENCODING             29L
#define HTTP_QUERY_FORWARDED                    30L
#define HTTP_QUERY_FROM                         31L
#define HTTP_QUERY_IF_MODIFIED_SINCE            32L
#define HTTP_QUERY_LOCATION                     33L
#define HTTP_QUERY_ORIG_URI                     34L
#define HTTP_QUERY_REFERER                      35L
#define HTTP_QUERY_RETRY_AFTER                  36L
#define HTTP_QUERY_SERVER                       37L
#define HTTP_QUERY_TITLE                        38L
#define HTTP_QUERY_USER_AGENT                   39L
#define HTTP_QUERY_WWW_AUTHENTICATE             40L
#define HTTP_QUERY_PROXY_AUTHENTICATE           41L
#define HTTP_QUERY_ACCEPT_RANGES                42L
#define HTTP_QUERY_SET_COOKIE                   43L
#define HTTP_QUERY_COOKIE                       44L
#define HTTP_QUERY_REQUEST_METHOD               45L
#define HTTP_QUERY_REFRESH                      46L
#define HTTP_QUERY_CONTENT_DISPOSITION          47L
#define HTTP_QUERY_AGE                          48L
#define HTTP_QUERY_CACHE_CONTROL                49L
#define HTTP_QUERY_CONTENT_BASE                 50L
#define HTTP_QUERY_CONTENT_LOCATION             51L
#define HTTP_QUERY_CONTENT_MD5                  52L
#define HTTP_QUERY_CONTENT_RANGE                53L
#define HTTP_QUERY_ETAG                         54L
#define HTTP_QUERY_HOST                         55L
#define HTTP_QUERY_IF_MATCH                     56L
#define HTTP_QUERY_IF_NONE_MATCH                57L
#define HTTP_QUERY_IF_RANGE                     58L
#define HTTP_QUERY_IF_UNMODIFIED_SINCE          59L
#define HTTP_QUERY_MAX_FORWARDS                 60L
#define HTTP_QUERY_PROXY_AUTHORIZATION          61L
#define HTTP_QUERY_RANGE                        62L
#define HTTP_QUERY_TRANSFER_ENCODING            63L
#define HTTP_QUERY_UPGRADE                      64L
#define HTTP_QUERY_VARY                         65L
#define HTTP_QUERY_VIA                          66L
#define HTTP_QUERY_WARNING                      67L
#define HTTP_QUERY_EXPECT                       68L
#define HTTP_QUERY_PROXY_CONNECTION             69L
#define HTTP_QUERY_UNLESS_MODIFIED_SINCE        70L
#define HTTP_QUERY_ECHO_REQUEST                 71L
#define HTTP_QUERY_REPLY                        72L
#define HTTP_QUERY_ECHO_HEADERS                 73L
#define HTTP_QUERY_ECHO_HEADERS_CRLF            74L
#define HTTP_QUERY_PROXY_SUPPORT                75L
#define HTTP_QUERY_AUTHENTICATION_INFO          76L
#define HTTP_QUERY_PASSPORT_URLS                77L
#define HTTP_QUERY_PASSPORT_CONFIG              78L
#define HTTP_QUERY_MAX                          78L
#define HTTP_QUERY_CUSTOM                       65535L

/* HTTP query flags */
#define HTTP_QUERY_FLAG_REQUEST_HEADERS 0x80000000L
#define HTTP_QUERY_FLAG_SYSTEMTIME      0x40000000L
#define HTTP_QUERY_FLAG_NUMBER          0x20000000L
#define HTTP_QUERY_FLAG_COALESCE        0x10000000L
#define HTTP_QUERY_FLAG_NUMBER64        0x08000000L
#define HTTP_QUERY_MODIFIER_FLAGS_MASK \
    (HTTP_QUERY_FLAG_REQUEST_HEADERS | HTTP_QUERY_FLAG_SYSTEMTIME | \
    HTTP_QUERY_FLAG_NUMBER | HTTP_QUERY_FLAG_COALESCE | HTTP_QUERY_FLAG_NUMBER64)
#define HTTP_QUERY_HEADER_MASK          (~HTTP_QUERY_MODIFIER_FLAGS_MASK)

/* Internet cookie flags */
#define INTERNET_COOKIE_IS_SECURE       0x00000001L
#define INTERNET_COOKIE_IS_SESSION      0x00000002L
#define INTERNET_COOKIE_THIRD_PARTY     0x00000010L
#define INTERNET_COOKIE_PROMPT_REQUIRED 0x00000020L
#define INTERNET_COOKIE_EVALUATE_P3P    0x00000040L
#define INTERNET_COOKIE_APPLY_P3P       0x00000080L
#define INTERNET_COOKIE_P3P_ENABLED     0x00000100L
#define INTERNET_COOKIE_IS_RESTRICTED   0x00000200L
#define INTERNET_COOKIE_IE6             0x00000400L
#define INTERNET_COOKIE_IS_LEGACY       0x00000800L
#define INTERNET_COOKIE_NON_SCRIPT      0x00001000L
#define INTERNET_COOKIE_HTTPONLY        0x00002000L

/* HTTP response status codes */
#define HTTP_STATUS_CONTINUE            100
#define HTTP_STATUS_SWITCH_PROTOCOLS    101
#define HTTP_STATUS_OK                  200
#define HTTP_STATUS_CREATED             201
#define HTTP_STATUS_ACCEPTED            202
#define HTTP_STATUS_PARTIAL             203
#define HTTP_STATUS_NO_CONTENT          204
#define HTTP_STATUS_RESET_CONTENT       205
#define HTTP_STATUS_PARTIAL_CONTENT     206
#define HTTP_STATUS_AMBIGUOUS           300
#define HTTP_STATUS_MOVED               301
#define HTTP_STATUS_REDIRECT            302
#define HTTP_STATUS_REDIRECT_METHOD     303
#define HTTP_STATUS_NOT_MODIFIED        304
#define HTTP_STATUS_USE_PROXY           305
#define HTTP_STATUS_REDIRECT_KEEP_VERB  307
#define HTTP_STATUS_BAD_REQUEST         400
#define HTTP_STATUS_DENIED              401
#define HTTP_STATUS_PAYMENT_REQ         402
#define HTTP_STATUS_FORBIDDEN           403
#define HTTP_STATUS_NOT_FOUND           404
#define HTTP_STATUS_BAD_METHOD          405
#define HTTP_STATUS_NONE_ACCEPTABLE     406
#define HTTP_STATUS_PROXY_AUTH_REQ      407
#define HTTP_STATUS_REQUEST_TIMEOUT     408
#define HTTP_STATUS_CONFLICT            409
#define HTTP_STATUS_GONE                410
#define HTTP_STATUS_LENGTH_REQUIRED     411
#define HTTP_STATUS_PRECOND_FAILED      412
#define HTTP_STATUS_REQUEST_TOO_LARGE   413
#define HTTP_STATUS_URI_TOO_LONG        414
#define HTTP_STATUS_UNSUPPORTED_MEDIA   415
#define HTTP_STATUS_RETRY_WITH          449
#define HTTP_STATUS_SERVER_ERROR        500
#define HTTP_STATUS_NOT_SUPPORTED       501
#define HTTP_STATUS_BAD_GATEWAY         502
#define HTTP_STATUS_SERVICE_UNAVAIL     503
#define HTTP_STATUS_GATEWAY_TIMEOUT     504
#define HTTP_STATUS_VERSION_NOT_SUP     505
#define HTTP_STATUS_FIRST               HTTP_STATUS_CONTINUE
#define HTTP_STATUS_LAST                HTTP_STATUS_VERSION_NOT_SUP

/* HttpAddRequestHeaders() flags */
#define HTTP_ADDREQ_INDEX_MASK                      0x0000FFFFL
#define HTTP_ADDREQ_FLAGS_MASK                      0xFFFF0000L
#define HTTP_ADDREQ_FLAG_ADD_IF_NEW                 0x10000000L
#define HTTP_ADDREQ_FLAG_ADD                        0x20000000L
#define HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA        0x40000000L
#define HTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON    0x01000000L
#define HTTP_ADDREQ_FLAG_COALESCE                   HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA
#define HTTP_ADDREQ_FLAG_REPLACE                    0x80000000L

/* HttpSendRequestEx() flags */
#define HSR_ASYNC       WININET_API_FLAG_ASYNC
#define HSR_SYNC        WININET_API_FLAG_SYNC
#define HSR_USE_CONTEXT WININET_API_FLAG_USE_CONTEXT
#define HSR_INITIATE    0x00000008L
#define HSR_DOWNLOAD    0x00000010L
#define HSR_CHUNKED     0x00000020L

/* InternetCheckConnection() flags */
#define FLAG_ICC_FORCE_CONNECTION   0x00000001L

/* InternetErrorDlg() flags */
#define FLAGS_ERROR_UI_FILTER_FOR_ERRORS    0x00000001L
#define FLAGS_ERROR_UI_FLAGS_CHANGE_OPTIONS 0x00000002L
#define FLAGS_ERROR_UI_FLAGS_GENERATE_DATA  0x00000004L
#define FLAGS_ERROR_UI_FLAGS_NO_UI          0x00000008L
#define FLAGS_ERROR_UI_SERIALIZE_DIALOGS    0x00000010L

/* Internet error codes */
#define INTERNET_ERROR_BASE                     12000L
#define ERROR_INTERNET_OUT_OF_HANDLES           (INTERNET_ERROR_BASE + 1)
#define ERROR_INTERNET_TIMEOUT                  (INTERNET_ERROR_BASE + 2)
#define ERROR_INTERNET_EXTENDED_ERROR           (INTERNET_ERROR_BASE + 3)
#define ERROR_INTERNET_INTERNAL_ERROR           (INTERNET_ERROR_BASE + 4)
#define ERROR_INTERNET_INVALID_URL              (INTERNET_ERROR_BASE + 5)
#define ERROR_INTERNET_UNRECOGNIZED_SCHEME      (INTERNET_ERROR_BASE + 6)
#define ERROR_INTERNET_NAME_NOT_RESOLVED        (INTERNET_ERROR_BASE + 7)
#define ERROR_INTERNET_PROTOCOL_NOT_FOUND       (INTERNET_ERROR_BASE + 8)
#define ERROR_INTERNET_INVALID_OPTION           (INTERNET_ERROR_BASE + 9)
#define ERROR_INTERNET_BAD_OPTION_LENGTH        (INTERNET_ERROR_BASE + 10)
#define ERROR_INTERNET_OPTION_NOT_SETTABLE      (INTERNET_ERROR_BASE + 11)
#define ERROR_INTERNET_SHUTDOWN                 (INTERNET_ERROR_BASE + 12)
#define ERROR_INTERNET_INCORRECT_USER_NAME      (INTERNET_ERROR_BASE + 13)
#define ERROR_INTERNET_INCORRECT_PASSWORD       (INTERNET_ERROR_BASE + 14)
#define ERROR_INTERNET_LOGIN_FAILURE            (INTERNET_ERROR_BASE + 15)
#define ERROR_INTERNET_INVALID_OPERATION        (INTERNET_ERROR_BASE + 16)
#define ERROR_INTERNET_OPERATION_CANCELLED      (INTERNET_ERROR_BASE + 17)
#define ERROR_INTERNET_INCORRECT_HANDLE_TYPE    (INTERNET_ERROR_BASE + 18)
#define ERROR_INTERNET_INCORRECT_HANDLE_STATE   (INTERNET_ERROR_BASE + 19)
#define ERROR_INTERNET_NOT_PROXY_REQUEST        (INTERNET_ERROR_BASE + 20)
#define ERROR_INTERNET_REGISTRY_VALUE_NOT_FOUND (INTERNET_ERROR_BASE + 21)
#define ERROR_INTERNET_BAD_REGISTRY_PARAMETER   (INTERNET_ERROR_BASE + 22)
#define ERROR_INTERNET_NO_DIRECT_ACCESS         (INTERNET_ERROR_BASE + 23)
#define ERROR_INTERNET_NO_CONTEXT               (INTERNET_ERROR_BASE + 24)
#define ERROR_INTERNET_NO_CALLBACK              (INTERNET_ERROR_BASE + 25)
#define ERROR_INTERNET_REQUEST_PENDING          (INTERNET_ERROR_BASE + 26)
#define ERROR_INTERNET_INCORRECT_FORMAT         (INTERNET_ERROR_BASE + 27)
#define ERROR_INTERNET_ITEM_NOT_FOUND           (INTERNET_ERROR_BASE + 28)
#define ERROR_INTERNET_CANNOT_CONNECT           (INTERNET_ERROR_BASE + 29)
#define ERROR_INTERNET_CONNECTION_ABORTED       (INTERNET_ERROR_BASE + 30)
#define ERROR_INTERNET_CONNECTION_RESET         (INTERNET_ERROR_BASE + 31)
#define ERROR_INTERNET_FORCE_RETRY              (INTERNET_ERROR_BASE + 32)
#define ERROR_INTERNET_INVALID_PROXY_REQUEST    (INTERNET_ERROR_BASE + 33)
#define ERROR_INTERNET_NEED_UI                  (INTERNET_ERROR_BASE + 34)
#define ERROR_INTERNET_HANDLE_EXISTS            (INTERNET_ERROR_BASE + 36)
#define ERROR_INTERNET_SEC_CERT_DATE_INVALID    (INTERNET_ERROR_BASE + 37)
#define ERROR_INTERNET_SEC_CERT_CN_INVALID      (INTERNET_ERROR_BASE + 38)
#define ERROR_INTERNET_HTTP_TO_HTTPS_ON_REDIR   (INTERNET_ERROR_BASE + 39)
#define ERROR_INTERNET_HTTPS_TO_HTTP_ON_REDIR   (INTERNET_ERROR_BASE + 40)
#define ERROR_INTERNET_MIXED_SECURITY           (INTERNET_ERROR_BASE + 41)
#define ERROR_INTERNET_CHG_POST_IS_NON_SECURE   (INTERNET_ERROR_BASE + 42)
#define ERROR_INTERNET_POST_IS_NON_SECURE       (INTERNET_ERROR_BASE + 43)
#define ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED  (INTERNET_ERROR_BASE + 44)
#define ERROR_INTERNET_INVALID_CA               (INTERNET_ERROR_BASE + 45)
#define ERROR_INTERNET_CLIENT_AUTH_NOT_SETUP    (INTERNET_ERROR_BASE + 46)
#define ERROR_INTERNET_ASYNC_THREAD_FAILED      (INTERNET_ERROR_BASE + 47)
#define ERROR_INTERNET_REDIRECT_SCHEME_CHANGE   (INTERNET_ERROR_BASE + 48)
#define ERROR_INTERNET_DIALOG_PENDING           (INTERNET_ERROR_BASE + 49)
#define ERROR_INTERNET_RETRY_DIALOG             (INTERNET_ERROR_BASE + 50)
#define ERROR_INTERNET_HTTPS_HTTP_SUBMIT_REDIR  (INTERNET_ERROR_BASE + 52)
#define ERROR_INTERNET_INSERT_CDROM             (INTERNET_ERROR_BASE + 53)
#define ERROR_INTERNET_FORTEZZA_LOGIN_NEEDED    (INTERNET_ERROR_BASE + 54)
#define ERROR_INTERNET_SEC_CERT_ERRORS          (INTERNET_ERROR_BASE + 55)
#define ERROR_INTERNET_SEC_CERT_NO_REV          (INTERNET_ERROR_BASE + 56)
#define ERROR_INTERNET_SEC_CERT_REV_FAILED      (INTERNET_ERROR_BASE + 57)
#define ERROR_FTP_TRANSFER_IN_PROGRESS          (INTERNET_ERROR_BASE + 110)
#define ERROR_FTP_DROPPED                       (INTERNET_ERROR_BASE + 111)
#define ERROR_FTP_NO_PASSIVE_MODE               (INTERNET_ERROR_BASE + 112)
#define ERROR_GOPHER_PROTOCOL_ERROR             (INTERNET_ERROR_BASE + 130)
#define ERROR_GOPHER_NOT_FILE                   (INTERNET_ERROR_BASE + 131)
#define ERROR_GOPHER_DATA_ERROR                 (INTERNET_ERROR_BASE + 132)
#define ERROR_GOPHER_END_OF_DATA                (INTERNET_ERROR_BASE + 133)
#define ERROR_GOPHER_INVALID_LOCATOR            (INTERNET_ERROR_BASE + 134)
#define ERROR_GOPHER_INCORRECT_LOCATOR_TYPE     (INTERNET_ERROR_BASE + 135)
#define ERROR_GOPHER_NOT_GOPHER_PLUS            (INTERNET_ERROR_BASE + 136)
#define ERROR_GOPHER_ATTRIBUTE_NOT_FOUND        (INTERNET_ERROR_BASE + 137)
#define ERROR_GOPHER_UNKNOWN_LOCATOR            (INTERNET_ERROR_BASE + 138)
#define ERROR_HTTP_HEADER_NOT_FOUND             (INTERNET_ERROR_BASE + 150)
#define ERROR_HTTP_DOWNLEVEL_SERVER             (INTERNET_ERROR_BASE + 151)
#define ERROR_HTTP_INVALID_SERVER_RESPONSE      (INTERNET_ERROR_BASE + 152)
#define ERROR_HTTP_INVALID_HEADER               (INTERNET_ERROR_BASE + 153)
#define ERROR_HTTP_INVALID_QUERY_REQUEST        (INTERNET_ERROR_BASE + 154)
#define ERROR_HTTP_HEADER_ALREADY_EXISTS        (INTERNET_ERROR_BASE + 155)
#define ERROR_HTTP_REDIRECT_FAILED              (INTERNET_ERROR_BASE + 156)
#define ERROR_HTTP_NOT_REDIRECTED               (INTERNET_ERROR_BASE + 160)
#define ERROR_HTTP_COOKIE_NEEDS_CONFIRMATION    (INTERNET_ERROR_BASE + 161)
#define ERROR_HTTP_COOKIE_DECLINED              (INTERNET_ERROR_BASE + 162)
#define ERROR_HTTP_REDIRECT_NEEDS_CONFIRMATION  (INTERNET_ERROR_BASE + 168)
#define ERROR_INTERNET_SECURITY_CHANNEL_ERROR   (INTERNET_ERROR_BASE + 157)
#define ERROR_INTERNET_UNABLE_TO_CACHE_FILE     (INTERNET_ERROR_BASE + 158)
#define ERROR_INTERNET_TCPIP_NOT_INSTALLED      (INTERNET_ERROR_BASE + 159)
#define ERROR_INTERNET_DISCONNECTED             (INTERNET_ERROR_BASE + 163)
#define ERROR_INTERNET_SERVER_UNREACHABLE       (INTERNET_ERROR_BASE + 164)
#define ERROR_INTERNET_PROXY_SERVER_UNREACHABLE (INTERNET_ERROR_BASE + 165)
#define ERROR_INTERNET_BAD_AUTO_PROXY_SCRIPT    (INTERNET_ERROR_BASE + 166)
#define ERROR_INTERNET_UNABLE_TO_DOWNLOAD_SCRIPT    (INTERNET_ERROR_BASE + 167)
#define ERROR_INTERNET_SEC_INVALID_CERT         (INTERNET_ERROR_BASE + 169)
#define ERROR_INTERNET_SEC_CERT_REVOKED         (INTERNET_ERROR_BASE + 170)
#define ERROR_INTERNET_FAILED_DUETOSECURITYCHECK    (INTERNET_ERROR_BASE + 171)
#define ERROR_INTERNET_NOT_INITIALIZED          (INTERNET_ERROR_BASE + 172)
#define ERROR_INTERNET_NEED_MSN_SSPI_PKG        (INTERNET_ERROR_BASE + 173)
#define ERROR_INTERNET_LOGIN_FAILURE_DISPLAY_ENTITY_BODY    (INTERNET_ERROR_BASE + 174)
#define ERROR_INTERNET_DECODING_FAILED          (INTERNET_ERROR_BASE + 175)
#define INTERNET_ERROR_LAST                     ERROR_INTERNET_DECODING_FAILED

/* Cache entry type flags */
#define NORMAL_CACHE_ENTRY          0x00000001L
#define STICKY_CACHE_ENTRY          0x00000004L
#define EDITED_CACHE_ENTRY          0x00000008L
#define TRACK_OFFLINE_CACHE_ENTRY   0x00000010L
#define TRACK_ONLINE_CACHE_ENTRY    0x00000020L
#define SPARSE_CACHE_ENTRY          0x00010000L
#define COOKIE_CACHE_ENTRY          0x00100000L
#define URLHISTORY_CACHE_ENTRY      0x00200000L
#define URLCACHE_FIND_DEFAULT_FILTER \
    (NORMAL_CACHE_ENTRY | COOKIE_CACHE_ENTRY | URLHISTORY_CACHE_ENTRY | \
    TRACK_OFFLINE_CACHE_ENTRY | TRACK_ONLINE_CACHE_ENTRY | STICKY_CACHE_ENTRY)

/* Cache group attribute flags */
#define CACHEGROUP_ATTRIBUTE_GET_ALL    0xFFFFFFFFL
#define CACHEGROUP_ATTRIBUTE_BASIC      0x00000001L
#define CACHEGROUP_ATTRIBUTE_FLAG       0x00000002L
#define CACHEGROUP_ATTRIBUTE_TYPE       0x00000004L
#define CACHEGROUP_ATTRIBUTE_QUOTA      0x00000008L
#define CACHEGROUP_ATTRIBUTE_GROUPNAME  0x00000010L
#define CACHEGROUP_ATTRIBUTE_STORAGE    0x00000020L
#define CACHEGROUP_READWRITE_MASK \
    (CACHEGROUP_ATTRIBUTE_TYPE | CACHEGROUP_ATTRIBUTE_QUOTA | \
    CACHEGROUP_ATTRIBUTE_GROUPNAME | CACHEGROUP_ATTRIBUTE_STORAGE)

/* Cache group flags */
#define CACHEGROUP_FLAG_NONPURGEABLE        0x00000001L
#define CACHEGROUP_FLAG_FLUSHURL_ONDELETE   0x00000002L
#define CACHEGROUP_FLAG_GIDONLY             0x00000004L

/* Cache group search flags */
#define CACHEGROUP_SEARCH_ALL   0x00000000L
#define CACHEGROUP_SEARCH_BYURL 0x00000001L

/* Cache group types */
#define CACHEGROUP_TYPE_INVALID 0x00000001L

/* Cache entry field control flags */
#define CACHE_ENTRY_ATTRIBUTE_FC    0x00000004L
#define CACHE_ENTRY_HITRATE_FC      0x00000010L
#define CACHE_ENTRY_MODTIME_FC      0x00000040L
#define CACHE_ENTRY_EXPTIME_FC      0x00000080L
#define CACHE_ENTRY_ACCTIME_FC      0x00000100L
#define CACHE_ENTRY_SYNCTIME_FC     0x00000200L
#define CACHE_ENTRY_HEADERINFO_FC   0x00000400L
#define CACHE_ENTRY_EXEMPT_DELTA_FC 0x00000800L

/* SetUrlCacheEntryGroup() flags */
#define INTERNET_CACHE_GROUP_ADD    0L
#define INTERNET_CACHE_GROUP_REMOVE 1L

/* InternetDial() flags */
#define INTERNET_DIAL_FORCE_PROMPT  0x00002000L
#define INTERNET_DIAL_SHOW_OFFLINE  0x00004000L
#define INTERNET_DIAL_UNATTENDED    0x00008000L

/* InternetGoOnline() flags */
#define INTERNET_GOONLINE_REFRESH   0x00000001L
#define INTERNET_GOONLINE_MASK      0x00000001L

/* InternetAutodial() flags */
#define INTERNET_AUTODIAL_FORCE_ONLINE          1L
#define INTERNET_AUTODIAL_FORCE_UNATTENDED      2L
#define INTERNET_AUTODIAL_FAILIFSECURITYCHECK   4L
#define INTERNET_AUTODIAL_OVERRIDE_NET_PRESENT  8L
#define INTERNET_AUTODIAL_FLAGS_MASK \
    (INTERNET_AUTODIAL_FORCE_ONLINE | INTERNET_AUTODIAL_FORCE_UNATTENDED | \
    INTERNET_AUTODIAL_FAILIFSECURITYCHECK | INTERNET_AUTODIAL_OVERRIDE_NET_PRESENT)

/* Proxy auto-detect types */
#define PROXY_AUTO_DETECT_TYPE_DHCP     1L
#define PROXY_AUTO_DETECT_TYPE_DNS_A    2L

/* InternetGetConnectedState() flags */
#define INTERNET_CONNECTION_MODEM       0x00000001L
#define INTERNET_CONNECTION_LAN         0x00000002L
#define INTERNET_CONNECTION_PROXY       0x00000004L
#define INTERNET_CONNECTION_MODEM_BUSY  0x00000008L
#define INTERNET_RAS_INSTALLED          0x00000010L
#define INTERNET_CONNECTION_OFFLINE     0x00000020L
#define INTERNET_CONNECTION_CONFIGURED  0x00000040L

/* Dial handler flags */
#define INTERNET_CUSTOMDIAL_CONNECT     0L
#define INTERNET_CUSTOMDIAL_UNATTENDED  1L
#define INTERNET_CUSTOMDIAL_DISCONNECT  2L
#define INTERNET_CUSTOMDIAL_SHOWOFFLINE 4L

/* Dial handler supported functionality flags */
#define INTERNET_CUSTOMDIAL_SAFE_FOR_UNATTENDED 1L
#define INTERNET_CUSTOMDIAL_WILL_SUPPLY_STATE   2L
#define INTERNET_CUSTOMDIAL_CAN_HANGUP          4L

/* InternetSetDialState() flags */
#define INTERNET_DIALSTATE_DISCONNECTED 1L

/* Internet identity flags */
#define INTERNET_IDENTITY_FLAG_PRIVATE_CACHE    0x00000001L
#define INTERNET_IDENTITY_FLAG_SHARED_CACHE     0x00000002L
#define INTERNET_IDENTITY_FLAG_CLEAR_DATA       0x00000004L
#define INTERNET_IDENTITY_FLAG_CLEAR_COOKIES    0x00000008L
#define INTERNET_IDENTITY_FLAG_CLEAR_HISTORY    0x00000010L
#define INTERNET_IDENTITY_FLAG_CLEAR_CONTENT    0x00000020L

/* Internet suppress flags */
#define INTERNET_SUPPRESS_RESET_ALL             0x00000000L
#define INTERNET_SUPPRESS_COOKIE_POLICY         0x00000001L
#define INTERNET_SUPPRESS_COOKIE_POLICY_RESET   0x00000002L

/* Privacy template flags */
#define PRIVACY_TEMPLATE_NO_COOKIES     0L
#define PRIVACY_TEMPLATE_HIGH           1L
#define PRIVACY_TEMPLATE_MEDIUM_HIGH    2L
#define PRIVACY_TEMPLATE_MEDIUM         3L
#define PRIVACY_TEMPLATE_MEDIUM_LOW     4L
#define PRIVACY_TEMPLATE_LOW            5L
#define PRIVACY_TEMPLATE_CUSTOM         100L
#define PRIVACY_TEMPLATE_ADVANCED       101L
#define PRIVACY_TEMPLATE_MAX            PRIVACY_TEMPLATE_LOW

/* Privacy types */
#define PRIVACY_TYPE_FIRST_PARTY    0L
#define PRIVACY_TYPE_THIRD_PARTY    1L

/* Internet schemes */
typedef enum {
    INTERNET_SCHEME_PARTIAL     = -2,
    INTERNET_SCHEME_UNKNOWN     = -1,
    INTERNET_SCHEME_DEFAULT     = 0,
    INTERNET_SCHEME_FTP         = 1,
    INTERNET_SCHEME_GOPHER      = 2,
    INTERNET_SCHEME_HTTP        = 3,
    INTERNET_SCHEME_HTTPS       = 4,
    INTERNET_SCHEME_FILE        = 5,
    INTERNET_SCHEME_NEWS        = 6,
    INTERNET_SCHEME_MAILTO      = 7,
    INTERNET_SCHEME_SOCKS       = 8,
    INTERNET_SCHEME_JAVASCRIPT  = 9,
    INTERNET_SCHEME_VBSCRIPT    = 10,
    INTERNET_SCHEME_RES         = 11,
    INTERNET_SCHEME_FIRST       = INTERNET_SCHEME_FTP,
    INTERNET_SCHEME_LAST        = INTERNET_SCHEME_RES
} INTERNET_SCHEME;
typedef INTERNET_SCHEME *LPINTERNET_SCHEME;

/* Internet asynchronous result */
typedef struct {
    DWORD_PTR   dwResult;
    DWORD       dwError;
} INTERNET_ASYNC_RESULT;
typedef INTERNET_ASYNC_RESULT   *LPINTERNET_ASYNC_RESULT;

/* Internet diagnostic socket information */
typedef struct {
    DWORD_PTR   Socket;
    DWORD       SourcePort;
    DWORD       DestPort;
    DWORD       Flags;
} INTERNET_DIAGNOSTIC_SOCKET_INFO;
typedef INTERNET_DIAGNOSTIC_SOCKET_INFO *LPINTERNET_DIAGNOSTIC_SOCKET_INFO;

/* Internet proxy information */
typedef struct {
    DWORD   dwAccessType;
    LPCTSTR lpszProxy;
    LPCTSTR lpszProxyBypass;
} INTERNET_PROXY_INFO;
typedef INTERNET_PROXY_INFO *LPINTERNET_PROXY_INFO;

/* Internet per connection option */
typedef struct {
    DWORD   dwOption;
    union {
        DWORD       dwValue;
        LPSTR       pszValue;
        FILETIME    ftValue;
    } Value;
} INTERNET_PER_CONN_OPTIONA;
typedef INTERNET_PER_CONN_OPTIONA   *LPINTERNET_PER_CONN_OPTIONA;
typedef struct {
    DWORD   dwOption;
    union {
        DWORD       dwValue;
        LPWSTR      pszValue;
        FILETIME    ftValue;
    } Value;
} INTERNET_PER_CONN_OPTIONW;
typedef INTERNET_PER_CONN_OPTIONW   *LPINTERNET_PER_CONN_OPTIONW;
#ifdef UNICODE
typedef INTERNET_PER_CONN_OPTIONW   INTERNET_PER_CONN_OPTION;
typedef LPINTERNET_PER_CONN_OPTIONW LPINTERNET_PER_CONN_OPTION;
#else
typedef INTERNET_PER_CONN_OPTIONA   INTERNET_PER_CONN_OPTION;
typedef LPINTERNET_PER_CONN_OPTIONA LPINTERNET_PER_CONN_OPTION;
#endif

/* Internet per connection option list */
typedef struct {
    DWORD                       dwSize;
    LPSTR                       pszConnection;
    DWORD                       dwOptionCount;
    DWORD                       dwOptionError;
    LPINTERNET_PER_CONN_OPTIONA pOptions;
} INTERNET_PER_CONN_OPTION_LISTA;
typedef INTERNET_PER_CONN_OPTION_LISTA      *LPINTERNET_PER_CONN_OPTION_LISTA;
typedef struct {
    DWORD                       dwSize;
    LPWSTR                      pszConnection;
    DWORD                       dwOptionCount;
    DWORD                       dwOptionError;
    LPINTERNET_PER_CONN_OPTIONW pOptions;
} INTERNET_PER_CONN_OPTION_LISTW;
typedef INTERNET_PER_CONN_OPTION_LISTW      *LPINTERNET_PER_CONN_OPTION_LISTW;
#ifdef UNICODE
typedef INTERNET_PER_CONN_OPTION_LISTW      INTERNET_PER_CONN_OPTION_LIST;
typedef LPINTERNET_PER_CONN_OPTION_LISTW    LPINTERNET_PER_CONN_OPTION_LIST;
#else
typedef INTERNET_PER_CONN_OPTION_LISTA      INTERNET_PER_CONN_OPTION_LIST;
typedef LPINTERNET_PER_CONN_OPTION_LISTA    LPINTERNET_PER_CONN_OPTION_LIST;
#endif

/* Internet version information */
typedef struct {
    DWORD   dwMajorVersion;
    DWORD   dwMinorVersion;
} INTERNET_VERSION_INFO;
typedef INTERNET_VERSION_INFO   *LPINTERNET_VERSION_INFO;

/* HTTP version information */
typedef struct {
    DWORD   dwMajorVersion;
    DWORD   dwMinorVersion;
} HTTP_VERSION_INFO;
typedef HTTP_VERSION_INFO   *LPHTTP_VERSION_INFO;

/* Internet connected information */
typedef struct {
    DWORD   dwConnectedState;
    DWORD   dwFlags;
} INTERNET_CONNECTED_INFO;
typedef INTERNET_CONNECTED_INFO *LPINTERNET_CONNECTED_INFO;

/* URL components */
typedef struct {
    DWORD           dwStructSize;
    LPSTR           lpszScheme;
    DWORD           dwSchemeLength;
    INTERNET_SCHEME nScheme;
    LPSTR           lpszHostName;
    DWORD           dwHostNameLength;
    INTERNET_PORT   nPort;
    LPSTR           lpszUserName;
    DWORD           dwUserNameLength;
    LPSTR           lpszPassword;
    DWORD           dwPasswordLength;
    LPSTR           lpszUrlPath;
    DWORD           dwUrlPathLength;
    LPSTR           lpszExtraInfo;
    DWORD           dwExtraInfoLength;
} URL_COMPONENTSA;
typedef URL_COMPONENTSA     *LPURL_COMPONENTSA;
typedef struct {
    DWORD           dwStructSize;
    LPWSTR          lpszScheme;
    DWORD           dwSchemeLength;
    INTERNET_SCHEME nScheme;
    LPWSTR          lpszHostName;
    DWORD           dwHostNameLength;
    INTERNET_PORT   nPort;
    LPWSTR          lpszUserName;
    DWORD           dwUserNameLength;
    LPWSTR          lpszPassword;
    DWORD           dwPasswordLength;
    LPWSTR          lpszUrlPath;
    DWORD           dwUrlPathLength;
    LPWSTR          lpszExtraInfo;
    DWORD           dwExtraInfoLength;
} URL_COMPONENTSW;
typedef URL_COMPONENTSW     *LPURL_COMPONENTSW;
#ifdef UNICODE
typedef URL_COMPONENTSW     URL_COMPONENTS;
typedef LPURL_COMPONENTSW   LPURL_COMPONENTS;
#else
typedef URL_COMPONENTSA     URL_COMPONENTS;
typedef LPURL_COMPONENTSA   LPURL_COMPONENTS;
#endif

/* Internet certificate information */
typedef struct {
    FILETIME    ftExpiry;
    FILETIME    ftStart;
    LPTSTR      lpszSubjectInfo;
    LPTSTR      lpszIssuerInfo;
    LPTSTR      lpszProtocolName;
    LPTSTR      lpszSignatureAlgorithm;
    LPTSTR      lpszEncryptionAlgName;
    DWORD       dwKeyName;
} INTERNET_CERTIFICATE_INFO;
typedef INTERNET_CERTIFICATE_INFO   *LPINTERNET_CERTIFICATE_INFO;

/* Internet buffers */
typedef struct _INTERNET_BUFFERSA {
    DWORD                       dwStructSize;
    struct _INTERNET_BUFFERSA   *Next;
    LPCSTR                      lpcszHeader;
    DWORD                       dwHeadersLength;
    DWORD                       dwHeadersTotal;
    LPVOID                      lpvBuffer;
    DWORD                       dwBufferLength;
    DWORD                       dwBufferTotal;
    DWORD                       dwOffsetLow;
    DWORD                       dwOffsetHigh;
} INTERNET_BUFFERSA;
typedef INTERNET_BUFFERSA   *LPINTERNET_BUFFERSA;
typedef struct _INTERNET_BUFFERSW {
    DWORD                       dwStructSize;
    struct _INTERNET_BUFFERSW   *Next;
    LPCWSTR                     lpcszHeader;
    DWORD                       dwHeadersLength;
    DWORD                       dwHeadersTotal;
    LPVOID                      lpvBuffer;
    DWORD                       dwBufferLength;
    DWORD                       dwBufferTotal;
    DWORD                       dwOffsetLow;
    DWORD                       dwOffsetHigh;
} INTERNET_BUFFERSW;
typedef INTERNET_BUFFERSW   *LPINTERNET_BUFFERSW;
#ifdef UNICODE
typedef INTERNET_BUFFERSW   INTERNET_BUFFERS;
typedef LPINTERNET_BUFFERSW LPINTERNET_BUFFERS;
#else
typedef INTERNET_BUFFERSA   INTERNET_BUFFERS;
typedef LPINTERNET_BUFFERSA LPINTERNET_BUFFERS;
#endif

/* Internet status callback */
typedef VOID (CALLBACK *INTERNET_STATUS_CALLBACK)( HINTERNET, DWORD_PTR, DWORD, LPVOID, DWORD );
typedef INTERNET_STATUS_CALLBACK            *LPINTERNET_STATUS_CALLBACK;
#define INTERNET_INVALID_STATUS_CALLBACK    ((INTERNET_STATUS_CALLBACK)-1L)

/* Internet cookie states */
typedef enum {
    COOKIE_STATE_UNKNOWN    = 0x00000000,
    COOKIE_STATE_ACCEPT     = 0x00000001,
    COOKIE_STATE_PROMPT     = 0x00000002,
    COOKIE_STATE_LEASH      = 0x00000003,
    COOKIE_STATE_DOWNGRADE  = 0x00000004,
    COOKIE_STATE_REJECT     = 0x00000005,
    COOKIE_STATE_MAX        = COOKIE_STATE_REJECT
} InternetCookieState;

/* Incoming cookie state */
typedef struct {
    int         cSession;
    int         cPersistent;
    int         cAccepted;
    int         cLeashed;
    int         cDowngraded;
    int         cBlocked;
    const char  *pszLocation;
} IncomingCookieState;

/* Outgoing cookie state */
typedef struct {
    int         cSent;
    int         cSuppressed;
    const char  *pszLocation;
} OutgoingCookieState;

/* Internet cookie history */
typedef struct {
    BOOL    fAccepted;
    BOOL    fLeashed;
    BOOL    fDowngraded;
    BOOL    fRejected;
} InternetCookieHistory;

/* Cookie decision */
typedef struct {
    DWORD   dwCookieState;
    BOOL    fAllowSession;
} CookieDecision;

/* Gopher find data */
typedef struct {
    CHAR        DisplayString[MAX_GOPHER_DISPLAY_TEXT + 1];
    DWORD       GopherType;
    DWORD       SizeLow;
    DWORD       SizeHigh;
    FILETIME    LastModificationTime;
    CHAR        Locator[MAX_GOPHER_LOCATOR_LENGTH + 1];
} GOPHER_FIND_DATAA;
typedef GOPHER_FIND_DATAA   *LPGOPHER_FIND_DATAA;
typedef struct {
    WCHAR       DisplayString[MAX_GOPHER_DISPLAY_TEXT + 1];
    DWORD       GopherType;
    DWORD       SizeLow;
    DWORD       SizeHigh;
    FILETIME    LastModificationTime;
    WCHAR       Locator[MAX_GOPHER_LOCATOR_LENGTH + 1];
} GOPHER_FIND_DATAW;
typedef GOPHER_FIND_DATAW   *LPGOPHER_FIND_DATAW;
#ifdef UNICODE
typedef GOPHER_FIND_DATAW   GOPHER_FIND_DATA;
typedef LPGOPHER_FIND_DATAW LPGOPHER_FIND_DATA;
#else
typedef GOPHER_FIND_DATAA   GOPHER_FIND_DATA;
typedef LPGOPHER_FIND_DATAA LPGOPHER_FIND_DATA;
#endif

/* Gopher administrative attribute type */
typedef struct {
    LPCTSTR Comment;
    LPCTSTR EmailAddress;
} GOPHER_ADMIN_ATTRIBUTE_TYPE;
typedef GOPHER_ADMIN_ATTRIBUTE_TYPE *LPGOPHER_ADMIN_ATTRIBUTE_TYPE;

/* Gopher modified date attribute type */
typedef struct {
    FILETIME    DateAndTime;
} GOPHER_MOD_DATE_ATTRIBUTE_TYPE;
typedef GOPHER_MOD_DATE_ATTRIBUTE_TYPE  *LPGOPHER_MOD_DATE_ATTRIBUTE_TYPE;

/* Gopher TTL attribute type */
typedef struct {
    DWORD   Ttl;
} GOPHER_TTL_ATTRIBUTE_TYPE;
typedef GOPHER_TTL_ATTRIBUTE_TYPE   *LPGOPHER_TTL_ATTRIBUTE_TYPE;

/* Gopher score attribute type */
typedef struct {
    INT Score;
} GOPHER_SCORE_ATTRIBUTE_TYPE;
typedef GOPHER_SCORE_ATTRIBUTE_TYPE *LPGOPHER_SCORE_ATTRIBUTE_TYPE;

/* Gopher score range attribute type */
typedef struct {
    INT LowerBound;
    INT UpperBound;
} GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE;
typedef GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE   *LPGOPHER_SCORE_RANGE_ATTRIBUTE_TYPE;

/* Gopher site attribute type */
typedef struct {
    LPCTSTR Site;
} GOPHER_SITE_ATTRIBUTE_TYPE;
typedef GOPHER_SITE_ATTRIBUTE_TYPE  *LPGOPHER_SITE_ATTRIBUTE_TYPE;

/* Gopher organization attribute type */
typedef struct {
    LPCTSTR Organization;
} GOPHER_ORGANIZATION_ATTRIBUTE_TYPE;
typedef GOPHER_ORGANIZATION_ATTRIBUTE_TYPE  *LPGOPHER_ORGANIZATION_ATTRIBUTE_TYPE;

/* Gopher location attribute type */
typedef struct {
    LPCTSTR Location;
} GOPHER_LOCATION_ATTRIBUTE_TYPE;
typedef GOPHER_LOCATION_ATTRIBUTE_TYPE  *LPGOPHER_LOCATION_ATTRIBUTE_TYPE;

/* Gopher geographical location attribute type */
typedef struct {
    INT DegreesNorth;
    INT MinutesNorth;
    INT SecondsNorth;
    INT DegreesEast;
    INT MinutesEast;
    INT SecondsEast;
} GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE;
typedef GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE *LPGOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE;

/* Gopher time zone attribute type */
typedef struct {
    INT Zone;
} GOPHER_TIMEZONE_ATTRIBUTE_TYPE;
typedef GOPHER_TIMEZONE_ATTRIBUTE_TYPE  *LPGOPHER_TIMEZONE_ATTRIBUTE_TYPE;

/* Gopher provider attribute type */
typedef struct {
    LPCTSTR Provider;
} GOPHER_PROVIDER_ATTRIBUTE_TYPE;
typedef GOPHER_PROVIDER_ATTRIBUTE_TYPE  *LPGOPHER_PROVIDER_ATTRIBUTE_TYPE;

/* Gopher version attribute type */
typedef struct {
    LPCTSTR Version;
} GOPHER_VERSION_ATTRIBUTE_TYPE;
typedef GOPHER_VERSION_ATTRIBUTE_TYPE   *LPGOPHER_VERSION_ATTRIBUTE_TYPE;

/* Gopher abstract attribute type */
typedef struct {
    LPCTSTR ShortAbstract;
    LPCTSTR AbstractFile;
} GOPHER_ABSTRACT_ATTRIBUTE_TYPE;
typedef GOPHER_ABSTRACT_ATTRIBUTE_TYPE  *LPGOPHER_ABSTRACT_ATTRIBUTE_TYPE;

/* Gopher view attribute type */
typedef struct {
    LPCTSTR ContentType;
    LPCTSTR Language;
    DWORD   Size;
} GOPHER_VIEW_ATTRIBUTE_TYPE;
typedef GOPHER_VIEW_ATTRIBUTE_TYPE  *LPGOPHER_VIEW_ATTRIBUTE_TYPE;

/* Gopher Veronica attribute type */
typedef struct {
    BOOL    TreeWalk;
} GOPHER_VERONICA_ATTRIBUTE_TYPE;
typedef GOPHER_VERONICA_ATTRIBUTE_TYPE  *LPGOPHER_VERONICA_ATTRIBUTE_TYPE;

/* Gopher ask attribute type */
typedef struct {
    LPCTSTR QuestionType;
    LPCTSTR QuestionText;
} GOPHER_ASK_ATTRIBUTE_TYPE;
typedef GOPHER_ASK_ATTRIBUTE_TYPE   *LPGOPHER_ASK_ATTRIBUTE_TYPE;

/* Gopher unknown attribute type */
typedef struct {
    LPCTSTR Text;
} GOPHER_UNKNOWN_ATTRIBUTE_TYPE;
typedef GOPHER_UNKNOWN_ATTRIBUTE_TYPE   *LPGOPHER_UNKNOWN_ATTRIBUTE_TYPE;

/* Gopher attribute type */
typedef struct {
    DWORD   CategoryId;
    DWORD   AttributeId;
    union {
        GOPHER_ADMIN_ATTRIBUTE_TYPE         Admin;
        GOPHER_MOD_DATE_ATTRIBUTE_TYPE      ModDate;
        GOPHER_TTL_ATTRIBUTE_TYPE           Ttl;
        GOPHER_SCORE_ATTRIBUTE_TYPE         Score;
        GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE   ScoreRange;
        GOPHER_SITE_ATTRIBUTE_TYPE          Site;
        GOPHER_ORGANIZATION_ATTRIBUTE_TYPE  Organization;
        GOPHER_LOCATION_ATTRIBUTE_TYPE      Location;
        GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE GeographicalLocation;
        GOPHER_TIMEZONE_ATTRIBUTE_TYPE      TimeZone;
        GOPHER_PROVIDER_ATTRIBUTE_TYPE      Provider;
        GOPHER_VERSION_ATTRIBUTE_TYPE       Version;
        GOPHER_ABSTRACT_ATTRIBUTE_TYPE      Abstract;
        GOPHER_VIEW_ATTRIBUTE_TYPE          View;
        GOPHER_VERONICA_ATTRIBUTE_TYPE      Veronica;
        GOPHER_ASK_ATTRIBUTE_TYPE           Ask;
        GOPHER_UNKNOWN_ATTRIBUTE_TYPE       Unknown;
    } AttributeType;
} GOPHER_ATTRIBUTE_TYPE;
typedef GOPHER_ATTRIBUTE_TYPE   *LPGOPHER_ATTRIBUTE_TYPE;

/* Gopher attribute enumerator callback */
typedef BOOL (CALLBACK *GOPHER_ATTRIBUTE_ENUMERATOR)( LPGOPHER_ATTRIBUTE_TYPE, DWORD );

/* Authentication notify callback */
typedef DWORD (CALLBACK *PFN_AUTH_NOTIFY)( DWORD_PTR, DWORD, LPVOID );

/* InternetErrorDlg() parameters */
typedef struct {
    DWORD           cbStruct;
    DWORD           dwOptions;
    PFN_AUTH_NOTIFY pfnNotify;
    DWORD_PTR       dwContext;
} INTERNET_AUTH_NOTIFY_DATA;

/* Internet cache entry information */
typedef struct _INTERNET_CACHE_ENTRY_INFOA {
    DWORD       dwStructSize;
    LPSTR       lpszSourceUrlName;
    LPSTR       lpszLocalFileName;
    DWORD       CacheEntryType;
    DWORD       dwUseCount;
    DWORD       dwHitRate;
    DWORD       dwSizeLow;
    DWORD       dwSizeHigh;
    FILETIME    LastModifiedTime;
    FILETIME    ExpireTime;
    FILETIME    LastAccessTime;
    FILETIME    LastSyncTime;
    LPSTR       lpHeaderInfo;
    DWORD       dwHeaderInfoSize;
    LPSTR       lpszFileExtension;
    union {
        DWORD   dwReserved;
        DWORD   dwExemptDelta;
    };
} INTERNET_CACHE_ENTRY_INFOA;
typedef INTERNET_CACHE_ENTRY_INFOA      *LPINTERNET_CACHE_ENTRY_INFOA;
typedef struct _INTERNET_CACHE_ENTRY_INFOW {
    DWORD       dwStructSize;
    LPWSTR      lpszSourceUrlName;
    LPWSTR      lpszLocalFileName;
    DWORD       CacheEntryType;
    DWORD       dwUseCount;
    DWORD       dwHitRate;
    DWORD       dwSizeLow;
    DWORD       dwSizeHigh;
    FILETIME    LastModifiedTime;
    FILETIME    ExpireTime;
    FILETIME    LastAccessTime;
    FILETIME    LastSyncTime;
    LPWSTR      lpHeaderInfo;
    DWORD       dwHeaderInfoSize;
    LPWSTR      lpszFileExtension;
    union {
        DWORD   dwReserved;
        DWORD   dwExemptDelta;
    };
} INTERNET_CACHE_ENTRY_INFOW;
typedef INTERNET_CACHE_ENTRY_INFOW      *LPINTERNET_CACHE_ENTRY_INFOW;
#ifdef UNICODE
typedef INTERNET_CACHE_ENTRY_INFOW      INTERNET_CACHE_ENTRY_INFO;
typedef LPINTERNET_CACHE_ENTRY_INFOW    LPINTERNET_CACHE_ENTRY_INFO;
#else
typedef INTERNET_CACHE_ENTRY_INFOA      INTERNET_CACHE_ENTRY_INFO;
typedef LPINTERNET_CACHE_ENTRY_INFOA    LPINTERNET_CACHE_ENTRY_INFO;
#endif

/* Internet cache timestamps */
typedef struct _INTERNET_CACHE_TIMESTAMPS {
    FILETIME    ftExpires;
    FILETIME    ftLastModified;
} INTERNET_CACHE_TIMESTAMPS;
typedef INTERNET_CACHE_TIMESTAMPS   *LPINTERNET_CACHE_TIMESTAMPS;

/* Internet cache group information */
typedef struct _INTERNET_CACHE_GROUP_INFOA {
    DWORD   dwGroupSize;
    DWORD   dwGroupFlags;
    DWORD   dwGroupType;
    DWORD   dwDiskUsage;
    DWORD   dwDiskQuota;
    DWORD   dwOwnerStorage[GROUP_OWNER_STORAGE_SIZE];
    CHAR    szGroupName[GROUPNAME_MAX_LENGTH];
} INTERNET_CACHE_GROUP_INFOA;
typedef INTERNET_CACHE_GROUP_INFOA      *LPINTERNET_CACHE_GROUP_INFOA;
typedef struct INTERNET_CACHE_GROUP_INFOW {
    DWORD   dwGroupSize;
    DWORD   dwGroupFlags;
    DWORD   dwGroupType;
    DWORD   dwDiskUsage;
    DWORD   dwDiskQuota;
    DWORD   dwOwnerStorage[GROUP_OWNER_STORAGE_SIZE];
    WCHAR   szGroupName[GROUPNAME_MAX_LENGTH];
} INTERNET_CACHE_GROUP_INFOW;
typedef INTERNET_CACHE_GROUP_INFOW      *LPINTERNET_CACHE_GROUP_INFOW;
#ifdef UNICODE
typedef INTERNET_CACHE_GROUP_INFOW      INTERNET_CACHE_GROUP_INFO;
typedef LPINTERNET_CACHE_GROUP_INFOW    LPINTERNET_CACHE_GROUP_INFO;
#else
typedef INTERNET_CACHE_GROUP_INFOA      INTERNET_CACHE_GROUP_INFO;
typedef LPINTERNET_CACHE_GROUP_INFOA    LPINTERNET_CACHE_GROUP_INFO;
#endif

/* Automatic proxy helper virtual table */
typedef struct AutoProxyHelperVtbl {
    BOOL    (__stdcall *IsResolvable)( LPSTR );
    DWORD   (__stdcall *GetIPAddress)( LPSTR, LPDWORD );
    DWORD   (__stdcall *ResolveHostName)( LPSTR, LPSTR, LPDWORD );
    BOOL    (__stdcall *IsInNet)( LPSTR, LPSTR, LPSTR );
    BOOL    (__stdcall *IsResolvableEx)( LPSTR );
    DWORD   (__stdcall *GetIPAddressEx)( LPSTR, LPDWORD );
    DWORD   (__stdcall *ResolveHostNameEx)( LPSTR, LPSTR, LPDWORD );
    BOOL    (__stdcall *IsInNetEx)( LPSTR, LPSTR );
    DWORD   (__stdcall *SortIpList)( LPSTR, LPSTR, LPDWORD );
} AutoProxyHelperVtbl;

/* Automatic proxy script buffer */
typedef struct {
    DWORD   dwStructSize;
    LPSTR   lpszScriptBuffer;
    DWORD   dwScriptBufferSize;
} AUTO_PROXY_SCRIPT_BUFFER;
typedef AUTO_PROXY_SCRIPT_BUFFER    *LPAUTO_PROXY_SCRIPT_BUFFER;

/* Automatic proxy helper functions */
typedef struct AutoProxyHelperFunctions {
    const struct AutoProxyHelperVtbl    *lpVtbl;
} AutoProxyHelperFunctions;

/* Automatic proxy callbacks */
typedef BOOL (CALLBACK *pfnInternetInitializeAutoProxyDll)( DWORD, LPSTR, LPSTR, AutoProxyHelperFunctions *, LPAUTO_PROXY_SCRIPT_BUFFER );
typedef BOOL (CALLBACK *pfnInternetDeInitializeAutoProxyDll)( LPSTR, DWORD );
typedef BOOL (CALLBACK *pfnInternetGetProxyInfo)( LPCSTR, DWORD, LPSTR, DWORD, LPSTR *, LPDWORD );

/* WPAD cache delete flags */
typedef enum {
    WPAD_CACHE_DELETE_CURRENT   = 0x00000000,
    WPAD_CACHE_DELETE_ALL       = 0x00000001
} WPAD_CACHE_DELETE;

/* Dial handler callback */
typedef DWORD (CALLBACK *PFN_DIAL_HANDLER)( HWND, LPCSTR, DWORD, LPDWORD );

/* Functions in WININET.DLL */
BOOLAPI CommitUrlCacheEntryA( LPCSTR, LPCSTR, FILETIME, FILETIME, DWORD, LPBYTE, DWORD, LPCSTR, LPCSTR );
BOOLAPI CommitUrlCacheEntryW( LPCWSTR, LPCWSTR, FILETIME, FILETIME, DWORD, LPBYTE, DWORD, LPCWSTR, LPCWSTR );
BOOLAPI CreateUrlCacheEntryA( LPCSTR, DWORD, LPCSTR, LPSTR, DWORD );
BOOLAPI CreateUrlCacheEntryW( LPCWSTR, DWORD, LPCWSTR, LPWSTR, DWORD );
BOOLAPI DeleteUrlCacheEntry( LPCSTR );
BOOLAPI DeleteUrlCacheEntryA( LPCSTR );
BOOLAPI DeleteUrlCacheEntryW( LPCWSTR );
BOOLAPI DeleteUrlCacheGroup( GROUPID, DWORD, LPVOID );
BOOLAPI FindCloseUrlCache( HANDLE );
BOOLAPI FindNextUrlCacheEntryA( HANDLE, LPINTERNET_CACHE_ENTRY_INFOA, LPDWORD );
BOOLAPI FindNextUrlCacheEntryExA( HANDLE, LPINTERNET_CACHE_ENTRY_INFOA, LPDWORD, LPVOID, LPDWORD, LPVOID );
BOOLAPI FindNextUrlCacheEntryExW( HANDLE, LPINTERNET_CACHE_ENTRY_INFOW, LPDWORD, LPVOID, LPDWORD, LPVOID );
BOOLAPI FindNextUrlCacheEntryW( HANDLE, LPINTERNET_CACHE_ENTRY_INFOW, LPDWORD );
BOOLAPI FtpCommandA( HINTERNET, BOOL, DWORD, LPCSTR, DWORD_PTR, HINTERNET * );
BOOLAPI FtpCommandW( HINTERNET, BOOL, DWORD, LPCWSTR, DWORD_PTR, HINTERNET * );
BOOLAPI FtpCreateDirectoryA( HINTERNET, LPCSTR );
BOOLAPI FtpCreateDirectoryW( HINTERNET, LPCWSTR );
BOOLAPI FtpDeleteFileA( HINTERNET, LPCSTR );
BOOLAPI FtpDeleteFileW( HINTERNET, LPCWSTR );
BOOLAPI FtpGetCurrentDirectoryA( HINTERNET, LPSTR, LPDWORD );
BOOLAPI FtpGetCurrentDirectoryW( HINTERNET, LPWSTR, LPDWORD );
BOOLAPI FtpGetFileA( HINTERNET, LPCSTR, LPCSTR, BOOL, DWORD, DWORD, DWORD_PTR );
BOOLAPI FtpGetFileEx( HINTERNET, LPCSTR, LPCWSTR, BOOL, DWORD, DWORD, DWORD_PTR );
BOOLAPI FtpGetFileW( HINTERNET, LPCWSTR, LPCWSTR, BOOL, DWORD, DWORD, DWORD_PTR );
BOOLAPI FtpPutFileA( HINTERNET, LPCSTR, LPCSTR, DWORD, DWORD_PTR );
BOOLAPI FtpPutFileEx( HINTERNET, LPCWSTR, LPCSTR, DWORD, DWORD_PTR );
BOOLAPI FtpPutFileW( HINTERNET, LPCWSTR, LPCWSTR, DWORD, DWORD_PTR );
BOOLAPI FtpRemoveDirectoryA( HINTERNET, LPCSTR );
BOOLAPI FtpRemoveDirectoryW( HINTERNET, LPCWSTR );
BOOLAPI FtpRenameFileA( HINTERNET, LPCSTR, LPCSTR );
BOOLAPI FtpRenameFileW( HINTERNET, LPCWSTR, LPCWSTR );
BOOLAPI FtpSetCurrentDirectoryA( HINTERNET, LPCSTR );
BOOLAPI FtpSetCurrentDirectoryW( HINTERNET, LPCWSTR );
BOOLAPI GetUrlCacheEntryInfoExA( LPCSTR, LPINTERNET_CACHE_ENTRY_INFOA, LPDWORD, LPSTR, LPDWORD, LPVOID, DWORD );
BOOLAPI GetUrlCacheEntryInfoExW( LPCWSTR, LPINTERNET_CACHE_ENTRY_INFOW, LPDWORD, LPWSTR, LPDWORD, LPVOID, DWORD );
BOOLAPI GopherCreateLocatorA( LPCSTR, INTERNET_PORT, LPCSTR, LPCSTR, DWORD, LPSTR, LPDWORD );
BOOLAPI GopherCreateLocatorW( LPCWSTR, INTERNET_PORT, LPCWSTR, LPCWSTR, DWORD, LPWSTR, LPDWORD );
BOOLAPI GopherGetAttributeA( HINTERNET, LPCSTR, LPCSTR, LPBYTE, DWORD, LPDWORD, GOPHER_ATTRIBUTE_ENUMERATOR, DWORD_PTR );
BOOLAPI GopherGetAttributeW( HINTERNET, LPCWSTR, LPCWSTR, LPBYTE, DWORD, LPDWORD, GOPHER_ATTRIBUTE_ENUMERATOR, DWORD_PTR );
BOOLAPI GopherGetLocatorTypeA( LPCSTR, LPDWORD );
BOOLAPI GopherGetLocatorTypeW( LPCWSTR, LPDWORD );
BOOLAPI HttpAddRequestHeadersA( HINTERNET, LPCSTR, DWORD, DWORD );
BOOLAPI HttpAddRequestHeadersW( HINTERNET, LPCWSTR, DWORD, DWORD );
BOOLAPI HttpQueryInfoA( HINTERNET, DWORD, LPVOID, LPDWORD, LPDWORD );
BOOLAPI HttpQueryInfoW( HINTERNET, DWORD, LPVOID, LPDWORD, LPDWORD );
BOOLAPI HttpSendRequestA( HINTERNET, LPCSTR, DWORD, LPVOID, DWORD );
BOOLAPI HttpSendRequestW( HINTERNET, LPCWSTR, DWORD, LPVOID, DWORD );
BOOLAPI InternetCanonicalizeUrlA( LPCSTR, LPSTR, LPDWORD, DWORD );
BOOLAPI InternetCanonicalizeUrlW( LPCWSTR, LPWSTR, LPDWORD, DWORD );
BOOLAPI InternetCheckConnectionA( LPCSTR, DWORD, DWORD );
BOOLAPI InternetCheckConnectionW( LPCWSTR, DWORD, DWORD );
BOOLAPI InternetCloseHandle( HINTERNET );
BOOLAPI InternetCombineUrlA( LPCSTR, LPCSTR, LPSTR, LPDWORD, DWORD );
BOOLAPI InternetCombineUrlW( LPCWSTR, LPCWSTR, LPWSTR, LPDWORD, DWORD );
BOOLAPI InternetCrackUrlA( LPCSTR, DWORD, DWORD, LPURL_COMPONENTSA );
BOOLAPI InternetCrackUrlW( LPCWSTR, DWORD, DWORD, LPURL_COMPONENTSW );
BOOLAPI InternetCreateUrlA( LPURL_COMPONENTSA, DWORD, LPSTR, LPDWORD );
BOOLAPI InternetCreateUrlW( LPURL_COMPONENTSW, DWORD, LPWSTR, LPDWORD );
BOOLAPI InternetFindNextFileA( HINTERNET, LPVOID );
BOOLAPI InternetFindNextFileW( HINTERNET, LPVOID );
BOOLAPI InternetGetCookieA( LPCSTR, LPCSTR, LPSTR, LPDWORD );
BOOLAPI InternetGetCookieExA( LPCSTR, LPCSTR, LPSTR, LPDWORD, DWORD, LPVOID );
BOOLAPI InternetGetCookieExW( LPCWSTR, LPCWSTR, LPWSTR, LPDWORD, DWORD, LPVOID );
BOOLAPI InternetGetCookieW( LPCWSTR, LPCWSTR, LPWSTR, LPDWORD );
BOOLAPI InternetGetLastResponseInfoA( LPDWORD, LPSTR, LPDWORD );
BOOLAPI InternetGetLastResponseInfoW( LPDWORD, LPWSTR, LPDWORD );
BOOLAPI InternetLockRequestFile( HINTERNET, HANDLE * );
BOOLAPI InternetQueryDataAvailable( HINTERNET, LPDWORD, DWORD, DWORD_PTR );
BOOLAPI InternetQueryOptionA( HINTERNET, DWORD, LPVOID, LPDWORD );
BOOLAPI InternetQueryOptionW( HINTERNET, DWORD, LPVOID, LPDWORD );
BOOLAPI InternetReadFile( HINTERNET, LPVOID, DWORD, LPDWORD );
BOOLAPI InternetSetCookieA( LPCSTR, LPCSTR, LPCSTR );
BOOLAPI InternetSetCookieW( LPCWSTR, LPCWSTR, LPCWSTR );
BOOLAPI InternetSetOptionA( HINTERNET, DWORD, LPVOID, DWORD );
BOOLAPI InternetSetOptionExA( HINTERNET, DWORD, LPVOID, DWORD, DWORD );
BOOLAPI InternetSetOptionExW( HINTERNET, DWORD, LPVOID, DWORD, DWORD );
BOOLAPI InternetSetOptionW( HINTERNET, DWORD, LPVOID, DWORD );
BOOLAPI InternetTimeFromSystemTime( CONST SYSTEMTIME *, DWORD, LPSTR, DWORD );
BOOLAPI InternetTimeFromSystemTimeA( CONST SYSTEMTIME *, DWORD, LPSTR, DWORD );
BOOLAPI InternetTimeFromSystemTimeW( CONST SYSTEMTIME *, DWORD, LPWSTR, DWORD );
BOOLAPI InternetTimeToSystemTime( LPCSTR, SYSTEMTIME *, DWORD );
BOOLAPI InternetTimeToSystemTimeA( LPCSTR, SYSTEMTIME *, DWORD );
BOOLAPI InternetTimeToSystemTimeW( LPCWSTR, SYSTEMTIME *, DWORD );
BOOLAPI InternetUnlockRequestFile( HANDLE );
BOOLAPI InternetWriteFile( HINTERNET, LPCVOID, DWORD, LPDWORD );
BOOLAPI ReadUrlCacheEntryStream( HANDLE, DWORD, LPVOID, LPDWORD, DWORD );
BOOLAPI ReadUrlCacheEntryStreamEx( HANDLE, DWORDLONG, LPVOID, LPDWORD );
BOOLAPI RetrieveUrlCacheEntryFileA( LPCSTR, LPINTERNET_CACHE_ENTRY_INFOA, LPDWORD, DWORD );
BOOLAPI RetrieveUrlCacheEntryFileW( LPCWSTR, LPINTERNET_CACHE_ENTRY_INFOW, LPDWORD, DWORD );
BOOLAPI SetUrlCacheEntryGroup( LPCSTR, DWORD, GROUPID, LPBYTE, DWORD, LPVOID );
BOOLAPI SetUrlCacheEntryGroupA( LPCSTR, DWORD, GROUPID, LPBYTE, DWORD, LPVOID );
BOOLAPI SetUrlCacheEntryGroupW( LPCWSTR, DWORD, GROUPID, LPBYTE, DWORD, LPVOID );
BOOLAPI SetUrlCacheEntryInfoA( LPCSTR, LPINTERNET_CACHE_ENTRY_INFOA, DWORD );
BOOLAPI SetUrlCacheEntryInfoW( LPCWSTR, LPINTERNET_CACHE_ENTRY_INFOW, DWORD );
BOOLAPI UnlockUrlCacheEntryFile( LPCSTR, DWORD );
BOOLAPI UnlockUrlCacheEntryFileA( LPCSTR, DWORD );
BOOLAPI UnlockUrlCacheEntryFileW( LPCWSTR, DWORD );
BOOLAPI UnlockUrlCacheEntryStream( HANDLE, DWORD );
INTERNETAPI_( BOOL )        CreateMD5SSOHash( PWSTR, PWSTR, PWSTR, PBYTE );
INTERNETAPI_( GROUPID )     CreateUrlCacheGroup( DWORD, LPVOID );
INTERNETAPI_( BOOL )        DeleteWpadCacheForNetworks( WPAD_CACHE_DELETE );
INTERNETAPI_( BOOL )        DetectAutoProxyUrl( LPSTR, DWORD, DWORD );
INTERNETAPI_( HANDLE )      FindFirstUrlCacheEntryA( LPCSTR, LPINTERNET_CACHE_ENTRY_INFOA, LPDWORD );
INTERNETAPI_( HANDLE )      FindFirstUrlCacheEntryExA( LPCSTR, DWORD, DWORD, GROUPID, LPINTERNET_CACHE_ENTRY_INFOA, LPDWORD, LPVOID, LPDWORD, LPVOID );
INTERNETAPI_( HANDLE )      FindFirstUrlCacheEntryExW( LPCWSTR, DWORD, DWORD, GROUPID, LPINTERNET_CACHE_ENTRY_INFOW, LPDWORD, LPVOID, LPDWORD, LPVOID );
INTERNETAPI_( HANDLE )      FindFirstUrlCacheEntryW( LPCWSTR, LPINTERNET_CACHE_ENTRY_INFOW, LPDWORD );
INTERNETAPI_( HINTERNET )   FtpFindFirstFileA( HINTERNET, LPCSTR, LPWIN32_FIND_DATAA, DWORD, DWORD_PTR );
INTERNETAPI_( HINTERNET )   FtpFindFirstFileW( HINTERNET, LPCWSTR, LPWIN32_FIND_DATAW, DWORD, DWORD_PTR );
INTERNETAPI_( DWORD )       FtpGetFileSize( HINTERNET, LPDWORD );
INTERNETAPI_( HINTERNET )   FtpOpenFileA( HINTERNET, LPCSTR, DWORD, DWORD, DWORD_PTR );
INTERNETAPI_( HINTERNET )   FtpOpenFileW( HINTERNET, LPCWSTR, DWORD, DWORD, DWORD_PTR );
INTERNETAPI_( HINTERNET )   GopherFindFirstFileA( HINTERNET, LPCSTR, LPCSTR, LPGOPHER_FIND_DATAA, DWORD, DWORD_PTR );
INTERNETAPI_( HINTERNET )   GopherFindFirstFileW( HINTERNET, LPCWSTR, LPCWSTR, LPGOPHER_FIND_DATAW, DWORD, DWORD_PTR );
INTERNETAPI_( HINTERNET )   GopherOpenFileA( HINTERNET, LPCSTR, LPCSTR, DWORD, DWORD_PTR );
INTERNETAPI_( HINTERNET )   GopherOpenFileW( HINTERNET, LPCWSTR, LPCWSTR, DWORD, DWORD_PTR );
INTERNETAPI_( BOOL )        HttpEndRequestA( HINTERNET, LPINTERNET_BUFFERSA, DWORD, DWORD_PTR );
INTERNETAPI_( BOOL )        HttpEndRequestW( HINTERNET, LPINTERNET_BUFFERSW, DWORD, DWORD_PTR );
INTERNETAPI_( HINTERNET )   HttpOpenRequestA( HINTERNET, LPCSTR, LPCSTR, LPCSTR, LPCSTR, LPCSTR *, DWORD, DWORD_PTR );
INTERNETAPI_( HINTERNET )   HttpOpenRequestW( HINTERNET, LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR *, DWORD, DWORD_PTR );
INTERNETAPI_( BOOL )        HttpSendRequestExA( HINTERNET, LPINTERNET_BUFFERSA, LPINTERNET_BUFFERSA, DWORD, DWORD_PTR );
INTERNETAPI_( BOOL )        HttpSendRequestExW( HINTERNET, LPINTERNET_BUFFERSW, LPINTERNET_BUFFERSW, DWORD, DWORD_PTR );
INTERNETAPI_( DWORD )       InternetAttemptConnect( DWORD );
INTERNETAPI_( BOOL )        InternetAutodial( DWORD, HWND );
INTERNETAPI_( BOOL )        InternetAutodialHangup( DWORD );
INTERNETAPI_( BOOL )        InternetClearAllPerSiteCookieDecisions();
INTERNETAPI_( DWORD )       InternetConfirmZoneCrossing( HWND, LPSTR, LPSTR, BOOL );
INTERNETAPI_( DWORD )       InternetConfirmZoneCrossingA( HWND, LPSTR, LPSTR, BOOL );
INTERNETAPI_( DWORD )       InternetConfirmZoneCrossingW( HWND, LPWSTR, LPWSTR, BOOL );
INTERNETAPI_( HINTERNET )   InternetConnectA( HINTERNET, LPCSTR, INTERNET_PORT, LPCSTR, LPCSTR, DWORD, DWORD, DWORD_PTR );
INTERNETAPI_( HINTERNET )   InternetConnectW( HINTERNET, LPCWSTR, INTERNET_PORT, LPCWSTR, LPCWSTR, DWORD, DWORD, DWORD_PTR );
INTERNETAPI_( DWORD )       InternetDial( HWND, LPSTR, DWORD, DWORD_PTR *, DWORD );
INTERNETAPI_( DWORD )       InternetDialA( HWND, LPSTR, DWORD, DWORD_PTR *, DWORD );
INTERNETAPI_( DWORD )       InternetDialW( HWND, LPWSTR, DWORD, DWORD_PTR *, DWORD );
INTERNETAPI_( BOOL )        InternetEnumPerSiteCookieDecisionA( LPSTR, unsigned long *, unsigned long *, unsigned long );
INTERNETAPI_( BOOL )        InternetEnumPerSiteCookieDecisionW( LPWSTR, unsigned long *, unsigned long *, unsigned long );
INTERNETAPI_( DWORD )       InternetErrorDlg( HWND, HINTERNET, DWORD, DWORD, LPVOID * );
INTERNETAPI_( BOOL )        InternetGetConnectedState( LPDWORD, DWORD );
INTERNETAPI_( BOOL )        InternetGetConnectedStateEx( LPDWORD, LPSTR, DWORD, DWORD );
INTERNETAPI_( BOOL )        InternetGetConnectedStateExA( LPDWORD, LPSTR, DWORD, DWORD );
INTERNETAPI_( BOOL )        InternetGetConnectedStateExW( LPDWORD, LPWSTR, DWORD, DWORD );
INTERNETAPI_( BOOL )        InternetGetPerSiteCookieDecisionA( LPCSTR, unsigned long * );
INTERNETAPI_( BOOL )        InternetGetPerSiteCookieDecisionW( LPCWSTR, unsigned long * );
INTERNETAPI_( BOOL )        InternetGoOnline( LPSTR, HWND, DWORD );
INTERNETAPI_( BOOL )        InternetGoOnlineA( LPCSTR, HWND, DWORD );
INTERNETAPI_( BOOL )        InternetGoOnlineW( LPCWSTR, HWND, DWORD );
INTERNETAPI_( DWORD )       InternetHangUp( DWORD_PTR, DWORD );
INTERNETAPI_( BOOL )        InternetInitializeAutoProxyDll( DWORD );
INTERNETAPI_( HINTERNET )   InternetOpenA( LPCSTR, DWORD, LPCSTR, LPCSTR, DWORD );
INTERNETAPI_( HINTERNET )   InternetOpenUrlA( HINTERNET, LPCSTR, LPCSTR, DWORD, DWORD, DWORD_PTR );
INTERNETAPI_( HINTERNET )   InternetOpenUrlW( HINTERNET, LPCWSTR, LPCWSTR, DWORD, DWORD, DWORD_PTR );
INTERNETAPI_( HINTERNET )   InternetOpenW( LPCWSTR, DWORD, LPCWSTR, LPCWSTR, DWORD );
INTERNETAPI_( BOOL )        InternetReadFileExA( HINTERNET, LPINTERNET_BUFFERSA, DWORD, DWORD_PTR );
INTERNETAPI_( BOOL )        InternetReadFileExW( HINTERNET, LPINTERNET_BUFFERSW, DWORD, DWORD_PTR );
INTERNETAPI_( DWORD )       InternetSetCookieExA( LPCSTR, LPCSTR, LPCSTR, DWORD, DWORD_PTR );
INTERNETAPI_( DWORD )       InternetSetCookieExW( LPCWSTR, LPCWSTR, LPCWSTR, DWORD, DWORD_PTR );
INTERNETAPI_( BOOL )        InternetSetDialState( LPCSTR, DWORD, DWORD );
INTERNETAPI_( BOOL )        InternetSetDialStateA( LPCSTR, DWORD, DWORD );
INTERNETAPI_( BOOL )        InternetSetDialStateW( LPCWSTR, DWORD, DWORD );
INTERNETAPI_( DWORD )       InternetSetFilePointer( HINTERNET, LONG, PLONG, DWORD, DWORD_PTR );
INTERNETAPI_( BOOL )        InternetSetPerSiteCookieDecisionA( LPCSTR, DWORD );
INTERNETAPI_( BOOL )        InternetSetPerSiteCookieDecisionW( LPCWSTR, DWORD );
INTERNETAPI_( INTERNET_STATUS_CALLBACK )    InternetSetStatusCallback( HINTERNET, INTERNET_STATUS_CALLBACK );
INTERNETAPI_( INTERNET_STATUS_CALLBACK )    InternetSetStatusCallbackA( HINTERNET, INTERNET_STATUS_CALLBACK );
INTERNETAPI_( INTERNET_STATUS_CALLBACK )    InternetSetStatusCallbackW( HINTERNET, INTERNET_STATUS_CALLBACK );
INTERNETAPI_( DWORD )       PrivacyGetZonePreferenceW( DWORD, DWORD, LPDWORD, LPWSTR, LPDWORD );
INTERNETAPI_( DWORD )       PrivacySetZonePreferenceW( DWORD, DWORD, DWORD, LPCWSTR );
INTERNETAPI_( BOOL )        ResumeSuspendedDownload( HINTERNET, DWORD );
INTERNETAPI_( HANDLE )      RetrieveUrlCacheEntryStreamA( LPCSTR, LPINTERNET_CACHE_ENTRY_INFOA, LPDWORD, BOOL, DWORD );
INTERNETAPI_( HANDLE )      RetrieveUrlCacheEntryStreamW( LPCWSTR, LPINTERNET_CACHE_ENTRY_INFOW, LPDWORD, BOOL, DWORD );
URLCACHEAPI_( HANDLE )      FindFirstUrlCacheGroup( DWORD, DWORD, LPVOID, DWORD, GROUPID *, LPVOID );
URLCACHEAPI_( BOOL )        FindNextUrlCacheGroup( HANDLE, GROUPID *, LPVOID );
URLCACHEAPI_( BOOL )        GetUrlCacheEntryInfoA( LPCSTR, LPINTERNET_CACHE_ENTRY_INFOA, LPDWORD );
URLCACHEAPI_( BOOL )        GetUrlCacheEntryInfoW( LPCWSTR, LPINTERNET_CACHE_ENTRY_INFOW, LPDWORD );
URLCACHEAPI_( BOOL )        GetUrlCacheGroupAttributeA( GROUPID, DWORD, DWORD, LPINTERNET_CACHE_GROUP_INFOA, LPDWORD, LPVOID );
URLCACHEAPI_( BOOL )        GetUrlCacheGroupAttributeW( GROUPID, DWORD, DWORD, LPINTERNET_CACHE_GROUP_INFOW, LPDWORD, LPVOID );
URLCACHEAPI_( BOOL )        SetUrlCacheGroupAttributeA( GROUPID, DWORD, DWORD, LPINTERNET_CACHE_GROUP_INFOA, LPVOID );
URLCACHEAPI_( BOOL )        SetUrlCacheGroupAttributeW( GROUPID, DWORD, DWORD, LPINTERNET_CACHE_GROUP_INFOW, LPVOID );

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define CommitUrlCacheEntry         CommitUrlCacheEntryW
    #define CreateUrlCacheEntry         CreateUrlCacheEntryW
    #define DeleteUrlCacheEntry         DeleteUrlCacheEntryW
    #define FindFirstUrlCacheEntry      FindFirstUrlCacheEntryW
    #define FindFirstUrlCacheEntryEx    FindFirstUrlCacheEntryExW
    #define FindNextUrlCacheEntry       FindNextUrlCacheEntryW
    #define FindNextUrlCacheEntryEx     FindNextUrlCacheEntryExW
    #define FtpCommand                  FtpCommandW
    #define FtpCreateDirectory          FtpCreateDirectoryW
    #define FtpDeleteFile               FtpDeleteFileW
    #define FtpFindFirstFile            FtpFindFirstFileW
    #define FtpGetCurrentDirectory      FtpGetCurrentDirectoryW
    #define FtpGetFile                  FtpGetFileW
    #define FtpOpenFile                 FtpOpenFileW
    #define FtpPutFile                  FtpPutFileW
    #define FtpRemoveDirectory          FtpRemoveDirectoryW
    #define FtpRenameFile               FtpRenameFileW
    #define FtpSetCurrentDirectory      FtpSetCurrentDirectoryW
    #define GetUrlCacheEntryInfo        GetUrlCacheEntryInfoW
    #define GetUrlCacheEntryInfoEx      GetUrlCacheEntryInfoExW
    #define GetUrlCacheGroupAttribute   GetUrlCacheGroupAttributeW
    #define GopherCreateLocator         GopherCreateLocatorW
    #define GopherFindFirstFile         GopherFindFirstFileW
    #define GopherGetAttribute          GopherGetAttributeW
    #define GopherGetLocatorType        GopherGetLocatorTypeW
    #define GopherOpenFile              GopherOpenFileW
    #define HttpAddRequestHeaders       HttpAddRequestHeadersW
    #define HttpEndRequest              HttpEndRequestW
    #define HttpOpenRequest             HttpOpenRequestW
    #define HttpQueryInfo               HttpQueryInfoW
    #define HttpSendRequest             HttpSendRequestW
    #define HttpSendRequestEx           HttpSendRequestExW
    #define InternetCanonicalizeUrl     InternetCanonicalizeUrlW
    #define InternetCheckConnection     InternetCheckConnectionW
    #define InternetCombineUrl          InternetCombineUrlW
    #define InternetConfirmZoneCrossing InternetConfirmZoneCrossingW
    #define InternetConnect             InternetConnectW
    #define InternetCrackUrl            InternetCrackUrlW
    #define InternetCreateUrl           InternetCreateUrlW
    #define InternetDial                InternetDialW
    #define InternetEnumPerSiteCookieDecision   InternetEnumPerSiteCookieDecisionW
    #define InternetFindNextFile        InternetFindNextFileW
    #define InternetGetConnectedStateEx InternetGetConnectedStateExW
    #define InternetGetCookie           InternetGetCookieW
    #define InternetGetCookieEx         InternetGetCookieExW
    #define InternetGetLastResponseInfo InternetGetLastResponseInfoW
    #define InternetGetPerSiteCookieDecision    InternetGetPerSiteCookieDecisionW
    #define InternetGoOnline            InternetGoOnlineW
    #define InternetOpen                InternetOpenW
    #define InternetOpenUrl             InternetOpenUrlW
    #define InternetQueryOption         InternetQueryOptionW
    #define InternetReadFileEx          InternetReadFileExW
    #define InternetSetCookie           InternetSetCookieW
    #define InternetSetCookieEx         InternetSetCookieExW
    #define InternetSetDialState        InternetSetDialStateW
    #define InternetSetOption           InternetSetOptionW
    #define InternetSetOptionEx         InternetSetOptionExW
    #define InternetSetPerSiteCookieDecision    InternetSetPerSiteCookieDecisionW
    #define InternetSetStatusCallback   InternetSetStatusCallbackW
    #define InternetTimeFromSystemTime  InternetTimeFromSystemTimeW
    #define InternetTimeToSystemTime    InternetTimeToSystemTimeW
    #define RetrieveUrlCacheEntryFile   RetrieveUrlCacheEntryFileW
    #define RetrieveUrlCacheEntryStream RetrieveUrlCacheEntryStreamW
    #define UnlockUrlCacheEntryFile     UnlockUrlCacheEntryFileW
    #define SetUrlCacheEntryGroup       SetUrlCacheEntryGroupW
    #define SetUrlCacheEntryInfo        SetUrlCacheEntryInfoW
    #define SetUrlCacheGroupAttribute   SetUrlCacheGroupAttributeW
#else
    #define CommitUrlCacheEntry         CommitUrlCacheEntryA
    #define CreateUrlCacheEntry         CreateUrlCacheEntryA
    #define FindFirstUrlCacheEntry      FindFirstUrlCacheEntryA
    #define FindFirstUrlCacheEntryEx    FindFirstUrlCacheEntryExA
    #define FindNextUrlCacheEntry       FindNextUrlCacheEntryA
    #define FindNextUrlCacheEntryEx     FindNextUrlCacheEntryExA
    #define FtpCommand                  FtpCommandA
    #define FtpCreateDirectory          FtpCreateDirectoryA
    #define FtpDeleteFile               FtpDeleteFileA
    #define FtpFindFirstFile            FtpFindFirstFileA
    #define FtpGetCurrentDirectory      FtpGetCurrentDirectoryA
    #define FtpGetFile                  FtpGetFileA
    #define FtpOpenFile                 FtpOpenFileA
    #define FtpPutFile                  FtpPutFileA
    #define FtpRemoveDirectory          FtpRemoveDirectoryA
    #define FtpRenameFile               FtpRenameFileA
    #define FtpSetCurrentDirectory      FtpSetCurrentDirectoryA
    #define GetUrlCacheEntryInfo        GetUrlCacheEntryInfoA
    #define GetUrlCacheEntryInfoEx      GetUrlCacheEntryInfoExA
    #define GetUrlCacheGroupAttribute   GetUrlCacheGroupAttributeA
    #define GopherCreateLocator         GopherCreateLocatorA
    #define GopherFindFirstFile         GopherFindFirstFileA
    #define GopherGetAttribute          GopherGetAttributeA
    #define GopherGetLocatorType        GopherGetLocatorTypeA
    #define GopherOpenFile              GopherOpenFileA
    #define HttpAddRequestHeaders       HttpAddRequestHeadersA
    #define HttpEndRequest              HttpEndRequestA
    #define HttpOpenRequest             HttpOpenRequestA
    #define HttpQueryInfo               HttpQueryInfoA
    #define HttpSendRequest             HttpSendRequestA
    #define HttpSendRequestEx           HttpSendRequestExA
    #define InternetCanonicalizeUrl     InternetCanonicalizeUrlA
    #define InternetCheckConnection     InternetCheckConnectionA
    #define InternetCombineUrl          InternetCombineUrlA
    #define InternetConnect             InternetConnectA
    #define InternetCrackUrl            InternetCrackUrlA
    #define InternetCreateUrl           InternetCreateUrlA
    #define InternetEnumPerSiteCookieDecision   InternetEnumPerSiteCookieDecisionA
    #define InternetFindNextFile        InternetFindNextFileA
    #define InternetGetCookie           InternetGetCookieA
    #define InternetGetCookieEx         InternetGetCookieExA
    #define InternetGetLastResponseInfo InternetGetLastResponseInfoA
    #define InternetGetPerSiteCookieDecision    InternetGetPerSiteCookieDecisionA
    #define InternetOpen                InternetOpenA
    #define InternetOpenUrl             InternetOpenUrlA
    #define InternetQueryOption         InternetQueryOptionA
    #define InternetReadFileEx          InternetReadFileExA
    #define InternetSetCookie           InternetSetCookieA
    #define InternetSetCookieEx         InternetSetCookieExA
    #define InternetSetOption           InternetSetOptionA
    #define InternetSetOptionEx         InternetSetOptionExA
    #define InternetSetPerSiteCookieDecision    InternetSetPerSiteCookieDecisionA
    #define RetrieveUrlCacheEntryFile   RetrieveUrlCacheEntryFileA
    #define RetrieveUrlCacheEntryStream RetrieveUrlCacheEntryStreamA
    #define SetUrlCacheEntryInfo        SetUrlCacheEntryInfoA
    #define SetUrlCacheGroupAttribute   SetUrlCacheGroupAttributeA
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WININET_ */
