/*
 *  urlmon.h    URL moniker interfaces and functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __urlmon_h__
#define __urlmon_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <oleidl.h>
#include <servprov.h>
#include <msxml.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Forward declarations */
typedef interface IBindStatusCallback   IBindStatusCallback;
typedef interface IBinding              IBinding;
typedef interface IInternetProtocol     IInternetProtocol;
typedef interface IInternetProtocolSink IInternetProtocolSink;

/* URL moniker object parameters */
#define SZ_URLCONTEXT   OLESTR( "URL Context" )
#define SZ_ASYNC_CALLEE OLESTR( "AsyncCallee" )

/* URL system moniker type */
#define MKSYS_URLMONIKER    6L

/* CreateURLMonikerEx() flags */
#define URL_MK_LEGACY           0L
#define URL_MK_UNIFORM          1L
#define URL_MK_NO_CANONICALIZE  2L

/* FaultInIEFeature() flags */
#define FIEF_FLAG_FORCE_JITUI                   0x00000001L
#define FIEF_FLAG_PEEK                          0x00000002L
#define FIEF_FLAG_SKIP_INSTALLED_VERSION_CHECK  0x00000004L

/* FindMimeFromData() flags */
#define FMFD_DEFAULT                    0x00000000L
#define FMFD_URLASFILENAME              0x00000001L
#if (_WIN32_IE >= 0x0602)
    #define FMFD_ENABLEMIMESNIFFING     0x00000002L
    #define FMFD_IGNOREMIMETEXTPLAIN    0x00000004L
#endif
#define FMFD_SERVERMIME                 0x00000008L

/* ObtainUserAgentString() options */
#define UAS_EXACTLEGACY 0x00001000L

/* UrlMkSetSessionOption() options */
#define URLMON_OPTION_USERAGENT                     0x10000001L
#define URLMON_OPTION_USERAGENT_REFRESH             0x10000002L
#define URLMON_OPTION_URL_ENCODING                  0x10000004L
#if (_WIN32_IE >= 0x0602)
    #define URLMON_OPTION_USE_BINDSTRINGCREDS       0x10000008L
#endif
#if (_WIN32_IE >= 0x0700)
    #define URLMON_OPTION_USE_BROWSERAPPSDOCUMENTS  0x10000010L
#endif

/* Clipboard format special value */
#define CF_NULL 0

/* MIME types */
#define CFSTR_MIME_NULL         NULL
#define CFSTR_MIME_TEXT         TEXT( "text/plain" )
#define CFSTR_MIME_RICHTEXT     TEXT( "text/richtext" )
#define CFSTR_MIME_X_BITMAP     TEXT( "image/x-xbitmap" )
#define CFSTR_MIME_POSTSCRIPT   TEXT( "application/postscript" )
#define CFSTR_MIME_AIFF         TEXT( "audio/aiff" )
#define CFSTR_MIME_BASICAUDIO   TEXT( "audio/basic" )
#define CFSTR_MIME_WAV          TEXT( "audio/wav" )
#define CFSTR_MIME_W_WAV        TEXT(" audio/x-wav" )
#define CFSTR_MIME_GIF          TEXT( "image/gif" )
#define CFSTR_MIME_PJPEG        TEXT( "image/pjpeg" )
#define CFSTR_MIME_JPEG         TEXT( "image/jpeg" )
#define CFSTR_MIME_TIFF         TEXT( "image/tiff" )
#define CFSTR_MIME_X_PNG        TEXT( "image/x-png" )
#define CFSTR_MIME_BMP          TEXT( "image/bmp" )
#define CFSTR_MIME_X_ART        TEXT( "image/x-jg" )
#define CFSTR_MIME_X_EMF        TEXT( "image/x-emf" )
#define CFSTR_MIME_X_WMF        TEXT( "image/x-wmf" )
#define CFSTR_MIME_AVI          TEXT( "video/avi" )
#define CFSTR_MIME_MPEG         TEXT( "video/mpeg" )
#define CFSTR_MIME_FRACTALS     TEXT( "application/fractals" )
#define CFSTR_MIME_RAWDATA      TEXT( "application/octet-stream" )
#define CFSTR_MIME_RAWDATASTRM  TEXT( "application/octet-stream" )
#define CFSTR_MIME_PDF          TEXT( "application/pdf" )
#define CFSTR_MIME_HTA          TEXT( "application/hta" )
#define CFSTR_MIME_X_AIFF       TEXT( "audio/x-aiff" )
#define CFSTR_MIME_X_REALAUDIO  TEXT( "audio/x-pn-realaudio" )
#define CFSTR_MIME_XBM          TEXT( "image/xbm" )
#define CFSTR_MIME_QUICKTIME    TEXT( "video/quicktime" )
#define CFSTR_MIME_X_MSVIDEO    TEXT( "video/x-msvideo" )
#define CFSTR_MIME_X_SGI_MOVIE  TEXT( "video/x-sgi-movie" )
#define CFSTR_MIME_HTML         TEXT( "text/html" )
#define CFSTR_MIME_XML          TEXT( "text/xml" )

/* Moniker error codes */
#define MK_S_ASYNCHRONOUS       0x000401E8L
#define S_ASYNCHRONOUS          MK_S_ASYNCHRONOUS

/* Internet error codes */
#define INET_E_ERROR_FIRST                          0x800C0002L
#define INET_E_INVALID_URL                          0x800C0002L
#define INET_E_NO_SESSION                           0x800C0003L
#define INET_E_CANNOT_CONNECT                       0x800C0004L
#define INET_E_RESOURCE_NOT_FOUND                   0x800C0005L
#define INET_E_OBJECT_NOT_FOUND                     0x800C0006L
#define INET_E_DATA_NOT_AVAILABLE                   0x800C0007L
#define INET_E_DOWNLOAD_FAILURE                     0x800C0008L
#define INET_E_AUTHENTICATION_REQUIRED              0x800C0009L
#define INET_E_NO_VALID_MEDIA                       0x800C000AL
#define INET_E_CONNECTION_TIMEOUT                   0x800C000BL
#define INET_E_INVALID_REQUEST                      0x800C000CL
#define INET_E_UNKNOWN_PROTOCOL                     0x800C000DL
#define INET_E_SECURITY_PROBLEM                     0x800C000EL
#define INET_E_CANNOT_LOAD_DATA                     0x800C000FL
#define INET_E_CANNOT_INSTANTIATE_OBJECT            0x800C0010L
#define INET_E_USE_DEFAULT_PROTOCOLHANDLER          0x800C0011L
#define INET_E_USE_DEFAULT_SETTING                  0x800C0012L
#define INET_E_QUERYOPTION_UNKNOWN                  0x800C0013L
#define INET_E_REDIRECTING                          0x800C0014L
#define INET_E_REDIRECT_FAILED                      0x800C0014L
#define INET_E_REDIRECT_TO_DIR                      0x800C0015L
#define INET_E_CANNOT_LOCK_REQUEST                  0x800C0016L
#define INET_E_USE_EXTEND_BINDING                   0x800C0017L
#define INET_E_TERMINATE_BIND                       0x800C0018L
#define INET_E_INVALID_CERTIFICATE                  0x800C0019L
#define INET_E_BLOCK_REDIRECT_XSECURITYID           0x800C001BL
#define INET_E_CODE_DOWNLOAD_DECLINED               0x800C0100L
#define INET_E_RESULT_DISPATCHED                    0x800C0200L
#define INET_E_CANNOT_REPLACE_SFP_FILE              0x800C0300L
#if (_WIN32_IE >= 0x0602)
    #define INET_E_CODE_INSTALL_SUPPRESSED          0x800C0400L
#endif
#define INET_E_CODE_INSTALL_BLOCKED_BY_HASH_POLICY  0x800C0500L
#define INET_E_DOWNLOAD_BLOCKED_BY_INPRIVATE        0x800C0501L
#define INET_E_ERROR_LAST                           INET_E_DOWNLOAD_BLOCKED_BY_INPRIVATE
#define INET_E_DEFAULT_ACTION                       INET_E_USE_DEFAULT_PROTOCOLHANDLER

/* URI creation flags */
#if (_WIN32_IE >= 0x0700)
    #define Uri_CREATE_ALLOW_RELATIVE                   0x00000001L
    #define Uri_CREATE_ALLOW_IMPLICIT_WILDCARD_SCHEME   0x00000002L
    #define Uri_CREATE_ALLOW_IMPLICIT_FILE_SCHEME       0x00000004L
    #define Uri_CREATE_NOFRAG                           0x00000008L
    #define Uri_CREATE_NO_CANONICALIZE                  0x00000010L
    #define Uri_CREATE_CANONICALIZE                     0x00000100L
    #define Uri_CREATE_FILE_USE_DOS_PATH                0x00000020L
    #define Uri_CREATE_DECODE_EXTRA_INFO                0x00000040L
    #define Uri_CREATE_NO_DECODE_EXTRA_INFO             0x00000080L
    #define Uri_CREATE_CRACK_UNKNOWN_SCHEMES            0x00000200L
    #define Uri_CREATE_NO_CRACK_UNKNOWN_SCHEMES         0x00000400L
    #define Uri_CREATE_PRE_PROCESS_HTML_URI             0x00000800L
    #define Uri_CREATE_NO_PRE_PROCESS_HTML_URI          0x00001000L
    #define Uri_CREATE_IE_SETTINGS                      0x00002000L
    #define Uri_CREATE_NO_IE_SETTINGS                   0x00004000L
    #define Uri_CREATE_NO_ENCODE_FORBIDDEN_CHARACTERS   0x00008000L
#endif

/* URI display flags */
#if (_WIN32_IE >= 0x0700)
    #define Uri_DISPLAY_NO_FRAGMENT 0x00000001L
    #define Uri_PUNYCODE_IDN_HOST   0x00000002L
    #define Uri_DISPLAY_IDN_HOST    0x00000004L
#endif

/* URI encoding flags */
#if (_WIN32_IE >= 0x0700)
    #define Uri_ENCODING_USER_INFO_AND_PATH_IS_PERCENT_ENCODED_UTF8 0x00000001L
    #define Uri_ENCODING_USER_INFO_AND_PATH_IS_CP                   0x00000002L
    #define Uri_ENCODING_HOST_IS_IDN                                0x00000004L
    #define Uri_ENCODING_HOST_IS_PERCENT_ENCODED_UTF8               0x00000008L
    #define Uri_ENCODING_HOST_IS_PERCENT_ENCODED_CP                 0x00000010L
    #define Uri_ENCODING_QUERY_AND_FRAGMENT_IS_PERCENT_ENCODED_UTF8 0x00000020L
    #define Uri_ENCODING_QUERY_AND_FRAGMENT_IS_CP                   0x00000040L
    #define Uri_ENCODING_RFC \
        (Uri_ENCODING_USER_INFO_AND_PATH_IS_PERCENT_ENCODED_UTF8 | \
        Uri_ENCODING_HOST_IS_PERCENT_ENCODED_UTF8 | \
        Uri_ENCODING_QUERY_AND_FRAGMENT_IS_PERCENT_ENCODED_UTF8)
#endif

/* URI builder flags */
#if (_WIN32_IE >= 0x0700)
    #define UriBuilder_USE_ORIGINAL_FLAGS   0x00000001L
#endif

/* UrlDownloadToCacheFile() flags */
#define URLOSTRM_USECACHEDCOPY_ONLY 0x00000001L
#define URLOSTRM_USECACHEDCOPY      0x00000002L
#define URLOSTRM_GETNEWESTVERSION   0x00000003L

/* IWinInetInfo::QueryOption() options */
#define WININETINFO_OPTION_LOCK_HANDLE  65534L

/* CoInternetSetFeatureEnabled() flags */
#if (_WIN32_IE >= 0x0602)
    #define SET_FEATURE_ON_THREAD               0x00000001L
    #define SET_FEATURE_ON_PROCESS              0x00000002L
    #define SET_FEATURE_IN_REGISTRY             0x00000004L
    #define SET_FEATURE_ON_THREAD_LOCALMACHINE  0x00000008L
    #define SET_FEATURE_ON_THREAD_INTRANET      0x00000010L
    #define SET_FEATURE_ON_THREAD_TRUSTED       0x00000020L
    #define SET_FEATURE_ON_THREAD_INTERNET      0x00000040L
    #define SET_FEATURE_ON_THREAD_RESTRICTED    0x00000080L
#endif

/* CoInternetIsFeatureEnabled() flags */
#if (_WIN32_IE >= 0x0602)
    #define GET_FEATURE_FROM_THREAD                 0x00000001L
    #define GET_FEATURE_FROM_PROCESS                0x00000002L
    #define GET_FEATURE_FROM_REGISTRY               0x00000004L
    #define GET_FEATURE_FROM_THREAD_LOCALMACHINE    0x00000008L
    #define GET_FEATURE_FROM_THREAD_INTRANET        0x00000010L
    #define GET_FEATURE_FROM_THREAD_TRUSTED         0x00000020L
    #define GET_FEATURE_FROM_TRREAD_INTERNET        0x00000040L
    #define GET_FEATURE_FROM_THREAD_RESTRICTED      0x00000080L
#endif

/* Protocol flags */
#define PROTOCOLFLAG_NO_PICS_CHECK  0x00000001L

/* IInternetSecurityManager::MapUrlToZone() flags */
#define MUTZ_NOSAVEDFILECHECK       0x00000001L
#define MUTZ_ISFILE                 0x00000002L
#define MUTZ_ACCEPT_WILDCARD_SCHEME 0x00000080L
#define MUTZ_ENFORCERESTRICTED      0x00000100L
#define MUTZ_RESERVED               0x00000200L
#define MUTZ_REQUIRESAVEDFILECHECK  0x00000400L
#define MUTZ_DONT_UNESCAPE          0x00000800L
#define MUTZ_DONT_USE_CACHE         0x00001000L
#define MUTZ_FORCE_INTRANET_FLAGS   0x00002000L
#define MUTZ_IGNORE_ZONE_MAPPINGS   0x00004000L

/* Maximum security identifier size */
#define MAX_SIZE_SECURITY_ID    512

/* URL actions */
#define URLACTION_MIN                                       0x00001000L
#define URLACTION_DOWNLOAD_MIN                              0x00001000L
#define URLACTION_DOWNLOAD_SIGNED_ACTIVEX                   0x00001001L
#define URLACTION_DOWNLOAD_UNSIGNED_ACTIVEX                 0x00001004L
#define URLACTION_DOWNLOAD_CURR_MAX                         0x00001004L
#define URLACTION_DOWNLOAD_MAX                              0x000011FFL
#define URLACTION_ACTIVEX_MIN                               0x00001200L
#define URLACTION_ACTIVEX_RUN                               0x00001200L
#define URLACTION_ACTIVEX_OVERRIDE_OBJECT_SAFETY            0x00001201L
#define URLACTION_ACTIVEX_OVERRIDE_DATA_SAFETY              0x00001202L
#define URLACTION_ACTIVEX_OVERRIDE_SCRIPT_SAFETY            0x00001203L
#define URLACTION_ACTIVEX_CONFIRM_NOOBJECTSAFETY            0x00001204L
#define URLACTION_ACTIVEX_TREATASUNTRUSTED                  0x00001205L
#define URLACTION_ACTIVEX_NO_WEBOC_SCRIPT                   0x00001206L
#define URLACTION_ACTIVEX_OVERRIDE_REPURPOSEDETECTION       0x00001207L
#define URLACTION_ACTIVEX_OVERRIDE_OPTIN                    0x00001208L
#define URLACTION_ACTIVEX_SCRIPTLET_RUN                     0x00001209L
#define URLACTION_ACTIVEX_DYNSRC_VIDEO_AND_ANIMATION        0x0000120AL
#define URLACTION_ACTIVEX_OVERRIDE_DOMAINLIST               0x0000120BL
#define URLACTION_ACTIVEX_CURR_MAX                          0x0000120BL
#define URLACTION_ACTIVEX_MAX                               0x000013FFL
#define URLACTION_SCRIPT_MIN                                0x00001400L
#define URLACTION_SCRIPT_RUN                                0x00001400L
#define URLACTION_SCRIPT_OVERRIDE_SAFETY                    0x00001401L
#define URLACTION_SCRIPT_JAVA_USE                           0x00001402L
#define URLACTION_SCRIPT_SAFE_ACTIVEX                       0x00001405L
#define URLACTION_CROSS_DOMAIN_DATA                         0x00001406L
#define URLACTION_SCRIPT_PASTE                              0x00001407L
#define URLACTION_ALLOW_XDOMAIN_SUBFRAME_RESIZE             0x00001408L
#define URLACTION_SCRIPT_XSSFILTER                          0x00001409L
#define URLACTION_SCRIPT_CURR_MAX                           0x00001409L
#define URLACTION_SCRIPT_MAX                                0x000015FFL
#define URLACTION_HTML_MIN                                  0x00001600L
#define URLACTION_HTML_SUBMIT_FORMS                         0x00001601L
#define URLACTION_HTML_SUBMIT_FORMS_FROM                    0x00001602L
#define URLACTION_HTML_SUBMIT_FORMS_TO                      0x00001603L
#define URLACTION_HTML_FONT_DOWNLOAD                        0x00001604L
#define URLACTION_HTML_JAVA_RUN                             0x00001605L
#define URLACTION_HTML_USERDATA_SAVE                        0x00001606L
#define URLACTION_HTML_SUBFRAME_NAVIGATE                    0x00001607L
#define URLACTION_HTML_META_REFRESH                         0x00001608L
#define URLACTION_HTML_MIXED_CONTENT                        0x00001609L
#define URLACTION_HTML_INCLUDE_FILE_PATH                    0x0000160AL
#define URLACTION_HTML_MAX                                  0x000017FFL
#define URLACTION_SHELL_MIN                                 0x00001800L
#define URLACTION_SHELL_INSTALL_DTITEMS                     0x00001800L
#define URLACTION_SHELL_MOVE_OR_COPY                        0x00001802L
#define URLACTION_SHELL_FILE_DOWNLOAD                       0x00001803L
#define URLACTION_SHELL_VERB                                0x00001804L
#define URLACTION_SHELL_WEBVIEW_VERB                        0x00001805L
#define URLACTION_SHELL_SHELLEXECUTE                        0x00001806L
#if (_WIN32_IE >= 0x0602)
    #define URLACTION_SHELL_EXECUTE_HIGHRISK                0x00001806L
    #define URLACTION_SHELL_EXECUTE_MODRISK                 0x00001807L
    #define URLACTION_SHELL_EXECUTE_LOWRISK                 0x00001808L
    #define URLACTION_SHELL_POPUPMGR                        0x00001809L
    #define URLACTION_SHELL_RTF_OBJECTS_LOAD                0x0000180AL
    #define URLACTION_SHELL_ENHANCED_DRAGDROP_SECURITY      0x0000180BL
    #define URLACTION_SHELL_EXTENSIONSECURITY               0x0000180CL
    #define URLACTION_SHELL_SECURE_DRAGSOURCE               0x0000180DL
#endif
#if (_WIN32_IE >= 0x0800)
    #define URLACTION_SHELL_REMOTEQUERY                     0x0000180EL
    #define URLACTION_SHELL_PREVIEW                         0x0000180FL
#endif
#define URLACTION_SHELL_CURR_MAX                            0x0000180FL
#define URLACTION_SHELL_MAX                                 0x000019FFL
#define URLACTION_NETWORK_MIN                               0x00001A00L
#define URLACTION_CREDENTIALS_USE                           0x00001A00L
#define URLACTION_AUTHENTICATE_CLIENT                       0x00001A01L
#define URLACTION_COOKIES                                   0x00001A02L
#define URLACTION_COOKIES_SESSION                           0x00001A03L
#define URLACTION_CLIENT_CERT_PROMPT                        0x00001A04L
#define URLACTION_COOKIES_THIRD_PARTY                       0x00001A05L
#define URLACTION_COOKIES_SESSION_THIRD_PARTY               0x00001A06L
#define URLACTION_COOKIES_ENABLED                           0x00001A10L
#define URLACTION_NETWORK_CURR_MAX                          0x00001A10L
#define URLACTION_NETWORK_MAX                               0x00001BFFL
#define URLACTION_JAVA_MIN                                  0x00001C00L
#define URLACTION_JAVA_PERMISSIONS                          0x00001C00L
#define URLACTION_JAVA_CURR_MAX                             0x00001C00L
#define URLACTION_JAVA_MAX                                  0x00001CFFL
#define URLACTION_INFODELIVERY_MIN                          0x00001D00L
#define URLACTION_INFODELIVERY_NO_ADDING_CHANNELS           0x00001D00L
#define URLACTION_INFODELIVERY_NO_EDITING_CHANNELS          0x00001D01L
#define URLACTION_INFODELIVERY_NO_REMOVING_CHANNELS         0x00001D02L
#define URLACTION_INFODELIVERY_NO_ADDING_SUBSCRIPTIONS      0x00001D03L
#define URLACTION_INFODELIVERY_NO_EDITING_SUBSCRIPTIONS     0x00001D04L
#define URLACTION_INFODELIVERY_NO_REMOVING_SUBSCRIPTIONS    0x00001D05L
#define URLACTION_INFODELIVERY_NO_CHANNEL_LOGGING           0x00001D06L
#define URLACTION_INFODELIVERY_CURR_MAX                     0x00001D06L
#define URLACTION_INFODELIVERY_MAX                          0x00001DFFL
#define URLACTION_CHANNEL_SOFTDIST_MIN                      0x00001E00L
#define URLACTION_CHANNEL_SOFTDIST_PERMISSIONS              0x00001E05L
#define URLACTION_CHANNEL_SOFTDIST_MAX                      0x00001EFFL
#if (_WIN32_IE >= 0x0800)
    #define URLACTION_DOTNER_USERCONTROLS                   0x00002005L
#endif
#if (_WIN32_IE >= 0x0602)
    #define URLACTION_BEHAVIOR_MIN                          0x00002000L
    #define URLACTION_BEHAVIOR_RUN                          0x00002000L
    #define URLACTION_FEATURE_MIN                           0x00002100L
    #define URLACTION_FEATURE_MIME_SNIFFING                 0x00002100L
    #define URLACTION_FEATURE_ZONE_ELEVATION                0x00002101L
    #define URLACTION_FEATURE_WINDOW_RESTRICTIONS           0x00002102L
    #define URLACTION_FEATURE_SCRIPT_STATUS_BAR             0x00002103L
    #define URLACTION_FEATURE_FORCE_ADDR_AND_STATUS         0x00002104L
    #define URLACTION_FEATURE_BLOCK_INPUT_PROMPTS           0x00002105L
    #define URLACTION_FEATURE_DATA_BINDING                  0x00002106L
    #define URLACTION_AUTOMATIC_DOWNLOAD_UI_MIN             0x00002200L
    #define URLACTION_AUTOMATIC_DOWNLOAD_UI                 0x00002200L
    #define URLACTION_AUTOMATIC_ACTIVEX_UI                  0x00002201L
    #define URLACTION_ALLOW_RESTRICTEDPROTOCOLS             0x00002300L
#endif
#if (_WIN32_IE >= 0x0700)
    #define URLACTION_ALLOW_APEVALUATION                    0x00002301L
    #define URLACTION_WINDOWS_BROWSER_APPLICATIONS          0x00002400L
    #define URLACTION_XPS_DOCUMENTS                         0x00002401L
    #define URLACTION_LOOSE_XAML                            0x00002402L
    #define URLACTION_LOWRIGHTS                             0x00002500L
    #define URLACTION_WINFX_SETUP                           0x00002600L
    #define URLACTION_INPRIVATE_BLOCKING                    0x00002700L
#endif

/* URL policy ActiveX options */
#define URLPOLICY_ACTIVEX_CHECK_LIST        0x00010000L

/* URL policy credential options */
#define URLPOLICY_CREDENTIALS_SILENT_LOGON_OK       0x00000000L
#define URLPOLICY_CREDENTIALS_MUST_PROMPT_USER      0x00010000L
#define URLPOLICY_CREDENTIALS_CONDITIONAL_PROMPT    0x00020000L
#define URLPOLICY_CREDENTIALS_ANONYMOUS_ONLY        0x00030000L

/* URL policy authentication options */
#define URLPOLICY_AUTHENTICATE_CLEARTEXT_OK         0x00000000L
#define URLPOLICY_AUTHENTICATE_CHALLENGE_RESPONSE   0x00010000L
#define URLPOLICY_AUTHENTICATE_MUTUAL_ONLY          0x00030000L

/* URL policy Java options */
#define URLPOLICY_JAVA_PROHIBIT 0x00000000L
#define URLPOLICY_JAVA_HIGH     0x00010000L
#define URLPOLICY_JAVA_MEDIUM   0x00020000L
#define URLPOLICY_JAVA_LOW      0x00030000L
#define URLPOLICY_JAVA_CUSTOM   0x00800000L

/* URL policy channel software distribution options */
#define URLPOLICY_CHANNEL_SOFTDIST_PROHIBIT     0x00010000L
#define URLPOLICY_CHANNEL_SOFTDIST_PRECACHE     0x00020000L
#define URLPOLICY_CHANNEL_SOFTDIST_AUTOINSTALL  0x00030000L

/* URL policy behavior options */
#if (_WIN32_IE >= 0x0602)
    #define URLPOLICY_BEHAVIOR_CHECK_LIST   0x00010000L
#endif

/* General URL policy options */
#define URLPOLICY_ALLOW                 0x00000000L
#define URLPOLICY_QUERY                 0x00000001L
#define URLPOLICY_DISALLOW              0x00000003L
#define URLPOLICY_NOTIFY_ON_ALLOW       0x00000010L
#define URLPOLICY_NOTIFY_ON_DISALLOW    0x00000020L
#define URLPOLICY_LOG_ON_ALLOW          0x00000040L
#define URLPOLICY_LOG_ON_DISALLOW       0x00000080L
#define URLPOLICY_MASK_PERMISSIONS      0x0000000FL
#define URLPOLICY_DONTCHECKDLGBOX       0x00000100L

/* Macros to manipulate URL policy options */
#define GetUrlPolicyPermissions( x )    (x & URLPOLICY_MASK_PERMISSIONS)
#define SetUrlPolicyPermissions( x, p ) ((x) = ((x) & ~URLPOLICY_MASK_PERMISSIONS) | (p))

/* IInternetSecurityManager::SetZoneMapping() flags */
#define URLZONE_ESC_FLAG    0x00000100L

/* Security states */
#if (_WIN32_IE >= 0x0700)
    #define SECURITY_IE_STATE_GREEN 0x00000000L
    #define SECURITY_IE_STATE_RED   0x00000001L
#endif

/* Software distribution flags */
#define SOFTDIST_FLAG_USAGE_EMAIL           0x00000001L
#define SOFTDIST_FLAG_USAGE_PRECACHE        0x00000002L
#define SOFTDIST_FLAG_USAGE_AUTOINSTALL     0x00000004L
#define SOFTDIST_FLAG_DELETE_SUBSCRIPTION   0x00000008L

/* Software distribution advertised states */
#define SOFTDIST_ADSTATE_NONE       0x00000000L
#define SOFTDIST_ADSTATE_AVAILABLE  0x00000001L
#define SOFTDIST_ADSTATE_DOWNLOADED 0x00000002L
#define SOFTDIST_ADSTATE_INSTALLED  0x00000003L

/* Confirm safety actions */
#define CONFIRMSAFETYACTION_LOADOBJECT  0x00000001L

/* Moniker properties */
typedef enum {
    MIMETYPEPROP        = 0x00000000,
    USE_SRC_URL         = 0x00000001,
    CLASSIDPROP         = 0x00000002,
    TRUSTEDDOWNLOADPROP = 0x00000003,
    POPUPLEVELPROP      = 0x00000004
} MONIKERPROPERTY;

/* Bind verbs */
typedef enum {
    BINDVERB_GET    = 0x00000000,
    BINDVERB_POST   = 0x00000001,
    BINDVERB_PUT    = 0x00000002,
    BINDVERB_CUSTOM = 0x00000003
} BINDVERB;

/* Bind information flags */
typedef enum {
    BINDINFOF_URLENCODESTGMEDDATA   = 0x00000001,
    BINDINFOF_URLENCODEDEXTRAINFO   = 0x00000002
} BINDINFOF;

/* Bind flags */
typedef enum {
    BINDF_ASYNCHRONOUS              = 0x00000001,
    BINDF_ASYNCSTORAGE              = 0x00000002,
    BINDF_NOPROGRESSIVERENDERING    = 0x00000004,
    BINDF_OFFLINEOPERATION          = 0x00000008,
    BINDF_GETNEWESTVERSION          = 0x00000010,
    BINDF_NOWRITECACHE              = 0x00000020,
    BINDF_NEEDFILE                  = 0x00000040,
    BINDF_PULLDATA                  = 0x00000080,
    BINDF_IGNORESECURITYPROBLEM     = 0x00000100,
    BINDF_RESYNCHRONIZE             = 0x00000200,
    BINDF_HYPERLINK                 = 0x00000400,
    BINDF_NO_UI                     = 0x00000800,
    BINDF_SILENTOPERATION           = 0x00001000,
    BINDF_PRAGMA_NO_CACHE           = 0x00002000,
    BINDF_GETCLASSOBJECT            = 0x00004000,
    BINDF_FREE_THREADED             = 0x00010000,
    BINDF_DIRECT_READ               = 0x00020000,
    BINDF_FORMS_SUBMIT              = 0x00040000,
    BINDF_GETFROMCACHE_IF_NET_FAIL  = 0x00080000,
    BINDF_FROMURLMON                = 0x00100000,
    BINDF_FWD_BACK                  = 0x00200000,
    BINDF_PREFERDEFAULTHANDLER      = 0x00400000,
    BINDF_ENFORCERESTRICTED         = 0x00800000
} BINDF;

/* URL encodings */
typedef enum {
    URL_ENCODING_NONE           = 0x00000000,
    URL_ENCODING_ENABLE_UTF8    = 0x10000000,
    URL_ENCODING_DISABLE_UTF8   = 0x20000000
} URL_ENCODING;

/* Bind information */
typedef struct _tagBINDINFO {
    ULONG               cbSize;
    LPWSTR              szExtraInfo;
    STGMEDIUM           stgmedData;
    DWORD               grfBindInfoF;
    DWORD               dwBindVerb;
    LPWSTR              szCustomVerb;
    DWORD               cbstgmedData;
    DWORD               dwOptions;
    DWORD               dwOptionsFlags;
    DWORD               dwCodePage;
    SECURITY_ATTRIBUTES securityAttributes;
    IID                 iid;
    IUnknown            *pUnk;
    DWORD               dwReserved;
} BINDINFO;

/* Bind information options */
typedef enum {
    BINDINFO_OPTIONS_WININETFLAG                = 0x00010000,
    BINDINFO_OPTIONS_ENABLE_UTF8                = 0x00020000,
    BINDINFO_OPTIONS_DISABLE_UTF8               = 0x00040000,
    BINDINFO_OPTIONS_USE_IE_ENCODING            = 0x00080000,
    BINDINFO_OPTIONS_BINDTOOBJECT               = 0x00100000,
    BINDINFO_OPTIONS_SECURITYOPTOUT             = 0x00200000,
    BINDINFO_OPTIONS_IGNOREMIMETEXTPLAIN        = 0x00400000,
    BINDINFO_OPTIONS_USEBINDSTRINGCREDS         = 0x00800000,
    BINDINFO_OPTIONS_IGNOREHTTPHTTPSREDIRECTS   = 0x01000000,
    BINDINFO_OPTIONS_IGNORE_SSLERRORS_ONCE      = 0x02000000,
    BINDINFO_WPC_DOWNLOADBLOCKED                = 0x08000000,
    BINDINFO_WPC_LOGGING_ENABLED                = 0x10000000,
    BINDINFO_OPTIONS_ALLOWCONNECTDATA           = 0x20000000,
    BINDINFO_OPTIONS_DISABLEAUTOREDIRECTS       = 0x40000000,
    BINDINFO_OPTIONS_SHDOCVW_NAVIGATE           = 0x80000000
} BINDINFO_OPTIONS;

/* Bind status callback flags */
typedef enum {
    BSCF_FIRSTDATANOTIFICATION          = 0x00000001,
    BSCF_INTERMEDIATEDATANOTIFICATION   = 0x00000002,
    BSCF_LASTDATANOTIFICATION           = 0x00000004,
    BSCF_DATAFULLYAVAILABLE             = 0x00000008,
    BSCF_AVAILABLEDATASIZEUNKNOWN       = 0x00000010,
    BSCF_SKIPDRAINDATAFORFILEURLS       = 0x00000020,
    BSCF_64BITLENGTHDOWNLOAD            = 0x00000040
} BSCF;

/* Bind status values */
typedef enum {
    BINDSTATUS_FINDINGRESOURCE              = 1,
    BINDSTATUS_CONNECTING                   = 2,
    BINDSTATUS_REDIRECTING                  = 3,
    BINDSTATUS_BEGINDOWNLOADDATA            = 4,
    BINDSTATUS_DOWNLOADINGDATA              = 5,
    BINDSTATUS_ENDDOWNLOADDATA              = 6,
    BINDSTATUS_BEGINDOWNLOADCOMPONENTS      = 7,
    BINDSTATUS_INSTALLINGCOMPONENTS         = 8,
    BINDSTATUS_ENDDOWNLOADCOMPONENTS        = 9,
    BINDSTATUS_USINGCACHEDCOPY              = 10,
    BINDSTATUS_SENDINGREQUEST               = 11,
    BINDSTATUS_CLASSIDAVAILABLE             = 12,
    BINDSTATUS_MIMETYPEAVAILABLE            = 13,
    BINDSTATUS_CACHEFILENAMEAVAILABLE       = 14,
    BINDSTATUS_BEGINSYNCOPERATION           = 15,
    BINDSTATUS_ENDSYNCOPERATION             = 16,
    BINDSTATUS_BEGINUPLOADDATA              = 17,
    BINDSTATUS_UPLOADINGDATA                = 18,
    BINDSTATUS_ENDUPLOADDATA                = 19,
    BINDSTATUS_PROTOCOLCLASSID              = 20,
    BINDSTATUS_ENCODING                     = 21,
    BINDSTATUS_VERIFIEDMIMETYPEAVAILABLE    = 22,
    BINDSTATUS_CLASSINSTALLLOCATION         = 23,
    BINDSTATUS_DECODING                     = 24,
    BINDSTATUS_LOADINGMIMEHANDLER           = 25,
    BINDSTATUS_CONTENTDISPOSITIONATTACH     = 26,
    BINDSTATUS_FILTERREPORTMIMETYPE         = 27,
    BINDSTATUS_CLSIDCANINSTANTIATE          = 28,
    BINDSTATUS_IUNKNOWNAVAILABLE            = 29,
    BINDSTATUS_DIRECTBIND                   = 30,
    BINDSTATUS_RAWMIMETYPE                  = 31,
    BINDSTATUS_PROXYDETECTING               = 32,
    BINDSTATUS_ACCEPTRANGES                 = 33,
    BINDSTATUS_COOKIE_SENT                  = 34,
    BINDSTATUS_COMPACT_POLICY_RECEIVED      = 35,
    BINDSTATUS_COOKIE_SUPPRESSED            = 36,
    BINDSTATUS_COOKIE_STATE_UNKNOWN         = 37,
    BINDSTATUS_COOKIE_STATE_ACCEPT          = 38,
    BINDSTATUS_COOKIE_STATE_REJECT          = 39,
    BINDSTATUS_COOKIE_STATE_PROMPT          = 40,
    BINDSTATUS_COOKIE_STATE_LEASH           = 41,
    BINDSTATUS_COOKIE_STATE_DOWNGRADE       = 42,
    BINDSTATUS_POLICY_HREF                  = 43,
    BINDSTATUS_P3P_HEADER                   = 44,
    BINDSTATUS_SESSION_COOKIE_RECEIVED      = 45,
    BINDSTATUS_PERSISTENT_COOKIE_RECEIVED   = 46,
    BINDSTATUS_SESSION_COOKIE_ALLOWED       = 47,
    BINDSTATUS_CACHECONTROL                 = 48,
    BINDSTATUS_CONTENTDISPOSITIONFILENAME   = 49,
    BINDSTATUS_MIMETEXTPLAINMISMATCH        = 50,
    BINDSTATUS_PUBLISHERAVAILABLE           = 51,
    BINDSTATUS_DISPLAYNAMEAVAILABLE         = 52,
    BINDSTATUS_SSLUX_NAVBLOCKED             = 53,
    BINDSTATUS_SERVER_MIMETYPEAVAILABLE     = 54,
    BINDSTATUS_SNIFFED_CLASSIDAVAILABLE     = 55,
    BINDSTATUS_64BIT_PROGRESS               = 56
} BINDSTATUS;

/* Bind flags (level 2) */
typedef enum {
    BINDF2_DISABLEBASICOVERHTTP                 = 0x00000001,
    BINDF2_DISABLEAUTOCOOKIEHANDLING            = 0x00000002,
    BINDF2_READ_DATA_GREATER_THAN_4GB           = 0x00000004,
    BINDF2_DISABLE_HTTP_REDIRECT_XSECURITYID    = 0x00000008
} BINDF2;

/* Authenticate flags */
typedef enum {
    AUTHENTICATEF_PROXY = 0x00000001,
    AUTHENTICATEF_BASIC = 0x00000002,
    AUTHENTICATEF_HTTP  = 0x00000004
} AUTHENTICATEF;

/* Authenticate information */
typedef struct _tagAUTHENTICATEINFO {
    DWORD   dwFlags;
    DWORD   dwReserved;
} AUTHENTICATEINFO;

/* Code install problems */
typedef enum {
    CIP_DISK_FULL                               = 0,
    CIP_ACCESS_DENIED                           = 1,
    CIP_NEWER_VERSION_EXISTS                    = 2,
    CIP_OLDER_VERSION_EXISTS                    = 3,
    CIP_NAME_CONFLICT                           = 4,
    CIP_TRUST_VERIFICATION_COMPONENT_MISSING    = 5,
    CIP_EXE_SELF_REGISTERATION_TIMEOUT          = 6,
    CIP_UNSAFE_TO_ABORT                         = 7,
    CIP_NEED_REBOOT                             = 8,
    CIP_NEED_REBOOT_UI_PERMISSION               = 9,
} CIP_STATUS;

/* URI properties */
#if (_WIN32_IE >= 0x0700)
typedef enum {
    Uri_PROPERTY_ABSOLUTE_URI   = 0,
    Uri_PROPERTY_STRING_START   = Uri_PROPERTY_ABSOLUTE_URI,
    Uri_PROPERTY_AUTHORITY      = 1,
    Uri_PROPERTY_DISPLAY_URI    = 2,
    Uri_PROPERTY_DOMAIN         = 3,
    Uri_PROPERTY_EXTENSION      = 4,
    Uri_PROPERTY_FRAGMENT       = 5,
    Uri_PROPERTY_HOST           = 6,
    Uri_PROPERTY_PASSWORD       = 7,
    Uri_PROPERTY_PATH           = 8,
    Uri_PROPERTY_PATH_AND_QUERY = 9,
    Uri_PROPERTY_QUERY          = 10,
    Uri_PROPERTY_RAW_URI        = 11,
    Uri_PROPERTY_SCHEME_NAME    = 12,
    Uri_PROPERTY_USER_INFO      = 13,
    Uri_PROPERTY_USER_NAME      = 14,
    Uri_PROPERTY_STRING_LAST    = Uri_PROPERTY_USER_NAME,
    Uri_PROPERTY_HOST_TYPE      = 15,
    Uri_PROPERTY_DWORD_START    = Uri_PROPERTY_HOST_TYPE,
    Uri_PROPERTY_PORT           = 16,
    Uri_PROPERTY_SCHEME         = 17,
    Uri_PROPERTY_ZONE           = 18,
    Uri_PROPERTY_DWORD_LAST     = Uri_PROPERTY_ZONE
} Uri_PROPERTY;
#endif

/* URI host types */
#if (_WIN32_IE >= 0x0700)
typedef enum {
    Uri_HOST_UNKNOWN    = 0,
    Uri_HOST_DNS        = 1,
    Uri_HOST_IPV4       = 2,
    Uri_HOST_IPV6       = 3,
    Uri_HOST_IDN        = 4
} Uri_HOST_TYPE;
#endif

/* IUri::GetProperties() flags */
#if (_WIN32_IE >= 0x0700)
    #define Uri_HAS_ABSOLUTE_URI    (1 << Uri_PROPERTY_ABSOLUTE_URI)
    #define Uri_HAS_AUTHORITY       (1 << Uri_PROPERTY_AUTHORITY)
    #define Uri_HAS_DISPLAY_URI     (1 << Uri_PROPERTY_DISPLAY_URI)
    #define Uri_HAS_DOMAIN          (1 << Uri_PROPERTY_DOMAIN)
    #define Uri_HAS_EXTENSION       (1 << Uri_PROPERTY_EXTENSION)
    #define Uri_HAS_FRAGMENT        (1 << Uri_PROPERTY_FRAGMENT)
    #define Uri_HAS_HOST            (1 << Uri_PROPERTY_HOST)
    #define Uri_HAS_PASSWORD        (1 << Uri_PROPERTY_PASSWORD)
    #define Uri_HAS_PATH            (1 << Uri_PROPERTY_PATH)
    #define Uri_HAS_QUERY           (1 << Uri_PROPERTY_QUERY)
    #define Uri_HAS_RAW_URI         (1 << Uri_PROPERTY_RAW_URI)
    #define Uri_HAS_SCHEME_NAME     (1 << Uri_PROPERTY_SCHEME_NAME)
    #define Uri_HAS_USER_NAME       (1 << Uri_PROPERTY_USER_NAME)
    #define Uri_HAS_PATH_AND_QUERY  (1 << Uri_PROPERTY_PATH_AND_QUERY)
    #define Uri_HAS_USER_INFO       (1 << Uri_PROPERTY_USER_INFO)
    #define Uri_HAS_HOST_TYPE       (1 << Uri_PROPERTY_HOST_TYPE)
    #define Uri_HAS_PORT            (1 << Uri_PROPERTY_PORT)
    #define Uri_HAS_SCHEME          (1 << Uri_PROPERTY_SCHEME)
    #define Uri_HAS_ZONE            (1 << Uri_PROPERTY_ZONE)
#endif

/* URLOpenStream() callback function */
typedef HRESULT (STDAPICALLTYPE *LPFNOSCALLBACK)( IBindStatusCallback * );

/* Bind strings */
typedef enum tagBINDSTRING {
    BINDSTRING_HEADERS              = 1,
    BINDSTRING_ACCEPT_MIMES         = 2,
    BINDSTRING_EXTRA_URL            = 3,
    BINDSTRING_LANGUAGE             = 4,
    BINDSTRING_USERNAME             = 5,
    BINDSTRING_PASSWORD             = 6,
    BINDSTRING_UA_PIXELS            = 7,
    BINDSTRING_UA_COLOR             = 8,
    BINDSTRING_OS                   = 9,
    BINDSTRING_USER_AGENT           = 10,
    BINDSTRING_ACCEPT_ENCODINGS     = 11,
    BINDSTRING_POST_COOKIE          = 12,
    BINDSTRING_POST_DATA_MIME       = 13,
    BINDSTRING_URL                  = 14,
    BINDSTRING_IID                  = 15,
    BINDSTRING_FLAG_BIND_TO_OBJECT  = 16,
    BINDSTRING_PTR_BIND_CONTEXT     = 17,
    BINDSTRING_XDR_ORIGIN           = 18
} BINDSTRING;

/* Asynchronous protocol handler flags */
typedef enum _tagPI_FLAGS {
    PI_PARSE_URL            = 0x00000001,
    PI_FILTER_MODE          = 0x00000002,
    PI_FORCE_ASYNC          = 0x00000004,
    PI_USE_WORKERTHREAD     = 0x00000008,
    PI_MIMEVERIFICATION     = 0x00000010,
    PI_CLSIDLOOKUP          = 0x00000020,
    PI_DATAPROGRESS         = 0x00000040,
    PI_SYNCHRONOUS          = 0x00000080,
    PI_APARTMENTTHREADED    = 0x00000100,
    PI_CLASSINSTALL         = 0x00000200,
    PI_PASSONBINDCTX        = 0x00002000,
    PI_NOMIMEHANDLER        = 0x00008000,
    PI_LOADAPPDIRECT        = 0x00004000,
    PI_FORCE_SWITCH         = 0x00010000,
    PI_PREFERDEFAULTHANDLER = 0x00020000
} PI_FLAGS;

/* Protocol data */
typedef struct _tagPROTOCOLDATA {
    DWORD   grfFlags;
    DWORD   dwState;
    LPVOID  pData;
    ULONG   cbData;
} PROTOCOLDATA;

/* Start parameter */
typedef struct _tagStartParam {
    IID         iid;
    IBindCtx    *pIBindCtx;
    IUnknown    *pItf;
} StartParam;

/* Obsolete flags for compatibility */
typedef enum _tagOIBDG_FLAGS {
    OIBDG_APARTMENTTHREADED = 0x00000100,
    OIBDG_DATAONLY          = 0x00001000
} OIBDG_FLAGS;

/* Parse actions */
typedef enum _tagPARSEACTION {
    PARSE_CANONICALIZE          = 1,
    PARSE_FRIENDLY              = 2,
    PARSE_SECURITY_URL          = 3,
    PARSE_ROOTDOCUMENT          = 4,
    PARSE_DOCUMENT              = 5,
    PARSE_ANCHOR                = 6,
    PARSE_ENCODE_IS_UNESCAPE    = 7,
    PARSE_DECODE_IS_ESCAPE      = 8,
    PARSE_PATH_FROM_URL         = 9,
    PARSE_URL_FROM_PATH         = 10,
    PARSE_MIME                  = 11,
    PARSE_SERVER                = 12,
    PARSE_SCHEMA                = 13,
    PARSE_SITE                  = 14,
    PARSE_DOMAIN                = 15,
    PARSE_LOCATION              = 16,
    PARSE_SECURITY_DOMAIN       = 17,
    PARSE_ESCAPE                = 18,
    PARSE_UNESCAPE              = 19
} PARSEACTION;

/* Old names for compatibility */
#ifndef URLMON_STRICT
    #define PARSE_ENCODE    PARSE_ENCODE_IS_UNESCAPE
    #define PARSE_DECODE    PARSE_DECODE_IS_ESCAPE
#endif

/* CoInternetGetSecurityURL() actions */
typedef enum _tagPSUACTION {
    PSU_DEFAULT             = 1,
    PSU_SECURITY_URL_ONLY   = 2
} PSUACTION;

/* Query options */
typedef enum _tagQUERYOPTION {
    QUERY_EXPIRATION_DATE       = 1,
    QUERY_TIME_OF_LAST_CHANGE   = 2,
    QUERY_CONTENT_ENCODING      = 3,
    QUERY_CONTENT_TYPE          = 4,
    QUERY_REFRESH               = 5,
    QUERY_RECOMBINE             = 6,
    QUERY_CAN_NAVIGATE          = 7,
    QUERY_USES_NETWORK          = 8,
    QUERY_IS_CACHED             = 9,
    QUERY_IS_INSTALLEDENTRY     = 10,
    QUERY_IS_CACHED_OR_MAPPED   = 11,
    QUERY_USES_CACHE            = 12,
    QUERY_IS_SECURE             = 13,
    QUERY_IS_SAFE               = 14,
    QUERY_USES_HISTORYFOLDER    = 15
} QUERYOPTION;

/* Internet feature options */
#if (_WIN32_IE >= 0x0602)
typedef enum _tagINTERNETFEATURELIST {
    FEATURE_OBJECT_CACHING                  = 0,
    FEATURE_ZONE_ELEVATION                  = 1,
    FEATURE_MIME_HANDLING                   = 2,
    FEATURE_MIME_SNIFFING                   = 3,
    FEATURE_WINDOW_RESTRICTIONS             = 4,
    FEATURE_WEBOC_POPUPMANAGEMENT           = 5,
    FEATURE_BEHAVIORS                       = 6,
    FEATURE_DISABLE_MK_PROTOCOL             = 7,
    FEATURE_LOCALMACHINE_LOCKDOWN           = 8,
    FEATURE_SECURITYBAND                    = 9,
    FEATURE_RESTRICT_ACTIVEXINSTALL         = 10,
    FEATURE_VALIDATE_NAVIGATE_URL           = 11,
    FEATURE_RESTRICT_FILEDOWNLOAD           = 12,
    FEATURE_ADDON_MANAGEMENT                = 13,
    FEATURE_PROTOCOL_LOCKDOWN               = 14,
    FEATURE_HTTP_USERNAME_PASSWORD_DISABLE  = 15,
    FEATURE_SAFE_BINDTOOBJECT               = 16,
    FEATURE_UNC_SAVEDFILECHECK              = 17,
    FEATURE_GET_URL_DOM_FILEPATH_UNENCODED  = 18,
    FEATURE_TABBED_BROWSING                 = 19,
    FEATURE_SSLUX                           = 20,
    FEATURE_DISABLE_NAVIGATION_SOUNDS       = 21,
    FEATURE_DISABLE_LEGACY_COMPRESSION      = 22,
    FEATURE_FORCE_ADDR_AND_STATUS           = 23,
    FEATURE_XMLHTTP                         = 24,
    FEATURE_DISABLE_TELNET_PROTOCOL         = 25,
    FEATURE_FEEDS                           = 26,
    FEATURE_BLOCK_INPUT_PROMPTS             = 27,
    FEATURE_ENTRY_COUNT                     = 28
} INTERNETFEATURELIST;
#endif

/* IInternetSecurityManager::ProcessUrlAction() flags */
typedef enum {
    PUAF_DEFAULT                        = 0x00000000,
    PUAF_NOUI                           = 0x00000001,
    PUAF_ISFILE                         = 0x00000002,
    PUAF_WARN_IF_DENIED                 = 0x00000004,
    PUAF_FORCEUI_FOREGROUND             = 0x00000008,
    PUAF_CHECK_TIFS                     = 0x00000010,
    PUAF_DONTCHECKBOXINDIALOG           = 0x00000020,
    PUAF_TRUSTED                        = 0x00000040,
    PUAF_ACCEPT_WILDCARD_SCHEME         = 0x00000080,
    PUAF_ENFORCERESTRICTED              = 0x00000100,
    PUAF_NOSAVEDFILECHECK               = 0x00000200,
    PUAF_REQUIRESAVEDFILECHECK          = 0x00000400,
    PUAF_DONT_USE_CACHE                 = 0x00001000,
    PUAF_LMZ_UNLOCKED                   = 0x00010000,
    PUAF_LMZ_LOCKED                     = 0x00020000,
    PUAF_DEFAULTZONEPOL                 = 0x00040000,
    PUAF_NPL_USE_LOCKED_IF_RESTRICTED   = 0x00080000,
    PUAF_NOUIIFLOCKED                   = 0x00100000,
    PUAF_DRAGPROTOCOLCHECK              = 0x00200000
} PUAF;

/* IInternetSecurityManager::ProcessUrlAction() output flags */
typedef enum {
    PUAOUT_DEFUALT          = 0x00000000,
    PUAOUT_ISZONELOCKPOLICY = 0x00000001
} PUAOUT;

/* IInternetSecurityManager::SetZoneMapping() flags */
typedef enum {
    SZM_CREATE  = 0x00000000,
    SZM_DELETE  = 0x00000001
} SZM_FLAGS;

/* URL zones */
typedef enum {
    URLZONE_INVALID         = -1,
    URLZONE_PREDEFINED_MIN  = 0,
    URLZONE_LOCAL_MACHINE   = 0,
    URLZONE_INTRANET        = 1,
    URLZONE_TRUSTED         = 2,
    URLZONE_INTERNET        = 3,
    URLZONE_UNTRUSTED       = 4,
    URLZONE_PREDEFINED_MAX  = 999,
    URLZONE_USER_MIN        = 1000,
    URLZONE_USER_MAX        = 10000
} URLZONE;

/* URL templates */
typedef enum tagURLTEMPLATE {
    URLTEMPLATE_CUSTOM          = 0x00000000,
    URLTEMPLATE_PREDEFINED_MIN  = 0x00010000,
    URLTEMPLATE_LOW             = 0x00010000,
    URLTEMPLATE_MEDLOW          = 0x00010500,
    URLTEMPLATE_MEDIUM          = 0x00011000,
    URLTEMPLATE_MEDHIGH         = 0x00011500,
    URLTEMPLATE_HIGH            = 0x00012000,
    URLTEMPLATE_PREDEFINED_MAX  = 0x00020000
} URLTEMPLATE;

/* Zone maximum string lengths */
enum {
    MAX_ZONE_PATH           = 260,
    MAX_ZONE_DESCRIPTION    = 200
};

/* Zone attribute flags */
typedef enum {
    ZAFLAGS_CUSTOM_EDIT                 = 0x00000001,
    ZAFLAGS_ADD_SITES                   = 0x00000002,
    ZAFLAGS_REQUIRE_VERIFICATION        = 0x00000004,
    ZAFLAGS_INCLUDE_PROXY_OVERRIDE      = 0x00000008,
    ZAFLAGS_INCLUDE_INTRANET_SITES      = 0x00000010,
    ZAFLAGS_NO_UI                       = 0x00000020,
    ZAFLAGS_SUPPORTS_VERIFICATION       = 0x00000040,
    ZAFLAGS_UNC_AS_INTERNET             = 0x00000080,
    ZAFLAGS_DETECT_INTRANET             = 0x00000100,
    ZAFLAGS_USE_LOCKED_ZONES            = 0x00010000,
    ZAFLAGS_VERIFY_TEMPLATE_SETTINGS    = 0x00020000,
    ZAFLAGS_NO_CACHE                    = 0x00040000
} ZAFLAGS;

/* Zone attributes */
typedef struct _ZONEATTRIBUTES {
    ULONG   cbSize;
    WCHAR   szDisplayName[MAX_ZONE_PATH];
    WCHAR   szDescription[MAX_ZONE_DESCRIPTION];
    WCHAR   szIconPath[MAX_ZONE_PATH];
    DWORD   dwTemplateMinLevel;
    DWORD   dwTemplateRecommended;
    DWORD   dwTemplateCurrentLevel;
    DWORD   dwFlags;
} ZONEATTRIBUTES;
typedef ZONEATTRIBUTES  *LPZONEATTRIBUTES;

/* URL zone registration flags */
typedef enum _URLZONEREG {
    URLZONEREG_DEFAULT  = 0,
    URLZONEREG_HKLM     = 1,
    URLZONEREG_HKCU     = 2
} URLZONEREG;

/* Code base hold */
typedef struct _tagCODEBASEHOLD {
    ULONG   cbSize;
    LPWSTR  szDistUnit;
    LPWSTR  szCodeBase;
    DWORD   dwVersionMS;
    DWORD   dwVersionLS;
    DWORD   dwStyle;
} CODEBASEHOLD;
typedef CODEBASEHOLD    *LPCODEBASEHOLD;

/* Software distribution information */
typedef struct _tagSOFTDISTINFO {
    ULONG   cbSize;
    DWORD   dwFlags;
    DWORD   dwAdState;
    LPWSTR  szTitle;
    LPWSTR  szAbstract;
    LPWSTR  szHREF;
    DWORD   dwInstalledVersionMS;
    DWORD   dwInstalledVersionLS;
    DWORD   dwUpdateVersionMS;
    DWORD   dwUpdateVersionLS;
    DWORD   dwAdvertisedVersionMS;
    DWORD   dwAdvertisedVersionLS;
    DWORD   dwReserved;
} SOFTDISTINFO;
typedef SOFTDISTINFO    *LPSOFTDISTINFO;

/* Protocol filter data */
typedef struct _tagPROTOCOLFILTERDATA {
    DWORD                   cbSize;
    IInternetProtocolSink   *pProtocolSink;
    IInternetProtocol       *pProtocol;
    IUnknown                *pUnk;
    DWORD                   dwFilterFlags;
} PROTOCOLFILTERDATA;

/* Data information */
typedef struct _tagDATAINFO {
    ULONG   ulTotalSize;
    ULONG   ulavrPacketSize;
    ULONG   ulConnectSpeed;
    ULONG   ulProcessorSpeed;
} DATAINFO;

/* Hit logging information */
typedef struct _tagHIT_LOGGING_INFO {
    DWORD       dwStructSize;
    LPSTR       lpszLoggedUrlName;
    SYSTEMTIME  StartTime;
    SYSTEMTIME  EndTime;
    LPSTR       lpszExtendedInfo;
} HIT_LOGGING_INFO;
typedef HIT_LOGGING_INFO    *LPHIT_LOGGING_INFO;

/* Confirm safety information */
struct CONFIRMSAFETY {
    CLSID       clsid;
    IUnknown    *pUnk;
    DWORD       dwFlags;
};

/* GUIDs */
EXTERN_C const IID  IID_IPersistMoniker;
EXTERN_C const IID  IID_IMonikerProp;
EXTERN_C const IID  IID_IBindProtocol;
EXTERN_C const IID  IID_IBinding;
EXTERN_C const IID  IID_IBindStatusCallback;
EXTERN_C const IID  IID_IBindStatusCallbackEx;
EXTERN_C const IID  IID_IAuthenticate;
EXTERN_C const IID  IID_IAuthenticateEx;
EXTERN_C const IID  IID_IHttpNegotiate;
EXTERN_C const IID  IID_IHttpNegotiate2;
EXTERN_C const IID  IID_IHttpNegotiate3;
EXTERN_C const IID  IID_IWinInetFileStream;
EXTERN_C const IID  IID_IWindowForBindingUI;
EXTERN_C const IID  IID_ICodeInstall;
#if (_WIN32_IE >= 0x0700)
EXTERN_C const IID  IID_IUri;
EXTERN_C const IID  IID_IUriContainer;
EXTERN_C const IID  IID_IUriBuilder;
EXTERN_C const IID  IID_IUriBuilderFactory;
#endif
EXTERN_C const IID  IID_IWinInetInfo;
EXTERN_C const IID  IID_IHttpSecurity;
EXTERN_C const IID  IID_IWinInetHttpInfo;
#if (_WIN32_IE >= 0x0602)
EXTERN_C const IID  IID_IWinInetCacheHints;
#endif
#if (_WIN32_IE >= 0x0700)
EXTERN_C const IID  IID_IWinInetCacheHints2;
#endif
EXTERN_C const IID  IID_IBindHost;
EXTERN_C const IID  IID_IInternet;
EXTERN_C const IID  IID_IInternetBindInfo;
EXTERN_C const IID  IID_IInternetBindInfoEx;
EXTERN_C const IID  IID_IInternetProtocolRoot;
EXTERN_C const IID  IID_IInternetProtocol;
#if (_WIN32_IE >= 0x0700)
EXTERN_C const IID  IID_IInternetProtocolEx;
#endif
EXTERN_C const IID  IID_IInternetProtocolSink;
EXTERN_C const IID  IID_IInternetProtocolSinkStackable;
EXTERN_C const IID  IID_IInternetSession;
EXTERN_C const IID  IID_IInternetThreadSwitch;
EXTERN_C const IID  IID_IInternetPriority;
EXTERN_C const IID  IID_IInternetProtocolInfo;
EXTERN_C const IID  IID_IInternetSecurityMgrSite;
EXTERN_C const IID  IID_IInternetSecurityManager;
#if (_WIN32_IE >= 0x0602)
EXTERN_C const IID  IID_IInternetSecurityManagerEx;
#endif
#if (_WIN32_IE >= 0x0700)
EXTERN_C const IID  IID_IInternetSecurityManagerEx2;
#endif
#if (_WIN32_IE >= 0x0602)
EXTERN_C const IID  IID_IZoneIdentifier;
#endif
EXTERN_C const IID  IID_IInternetHostSecurityManager;
EXTERN_C const IID  IID_IInternetZoneManager;
#if (_WIN32_IE >= 0x0602)
EXTERN_C const IID  IID_IInternetZoneManagerEx;
#endif
#if (_WIN32_IE >= 0x0700)
EXTERN_C const IID  IID_IInternetZoneManagerEx2;
#endif
EXTERN_C const IID  IID_ISoftDistExt;
EXTERN_C const IID  IID_ICatalogFileInfo;
EXTERN_C const IID  IID_IDataFilter;
EXTERN_C const IID  IID_IEncodingFilterFactory;
EXTERN_C const IID  IID_IWrappedProtocol;

/* Service identifiers */
#define SID_IBindHost                       IID_IBindHost
#define SID_SBindHost                       IID_IBindHost
#define SID_SInternetSecurityManager        IID_IInternetSecurityManager
#if (_WIN32_IE >= 0x0602)
    #define SID_SInternetSecurityManagerEx  IID_IInternetSecurityManagerEx
#endif
#if (_WIN32_IE >= 0x0700)
    #define SID_SInternetSecurityManagerEx2 IID_IInternetSecurityManagerEx2
#endif
#define SID_SInternetHostSecurityManager    IID_IInternetHostSecurityManager

/* IPersistMoniker interface */
#undef INTERFACE
#define INTERFACE   IPersistMoniker
DECLARE_INTERFACE_( IPersistMoniker, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersistMoniker interface */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;
    STDMETHOD( IsDirty )( THIS ) PURE;
    STDMETHOD( Load )( THIS_ BOOL, IMoniker *, LPBC, DWORD ) PURE;
    STDMETHOD( Save )( THIS_ IMoniker *, LPBC, BOOL ) PURE;
    STDMETHOD( SaveCompleted )( THIS_ IMoniker *, LPBC ) PURE;
    STDMETHOD( GetCurMoniker )( THIS_ IMoniker ** ) PURE;
};
typedef IPersistMoniker *LPPERSISTMONIKER;

/* IMonikerProp interface */
#undef INTERFACE
#define INTERFACE   IMonikerProp
DECLARE_INTERFACE_( IMonikerProp, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMonikerProp methods */
    STDMETHOD( PutProperty )( THIS_ MONIKERPROPERTY, LPCWSTR ) PURE;
};
typedef IMonikerProp    *LPMONIKERPROP;

/* IBindProtocol interface */
#undef INTERFACE
#define INTERFACE   IBindProtocol
DECLARE_INTERFACE_( IBindProtocol, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IBindProtocol methods */
    STDMETHOD( CreateBinding )( THIS_ LPCWSTR, IBindCtx *, IBinding ** ) PURE;
};
typedef IBindProtocol   *LPBINDPROTOCOL;

/* IBinding interface */
#undef INTERFACE
#define INTERFACE   IBinding
DECLARE_INTERFACE_( IBinding, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IBinding methods */
    STDMETHOD( Abort )( THIS ) PURE;
    STDMETHOD( Suspend )( THIS ) PURE;
    STDMETHOD( Resume )( THIS ) PURE;
    STDMETHOD( SetPriority )( THIS_ LONG ) PURE;
    STDMETHOD( GetPriority )( THIS_ LONG * ) PURE;
    STDMETHOD( GetBindResult )( THIS_ CLSID *, DWORD *, LPOLESTR *, DWORD * ) PURE;
};
typedef IBinding    *LPBINDING;

/* IBindStatusCallback interface */
#undef INTERFACE
#define INTERFACE   IBindStatusCallback
DECLARE_INTERFACE_( IBindStatusCallback, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IBindStatusCallback methods */
    STDMETHOD( OnStartBinding )( THIS_ DWORD, IBinding * ) PURE;
    STDMETHOD( GetPriority )( THIS_ LONG * ) PURE;
    STDMETHOD( OnLowResource )( THIS_ DWORD ) PURE;
    STDMETHOD( OnProgress )( THIS_ ULONG, ULONG, ULONG, LPCWSTR ) PURE;
    STDMETHOD( OnStopBinding )( THIS_ HRESULT, LPCWSTR ) PURE;
    STDMETHOD( GetBindInfo )( THIS_ DWORD *, BINDINFO * ) PURE;
    STDMETHOD( OnDataAvailable )( THIS_ DWORD, DWORD, FORMATETC *, STGMEDIUM * ) PURE;
    STDMETHOD( OnObjectAvailable )( THIS_ REFIID, IUnknown * ) PURE;
};
typedef IBindStatusCallback *LPBINDSTATUSCALLBACK;

/* IBindStatusCallbackEx interface */
#undef INTERFACE
#define INTERFACE   IBindStatusCallbackEx
DECLARE_INTERFACE_( IBindStatusCallbackEx, IBindStatusCallback ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IBindStatusCallback methods */
    STDMETHOD( OnStartBinding )( THIS_ DWORD, IBinding * ) PURE;
    STDMETHOD( GetPriority )( THIS_ LONG * ) PURE;
    STDMETHOD( OnLowResource )( THIS_ DWORD ) PURE;
    STDMETHOD( OnProgress )( THIS_ ULONG, ULONG, ULONG, LPCWSTR ) PURE;
    STDMETHOD( OnStopBinding )( THIS_ HRESULT, LPCWSTR ) PURE;
    STDMETHOD( GetBindInfo )( THIS_ DWORD *, BINDINFO * ) PURE;
    STDMETHOD( OnDataAvailable )( THIS_ DWORD, DWORD, FORMATETC *, STGMEDIUM * ) PURE;
    STDMETHOD( OnObjectAvailable )( THIS_ REFIID, IUnknown * ) PURE;

    /* IBindStatusCallbackEx methods */
    STDMETHOD( GetBindInfoEx )( THIS_ DWORD *, BINDINFO *, DWORD *, DWORD * ) PURE;
};
typedef IBindStatusCallbackEx   *LPBINDSTATUSCALLBACKEX;

/* IAuthenticate interface */
#undef INTERFACE
#define INTERFACE   IAuthenticate
DECLARE_INTERFACE_( IAuthenticate, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAuthenticate methods */
    STDMETHOD( Authenticate )( THIS_ HWND *, LPWSTR *, LPWSTR * ) PURE;
};
typedef IAuthenticate   *LPAUTHENTICATION;

/* IAuthenticateEx interface */
#undef INTERFACE
#define INTERFACE   IAuthenticateEx
DECLARE_INTERFACE_( IAuthenticateEx, IAuthenticate ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAuthenticate methods */
    STDMETHOD( Authenticate )( THIS_ HWND *, LPWSTR *, LPWSTR * ) PURE;

    /* IAuthenticateEx methods */
    STDMETHOD( AuthenticateEx )( THIS_ HWND *, LPWSTR *, LPWSTR *, AUTHENTICATEINFO * ) PURE;
};
typedef IAuthenticateEx *LPAUTHENTICATIONEX;

/* IHttpNegotiate interface */
#undef INTERFACE
#define INTERFACE   IHttpNegotiate
DECLARE_INTERFACE_( IHttpNegotiate, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHttpNegotiate methods */
    STDMETHOD( BeginningTransaction )( THIS_ LPCWSTR, LPCWSTR, DWORD, LPWSTR * ) PURE;
    STDMETHOD( OnResponse )( THIS_ DWORD, LPCWSTR, LPCWSTR, LPWSTR * ) PURE;
};
typedef IHttpNegotiate  *LPHTTPNEGOTIATE;

/* IHttpNegotiate2 interface */
#undef INTERFACE
#define INTERFACE   IHttpNegotiate2
DECLARE_INTERFACE_( IHttpNegotiate2, IHttpNegotiate ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHttpNegotiate methods */
    STDMETHOD( BeginningTransaction )( THIS_ LPCWSTR, LPCWSTR, DWORD, LPWSTR * ) PURE;
    STDMETHOD( OnResponse )( THIS_ DWORD, LPCWSTR, LPCWSTR, LPWSTR * ) PURE;

    /* IHttpNegotiate2 methods */
    STDMETHOD( GetRootSecurityId )( THIS_ BYTE *, DWORD *, DWORD_PTR ) PURE;
};
typedef IHttpNegotiate2 *LPHTTPNEGOTIATE2;

/* IHttpNegotiate3 interface */
#undef INTERFACE
#define INTERFACE   IHttpNegotiate3
DECLARE_INTERFACE_( IHttpNegotiate3, IHttpNegotiate2 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHttpNegotiate methods */
    STDMETHOD( BeginningTransaction )( THIS_ LPCWSTR, LPCWSTR, DWORD, LPWSTR * ) PURE;
    STDMETHOD( OnResponse )( THIS_ DWORD, LPCWSTR, LPCWSTR, LPWSTR * ) PURE;

    /* IHttpNegotiate2 methods */
    STDMETHOD( GetRootSecurityId )( THIS_ BYTE *, DWORD *, DWORD_PTR ) PURE;

    /* IHttpNegotiate3 methods */
    STDMETHOD( GetSerializedClientCertContext )( THIS_ BYTE **, DWORD * ) PURE;
};
typedef IHttpNegotiate3 *LPHTTPNEGOTIATE3;

/* IWinInetFileStream interface */
#undef INTERFACE
#define INTERFACE   IWinInetFileStream
DECLARE_INTERFACE_( IWinInetFileStream, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IWinInetFileStream methods */
    STDMETHOD( SetHandleForUnlock )( THIS_ DWORD_PTR, DWORD_PTR ) PURE;
    STDMETHOD( SetDeleteFile )( THIS_ DWORD_PTR ) PURE;
};
typedef IWinInetFileStream  *LPWININETFILESTREAM;

/* IWindowForBindingUI interface */
#undef INTERFACE
#define INTERFACE   IWindowForBindingUI
DECLARE_INTERFACE_( IWindowForBindingUI, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IWindowForBindingUI methods */
    STDMETHOD( GetWindow )( THIS_ REFGUID, HWND * ) PURE;
};
typedef IWindowForBindingUI *LPWINDOWFORBINDINGUI;

/* ICodeInstall interface */
#undef INTERFACE
#define INTERFACE   ICodeInstall
DECLARE_INTERFACE_( ICodeInstall, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IWindowForBindingUI methods */
    STDMETHOD( GetWindow )( THIS_ REFGUID, HWND * ) PURE;

    /* ICodeInstall methods */
    STDMETHOD( OnCodeInstallProblem )( THIS_ ULONG, LPCWSTR, LPCWSTR, DWORD ) PURE;
};
typedef ICodeInstall    *LPCODEINSTALL;

/* IUri interface */
#if (_WIN32_IE >= 0x0700)
#undef INTERFACE
#define INTERFACE   IUri
DECLARE_INTERFACE_( IUri, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IUri methods */
    STDMETHOD( GetPropertyBSTR )( THIS_ Uri_PROPERTY, BSTR *, DWORD ) PURE;
    STDMETHOD( GetPropertyLength )( THIS_ Uri_PROPERTY, DWORD *, DWORD ) PURE;
    STDMETHOD( GetPropertyDWORD )( THIS_ Uri_PROPERTY, DWORD *, DWORD ) PURE;
    STDMETHOD( HasProperty )( THIS_ Uri_PROPERTY, BOOL * ) PURE;
    STDMETHOD( GetAbsoluteUri )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetAuthority )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetDisplayUri )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetDomain )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetExtension )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetFragment )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetHost )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetPassword )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetPath )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetPathAndQuery )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetQuery )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetRawUri )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetSchemeName )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetUserInfo )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetUserName )( THIS_ BSTR * ) PURE;
    STDMETHOD( GetHostType )( THIS_ DWORD * ) PURE;
    STDMETHOD( GetPort )( THIS_ DWORD * ) PURE;
    STDMETHOD( GetScheme )( THIS_ DWORD * ) PURE;
    STDMETHOD( GetZone )( THIS_ DWORD * ) PURE;
    STDMETHOD( GetProperties )( THIS_ LPDWORD ) PURE;
    STDMETHOD( IsEqual )( THIS_ IUri *, BOOL * ) PURE;
};
#endif

/* IUriContainer interface */
#if (_WIN32_IE >= 0x0700)
#undef INTERFACE
#define INTERFACE   IUriContainer
DECLARE_INTERFACE_( IUriContainer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IUriContainer methods */
    STDMETHOD( GetIUri )( THIS_ IUri ** ) PURE;
};
#endif

/* IUriBuilder interface */
#if (_WIN32_IE >= 0x0700)
#undef INTERFACE
#define INTERFACE   IUriBuilder
DECLARE_INTERFACE_( IUriBuilder, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IUriBuilder methods */
    STDMETHOD( CreateUriSimple )( THIS_ DWORD, DWORD_PTR, IUri ** ) PURE;
    STDMETHOD( CreateUri )( THIS_ DWORD, DWORD, DWORD_PTR, IUri ** ) PURE;
    STDMETHOD( CreateUriWithFlags )( THIS_ DWORD, DWORD, DWORD, DWORD_PTR, IUri ** ) PURE;
    STDMETHOD( GetIUri )( THIS_ IUri ** ) PURE;
    STDMETHOD( SetIUri )( THIS_ IUri * ) PURE;
    STDMETHOD( GetFragment )( THIS_ DWORD *, LPCWSTR * ) PURE;
    STDMETHOD( GetHost )( THIS_ DWORD *, LPCWSTR * ) PURE;
    STDMETHOD( GetPassword )( THIS_ DWORD *, LPCWSTR * ) PURE;
    STDMETHOD( GetPath )( THIS_ DWORD *, LPCWSTR * ) PURE;
    STDMETHOD( GetPort )( THIS_ BOOL *, DWORD * ) PURE;
    STDMETHOD( GetQuery )( THIS_ DWORD *, LPCWSTR * ) PURE;
    STDMETHOD( GetSchemeName )( THIS_ DWORD *, LPCWSTR * ) PURE;
    STDMETHOD( GetUserName )( THIS_ DWORD *, LPCWSTR * ) PURE;
    STDMETHOD( SetFragment )( THIS_ LPCWSTR ) PURE;
    STDMETHOD( SetHost )( THIS_ LPCWSTR ) PURE;
    STDMETHOD( SetPassword )( THIS_ LPCWSTR ) PURE;
    STDMETHOD( SetPath )( THIS_ LPCWSTR ) PURE;
    STDMETHOD( SetPort )( THIS_ BOOL, DWORD ) PURE;
    STDMETHOD( SetQuery )( THIS_ LPCWSTR ) PURE;
    STDMETHOD( SetSchemeName )( THIS_ LPCWSTR ) PURE;
    STDMETHOD( SetUserName )( THIS_ LPCWSTR ) PURE;
    STDMETHOD( RemoveProperties )( THIS_ DWORD ) PURE;
    STDMETHOD( HasBeenModified )( THIS_ BOOL * ) PURE;
};
#endif

/* IUriBuilderFactory interface */
#if (_WIN32_IE >= 0x0700)
#undef INTERFACE
#define INTERFACE   IUriBuilderFactory
DECLARE_INTERFACE_( IUriBuilderFactory, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IUriBuilderFactory methods */
    STDMETHOD( CreateIUriBuilder )( THIS_ DWORD, DWORD_PTR, IUriBuilder ** ) PURE;
    STDMETHOD( CreateInitializedIUriBuilder )( THIS_ DWORD, DWORD_PTR, IUriBuilder ** ) PURE;
};
#endif

/* IWinInetInfo interface */
#undef INTERFACE
#define INTERFACE   IWinInetInfo
DECLARE_INTERFACE_( IWinInetInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IWinInetInfo methods */
    STDMETHOD( QueryOption )( THIS_ DWORD, LPVOID, DWORD * ) PURE;
};
typedef IWinInetInfo    *LPWININETINFO;

/* IHttpSecurity interface */
#undef INTERFACE
#define INTERFACE   IHttpSecurity
DECLARE_INTERFACE_( IHttpSecurity, IWindowForBindingUI ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IWindowForBindingUI methods */
    STDMETHOD( GetWindow )( THIS_ REFGUID, HWND * ) PURE;

    /* IHttpSecurity methods */
    STDMETHOD( OnSecurityProblem )( THIS_ DWORD ) PURE;
};
typedef IHttpSecurity   *LPHTTPSECURITY;

/* IWinInetHttpInfo interface */
#undef INTERFACE
#define INTERFACE   IWinInetHttpInfo
DECLARE_INTERFACE_( IWinInetHttpInfo, IWinInetInfo ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IWinInetInfo methods */
    STDMETHOD( QueryOption )( THIS_ DWORD, LPVOID, DWORD * ) PURE;

    /* IWinInetHttpInfo methods */
    STDMETHOD( QueryInfo )( THIS_ DWORD, LPVOID, DWORD *, DWORD *, DWORD * ) PURE;
};
typedef IWinInetHttpInfo    *LPWININETHTTPINFO;

/* IWinInetCacheHints interface */
#if (_WIN32_IE >= 0x0602)
#undef INTERFACE
#define INTERFACE   IWinInetCacheHints
DECLARE_INTERFACE_( IWinInetCacheHints, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IWinInetCacheHints methods */
    STDMETHOD( SetCacheExtension )( THIS_ LPCWSTR, LPVOID, DWORD *, DWORD *, DWORD * ) PURE;
};
typedef IWinInetCacheHints  *LPWININETCACHEHINTS;
#endif

/* IWinInetCacheHints2 interface */
#if (_WIN32_IE >= 0x0700)
#undef INTERFACE
#define INTERFACE   IWinInetCacheHints2
DECLARE_INTERFACE_( IWinInetCacheHints2, IWinInetCacheHints ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IWinInetCacheHints methods */
    STDMETHOD( SetCacheExtension )( THIS_ LPCWSTR, LPVOID, DWORD *, DWORD *, DWORD * ) PURE;
    
    /* IWinInetCacheHints2 methods */
    STDMETHOD( SetCacheExtension2 )( THIS_ LPCWSTR, WCHAR *, DWORD *, DWORD *, DWORD * ) PURE;
};
typedef IWinInetCacheHints2 *LPWININETCACHEHINTS2;
#endif

/* IBindHost interface */
#undef INTERFACE
#define INTERFACE   IBindHost
DECLARE_INTERFACE_( IBindHost, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IBindHost methods */
    STDMETHOD( CreateMoniker )( THIS_ LPOLESTR, IBindCtx *, IMoniker **, DWORD ) PURE;
    STDMETHOD( MonikerBindToStorage )( THIS_ IMoniker *, IBindCtx *, IBindStatusCallback *, REFIID, void ** ) PURE;
    STDMETHOD( MonikerBindToObject )( THIS_ IMoniker *, IBindCtx *, IBindStatusCallback *, REFIID, void ** ) PURE;
};
typedef IBindHost   *LPBINDHOST;

/* IInternet interface */
#undef INTERFACE
#define INTERFACE   IInternet
DECLARE_INTERFACE_( IInternet, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
};
typedef IInternet   *LPIINTERNET;

/* IInternetBindInfo interface */
#undef INTERFACE
#define INTERFACE   IInternetBindInfo
DECLARE_INTERFACE_( IInternetBindInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetBindInfo methods */
    STDMETHOD( GetBindInfo )( THIS_ DWORD *, BINDINFO * ) PURE;
    STDMETHOD( GetBindString )( THIS_ ULONG, LPOLESTR *, ULONG, ULONG * ) PURE;
};
typedef IInternetBindInfo   *LPIINTERNETBINDINFO;

/* IInternetBindInfoEx interface */
#undef INTERFACE
#define INTERFACE   IInternetBindInfoEx
DECLARE_INTERFACE_( IInternetBindInfoEx, IInternetBindInfo ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetBindInfo methods */
    STDMETHOD( GetBindInfo )( THIS_ DWORD *, BINDINFO * ) PURE;
    STDMETHOD( GetBindString )( THIS_ ULONG, LPOLESTR *, ULONG, ULONG * ) PURE;

    /* IInternetBindInfoEx methods */
    STDMETHOD( GetBindInfoEx )( THIS_ DWORD *, BINDINFO *, DWORD *, DWORD * ) PURE;
};

/* IInternetProtocolRoot interface */
#undef INTERFACE
#define INTERFACE   IInternetProtocolRoot
DECLARE_INTERFACE_( IInternetProtocolRoot, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetProtocolRoot methods */
    STDMETHOD( Start )( THIS_ LPCWSTR, IInternetProtocolSink *, IInternetBindInfo *, DWORD, HANDLE_PTR ) PURE;
    STDMETHOD( Continue )( THIS_ PROTOCOLDATA * ) PURE;
    STDMETHOD( Abort )( THIS_ HRESULT, DWORD ) PURE;
    STDMETHOD( Terminate )( THIS_ DWORD ) PURE;
    STDMETHOD( Suspend )( THIS ) PURE;
    STDMETHOD( Resume )( THIS ) PURE;
};
typedef IInternetProtocolRoot   *LPIINTERNETPROTOCOLROOT;

/* IInternetProtocol interface */
#undef INTERFACE
#define INTERFACE   IInternetProtocol
DECLARE_INTERFACE_( IInternetProtocol, IInternetProtocolRoot ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetProtocolRoot methods */
    STDMETHOD( Start )( THIS_ LPCWSTR, IInternetProtocolSink *, IInternetBindInfo *, DWORD, HANDLE_PTR ) PURE;
    STDMETHOD( Continue )( THIS_ PROTOCOLDATA * ) PURE;
    STDMETHOD( Abort )( THIS_ HRESULT, DWORD ) PURE;
    STDMETHOD( Terminate )( THIS_ DWORD ) PURE;
    STDMETHOD( Suspend )( THIS ) PURE;
    STDMETHOD( Resume )( THIS ) PURE;

    /* IInternetProtocol methods */
    STDMETHOD( Read )( THIS_ void *, ULONG, ULONG * ) PURE;
    STDMETHOD( Seek )( THIS_ LARGE_INTEGER, DWORD, ULARGE_INTEGER * ) PURE;
    STDMETHOD( LockRequest )( THIS_ DWORD ) PURE;
    STDMETHOD( UnlockRequest )( THIS ) PURE;
};
typedef IInternetProtocol   *LPIINTERNETPROTOCOL;

/* IInternetProtocolEx interface */
#if (_WIN32_IE >= 0x0700)
#undef INTERFACE
#define INTERFACE   IInternetProtocolEx
DECLARE_INTERFACE_( IInternetProtocolEx, IInternetProtocol ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetProtocolRoot methods */
    STDMETHOD( Start )( THIS_ LPCWSTR, IInternetProtocolSink *, IInternetBindInfo *, DWORD, HANDLE_PTR ) PURE;
    STDMETHOD( Continue )( THIS_ PROTOCOLDATA * ) PURE;
    STDMETHOD( Abort )( THIS_ HRESULT, DWORD ) PURE;
    STDMETHOD( Terminate )( THIS_ DWORD ) PURE;
    STDMETHOD( Suspend )( THIS ) PURE;
    STDMETHOD( Resume )( THIS ) PURE;

    /* IInternetProtocol methods */
    STDMETHOD( Read )( THIS_ void *, ULONG, ULONG * ) PURE;
    STDMETHOD( Seek )( THIS_ LARGE_INTEGER, DWORD, ULARGE_INTEGER * ) PURE;
    STDMETHOD( LockRequest )( THIS_ DWORD ) PURE;
    STDMETHOD( UnlockRequest )( THIS ) PURE;

    /* IInternetProtocolEx methods */
    STDMETHOD( StartEx )( THIS_ IUri *, IInternetProtocolSink *, IInternetBindInfo *, DWORD, HANDLE_PTR ) PURE;
};
#endif

/* IInternetProtocolSink interface */
#undef INTERFACE
#define INTERFACE   IInternetProtocolSink
DECLARE_INTERFACE_( IInternetProtocolSink, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetProtocolSink methods */
    STDMETHOD( Switch )( THIS_ PROTOCOLDATA * ) PURE;
    STDMETHOD( ReportProgress )( THIS_ ULONG, LPCWSTR ) PURE;
    STDMETHOD( ReportData )( THIS_ DWORD, ULONG, ULONG ) PURE;
    STDMETHOD( ReportResult )( THIS_ HRESULT, DWORD, LPCWSTR ) PURE;
};
typedef IInternetProtocolSink   *LPIINTERNETPROTOCOLSINK;

/* IInternetProtocolSinkStackable interface */
#undef INTERFACE
#define INTERFACE   IInternetProtocolSinkStackable
DECLARE_INTERFACE_( IInternetProtocolSinkStackable, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetProtocolSinkStackable methods */
    STDMETHOD( SwitchSink )( THIS_ IInternetProtocolSink * ) PURE;
    STDMETHOD( CommitSwitch )( THIS ) PURE;
    STDMETHOD( RollbackSwitch )( THIS ) PURE;
};
typedef IInternetProtocolSinkStackable  *LPIINTERNETPROTOCOLSINKSTACKABLE;

/* IInternetSession interface */
#undef INTERFACE
#define INTERFACE   IInternetSession
DECLARE_INTERFACE_( IInternetSession, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IInternetSession methods */
    STDMETHOD( RegisterNameSpace )( THIS_ IClassFactory *, REFCLSID, LPCWSTR, ULONG, const LPCWSTR *, DWORD ) PURE;
    STDMETHOD( UnregisterNameSpace )( THIS_ IClassFactory *, LPCWSTR ) PURE;
    STDMETHOD( RegisterMimeFilter )( THIS_ IClassFactory *, REFCLSID, LPCWSTR ) PURE;
    STDMETHOD( UnregisterMimeFilter )( THIS_ IClassFactory *, LPCWSTR ) PURE;
    STDMETHOD( CreateBinding )( THIS_ LPBC, LPCWSTR, IUnknown *, IUnknown **, IInternetProtocol **, DWORD ) PURE;
    STDMETHOD( SetSessionOption )( THIS_ DWORD, LPVOID, DWORD, DWORD ) PURE;
    STDMETHOD( GetSessionOption )( THIS_ DWORD, LPVOID, DWORD *, DWORD ) PURE;
};
typedef IInternetSession    *LPIINTERNETSESSION;

/* IInternetThreadSwitch interface */
#undef INTERFACE
#define INTERFACE   IInternetThreadSwitch
DECLARE_INTERFACE_( IInternetThreadSwitch, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetThreadSwitch methods */
    STDMETHOD( Prepare )( THIS ) PURE;
    STDMETHOD( Continue )( THIS ) PURE;
};
typedef IInternetThreadSwitch   *LPIINTERNETTHREADSWITCH;

/* IInternetPriority interface */
#undef INTERFACE
#define INTERFACE   IInternetPriority
DECLARE_INTERFACE_( IInternetPriority, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetPriority methods */
    STDMETHOD( SetPriority )( THIS_ LONG ) PURE;
    STDMETHOD( GetPriority )( THIS_ LONG * ) PURE;
};

/* IInternetProtocolInfo interface */
#undef INTERFACE
#define INTERFACE   IInternetProtocolInfo
DECLARE_INTERFACE_( IInternetProtocolInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetProtocolInfo methods */
    STDMETHOD( ParseUrl )( THIS_ LPCWSTR, PARSEACTION, DWORD, LPWSTR, DWORD, DWORD *, DWORD ) PURE;
    STDMETHOD( CombineUrl )( THIS_ LPCWSTR, LPCWSTR, DWORD, LPWSTR, DWORD, DWORD *, DWORD ) PURE;
    STDMETHOD( CompareUrl )( THIS_ LPCWSTR, LPCWSTR, DWORD ) PURE;
    STDMETHOD( QueryInfo )( THIS_ LPCWSTR, QUERYOPTION, DWORD, LPVOID, DWORD, DWORD *, DWORD ) PURE;
};
typedef IInternetProtocolInfo   *LPIINTERNETPROTOCOLINFO;

/* IInternetSecurityMgrSite interface */
#undef INTERFACE
#define INTERFACE   IInternetSecurityMgrSite
DECLARE_INTERFACE_( IInternetSecurityMgrSite, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetSecurityMgrSite methods */
    STDMETHOD( GetWindow )( THIS_ HWND * ) PURE;
    STDMETHOD( EnableModeless )( THIS_ BOOL ) PURE;
};

/* IInternetSecurityManager interface */
#undef INTERFACE
#define INTERFACE   IInternetSecurityManager
DECLARE_INTERFACE_( IInternetSecurityManager, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetSecurityManager methods */
    STDMETHOD( SetSecuritySite )( THIS_ IInternetSecurityMgrSite * ) PURE;
    STDMETHOD( GetSecuritySite )( THIS_ IInternetSecurityMgrSite ** ) PURE;
    STDMETHOD( MapUrlToZone )( THIS_ LPCWSTR, DWORD *, DWORD ) PURE;
    STDMETHOD( GetSecurityId )( THIS_ LPCWSTR, BYTE *, DWORD *, DWORD_PTR ) PURE;
    STDMETHOD( ProcessUrlAction )( THIS_ LPCWSTR, DWORD, BYTE *, DWORD, BYTE *, DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( QueryCustomPolicy )( THIS_ LPCWSTR, REFGUID, BYTE **, DWORD *, BYTE *, DWORD, DWORD ) PURE;
    STDMETHOD( SetZoneMapping )( THIS_ DWORD, LPCWSTR, DWORD ) PURE;
    STDMETHOD( GetZoneMappings )( THIS_ DWORD, IEnumString **, DWORD ) PURE;
};

/* IInternetSecurityManagerEx interface */
#if (_WIN32_IE >= 0x0602)
#undef INTERFACE
#define INTERFACE   IInternetSecurityManagerEx
DECLARE_INTERFACE_( IInternetSecurityManagerEx, IInternetSecurityManager ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetSecurityManager methods */
    STDMETHOD( SetSecuritySite )( THIS_ IInternetSecurityMgrSite * ) PURE;
    STDMETHOD( GetSecuritySite )( THIS_ IInternetSecurityMgrSite ** ) PURE;
    STDMETHOD( MapUrlToZone )( THIS_ LPCWSTR, DWORD *, DWORD ) PURE;
    STDMETHOD( GetSecurityId )( THIS_ LPCWSTR, BYTE *, DWORD *, DWORD_PTR ) PURE;
    STDMETHOD( ProcessUrlAction )( THIS_ LPCWSTR, DWORD, BYTE *, DWORD, BYTE *, DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( QueryCustomPolicy )( THIS_ LPCWSTR, REFGUID, BYTE **, DWORD *, BYTE *, DWORD, DWORD ) PURE;
    STDMETHOD( SetZoneMapping )( THIS_ DWORD, LPCWSTR, DWORD ) PURE;
    STDMETHOD( GetZoneMappings )( THIS_ DWORD, IEnumString **, DWORD ) PURE;

    /* IInternetSecurityManagerEx methods */
    STDMETHOD( ProcessUrlActionEx )( THIS_ LPCWSTR, DWORD, BYTE *, DWORD, BYTE *, DWORD, DWORD, DWORD, DWORD * ) PURE;
};
#endif

/* IInternetSecurityManagerEx2 interface */
#if (_WIN32_IE >= 0x0700)
#undef INTERFACE
#define INTERFACE   IInternetSecurityManagerEx2
DECLARE_INTERFACE_( IInternetSecurityManagerEx2, IInternetSecurityManager ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetSecurityManager methods */
    STDMETHOD( SetSecuritySite )( THIS_ IInternetSecurityMgrSite * ) PURE;
    STDMETHOD( GetSecuritySite )( THIS_ IInternetSecurityMgrSite ** ) PURE;
    STDMETHOD( MapUrlToZone )( THIS_ LPCWSTR, DWORD *, DWORD ) PURE;
    STDMETHOD( GetSecurityId )( THIS_ LPCWSTR, BYTE *, DWORD *, DWORD_PTR ) PURE;
    STDMETHOD( ProcessUrlAction )( THIS_ LPCWSTR, DWORD, BYTE *, DWORD, BYTE *, DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( QueryCustomPolicy )( THIS_ LPCWSTR, REFGUID, BYTE **, DWORD *, BYTE *, DWORD, DWORD ) PURE;
    STDMETHOD( SetZoneMapping )( THIS_ DWORD, LPCWSTR, DWORD ) PURE;
    STDMETHOD( GetZoneMappings )( THIS_ DWORD, IEnumString **, DWORD ) PURE;

    /* IInternetSecurityManagerEx methods */
    STDMETHOD( ProcessUrlActionEx )( THIS_ LPCWSTR, DWORD, BYTE *, DWORD, BYTE *, DWORD, DWORD, DWORD, DWORD * ) PURE;

    /* IInternetSecurityManagerEx2 methods */
    STDMETHOD( MapUrlToZoneEx2 )( THIS_ IUri *, DWORD *, DWORD, LPWSTR *, DWORD * ) PURE;
    STDMETHOD( ProcessUrlActionEx2 )( THIS_ IUri *, DWORD, BYTE *, DWORD, BYTE *, DWORD, DWORD, DWORD_PTR, DWORD * ) PURE;
    STDMETHOD( GetSecurityIdEx2 )( THIS_ IUri *, BYTE *, DWORD *, DWORD_PTR ) PURE;
    STDMETHOD( QueryCustomPolicyEx2 )( THIS_ IUri *, REFGUID, BYTE **, DWORD *, BYTE *, DWORD, DWORD_PTR ) PURE;
};
#endif

/* IZoneIdentifier interface */
#if (_WIN32_IE >= 0x0602)
#undef INTERFACE
#define INTERFACE   IZoneIdentifier
DECLARE_INTERFACE_( IZoneIdentifier, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IZoneIdentifier methods */
    STDMETHOD( GetId )( THIS_ DWORD * ) PURE;
    STDMETHOD( SetId )( THIS_ DWORD ) PURE;
    STDMETHOD( Remove )( THIS ) PURE;
};
#endif

/* IInternetHostSecurityManager interface */
#undef INTERFACE
#define INTERFACE   IInternetHostSecurityManager
DECLARE_INTERFACE_( IInternetHostSecurityManager, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IInternetHostSecurityManager methods */
    STDMETHOD( GetSecurityId )( THIS_ BYTE *, DWORD *, DWORD_PTR ) PURE;
    STDMETHOD( ProcessUrlAction )( THIS_ DWORD, BYTE *, DWORD, BYTE *, DWORD, DWORD, DWORD ) PURE;
    STDMETHOD( QueryCustomPolicy )( THIS_ REFGUID, BYTE **, DWORD *, BYTE *, DWORD, DWORD ) PURE;
};

/* IInternetZoneManager interface */
#undef INTERFACE
#define INTERFACE   IInternetZoneManager
DECLARE_INTERFACE_( IInternetZoneManager, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetZoneManager methods */
    STDMETHOD( GetZoneAttributes )( THIS_ DWORD, ZONEATTRIBUTES * ) PURE;
    STDMETHOD( SetZoneAttributes )( THIS_ DWORD, ZONEATTRIBUTES * ) PURE;
    STDMETHOD( GetZoneCustomPolicy )( THIS_ DWORD, REFGUID, BYTE **, DWORD *, URLZONEREG ) PURE;
    STDMETHOD( SetZoneCustomPolicy )( THIS_ DWORD, REFGUID, BYTE *, DWORD, URLZONEREG ) PURE;
    STDMETHOD( GetZoneActionPolicy )( THIS_ DWORD, DWORD, BYTE *, DWORD, URLZONEREG ) PURE;
    STDMETHOD( SetZoneActionPolicy )( THIS_ DWORD, DWORD, BYTE *, DWORD, URLZONEREG ) PURE;
    STDMETHOD( PromptAction )( THIS_ DWORD, HWND, LPCWSTR, LPCWSTR, DWORD ) PURE;
    STDMETHOD( LogAction )( THIS_ DWORD, LPCWSTR, LPCWSTR, DWORD ) PURE;
    STDMETHOD( CreateZoneEnumerator )( THIS_ DWORD *, DWORD *, DWORD ) PURE;
    STDMETHOD( GetZoneAt )( THIS_ DWORD, DWORD, DWORD * ) PURE;
    STDMETHOD( DestroyZoneEnumerator )( THIS_ DWORD ) PURE;
    STDMETHOD( CopyTemplatePoliciesToZone )( THIS_ DWORD, DWORD, DWORD ) PURE;
};
typedef IInternetZoneManager    *LPURLZONEMANAGER;

/* IInternetZoneManagerEx interface */
#if (_WIN32_IE >= 0x0602)
#undef INTERFACE
#define INTERFACE   IInternetZoneManagerEx
DECLARE_INTERFACE_( IInternetZoneManagerEx, IInternetZoneManager ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetZoneManager methods */
    STDMETHOD( GetZoneAttributes )( THIS_ DWORD, ZONEATTRIBUTES * ) PURE;
    STDMETHOD( SetZoneAttributes )( THIS_ DWORD, ZONEATTRIBUTES * ) PURE;
    STDMETHOD( GetZoneCustomPolicy )( THIS_ DWORD, REFGUID, BYTE **, DWORD *, URLZONEREG ) PURE;
    STDMETHOD( SetZoneCustomPolicy )( THIS_ DWORD, REFGUID, BYTE *, DWORD, URLZONEREG ) PURE;
    STDMETHOD( GetZoneActionPolicy )( THIS_ DWORD, DWORD, BYTE *, DWORD, URLZONEREG ) PURE;
    STDMETHOD( SetZoneActionPolicy )( THIS_ DWORD, DWORD, BYTE *, DWORD, URLZONEREG ) PURE;
    STDMETHOD( PromptAction )( THIS_ DWORD, HWND, LPCWSTR, LPCWSTR, DWORD ) PURE;
    STDMETHOD( LogAction )( THIS_ DWORD, LPCWSTR, LPCWSTR, DWORD ) PURE;
    STDMETHOD( CreateZoneEnumerator )( THIS_ DWORD *, DWORD *, DWORD ) PURE;
    STDMETHOD( GetZoneAt )( THIS_ DWORD, DWORD, DWORD * ) PURE;
    STDMETHOD( DestroyZoneEnumerator )( THIS_ DWORD ) PURE;
    STDMETHOD( CopyTemplatePoliciesToZone )( THIS_ DWORD, DWORD, DWORD ) PURE;

    /* IInternetZoneManagerEx methods */
    STDMETHOD( GetZoneActionPolicyEx )( THIS_ DWORD, DWORD, BYTE *, DWORD, URLZONEREG, DWORD ) PURE;
    STDMETHOD( SetZoneActionPolicyEx )( THIS_ DWORD, DWORD, BYTE *, DWORD, URLZONEREG, DWORD ) PURE;
};
#endif

/* IInternetZoneManagerEx2 interface */
#if (_WIN32_IE >= 0x0700)
#undef INTERFACE
#define INTERFACE   IInternetZoneManagerEx2
DECLARE_INTERFACE_( IInternetZoneManagerEx2, IInternetZoneManagerEx ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IInternetZoneManager methods */
    STDMETHOD( GetZoneAttributes )( THIS_ DWORD, ZONEATTRIBUTES * ) PURE;
    STDMETHOD( SetZoneAttributes )( THIS_ DWORD, ZONEATTRIBUTES * ) PURE;
    STDMETHOD( GetZoneCustomPolicy )( THIS_ DWORD, REFGUID, BYTE **, DWORD *, URLZONEREG ) PURE;
    STDMETHOD( SetZoneCustomPolicy )( THIS_ DWORD, REFGUID, BYTE *, DWORD, URLZONEREG ) PURE;
    STDMETHOD( GetZoneActionPolicy )( THIS_ DWORD, DWORD, BYTE *, DWORD, URLZONEREG ) PURE;
    STDMETHOD( SetZoneActionPolicy )( THIS_ DWORD, DWORD, BYTE *, DWORD, URLZONEREG ) PURE;
    STDMETHOD( PromptAction )( THIS_ DWORD, HWND, LPCWSTR, LPCWSTR, DWORD ) PURE;
    STDMETHOD( LogAction )( THIS_ DWORD, LPCWSTR, LPCWSTR, DWORD ) PURE;
    STDMETHOD( CreateZoneEnumerator )( THIS_ DWORD *, DWORD *, DWORD ) PURE;
    STDMETHOD( GetZoneAt )( THIS_ DWORD, DWORD, DWORD * ) PURE;
    STDMETHOD( DestroyZoneEnumerator )( THIS_ DWORD ) PURE;
    STDMETHOD( CopyTemplatePoliciesToZone )( THIS_ DWORD, DWORD, DWORD ) PURE;

    /* IInternetZoneManagerEx methods */
    STDMETHOD( GetZoneActionPolicyEx )( THIS_ DWORD, DWORD, BYTE *, DWORD, URLZONEREG, DWORD ) PURE;
    STDMETHOD( SetZoneActionPolicyEx )( THIS_ DWORD, DWORD, BYTE *, DWORD, URLZONEREG, DWORD ) PURE;

    /* IInternetZoneManagerEx2 methods */
    STDMETHOD( GetZoneAttributesEx )( THIS_ DWORD, ZONEATTRIBUTES *, DWORD ) PURE;
    STDMETHOD( GetZoneSecurityState )( THIS_ DWORD, BOOL, LPDWORD, BOOL * ) PURE;
    STDMETHOD( GetIESecurityState )( THIS_ BOOL, LPDWORD, BOOL *, BOOL ) PURE;
    STDMETHOD( FixUnsecureSettings )( THIS ) PURE;
};
#endif

/* ISoftDistExt interface */
#undef INTERFACE
#define INTERFACE   ISoftDistExt
DECLARE_INTERFACE_( ISoftDistExt, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISoftDistExt methods */
    STDMETHOD( ProcessSoftDist )( THIS_ LPCWSTR, IXMLElement *, LPSOFTDISTINFO ) PURE;
    STDMETHOD( GetFirstCodeBase )( THIS_ LPWSTR *, LPDWORD ) PURE;
    STDMETHOD( GetNextCodeBase )( THIS_ LPWSTR *, LPDWORD ) PURE;
    STDMETHOD( AsyncInstallDistributionUnit )( THIS_ IBindCtx *, LPVOID, DWORD, LPCODEBASEHOLD ) PURE;
};

/* ICatalogFileInfo interface */
#undef INTERFACE
#define INTERFACE   ICatalogFileInfo
DECLARE_INTERFACE_( ICatalogFileInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ICatalogFileInfo methods */
    STDMETHOD( GetCatalogFile )( THIS_ LPSTR * ) PURE;
    STDMETHOD( GetJavaTrust )( THIS_ void ** ) PURE;
};
typedef ICatalogFileInfo    *LPCATALOGFILEINFO;

/* IDataFilter interface */
#undef INTERFACE
#define INTERFACE   IDataFilter
DECLARE_INTERFACE_( IDataFilter, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDataFilter methods */
    STDMETHOD( DoEncode )( THIS_ DWORD, LONG, BYTE *, LONG, BYTE *, LONG, LONG *, LONG *, DWORD ) PURE;
    STDMETHOD( DoDecode )( THIS_ DWORD, LONG, BYTE *, LONG, BYTE *, LONG, LONG *, LONG *, DWORD ) PURE;
    STDMETHOD( SetEncodingLevel )( THIS_ DWORD ) PURE;
};
typedef IDataFilter *LPDATAFILTER;

/* IEncodingFilterFactory interface */
#undef INTERFACE
#define INTERFACE   IEncodingFilterFactory
DECLARE_INTERFACE_( IEncodingFilterFactory, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IEncodingFilterFactory methods */
    STDMETHOD( FindBestFilter )( THIS_ LPCWSTR, LPCWSTR, DATAINFO, IDataFilter ** ) PURE;
    STDMETHOD( GetDefaultFilter )( THIS_ LPCWSTR, LPCWSTR, IDataFilter ** ) PURE;
};
typedef IEncodingFilterFactory  *LPENCODINGFILTERFACTORY;

/* IWrappedProtocol interface */
#undef INTERFACE
#define INTERFACE   IWrappedProtocol
DECLARE_INTERFACE_( IWrappedProtocol, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IWrappedProtocol methods */
    STDMETHOD( GetWrappedCode )( THIS_ LONG *, DWORD_PTR ) PURE;
};
typedef IWrappedProtocol    *LPWRAPPEDPROTOCOL;

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IPersistMoniker_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPersistMoniker_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPersistMoniker_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPersistMoniker_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IPersistMoniker_IsDirty( x ) \
        (x)->lpVtbl->IsDirty( x )
    #define IPersistMoniker_Load( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Load( x, p1, p2, p3, p4 )
    #define IPersistMoniker_Save( x, p1, p2, p3 ) \
        (x)->lpVtbl->Save( x, p1, p2, p3 )
    #define IPersistMoniker_SaveCompleted( x, p1, p2 ) \
        (x)->lpVtbl->SaveCompleted( x, p1, p2 )
    #define IPersistMoniker_GetCurMoniker( x, p ) \
        (x)->lpVtbl->GetCurMoniker( x, p )
    #define IMonikerProp_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMonikerProp_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMonikerProp_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMonikerProp_PutProperty( x, p1, p2 ) \
        (x)->lpVtbl->PutProperty( x, p1, p2 )
    #define IBindProtocol_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IBindProtocol_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IBindProtocol_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IBindProtocol_CreateBinding( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateBinding( x, p1, p2, p3 )
    #define IBinding_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IBinding_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IBinding_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IBinding_Abort( x ) \
        (x)->lpVtbl->Abort( x )
    #define IBinding_Suspend( x ) \
        (x)->lpVtbl->Suspend( x )
    #define IBinding_Resume( x ) \
        (x)->lpVtbl->Resume( x )
    #define IBinding_SetPriority( x, p ) \
        (x)->lpVtbl->SetPriority( x, p )
    #define IBinding_GetPriority( x, p ) \
        (x)->lpVtbl->GetPriority( x, p )
    #define IBinding_GetBindResult( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetBindResult( x, p1, p2, p3, p4 )
    #define IBindStatusCallback_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IBindStatusCallback_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IBindStatusCallback_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IBindStatusCallback_OnStartBinding( x, p1, p2 ) \
        (x)->lpVtbl->OnStartBinding( x, p1, p2 )
    #define IBindStatusCallback_GetPriority( x, p ) \
        (x)->lpVtbl->GetPriority( x, p )
    #define IBindStatusCallback_OnLowResource( x, p ) \
        (x)->lpVtbl->OnLowResource( x, p )
    #define IBindStatusCallback_OnProgress( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->OnProgress( x, p1, p2, p3, p4 )
    #define IBindStatusCallback_OnStopBinding( x, p1, p2 ) \
        (x)->lpVtbl->OnStopBinding( x, p1, p2 )
    #define IBindStatusCallback_GetBindInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetBindInfo( x, p1, p2 )
    #define IBindStatusCallback_OnDataAvailable( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->OnDataAvailable( x, p1, p2, p3, p4 )
    #define IBindStatusCallback_OnObjectAvailable( x, p1, p2 ) \
        (x)->lpVtbl->OnObjectAvailable( x, p1, p2 )
    #define IBindStatusCallbackEx_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IBindStatusCallbackEx_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IBindStatusCallbackEx_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IBindStatusCallbackEx_OnStartBinding( x, p1, p2 ) \
        (x)->lpVtbl->OnStartBinding( x, p1, p2 )
    #define IBindStatusCallbackEx_GetPriority( x, p ) \
        (x)->lpVtbl->GetPriority( x, p )
    #define IBindStatusCallbackEx_OnLowResource( x, p ) \
        (x)->lpVtbl->OnLowResource( x, p )
    #define IBindStatusCallbackEx_OnProgress( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->OnProgress( x, p1, p2, p3, p4 )
    #define IBindStatusCallbackEx_OnStopBinding( x, p1, p2 ) \
        (x)->lpVtbl->OnStopBinding( x, p1, p2 )
    #define IBindStatusCallbackEx_GetBindInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetBindInfo( x, p1, p2 )
    #define IBindStatusCallbackEx_OnDataAvailable( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->OnDataAvailable( x, p1, p2, p3, p4 )
    #define IBindStatusCallbackEx_OnObjectAvailable( x, p1, p2 ) \
        (x)->lpVtbl->OnObjectAvailable( x, p1, p2 )
    #define IBindStatusCallbackEx_GetBindInfoEx( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetBindInfoEx( x, p1, p2, p3, p4 )
    #define IAuthenticate_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAuthenticate_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAuthenticate_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAuthenticate_Authenticate( x, p1, p2, p3 ) \
        (x)->lpVtbl->Authenticate( x, p1, p2, p3 )
    #define IAuthenticateEx_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAuthenticateEx_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAuthenticateEx_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAuthenticateEx_Authenticate( x, p1, p2, p3 ) \
        (x)->lpVtbl->Authenticate( x, p1, p2, p3 )
    #define IAuthenticateEx_AuthenticateEx( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->AuthenticateEx( x, p1, p2, p3, p4 )
    #define IHttpNegotiate_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHttpNegotiate_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHttpNegotiate_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHttpNegotiate_BeginningTransaction( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->BeginningTransaction( x, p1, p2, p3, p4 )
    #define IHttpNegotiate_OnResponse( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->OnResponse( x, p1, p2, p3, p4 )
    #define IHttpNegotiate2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHttpNegotiate2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHttpNegotiate2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHttpNegotiate2_BeginningTransaction( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->BeginningTransaction( x, p1, p2, p3, p4 )
    #define IHttpNegotiate2_OnResponse( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->OnResponse( x, p1, p2, p3, p4 )
    #define IHttpNegotiate2_GetRootSecurityId( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetRootSecurityId( x, p1, p2, p3 )
    #define IHttpNegotiate3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHttpNegotiate3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHttpNegotiate3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHttpNegotiate3_BeginningTransaction( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->BeginningTransaction( x, p1, p2, p3, p4 )
    #define IHttpNegotiate3_OnResponse( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->OnResponse( x, p1, p2, p3, p4 )
    #define IHttpNegotiate3_GetRootSecurityId( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetRootSecurityId( x, p1, p2, p3 )
    #define IHttpNegotiate3_GetSerializedClientCertContext( x, p1, p2 ) \
        (x)->lpVtbl->GetSerializedClientCertContext( x, p1, p2 )
    #define IWinInetFileStream_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IWinInetFileStream_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IWinInetFileStream_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IWinInetFileStream_SetHandleForUnlock( x, p1, p2 ) \
        (x)->lpVtbl->SetHandleForUnlock( x, p1, p2 )
    #define IWinInetFileStream_SetDeleteFile( x, p ) \
        (x)->lpVtbl->SetDeleteFile( x, p )
    #define IWindowForBindingUI_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IWindowForBindingUI_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IWindowForBindingUI_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IWindowForBindingUI_GetWindow( x, p1, p2 ) \
        (x)->lpVtbl->GetWindow( x, p1, p2 )
    #if (_WIN32_IE >= 0x0700)
        #define IUri_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IUri_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IUri_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IUri_GetPropertyBSTR( x, p1, p2, p3 ) \
            (x)->lpVtbl->GetPropertyBSTR( x, p1, p2, p3 )
        #define IUri_GetPropertyLength( x, p1, p2, p3 ) \
            (x)->lpVtbl->GetPropertyLength( x, p1, p2, p3 )
        #define IUri_GetPropertyDWORD( x, p1, p2, p3 ) \
            (x)->lpVtbl->GetPropertyDWORD( x, p1, p2, p3 )
        #define IUri_HasProperty( x, p1, p2 ) \
            (x)->lpVtbl->HasProperty( x, p1, p2 )
        #define IUri_GetAbsoluteUri( x, p ) \
            (x)->lpVtbl->GetAbsoluteUri( x, p )
        #define IUri_GetAuthority( x, p ) \
            (x)->lpVtbl->GetAuthority( x, p )
        #define IUri_GetDisplayUri( x, p ) \
            (x)->lpVtbl->GetDisplayUri( x, p )
        #define IUri_GetDomain( x, p ) \
            (x)->lpVtbl->GetDomain( x, p )
        #define IUri_GetExtension( x, p ) \
            (x)->lpVtbl->GetExtension( x, p )
        #define IUri_GetFragment( x, p ) \
            (x)->lpVtbl->GetFragment( x, p )
        #define IUri_GetHost( x, p ) \
            (x)->lpVtbl->GetHost( x, p )
        #define IUri_GetPassword( x, p ) \
            (x)->lpVtbl->GetPassword( x, p )
        #define IUri_GetPath( x, p ) \
            (x)->lpVtbl->GetPath( x, p )
        #define IUri_GetPathAndQuery( x, p ) \
            (x)->lpVtbl->GetPathAndQuery( x, p )
        #define IUri_GetQuery( x, p ) \
            (x)->lpVtbl->GetQuery( x, p )
        #define IUri_GetRawUri( x, p ) \
            (x)->lpVtbl->GetRawUri( x, p )
        #define IUri_GetSchemeName( x, p ) \
            (x)->lpVtbl->GetSchemeName( x, p )
        #define IUri_GetUserInfo( x, p ) \
            (x)->lpVtbl->GetUserInfo( x, p )
        #define IUri_GetUserName( x, p ) \
            (x)->lpVtbl->GetUserName( x, p )
        #define IUri_GetHostType( x, p ) \
            (x)->lpVtbl->GetHostType( x, p )
        #define IUri_GetPort( x, p ) \
            (x)->lpVtbl->GetPort( x, p )
        #define IUri_GetScheme( x, p ) \
            (x)->lpVtbl->GetScheme( x, p )
        #define IUri_GetZone( x, p ) \
            (x)->lpVtbl->GetZone( x, p )
        #define IUri_GetProperties( x, p ) \
            (x)->lpVtbl->GetProperties( x, p )
        #define IUri_IsEqual( x, p1, p2 ) \
            (x)->lpVtbl->IsEqual( x, p1, p2 )
        #define IUriContainer_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IUriContainer_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IUriContainer_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IUriContainer_GetIUri( x, p ) \
            (x)->lpVtbl->GetIUri( x, p )
        #define IUriBuilder_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IUriBuilder_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IUriBuilder_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IUriBuilder_CreateUriSimple( x, p1, p2, p3 ) \
            (x)->lpVtbl->CreateUriSimple( x, p1, p2, p3 )
        #define IUriBuilder_CreateUri( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->CreateUri( x, p1, p2, p3, p4 )
        #define IUriBuilder_CreateUriWithFlags( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->CreateUriWithFlags( x, p1, p2, p3, p4, p5 )
        #define IUriBuilder_GetIUri( x, p ) \
            (x)->lpVtbl->GetIUri( x, p )
        #define IUriBuilder_SetIUri( x, p ) \
            (x)->lpVtbl->SetIUri( x, p )
        #define IUriBuilder_GetFragment( x, p1, p2 ) \
            (x)->lpVtbl->GetFragment( x, p1, p2 )
        #define IUriBuilder_GetHost( x, p1, p2 ) \
            (x)->lpVtbl->GetHost( x, p1, p2 )
        #define IUriBuilder_GetPassword( x, p1, p2 ) \
            (x)->lpVtbl->GetPassword( x, p1, p2 )
        #define IUriBuilder_GetPath( x, p1, p2 ) \
            (x)->lpVtbl->GetPath( x, p1, p2 )
        #define IUriBuilder_GetPort( x, p1, p2 ) \
            (x)->lpVtbl->GetPort( x, p1, p2 )
        #define IUriBuilder_GetQuery( x, p1, p2 ) \
            (x)->lpVtbl->GetQuery( x, p1, p2 )
        #define IUriBuilder_GetSchemeName( x, p1, p2 ) \
            (x)->lpVtbl->GetSchemeName( x, p1, p2 )
        #define IUriBuilder_GetUserName( x, p1, p2 ) \
            (x)->lpVtbl->GetUserName( x, p1, p2 )
        #define IUriBuilder_SetFragment( x, p ) \
            (x)->lpVtbl->SetFragment( x, p )
        #define IUriBuilder_SetHost( x, p ) \
            (x)->lpVtbl->SetHost( x, p )
        #define IUriBuilder_SetPassword( x, p ) \
            (x)->lpVtbl->SetPassword( x, p )
        #define IUriBuilder_SetPath( x, p ) \
            (x)->lpVtbl->SetPath( x, p )
        #define IUriBuilder_SetPort( x, p1, p2 ) \
            (x)->lpVtbl->SetPort( x, p1, p2 )
        #define IUriBuilder_SetQuery( x, p ) \
            (x)->lpVtbl->SetQuery( x, p )
        #define IUriBuilder_SetSchemeName( x, p ) \
            (x)->lpVtbl->SetSchemeName( x, p )
        #define IUriBuilder_SetUserName( x, p ) \
            (x)->lpVtbl->SetUserName( x, p )
        #define IUriBuilder_RemoveProperties( x, p ) \
            (x)->lpVtbl->RemoveProperties( x, p )
        #define IUriBuilder_HasBeenModified( x, p ) \
            (x)->lpVtbl->HasBeenModified( x, p )
        #define IUriBuilderFactory_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IUriBuilderFactory_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IUriBuilderFactory_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IUriBuilderFactory_CreateIUriBuilder( x, p1, p2, p3 ) \
            (x)->lpVtbl->CreateIUriBuilder( x, p1, p2, p3 )
        #define IUriBuilderFactory_CreateInitializedIUriBuilder( x, p1, p2, p3 ) \
            (x)->lpVtbl->CreateInitializedIUriBuilder( x, p1, p2, p3 )
    #endif
    #define IWinInetInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IWinInetInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IWinInetInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IWinInetInfo_QueryOption( x, p1, p2, p3 ) \
        (x)->lpVtbl->QueryOption( x, p1, p2, p3 )
    #define IHttpSecurity_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHttpSecurity_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHttpSecurity_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHttpSecurity_GetWindow( x, p1, p2 ) \
        (x)->lpVtbl->GetWindow( x, p1, p2 )
    #define IHttpSecurity_OnSecurityProblem( x, p ) \
        (x)->lpVtbl->OnSecurityProblem( x, p )
    #define IWinInetHttpInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IWinInetHttpInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IWinInetHttpInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IWinInetHttpInfo_QueryOption( x, p1, p2, p3 ) \
        (x)->lpVtbl->QueryOption( x, p1, p2, p3 )
    #define IWinInetHttpInfo_QueryInfo( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->QueryInfo( x, p1, p2, p3, p4, p5 )
    #if (_WIN32_IE >= 0x0602)
        #define IWinInetCacheHints_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IWinInetCacheHints_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IWinInetCacheHints_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IWinInetCacheHints_SetCacheExtension( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->SetCacheExtension( x, p1, p2, p3, p4, p5 )
    #endif
    #if (_WIN32_IE >= 0x0700)
        #define IWinInetCacheHints2_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IWinInetCacheHints2_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IWinInetCacheHints2_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IWinInetCacheHints2_SetCacheExtension( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->SetCacheExtension( x, p1, p2, p3, p4, p5 )
        #define IWinInetCacheHints2_SetCacheExtension2( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->SetCacheExtension2( x, p1, p2, p3, p4, p5 )
    #endif
    #define IBindHost_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IBindHost_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IBindHost_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IBindHost_CreateMoniker( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CreateMoniker( x, p1, p2, p3, p4 )
    #define IBindHost_MonikerBindToStorage( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->MonikerBindToStorage( x, p1, p2, p3, p4, p5 )
    #define IBindHost_MonikerBindToObject( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->MonikerBindToObject( x, p1, p2, p3, p4, p5 )
    #define IInternet_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternet_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternet_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetBindInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetBindInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetBindInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetBindInfo_GetBindInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetBindInfo( x, p1, p2 )
    #define IInternetBindInfo_GetBindString( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetBindString( x, p1, p2, p3, p4 )
    #define IInternetBindInfoEx_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetBindInfoEx_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetBindInfoEx_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetBindInfoEx_GetBindInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetBindInfo( x, p1, p2 )
    #define IInternetBindInfoEx_GetBindString( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetBindString( x, p1, p2, p3, p4 )
    #define IInternetBindInfoEx_GetBindInfoEx( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetBindInfoEx( x, p1, p2, p3, p4 )
    #define IInternetProtocolRoot_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetProtocolRoot_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetProtocolRoot_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetProtocolRoot_Start( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->Start( x, p1, p2, p3, p4, p5 )
    #define IInternetProtocolRoot_Continue( x, p ) \
        (x)->lpVtbl->Continue( x, p )
    #define IInternetProtocolRoot_Abort( x, p1, p2 ) \
        (x)->lpVtbl->Abort( x, p1, p2 )
    #define IInternetProtocolRoot_Terminate( x, p ) \
        (x)->lpVtbl->Terminate( x, p )
    #define IInternetProtocolRoot_Suspend( x ) \
        (x)->lpVtbl->Suspend( x )
    #define IInternetProtocolRoot_Resume( x ) \
        (x)->lpVtbl->Resume( x )
    #define IInternetProtocol_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetProtocol_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetProtocol_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetProtocol_Start( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->Start( x, p1, p2, p3, p4, p5 )
    #define IInternetProtocol_Continue( x, p ) \
        (x)->lpVtbl->Continue( x, p )
    #define IInternetProtocol_Abort( x, p1, p2 ) \
        (x)->lpVtbl->Abort( x, p1, p2 )
    #define IInternetProtocol_Terminate( x, p ) \
        (x)->lpVtbl->Terminate( x, p )
    #define IInternetProtocol_Suspend( x ) \
        (x)->lpVtbl->Suspend( x )
    #define IInternetProtocol_Resume( x ) \
        (x)->lpVtbl->Resume( x )
    #define IInternetProtocol_Read( x, p1, p2, p3 ) \
        (x)->lpVtbl->Read( x, p1, p2, p3 )
    #define IInternetProtocol_Seek( x, p1, p2, p3 ) \
        (x)->lpVtbl->Seek( x, p1, p2, p3 )
    #define IInternetProtocol_LockRequest( x, p ) \
        (x)->lpVtbl->LockRequest( x, p )
    #define IInternetProtocol_UnlockRequest( x ) \
        (x)->lpVtbl->UnlockRequest( x )
    #if (_WIN32_IE >= 0x0700)
        #define IInternetProtocolEx_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IInternetProtocolEx_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IInternetProtocolEx_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IInternetProtocolEx_Start( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->Start( x, p1, p2, p3, p4, p5 )
        #define IInternetProtocolEx_Continue( x, p ) \
            (x)->lpVtbl->Continue( x, p )
        #define IInternetProtocolEx_Abort( x, p1, p2 ) \
            (x)->lpVtbl->Abort( x, p1, p2 )
        #define IInternetProtocolEx_Terminate( x, p ) \
            (x)->lpVtbl->Terminate( x, p )
        #define IInternetProtocolEx_Suspend( x ) \
            (x)->lpVtbl->Suspend( x )   
        #define IInternetProtocolEx_Resume( x ) \
            (x)->lpVtbl->Resume( x )
        #define IInternetProtocolEx_Read( x, p1, p2, p3 ) \
            (x)->lpVtbl->Read( x, p1, p2, p3 )
        #define IInternetProtocolEx_Seek( x, p1, p2, p3 ) \
            (x)->lpVtbl->Seek( x, p1, p2, p3 )
        #define IInternetProtocolEx_LockRequest( x, p ) \
            (x)->lpVtbl->LockRequest( x, p )
        #define IInternetProtocolEx_UnlockRequest( x ) \
            (x)->lpVtbl->UnlockRequest( x )
        #define IInternetProtocolEx_StartEx( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->StartEx( x, p1, p2, p3, p4, p5 )
    #endif
    #define IInternetProtocolSink_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetProtocolSink_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetProtocolSink_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetProtocolSink_Switch( x, p ) \
        (x)->lpVtbl->Switch( x, p )
    #define IInternetProtocolSink_ReportProgress( x, p1, p2 ) \
        (x)->lpVtbl->ReportProgress( x, p1, p2 )
    #define IInternetProtocolSink_ReportData( x, p1, p2, p3 ) \
        (x)->lpVtbl->ReportData( x, p1, p2, p3 )
    #define IInternetProtocolSink_ReportResult( x, p1, p2, p3 ) \
        (x)->lpVtbl->ReportResult( x, p1, p2, p3 )
    #define IInternetProtocolSinkStackable_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetProtocolSinkStackable_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetProtocolSinkStackable_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetProtocolSinkStackable_SwitchSink( x, p ) \
        (x)->lpVtbl->SwitchSink( x, p )
    #define IInternetProtocolSinkStackable_CommitSwitch( x ) \
        (x)->lpVtbl->CommitSwitch( x )
    #define IInternetProtocolSinkStackable_RollbackSwitch( x ) \
        (x)->lpVtbl->RollbackSwitch( x )
    #define IInternetSession_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetSession_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetSession_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetSession_RegisterNameSpace( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->RegisterNameSpace( x, p1, p2, p3, p4, p5, p6 )
    #define IInternetSession_UnregisterNameSpace( x, p1, p2 ) \
        (x)->lpVtbl->UnregisterNameSpace( x, p1, p2 )
    #define IInternetSession_RegisterMimeFilter( x, p1, p2, p3 ) \
        (x)->lpVtbl->RegisterMimeFilter( x, p1, p2, p3 )
    #define IInternetSession_UnregisterMimeFilter( x, p1, p2 ) \
        (x)->lpVtbl->UnregisterMimeFilter( x, p1, p2 )
    #define IInternetSession_CreateBinding( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->CreateBinding( x, p1, p2, p3, p4, p5, p6 )
    #define IInternetSession_SetSessionOption( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->SetSessionOption( x, p1, p2, p3, p4 )
    #define IInternetSession_GetSessionOption( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetSessionOption( x, p1, p2, p3, p4 )
    #define IInternetThreadSwitch_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetThreadSwitch_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetThreadSwitch_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetThreadSwitch_Prepare( x ) \
        (x)->lpVtbl->Prepare( x )
    #define IInternetThreadSwitch_Continue( x ) \
        (x)->lpVtbl->Continue( x )
    #define IInternetPriority_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetPriority_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetPriority_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetPriority_SetPriority( x, p ) \
        (x)->lpVtbl->SetPriority( x, p )
    #define IInternetPriority_GetPriority( x, p ) \
        (x)->lpVtbl->GetPriority( x, p )
    #define IInternetProtocolInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetProtocolInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetProtocolInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetProtocolInfo_ParseUrl( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->ParseUrl( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IInternetProtocolInfo_CombineUrl( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->CombineUrl( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IInternetProtocolInfo_CompareUrl( x, p1, p2, p3 ) \
        (x)->lpVtbl->CompareUrl( x, p1, p2, p3 )
    #define IInternetProtocolInfo_QueryInfo( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->QueryInfo( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IInternetSecurityMgrSite_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetSecurityMgrSite_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetSecurityMgrSite_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetSecurityMgrSite_GetWindow( x, p ) \
        (x)->lpVtbl->GetWindow( x, p )
    #define IInternetSecurityMgrSite_EnableModeless( x, p ) \
        (x)->lpVtbl->EnableModeless( x, p )
    #define IInternetSecurityManager_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetSecurityManager_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetSecurityManager_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetSecurityManager_SetSecuritySite( x, p ) \
        (x)->lpVtbl->SetSecuritySite( x, p )
    #define IInternetSecurityManager_GetSecuritySite( x, p ) \
        (x)->lpVtbl->GetSecuritySite( x, p )
    #define IInternetSecurityManager_MapUrlToZone( x, p1, p2, p3 ) \
        (x)->lpVtbl->MapUrlToZone( x, p1, p2, p3 )
    #define IInternetSecurityManager_GetSecurityId( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetSecurityId( x, p1, p2, p3, p4 )
    #define IInternetSecurityManager_ProcessUrlAction( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->ProcessUrlAction( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IInternetSecurityManager_QueryCustomPolicy( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->QueryCustomPolicy( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IInternetSecurityManager_SetZoneMapping( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetZoneMapping( x, p1, p2, p3 )
    #define IInternetSecurityManager_GetZoneMappings( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetZoneMappings( x, p1, p2, p3 )
    #if (_WIN32_IE >= 0x0602)
        #define IInternetSecurityManagerEx_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IInternetSecurityManagerEx_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IInternetSecurityManagerEx_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IInternetSecurityManagerEx_SetSecuritySite( x, p ) \
            (x)->lpVtbl->SetSecuritySite( x, p )
        #define IInternetSecurityManagerEx_GetSecuritySite( x, p ) \
            (x)->lpVtbl->GetSecuritySite( x, p )
        #define IInternetSecurityManagerEx_MapUrlToZone( x, p1, p2, p3 ) \
            (x)->lpVtbl->MapUrlToZone( x, p1, p2, p3 )
        #define IInternetSecurityManagerEx_GetSecurityId( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->GetSecurityId( x, p1, p2, p3, p4 )
        #define IInternetSecurityManagerEx_ProcessUrlAction( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
            (x)->lpVtbl->ProcessUrlAction( x, p1, p2, p3, p4, p5, p6, p7, p8 )
        #define IInternetSecurityManagerEx_QueryCustomPolicy( x, p1, p2, p3, p4, p5, p6, p7 ) \
            (x)->lpVtbl->QueryCustomPolicy( x, p1, p2, p3, p4, p5, p6, p7 )
        #define IInternetSecurityManagerEx_SetZoneMapping( x, p1, p2, p3 ) \
            (x)->lpVtbl->SetZoneMapping( x, p1, p2, p3 )
        #define IInternetSecurityManagerEx_GetZoneMappings( x, p1, p2, p3 ) \
            (x)->lpVtbl->GetZoneMappings( x, p1, p2, p3 )
        #define IInternetSecurityManagerEx_ProcessUrlActionEx( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 ) \
            (x)->lpVtbl->ProcessUrlActionEx( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 )
    #endif
    #if (_WIN32_IE >= 0x0700)
        #define IInternetSecurityManagerEx2_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IInternetSecurityManagerEx2_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IInternetSecurityManagerEx2_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IInternetSecurityManagerEx2_SetSecuritySite( x, p ) \
            (x)->lpVtbl->SetSecuritySite( x, p )
        #define IInternetSecurityManagerEx2_GetSecuritySite( x, p ) \
            (x)->lpVtbl->GetSecuritySite( x, p )
        #define IInternetSecurityManagerEx2_MapUrlToZone( x, p1, p2, p3 ) \
            (x)->lpVtbl->MapUrlToZone( x, p1, p2, p3 )
        #define IInternetSecurityManagerEx2_GetSecurityId( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->GetSecurityId( x, p1, p2, p3, p4 )
        #define IInternetSecurityManagerEx2_ProcessUrlAction( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
            (x)->lpVtbl->ProcessUrlAction( x, p1, p2, p3, p4, p5, p6, p7, p8 )
        #define IInternetSecurityManagerEx2_QueryCustomPolicy( x, p1, p2, p3, p4, p5, p6, p7 ) \
            (x)->lpVtbl->QueryCustomPolicy( x, p1, p2, p3, p4, p5, p6, p7 )
        #define IInternetSecurityManagerEx2_SetZoneMapping( x, p1, p2, p3 ) \
            (x)->lpVtbl->SetZoneMapping( x, p1, p2, p3 )
        #define IInternetSecurityManagerEx2_GetZoneMappings( x, p1, p2, p3 ) \
            (x)->lpVtbl->GetZoneMappings( x, p1, p2, p3 )
        #define IInternetSecurityManagerEx2_ProcessUrlActionEx( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 ) \
            (x)->lpVtbl->ProcessUrlActionEx( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 )
        #define IInternetSecurityManagerEx2_MapUrlToZoneEx2( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->MapUrlToZoneEx2( x, p1, p2, p3, p4, p5 )
        #define IInternetSecurityManagerEx2_ProcessUrlActionEx2( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 ) \
            (x)->lpVtbl->ProcessUrlActionEx2( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 )
        #define IInternetSecurityManagerEx2_GetSecurityIdEx2( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->GetSecurityIdEx2( x, p1, p2, p3, p4 )
        #define IInternetSecurityManagerEx2_QueryCustomPolicyEx2( x, p1, p2, p3, p4, p5, p6, p7 ) \
            (x)->lpVtbl->QueryCustomPolicyEx2( x, p1, p2, p3, p4, p5, p6, p7 )
    #endif
    #if (_WIN32_IE >= 0x0602)
        #define IZoneIdentifier_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IZoneIdentifier_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IZoneIdentifier_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IZoneIdentifier_GetId( x, p ) \
            (x)->lpVtbl->GetId( x, p )
        #define IZoneIdentifier_SetId( x, p ) \
            (x)->lpVtbl->SetId( x, p )
        #define IZoneIdentifier_Remove( x ) \
            (x)->lpVtbl->Remove( x )
    #endif
    #define IInternetHostSecurityManager_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetHostSecurityManager_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetHostSecurityManager_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetHostSecurityManager_GetSecurityId( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetSecurityId( x, p1, p2, p3 )
    #define IInternetHostSecurityManager_ProcessUrlAction( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->ProcessUrlAction( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IInternetHostSecurityManager_QueryCustomPolicy( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->QueryCustomPolicy( x, p1, p2, p3, p4, p5, p6 )
    #define IInternetZoneManager_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternetZoneManager_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternetZoneManager_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternetZoneManager_GetZoneAttributes( x, p1, p2 ) \
        (x)->lpVtbl->GetZoneAttributes( x, p1, p2 )
    #define IInternetZoneManager_SetZoneAttributes( x, p1, p2 ) \
        (x)->lpVtbl->SetZoneAttributes( x, p1, p2 )
    #define IInternetZoneManager_GetZoneCustomPolicy( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetZoneCustomPolicy( x, p1, p2, p3, p4, p5 )
    #define IInternetZoneManager_SetZoneCustomPolicy( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->SetZoneCustomPolicy( x, p1, p2, p3, p4, p5 )
    #define IInternetZoneManager_GetZoneActionPolicy( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetZoneActionPolicy( x, p1, p2, p3, p4, p5 )
    #define IInternetZoneManager_SetZoneActionPolicy( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->SetZoneActionPolicy( x, p1, p2, p3, p4, p5 )
    #define IInternetZoneManager_PromptAction( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->PromptAction( x, p1, p2, p3, p4, p5 )
    #define IInternetZoneManager_LogAction( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->LogAction( x, p1, p2, p3, p4 )
    #define IInternetZoneManager_CreateZoneEnumerator( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateZoneEnumerator( x, p1, p2, p3 )
    #define IInternetZoneManager_GetZoneAt( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetZoneAt( x, p1, p2, p3 )
    #define IInternetZoneManager_DestroyZoneEnumerator( x, p ) \
        (x)->lpVtbl->DestroyZoneEnumerator( x, p )
    #define IInternetZoneManager_CopyTemplatePoliciesToZone( x, p1, p2, p3 ) \
        (x)->lpVtbl->CopyTemplatePoliciesToZone( x, p1, p2, p3 )
    #if (_WIN32_IE >= 0x0602)
        #define IInternetZoneManagerEx_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IInternetZoneManagerEx_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IInternetZoneManagerEx_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IInternetZoneManagerEx_GetZoneAttributes( x, p1, p2 ) \
            (x)->lpVtbl->GetZoneAttributes( x, p1, p2 )
        #define IInternetZoneManagerEx_SetZoneAttributes( x, p1, p2 ) \
            (x)->lpVtbl->SetZoneAttributes( x, p1, p2 )
        #define IInternetZoneManagerEx_GetZoneCustomPolicy( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->GetZoneCustomPolicy( x, p1, p2, p3, p4, p5 )
        #define IInternetZoneManagerEx_SetZoneCustomPolicy( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->SetZoneCustomPolicy( x, p1, p2, p3, p4, p5 )
        #define IInternetZoneManagerEx_GetZoneActionPolicy( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->GetZoneActionPolicy( x, p1, p2, p3, p4, p5 )
        #define IInternetZoneManagerEx_SetZoneActionPolicy( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->SetZoneActionPolicy( x, p1, p2, p3, p4, p5 )
        #define IInternetZoneManagerEx_PromptAction( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->PromptAction( x, p1, p2, p3, p4, p5 )
        #define IInternetZoneManagerEx_LogAction( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->LogAction( x, p1, p2, p3, p4 )
        #define IInternetZoneManagerEx_CreateZoneEnumerator( x, p1, p2, p3 ) \
            (x)->lpVtbl->CreateZoneEnumerator( x, p1, p2, p3 )
        #define IInternetZoneManagerEx_GetZoneAt( x, p1, p2, p3 ) \
            (x)->lpVtbl->GetZoneAt( x, p1, p2, p3 )
        #define IInternetZoneManagerEx_DestroyZoneEnumerator( x, p ) \
            (x)->lpVtbl->DestroyZoneEnumerator( x, p )
        #define IInternetZoneManagerEx_CopyTemplatePoliciesToZone( x, p1, p2, p3 ) \
            (x)->lpVtbl->CopyTemplatePoliciesToZone( x, p1, p2, p3 )
        #define IInternetZoneManagerEx_GetZoneActionPolicyEx( x, p1, p2, p3, p4, p5, p6 ) \
            (x)->lpVtbl->GetZoneActionPolicyEx( x, p1, p2, p3, p4, p5, p6 )
        #define IInternetZoneManagerEx_SetZoneActionPolicyEx( x, p1, p2, p3, p4, p5, p6 ) \
            (x)->lpVtbl->SetZoneActionPolicyEx( x, p1, p2, p3, p4, p5, p6 )
    #endif
    #if (_WIN32_IE >= 0x0700)
        #define IInternetZoneManagerEx2_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IInternetZoneManagerEx2_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IInternetZoneManagerEx2_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IInternetZoneManagerEx2_GetZoneAttributes( x, p1, p2 ) \
            (x)->lpVtbl->GetZoneAttributes( x, p1, p2 )
        #define IInternetZoneManagerEx2_SetZoneAttributes( x, p1, p2 ) \
            (x)->lpVtbl->SetZoneAttributes( x, p1, p2 )
        #define IInternetZoneManagerEx2_GetZoneCustomPolicy( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->GetZoneCustomPolicy( x, p1, p2, p3, p4, p5 )
        #define IInternetZoneManagerEx2_SetZoneCustomPolicy( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->SetZoneCustomPolicy( x, p1, p2, p3, p4, p5 )
        #define IInternetZoneManagerEx2_GetZoneActionPolicy( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->GetZoneActionPolicy( x, p1, p2, p3, p4, p5 )
        #define IInternetZoneManagerEx2_SetZoneActionPolicy( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->SetZoneActionPolicy( x, p1, p2, p3, p4, p5 )
        #define IInternetZoneManagerEx2_PromptAction( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->PromptAction( x, p1, p2, p3, p4, p5 )
        #define IInternetZoneManagerEx2_LogAction( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->LogAction( x, p1, p2, p3, p4 )
        #define IInternetZoneManagerEx2_CreateZoneEnumerator( x, p1, p2, p3 ) \
            (x)->lpVtbl->CreateZoneEnumerator( x, p1, p2, p3 )
        #define IInternetZoneManagerEx2_GetZoneAt( x, p1, p2, p3 ) \
            (x)->lpVtbl->GetZoneAt( x, p1, p2, p3 )
        #define IInternetZoneManagerEx2_DestroyZoneEnumerator( x, p ) \
            (x)->lpVtbl->DestroyZoneEnumerator( x, p )
        #define IInternetZoneManagerEx2_CopyTemplatePoliciesToZone( x, p1, p2, p3 ) \
            (x)->lpVtbl->CopyTemplatePoliciesToZone( x, p1, p2, p3 )
        #define IInternetZoneManagerEx2_GetZoneActionPolicyEx( x, p1, p2, p3, p4, p5, p6 ) \
            (x)->lpVtbl->GetZoneActionPolicyEx( x, p1, p2, p3, p4, p5, p6 )
        #define IInternetZoneManagerEx2_SetZoneActionPolicyEx( x, p1, p2, p3, p4, p5, p6 ) \
            (x)->lpVtbl->SetZoneActionPolicyEx( x, p1, p2, p3, p4, p5, p6 )
        #define IInternetZoneManagerEx2_GetZoneAttributesEx( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->GetZoneAttributesEx( x, p1, p2, p3, p4 )
        #define IInternetZoneManagerEx2_GetZoneSecurityState( x, p1, p2, p3, p4 ) \ 
            (x)->lpVtbl->GetZoneSecurityState( x, p1, p2, p3, p4 )
        #define IInternetZoneManagerEx2_GetIESecurityState( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->GetIESecurityState( x, p1, p2, p3, p4 )
        #define IInternetZoneManagerEx2_FixUnsecureSettings( x ) \
            (x)->lpVtbl->FixUnsecureSettings( x )
    #endif
    #define ISoftDistExt_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISoftDistExt_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISoftDistExt_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISoftDistExt_ProcessSoftDist( x, p1, p2, p3 ) \
        (x)->lpVtbl->ProcessSoftDist( x, p1, p2, p3 )
    #define ISoftDistExt_GetFirstCodeBase( x, p1, p2 ) \
        (x)->lpVtbl->GetFirstCodeBase( x, p1, p2 )
    #define ISoftDistExt_GetNextCodeBase( x, p1, p2 ) \
        (x)->lpVtbl->GetNextCodeBase( x, p1, p2 )
    #define ISoftDistExt_AsyncInstallDistributionUnit( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->AsyncInstallDistributionUnit( x, p1, p2, p3, p4 )
    #define ICatalogFileInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICatalogFileInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICatalogFileInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICatalogFileInfo_GetCatalogFile( x, p ) \
        (x)->lpVtbl->GetCatalogFile( x, p )
    #define ICatalogFileInfo_GetJavaTrust( x, p ) \
        (x)->lpVtbl->GetJavaTrust( x, p )
    #define IDataFilter_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDataFilter_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDataFilter_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDataFilter_DoEncode( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 ) \
        (x)->lpVtbl->DoEncode( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 )
    #define IDataFilter_DoDecode( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 ) \
        (x)->lpVtbl->DoDecode( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 )
    #define IDataFilter_SetEncodingLevel( x, p ) \
        (x)->lpVtbl->SetEncodingLevel( x, p )
    #define IEncodingFilterFactory_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEncodingFilterFactory_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEncodingFilterFactory_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEncodingFilterFactory_FindBestFilter( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->FindBestFilter( x, p1, p2, p3, p4 )
    #define IEncodingFilterFactory_GetDefaultFilter( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDefaultFilter( x, p1, p2, p3 )
#endif

/* Old names of interfaces for compatibility */
#define IOInet                      IInternet
#define IOInetBindInfo              IInternetBindInfo
#define IOInetBindInfoEx            IInternetBindInfoEx
#define IOInetProtocolRoot          IInternetProtocolRoot
#define IOInetProtocol              IInternetProtocol
#if (_WIN32_IE >= 0x0700)
    #define IOInetProtocolEx        IInternetProtocolEx
#endif
#define IOInetProtocolSink          IInternetProtocolSink
#define IOInetProtocolInfo          IInternetProtocolInfo
#define IOInetSession               IInternetSession
#define IOInetPriority              IInternetPriority
#define IOInetThreadSwitch          IInternetThreadSwitch
#define IOInetProtocolSinkStackable IInternetProtocolSinkStackable

/* Old names of pointers to interfaces for compatibility */
#define LPOINET                         LPIINTERNET
#define LPOINETBINDINFO                 LPIINTERNETBINDINFO
#define LPOINETPROTOCOLROOT             LPIINTERNETPROTOCOLROOT
#define LPOINETPROTOCOL                 LPIINTERNETPROTOCOL
#if (_WIN32_IE >= 0x0700)
    #define LPOINETPROTOCOLEX           LPIINTERNETPROTOCOLEX
#endif
#define LPOINETPROTOCOLSINK             LPIINTERNETPROTOCOLSINK
#define LPOINETPROTOCOLINFO             LPIINTERNETPROTOCOLINFO
#define LPOINETSESSION                  LPIINTERNETSESSION
#define LPOINETPRIORITY                 LPIINTERNETPRIORITY
#define LPOINETTHREADSWITCH             LPIINTERNETTHREADSWITCH
#define LPOINETPROTOCOLSINKSTACKABLE    LPIINTERNETPROTOCOLSINKSTACKABLE

/* Old names of GUIDs for compatibility */
#define IID_IOInet                      IID_IInternet
#define IID_IOInetBindInfo              IID_IInternetBindInfo
#define IID_IOInetBindInfoEx            IID_IInternetBindInfoEx
#define IID_IOInetProtocolRoot          IID_IInternetProtocolRoot
#define IID_IOInetProtocol              IID_IInternetProtocol
#if (_WIN32_IE >= 0x0700)
    #define IID_IOInetProtocolEx        IID_IInternetProtocolEx
#endif
#define IID_IOInetProtocolSink          IID_IInternetProtocolSink
#define IID_IOInetProtocolInfo          IID_IInternetProtocolInfo
#define IID_IOInetSession               IID_IInternetSession
#define IID_IOInetPriority              IID_IInternetPriority
#define IID_IOInetThreadSwitch          IID_IInternetThreadSwitch
#define IID_IOInetProtocolSinkStackable IID_IInternetProtocolSinkStackable

/* Functions in URLMON.DLL */
/* NOTE: Microsoft declares the function CoInternetIsFeatureEnabledForIUri() when
 * _WIN32_IE >= 0x0602.  However, it depends on the IUri interface, which only exists
 * when _WIN32_IE >= 0x0700.  This is a bug that will cause a compiler error when
 * _WIN32_IE is defined as 0x0602.  Therefore, the function is declared here only if
 * _WIN32_IE >= 0x0700. */
STDAPI          AsyncInstallDistributionUnit( LPCWSTR, LPCWSTR, LPCWSTR, DWORD, DWORD, LPCWSTR, IBindCtx *, LPVOID, DWORD );
STDAPI          CoGetClassObjectFromURL( REFCLSID, LPCWSTR, DWORD, DWORD, LPCWSTR, LPBINDCTX, DWORD, LPVOID, REFIID, LPVOID * );
STDAPI          CoInternetCombineUrl( LPCWSTR, LPCWSTR, DWORD, LPWSTR, DWORD, DWORD *, DWORD );
STDAPI          CoInternetCompareUrl( LPCWSTR, LPCWSTR, DWORD );
STDAPI          CoInternetCreateSecurityManager( IServiceProvider *, IInternetSecurityManager **, DWORD );
STDAPI          CoInternetCreateZoneManager( IServiceProvider *, IInternetZoneManager **, DWORD );
STDAPI          CoInternetGetProtocolFlags( LPCWSTR, DWORD *, DWORD );
STDAPI          CoInternetGetSecurityUrl( LPCWSTR, LPWSTR *, PSUACTION, DWORD );
STDAPI          CoInternetGetSession( DWORD, IInternetSession **, DWORD );
STDAPI          CoInternetParseUrl( LPCWSTR, PARSEACTION, DWORD, LPWSTR, DWORD, DWORD *, DWORD );
STDAPI          CoInternetQueryInfo( LPCWSTR, QUERYOPTION, DWORD, LPVOID, DWORD, DWORD *, DWORD );
STDAPI          CompareSecurityIds( BYTE *, DWORD, BYTE *, DWORD, DWORD );
STDAPI          CompatFlagsFromClsid( CLSID *, LPDWORD, LPDWORD );
STDAPI          CopyBindInfo( const BINDINFO *, BINDINFO * );
STDAPI          CopyStgMedium( const STGMEDIUM *, STGMEDIUM * );
STDAPI          CreateAsyncBindCtx( DWORD, IBindStatusCallback *, IEnumFORMATETC *, IBindCtx ** );
STDAPI          CreateAsyncBindCtxEx( IBindCtx *, DWORD, IBindStatusCallback *, IEnumFORMATETC *, IBindCtx **, DWORD );
STDAPI          CreateFormatEnumerator( UINT, FORMATETC *, IEnumFORMATETC ** );
STDAPI          CreateURLBinding( LPCWSTR, IBindCtx *, IBinding ** );
STDAPI          CreateURLMoniker( LPMONIKER, LPCWSTR, LPMONIKER * );
STDAPI          CreateURLMonikerEx( LPMONIKER, LPCWSTR, LPMONIKER *, DWORD );
STDAPI          FaultInIEFeature( HWND, uCLSSPEC *, QUERYCONTEXT *, DWORD );
STDAPI          FindMediaType( LPCSTR, CLIPFORMAT * );
STDAPI          FindMediaTypeClass( LPBC, LPCSTR, CLSID *, DWORD );
STDAPI          FindMimeFromData( LPBC, LPCWSTR, LPVOID, DWORD, LPCWSTR, DWORD, LPWSTR *, DWORD );
STDAPI          GetClassFileOrMime( LPBC, LPCWSTR, LPVOID, DWORD, LPCWSTR, DWORD, CLSID * );
STDAPI          GetClassURL( LPCWSTR, CLSID * );
STDAPI          GetComponentIDFromCLSSPEC( uCLSSPEC *, LPSTR * );
STDAPI          GetSoftwareUpdateInfo( LPCWSTR, LPSOFTDISTINFO );
STDAPI          HlinkGoBack( IUnknown * );
STDAPI          HlinkGoForward( IUnknown * );
STDAPI          HlinkNavigateMoniker( IUnknown *, IMoniker * );
STDAPI          HlinkNavigateString( IUnknown *, LPCWSTR );
STDAPI          HlinkSimpleNavigateToMoniker( IMoniker *, LPCWSTR, LPCWSTR, IUnknown *, IBindCtx *, IBindStatusCallback *, DWORD, DWORD );
STDAPI          HlinkSimpleNavigateToString( LPCWSTR, LPCWSTR, LPCWSTR, IUnknown *, IBindCtx *, IBindStatusCallback *, DWORD, DWORD );
STDAPI          IEInstallScope( LPDWORD );
STDAPI          IsAsyncMoniker( IMoniker * );
STDAPI          IsValidURL( LPBC, LPCWSTR, DWORD );
STDAPI          MkParseDisplayNameEx( IBindCtx *, LPCWSTR, ULONG *, LPMONIKER * );
STDAPI          ObtainUserAgentString( DWORD, LPSTR, DWORD * );
STDAPI          RegisterBindStatusCallback( LPBC, IBindStatusCallback *, IBindStatusCallback **, DWORD );
STDAPI          RegisterFormatEnumerator( LPBC, IEnumFORMATETC *, DWORD );
STDAPI          RegisterMediaTypeClass( LPBC, UINT, const LPCSTR *, CLSID *, DWORD );
STDAPI          RegisterMediaTypes( UINT, const LPCSTR *, CLIPFORMAT * );
STDAPI_( void ) ReleaseBindInfo( BINDINFO * );
STDAPI          RevokeBindStatusCallback( LPBC, IBindStatusCallback * );
STDAPI          RevokeFormatEnumerator( LPBC, IEnumFORMATETC * );
STDAPI          SetSoftwareUpdateAdvertisementState( LPCWSTR, DWORD, DWORD, DWORD );
STDAPI          URLDownloadToCacheFileA( LPUNKNOWN, LPCSTR, LPSTR, DWORD, DWORD, LPBINDSTATUSCALLBACK );
STDAPI          URLDownloadToCacheFileW( LPUNKNOWN, LPCWSTR, LPWSTR, DWORD, DWORD, LPBINDSTATUSCALLBACK );
STDAPI          URLDownloadToFileA( LPUNKNOWN, LPCSTR, LPCSTR, DWORD, LPBINDSTATUSCALLBACK );
STDAPI          URLDownloadToFileW( LPUNKNOWN, LPCWSTR, LPCWSTR, DWORD, LPBINDSTATUSCALLBACK );
STDAPI          URLOpenBlockingStreamA( LPUNKNOWN, LPCSTR, LPSTREAM *, DWORD, LPBINDSTATUSCALLBACK );
STDAPI          URLOpenBlockingStreamW( LPUNKNOWN, LPCWSTR, LPSTREAM *, DWORD, LPBINDSTATUSCALLBACK );
STDAPI          URLOpenPullStreamA( LPUNKNOWN, LPCSTR, DWORD, LPBINDSTATUSCALLBACK );
STDAPI          URLOpenPullStreamW( LPUNKNOWN, LPCWSTR, DWORD, LPBINDSTATUSCALLBACK );
STDAPI          URLOpenStreamA( LPUNKNOWN, LPCSTR, DWORD, LPBINDSTATUSCALLBACK );
STDAPI          URLOpenStreamW( LPUNKNOWN, LPCWSTR, DWORD, LPBINDSTATUSCALLBACK );
STDAPI          UrlMkGetSessionOption( DWORD, LPVOID, DWORD, DWORD *, DWORD );
STDAPI          UrlMkSetSessionOption( DWORD, LPVOID, DWORD, DWORD );
#if (_WIN32_IE >= 0x0602)
STDAPI          CoInternetIsFeatureEnabled( INTERNETFEATURELIST, DWORD );
STDAPI          CoInternetIsFeatureEnabledForUrl( INTERNETFEATURELIST, DWORD, LPCWSTR, IInternetSecurityManager * );
STDAPI          CoInternetIsFeatureZoneElevationEnabled( LPCWSTR, LPCWSTR, IInternetSecurityManager *, DWORD );
STDAPI          CoInternetSetFeatureEnabled( INTERNETFEATURELIST, DWORD, BOOL );
#endif
#if (_WIN32_IE >= 0x0700)
STDAPI          CoInternetCombineIUri( IUri *, IUri *, DWORD, IUri **, DWORD_PTR );
STDAPI          CoInternetCombineUrlEx( IUri *, LPCWSTR, DWORD, IUri **, DWORD_PTR );
STDAPI          CoInternetGetSecurityUrlEx( IUri *, IUri **, PSUACTION, DWORD_PTR );
STDAPI          CoInternetIsFeatureEnabledForIUri( INTERNETFEATURELIST, DWORD, IUri *, IInternetSecurityManagerEx2 * );
STDAPI          CoInternetParseIUri( IUri *, PARSEACTION, DWORD, LPWSTR, DWORD, DWORD *, DWORD_PTR );
STDAPI          CreateIUriBuilder( IUri *, DWORD, DWORD_PTR *, IUriBuilder ** );
STDAPI          CreateURLMonikerEx2( LPMONIKER, IUri *, LPMONIKER, DWORD );
STDAPI          CreateUri( LPCWSTR, DWORD, DWORD_PTR, IUri ** );
STDAPI          CreateUriFromMultiByteString( LPCSTR, DWORD, DWORD, DWORD, DWORD_PTR, IUri ** );
STDAPI          CreateUriWithFragment( LPCWSTR, LPCWSTR, DWORD, DWORD_PTR, IUri ** );
#endif

/* Functions in URLMON.DLL for hit logging */
BOOL WINAPI IsLoggingEnabledA( LPCSTR );
BOOL WINAPI IsLoggingEnabledW( LPCWSTR );
BOOL WINAPI WriteHitLogging( LPHIT_LOGGING_INFO );

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define IsLoggingEnabled        IsLoggingEnabledW
    #define URLDownloadToCacheFile  URLDownloadToCacheFileW
    #define URLDownloadToFile       URLDownloadToFileW
    #define URLOpenBlockingStream   URLOpenBlockingStreamW
    #define URLOpenPullStream       URLOpenPullStreamW
    #define URLOpenStream           URLOpenStreamW
#else
    #define IsLoggingEnabled        IsLoggingEnabledA
    #define URLDownloadToCacheFile  URLDownloadToCacheFileA
    #define URLDownloadToFile       URLDownloadToFileA
    #define URLOpenBlockingStream   URLOpenBlockingStreamA
    #define URLOpenPullStream       URLOpenPullStreamA
    #define URLOpenStream           URLOpenStreamA
#endif

/* Old names of functions for compatibility */
#define OInetCombineUrl         CoInternetCombineUrl
#define OInetCompareUrl         CoInternetCompareUrl
#define OInetGetSession         CoInternetGetSession
#define OInetParseUrl           CoInternetParseUrl
#define OInetQueryInfo          CoInternetQueryInfo
#if (_WIN32_IE >= 0x0700)
    #define OInetCombineIUri    CoInternetCombineIUri
    #define OInetCombineUrlEx   CoInternetCombineUrlEx
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __urlmon_h__ */
