/*
 *  shldisp.h   Shell automation interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __shldisp_h__
#define __shldisp_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Forward declarations */
typedef interface FolderItem        FolderItem;
typedef interface FolderItems       FolderItems;
typedef interface FolderItemVerbs   FolderItemVerbs;

/* Offline folder status values */
typedef enum OfflineFolderStatus {
    OFS_INACTIVE    = -1,
    OFS_ONLINE      = 0,
    OFS_OFFLINE     = 1,
    OFS_SERVERBACK  = 2,
    OFS_DIRTYCACHE  = 3
} OfflineFolderStatus;

/* Shell folder view options */
typedef enum ShellFolderViewOptions {
    SFVVO_SHOWALLOBJECTS        = 0x00000001,
    SFVVO_SHOWEXTENSIONS        = 0x00000002,
    SFVVO_SHOWCOMPCOLOR         = 0x00000008,
    SFVVO_SHOWSYSFILES          = 0x00000020,
    SFVVO_WIN95CLASSIC          = 0x00000040,
    SFVVO_DOUBLECLICKINWEBVIEW  = 0x00000080,
    SFVVO_DESKTOPHTML           = 0x00000200
} ShellFolderViewOptions;

/* Shell special folder constants */
typedef enum ShellSpecialFolderConstants {
    ssfDESKTOP          = 0x0000,
    ssfPROGRAMS         = 0x0002,
    ssfCONTROLS         = 0x0003,
    ssfPRINTERS         = 0x0004,
    ssfPERSONAL         = 0x0005,
    ssfFAVORITES        = 0x0006,
    ssfSTARTUP          = 0x0007,
    ssfRECENT           = 0x0008,
    ssfSENDTO           = 0x0009,
    ssfBITBUCKET        = 0x000A,
    ssfSTARTMENU        = 0x000B,
    ssfDESKTOPDIRECTORY = 0x0010,
    ssfDRIVES           = 0x0011,
    ssfNETWORK          = 0x0012,
    ssfNETHOOD          = 0x0013,
    ssfFONTS            = 0x0014,
    ssfTEMPLATES        = 0x0015,
    ssfCOMMONSTARTMENU  = 0x0016,
    ssfCOMMONPROGRAMS   = 0x0017,
    ssfCOMMONSTARTUP    = 0x0018,
    ssfCOMMONDESKTOPDIR = 0x0019,
    ssfAPPDATA          = 0x001A,
    ssfPRINTHOOD        = 0x001B,
    ssfLOCALAPPDATA     = 0x001C,
    ssfALTSTARTUP       = 0x001D,
    ssfCOMMONALTSTARTUP = 0x001E,
    ssfCOMMONFAVORITES  = 0x001F,
    ssfINTERNETCACHE    = 0x0020,
    ssfCOOKIES          = 0x0021,
    ssfHISTORY          = 0x0022,
    ssfCOMMONAPPDATA    = 0x0023,
    ssfWINDOWS          = 0x0024,
    ssfSYSTEM           = 0x0025,
    ssfPROGRAMFILES     = 0x0026,
    ssfMYPICTURES       = 0x0027,
    ssfPROFILE          = 0x0028,
    ssfSYSTEMx86        = 0x0029,
    ssfPROGRAMFILESx86  = 0x0030
} ShellSpecialFolderConstants;

/* Autocomplete options */
typedef enum _tagAUTOCOMPLETEOPTIONS {
    ACO_NONE                = 0x00000000,
    ACO_AUTOSUGGEST         = 0x00000001,
    ACO_AUTOAPPEND          = 0x00000002,
    ACO_SEARCH              = 0x00000004,
    ACO_FILTERPREFIXES      = 0x00000008,
    ACO_USETAB              = 0x00000010,
    ACO_UPDOWNKEYDROPSLIST  = 0x00000020,
    ACO_RTLREADING          = 0x00000040,
    ACO_WORD_FILTER         = 0x00000080,
    ACO_NOPREFIXFILTERING   = 0x00000100
} AUTOCOMPLETEOPTIONS;

/* IEnumACString options */
typedef enum _tagACENUMOPTION {
    ACEO_NONE               = 0x00000000,
    ACEO_MOSTRECENTFIRST    = 0x00000001,
    ACEO_FIRSTUNUSED        = 0x00010000
} ACENUMOPTION;

/* GUIDs */
EXTERN_C const IID      LIBID_Shell32;
EXTERN_C const IID      IID_IFolderViewOC;
EXTERN_C const IID      DIID_DShellFolderViewEvents;
EXTERN_C const CLSID    CLSID_ShellFolderViewOC;
EXTERN_C const IID      IID_DFConstraint;
EXTERN_C const IID      IID_Folder;
EXTERN_C const IID      IID_Folder2;
EXTERN_C const IID      IID_Folder3;
EXTERN_C const IID      IID_FolderItem;
EXTERN_C const IID      IID_FolderItem2;
EXTERN_C const CLSID    CLSID_ShellFolderItem;
EXTERN_C const IID      IID_FolderItems;
EXTERN_C const IID      IID_FolderItems2;
EXTERN_C const IID      IID_FolderItems3;
EXTERN_C const IID      IID_FolderItemVerb;
EXTERN_C const IID      IID_FolderItemVerbs;
EXTERN_C const IID      IID_IShellLinkDual;
EXTERN_C const IID      IID_IShellLinkDual2;
EXTERN_C const CLSID    CLSID_ShellLinkObject;
EXTERN_C const IID      IID_IShellFolderViewDual;
EXTERN_C const IID      IID_IShellFolderViewDual2;
EXTERN_C const IID      IID_IShellFolderViewDual3;
EXTERN_C const CLSID    CLSID_ShellFolderView;
EXTERN_C const IID      IID_IShellDispatch;
EXTERN_C const IID      IID_IShellDispatch2;
EXTERN_C const IID      IID_IShellDispatch3;
EXTERN_C const IID      IID_IShellDispatch4;
EXTERN_C const IID      IID_IShellDispatch5;
EXTERN_C const CLSID    CLSID_Shell;
EXTERN_C const CLSID    CLSID_ShellDispatchInproc;
EXTERN_C const IID      IID_IFileSearchBand;
EXTERN_C const CLSID    CLSID_FileSearchBand;
EXTERN_C const IID      IID_IWebWizardHost;
EXTERN_C const IID      IID_INewWDEvents;
EXTERN_C const IID      IID_IAutoComplete;
EXTERN_C const IID      IID_IAutoComplete2;
EXTERN_C const IID      IID_IEnumACString;
EXTERN_C const IID      IID_IAsyncOperation;

/* IFolderViewOC interface */
#undef INTERFACE
#define INTERFACE   IFolderViewOC
DECLARE_INTERFACE_( IFolderViewOC, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IFolderViewOC methods */
    STDMETHOD( SetFolderView )( THIS_ IDispatch * ) PURE;
};

/* DShellFolderViewEvents interface */
#undef INTERFACE
#define INTERFACE   DShellFolderViewEvents
DECLARE_INTERFACE_( DShellFolderViewEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DFConstraint interface */
#undef INTERFACE
#define INTERFACE   DFConstraint
DECLARE_INTERFACE_( DFConstraint, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* DFConstraint methods */
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Value )( THIS_ VARIANT * ) PURE;
};

/* Folder interface */
#undef INTERFACE
#define INTERFACE   Folder
DECLARE_INTERFACE_( Folder, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* Folder methods */
    STDMETHOD( get_Title )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_ParentFolder )( THIS_ Folder ** ) PURE;
    STDMETHOD( Items )( THIS_ FolderItems ** ) PURE;
    STDMETHOD( ParseName )( THIS_ BSTR, FolderItem ** ) PURE;
    STDMETHOD( NewFolder )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( MoveHere )( THIS_ VARIANT, VARIANT ) PURE;
    STDMETHOD( CopyHere )( THIS_ VARIANT, VARIANT ) PURE;
    STDMETHOD( GetDetailsOf )( THIS_ VARIANT, int, BSTR * ) PURE;
};

/* Folder2 interface */
#undef INTERFACE
#define INTERFACE   Folder2
DECLARE_INTERFACE_( Folder2, Folder ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* Folder methods */
    STDMETHOD( get_Title )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_ParentFolder )( THIS_ Folder ** ) PURE;
    STDMETHOD( Items )( THIS_ FolderItems ** ) PURE;
    STDMETHOD( ParseName )( THIS_ BSTR, FolderItem ** ) PURE;
    STDMETHOD( NewFolder )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( MoveHere )( THIS_ VARIANT, VARIANT ) PURE;
    STDMETHOD( CopyHere )( THIS_ VARIANT, VARIANT ) PURE;
    STDMETHOD( GetDetailsOf )( THIS_ VARIANT, int, BSTR * ) PURE;

    /* Folder2 methods */
    STDMETHOD( get_Self )( THIS_ FolderItem ** ) PURE;
    STDMETHOD( get_OfflineStatus )( THIS_ LONG * ) PURE;
    STDMETHOD( Synchronize )( THIS ) PURE;
    STDMETHOD( get_HaveToShowWebViewBarricade )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( DismissedWebViewBarricade )( THIS ) PURE;
};

/* Folder3 interface */
#undef INTERFACE
#define INTERFACE   Folder3
DECLARE_INTERFACE_( Folder3, Folder2 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* Folder methods */
    STDMETHOD( get_Title )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_ParentFolder )( THIS_ Folder ** ) PURE;
    STDMETHOD( Items )( THIS_ FolderItems ** ) PURE;
    STDMETHOD( ParseName )( THIS_ BSTR, FolderItem ** ) PURE;
    STDMETHOD( NewFolder )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( MoveHere )( THIS_ VARIANT, VARIANT ) PURE;
    STDMETHOD( CopyHere )( THIS_ VARIANT, VARIANT ) PURE;
    STDMETHOD( GetDetailsOf )( THIS_ VARIANT, int, BSTR * ) PURE;

    /* Folder2 methods */
    STDMETHOD( get_Self )( THIS_ FolderItem ** ) PURE;
    STDMETHOD( get_OfflineStatus )( THIS_ LONG * ) PURE;
    STDMETHOD( Synchronize )( THIS ) PURE;
    STDMETHOD( get_HaveToShowWebViewBarricade )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( DismissedWebViewBarricade )( THIS ) PURE;

    /* Folder3 methods */
    STDMETHOD( get_ShowWebViewBarricade )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_ShowWebViewBarricade )( THIS_ VARIANT_BOOL ) PURE;
};

/* FolderItem interface */
#undef INTERFACE
#define INTERFACE   FolderItem
DECLARE_INTERFACE_( FolderItem, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* FolderItem methods */
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Path )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GetLink )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_GetFolder )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_IsLink )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_IsFolder )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_IsFileSystem )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_IsBrowsable )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_ModifyDate )( THIS_ DATE * ) PURE;
    STDMETHOD( put_ModifyDate )( THIS_ DATE ) PURE;
    STDMETHOD( get_Size )( THIS_ LONG * ) PURE;
    STDMETHOD( get_Type )( THIS_ BSTR * ) PURE;
    STDMETHOD( Verbs )( THIS_ FolderItemVerbs ** ) PURE;
    STDMETHOD( InvokeVerb )( THIS_ VARIANT ) PURE;
};
typedef FolderItem  *LPFOLDERITEM;

/* FolderItem2 interface */
#undef INTERFACE
#define INTERFACE   FolderItem2
DECLARE_INTERFACE_( FolderItem2, FolderItem ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* FolderItem methods */
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Path )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_GetLink )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_GetFolder )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_IsLink )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_IsFolder )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_IsFileSystem )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_IsBrowsable )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_ModifyDate )( THIS_ DATE * ) PURE;
    STDMETHOD( put_ModifyDate )( THIS_ DATE ) PURE;
    STDMETHOD( get_Size )( THIS_ LONG * ) PURE;
    STDMETHOD( get_Type )( THIS_ BSTR * ) PURE;
    STDMETHOD( Verbs )( THIS_ FolderItemVerbs ** ) PURE;
    STDMETHOD( InvokeVerb )( THIS_ VARIANT ) PURE;

    /* FolderItem2 methods */
    STDMETHOD( InvokeVerbEx )( THIS_ VARIANT, VARIANT ) PURE;
    STDMETHOD( ExtendedProperty )( THIS_ BSTR, VARIANT * ) PURE;
};

/* FolderItems interface */
#undef INTERFACE
#define INTERFACE   FolderItems
DECLARE_INTERFACE_( FolderItems, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* FolderItems methods */
    STDMETHOD( get_Count )( THIS_ long * ) PURE;
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( Item )( THIS_ VARIANT, FolderItem ** ) PURE;
    STDMETHOD( _NewEnum )( THIS_ IUnknown ** ) PURE;
};

/* FolderItems2 interface */
#undef INTERFACE
#define INTERFACE   FolderItems2
DECLARE_INTERFACE_( FolderItems2, FolderItems ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* FolderItems methods */
    STDMETHOD( get_Count )( THIS_ long * ) PURE;
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( Item )( THIS_ VARIANT, FolderItem ** ) PURE;
    STDMETHOD( _NewEnum )( THIS_ IUnknown ** ) PURE;

    /* FolderItems2 methods */
    STDMETHOD( InvokeVerbEx )( THIS_ VARIANT, VARIANT ) PURE;
};

/* FolderItems3 interface */
#undef INTERFACE
#define INTERFACE   FolderItems3
DECLARE_INTERFACE_( FolderItems3, FolderItems2 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* FolderItems methods */
    STDMETHOD( get_Count )( THIS_ long * ) PURE;
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( Item )( THIS_ VARIANT, FolderItem ** ) PURE;
    STDMETHOD( _NewEnum )( THIS_ IUnknown ** ) PURE;

    /* FolderItems2 methods */
    STDMETHOD( InvokeVerbEx )( THIS_ VARIANT, VARIANT ) PURE;

    /* FolderItems3 methods */
    STDMETHOD( Filter )( THIS_ long, BSTR ) PURE;
    STDMETHOD( get_Verbs )( THIS_ FolderItemVerbs ** ) PURE;
};

/* FolderItemVerb interface */
#undef INTERFACE
#define INTERFACE   FolderItemVerb
DECLARE_INTERFACE_( FolderItemVerb, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* FolderItemVerb methods */
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Name )( THIS_ BSTR * ) PURE;
    STDMETHOD( DoIt )( THIS ) PURE;
};

/* FolderItemVerbs interface */
#undef INTERFACE
#define INTERFACE   FolderItemVerbs
DECLARE_INTERFACE_( FolderItemVerbs, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* FolderItemVerbs methods */
    STDMETHOD( get_Count )( THIS_ long * ) PURE;
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( Item )( THIS_ VARIANT, FolderItemVerb ** ) PURE;
    STDMETHOD( _NewEnum )( THIS_ IUnknown ** ) PURE;
};

/* IShellLinkDual interface */
#undef INTERFACE
#define INTERFACE   IShellLinkDual
DECLARE_INTERFACE_( IShellLinkDual, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IShellLinkDual methods */
    STDMETHOD( get_Path )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Path )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Description )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Description )( THIS_ BSTR ) PURE;
    STDMETHOD( get_WorkingDirectory )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_WorkingDirectory )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Arguments )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Arguments )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Hotkey )( THIS_ int * ) PURE;
    STDMETHOD( put_Hotkey )( THIS_ int ) PURE;
    STDMETHOD( get_ShowCommand )( THIS_ int * ) PURE;
    STDMETHOD( put_ShowCommand )( THIS_ int ) PURE;
    STDMETHOD( Resolve )( THIS_ int ) PURE;
    STDMETHOD( GetIconLocation )( THIS_ BSTR *, int * ) PURE;
    STDMETHOD( SetIconLocation )( THIS_ BSTR, int ) PURE;
    STDMETHOD( Save )( THIS_ VARIANT ) PURE;
};

/* IShellLinkDual2 interface */
#undef INTERFACE
#define INTERFACE   IShellLinkDual2
DECLARE_INTERFACE_( IShellLinkDual2, IShellLinkDual ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IShellLinkDual methods */
    STDMETHOD( get_Path )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Path )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Description )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Description )( THIS_ BSTR ) PURE;
    STDMETHOD( get_WorkingDirectory )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_WorkingDirectory )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Arguments )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Arguments )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Hotkey )( THIS_ int * ) PURE;
    STDMETHOD( put_Hotkey )( THIS_ int ) PURE;
    STDMETHOD( get_ShowCommand )( THIS_ int * ) PURE;
    STDMETHOD( put_ShowCommand )( THIS_ int ) PURE;
    STDMETHOD( Resolve )( THIS_ int ) PURE;
    STDMETHOD( GetIconLocation )( THIS_ BSTR *, int * ) PURE;
    STDMETHOD( SetIconLocation )( THIS_ BSTR, int ) PURE;
    STDMETHOD( Save )( THIS_ VARIANT ) PURE;

    /* IShellLinkDual2 methods */
    STDMETHOD( get_Target )( THIS_ FolderItem ** ) PURE;
};

/* IShellFolderViewDual interface */
#undef INTERFACE
#define INTERFACE   IShellFolderViewDual
DECLARE_INTERFACE_( IShellFolderViewDual, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IShellFolderViewDual methods */
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Folder )( THIS_ Folder ** ) PURE;
    STDMETHOD( SelectedItems )( THIS_ FolderItems ** ) PURE;
    STDMETHOD( get_FocusedItem )( THIS_ FolderItem ** ) PURE;
    STDMETHOD( SelectItem )( THIS_ VARIANT *, int ) PURE;
    STDMETHOD( PopupItemMenu )( THIS_ FolderItem *, VARIANT, VARIANT, BSTR * ) PURE;
    STDMETHOD( get_Script )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_ViewOptions )( THIS_ long * ) PURE;
};

/* IShellFolderViewDual2 interface */
#undef INTERFACE
#define INTERFACE   IShellFolderViewDual2
DECLARE_INTERFACE_( IShellFolderViewDual2, IShellFolderViewDual ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IShellFolderViewDual methods */
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Folder )( THIS_ Folder ** ) PURE;
    STDMETHOD( SelectedItems )( THIS_ FolderItems ** ) PURE;
    STDMETHOD( get_FocusedItem )( THIS_ FolderItem ** ) PURE;
    STDMETHOD( SelectItem )( THIS_ VARIANT *, int ) PURE;
    STDMETHOD( PopupItemMenu )( THIS_ FolderItem *, VARIANT, VARIANT, BSTR * ) PURE;
    STDMETHOD( get_Script )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_ViewOptions )( THIS_ long * ) PURE;

    /* IShellFolderViewDual2 methods */
    STDMETHOD( get_CurrentViewMode )( THIS_ UINT * ) PURE;
    STDMETHOD( put_CurrentViewMode )( THIS_ UINT ) PURE;
    STDMETHOD( SelectItemRelative )( THIS_ int ) PURE;
};

/* IShellFolderViewDual3 interface */
#undef INTERFACE
#define INTERFACE   IShellFolderViewDual3
DECLARE_INTERFACE_( IShellFolderViewDual3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IShellFolderViewDual methods */
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Folder )( THIS_ Folder ** ) PURE;
    STDMETHOD( SelectedItems )( THIS_ FolderItems ** ) PURE;
    STDMETHOD( get_FocusedItem )( THIS_ FolderItem ** ) PURE;
    STDMETHOD( SelectItem )( THIS_ VARIANT *, int ) PURE;
    STDMETHOD( PopupItemMenu )( THIS_ FolderItem *, VARIANT, VARIANT, BSTR * ) PURE;
    STDMETHOD( get_Script )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_ViewOptions )( THIS_ long * ) PURE;

    /* IShellFolderViewDual2 methods */
    STDMETHOD( get_CurrentViewMode )( THIS_ UINT * ) PURE;
    STDMETHOD( put_CurrentViewMode )( THIS_ UINT ) PURE;
    STDMETHOD( SelectItemRelative )( THIS_ int ) PURE;

    /* IShellFolderViewDual3 methods */
    STDMETHOD( get_GroupBy )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_GroupBy )( THIS_ BSTR ) PURE;
    STDMETHOD( get_FolderFlags )( THIS_ DWORD * ) PURE;
    STDMETHOD( put_FolderFlags )( THIS_ DWORD ) PURE;
    STDMETHOD( get_SortColumns )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_SortColumns )( THIS_ BSTR ) PURE;
    STDMETHOD( put_IconSize )( THIS_ int ) PURE;
    STDMETHOD( get_IconSize )( THIS_ int * ) PURE;
    STDMETHOD( FilterView )( THIS_ BSTR ) PURE;
};

/* IShellDispatch interface */
#undef INTERFACE
#define INTERFACE   IShellDispatch
DECLARE_INTERFACE_( IShellDispatch, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IShellDispatch methods */
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( NameSpace )( THIS_ VARIANT, Folder ** ) PURE;
    STDMETHOD( BrowseForFolder )( THIS_ long, BSTR, long, VARIANT, Folder ** ) PURE;
    STDMETHOD( Windows )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( Open )( THIS_ VARIANT ) PURE;
    STDMETHOD( Explore )( THIS_ VARIANT ) PURE;
    STDMETHOD( MinimizeAll )( THIS ) PURE;
    STDMETHOD( UndoMinimizeALL )( THIS ) PURE;
    STDMETHOD( FileRun )( THIS ) PURE;
    STDMETHOD( CascadeWindows )( THIS ) PURE;
    STDMETHOD( TileVertically )( THIS ) PURE;
    STDMETHOD( TileHorizontally )( THIS ) PURE;
    STDMETHOD( ShutdownWindows )( THIS ) PURE;
    STDMETHOD( Suspend )( THIS ) PURE;
    STDMETHOD( EjectPC )( THIS ) PURE;
    STDMETHOD( SetTime )( THIS ) PURE;
    STDMETHOD( TrayProperties )( THIS ) PURE;
    STDMETHOD( Help )( THIS ) PURE;
    STDMETHOD( FindFiles )( THIS ) PURE;
    STDMETHOD( FindComputer )( THIS ) PURE;
    STDMETHOD( RefreshMenu )( THIS ) PURE;
    STDMETHOD( ControlPanelItem )( THIS_ BSTR ) PURE;
};

/* IShellDispatch2 interface */
#undef INTERFACE
#define INTERFACE   IShellDispatch2
DECLARE_INTERFACE_( IShellDispatch2, IShellDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IShellDispatch methods */
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( NameSpace )( THIS_ VARIANT, Folder ** ) PURE;
    STDMETHOD( BrowseForFolder )( THIS_ long, BSTR, long, VARIANT, Folder ** ) PURE;
    STDMETHOD( Windows )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( Open )( THIS_ VARIANT ) PURE;
    STDMETHOD( Explore )( THIS_ VARIANT ) PURE;
    STDMETHOD( MinimizeAll )( THIS ) PURE;
    STDMETHOD( UndoMinimizeALL )( THIS ) PURE;
    STDMETHOD( FileRun )( THIS ) PURE;
    STDMETHOD( CascadeWindows )( THIS ) PURE;
    STDMETHOD( TileVertically )( THIS ) PURE;
    STDMETHOD( TileHorizontally )( THIS ) PURE;
    STDMETHOD( ShutdownWindows )( THIS ) PURE;
    STDMETHOD( Suspend )( THIS ) PURE;
    STDMETHOD( EjectPC )( THIS ) PURE;
    STDMETHOD( SetTime )( THIS ) PURE;
    STDMETHOD( TrayProperties )( THIS ) PURE;
    STDMETHOD( Help )( THIS ) PURE;
    STDMETHOD( FindFiles )( THIS ) PURE;
    STDMETHOD( FindComputer )( THIS ) PURE;
    STDMETHOD( RefreshMenu )( THIS ) PURE;
    STDMETHOD( ControlPanelItem )( THIS_ BSTR ) PURE;

    /* IShellDispatch2 methods */
    STDMETHOD( IsRestricted )( THIS_ BSTR, BSTR, long * ) PURE;
    STDMETHOD( ShellExecute )( THIS_ BSTR, VARIANT, VARIANT, VARIANT, VARIANT ) PURE;
    STDMETHOD( FindPrinter )( THIS_ BSTR, BSTR, BSTR ) PURE;
    STDMETHOD( GetSystemInformation )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( ServiceStart )( THIS_ BSTR, VARIANT, VARIANT * ) PURE;
    STDMETHOD( ServiceStop )( THIS_ BSTR, VARIANT, VARIANT * ) PURE;
    STDMETHOD( IsServiceRunning )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( CanStartStopService )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( ShowBrowseBar )( THIS_ BSTR, VARIANT, VARIANT * ) PURE;
};

/* IShellDispatch3 interface */
#undef INTERFACE
#define INTERFACE   IShellDispatch3
DECLARE_INTERFACE_( IShellDispatch3, IShellDispatch2 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IShellDispatch methods */
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( NameSpace )( THIS_ VARIANT, Folder ** ) PURE;
    STDMETHOD( BrowseForFolder )( THIS_ long, BSTR, long, VARIANT, Folder ** ) PURE;
    STDMETHOD( Windows )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( Open )( THIS_ VARIANT ) PURE;
    STDMETHOD( Explore )( THIS_ VARIANT ) PURE;
    STDMETHOD( MinimizeAll )( THIS ) PURE;
    STDMETHOD( UndoMinimizeALL )( THIS ) PURE;
    STDMETHOD( FileRun )( THIS ) PURE;
    STDMETHOD( CascadeWindows )( THIS ) PURE;
    STDMETHOD( TileVertically )( THIS ) PURE;
    STDMETHOD( TileHorizontally )( THIS ) PURE;
    STDMETHOD( ShutdownWindows )( THIS ) PURE;
    STDMETHOD( Suspend )( THIS ) PURE;
    STDMETHOD( EjectPC )( THIS ) PURE;
    STDMETHOD( SetTime )( THIS ) PURE;
    STDMETHOD( TrayProperties )( THIS ) PURE;
    STDMETHOD( Help )( THIS ) PURE;
    STDMETHOD( FindFiles )( THIS ) PURE;
    STDMETHOD( FindComputer )( THIS ) PURE;
    STDMETHOD( RefreshMenu )( THIS ) PURE;
    STDMETHOD( ControlPanelItem )( THIS_ BSTR ) PURE;

    /* IShellDispatch2 methods */
    STDMETHOD( IsRestricted )( THIS_ BSTR, BSTR, long * ) PURE;
    STDMETHOD( ShellExecute )( THIS_ BSTR, VARIANT, VARIANT, VARIANT, VARIANT ) PURE;
    STDMETHOD( FindPrinter )( THIS_ BSTR, BSTR, BSTR ) PURE;
    STDMETHOD( GetSystemInformation )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( ServiceStart )( THIS_ BSTR, VARIANT, VARIANT * ) PURE;
    STDMETHOD( ServiceStop )( THIS_ BSTR, VARIANT, VARIANT * ) PURE;
    STDMETHOD( IsServiceRunning )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( CanStartStopService )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( ShowBrowseBar )( THIS_ BSTR, VARIANT, VARIANT * ) PURE;

    /* IShellDispatch3 methods */
    STDMETHOD( AddToRecent )( THIS_ VARIANT, BSTR ) PURE;
};

/* IShellDispatch4 interface */
#undef INTERFACE
#define INTERFACE   IShellDispatch4
DECLARE_INTERFACE_( IShellDispatch4, IShellDispatch3 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IShellDispatch methods */
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( NameSpace )( THIS_ VARIANT, Folder ** ) PURE;
    STDMETHOD( BrowseForFolder )( THIS_ long, BSTR, long, VARIANT, Folder ** ) PURE;
    STDMETHOD( Windows )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( Open )( THIS_ VARIANT ) PURE;
    STDMETHOD( Explore )( THIS_ VARIANT ) PURE;
    STDMETHOD( MinimizeAll )( THIS ) PURE;
    STDMETHOD( UndoMinimizeALL )( THIS ) PURE;
    STDMETHOD( FileRun )( THIS ) PURE;
    STDMETHOD( CascadeWindows )( THIS ) PURE;
    STDMETHOD( TileVertically )( THIS ) PURE;
    STDMETHOD( TileHorizontally )( THIS ) PURE;
    STDMETHOD( ShutdownWindows )( THIS ) PURE;
    STDMETHOD( Suspend )( THIS ) PURE;
    STDMETHOD( EjectPC )( THIS ) PURE;
    STDMETHOD( SetTime )( THIS ) PURE;
    STDMETHOD( TrayProperties )( THIS ) PURE;
    STDMETHOD( Help )( THIS ) PURE;
    STDMETHOD( FindFiles )( THIS ) PURE;
    STDMETHOD( FindComputer )( THIS ) PURE;
    STDMETHOD( RefreshMenu )( THIS ) PURE;
    STDMETHOD( ControlPanelItem )( THIS_ BSTR ) PURE;

    /* IShellDispatch2 methods */
    STDMETHOD( IsRestricted )( THIS_ BSTR, BSTR, long * ) PURE;
    STDMETHOD( ShellExecute )( THIS_ BSTR, VARIANT, VARIANT, VARIANT, VARIANT ) PURE;
    STDMETHOD( FindPrinter )( THIS_ BSTR, BSTR, BSTR ) PURE;
    STDMETHOD( GetSystemInformation )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( ServiceStart )( THIS_ BSTR, VARIANT, VARIANT * ) PURE;
    STDMETHOD( ServiceStop )( THIS_ BSTR, VARIANT, VARIANT * ) PURE;
    STDMETHOD( IsServiceRunning )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( CanStartStopService )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( ShowBrowseBar )( THIS_ BSTR, VARIANT, VARIANT * ) PURE;

    /* IShellDispatch3 methods */
    STDMETHOD( AddToRecent )( THIS_ VARIANT, BSTR ) PURE;

    /* IShellDispatch4 methods */
    STDMETHOD( WindowsSecurity )( THIS ) PURE;
    STDMETHOD( ToggleDesktop )( THIS ) PURE;
    STDMETHOD( ExplorerPolicy )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( GetSetting )( THIS_ long, VARIANT_BOOL * ) PURE;
};

/* IShellDispatch5 interface */
#undef INTERFACE
#define INTERFACE   IShellDispatch5
DECLARE_INTERFACE_( IShellDispatch5, IShellDispatch4 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IShellDispatch methods */
    STDMETHOD( get_Application )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Parent )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( NameSpace )( THIS_ VARIANT, Folder ** ) PURE;
    STDMETHOD( BrowseForFolder )( THIS_ long, BSTR, long, VARIANT, Folder ** ) PURE;
    STDMETHOD( Windows )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( Open )( THIS_ VARIANT ) PURE;
    STDMETHOD( Explore )( THIS_ VARIANT ) PURE;
    STDMETHOD( MinimizeAll )( THIS ) PURE;
    STDMETHOD( UndoMinimizeALL )( THIS ) PURE;
    STDMETHOD( FileRun )( THIS ) PURE;
    STDMETHOD( CascadeWindows )( THIS ) PURE;
    STDMETHOD( TileVertically )( THIS ) PURE;
    STDMETHOD( TileHorizontally )( THIS ) PURE;
    STDMETHOD( ShutdownWindows )( THIS ) PURE;
    STDMETHOD( Suspend )( THIS ) PURE;
    STDMETHOD( EjectPC )( THIS ) PURE;
    STDMETHOD( SetTime )( THIS ) PURE;
    STDMETHOD( TrayProperties )( THIS ) PURE;
    STDMETHOD( Help )( THIS ) PURE;
    STDMETHOD( FindFiles )( THIS ) PURE;
    STDMETHOD( FindComputer )( THIS ) PURE;
    STDMETHOD( RefreshMenu )( THIS ) PURE;
    STDMETHOD( ControlPanelItem )( THIS_ BSTR ) PURE;

    /* IShellDispatch2 methods */
    STDMETHOD( IsRestricted )( THIS_ BSTR, BSTR, long * ) PURE;
    STDMETHOD( ShellExecute )( THIS_ BSTR, VARIANT, VARIANT, VARIANT, VARIANT ) PURE;
    STDMETHOD( FindPrinter )( THIS_ BSTR, BSTR, BSTR ) PURE;
    STDMETHOD( GetSystemInformation )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( ServiceStart )( THIS_ BSTR, VARIANT, VARIANT * ) PURE;
    STDMETHOD( ServiceStop )( THIS_ BSTR, VARIANT, VARIANT * ) PURE;
    STDMETHOD( IsServiceRunning )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( CanStartStopService )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( ShowBrowseBar )( THIS_ BSTR, VARIANT, VARIANT * ) PURE;

    /* IShellDispatch3 methods */
    STDMETHOD( AddToRecent )( THIS_ VARIANT, BSTR ) PURE;

    /* IShellDispatch4 methods */
    STDMETHOD( WindowsSecurity )( THIS ) PURE;
    STDMETHOD( ToggleDesktop )( THIS ) PURE;
    STDMETHOD( ExplorerPolicy )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( GetSetting )( THIS_ long, VARIANT_BOOL * ) PURE;

    /* IShellDispatch5 methods */
    STDMETHOD( WindowSwitcher )( THIS ) PURE;
};

/* IFileSearchBand interface */
#undef INTERFACE
#define INTERFACE   IFileSearchBand
DECLARE_INTERFACE_( IFileSearchBand, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IFileSearchBand methods */
    STDMETHOD( SetFocus )( THIS ) PURE;
    STDMETHOD( SetSearchParameters )( THIS_ BSTR *, VARIANT_BOOL, VARIANT *, VARIANT * ) PURE;
    STDMETHOD( get_SearchID )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_Scope )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_QueryFile )( THIS_ VARIANT * ) PURE;
};

/* IWebWizardHost interface */
#undef INTERFACE
#define INTERFACE   IWebWizardHost
DECLARE_INTERFACE_( IWebWizardHost, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IWebWizardHost methods */
    STDMETHOD( FinalBack )( THIS ) PURE;
    STDMETHOD( FinalNext )( THIS ) PURE;
    STDMETHOD( Cancel )( THIS ) PURE;
    STDMETHOD( put_Caption )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Caption )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Property )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( get_Property )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( SetWizardButtons )( THIS_ VARIANT_BOOL, VARIANT_BOOL, VARIANT_BOOL ) PURE;
    STDMETHOD( SetHeaderText )( THIS_ BSTR, BSTR ) PURE;
};

/* INewWDEvents interface */
#undef INTERFACE
#define INTERFACE   INewWDEvents
DECLARE_INTERFACE_( INewWDEvents, IWebWizardHost ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IWebWizardHost methods */
    STDMETHOD( FinalBack )( THIS ) PURE;
    STDMETHOD( FinalNext )( THIS ) PURE;
    STDMETHOD( Cancel )( THIS ) PURE;
    STDMETHOD( put_Caption )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Caption )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Property )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( get_Property )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( SetWizardButtons )( THIS_ VARIANT_BOOL, VARIANT_BOOL, VARIANT_BOOL ) PURE;
    STDMETHOD( SetHeaderText )( THIS_ BSTR, BSTR ) PURE;

    /* INewWDEvents methods */
    STDMETHOD( PassportAuthenticate )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
};

/* IAutoComplete interface */
#undef INTERFACE
#define INTERFACE   IAutoComplete
DECLARE_INTERFACE_( IAutoComplete, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAutoComplete methods */
    STDMETHOD( Init )( THIS_ HWND, IUnknown *, LPCWSTR, LPCWSTR ) PURE;
    STDMETHOD( Enable )( THIS_ BOOL ) PURE;
};
typedef IAutoComplete   *LPAUTOCOMPLETE;

/* IAutoComplete2 interface */
#undef INTERFACE
#define INTERFACE   IAutoComplete2
DECLARE_INTERFACE_( IAutoComplete2, IAutoComplete ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAutoComplete methods */
    STDMETHOD( Init )( THIS_ HWND, IUnknown *, LPCWSTR, LPCWSTR ) PURE;
    STDMETHOD( Enable )( THIS_ BOOL ) PURE;

    /* IAutoComplete2 methods */
    STDMETHOD( SetOptions )( THIS_ DWORD ) PURE;
    STDMETHOD( GetOptions )( THIS_ DWORD * ) PURE;
};
typedef IAutoComplete2  *LPAUTOCOMPLETE2;

/* IEnumACString interface */
#undef INTERFACE
#define INTERFACE   IEnumACString
DECLARE_INTERFACE_( IEnumACString, IEnumString ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IEnumString methods */
    STDMETHOD( Next )( THIS_ ULONG, LPOLESTR *, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumString ** ) PURE;

    /* IEnumACString methods */
    STDMETHOD( NextItem )( THIS_ LPWSTR, ULONG, ULONG * ) PURE;
    STDMETHOD( SetEnumOptions )( THIS_ DWORD ) PURE;
    STDMETHOD( GetEnumOptions )( THIS_ DWORD * ) PURE;
};
typedef IEnumACString   *PENUMACSTRING;
typedef IEnumACString   *LPENUMACSTRING;

/* IAsyncOperation interface */
#undef INTERFACE
#define INTERFACE   IAsyncOperation
DECLARE_INTERFACE_( IAsyncOperation, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAsyncOperation methods */
    STDMETHOD( SetAsyncMode )( THIS_ BOOL ) PURE;
    STDMETHOD( GetAsyncMode )( THIS_ BOOL * ) PURE;
    STDMETHOD( StartOperation )( THIS_ IBindCtx * ) PURE;
    STDMETHOD( InOperation )( THIS_ BOOL * ) PURE;
    STDMETHOD( EndOperation )( THIS_ HRESULT, IBindCtx *, DWORD ) PURE;
};
typedef IAsyncOperation *LPASYNCOPERATION;

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IFolderViewOC_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFolderViewOC_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFolderViewOC_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFolderViewOC_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IFolderViewOC_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IFolderViewOC_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IFolderViewOC_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IFolderViewOC_SetFolderView( x, p ) \
        (x)->lpVtbl->SetFolderView( x, p )
    #define DShellFolderViewEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DShellFolderViewEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DShellFolderViewEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DShellFolderViewEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DShellFolderViewEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DShellFolderViewEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DShellFolderViewEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DFConstraint_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DFConstraint_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DFConstraint_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DFConstraint_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DFConstraint_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DFConstraint_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DFConstraint_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DFConstraint_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define DFConstraint_get_Value( x, p ) \
        (x)->lpVtbl->get_Value( x, p )
    #define Folder_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define Folder_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define Folder_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define Folder_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define Folder_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define Folder_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define Folder_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define Folder_get_Title( x, p ) \
        (x)->lpVtbl->get_Title( x, p )
    #define Folder_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define Folder_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define Folder_get_ParentFolder( x, p ) \
        (x)->lpVtbl->get_ParentFolder( x, p )
    #define Folder_Items( x, p ) \
        (x)->lpVtbl->Items( x, p )
    #define Folder_ParseName( x, p1, p2 ) \
        (x)->lpVtbl->ParseName( x, p1, p2 )
    #define Folder_NewFolder( x, p1, p2 ) \
        (x)->lpVtbl->NewFolder( x, p1, p2 )
    #define Folder_MoveHere( x, p1, p2 ) \
        (x)->lpVtbl->MoveHere( x, p1, p2 )
    #define Folder_CopyHere( x, p1, p2 ) \
        (x)->lpVtbl->CopyHere( x, p1, p2 )
    #define Folder_GetDetailsOf( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDetailsOf( x, p1, p2, p3 )
    #define Folder2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define Folder2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define Folder2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define Folder2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define Folder2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define Folder2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define Folder2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define Folder2_get_Title( x, p ) \
        (x)->lpVtbl->get_Title( x, p )
    #define Folder2_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define Folder2_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define Folder2_get_ParentFolder( x, p ) \
        (x)->lpVtbl->get_ParentFolder( x, p )
    #define Folder2_Items( x, p ) \
        (x)->lpVtbl->Items( x, p )
    #define Folder2_ParseName( x, p1, p2 ) \
        (x)->lpVtbl->ParseName( x, p1, p2 )
    #define Folder2_NewFolder( x, p1, p2 ) \
        (x)->lpVtbl->NewFolder( x, p1, p2 )
    #define Folder2_MoveHere( x, p1, p2 ) \
        (x)->lpVtbl->MoveHere( x, p1, p2 )
    #define Folder2_CopyHere( x, p1, p2 ) \
        (x)->lpVtbl->CopyHere( x, p1, p2 )
    #define Folder2_GetDetailsOf( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDetailsOf( x, p1, p2, p3 )
    #define Folder2_get_Self( x, p ) \
        (x)->lpVtbl->get_Self( x, p )
    #define Folder2_get_OfflineStatus( x, p ) \
        (x)->lpVtbl->get_OfflineStatus( x, p )
    #define Folder2_Synchronize( x ) \
        (x)->lpVtbl->Synchronize( x )
    #define Folder2_get_HaveToShowWebViewBarricade( x, p ) \
        (x)->lpVtbl->get_HaveToShowWebViewBarricade( x, p )
    #define Folder2_DismissedWebViewBarricade( x ) \
        (x)->lpVtbl->DismissedWebViewBarricade( x )
    #define Folder3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define Folder3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define Folder3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define Folder3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define Folder3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define Folder3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define Folder3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define Folder3_get_Title( x, p ) \
        (x)->lpVtbl->get_Title( x, p )
    #define Folder3_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define Folder3_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define Folder3_get_ParentFolder( x, p ) \
        (x)->lpVtbl->get_ParentFolder( x, p )
    #define Folder3_Items( x, p ) \
        (x)->lpVtbl->Items( x, p )
    #define Folder3_ParseName( x, p1, p2 ) \
        (x)->lpVtbl->ParseName( x, p1, p2 )
    #define Folder3_NewFolder( x, p1, p2 ) \
        (x)->lpVtbl->NewFolder( x, p1, p2 )
    #define Folder3_MoveHere( x, p1, p2 ) \
        (x)->lpVtbl->MoveHere( x, p1, p2 )
    #define Folder3_CopyHere( x, p1, p2 ) \
        (x)->lpVtbl->CopyHere( x, p1, p2 )
    #define Folder3_GetDetailsOf( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDetailsOf( x, p1, p2, p3 )
    #define Folder3_get_Self( x, p ) \
        (x)->lpVtbl->get_Self( x, p )
    #define Folder3_get_OfflineStatus( x, p ) \
        (x)->lpVtbl->get_OfflineStatus( x, p )
    #define Folder3_Synchronize( x ) \
        (x)->lpVtbl->Synchronize( x )
    #define Folder3_get_HaveToShowWebViewBarricade( x, p ) \
        (x)->lpVtbl->get_HaveToShowWebViewBarricade( x, p )
    #define Folder3_DismissedWebViewBarricade( x ) \
        (x)->lpVtbl->DismissedWebViewBarricade( x )
    #define FolderItem_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define FolderItem_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define FolderItem_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define FolderItem_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define FolderItem_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define FolderItem_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define FolderItem_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define FolderItem_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define FolderItem_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define FolderItem_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define FolderItem_put_Name( x, p ) \
        (x)->lpVtbl->put_Name( x, p )
    #define FolderItem_get_Path( x, p ) \
        (x)->lpVtbl->get_Path( x, p )
    #define FolderItem_get_GetLink( x, p ) \
        (x)->lpVtbl->get_GetLink( x, p )
    #define FolderItem_get_GetFolder( x, p ) \
        (x)->lpVtbl->get_GetFolder( x, p )
    #define FolderItem_get_IsLink( x, p ) \
        (x)->lpVtbl->get_IsLink( x, p )
    #define FolderItem_get_IsFolder( x, p ) \
        (x)->lpVtbl->get_IsFolder( x, p )
    #define FolderItem_get_IsFileSystem( x, p ) \
        (x)->lpVtbl->get_IsFileSystem( x, p )
    #define FolderItem_get_IsBrowsable( x, p ) \
        (x)->lpVtbl->get_IsBrowsable( x, p )
    #define FolderItem_get_ModifyDate( x, p ) \
        (x)->lpVtbl->get_ModifyDate( x, p )
    #define FolderItem_put_ModifyDate( x, p ) \
        (x)->lpVtbl->put_ModifyDate( x, p )
    #define FolderItem_get_Size( x, p ) \
        (x)->lpVtbl->get_Size( x, p )
    #define FolderItem_get_Type( x, p ) \
        (x)->lpVtbl->get_Type( x, p )
    #define FolderItem_Verbs( x, p ) \
        (x)->lpVtbl->Verbs( x, p )
    #define FolderItem_InvokeVerb( x, p ) \
        (x)->lpVtbl->InvokeVerb( x, p )
    #define FolderItem2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define FolderItem2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define FolderItem2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define FolderItem2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define FolderItem2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define FolderItem2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define FolderItem2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define FolderItem2_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define FolderItem2_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define FolderItem2_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define FolderItem2_put_Name( x, p ) \
        (x)->lpVtbl->put_Name( x, p )
    #define FolderItem2_get_Path( x, p ) \
        (x)->lpVtbl->get_Path( x, p )
    #define FolderItem2_get_GetLink( x, p ) \
        (x)->lpVtbl->get_GetLink( x, p )
    #define FolderItem2_get_GetFolder( x, p ) \
        (x)->lpVtbl->get_GetFolder( x, p )
    #define FolderItem2_get_IsLink( x, p ) \
        (x)->lpVtbl->get_IsLink( x, p )
    #define FolderItem2_get_IsFolder( x, p ) \
        (x)->lpVtbl->get_IsFolder( x, p )
    #define FolderItem2_get_IsFileSystem( x, p ) \
        (x)->lpVtbl->get_IsFileSystem( x, p )
    #define FolderItem2_get_IsBrowsable( x, p ) \
        (x)->lpVtbl->get_IsBrowsable( x, p )
    #define FolderItem2_get_ModifyDate( x, p ) \
        (x)->lpVtbl->get_ModifyDate( x, p )
    #define FolderItem2_put_ModifyDate( x, p ) \
        (x)->lpVtbl->put_ModifyDate( x, p )
    #define FolderItem2_get_Size( x, p ) \
        (x)->lpVtbl->get_Size( x, p )
    #define FolderItem2_get_Type( x, p ) \
        (x)->lpVtbl->get_Type( x, p )
    #define FolderItem2_Verbs( x, p ) \
        (x)->lpVtbl->Verbs( x, p )
    #define FolderItem2_InvokeVerb( x, p ) \
        (x)->lpVtbl->InvokeVerb( x, p )
    #define FolderItem2_InvokeVerbEx( x, p1, p2 ) \
        (x)->lpVtbl->InvokeVerbEx( x, p1, p2 )
    #define FolderItem2_ExtendedProperty( x, p1, p2 ) \
        (x)->lpVtbl->ExtendedProperty( x, p1, p2 )
    #define FolderItems_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define FolderItems_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define FolderItems_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define FolderItems_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define FolderItems_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define FolderItems_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define FolderItems_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define FolderItems_get_Count( x, p ) \
        (x)->lpVtbl->get_Count( x, p )
    #define FolderItems_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define FolderItems_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define FolderItems_Item( x, p1, p2 ) \
        (x)->lpVtbl->Item( x, p1, p2 )
    #define FolderItems__NewEnum( x, p ) \
        (x)->lpVtbl->_NewEnum( x, p )
    #define FolderItems2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define FolderItems2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define FolderItems2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define FolderItems2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define FolderItems2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define FolderItems2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define FolderItems2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define FolderItems2_get_Count( x, p ) \
        (x)->lpVtbl->get_Count( x, p )
    #define FolderItems2_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define FolderItems2_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define FolderItems2_Item( x, p1, p2 ) \
        (x)->lpVtbl->Item( x, p1, p2 )
    #define FolderItems2__NewEnum( x, p ) \
        (x)->lpVtbl->_NewEnum( x, p )
    #define FolderItems2_InvokeVerbEx( x, p1, p2 ) \
        (x)->lpVtbl->InvokeVerbEx( x, p1, p2 )
    #define FolderItems3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define FolderItems3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define FolderItems3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define FolderItems3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define FolderItems3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define FolderItems3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define FolderItems3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define FolderItems3_get_Count( x, p ) \
        (x)->lpVtbl->get_Count( x, p )
    #define FolderItems3_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define FolderItems3_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define FolderItems3_Item( x, p1, p2 ) \
        (x)->lpVtbl->Item( x, p1, p2 )
    #define FolderItems3__NewEnum( x, p ) \
        (x)->lpVtbl->_NewEnum( x, p )
    #define FolderItems3_InvokeVerbEx( x, p1, p2 ) \
        (x)->lpVtbl->InvokeVerbEx( x, p1, p2 )
    #define FolderItems3_Filter( x, p1, p2 ) \
        (x)->lpVtbl->Filter( x, p1, p2 )
    #define FolderItems3_get_Verbs( x, p ) \
        (x)->lpVtbl->get_Verbs( x, p )
    #define FolderItemVerb_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define FolderItemVerb_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define FolderItemVerb_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define FolderItemVerb_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define FolderItemVerb_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define FolderItemVerb_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define FolderItemVerb_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define FolderItemVerb_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define FolderItemVerb_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define FolderItemVerb_get_Name( x, p ) \
        (x)->lpVtbl->get_Name( x, p )
    #define FolderItemVerb_DoIt( x ) \
        (x)->lpVtbl->DoIt( x )
    #define FolderItemVerbs_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define FolderItemVerbs_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define FolderItemVerbs_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define FolderItemVerbs_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define FolderItemVerbs_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define FolderItemVerbs_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define FolderItemVerbs_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define FolderItemVerbs_get_Count( x, p ) \
        (x)->lpVtbl->get_Count( x, p )
    #define FolderItemVerbs_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define FolderItemVerbs_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define FolderItemVerbs_Item( x, p1, p2 ) \
        (x)->lpVtbl->Item( x, p1, p2 )
    #define FolderItemVerbs__NewEnum( x, p ) \
        (x)->lpVtbl->_NewEnum( x, p )
    #define IShellLinkDual_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IShellLinkDual_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IShellLinkDual_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IShellLinkDual_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IShellLinkDual_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IShellLinkDual_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IShellLinkDual_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IShellLinkDual_get_Path( x, p ) \
        (x)->lpVtbl->get_Path( x, p )
    #define IShellLinkDual_put_Path( x, p ) \
        (x)->lpVtbl->put_Path( x, p )
    #define IShellLinkDual_get_Description( x, p ) \
        (x)->lpVtbl->get_Description( x, p )
    #define IShellLinkDual_put_Description( x, p ) \
        (x)->lpVtbl->put_Description( x, p )
    #define IShellLinkDual_get_WorkingDirectory( x, p ) \
        (x)->lpVtbl->get_WorkingDirectory( x, p )
    #define IShellLinkDual_put_WorkingDirectory( x, p ) \
        (x)->lpVtbl->put_WorkingDirectory( x, p )
    #define IShellLinkDual_get_Arguments( x, p ) \
        (x)->lpVtbl->get_Arguments( x, p )
    #define IShellLinkDual_put_Arguments( x, p ) \
        (x)->lpVtbl->put_Arguments( x, p )
    #define IShellLinkDual_get_Hotkey( x, p ) \
        (x)->lpVtbl->get_Hotkey( x, p )
    #define IShellLinkDual_put_Hotkey( x, p ) \
        (x)->lpVtbl->put_Hotkey( x, p )
    #define IShellLinkDual_get_ShowCommand( x, p ) \
        (x)->lpVtbl->get_ShowCommand( x, p )
    #define IShellLinkDual_put_ShowCommand( x, p ) \
        (x)->lpVtbl->put_ShowCommand( x, p )
    #define IShellLinkDual_Resolve( x, p ) \
        (x)->lpVtbl->Resolve( x, p )
    #define IShellLinkDual_GetIconLocation( x, p1, p2 ) \
        (x)->lpVtbl->GetIconLocation( x, p1, p2 )
    #define IShellLinkDual_SetIconLocation( x, p1, p2 ) \
        (x)->lpVtbl->SetIconLocation( x, p1, p2 )
    #define IShellLinkDual_Save( x, p ) \
        (x)->lpVtbl->Save( x, p )
    #define IShellLinkDual2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IShellLinkDual2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IShellLinkDual2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IShellLinkDual2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IShellLinkDual2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IShellLinkDual2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IShellLinkDual2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IShellLinkDual2_get_Path( x, p ) \
        (x)->lpVtbl->get_Path( x, p )
    #define IShellLinkDual2_put_Path( x, p ) \
        (x)->lpVtbl->put_Path( x, p )
    #define IShellLinkDual2_get_Description( x, p ) \
        (x)->lpVtbl->get_Description( x, p )
    #define IShellLinkDual2_put_Description( x, p ) \
        (x)->lpVtbl->put_Description( x, p )
    #define IShellLinkDual2_get_WorkingDirectory( x, p ) \
        (x)->lpVtbl->get_WorkingDirectory( x, p )
    #define IShellLinkDual2_put_WorkingDirectory( x, p ) \
        (x)->lpVtbl->put_WorkingDirectory( x, p )
    #define IShellLinkDual2_get_Arguments( x, p ) \
        (x)->lpVtbl->get_Arguments( x, p )
    #define IShellLinkDual2_put_Arguments( x, p ) \
        (x)->lpVtbl->put_Arguments( x, p )
    #define IShellLinkDual2_get_Hotkey( x, p ) \
        (x)->lpVtbl->get_Hotkey( x, p )
    #define IShellLinkDual2_put_Hotkey( x, p ) \
        (x)->lpVtbl->put_Hotkey( x, p )
    #define IShellLinkDual2_get_ShowCommand( x, p ) \
        (x)->lpVtbl->get_ShowCommand( x, p )
    #define IShellLinkDual2_put_ShowCommand( x, p ) \
        (x)->lpVtbl->put_ShowCommand( x, p )
    #define IShellLinkDual2_Resolve( x, p ) \
        (x)->lpVtbl->Resolve( x, p )
    #define IShellLinkDual2_GetIconLocation( x, p1, p2 ) \
        (x)->lpVtbl->GetIconLocation( x, p1, p2 )
    #define IShellLinkDual2_SetIconLocation( x, p1, p2 ) \
        (x)->lpVtbl->SetIconLocation( x, p1, p2 )
    #define IShellLinkDual2_Save( x, p ) \
        (x)->lpVtbl->Save( x, p )
    #define IShellLinkDual2_get_Target( x, p ) \
        (x)->lpVtbl->get_Target( x, p )
    #define IShellFolderViewDual_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IShellFolderViewDual_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IShellFolderViewDual_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IShellFolderViewDual_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IShellFolderViewDual_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IShellFolderViewDual_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IShellFolderViewDual_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IShellFolderViewDual_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define IShellFolderViewDual_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IShellFolderViewDual_get_Folder( x, p ) \
        (x)->lpVtbl->get_Folder( x, p )
    #define IShellFolderViewDual_SelectedItems( x, p ) \
        (x)->lpVtbl->SelectedItems( x, p )
    #define IShellFolderViewDual_get_FocusedItem( x, p ) \
        (x)->lpVtbl->get_FocusedItem( x, p )
    #define IShellFolderViewDual_SelectItem( x, p1, p2 ) \
        (x)->lpVtbl->SelectItem( x, p1, p2 )
    #define IShellFolderViewDual_PopupItemMenu( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->PopupItemMenu( x, p1, p2, p3, p4 )
    #define IShellFolderViewDual_get_Script( x, p ) \
        (x)->lpVtbl->get_Script( x, p )
    #define IShellFolderViewDual_get_ViewOptions( x, p ) \
        (x)->lpVtbl->get_ViewOptions( x, p )
    #define IShellFolderViewDual2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IShellFolderViewDual2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IShellFolderViewDual2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IShellFolderViewDual2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IShellFolderViewDual2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IShellFolderViewDual2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IShellFolderViewDual2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IShellFolderViewDual2_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define IShellFolderViewDual2_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IShellFolderViewDual2_get_Folder( x, p ) \
        (x)->lpVtbl->get_Folder( x, p )
    #define IShellFolderViewDual2_SelectedItems( x, p ) \
        (x)->lpVtbl->SelectedItems( x, p )
    #define IShellFolderViewDual2_get_FocusedItem( x, p ) \
        (x)->lpVtbl->get_FocusedItem( x, p )
    #define IShellFolderViewDual2_SelectItem( x, p1, p2 ) \
        (x)->lpVtbl->SelectItem( x, p1, p2 )
    #define IShellFolderViewDual2_PopupItemMenu( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->PopupItemMenu( x, p1, p2, p3, p4 )
    #define IShellFolderViewDual2_get_Script( x, p ) \
        (x)->lpVtbl->get_Script( x, p )
    #define IShellFolderViewDual2_get_ViewOptions( x, p ) \
        (x)->lpVtbl->get_ViewOptions( x, p )
    #define IShellFolderViewDual2_get_CurrentViewMode( x, p ) \
        (x)->lpVtbl->get_CurrentViewMode( x, p )
    #define IShellFolderViewDual2_put_CurrentViewMode( x, p ) \
        (x)->lpVtbl->put_CurrentViewMode( x, p )
    #define IShellFolderViewDual2_SelectItemRelative( x, p ) \
        (x)->lpVtbl->SelectItemRelative( x, p )
    #define IShellFolderViewDual3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IShellFolderViewDual3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IShellFolderViewDual3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IShellFolderViewDual3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IShellFolderViewDual3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IShellFolderViewDual3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IShellFolderViewDual3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IShellFolderViewDual3_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define IShellFolderViewDual3_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IShellFolderViewDual3_get_Folder( x, p ) \
        (x)->lpVtbl->get_Folder( x, p )
    #define IShellFolderViewDual3_SelectedItems( x, p ) \
        (x)->lpVtbl->SelectedItems( x, p )
    #define IShellFolderViewDual3_get_FocusedItem( x, p ) \
        (x)->lpVtbl->get_FocusedItem( x, p )
    #define IShellFolderViewDual3_SelectItem( x, p1, p2 ) \
        (x)->lpVtbl->SelectItem( x, p1, p2 )
    #define IShellFolderViewDual3_PopupItemMenu( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->PopupItemMenu( x, p1, p2, p3, p4 )
    #define IShellFolderViewDual3_get_Script( x, p ) \
        (x)->lpVtbl->get_Script( x, p )
    #define IShellFolderViewDual3_get_ViewOptions( x, p ) \
        (x)->lpVtbl->get_ViewOptions( x, p )
    #define IShellFolderViewDual3_get_CurrentViewMode( x, p ) \
        (x)->lpVtbl->get_CurrentViewMode( x, p )
    #define IShellFolderViewDual3_put_CurrentViewMode( x, p ) \
        (x)->lpVtbl->put_CurrentViewMode( x, p )
    #define IShellFolderViewDual3_SelectItemRelative( x, p ) \
        (x)->lpVtbl->SelectItemRelative( x, p )
    #define IShellFolderViewDual3_get_GroupBy( x, p ) \
        (x)->lpVtbl->get_GroupBy( x, p )
    #define IShellFolderViewDual3_put_GroupBy( x, p ) \
        (x)->lpVtbl->put_GroupBy( x, p )
    #define IShellFolderViewDual3_get_FolderFlags( x, p ) \
        (x)->lpVtbl->get_FolderFlags( x, p )
    #define IShellFolderViewDual3_put_FolderFlags( x, p ) \
        (x)->lpVtbl->put_FolderFlags( x, p )
    #define IShellFolderViewDual3_get_SortColumns( x, p ) \
        (x)->lpVtbl->get_SortColumns( x, p )
    #define IShellFolderViewDual3_put_SortColumns( x, p ) \
        (x)->lpVtbl->put_SortColumns( x, p )
    #define IShellFolderViewDual3_put_IconSize( x, p ) \
        (x)->lpVtbl->put_IconSize( x, p )
    #define IShellFolderViewDual3_get_IconSize( x, p ) \
        (x)->lpVtbl->get_IconSize( x, p )
    #define IShellFolderViewDual3_FilterView( x, p ) \
        (x)->lpVtbl->FilterView( x, p )
    #define IShellDispatch_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IShellDispatch_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IShellDispatch_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IShellDispatch_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IShellDispatch_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IShellDispatch_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IShellDispatch_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define IShellDispatch_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IShellDispatch_NameSpace( x, p1, p2 ) \
        (x)->lpVtbl->NameSpace( x, p1, p2 )
    #define IShellDispatch_BrowseForFolder( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->BrowseForFolder( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch_Windows( x, p ) \
        (x)->lpVtbl->Windows( x, p )
    #define IShellDispatch_Open( x, p ) \
        (x)->lpVtbl->Open( x, p )
    #define IShellDispatch_Explore( x, p ) \
        (x)->lpVtbl->Explore( x, p )
    #define IShellDispatch_MinimizeAll( x ) \
        (x)->lpVtbl->MinimizeAll( x )
    #define IShellDispatch_UndoMinimizeALL( x ) \
        (x)->lpVtbl->UndoMinimizeALL( x )
    #define IShellDispatch_FileRun( x ) \
        (x)->lpVtbl->FileRun( x )
    #define IShellDispatch_CascadeWindows( x ) \
        (x)->lpVtbl->CascadeWindows( x )
    #define IShellDispatch_TileVertically( x ) \
        (x)->lpVtbl->TileVertically( x )
    #define IShellDispatch_TileHorizontally( x ) \
        (x)->lpVtbl->TileHorizontally( x )
    #define IShellDispatch_ShutdownWindows( x ) \
        (x)->lpVtbl->ShutdownWindows( x )
    #define IShellDispatch_Suspend( x ) \
        (x)->lpVtbl->Suspend( x )
    #define IShellDispatch_EjectPC( x ) \
        (x)->lpVtbl->EjectPC( x )
    #define IShellDispatch_SetTime( x ) \
        (x)->lpVtbl->SetTime( x )
    #define IShellDispatch_TrayProperties( x ) \
        (x)->lpVtbl->TrayProperties( x )
    #define IShellDispatch_Help( x ) \
        (x)->lpVtbl->Help( x )
    #define IShellDispatch_FindFiles( x ) \
        (x)->lpVtbl->FindFiles( x )
    #define IShellDispatch_FindComputer( x ) \
        (x)->lpVtbl->FindComputer( x )
    #define IShellDispatch_RefreshMenu( x ) \
        (x)->lpVtbl->RefreshMenu( x )
    #define IShellDispatch_ControlPanelItem( x, p ) \
        (x)->lpVtbl->ControlPanelItem( x, p )
    #define IShellDispatch2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IShellDispatch2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IShellDispatch2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IShellDispatch2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IShellDispatch2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IShellDispatch2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IShellDispatch2_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define IShellDispatch2_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IShellDispatch2_NameSpace( x, p1, p2 ) \
        (x)->lpVtbl->NameSpace( x, p1, p2 )
    #define IShellDispatch2_BrowseForFolder( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->BrowseForFolder( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch2_Windows( x, p ) \
        (x)->lpVtbl->Windows( x, p )
    #define IShellDispatch2_Open( x, p ) \
        (x)->lpVtbl->Open( x, p )
    #define IShellDispatch2_Explore( x, p ) \
        (x)->lpVtbl->Explore( x, p )
    #define IShellDispatch2_MinimizeAll( x ) \
        (x)->lpVtbl->MinimizeAll( x )
    #define IShellDispatch2_UndoMinimizeALL( x ) \
        (x)->lpVtbl->UndoMinimizeALL( x )
    #define IShellDispatch2_FileRun( x ) \
        (x)->lpVtbl->FileRun( x )
    #define IShellDispatch2_CascadeWindows( x ) \
        (x)->lpVtbl->CascadeWindows( x )
    #define IShellDispatch2_TileVertically( x ) \
        (x)->lpVtbl->TileVertically( x )
    #define IShellDispatch2_TileHorizontally( x ) \
        (x)->lpVtbl->TileHorizontally( x )
    #define IShellDispatch2_ShutdownWindows( x ) \
        (x)->lpVtbl->ShutdownWindows( x )
    #define IShellDispatch2_Suspend( x ) \
        (x)->lpVtbl->Suspend( x )
    #define IShellDispatch2_EjectPC( x ) \
        (x)->lpVtbl->EjectPC( x )
    #define IShellDispatch2_SetTime( x ) \
        (x)->lpVtbl->SetTime( x )
    #define IShellDispatch2_TrayProperties( x ) \
        (x)->lpVtbl->TrayProperties( x )
    #define IShellDispatch2_Help( x ) \
        (x)->lpVtbl->Help( x )
    #define IShellDispatch2_FindFiles( x ) \
        (x)->lpVtbl->FindFiles( x )
    #define IShellDispatch2_FindComputer( x ) \
        (x)->lpVtbl->FindComputer( x )
    #define IShellDispatch2_RefreshMenu( x ) \
        (x)->lpVtbl->RefreshMenu( x )
    #define IShellDispatch2_ControlPanelItem( x, p ) \
        (x)->lpVtbl->ControlPanelItem( x, p )
    #define IShellDispatch2_IsRestricted( x, p1, p2, p3 ) \
        (x)->lpVtbl->IsRestricted( x, p1, p2, p3 )
    #define IShellDispatch2_ShellExecute( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->ShellExecute( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch2_FindPrinter( x, p1, p2, p3 ) \
        (x)->lpVtbl->FindPrinter( x, p1, p2, p3 )
    #define IShellDispatch2_GetSystemInformation( x, p1, p2 ) \
        (x)->lpVtbl->GetSystemInformation( x, p1, p2 )
    #define IShellDispatch2_ServiceStart( x, p1, p2, p3 ) \
        (x)->lpVtbl->ServiceStart( x, p1, p2, p3 )
    #define IShellDispatch2_IsServiceRunning( x, p1, p2 ) \
        (x)->lpVtbl->IsServiceRunning( x, p1, p2 )
    #define IShellDispatch2_CanStartStopService( x, p1, p2 ) \
        (x)->lpVtbl->CanStartStopService( x, p1, p2 )
    #define IShellDispatch2_ShowBrowserBar( x, p1, p2, p3 ) \
        (x)->lpVtbl->ShowBrowserBar( x, p1, p2, p3 )
    #define IShellDispatch3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IShellDispatch3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IShellDispatch3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IShellDispatch3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IShellDispatch3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IShellDispatch3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IShellDispatch3_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define IShellDispatch3_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IShellDispatch3_NameSpace( x, p1, p2 ) \
        (x)->lpVtbl->NameSpace( x, p1, p2 )
    #define IShellDispatch3_BrowseForFolder( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->BrowseForFolder( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch3_Windows( x, p ) \
        (x)->lpVtbl->Windows( x, p )
    #define IShellDispatch3_Open( x, p ) \
        (x)->lpVtbl->Open( x, p )
    #define IShellDispatch3_Explore( x, p ) \
        (x)->lpVtbl->Explore( x, p )
    #define IShellDispatch3_MinimizeAll( x ) \
        (x)->lpVtbl->MinimizeAll( x )
    #define IShellDispatch3_UndoMinimizeALL( x ) \
        (x)->lpVtbl->UndoMinimizeALL( x )
    #define IShellDispatch3_FileRun( x ) \
        (x)->lpVtbl->FileRun( x )
    #define IShellDispatch3_CascadeWindows( x ) \
        (x)->lpVtbl->CascadeWindows( x )
    #define IShellDispatch3_TileVertically( x ) \
        (x)->lpVtbl->TileVertically( x )
    #define IShellDispatch3_TileHorizontally( x ) \
        (x)->lpVtbl->TileHorizontally( x )
    #define IShellDispatch3_ShutdownWindows( x ) \
        (x)->lpVtbl->ShutdownWindows( x )
    #define IShellDispatch3_Suspend( x ) \
        (x)->lpVtbl->Suspend( x )
    #define IShellDispatch3_EjectPC( x ) \
        (x)->lpVtbl->EjectPC( x )
    #define IShellDispatch3_SetTime( x ) \
        (x)->lpVtbl->SetTime( x )
    #define IShellDispatch3_TrayProperties( x ) \
        (x)->lpVtbl->TrayProperties( x )
    #define IShellDispatch3_Help( x ) \
        (x)->lpVtbl->Help( x )
    #define IShellDispatch3_FindFiles( x ) \
        (x)->lpVtbl->FindFiles( x )
    #define IShellDispatch3_FindComputer( x ) \
        (x)->lpVtbl->FindComputer( x )
    #define IShellDispatch3_RefreshMenu( x ) \
        (x)->lpVtbl->RefreshMenu( x )
    #define IShellDispatch3_ControlPanelItem( x, p ) \
        (x)->lpVtbl->ControlPanelItem( x, p )
    #define IShellDispatch3_IsRestricted( x, p1, p2, p3 ) \
        (x)->lpVtbl->IsRestricted( x, p1, p2, p3 )
    #define IShellDispatch3_ShellExecute( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->ShellExecute( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch3_FindPrinter( x, p1, p2, p3 ) \
        (x)->lpVtbl->FindPrinter( x, p1, p2, p3 )
    #define IShellDispatch3_GetSystemInformation( x, p1, p2 ) \
        (x)->lpVtbl->GetSystemInformation( x, p1, p2 )
    #define IShellDispatch3_ServiceStart( x, p1, p2, p3 ) \
        (x)->lpVtbl->ServiceStart( x, p1, p2, p3 )
    #define IShellDispatch3_IsServiceRunning( x, p1, p2 ) \
        (x)->lpVtbl->IsServiceRunning( x, p1, p2 )
    #define IShellDispatch3_CanStartStopService( x, p1, p2 ) \
        (x)->lpVtbl->CanStartStopService( x, p1, p2 )
    #define IShellDispatch3_ShowBrowserBar( x, p1, p2, p3 ) \
        (x)->lpVtbl->ShowBrowserBar( x, p1, p2, p3 )
    #define IShellDispatch3_AddToRecent( x, p1, p2 ) \
        (x)->lpVtbl->AddToRecent( x, p1, p2 )
    #define IShellDispatch4_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IShellDispatch4_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IShellDispatch4_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IShellDispatch4_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IShellDispatch4_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IShellDispatch4_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch4_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IShellDispatch4_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define IShellDispatch4_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IShellDispatch4_NameSpace( x, p1, p2 ) \
        (x)->lpVtbl->NameSpace( x, p1, p2 )
    #define IShellDispatch4_BrowseForFolder( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->BrowseForFolder( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch4_Windows( x, p ) \
        (x)->lpVtbl->Windows( x, p )
    #define IShellDispatch4_Open( x, p ) \
        (x)->lpVtbl->Open( x, p )
    #define IShellDispatch4_Explore( x, p ) \
        (x)->lpVtbl->Explore( x, p )
    #define IShellDispatch4_MinimizeAll( x ) \
        (x)->lpVtbl->MinimizeAll( x )
    #define IShellDispatch4_UndoMinimizeALL( x ) \
        (x)->lpVtbl->UndoMinimizeALL( x )
    #define IShellDispatch4_FileRun( x ) \
        (x)->lpVtbl->FileRun( x )
    #define IShellDispatch4_CascadeWindows( x ) \
        (x)->lpVtbl->CascadeWindows( x )
    #define IShellDispatch4_TileVertically( x ) \
        (x)->lpVtbl->TileVertically( x )
    #define IShellDispatch4_TileHorizontally( x ) \
        (x)->lpVtbl->TileHorizontally( x )
    #define IShellDispatch4_ShutdownWindows( x ) \
        (x)->lpVtbl->ShutdownWindows( x )
    #define IShellDispatch4_Suspend( x ) \
        (x)->lpVtbl->Suspend( x )
    #define IShellDispatch4_EjectPC( x ) \
        (x)->lpVtbl->EjectPC( x )
    #define IShellDispatch4_SetTime( x ) \
        (x)->lpVtbl->SetTime( x )
    #define IShellDispatch4_TrayProperties( x ) \
        (x)->lpVtbl->TrayProperties( x )
    #define IShellDispatch4_Help( x ) \
        (x)->lpVtbl->Help( x )
    #define IShellDispatch4_FindFiles( x ) \
        (x)->lpVtbl->FindFiles( x )
    #define IShellDispatch4_FindComputer( x ) \
        (x)->lpVtbl->FindComputer( x )
    #define IShellDispatch4_RefreshMenu( x ) \
        (x)->lpVtbl->RefreshMenu( x )
    #define IShellDispatch4_ControlPanelItem( x, p ) \
        (x)->lpVtbl->ControlPanelItem( x, p )
    #define IShellDispatch4_IsRestricted( x, p1, p2, p3 ) \
        (x)->lpVtbl->IsRestricted( x, p1, p2, p3 )
    #define IShellDispatch4_ShellExecute( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->ShellExecute( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch4_FindPrinter( x, p1, p2, p3 ) \
        (x)->lpVtbl->FindPrinter( x, p1, p2, p3 )
    #define IShellDispatch4_GetSystemInformation( x, p1, p2 ) \
        (x)->lpVtbl->GetSystemInformation( x, p1, p2 )
    #define IShellDispatch4_ServiceStart( x, p1, p2, p3 ) \
        (x)->lpVtbl->ServiceStart( x, p1, p2, p3 )
    #define IShellDispatch4_IsServiceRunning( x, p1, p2 ) \
        (x)->lpVtbl->IsServiceRunning( x, p1, p2 )
    #define IShellDispatch4_CanStartStopService( x, p1, p2 ) \
        (x)->lpVtbl->CanStartStopService( x, p1, p2 )
    #define IShellDispatch4_ShowBrowserBar( x, p1, p2, p3 ) \
        (x)->lpVtbl->ShowBrowserBar( x, p1, p2, p3 )
    #define IShellDispatch4_AddToRecent( x, p1, p2 ) \
        (x)->lpVtbl->AddToRecent( x, p1, p2 )
    #define IShellDispatch4_WindowsSecurity( x ) \
        (x)->lpVtbl->WindowsSecurity( x )
    #define IShellDispatch4_ToggleDesktop( x ) \
        (x)->lpVtbl->ToggleDesktop( x )
    #define IShellDispatch4_ExplorerPolicy( x, p1, p2 ) \
        (x)->lpVtbl->ExplorerPolicy( x, p1, p2 )
    #define IShellDispatch4_GetSetting( x, p1, p2 ) \
        (x)->lpVtbl->GetSetting( x, p1, p2 )
    #define IShellDispatch5_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IShellDispatch5_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IShellDispatch5_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IShellDispatch5_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IShellDispatch5_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IShellDispatch5_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch5_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IShellDispatch5_get_Application( x, p ) \
        (x)->lpVtbl->get_Application( x, p )
    #define IShellDispatch5_get_Parent( x, p ) \
        (x)->lpVtbl->get_Parent( x, p )
    #define IShellDispatch5_NameSpace( x, p1, p2 ) \
        (x)->lpVtbl->NameSpace( x, p1, p2 )
    #define IShellDispatch5_BrowseForFolder( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->BrowseForFolder( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch5_Windows( x, p ) \
        (x)->lpVtbl->Windows( x, p )
    #define IShellDispatch5_Open( x, p ) \
        (x)->lpVtbl->Open( x, p )
    #define IShellDispatch5_Explore( x, p ) \
        (x)->lpVtbl->Explore( x, p )
    #define IShellDispatch5_MinimizeAll( x ) \
        (x)->lpVtbl->MinimizeAll( x )
    #define IShellDispatch5_UndoMinimizeALL( x ) \
        (x)->lpVtbl->UndoMinimizeALL( x )
    #define IShellDispatch5_FileRun( x ) \
        (x)->lpVtbl->FileRun( x )
    #define IShellDispatch5_CascadeWindows( x ) \
        (x)->lpVtbl->CascadeWindows( x )
    #define IShellDispatch5_TileVertically( x ) \
        (x)->lpVtbl->TileVertically( x )
    #define IShellDispatch5_TileHorizontally( x ) \
        (x)->lpVtbl->TileHorizontally( x )
    #define IShellDispatch5_ShutdownWindows( x ) \
        (x)->lpVtbl->ShutdownWindows( x )
    #define IShellDispatch5_Suspend( x ) \
        (x)->lpVtbl->Suspend( x )
    #define IShellDispatch5_EjectPC( x ) \
        (x)->lpVtbl->EjectPC( x )
    #define IShellDispatch5_SetTime( x ) \
        (x)->lpVtbl->SetTime( x )
    #define IShellDispatch5_TrayProperties( x ) \
        (x)->lpVtbl->TrayProperties( x )
    #define IShellDispatch5_Help( x ) \
        (x)->lpVtbl->Help( x )
    #define IShellDispatch5_FindFiles( x ) \
        (x)->lpVtbl->FindFiles( x )
    #define IShellDispatch5_FindComputer( x ) \
        (x)->lpVtbl->FindComputer( x )
    #define IShellDispatch5_RefreshMenu( x ) \
        (x)->lpVtbl->RefreshMenu( x )
    #define IShellDispatch5_ControlPanelItem( x, p ) \
        (x)->lpVtbl->ControlPanelItem( x, p )
    #define IShellDispatch5_IsRestricted( x, p1, p2, p3 ) \
        (x)->lpVtbl->IsRestricted( x, p1, p2, p3 )
    #define IShellDispatch5_ShellExecute( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->ShellExecute( x, p1, p2, p3, p4, p5 )
    #define IShellDispatch5_FindPrinter( x, p1, p2, p3 ) \
        (x)->lpVtbl->FindPrinter( x, p1, p2, p3 )
    #define IShellDispatch5_GetSystemInformation( x, p1, p2 ) \
        (x)->lpVtbl->GetSystemInformation( x, p1, p2 )
    #define IShellDispatch5_ServiceStart( x, p1, p2, p3 ) \
        (x)->lpVtbl->ServiceStart( x, p1, p2, p3 )
    #define IShellDispatch5_IsServiceRunning( x, p1, p2 ) \
        (x)->lpVtbl->IsServiceRunning( x, p1, p2 )
    #define IShellDispatch5_CanStartStopService( x, p1, p2 ) \
        (x)->lpVtbl->CanStartStopService( x, p1, p2 )
    #define IShellDispatch5_ShowBrowserBar( x, p1, p2, p3 ) \
        (x)->lpVtbl->ShowBrowserBar( x, p1, p2, p3 )
    #define IShellDispatch5_AddToRecent( x, p1, p2 ) \
        (x)->lpVtbl->AddToRecent( x, p1, p2 )
    #define IShellDispatch5_WindowsSecurity( x ) \
        (x)->lpVtbl->WindowsSecurity( x )
    #define IShellDispatch5_ToggleDesktop( x ) \
        (x)->lpVtbl->ToggleDesktop( x )
    #define IShellDispatch5_ExplorerPolicy( x, p1, p2 ) \
        (x)->lpVtbl->ExplorerPolicy( x, p1, p2 )
    #define IShellDispatch5_GetSetting( x, p1, p2 ) \
        (x)->lpVtbl->GetSetting( x, p1, p2 )
    #define IShellDispatch5_WindowSwitcher( x ) \
        (x)->lpVtbl->WindowSwitcher( x )
    #define IFileSearchBand_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFileSearchBand_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFileSearchBand_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFileSearchBand_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IFileSearchBand_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IFileSearchBand_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IFileSearchBand_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IFileSearchBand_SetFocus( x ) \
        (x)->lpVtbl->SetFocus( x )
    #define IFileSearchBand_SetSearchParameters( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->SetSearchParameters( x, p1, p2, p3, p4 )
    #define IFileSearchBand_get_SearchID( x, p ) \
        (x)->lpVtbl->get_SearchID( x, p )
    #define IFileSearchBand_get_Scope( x, p ) \
        (x)->lpVtbl->get_Scope( x, p )
    #define IFileSearchBand_get_QueryFile( x, p ) \
        (x)->lpVtbl->get_QueryFile( x, p )
    #define IWebWizardHost_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IWebWizardHost_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IWebWizardHost_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IWebWizardHost_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IWebWizardHost_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IWebWizardHost_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IWebWizardHost_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IWebWizardHost_FinalBack( x ) \
        (x)->lpVtbl->FinalBack( x )
    #define IWebWizardHost_FinalNext( x ) \
        (x)->lpVtbl->FinalNext( x )
    #define IWebWizardHost_Cancel( x ) \
        (x)->lpVtbl->Cancel( x )
    #define IWebWizardHost_put_Caption( x, p ) \
        (x)->lpVtbl->put_Caption( x, p )
    #define IWebWizardHost_get_Caption( x, p ) \
        (x)->lpVtbl->get_Caption( x, p )
    #define IWebWizardHost_put_Property( x, p ) \
        (x)->lpVtbl->put_Property( x, p )
    #define IWebWizardHost_get_Property( x, p ) \
        (x)->lpVtbl->get_Property( x, p )
    #define IWebWizardHost_SetWizardButtons( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetWizardButtons( x, p1, p2, p3 )
    #define IWebWizardHost_SetHeaderText( x, p1, p2 ) \
        (x)->lpVtbl->SetHeaderText( x, p1, p2 )
    #define INewWDEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define INewWDEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define INewWDEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define INewWDEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define INewWDEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define INewWDEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define INewWDEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define INewWDEvents_FinalBack( x ) \
        (x)->lpVtbl->FinalBack( x )
    #define INewWDEvents_FinalNext( x ) \
        (x)->lpVtbl->FinalNext( x )
    #define INewWDEvents_Cancel( x ) \
        (x)->lpVtbl->Cancel( x )
    #define INewWDEvents_put_Caption( x, p ) \
        (x)->lpVtbl->put_Caption( x, p )
    #define INewWDEvents_get_Caption( x, p ) \
        (x)->lpVtbl->get_Caption( x, p )
    #define INewWDEvents_put_Property( x, p ) \
        (x)->lpVtbl->put_Property( x, p )
    #define INewWDEvents_get_Property( x, p ) \
        (x)->lpVtbl->get_Property( x, p )
    #define INewWDEvents_SetWizardButtons( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetWizardButtons( x, p1, p2, p3 )
    #define INewWDEvents_SetHeaderText( x, p1, p2 ) \
        (x)->lpVtbl->SetHeaderText( x, p1, p2 )
    #define INewWDEvents_PassportAuthenticate( x, p1, p2 ) \
        (x)->lpVtbl->PassportAuthenticate( x, p1, p2 )
    #define IAutoComplete_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAutoComplete_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAutoComplete_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAutoComplete_Init( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Init( x, p1, p2, p3, p4 )
    #define IAutoComplete_Enable( x, p ) \
        (x)->lpVtbl->Enable( x, p )
    #define IAutoComplete2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAutoComplete2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAutoComplete2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAutoComplete2_Init( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Init( x, p1, p2, p3, p4 )
    #define IAutoComplete2_Enable( x, p ) \
        (x)->lpVtbl->Enable( x, p )
    #define IAutoComplete2_SetOptions( x, p ) \
        (x)->lpVtbl->SetOptions( x, p )
    #define IAutoComplete2_GetOptions( x, p ) \
        (x)->lpVtbl->GetOptions( x, p )
    #define IEnumACString_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumACString_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumACString_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumACString_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumACString_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumACString_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumACString_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IEnumACString_NextItem( x, p1, p2, p3 ) \
        (x)->lpVtbl->NextItem( x, p1, p2, p3 )
    #define IEnumACString_SetEnumOptions( x, p ) \
        (x)->lpVtbl->SetEnumOptions( x, p )
    #define IEnumACString_GetEnumOptions( x, p ) \
        (x)->lpVtbl->GetEnumOptions( x, p )
    #define IAsyncOperation_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAsyncOperation_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAsyncOperation_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAsyncOperation_SetAsyncMode( x, p ) \
        (x)->lpVtbl->SetAsyncMode( x, p )
    #define IAsyncOperation_GetAsyncMode( x, p ) \
        (x)->lpVtbl->GetAsyncMode( x, p )
    #define IAsyncOperation_StartOperation( x, p ) \
        (x)->lpVtbl->StartOperation( x, p )
    #define IAsyncOperation_InOperation( x, p ) \
        (x)->lpVtbl->InOperation( x, p )
    #define IAsyncOperation_EndOperation( x, p1, p2, p3 ) \
        (x)->lpVtbl->EndOperation( x, p1, p2, p3 )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __shldisp_h__ */
