/*
 *  miniport.h  Miniport definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _MINIPORT_
#define _MINIPORT_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

/* The Microsoft version of miniport.h is mostly a lot of the same stuff that's in
 * ntddk.h and wdm.h.  To save space, include ntddk.h and just define those constants
 * and structures that are unique to this header.
 */
#include <ntddk.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Emulator access modes */
#define EMULATOR_READ_ACCESS    0x01
#define EMULATOR_WRITE_ACCESS   0x02

/* Emulator port access types */
typedef enum _EMULATOR_PORT_ACCESS_TYPE {
    Uchar   = 0,
    Ushort  = 1,
    Ulong   = 2
} EMULATOR_PORT_ACCESS_TYPE;
typedef EMULATOR_PORT_ACCESS_TYPE   *PEMULATOR_PORT_ACCESS_TYPE;

/* Emulator access entry */
typedef struct _EMULATOR_ACCESS_ENTRY {
    ULONG                       BasePort;
    ULONG                       NumConsecutivePorts;
    EMULATOR_PORT_ACCESS_TYPE   AccessType;
    UCHAR                       AccessMode;
    UCHAR                       StringSupport;
    PVOID                       Routine;
} EMULATOR_ACCESS_ENTRY;
typedef EMULATOR_ACCESS_ENTRY   *PEMULATOR_ACCESS_ENTRY;

/* Banked section routine */
typedef VOID (NTAPI *PBANKED_SECTION_ROUTINE)( ULONG, ULONG, PVOID );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _MINIPORT */
