/*
 *  icm.h       Image Color Management (ICM) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _ICM_H_
#define _ICM_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Primitive data types */
typedef char        COLOR_NAME[32];
typedef COLOR_NAME  *PCOLOR_NAME;
typedef COLOR_NAME  *LPCOLOR_NAME;
typedef HANDLE      HPROFILE;
typedef HPROFILE    *PHPROFILE;
typedef HANDLE      HTRANSFORM;
typedef DWORD       TAGTYPE;
typedef TAGTYPE     *PTAGTYPE;
typedef TAGTYPE     *LPTAGTYPE;
typedef HANDLE      HCMTRANSFORM;
typedef PVOID       LPDEVCHARACTER;

/* Maximum number of color channels */
#define MAX_COLOR_CHANNELS  8

/* Rendering intents */
#define INTENT_PERCEPTUAL               0
#define INTENT_RELATIVE_COLORIMETRIC    1
#define INTENT_SATURATION               2
#define INTENT_ABSOLUTE_COLORIMETRIC    3

/* Profile class values */
#define CLASS_MONITOR       'mntr'
#define CLASS_PRINTER       'prtr'
#define CLASS_SCANNER       'scnr'
#define CLASS_LINK          'link'
#define CLASS_ABSTRACT      'abst'
#define CLASS_COLORSPACE    'spac'
#define CLASS_NAMED         'nmcl'
#if (NTDDI_VERSION >= 0x06000000)
    #define CLASS_CAMP      'camp'
    #define CLASS_GMMP      'gmmp'
#endif

/* Color space values */
#define SPACE_XYZ       'XYZ '
#define SPACE_Lab       'Lab '
#define SPACE_Luv       'Luv '
#define SPACE_YCbCr     'YCbr'
#define SPACE_Yxy       'Yxy '
#define SPACE_RGB       'RGB '
#define SPACE_GRAY      'GRAY'
#define SPACE_HSV       'HSV '
#define SPACE_HLS       'HLS '
#define SPACE_CMYK      'CMYK'
#define SPACE_CMY       'CMY '
#define SPACE_2_CHANNEL '2CLR'
#define SPACE_3_CHANNEL '3CLR'
#define SPACE_4_CHANNEL '4CLR'
#define SPACE_5_CHANNEL '5CLR'
#define SPACE_6_CHANNEL '6CLR'
#define SPACE_7_CHANNEL '7CLR'
#define SPACE_8_CHANNEL '8CLR'

/* Profile flags */
#define FLAG_EMBEDDEDPROFILE                    0x00000001L
#define FLAG_DEPENDENTONDATA                    0x00000002L
#if (NTDDI_VERSION >= 0x06000000)
    #define FLAG_ENABLE_CHROMATIC_ADAPTATION    0x02000000L
#endif

/* Profile attribute flags */
#define ATTRIB_TRANSPARENCY 0x00000001L
#define ATTRIB_MATTE        0x00000002L

/* Profile types */
#define PROFILE_FILENAME    1L
#define PROFILE_MEMBUFFER   2L

/* Profile access modes */
#define PROFILE_READ        1L
#define PROFILE_READWRITE   2L

/* CMM special values */
#define INDEX_DONT_CARE     0
#define CMM_FROM_PROFILE    INDEX_DONT_CARE
#define CMM_WINDOWS_DEFAULT 'Win '

/* Enumeration type version number */
#define ENUM_TYPE_VERSION   0x0300

/* Enumeration type fields */
#define ET_DEVICENAME       0x00000001L
#define ET_MEDIATYPE        0x00000002L
#define ET_DITHERMODE       0x00000004L
#define ET_RESOLUTION       0x00000008L
#define ET_CMMTYPE          0x00000010L
#define ET_CLASS            0x00000020L
#define ET_DATACOLORSPACE   0x00000040L
#define ET_CONNECTIONSPACE  0x00000080L
#define ET_SIGNATURE        0x00000100L
#define ET_PLATFORM         0x00000200L
#define ET_PROFILEFLAGS     0x00000400L
#define ET_MANUFACTURER     0x00000800L
#define ET_MODEL            0x00001000L
#define ET_ATTRIBUTES       0x00002000L
#define ET_RENDERINGINTENT  0x00004000L
#define ET_CREATOR          0x00008000L
#define ET_DEVICECLASS      0x00010000L

/* Color transform modes */
#define PROOF_MODE                  0x00000001L
#define NORMAL_MODE                 0x00000002L
#define BEST_MODE                   0x00000003L
#define ENABLE_GAMUT_CHECKING       0x00010000L
#define USE_RELATIVE_COLORIMETRIC   0x00020000L
#define FAST_TRANSLATE              0x00040000L
#if (NTDDI_VERSION >= 0x06000000)
    #define PRESERVEBLACK           0x00100000L
    #define WCS_ALWAYS              0x00200000L
    #define SEQUENTIAL_TRANSFORM    0x80800000L
#endif

/* GetPS2ColorSpaceArray() constants */
#define CSA_A       1
#define CSA_ABC     2
#define CSA_DEF     3
#define CSA_DEFG    4
#define CSA_GRAY    5
#define CSA_RGB     6
#define CSA_CMYK    7
#define CSA_Lab     8

/* CMGetInfo() constants */
#define CMM_WIN_VERSION     0
#define CMM_IDENT           1
#define CMM_DRIVER_VERSION  2
#define CMM_DLL_VERSION     3
#define CMM_VERSION         4
#define CMM_DESCRIPTION     5
#define CMM_LOGOICON        6

/* CMTranslateRGBs() constants */
#define CMS_FORWARD     0
#define CMS_BACKWARD    1

/* SetupColorMatching() constants */
#define COLOR_MATCH_VERSION 0x0200

/* Color matching flags */
#define CMS_DISABLEICM          0x00000001L
#define CMS_ENABLEPROOFING      0x00000002L
#define CMS_SETRENDERINTENT     0x00000004L
#define CMS_SETPROOFINTENT      0x00000008L
#define CMS_SETMONITORPROFILE   0x00000010L
#define CMS_SETPRINTERPROFILE   0x00000020L
#define CMS_SETTARGETPROFILE    0x00000040L
#define CMS_USEHOOK             0x00000080L
#define CMS_USEAPPLYCALLBACK    0x00000100L
#define CMS_USEDESCRIPTION      0x00000200L
#define CMS_DISABLEINTENT       0x00000400L
#define CMS_DISABLERENDERINTENT 0x00000800L
#define CMS_MONITOROVERFLOW     0x80000000L
#define CMS_PRINTEROVERFLOW     0x40000000L
#define CMS_TARGETOVERFLOW      0x20000000L

/* WcsOpenColorProfile() flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define DONT_USE_EMBEDDED_WCS_PROFILES  0x00000001L
#endif

/* WcsCreateIccProfile() flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define WCS_DEFAULT 0x00000000L
    #define WCS_ICCONLY 0x00010000L
#endif

/* ICC tag types */
#if (NTDDI_VERSION >= 0x06000000)
    #define WCS_EMBEDDED_TAG_SIGNATURE      'MS00'
    #define WCS_EMBEDDED_TAG_TYPE_SIGNATURE 'MS10'
#endif

/* Named profile information */
typedef struct tagNAMED_PROFILE_INFO {
    DWORD       dwFlags;
    DWORD       dwCount;
    DWORD       dwCountDevCoordinates;
    COLOR_NAME  szPrefix;
    COLOR_NAME  szSuffix;
} NAMED_PROFILE_INFO;
typedef NAMED_PROFILE_INFO  *PNAMED_PROFILE_INFO;
typedef NAMED_PROFILE_INFO  *LPNAMED_PROFILE_INFO;

/* Gray color */
struct GRAYCOLOR {
    WORD    gray;
};

/* RGB color */
struct RGBCOLOR {
    WORD    red;
    WORD    green;
    WORD    blue;
} RGBCOLOR;

/* CMYK color */
struct CMYKCOLOR {
    WORD    cyan;
    WORD    magenta;
    WORD    yellow;
    WORD    black;
};

/* XYZ color */
struct XYZCOLOR {
    WORD    X;
    WORD    Y;
    WORD    Z;
};

/* Yxy color */
struct YxyCOLOR {
    WORD    Y;
    WORD    x;
    WORD    y;
};

/* Lab color */
struct LabCOLOR {
    WORD    L;
    WORD    a;
    WORD    b;
};

/* Generic 3-channel color */
struct GENERIC3CHANNEL {
    WORD    ch1;
    WORD    ch2;
    WORD    ch3;
};

/* Named color */
struct NAMEDCOLOR {
    DWORD   dwIndex;
};

/* HiFi color */
struct HiFiCOLOR {
    BYTE    channel[MAX_COLOR_CHANNELS];
};

/* Color */
typedef union tagCOLOR {
    struct GRAYCOLOR        gray;
    struct RGBCOLOR         rgb;
    struct CMYKCOLOR        cmyk;
    struct XYZCOLOR         XYZ;
    struct YxyCOLOR         Yxy;
    struct LabCOLOR         Lab;
    struct GENERIC3CHANNEL  gen3ch;
    struct NAMEDCOLOR       named;
    struct HiFiCOLOR        hifi;
    struct {
        DWORD   reserved1;
        VOID    *reserved2;
    };
} COLOR;
typedef COLOR   *PCOLOR;
typedef COLOR   *LPCOLOR;

/* Color types */
typedef enum {
    COLOR_GRAY      = 1,
    COLOR_RGB       = 2,
    COLOR_XYZ       = 3,
    COLOR_Yxy       = 4,
    COLOR_Lab       = 5,
    COLOR_3_CHANNEL = 6,
    COLOR_CMYK      = 7,
    COLOR_5_CHANNEL = 8,
    COLOR_6_CHANNEL = 9,
    COLOR_7_CHANNEL = 10,
    COLOR_8_CHANNEL = 11,
    COLOR_NAMED     = 12
} COLORTYPE;
typedef COLORTYPE   *PCOLORTYPE;
typedef COLORTYPE   *LPCOLORTYPE;

/* Color profile types */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum {
    CPT_ICC     = 0,
    CPT_DMP     = 1,
    CPT_CAMP    = 2,
    CPT_GMMP    = 3
} COLORPROFILETYPE;
typedef COLORPROFILETYPE    *PCOLORPROFILETYPE;
typedef COLORPROFILETYPE    *LPCOLORPROFILETYPE;
#endif

/* Color profile subtypes */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum {
    CPST_PERCEPTUAL             = INTENT_PERCEPTUAL,
    CPST_RELATIVE_COLORIMETRIC  = INTENT_RELATIVE_COLORIMETRIC,
    CPST_SATURATION             = INTENT_SATURATION,
    CPST_ABSOLUTE_COLORIMETRIC  = INTENT_ABSOLUTE_COLORIMETRIC,
    CPST_NONE                   = 4,
    CPST_RGB_WORKING_SPACE      = 5,
    CPST_CUSTOM_WORKING_SPACE   = 6
} COLORPROFILESUBTYPE;
typedef COLORPROFILESUBTYPE *PCOLORPROFILESUBTYPE;
typedef COLORPROFILESUBTYPE *LPCOLORPROFILESUBTYPE;
#endif

/* Color data types */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum {
    COLOR_BYTE                  = 1,
    COLOR_WORD                  = 2,
    COLOR_FLOAT                 = 3,
    COLOR_S2DOT13FIXED          = 4,
    COLOR_10b_R10G10B10A2       = 5,
    COLOR_10b_R10G10B10A2_XR    = 6,
    COLOR_FLOAT16               = 7
} COLORDATATYPE;
typedef COLORDATATYPE   *PCOLORDATATYPE;
typedef COLORDATATYPE   *LPCOLORDATATYPE;
#endif

/* Bitmap formats */
typedef enum {
    BM_x555RGB              = 0x0000,
    BM_x555XYZ              = 0x0101,
    BM_x555Yxy              = 0x0102,
    BM_x555Lab              = 0x0103,
    BM_x555G3CH             = 0x0104,
    BM_RGBTRIPLETS          = 0x0002,
    BM_BGRTRIPLETS          = 0x0004,
    BM_XYZTRIPLETS          = 0x0201,
    BM_YxyTRIPLETS          = 0x0202,
    BM_LabTRIPLETS          = 0x0203,
    BM_G3CHTRIPLETS         = 0x0204,
    BM_5CHANNEL             = 0x0205,
    BM_6CHANNEL             = 0x0206,
    BM_7CHANNEL             = 0x0207,
    BM_8CHANNEL             = 0x0208,
    BM_GRAY                 = 0x0209,
    BM_xRGBQUADS            = 0x0008,
    BM_xBGRQUADS            = 0x0010,
    BM_xG3CHQUADS           = 0x0304,
    BM_KYMCQUADS            = 0x0305,
    BM_CMYKQUADS            = 0x0020,
    BM_10b_RGB              = 0x0009,
    BM_10b_XYZ              = 0x0401,
    BM_10b_Yxy              = 0x0402,
    BM_10b_Lab              = 0x0403,
    BM_10b_G3CH             = 0x0404,
    BM_NAMED_INDEX          = 0x0405,
    BM_16b_RGB              = 0x000A,
    BM_16b_XYZ              = 0x0501,
    BM_16b_Yxy              = 0x0502,
    BM_16b_Lab              = 0x0503,
    BM_16b_G3CH             = 0x0504,
    BM_16b_GRAY             = 0x0505,
    BM_565RGB               = 0x0001,
    BM_32b_scRGB            = 0x0601,
    BM_32b_scARGB           = 0x0602,
    BM_S2DOT13FIXED_scRGB   = 0x0603,
    BM_S2DOT13FIXED_scARGB  = 0x0604,
    BM_R10G10B10A2          = 0x0701,
    BM_R10G10B10A2_XR       = 0x0702,
    BM_R16G16B16A16_FLOAT   = 0x0703
} BMFORMAT;
typedef BMFORMAT    *PBMFORMAT;
typedef BMFORMAT    *LPBMFORMAT;

/* Bitmap callback */
typedef BOOL (WINAPI *PBMCALLBACKFN)( ULONG, ULONG, LPARAM );
typedef PBMCALLBACKFN   LPBMCALLBACKFN;

/* Profile header */
typedef struct tagPROFILEHEADER {
    DWORD   phSize;
    DWORD   phCMMType;
    DWORD   phVersion;
    DWORD   phClass;
    DWORD   phDataColorSpace;
    DWORD   phConnectionSpace;
    DWORD   phDateTime[3];
    DWORD   phSignature;
    DWORD   phPlatform;
    DWORD   phProfileFlags;
    DWORD   phManufacturer;
    DWORD   phModel;
    DWORD   phAttributes[2];
    DWORD   phRenderingIntent;
    CIEXYZ  phIlluminant;
    DWORD   phCreator;
    BYTE    phReserved[44];
} PROFILEHEADER;
typedef PROFILEHEADER   *PPROFILEHEADER;
typedef PROFILEHEADER   *LPPROFILEHEADER;

/* Profile */
typedef struct tagPROFILE {
    DWORD   dwType;
    PVOID   pProfileData;
    DWORD   cbDataSize;
} PROFILE;
typedef PROFILE *PPROFILE;
typedef PROFILE *LPPROFILE;

/* Enumeration type */
typedef struct tagENUMTYPEA {
    DWORD   dwSize;
    DWORD   dwVersion;
    DWORD   dwFields;
    PCSTR   pDeviceName;
    DWORD   dwMediaType;
    DWORD   dwDitheringMode;
    DWORD   dwResolution[2];
    DWORD   dwCMMType;
    DWORD   dwClass;
    DWORD   dwDataColorSpace;
    DWORD   dwConnectionSpace;
    DWORD   dwSignature;
    DWORD   dwPlatform;
    DWORD   dwProfileFlags;
    DWORD   dwManufacturer;
    DWORD   dwModel;
    DWORD   dwAttributes[2];
    DWORD   dwRenderingIntent;
    DWORD   dwCreator;
    DWORD   dwDeviceClass;
} ENUMTYPEA;
typedef ENUMTYPEA   *PENUMTYPEA;
typedef ENUMTYPEA   *LPENUMTYPEA;
typedef struct tagENUMTYPEW {
    DWORD   dwSize;
    DWORD   dwVersion;
    DWORD   dwFields;
    PCWSTR  pDeviceName;
    DWORD   dwMediaType;
    DWORD   dwDitheringMode;
    DWORD   dwResolution[2];
    DWORD   dwCMMType;
    DWORD   dwClass;
    DWORD   dwDataColorSpace;
    DWORD   dwConnectionSpace;
    DWORD   dwSignature;
    DWORD   dwPlatform;
    DWORD   dwProfileFlags;
    DWORD   dwManufacturer;
    DWORD   dwModel;
    DWORD   dwAttributes[2];
    DWORD   dwRenderingIntent;
    DWORD   dwCreator;
    DWORD   dwDeviceClass;
} ENUMTYPEW;
typedef ENUMTYPEW   *PENUMTYPEW;
typedef ENUMTYPEW   *LPENUMTYPEW;
#ifdef UNICODE
typedef ENUMTYPEW   ENUMTYPE;
typedef PENUMTYPEW  PENUMTYPE;
#else
typedef ENUMTYPEA   ENUMTYPE;
typedef PENUMTYPEA  PENUMTYPE;
#endif

/* WCS profile management scopes */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum {
    WCS_PROFILE_MANAGEMENT_SCOPE_SYSTEM_WIDE    = 0,
    WCS_PROFILE_MANAGEMENT_SCOPE_CURRENT_USER   = 1
} WCS_PROFILE_MANAGEMENT_SCOPE;
#endif

/* Color matching callback */
typedef BOOL (WINAPI *PCMSCALLBACKA)( struct _tagCOLORMATCHSETUPA *, LPARAM );
typedef BOOL (WINAPI *PCMSCALLBACKW)( struct _tagCOLORMATCHSETUPW *, LPARAM );
#ifdef UNICODE
    #define PCMSCALLBACK    PCMSCALLBACKW
#else
    #define PCMSCALLBACK    PCMSCALLBACKA
#endif

/* Color matching setup information */
typedef struct _tagCOLORMATCHSETUPA {
    DWORD           dwSize;
    DWORD           dwVersion;
    DWORD           dwFlags;
    HWND            hwndOwner;
    PCSTR           pSourceName;
    PCSTR           pDisplayName;
    PCSTR           pPrinterName;
    DWORD           dwRenderIntent;
    DWORD           dwProofingIntent;
    PWSTR           pMonitorProfile;
    DWORD           ccMonitorProfile;
    PWSTR           pPrinterProfile;
    DWORD           ccPrinterProfile;
    PSTR            pTargetProfile;
    DWORD           ccTargetProfile;
    DLGPROC         lpfnHook;
    LPARAM          lParam;
    PCMSCALLBACKA   lpfnApplyCallback;
    LPARAM          lParamApplyCallback;
} COLORMATCHSETUPA;
typedef COLORMATCHSETUPA    *PCOLORMATCHSETUPA;
typedef COLORMATCHSETUPA    *LPCOLORMATCHSETUPA;
typedef struct _tagCOLORMATCHSETUPW {
    DWORD           dwSize;
    DWORD           dwVersion;
    DWORD           dwFlags;
    HWND            hwndOwner;
    PCWSTR          pSourceName;
    PCWSTR          pDisplayName;
    PCWSTR          pPrinterName;
    DWORD           dwRenderIntent;
    DWORD           dwProofingIntent;
    PWSTR           pMonitorProfile;
    DWORD           ccMonitorProfile;
    PWSTR           pPrinterProfile;
    DWORD           ccPrinterProfile;
    PWSTR           pTargetProfile;
    DWORD           ccTargetProfile;
    DLGPROC         lpfnHook;
    LPARAM          lParam;
    PCMSCALLBACKW   lpfnApplyCallback;
    LPARAM          lParamApplyCallback;
} COLORMATCHSETUPW;
typedef COLORMATCHSETUPW    *PCOLORMATCHSETUPW;
typedef COLORMATCHSETUPW    *LPCOLORMATCHSETUPW;
#ifdef UNICODE
typedef COLORMATCHSETUPW    COLORMATCHSETUP;
typedef PCOLORMATCHSETUPW   PCOLORMATCHSETUP;
typedef LPCOLORMATCHSETUPW  LPCOLORMATCHSETUP;
#else
typedef COLORMATCHSETUPA    COLORMATCHSETUP;
typedef PCOLORMATCHSETUPA   PCOLORMATCHSETUP;
typedef LPCOLORMATCHSETUPA  LPCOLORMATCHSETUP;
#endif

/* Functions in MSCMS.DLL */
BOOL WINAPI         AssociateColorProfileWithDeviceA( PCSTR, PCSTR, PCSTR );
BOOL WINAPI         AssociateColorProfileWithDeviceW( PCWSTR, PCWSTR, PCWSTR );
BOOL WINAPI         CheckBitmapBits( HTRANSFORM, PVOID, BMFORMAT, DWORD, DWORD, DWORD, PBYTE, PBMCALLBACKFN, LPARAM );
BOOL WINAPI         CheckColors( HTRANSFORM, PCOLOR, DWORD, COLORTYPE, PBYTE );
BOOL WINAPI         CloseColorProfile( HPROFILE );
BOOL WINAPI         ConvertColorNameToIndex( HPROFILE, PCOLOR_NAME, PDWORD, DWORD );
BOOL WINAPI         ConvertIndexToColorName( HPROFILE, PDWORD, PCOLOR_NAME, DWORD );
BOOL WINAPI         CreateProfileFromLogColorSpaceA( LPLOGCOLORSPACEA, PBYTE * );
BOOL WINAPI         CreateProfileFromLogColorSpaceW( LPLOGCOLORSPACEW, PBYTE * );
HTRANSFORM WINAPI   CreateColorTransformA( LPLOGCOLORSPACEA, HPROFILE, HPROFILE, DWORD );
HTRANSFORM WINAPI   CreateColorTransformW( LPLOGCOLORSPACEW, HPROFILE, HPROFILE, DWORD );
BOOL WINAPI         CreateDeviceLinkProfile( PHPROFILE, DWORD, PDWORD, DWORD, DWORD, PBYTE *, DWORD );
HTRANSFORM WINAPI   CreateMultiPlatformTransform( PHPROFILE, DWORD, PDWORD, DWORD, DWORD, DWORD );
BOOL WINAPI         DeleteColorTransform( HTRANSFORM );
BOOL WINAPI         DisassociateColorProfileFromDeviceA( PCSTR, PCSTR, PCSTR );
BOOL WINAPI         DisassociateColorProfileFromDeviceW( PCWSTR, PCWSTR, PCWSTR );
BOOL WINAPI         EnumColorProfilesA( PCSTR, PENUMTYPEA, PBYTE, PDWORD, PDWORD );
BOOL WINAPI         EnumColorProfilesW( PCWSTR, PENUMTYPEW, PBYTE, PDWORD, PDWORD );
DWORD WINAPI        GetCMMInfo( HTRANSFORM, DWORD );
BOOL WINAPI         GetColorDirectoryA( PCSTR, PSTR, PDWORD );
BOOL WINAPI         GetColorDirectoryW( PCWSTR, PWSTR, PDWORD );
BOOL WINAPI         GetColorProfileElement( HPROFILE, TAGTYPE, DWORD, PDWORD, PVOID, PBOOL );
BOOL WINAPI         GetColorProfileElementTag( HPROFILE, DWORD, PTAGTYPE );
BOOL WINAPI         GetColorProfileFromHandle( HPROFILE, PBYTE, PDWORD );
BOOL WINAPI         GetColorProfileHeader( HPROFILE, PPROFILEHEADER );
BOOL WINAPI         GetCountColorProfileElements( HPROFILE, PDWORD );
BOOL WINAPI         GetNamedProfileInfo( HPROFILE, PNAMED_PROFILE_INFO );
BOOL WINAPI         GetPS2ColorRenderingDictionary( HPROFILE, DWORD, PBYTE, PDWORD, PBOOL );
BOOL WINAPI         GetPS2ColorRenderingIntent( HPROFILE, DWORD, PBYTE, PDWORD );
BOOL WINAPI         GetPS2ColorSpaceArray( HPROFILE, DWORD, DWORD, PBYTE, PDWORD, PBOOL );
BOOL WINAPI         GetStandardColorSpaceProfileA( PCSTR, DWORD, PSTR, PDWORD );
BOOL WINAPI         GetStandardColorSpaceProfileW( PCWSTR, DWORD, PWSTR, PDWORD );
BOOL WINAPI         InstallColorProfileA( PCSTR, PCSTR );
BOOL WINAPI         InstallColorProfileW( PCWSTR, PCWSTR );
BOOL WINAPI         IsColorProfileTagPresent( HPROFILE, TAGTYPE, PBOOL );
BOOL WINAPI         IsColorProfileValid( HPROFILE, PBOOL );
HPROFILE WINAPI     OpenColorProfileA( PPROFILE, DWORD, DWORD, DWORD );
HPROFILE WINAPI     OpenColorProfileW( PPROFILE, DWORD, DWORD, DWORD );
BOOL WINAPI         RegisterCMMA( PCSTR, DWORD, PCSTR );
BOOL WINAPI         RegisterCMMW( PCWSTR, DWORD, PCWSTR );
BOOL WINAPI         SelectCMM( DWORD );
BOOL WINAPI         SetColorProfileElement( HPROFILE, TAGTYPE, DWORD, PDWORD, PVOID );
BOOL WINAPI         SetColorProfileElementReference( HPROFILE, TAGTYPE, TAGTYPE );
BOOL WINAPI         SetColorProfileElementSize( HPROFILE, TAGTYPE, DWORD );
BOOL WINAPI         SetColorProfileHeader( HPROFILE, PPROFILEHEADER );
BOOL WINAPI         SetStandardColorSpaceBufferA( PCSTR, DWORD, PCSTR );
BOOL WINAPI         SetStandardColorSpaceBufferW( PCWSTR, DWORD, PCWSTR );
BOOL WINAPI         TransformBitmapBits( HTRANSFORM, PVOID, BMFORMAT, DWORD, DWORD, DWORD, PVOID, BMFORMAT, DWORD, PBMCALLBACKFN, LPARAM );
BOOL WINAPI         TranslateColors( HTRANSFORM, PCOLOR, DWORD, COLORTYPE, PCOLOR, COLORTYPE );
BOOL WINAPI         UninstallColorProfileA( PCSTR, PCSTR, BOOL );
BOOL WINAPI         UninstallColorProfileW( PCWSTR, PCWSTR, BOOL );
BOOL WINAPI         UnregisterCMMA( PCSTR, DWORD );
BOOL WINAPI         UnregisterCMMW( PCWSTR, DWORD );
#if (NTDDI_VERSION >= 0x06000000)
BOOL WINAPI         WcsAssociateColorProfileWithDevice( WCS_PROFILE_MANAGEMENT_SCOPE, PCWSTR, PCWSTR );
BOOL WINAPI         WcsCheckColors( HTRANSFORM, DWORD, DWORD, COLORDATATYPE, DWORD, PVOID, PBYTE );
HPROFILE WINAPI     WcsCreateIccProfile( HPROFILE, DWORD );
BOOL WINAPI         WcsDisassociateColorProfileFromDevice( WCS_PROFILE_MANAGEMENT_SCOPE, PCWSTR, PCWSTR );
BOOL WINAPI         WcsEnumColorProfiles( WCS_PROFILE_MANAGEMENT_SCOPE, PENUMTYPEW, PBYTE, DWORD, PDWORD );
BOOL WINAPI         WcsEnumColorProfilesSize( WCS_PROFILE_MANAGEMENT_SCOPE, PENUMTYPEW, PDWORD );
BOOL WINAPI         WcsGetDefaultColorProfile( WCS_PROFILE_MANAGEMENT_SCOPE, PCWSTR, COLORPROFILETYPE, COLORPROFILESUBTYPE, DWORD, DWORD, LPWSTR );
BOOL WINAPI         WcsGetDefaultColorProfileSize( WCS_PROFILE_MANAGEMENT_SCOPE, PCWSTR, COLORPROFILETYPE, COLORPROFILESUBTYPE, DWORD, PDWORD );
BOOL WINAPI         WcsGetDefaultRenderingIntent( WCS_PROFILE_MANAGEMENT_SCOPE, PDWORD );
BOOL WINAPI         WcsGetUsePerUserProfiles( LPCWSTR, DWORD, PBOOL );
HPROFILE WINAPI     WcsOpenColorProfileA( PPROFILE, PPROFILE, PPROFILE, DWORD, DWORD, DWORD, DWORD );
HPROFILE WINAPI     WcsOpenColorProfileW( PPROFILE, PPROFILE, PPROFILE, DWORD, DWORD, DWORD, DWORD );
BOOL WINAPI         WcsSetDefaultColorProfile( WCS_PROFILE_MANAGEMENT_SCOPE, PCWSTR, COLORPROFILETYPE, COLORPROFILESUBTYPE, DWORD, LPCWSTR );
BOOL WINAPI         WcsSetDefaultRenderingIntent( WCS_PROFILE_MANAGEMENT_SCOPE, DWORD );
BOOL WINAPI         WcsSetUsePerUserProfiles( LPCWSTR, DWORD, BOOL );
BOOL WINAPI         WcsTranslateColors( HTRANSFORM, DWORD, DWORD, COLORDATATYPE, DWORD, PVOID, DWORD, COLORDATATYPE, DWORD, PVOID );
#endif
#if (NTDDI_VERSION >= 0x06010000)
BOOL WINAPI         WcsGetCalibrationManagementState( BOOL * );
BOOL WINAPI         WcsSetCalibrationManagementState( BOOL );
#endif

/* Functions in ICMUI.DLL */
BOOL WINAPI SetupColorMatchingA( PCOLORMATCHSETUPA );
BOOL WINAPI SetupColorMatchingW( PCOLORMATCHSETUPW );

/* Functions in ICM32.DLL */
BOOL WINAPI         CMCheckColors( HCMTRANSFORM, LPCOLOR, DWORD, COLORTYPE, LPBYTE );
BOOL WINAPI         CMCheckColorsInGamut( HCMTRANSFORM, RGBTRIPLE *, LPBYTE, UINT );
BOOL WINAPI         CMCheckRGBs( HCMTRANSFORM, LPVOID, BMFORMAT, DWORD, DWORD, DWORD, LPBYTE, PBMCALLBACKFN, LPARAM );
BOOL WINAPI         CMConvertColorNameToIndex( HPROFILE, PCOLOR_NAME, PDWORD, DWORD );
BOOL WINAPI         CMConvertIndexToColorName( HPROFILE, PDWORD, PCOLOR_NAME, DWORD );
BOOL WINAPI         CMCreateDeviceLinkProfile( PHPROFILE, DWORD, PDWORD, DWORD, DWORD, LPBYTE * );
HCMTRANSFORM WINAPI CMCreateMultiProfileTransform( PHPROFILE, DWORD, PDWORD, DWORD, DWORD );
BOOL WINAPI         CMCreateProfile( LPLOGCOLORSPACEA, LPDEVCHARACTER * );
BOOL WINAPI         CMCreateProfileW( LPLOGCOLORSPACEW, LPDEVCHARACTER * );
HCMTRANSFORM WINAPI CMCreateTransform( LPLOGCOLORSPACEA, LPDEVCHARACTER, LPDEVCHARACTER );
HCMTRANSFORM WINAPI CMCreateTransformExt( LPLOGCOLORSPACEA, LPDEVCHARACTER, LPDEVCHARACTER, DWORD );
HCMTRANSFORM WINAPI CMCreateTransformExtW( LPLOGCOLORSPACEW, LPDEVCHARACTER, LPDEVCHARACTER, DWORD );
HCMTRANSFORM WINAPI CMCreateTransformW( LPLOGCOLORSPACEW, LPDEVCHARACTER, LPDEVCHARACTER );
BOOL WINAPI         CMDeleteTransform( HCMTRANSFORM );
DWORD WINAPI        CMGetInfo( DWORD );
BOOL WINAPI         CMGetNamedProfileInfo( HPROFILE, PNAMED_PROFILE_INFO );
BOOL WINAPI         CMIsProfileValid( HPROFILE, LPBOOL );
BOOL WINAPI         CMTranslateColors( HCMTRANSFORM, LPCOLOR, DWORD, COLORTYPE, LPCOLOR, COLORTYPE );
BOOL WINAPI         CMTranslateRGB( HCMTRANSFORM, COLORREF, LPCOLORREF, DWORD );
BOOL WINAPI         CMTranslateRGBs( HCMTRANSFORM, LPVOID, BMFORMAT, DWORD, DWORD, DWORD, LPVOID, BMFORMAT, DWORD );
BOOL WINAPI         CMTranslateRGBsExt( HCMTRANSFORM, LPVOID, BMFORMAT, DWORD, DWORD, DWORD, LPVOID, BMFORMAT, DWORD, LPBMCALLBACKFN, LPARAM );

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define AssociateColorProfileWithDevice AssociateColorProfileWithDeviceW
    #define CreateColorTransform            CreateColorTransformW
    #define CreateProfileFromLogColorSpace  CreateProfileFromLogColorSpaceW
    #define DisassociateColorProfileFromDevice  DisassociateColorProfileFromDeviceW
    #define EnumColorProfiles               EnumColorProfilesW
    #define GetColorDirectory               GetColorDirectoryW
    #define GetStandardColorSpaceProfile    GetStandardColorSpaceProfileW
    #define InstallColorProfile             InstallColorProfileW
    #define OpenColorProfile                OpenColorProfileW
    #define RegisterCMM                     RegisterCMMW
    #define SetStandardColorSpaceProfile    SetStandardColorSpaceProfileW
    #define SetupColorMatching              SetupColorMatchingW
    #define UninstallColorProfile           UninstallColorProfileW
    #define UnregisterCMM                   UnregisterCMMW
    #if (NTDDI_VERSION >= 0x06000000)
        #define WcsOpenColorProfile         WcsOpenColorProfileW
    #endif
#else
    #define AssociateColorProfileWithDevice AssociateColorProfileWithDeviceA
    #define CreateColorTransform            CreateColorTransformA
    #define CreateProfileFromLogColorSpace  CreateProfileFromLogColorSpaceA
    #define DisassociateColorProfileFromDevice  DisassociateColorProfileFromDeviceA
    #define EnumColorProfiles               EnumColorProfilesA
    #define GetColorDirectory               GetColorDirectoryA
    #define GetStandardColorSpaceProfile    GetStandardColorSpaceProfileA
    #define InstallColorProfile             InstallColorProfileA
    #define OpenColorProfile                OpenColorProfileA
    #define RegisterCMM                     RegisterCMMA
    #define SetStandardColorSpaceProfile    SetStandardColorSpaceProfileA
    #define SetupColorMatching              SetupColorMatchingA
    #define UninstallColorProfile           UninstallColorProfileA
    #define UnregisterCMM                   UnregisterCMMA
    #if (NTDDI_VERSION >= 0x06000000)
        #define WcsOpenColorProfile         WcsOpenColorProfileA
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _ICM_H_ */
