/*
 *  dsclient.h  Directory Service client functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

/* Directory Service object flags */
#define DSOBJECT_ISCONTAINER    0x00000001L
#define DSOBJECT_READONLYPAGES  0x80000000L

/* Directory Service provider flags */
#define DSPROVIDER_ADVANCED 0x00000010L
#define DSPROVIDER_AD_LDS   0x00000020L

/* Directory Service clipboard format strings */
#define CFSTR_DSOBJECTNAMES             TEXT( "DsObjectNames" )
#define CFSTR_DS_DISPLAY_SPEC_OPTIONS   TEXT( "DsDisplaySpecOptions" )
#define CFSTR_DSDISPLAYSPECOPTIONS      CFSTR_DS_DISPLAY_SPEC_OPTIONS
#define CFSTR_DSPROPERTYPAGEINFO        TEXT( "DsPropPageInfo" )

/* Directory Service property prefixes */
#define DS_PROP_SHELL_PREFIX    L"shell"
#define DS_PROP_ADMIN_PREFIX    L"admin"

/* Directory Service display specifier option flags */
#define DSDSOF_HASUSERANDSERVERINFO 0x00000001L
#define DSDSOF_SIMPLEAUTHENTICATE   0x00000002L
#define DSDSOF_DONTSIGNSEAL         0x00000004L
#define DSDSOF_DSAVAILABLE          0x40000000L

/* Directory Service property messages */
#define DSPROP_ATTRCHANGED_MSG  TEXT( "DsPropAttrChanged" )

/* Directory Service browse domain tree flags */
#define DBDTF_RETURNFQDN            0x00000001L
#define DBDTF_RETURNMIXEDDOMAINS    0x0x000002L
#define DBDTF_RETURNEXTERNAL        0x00000004L
#define DBDTF_RETURNINBOUND         0x00000008L
#define DBDTF_RETURNINOUTBOUND      0x00000010L

/* IDsDisplaySpecifier::SetServer() flags */
#define DSSSF_SIMPLEAUTHENTICATE    0x00000001L
#define DSSSF_DONTSIGNSEAL          0x00000002L
#define DSSSF_DSAVAILABLE           0x80000000L

/* IDsDisplaySpecifier::GetIcon() flags */
#define DSGIF_ISNORMAL              0x00000000L
#define DSGIF_ISOPEN                0x00000001L
#define DSGIF_ISDISABLED            0x00000002L
#define DSGIF_ISMASK                0x0000000FL
#define DSGIF_GETDEFAULTICON        0x00000010L
#define DSGIF_DEFAULTISCONTAINER    0x00000020L

/* IDsDisplaySpecifier::IsClassContainer() flags */
#define DSICCF_IGNORETREATASLEAF    0x00000001L

/* IDsDisplaySpecifier::EnumClassAttributes() flags */
#define DSECAF_NOTLISTED    0x00000001L

/* IDsDisplaySpecifier::GetClassCreationInfo() flags */
#define DSCCIF_HASWIZARDDIALOG      0x00000001L
#define DSCCIF_HASWIZARDPRIMARYPAGE 0x00000002L

/* DsBrowseForContainer() flags */
#define DSBI_NOBUTTONS          0x00000001L
#define DSBI_NOLINES            0x00000002L
#define DSBI_NOLINESATROOT      0x00000004L
#define DSBI_CHECKBOXES         0x00000100L
#define DSBI_NOROOT             0x00010000L
#define DSBI_INCLUDEHIDDEN      0x00020000L
#define DSBI_EXPANDONOPEN       0x00040000L
#define DSBI_EXPANDDIRECTORY    0x00090000L
#define DSBI_RETURN_FORMAT      0x00100000L
#define DSBI_HASCREDENTIALS     0x00200000L
#define DSBI_IGNORETREATASLEAF  0x00400000L
#define DSBI_SIMPLEAUTHENTICATE 0x00800000L
#define DSBI_RETURNOBJECTCLASS  0x01000000L
#define DSBI_DONTSIGNSEAL       0x02000000L

/* DsBrowseForContainer() maximum display name characters */
#define DSB_MAX_DISPLAYNAME_CHARS   64

/* DsBrowseForContainer() item masks */
#define DSBF_STATE          0x00000001L
#define DSBF_ICONLOCATION   0x00000002L
#define DSBF_DISPLAYNAME    0x00000004L

/* DsBrowseForContainer() item states */
#define DSBS_CHECKED    0x00000001L
#define DSBS_HIDDEN     0x00000002L
#define DSBS_ROOT       0x00000004L

/* DsBrowseForContainer() callback messages */
#define DSBM_QUERYINSERTW       100
#define DSBM_QUERYINSERTA       101
#define DSBM_CHANGEIMAGESTATE   102
#define DSBM_HELP               103
#define DSBM_CONTEXTMENU        104
#ifdef UNICODE
    #define DSBM_QUERYINSERT    DSBM_QUERYINSERTW
#else
    #define DSBM_QUERYINSERT    DSBM_QUERYINSERTA
#endif

/* DsBrowseForContainer() control identifiers */
#define DSBID_BANNER        256
#define DSBID_CONTAINERLIST 257

/* Directory Service object */
typedef struct {
    DWORD   dwFlags;
    DWORD   dwProviderFlags;
    DWORD   offsetName;
    DWORD   offsetClass;
} DSOBJECT;
typedef DSOBJECT    *LPDSOBJECT;

/* Directory Service object names */
typedef struct {
    CLSID       clsidNamespace;
    UINT        cItems;
    DSOBJECT    aObjects[1];
} DSOBJECTNAMES;
typedef DSOBJECTNAMES   *PDSOBJECTNAMES;

/* Directory Service display specifier options */
typedef struct _DSDISPLAYSPECOPTIONS {
    DWORD   dwSize;
    DWORD   dwFlags;
    DWORD   offsetAttribPrefix;
    DWORD   offsetUserName;
    DWORD   offsetPassword;
    DWORD   offsetServer;
    DWORD   offsetServerConfigPath;
} DSDISPLAYSPECOPTIONS;
typedef DSDISPLAYSPECOPTIONS    *PDSDISPLAYSPECOPTIONS;
typedef DSDISPLAYSPECOPTIONS    *LPDSDISPLAYSPECOPTIONS;

/* Directory Service property page information */
typedef struct {
    DWORD   offsetString;
} DSPROPERTYPAGEINFO;
typedef DSPROPERTYPAGEINFO  *LPDSPROPERTYPAGEINFO;

/* Domain descriptor */
typedef struct _DOMAINDESC {
    LPWSTR              pszName;
    LPWSTR              pszPath;
    LPWSTR              pszNCName;
    LPWSTR              pszTrustParent;
    LPWSTR              pszObjectClass;
    ULONG               ulFlags;
    BOOL                fDownLevel;
    struct _DOMAINDESC  *pdChildList;
    struct _DOMAINDESC  *pdNextSibling;
} DOMAIN_DESC;
typedef DOMAIN_DESC DOMAINDESC;
typedef DOMAIN_DESC *PDOMAIN_DESC;
typedef DOMAIN_DESC *LPDOMAINDESC;

/* Domain tree */
typedef struct {
    DWORD       dsSize;
    DWORD       dwCount;
    DOMAINDESC  aDomains[1];
} DOMAIN_TREE;
typedef DOMAIN_TREE DOMAINTREE;
typedef DOMAIN_TREE *PDOMAIN_TREE;
typedef DOMAIN_TREE *LPDOMAINTREE;

/* Directory Service enumerate attributes callback */
typedef HRESULT (CALLBACK *LPDSENUMATTRIBUTES)( LPARAM, LPCWSTR, LPCWSTR, DWORD );

/* Directory Service class creation information */
typedef struct {
    DWORD   dwFlags;
    CLSID   clsidWizardDialog;
    CLSID   clsidWizardPrimaryPage;
    DWORD   cWizardExtensions;
    CLSID   aWizardExtensions[1];
} DSCLASSCREATIONINFO;
typedef DSCLASSCREATIONINFO *LPDSCLASSCREATIONINFO;

/* DsBrowseForContainer() parameters */
typedef struct {
    DWORD       cbStruct;
    HWND        hwndOwner;
    LPCSTR      pszCaption;
    LPCSTR      pszTitle;
    LPCWSTR     pszRoot;
    LPWSTR      pszPath;
    ULONG       cchPath;
    DWORD       dwFlags;
    BFFCALLBACK pfnCallback;
    LPARAM      lParam;
    DWORD       dwReturnFormat;
    LPCWSTR     pUserName;
    LPCWSTR     pPassword;
    LPWSTR      pszObjectClass;
    ULONG       cchObjectClass;
} DSBROWSEINFOA;
typedef DSBROWSEINFOA   *PDSBROWSEINFOA;
typedef struct {
    DWORD       cbStruct;
    HWND        hwndOwner;
    LPCWSTR     pszCaption;
    LPCWSTR     pszTitle;
    LPCWSTR     pszRoot;
    LPWSTR      pszPath;
    ULONG       cchPath;
    DWORD       dwFlags;
    BFFCALLBACK pfnCallback;
    LPARAM      lParam;
    DWORD       dwReturnFormat;
    LPCWSTR     pUserName;
    LPCWSTR     pPassword;
    LPWSTR      pszObjectClass;
    ULONG       cchObjectClass;
} DSBROWSEINFOW;
typedef DSBROWSEINFOW   *PDSBROWSEINFOW;
#ifdef UNICODE
typedef DSBROWSEINFOW   DSBROWSEINFO;
typedef PDSBROWSEINFOW  PDSBROWSEINFO;
#else
typedef DSBROWSEINFOA   DSBROWSEINFO;
typedef PDSBROWSEINFOA  PDSBROWSEINFO;
#endif

/* DsBrowseForContainer() item */
typedef struct {
    DWORD   cbStruct;
    LPCWSTR pszADsPath;
    LPCWSTR pszClass;
    DWORD   dwMask;
    DWORD   dwState;
    DWORD   dwStateMask;
    CHAR    szDisplayName[DSB_MAX_DISPLAYNAME_CHARS];
    CHAR    szIconLocation[MAX_PATH];
    INT     iIconResID;
} DSBITEMA;
typedef DSBITEMA    *PDSBITEMA;
typedef struct {
    DWORD   cbStruct;
    LPCWSTR pszADsPath;
    LPCWSTR pszClass;
    DWORD   dwMask;
    DWORD   dwState;
    DWORD   dwStateMask;
    WCHAR   szDisplayName[DSB_MAX_DISPLAYNAME_CHARS];
    WCHAR   szIconLocation[MAX_PATH];
    INT     iIconResID;
} DSBITEMW;
typedef DSBITEMW    *PDSBITEMW;
#ifdef UNICODE
typedef DSBITEMW    DSBITEM;
typedef PDSBITEMW   PDSBITEM;
#else
typedef DSBITEMA    DSBITEM;
typedef PDSBITEMA   PDSBITEM;
#endif

/* GUIDs */
EXTERN_C const CLSID    CLSID_MicrosoftDS;
EXTERN_C const CLSID    CLSID_DsPropertyPages;
EXTERN_C const CLSID    CLSID_DsDomainTreeBrowser;
EXTERN_C const IID      IID_IDsBrowseDomainTree;
EXTERN_C const CLSID    CLSID_DsDisplaySpecifier;
EXTERN_C const CLSID    CLSID_DsFolderProperties;
#define IID_IDsDisplaySpecifier CLSID_DsDisplaySpecifier
#define IID_IDsFolderProperties CLSID_DsFolderProperties

/* IDsBrowseDomainTree interface */
#undef INTERFACE
#define INTERFACE   IDsBrowseDomainTree
DECLARE_INTERFACE_( IDsBrowseDomainTree, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDsBrowseDomainTree methods */
    STDMETHOD( BrowseTo )( THIS_ HWND, LPWSTR *, DWORD ) PURE;
    STDMETHOD( GetDomains )( THIS_ PDOMAIN_TREE *, DWORD ) PURE;
    STDMETHOD( FreeDomains )( THIS_ PDOMAIN_TREE * ) PURE;
    STDMETHOD( FlushCachedDomains )( THIS ) PURE;
    STDMETHOD( SetComputer )( THIS_ LPCWSTR, LPCWSTR, LPCWSTR ) PURE;
};

/* IDsDisplaySpecifier interface */
#undef INTERFACE
#define INTERFACE   IDsDisplaySpecifier
DECLARE_INTERFACE_( IDsDisplaySpecifier, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDsDisplaySpecifier methods */
    STDMETHOD( SetServer )( THIS_ LPCWSTR, LPCWSTR, LPCWSTR, DWORD ) PURE;
    STDMETHOD( SetLanguageID )( THIS_ LANGID ) PURE;
    STDMETHOD( GetDisplaySpecifier )( THIS_ LPCWSTR, REFIID, void ** ) PURE;
    STDMETHOD( GetIconLocation )( THIS_ LPCWSTR, DWORD, LPWSTR, INT, INT * ) PURE;
    STDMETHOD_( HICON, GetIcon )( THIS_ LPCWSTR, DWORD, INT, INT ) PURE;
    STDMETHOD( GetFriendlyClassName )( THIS_ LPCWSTR, LPWSTR, INT ) PURE;
    STDMETHOD( GetFriendlyAttributeName )( THIS_ LPCWSTR, LPCWSTR, LPWSTR, UINT ) PURE;
    STDMETHOD_( BOOL, IsClassContainer )( THIS_ LPCWSTR, LPCWSTR, DWORD ) PURE;
    STDMETHOD( GetClassCreationInfo )( THIS_ LPCWSTR, LPDSCLASSCREATIONINFO * ) PURE;
    STDMETHOD( EnumClassAttributes )( THIS_ LPCWSTR, LPDSENUMATTRIBUTES, LPARAM ) PURE;
    STDMETHOD_( ADSTYPE, GetAttributeADsType )( THIS_ LPCWSTR ) PURE;
};

/* Functions in DSUIEXT.DLL */
STDAPI_( int )      DsBrowseForContainerA( PDSBROWSEINFOA );
STDAPI_( int )      DsBrowseForContainerW( PDSBROWSEINFOW );
STDAPI              DsGetFriendlyClassName( LPCWSTR, LPWSTR, UINT );
STDAPI_( HICON )    DsGetIcon( DWORD, LPCWSTR, INT, INT );

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define DsBrowseForContainer    DsBrowseForContainerW
#else
    #define DsBrowseForContainer    DsBrowseForContainerA
#endif
