;***********************;
; SESSION Macro Support ;
;     By Eric Tauck     ;
;***********************;

m_run   DB      'Macro file to execute: ', 0

m_err1  DB      'Not enough memory',0
m_err2  DB      'Out of symbol space',0
m_err3  DB      'Out of code space',0
m_err4  DB      'Token too long',0
m_err5  DB      'Undefined symbol',0
m_err6  DB      'Unexpected end of macro file',0
m_err7  DB      'Unable to read macro file',0
m_err8  DB      'Invalid number after ALLOC',0
m_err9  DB      'Undefined symbol: ',0

m_errs  DW      OFFSET m_err1, OFFSET m_err2, OFFSET m_err3, OFFSET m_err4
        DW      OFFSET m_err5, OFFSET m_err6, OFFSET m_err7, OFFSET m_err8

m_nl    DB      13, 10, 0

;--- user defined words

MacUsr  LABEL   BYTE
        DB      'CGET',0, OFFSET Macro_CGET
        DB      'CPUT',0, OFFSET Macro_CPUT
        DB      'CREP',0, OFFSET Macro_CREP
        DB      'KGET',0, OFFSET Macro_KGET
        DB      'KREP',0, OFFSET Macro_KREP
        DB      'TERM',0, OFFSET Macro_TERM
        DB      'RESET',0, OFFSET Macro_RESET
        DB      'TICKS',0, OFFSET Macro_TICKS
        DB      'CLEAR',0, OFFSET Macro_CLEAR
        DB      'TYPE',0, OFFSET Macro_TYPE
        DB      'MESS',0, OFFSET Macro_MESS
        DB      'ERROR',0, OFFSET Macro_ERROR
        DB      'INPUT',0, OFFSET Macro_INPUT
        DB      'VERIFY',0, OFFSET Macro_VERIFY
        DB      'ULOAD',0, OFFSET Macro_ULOAD
        DB      'DLOAD',0, OFFSET Macro_DLOAD
        DB      0

;========================================
; Load and compile a macro.
;
; In: AX= file name or 0 if none.
;
; Out: CY= set if abort.

Macro_Load PROC NEAR
        push    di
        StkAll  di, 80          ;allocate space for file name and error mess.

;--- input file name

        or      ax, ax          ;check if name passed
        jz      macloa1         ;jump if not
        mov     bx, di
        call    StrCpy          ;copy to buffer
        jmps    macloa2
        
macloa1 mov     ax,OFFSET t_rea ;prompt

        mov     ax,OFFSET m_run ;prompt
        mov     bx, di          ;storage for file name
        call    Command_Input   ;input a file name
        jc      macloa7         ;jump if cancel

;---- check if file exists, if not, try using program path

macloa2 mov     ax, di
        call    Find_File       ;find file
        jnc     macloa3         ;jump if found
        mov     ax, di
        call    Cut_Name        ;check if drive or directory
        jnc     macloa3         ;jump if so, let MacCom handle it
        call    EnvPro          ;get program name
        jc      macloa3         ;jump if can't, let MacCom handle it

        push    si
        StkAll  si, 80
        mov     cx, ds
        mov     bx, si
        call    StrCpyF         ;program name to local storage
        mov     ax, si
        call    Cut_Name        ;find end of path
        mov     bx, ax
        mov     ax, di
        call    StrCpy          ;append to end of path
        mov     ax, si
        mov     bx, di
        call    StrCpy          ;copy to input buffer
        StkRel  80
        pop     si

;---- compile and load

macloa3 mov     ax, di
        call    MacCom          ;compile and load macro
        jc      macloa4         ;jump if error

        StkRel  80
        pop     di
        clc
        ret

;--- deal with error

macloa4 mov     bx, ax
        dec     bx
        shl     bx
        cmp     ax, MACRO_UNDEF         ;check if undefined symbol
        jne     macloa5                 ;skip if not

        push    bx
        mov     ax, OFFSET m_err9
        mov     bx, di
        call    StrCpy                  ;copy error message
        add     ax, di                  ;end of error message
        call    MacUnd                  ;append symbol
        mov     ax, di
        pop     bx
        jnc     macloa6                 ;jump if okay

macloa5 mov     ax, [m_errs + bx]       ;load error message
macloa6 call    Command_Error           ;display

macloa7 StkRel  80
        pop     di
        stc
        ret
        ENDP

;========================================
; Return the end of the drive/directory
; of a file name.
;
; In: AX= file name.
;
; Out: AX= first byte of filename (byte
;      after drive and path); CY= set if
;      no drive/path.

Cut_Name PROC   NEAR
        push    si
        mov     si, ax
        mov     bx, ax
        mov     cx, ax
        cld

cutnam1 lodsb                   ;load byte
        or      al, al          ;check if end of string
        jz      cutnam3
        cmp     al, ':'         ;check if drive specifier
        je      cutnam2
        cmp     al, '\'         ;check if directory specifier
        jne     cutnam1
cutnam2 mov     bx, si          ;save this location
        jmps    cutnam1

cutnam3 mov     ax, bx
        pop     si
        sub     cx, bx          ;set carry if found
        cmc                     ;set carry if not found
        ret
        ENDP

;========================================
; Get a serial byte. Return FALSE if not
; available or TRUE and the value if
; available.

Macro_CGET PROC  FAR

;--- read terminal byte buffer

        mov     al, t_cflg      ;load flag
        or      al, al          ;check if set
        jz      macget2         ;jump if not

        dec     t_cflg          ;zero flag
        mov     al, t_cbyt      ;load data byte

;--- return TRUE and a value

macget1 sub     ah, ah
        call    MacSto          ;store byte
        mov     ax, -1
        call    MacSto          ;store flag
        ret

;--- check serial port directly

macget2 mov     bx, t_ser
        call    ComGet          ;try getting byte directly
        jnc     macget1

;--- return FALSE and no byte

        sub     ax, ax
        call    MacSto          ;store
        ret
        ENDP

;========================================
; Send a byte directly to the serial
; port.

Macro_CPUT PROC  FAR
        call    MacLoa          ;load byte
        mov     bx, t_ser
        call    ComPut          ;send it
        ret
        ENDP

;========================================
; Replace a serial byte.

Macro_CREP PROC  FAR
        call    MacLoa          ;get byte
        mov     t_cflg, 1       ;set flag
        mov     t_cbyt, al      ;store value
        ret
        ENDP

;========================================
; Get a keystroke. Return FALSE if not
; available or TRUE and the value if
; available.

Macro_KGET PROC  FAR

;--- read buffer

        mov     al, t_kflg      ;load flag
        or      al, al          ;check if set
        jz      macgek2         ;jump if not

        dec     t_kflg          ;zero flag
        mov     ax, t_kbyt      ;load data byte

;--- return TRUE and a value

macgek1 call    MacSto          ;store key
        mov     ax, -1
        call    MacSto          ;store flag
        ret

;--- check keyboard directly

macgek2 call    KeyGet          ;get keystroke
        jnc     macgek1

;--- return FALSE and no byte

        sub     ax, ax          ;return false
        call    MacSto
        ret
        ENDP

;========================================
; Replace a keystroke.

Macro_KREP PROC  FAR
        call    MacLoa          ;get key
        mov     t_kflg, 1       ;set flag
        mov     t_kbyt, ax      ;store value
        ret
        ENDP

;========================================
; Send a byte through the terminal.

Macro_TERM PROC FAR
        call    MacLoa          ;get byte
        call    Term_Out        ;terminal output
        ret
        ENDP

;========================================
; Reset timer.

Macro_RESET PROC FAR
        mov     al, MACRO_TIMER
        call    TicRes          ;reset timer
        ret
        ENDP

;========================================
; Return timer ticks passed.

Macro_TICKS PROC FAR
        mov     al, MACRO_TIMER
        call    TicPas          ;get ticks passed
        call    MacSto          ;store ticks
        ret
        ENDP

;========================================
; Clear both windows.

Macro_CLEAR PROC FAR
        call    Clear_Both
        ret
        ENDP

;========================================
; Type a system character.

Macro_TYPE PROC FAR
        push    di
        StkAll  di, 2           ;allocate local storage
        call    MacLoa          ;load character
        sub     ah, ah          ;NUL
        mov     [di], ax        ;store character and NUL
        mov     ax, di
        call    System_String   ;display as string
        StkRel  2               ;fix stack
        pop     di
        ret
        ENDP

;========================================
; Display a system message.

Macro_MESS PROC FAR
        push    di
        StkAll  di, 80          ;allocate local storage
        call    MacLoa          ;load address
        mov     cx, ds
        mov     bx, di
        call    StrCpyF         ;copy to local storage
        mov     ax, di
        call    System_String   ;display
        mov     ax, OFFSET m_nl
        call    System_String   ;display new line
        StkRel  80              ;fix stack
        pop     di
        ret
        ENDP

;========================================
; Display an error.

Macro_ERROR PROC FAR
        push    di
        StkAll  di, 80          ;allocate local storage
        call    MacLoa          ;load address
        mov     cx, ds
        mov     bx, di
        call    StrCpyF         ;copy to string to local storage
        mov     ax, di
        call    Command_Error   ;display
        StkRel  80              ;fix stack
        pop     di
        ret
        ENDP

;========================================
; Perform a verify.

Macro_VERIFY PROC FAR
        push    di
        StkAll  di, 80          ;prompt storage
        call    MacLoa          ;get address
        mov     cx, ds
        mov     bx, di
        call    StrCpyF         ;copy prompt to local storage
        mov     ax, di
        call    Command_Confirm ;verify
        mov     ax, 0           ;return value
        jc      macver1         ;jump if not verified
        dec     ax              ;return TRUE
macver1 call    MacSto          ;store flag
        StkRel  80
        pop     di
        ret
        ENDP

;========================================
; Input a string.

Macro_INPUT PROC FAR
        push    di
        push    si
        StkAll  di, 80          ;prompt storage
        StkAll  si, 80          ;allocate temporary input buffer
        call    MacLoa          ;load address
        mov     cx, ds
        mov     bx, di
        call    StrCpyF         ;copy prompt to local storage
        mov     ax, di
        mov     bx, si
        call    Command_Input   ;input string
        mov     ax, 0
        jc      macinp1         ;jump if no input
        dec     ax
macinp1 push    ax
        call    MacLoa          ;get buffer address
        mov     cx, dx
        mov     bx, ax
        pop     ax

        or      ax, ax
        jz      macinp2
        push    ax
        mov     dx, ds
        mov     ax, si
        call    StrCpyF         ;copy to macro area
        pop     ax

macinp2 call    MacSto          ;store flag

        StkRel  80 + 80         ;fix stack
        pop     si
        pop     di
        ret
        ENDP

;========================================
; Upload a file.

Macro_ULOAD PROC FAR
        push    di
        push    si
        StkAll  si, 80          ;allocate local storage
        call    MacLoa          ;load file address
        mov     cx, ds
        mov     bx, si
        call    StrCpyF         ;copy to name to local storage
        call    Xmodem_Flags    ;set flags
        mov     ax, si
        mov     bx, t_ser
        call    Xmodem_Upload   ;perform upload
        StkRel  80              ;fix stack
        pop     si
        pop     di
        ret
        ENDP

;========================================
; Download a file.

Macro_DLOAD PROC FAR
        push    di
        push    si
        StkAll  si, 80          ;allocate local storage
        call    MacLoa          ;load file address
        mov     cx, ds
        mov     bx, si
        call    StrCpyF         ;copy to name to local storage
        call    Xmodem_Flags    ;set flags
        mov     ax, si
        mov     bx, t_ser
        call    Xmodem_Download ;perform download
        StkRel  80              ;fix stack
        pop     si
        pop     di
        ret
        ENDP
