;******************************************;
; WASM Video Module, Cursor Routines       ;
; By Eric Tauck                            ;
;                                          ;
; Defines:                                 ;
;                                          ;
;   CurAct  activate/deactive cursor       ;
;   CurGet  return the cursor on/off state ;
;   CurSet  turn the cursor on/off         ;
;   CurCol  return current column          ;
;   CurRow  return current row             ;
;   CurPos  return current column and row  ;
;   CurMov  move cursor to location        ;
;   CurAdv  advance the cursor             ;
;                                          ;
; Requires:                                ;
;                                          ;
;   VIDEO1.ASM                             ;
;******************************************;

        jmp     _video4_end

;========================================
; Activate or deactive cursor.
;
; In: AL= zero if deactivate, otherwise
;     activate.
;
; Out: AL= original state.

CurAct  PROC    NEAR
        mov     ah, _vid_flags          ;load flags
        push    ax                      ;save for return
        and     _vid_flags, NOT _vid_CACT ;clear bit
        or      al, al                  ;check if deactivate
        jz      _cract1
        test    ah, _vid_CACT           ;check if already active
        jnz     _cract1
        or      _vid_flags, _vid_CACT   ;set bit
        mov     ax, _vid_colrow         ;current location
        call    CurMov                  ;set physical cursor
_cract1 pop     ax                      ;original flags
        mov     al, ah
        and     al, _vid_CACT           ;return bit
        ret
        ENDP

;========================================
; Return the cursor on/off state.
;
; Out: AL= cursor on/off state.

CurGet  PROC    NEAR
        mov     al, _vid_flags  ;load flags
        and     al, _vid_CVIS   ;mask relevant bit
        ret
        ENDP

;========================================
; Set the cursor on or off.
;
; In: AL= non-zero if set visible,
;     otherwise set invisible.
;
; Out: AL= original state.

CurSet  PROC    NEAR
        mov     ah, _vid_flags          ;load flags
        push    ax                      ;save for return
        or      al, al                  ;check if turn on or off
        jnz     _crset1                 ;jump if turn on

;--- cursor off

        test    ah, _vid_CVIS           ;check if already off
        jz      _crset2
        mov     ah, 1                   ;set cursor function
        mov     cx, _vid_coff           ;off scan pattern
        int     10H                     ;execute
        and     _vid_flags, NOT _vid_CVIS ;clear flag
        jmps    _crset2

;--- cursor on

_crset1 test    ah, _vid_CVIS           ;check if already on
        jnz     _crset2
        mov     ah, 1                   ;set cursor function
        mov     cx, _vid_con            ;on scan pattern
        int     10H                     ;execute
        or      _vid_flags, _vid_CVIS   ;set flag
        mov     ax, _vid_colrow         ;current location
        call    CurMov                  ;position cursor, sets physical cursor

_crset2 pop     ax
        mov     al, ah
        and     al, _vid_CVIS
        ret
        ENDP

;========================================
; Return the cursor column.
;
; Out: AL= column.

CurCol  PROC    NEAR
        mov     al, _vid_col    ;return column
        ret
        ENDP

;========================================
; Return the cursor row.
;
; Out: AL= row.

CurRow  PROC    NEAR
        mov     al, _vid_row    ;return row
        ret
        ENDP

;========================================
; Return the cursor position (row and
; column).
;
; Out: AL= column; AH= row.

CurPos  PROC    NEAR
        mov     ax, _vid_colrow ;return column and row
        ret
        ENDP

;========================================
; Move the cursor.
;
; In: AL= column; AH= row.

CurMov  PROC    NEAR
        mov     _vid_curadv, 0          ;zero advance count

;--- save location and determine address for next write

        mov     _vid_colrow, ax         ;save column and row
        call    _vid_setaddr            ;set write address

;--- move physical cursor if visible and active

        mov     al, _vid_flags
        and     al, _vid_CVIS OR _vid_CACT
        cmp     al, _vid_CVIS OR _vid_CACT
        jne     _crmov1

        mov     ah, 2                   ;move cursor function
        mov     bh, _vid_page           ;active page
        mov     dx, _vid_colrow         ;location
        int     10H                     ;execute

_crmov1 ret
        ENDP

;========================================
; Advance the cursor according the last
; character/string write.

CurAdv  PROC    NEAR
        mov     ax, _vid_colrow ;load current location
        add     al, _vid_curadv ;add advance value to column
        call    CurMov          ;move cursor
        ret
        ENDP

_video4_end
