;********************************;
; WASM Serial I/O, Line Status   ;
; By Eric Tauck                  ;
;                                ;
; Defines:                       ;
;                                ;
;   ComRng  return ring state    ;
;   ComCar  return carrier state ;
;                                ;
; Requires:                      ;
;                                ;
;   SERIAL1.ASM                  ;
;********************************;

        jmps    _serial7_end

;========================================
; Return ring state.
;
; In: BX= serial record.
;
; Out: CY= set if ring.

ComRng  PROC    NEAR
        mov     dx, [bx+_COM_MODEMSTAT] ;modem status
        in      al, dx                  ;get byte
        and     al, 40H                 ;mask bit
        sub     ah, ah                  ;zero
        sub     ah, al                  ;set carry if high
        ret
        ENDP

;========================================
; Return carrier state.
;
; In: BX= serial record.
;
; Out: CY= set if carrier detected.

ComCar  PROC    NEAR
        mov     dx, [bx+_COM_MODEMSTAT] ;modem status
        in      al, dx                  ;get byte
        and     al, 80H                 ;mask bit
        sub     ah, ah                  ;zero
        sub     ah, al                  ;set carry if high
        ret
        ENDP

_serial7_end
