;**********************************;
; WASM Serial I/O, Word Transfer   ;
; By Eric Tauck                    ;
;                                  ;
; Defines:                         ;
;                                  ;
;   ComGetW  input a word of data  ;
;   ComPutW  output a word of data ;
;                                  ;
; Requires:                        ;
;                                  ;
;   SERIAL1.ASM                    ;
;**********************************;

        jmps    _serial2_end

;========================================
; Input a word.
;
; In: BX= record address.
;
; Out: AX= word; CY= set if unavailable.

ComGetW PROC    NEAR
        push    di
        mov     di, bx
        call    ComByt          ;get bytes
        cmp     ax, 2           ;check if at least two bytes
        jb      _cminw1         ;jump if not
        mov     bx, di
        call    ComGet          ;get byte
        push    ax
        mov     bx, di
        call    ComGet          ;get byte
        pop     dx
        mov     ah, dl          ;return high byte

;--- finished, successful

        pop     di
        clc
        ret

;--- bytes not available

_cminw1 pop     di
        stc
        ret
        ENDP

;========================================
; Output a word.
;
; In: BX= record address; AX= word.

ComPutW PROC    NEAR
        push    ax
        push    bx
        mov     al, ah
        call    ComPut  ;send high byte
        pop     bx
        pop     ax
        call    ComPut  ;send low byte
        ret
        ENDP

_serial2_end
