;*******************************************;
; WASM Checksum Calculation, Standard Block ;
; By Eric Tauck                             ;
;                                           ;
; Defines:                                  ;
;                                           ;
;   SumBlk  return checksum of block        ;
;*******************************************;

        jmps    _check1_end

;========================================
; Return the 8 or 16 bit checksum of a
; block.
;
; In: BX= address of bytes to check; CX=
;     bytes to check.
;
; Out: AL= 8 bit checksum; AX= 16 bit
;      checksum.

SumBlk  PROC    NEAR
        sub     ax, ax          ;zero checksum
        jcxz    _smblk2         ;jump if no bytes to check

;--- loop for each byte

_smblk1 add     al, [bx]        ;add to checksum
        adc     ah, 0           ;carry
        inc     bx              ;next byte
        loop    _smblk1         ;loop back

;--- finished

_smblk2 ret
        ENDP

_check1_end
