/* powerpc64-darwin.macho-fold.h
   created from powerpc64-darwin.macho-fold.bin, 6520 (0x1978) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_POWERPC64_DARWIN_MACHO_FOLD_SIZE    6520
#define STUB_POWERPC64_DARWIN_MACHO_FOLD_ADLER32 0x7e1ac4ee
#define STUB_POWERPC64_DARWIN_MACHO_FOLD_CRC32   0xe895cd89

unsigned char stub_powerpc64_darwin_macho_fold[6520] = {
/* 0x0000 */ 124,128,  0,  8, 72,  0,  0,105, 40,  6,  0,208, 76,194,  0, 32,
/* 0x0010 */  84,132,240,191, 77,194,  0, 32, 60,  0,  0, 16,124,  4,  0, 64,
/* 0x0020 */  65,128,  0,  8,124,  4,  3,120, 56,165,  1, 32,124,103, 27,120,
/* 0x0030 */  56, 99,255,252,124,137,  3,166, 72,  0,  0, 28, 85, 96,  2,186,
/* 0x0040 */ 124,  3,  0, 80,124,  0, 58, 20, 80, 11,  1,186,145, 99,  0,  0,
/* 0x0050 */  79, 64,  0, 32,133, 99,  0,  4, 85, 96, 85,190,124,  0, 40, 64,
/* 0x0060 */  65,194,255,220, 67, 32,255,240, 78,128,  0, 32, 56, 33,  0,144,
/* 0x0070 */  57, 32,  0,  0,149, 33,255,252,124, 41, 11,120,125,  8,  2,166,
/* 0x0080 */ 128,159,255,248,124,100,248, 80,128,195,  0, 24, 40,  6,  8,  0,
/* 0x0090 */  65,129,  0,  8, 56,192,  8,  0,124, 61, 11,120,124, 38,  8, 80,
/* 0x00a0 */ 124, 37, 11,120,248, 33,255,113,127,231,251,120, 72,  0,  6,105,
/* 0x00b0 */ 127,161,235,120,128,  3,  0,  0,124,  9,  3,166,128,  3,  0,136,
/* 0x00c0 */ 124, 15,241, 32,128,  3,  0,140,124,  1,  3,166,128,  3,  0,144,
/* 0x00d0 */ 124,  8,  3,166,184,131,  0, 24,128,  3,  0,  8,128, 67,  0, 16,
/* 0x00e0 */ 128, 99,  0, 20, 78,128,  4, 32,124,199, 51,120, 56,192,  0,  0,
/* 0x00f0 */  56,  0,  0,153, 72,  0,  0, 16,125,  9, 67,120, 57,  0,  0,  0,
/* 0x0100 */  56,  0,  0,197, 68,  0,  0,  2, 56, 96,255,255, 78,128,  0, 32,
/* 0x0110 */  56,  0,  0,  1, 75,255,255,240, 56,  0,  0,  3, 75,255,255,232,
/* 0x0120 */  56,  0,  0,  5, 75,255,255,224, 56,  0,  0,  6, 75,255,255,216,
/* 0x0130 */  56,  0,  0, 74, 75,255,255,208,249,193,255,112,249,225,255,120,
/* 0x0140 */ 250,  1,255,128,250, 33,255,136,250, 65,255,144,250, 97,255,152,
/* 0x0150 */ 250,129,255,160,250,161,255,168,250,193,255,176,250,225,255,184,
/* 0x0160 */ 251,  1,255,192,251, 33,255,200,251, 65,255,208,251, 97,255,216,
/* 0x0170 */ 251,129,255,224,251,161,255,232,251,193,255,240,251,225,255,248,
/* 0x0180 */ 248,  1,  0, 16, 78,128,  0, 32,233,193,255,112,233,225,255,120,
/* 0x0190 */ 234,  1,255,128,234, 33,255,136,234, 65,255,144,234, 97,255,152,
/* 0x01a0 */ 234,129,255,160,234,161,255,168,234,193,255,176,234,225,255,184,
/* 0x01b0 */ 235,  1,255,192,235, 33,255,200,235, 65,255,208,235, 97,255,216,
/* 0x01c0 */ 235,129,255,224,232,  1,  0, 16,235,161,255,232,124,  8,  3,166,
/* 0x01d0 */ 235,193,255,240,235,225,255,248, 78,128,  0, 32,233,  3,  0,  8,
/* 0x01e0 */ 233, 67,  0,  0,127,170, 40, 64, 65,220,  0, 40, 57, 37,255,255,
/* 0x01f0 */  57, 72,255,255, 56,132,255,255,125, 40, 74, 20,125, 42, 72, 80,
/* 0x0200 */ 125, 41,  3,166, 47,165,  0,  0, 64,158,  0, 32, 72,  0,  0, 40,
/* 0x0210 */ 124,  8,  2,166,248,  1,  0, 16,248, 33,255,145, 56, 96,  0,127,
/* 0x0220 */  75,255,254,241, 96,  0,  0,  0,141, 42,  0,  1,157, 36,  0,  1,
/* 0x0230 */  66,  0,255,248,233, 35,  0,  8,125, 41, 42, 20,249, 35,  0,  8,
/* 0x0240 */ 233, 35,  0,  0,124,165, 72, 80,248,163,  0,  0, 78,128,  0, 32,
/* 0x0250 */   0,  0,  0,  0,  0,  0,  0,  1,128,  0,  0,  0,124,  8,  2,166,
/* 0x0260 */ 248,  1,  0, 16,125,128,  0, 38,251,129,255,224,251,161,255,232,
/* 0x0270 */ 251,193,255,240,251,225,255,248,145,129,  0,  8,248, 33,255, 97,
/* 0x0280 */ 233, 36,  0,  0, 47,169,  0,  0, 65,158,  1, 92,124,220, 51,120,
/* 0x0290 */ 124,189, 43,120,124,159, 35,120,124,126, 27,120, 46, 38,  0,  0,
/* 0x02a0 */ 127,195,243,120, 56,129,  0,112, 56,160,  0, 12, 75,255,255, 49,
/* 0x02b0 */ 129, 33,  0,112, 47,169,  0,  0, 64,158,  0, 40,129, 33,  0,116,
/* 0x02c0 */  61, 64, 33, 88, 97, 74, 80, 85,127,137, 80,  0, 64,222,  0, 32,
/* 0x02d0 */ 233, 62,  0,  0, 47,169,  0,  0, 65,254,  1, 12, 72,  0,  0, 16,
/* 0x02e0 */ 128,161,  0,116, 47,165,  0,  0, 64,254,  0, 16, 56, 96,  0,127,
/* 0x02f0 */  75,255,254, 33, 96,  0,  0,  0,127,137, 40, 64, 65,220,255,240,
/* 0x0300 */ 233, 95,  0,  0,127,169, 80, 64, 65,221,255,228,127,137, 40, 64,
/* 0x0310 */  64,157,  0,164,145, 33,  0,124,232,126,  0,  8,124,164, 43,120,
/* 0x0320 */ 232,191,  0,  8, 56,193,  0,124,136,225,  0,120,248, 65,  0, 40,
/* 0x0330 */ 233, 61,  0,  0,233,125,  0, 16,125, 41,  3,166,232, 93,  0,  8,
/* 0x0340 */  78,128,  4, 33,232, 65,  0, 40, 47,163,  0,  0, 64,222,255,160,
/* 0x0350 */ 128,129,  0,112,129, 33,  0,124,127,137, 32,  0, 64,222,255,144,
/* 0x0360 */ 136,193,  0,121, 47,166,  0,  0, 65,158,  0, 44, 65,146,  0, 40,
/* 0x0370 */ 232,127,  0,  8,136,161,  0,122,248, 65,  0, 40,233, 60,  0,  0,
/* 0x0380 */ 233,124,  0, 16,125, 41,  3,166,232, 92,  0,  8, 78,128,  4, 33,
/* 0x0390 */ 232, 65,  0, 40,129,  1,  0,116,233, 94,  0,  8,125, 74, 66, 20,
/* 0x03a0 */ 249, 94,  0,  8,233, 62,  0,  0,125, 40, 72, 80,249, 62,  0,  0,
/* 0x03b0 */  72,  0,  0, 16,127,195,243,120,232,159,  0,  8, 75,255,254, 33,
/* 0x03c0 */ 129,  1,  0,112,233, 95,  0,  8,125, 74, 66, 20,249, 95,  0,  8,
/* 0x03d0 */ 233, 63,  0,  0,125, 40, 72, 80,249, 63,  0,  0, 47,169,  0,  0,
/* 0x03e0 */  64,158,254,192, 56, 33,  0,160,232,  1,  0, 16,129,129,  0,  8,
/* 0x03f0 */ 124,  8,  3,166,235,129,255,224,235,161,255,232,235,193,255,240,
/* 0x0400 */ 235,225,255,248,125,144,129, 32, 78,128,  0, 32,  0,  0,  0,  0,
/* 0x0410 */   0,  0,  0,  3,128,  4,  0,  0,124,  8,  2,166,248,  1,  0, 16,
/* 0x0420 */ 125,128,  0, 38,249,225,255,120,250,  1,255,128,250, 33,255,136,
/* 0x0430 */ 250, 65,255,144,250, 97,255,152,250,129,255,160,250,161,255,168,
/* 0x0440 */ 250,193,255,176,250,225,255,184,251,  1,255,192,251, 33,255,200,
/* 0x0450 */ 251, 65,255,208,251, 97,255,216,251,129,255,224,251,161,255,232,
/* 0x0460 */ 251,193,255,240,251,225,255,248,145,129,  0,  8,248, 33,254,241,
/* 0x0470 */ 124,123, 27,120,125, 53, 75,120, 59,227,  0, 28,129, 35,  0, 16,
/* 0x0480 */  47,137,  0,  0, 65,158,  1,140,124,153, 35,120,124,184, 43,120,
/* 0x0490 */ 124,215, 51,120,124,244, 59,120,125, 22, 67,120, 59,160,  0,  0,
/* 0x04a0 */  58, 96,  0,  0, 46, 37,  0,  0, 59, 64,  0,  0, 59,128,  0,  0,
/* 0x04b0 */  58, 64,  0, 18,129, 95,  0,  0, 43,138,  0,  1, 64,158,  1, 12,
/* 0x04c0 */ 129, 63,  0, 36,249, 33,  0,112,130, 63,  0, 24,250, 33,  0,120,
/* 0x04d0 */ 130, 31,  0, 28,126, 17,130, 20,122, 47,  4,228,122, 49,  5, 32,
/* 0x04e0 */ 126, 49, 74, 21, 65,130,  1, 52, 64,146,  0, 16, 47,169,  0,  0,
/* 0x04f0 */  65,158,  1, 64, 72,  0,  1, 48,126,231,187,120, 47,169,  0,  0,
/* 0x0500 */  64,158,  1,100, 56,224,255,255, 72,  0,  1, 92,129, 63,  0, 36,
/* 0x0510 */  47,137,  0,  0, 65,158,  0, 40,129, 63,  0, 32, 47,137,  0,  0,
/* 0x0520 */  64,158,  0,  8,249,244,  0,  0,127,  3,195,120, 56,129,  0,112,
/* 0x0530 */ 126,197,179,120,126,166,171,120, 75,255,253, 37,127,209,  0,208,
/* 0x0540 */ 123,222,  5, 33, 65,130,  0, 24,125, 47,138, 20, 57, 41,255,255,
/* 0x0550 */ 127,201,  3,166,159,137,  0,  1, 66,  0,255,252, 47,177,  0,  0,
/* 0x0560 */  65,158,  0, 44,125,227,123,120,126, 36,139,120,232,191,  0, 46,
/* 0x0570 */  75,255,251,193, 96,  0,  0,  0, 47,163,  0,  0, 65,254,  0, 16,
/* 0x0580 */  56, 96,  0,127, 75,255,251,141, 96,  0,  0,  0,127,222,138, 20,
/* 0x0590 */ 125,239,242, 20,127,176,120, 64, 64,157,  0, 88,125,227,123,120,
/* 0x05a0 */ 124,143,128, 80,128,191,  0, 44, 56,192, 16, 18, 56,224,255,255,
/* 0x05b0 */ 127, 72,211,120, 75,255,251, 69, 96,  0,  0,  0,127,175, 24,  0,
/* 0x05c0 */  65,254,  0, 48, 75,255,255,188, 57, 74,255,252, 43,138,  0,  1,
/* 0x05d0 */  65,157,  0, 32,129, 63,  0,  8, 47,137,  0,  1, 64,158,  0, 20,
/* 0x05e0 */ 129, 63,  0, 12, 47,137,  0, 40, 64,158,  0,  8, 58,127,  0, 16,
/* 0x05f0 */  57, 93,  0,  1,121, 93,  0, 32,129, 63,  0,  4,127,255, 74, 20,
/* 0x0600 */ 129, 59,  0, 16,127,137, 80, 64, 65,157,254,172, 72,  0,  0,156,
/* 0x0610 */  58, 96,  0,  0, 72,  0,  0,148, 64,146,  0,124,127, 94,211,120,
/* 0x0620 */  75,255,255,108,126,231,187,120,126, 70,147,120, 72,  0,  0, 12,
/* 0x0630 */  56,192, 16, 18, 56,224,255,255,129, 31,  0, 32,125,  8,202, 20,
/* 0x0640 */ 125,227,123,120,126, 36,139,120, 56,160,  0,  3,121,  8,  0, 32,
/* 0x0650 */  75,255,250,169, 96,  0,  0,  0,127,175, 24,  0, 65,254,254,224,
/* 0x0660 */  75,255,255, 32,129, 31,  0, 32,125,  8,202, 20,125,227,123,120,
/* 0x0670 */ 126, 36,139,120, 56,160,  0,  3, 56,192, 16, 18,121,  8,  0, 32,
/* 0x0680 */  75,255,250,121, 96,  0,  0,  0,127,175, 24,  0, 65,254,254,128,
/* 0x0690 */  75,255,254,240,129, 63,  0, 36,127, 94,211,120, 47,137,  0,  0,
/* 0x06a0 */  65,158,254,188, 75,255,254,116,126, 99,155,120, 56, 33,  1, 16,
/* 0x06b0 */ 232,  1,  0, 16,129,129,  0,  8,124,  8,  3,166,233,225,255,120,
/* 0x06c0 */ 234,  1,255,128,234, 33,255,136,234, 65,255,144,234, 97,255,152,
/* 0x06d0 */ 234,129,255,160,234,161,255,168,234,193,255,176,234,225,255,184,
/* 0x06e0 */ 235,  1,255,192,235, 33,255,200,235, 65,255,208,235, 97,255,216,
/* 0x06f0 */ 235,129,255,224,235,161,255,232,235,193,255,240,235,225,255,248,
/* 0x0700 */ 125,144,129, 32, 78,128,  0, 32,  0,  0,  0,  0,  0,  0,  0,  3,
/* 0x0710 */ 128, 17,  0,  0,124,  8,  2,166,248,  1,  0, 16,251, 97,255,216,
/* 0x0720 */ 251,129,255,224,251,161,255,232,251,193,255,240,251,225,255,248,
/* 0x0730 */ 248, 33,255, 49,248,129,  1,  8,124,191, 43,120,124,222, 51,120,
/* 0x0740 */ 124,253, 59,120,125, 28, 67,120,125, 59, 75,120, 57, 35,  0, 24,
/* 0x0750 */ 249, 33,  0,120,233, 65,  1,  8, 57, 74,255,232,249, 65,  0,112,
/* 0x0760 */ 248,161,  0,136,129, 35,  0, 24,249, 33,  0,128,233, 65,  0,112,
/* 0x0770 */ 233, 97,  0,120,249, 65,  0,144,249, 97,  0,152, 56, 97,  0,112,
/* 0x0780 */  56,129,  0,128,124,229, 59,120, 56,192,  0,  0, 75,255,250,209,
/* 0x0790 */ 127,227,251,120, 56,128,  0,  0, 56,161,  0,144, 56,192,255,255,
/* 0x07a0 */ 127,103,219,120,127,168,235,120,127,137,227,120, 75,255,252,109,
/* 0x07b0 */ 124,124, 27,120, 57, 63,  0, 28,129, 31,  0, 16, 47,168,  0,  0,
/* 0x07c0 */  65,158,  1, 64,129, 95,  0, 28, 47,138,  0, 14, 65,158,  0, 40,
/* 0x07d0 */  57, 64,  0,  0, 57,  8,255,255,121,  8,  0, 32, 57,  8,  0,  1,
/* 0x07e0 */ 125,  9,  3,166, 72,  0,  1,  8,129,  9,  0,  0, 47,136,  0, 14,
/* 0x07f0 */  64,158,  0,252,232,105,  0,  8,124,105, 26, 20, 56,128,  0,  0,
/* 0x0800 */  56,160,  0,  0, 75,255,249, 29, 96,  0,  0,  0,124,125, 27,120,
/* 0x0810 */  47,131,  0,  0, 65,220,  0, 48, 59,128,  0,  0, 63, 96,202,254,
/* 0x0820 */  99,123,186,190,127,163,235,120,127,228,251,120,127,197,243,120,
/* 0x0830 */ 127,134,227,120, 75,255,248,181, 96,  0,  0,  0,127,190, 24,  0,
/* 0x0840 */  65,254,  0, 16, 56, 96,  0,127, 75,255,248,201, 96,  0,  0,  0,
/* 0x0850 */ 129, 63,  0,  0,127,137,216,  0, 64,158,  0, 96, 57, 63,  0,  8,
/* 0x0860 */ 129, 95,  0,  4, 47,170,  0,  0, 65,158,  0, 80,129, 31,  0,  8,
/* 0x0870 */  47,136,  0, 18, 64,158,  0, 28, 72,  0,  0, 16,129, 73,  0,  0,
/* 0x0880 */  47,138,  0, 18, 64,158,  0, 40,131,137,  0,  8, 75,255,255,152,
/* 0x0890 */  57, 74,255,255,121, 74,  0, 32,121, 72, 23,100,121, 74, 38,228,
/* 0x08a0 */ 125,  8, 82, 20, 57,  8,  0, 28,125, 31, 66, 20, 57, 41,  0, 20,
/* 0x08b0 */ 127,169, 64, 64, 64,158,255,200,127,227,251,120,127,132,227,120,
/* 0x08c0 */  56,160,  0,  0,127,166,235,120, 56,224,  0,  0, 57,  0,  0,  0,
/* 0x08d0 */  57, 32,  0,  0, 75,255,251, 69,124,124, 27,120,127,163,235,120,
/* 0x08e0 */  75,255,248, 73, 96,  0,  0,  0, 72,  0,  0, 24, 57, 74,  0,  1,
/* 0x08f0 */ 121, 74,  0, 32,129,  9,  0,  4,125, 41, 66, 20, 66,  0,254,236,
/* 0x0900 */ 127,131,227,120, 56, 33,  0,208,232,  1,  0, 16,124,  8,  3,166,
/* 0x0910 */ 235, 97,255,216,235,129,255,224,235,161,255,232,235,193,255,240,
/* 0x0920 */ 235,225,255,248, 78,128,  0, 32,  0,  0,  0,  0,  0,  0,  0,  1,
/* 0x0930 */ 128,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0940 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0950 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0960 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0970 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0980 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0990 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0aa0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ab0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ac0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ad0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ae0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0af0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ba0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bc0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0be0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bf0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ca0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0cb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0cc0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0cd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ce0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0cf0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0da0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0db0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0dc0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0dd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0de0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0df0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ea0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0eb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ec0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ed0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ee0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ef0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fa0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fc0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fe0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ff0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1000 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1010 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1020 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1030 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1040 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1050 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1060 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1070 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1080 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1090 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1100 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1110 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1120 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1130 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1140 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1150 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1160 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1170 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1180 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1190 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1200 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1210 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1220 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1230 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1240 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1250 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1260 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1270 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1280 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1290 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1300 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1310 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1320 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1330 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1340 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1350 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1360 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1370 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1380 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1390 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x13a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x13b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x13c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x13d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x13e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x13f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1400 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1410 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1420 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1430 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1440 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1450 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1460 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1470 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1480 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1490 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x14a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x14b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x14c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x14d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x14e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x14f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1500 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1510 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1520 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1530 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1540 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1550 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1560 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1570 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1580 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1590 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x15a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x15b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x15c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x15d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x15e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x15f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1600 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1610 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1620 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1630 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1640 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1650 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1660 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1670 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1680 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1690 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x16a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x16b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x16c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x16d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x16e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x16f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1700 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1710 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1720 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1730 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1740 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1750 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1760 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1770 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1780 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1790 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x17a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x17b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x17c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x17d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x17e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x17f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1800 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1810 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1820 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1830 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1840 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1850 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1860 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1870 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1880 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1890 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1900 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1910 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1920 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1930 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  8,  4,129,220,
/* 0x1940 */   0,  0,  0,  0,  8,  5, 25,  0,  0,  0,  0,  0,  8,  4,130, 92,
/* 0x1950 */   0,  0,  0,  0,  8,  5, 25,  0,  0,  0,  0,  0,  8,  4,132, 24,
/* 0x1960 */   0,  0,  0,  0,  8,  5, 25,  0,  0,  0,  0,  0,  8,  4,135, 20,
/* 0x1970 */   0,  0,  0,  0,  8,  5, 25,  0
};
