/* arm.v5a-linux.elf-entry.h
   created from arm.v5a-linux.elf-entry.bin, 15023 (0x3aaf) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2017 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2017 Laszlo Molnar
   Copyright (C) 2000-2017 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_ARM_V5A_LINUX_ELF_ENTRY_SIZE    15023
#define STUB_ARM_V5A_LINUX_ELF_ENTRY_ADLER32 0x2bde4a99
#define STUB_ARM_V5A_LINUX_ELF_ENTRY_CRC32   0x88e4202b

unsigned char stub_arm_v5a_linux_elf_entry[15023] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 204, 19,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  27,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0040 */   0,  0,  0,  0, 28,192, 79,226,  6, 76,156,232, 12,176,139,224,
/* 0x0050 */  12,160,138,224,  0, 48,155,229,  1,144, 76,224,  3, 16,129,224,
/* 0x0060 */   2,  0,160,225,  1, 26,129,226,  0, 48,160,227,  1, 58,160,227,
/* 0x0070 */  15, 64, 45,233,  7, 32,160,227, 16, 48,156,229,  0, 80,160,227,
/* 0x0080 */   0, 64,224,227, 16, 48,131,227,192,112,160,227,  0,  0,  0,239,
/* 0x0090 */   1, 10,112,227,254,255,255, 42,254,  1,185,232, 10,  0, 89,225,
/* 0x00a0 */ 254,  1,160,232,  8,  0,  0, 58,  9, 64, 64,224, 16, 16,157,229,
/* 0x00b0 */  92, 80,143,226,  4, 16,128,228,  0,224,160,225,  4, 80,133,224,
/* 0x00c0 */   5,  0,160,225,  4, 16,137,224,  0, 32,160,227,  2,112,160,227,
/* 0x00d0 */  15,120,135,227,  0,  0,  0,239,  0,144,156,229,140,144, 73,226,
/* 0x00e0 */   9,160, 76,224,  4,160,138,224,  8,  0,155,229,  1, 64, 45,233,
/* 0x00f0 */   0, 48,155,229, 12,  0,139,226,  4, 16,155,229, 14, 32,160,225,
/* 0x0100 */  16, 48,141,229, 16, 48,141,226, 15,224,160,225,  5,240,160,225,
/* 0x0110 */   2,128,189,232,252, 64, 45,233,  0,112,129,224,  0, 80,224,227,
/* 0x0120 */   2, 65,160,227, 24,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,
/* 0x0130 */   3, 32, 66,224,  0, 32,132,229,  0, 64,160,225,  3,  0,160,225,
/* 0x0140 */   2, 16,131,224,  0, 32,160,227,  7,192,160,225,  2,112,160,227,
/* 0x0150 */  15,120,135,227,  0,  0,  0,239, 12,112,160,225,  4,  0,160,225,
/* 0x0160 */ 240,128,189,232,  1, 64,208,228,  4, 64,164,224,  4, 76,176,225,
/* 0x0170 */  14,240,160,225,  1, 48,208,228,  1, 48,194,228,  4, 64,148,224,
/* 0x0180 */  18,  0,  0, 11, 22,  0,  0, 42,  1, 16,160,227, 33,  0,  0,234,
/* 0x0190 */   1, 16, 65,226,  4, 64,148,224, 18,  0,  0, 11,  1, 16,161,224,
/* 0x01a0 */   4, 64,148,224, 18,  0,  0, 11,  1, 16,161,224,  4, 64,148,224,
/* 0x01b0 */  18,  0,  0, 11, 29,  0,  0, 58,  3, 48, 81,226,  0, 16,160,227,
/* 0x01c0 */  49,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,  5, 80,240,225,
/* 0x01d0 */   3,  0,  0, 10,197, 80,176,225, 64,  0,  0, 42, 52,  0,  0,234,
/* 0x01e0 */   4, 64,148,224, 18,  0,  0, 11, 64,  0,  0, 42,  1, 16,160,227,
/* 0x01f0 */   4, 64,148,224, 18,  0,  0, 11, 64,  0,  0, 42,  4, 64,148,224,
/* 0x0200 */  18,  0,  0, 11,  1, 16,161,224,  4, 64,148,224, 18,  0,  0, 11,
/* 0x0210 */  56,  0,  0, 58,  4, 16,129,226, 68,  0,  0,234,  4, 64,148,224,
/* 0x0220 */  18,  0,  0, 11,  1, 16,161,224,  2, 16,129,226,  5, 12,117,227,
/* 0x0230 */   1, 16,129, 50,  1, 48,130,224,  1, 48, 83,229,  5, 48,210,231,
/* 0x0240 */   1, 48,194,228,  1, 16, 81,226, 72,  0,  0, 26, 24,  0,  0,234,
/* 0x0250 */ 252, 64, 45,233,  0,112,129,224,  0, 80,224,227,  2, 65,160,227,
/* 0x0260 */  24,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,  3, 32, 66,224,
/* 0x0270 */   0, 32,132,229,  0, 64,160,225,  3,  0,160,225,  2, 16,131,224,
/* 0x0280 */   0, 32,160,227,  7,192,160,225,  2,112,160,227, 15,120,135,227,
/* 0x0290 */   0,  0,  0,239, 12,112,160,225,  4,  0,160,225,240,128,189,232,
/* 0x02a0 */   1, 64,208,228,  4, 64,164,224,  4, 76,176,225, 14,240,160,225,
/* 0x02b0 */   1, 48,208,228,  1, 48,194,228,  4, 64,148,224, 18,  0,  0, 11,
/* 0x02c0 */  22,  0,  0, 42,  1, 16,160,227, 33,  0,  0,234,  1, 16, 65,226,
/* 0x02d0 */   4, 64,148,224, 18,  0,  0, 11,  1, 16,177,224,  4, 64,148,224,
/* 0x02e0 */  18,  0,  0, 11,  1, 16,177,224,  4, 64,148,224, 18,  0,  0, 11,
/* 0x02f0 */  29,  0,  0, 58,  3, 48, 81,226,  0, 16,160,227, 48,  0,  0, 58,
/* 0x0300 */   1, 80,208,228,  3, 84,133,225,  5, 80,240,225,  3,  0,  0, 10,
/* 0x0310 */ 197, 80,176,225, 50,  0,  0,234,  4, 64,148,224, 18,  0,  0, 11,
/* 0x0320 */   1, 16,177,224,  4, 64,148,224, 18,  0,  0, 11,  1, 16,177,224,
/* 0x0330 */  63,  0,  0, 26,  1, 16,160,227,  4, 64,148,224, 18,  0,  0, 11,
/* 0x0340 */   1, 16,177,224,  4, 64,148,224, 18,  0,  0, 11, 56,  0,  0, 58,
/* 0x0350 */   2, 16,129,226,  1, 16,129,226,  5, 12,117,227,  1, 16,129, 50,
/* 0x0360 */   0, 48,210,229,  5, 48,210,231,  1, 48,194,228,  1, 16, 81,226,
/* 0x0370 */  67,  0,  0, 26, 24,  0,  0,234,  0, 16,129,224, 62, 64, 45,233,
/* 0x0380 */   0, 80,224,227,  2, 65,160,227, 33,  0,  0,234, 26,  0,189,232,
/* 0x0390 */   1,  0, 64,224,  3, 32, 66,224,  0, 32,132,229,  0, 64,160,225,
/* 0x03a0 */   3,  0,160,225,  2, 16,131,224,  0, 32,160,227,  7,192,160,225,
/* 0x03b0 */   2,112,160,227, 15,120,135,227,  0,  0,  0,239, 12,112,160,225,
/* 0x03c0 */   4,  0,160,225, 48,128,189,232,  4, 64,148,224, 14,240,160, 17,
/* 0x03d0 */   1, 64,208,228,  4, 64,164,224,  4, 76,176,225, 14,240,160,225,
/* 0x03e0 */   1, 16,160,227, 14,192,160,225, 18,  0,  0,235,  1, 16,177,224,
/* 0x03f0 */  18,  0,  0,235, 26,  0,  0, 58, 12,240,160,225,  1, 48,208,228,
/* 0x0400 */   1, 48,194,228, 18,  0,  0,235, 31,  0,  0, 42, 24,  0,  0,235,
/* 0x0410 */   3, 48, 81,226,  0, 16,160,227, 43,  0,  0, 58,  1, 80,208,228,
/* 0x0420 */   3, 84,133,225,  5, 80,240,225,  3,  0,  0, 10, 18,  0,  0,235,
/* 0x0430 */   1, 16,177,224, 18,  0,  0,235,  1, 16,177,224, 50,  0,  0, 26,
/* 0x0440 */  24,  0,  0,235,  2, 16,129,226, 13, 12,117,227,  1, 16,129, 50,
/* 0x0450 */   5, 48,210,231,  1, 16, 81,226,  1, 48,194,228, 52,  0,  0, 42,
/* 0x0460 */  33,  0,  0,234,  0,192,221,229, 14,  0, 92,227,254,255,255, 26,
/* 0x0470 */  12, 72, 45,233,  0,176,208,229,  6,204,160,227,171,177,160,225,
/* 0x0480 */  28,203,160,225, 13,176,160,225, 58,205,140,226, 12,208, 77,224,
/* 0x0490 */   0,192,147,229,  8, 48,141,229,  4,192,141,229,  0, 32,141,229,
/* 0x04a0 */  12, 48,141,226,  0,192,160,227,  4,192,131,228, 11,  0, 83,225,
/* 0x04b0 */  15,  0,  0, 26, 12, 48,141,226,  2, 32, 65,226,  0, 16,160,225,
/* 0x04c0 */   1,192,209,228,  7,192, 12,226, 18,192,205,229,  1,192,209,228,
/* 0x04d0 */  44,  2,160,225, 17,  0,205,229, 15,192, 12,226, 16,192,205,229,
/* 0x04e0 */  16,  0,141,226, 44,  0,  0,235, 11,208,160,225,  0, 48,160,225,
/* 0x04f0 */   3,  0,189,232,  0, 16,145,229,  0, 16,129,224,  0, 32,160,227,
/* 0x0500 */   7,192,160,225,  2,112,160,227, 15,120,135,227,  0,  0,  0,239,
/* 0x0510 */  12,112,160,225,  3,  0,160,225,  0,136,189,232,240, 79, 45,233,
/* 0x0520 */  48,208, 77,226,  0, 48,141,229,  0, 48,208,229,  2, 80,208,229,
/* 0x0530 */   1,224,208,229,  0,192,157,229, 20, 48,141,229, 92, 48,157,229,
/* 0x0540 */   0, 64,160,227,  0, 64,140,229,  0, 64,131,229, 20,192,157,229,
/* 0x0550 */   1, 48,208,229,  3, 48,140,224,  3,204,160,227, 28,195,160,225,
/* 0x0560 */   1, 48,160,227, 19,238,160,225, 19, 53,160,225,115,206,140,226,
/* 0x0570 */   1, 48, 67,226,  1,224, 78,226,  4,  0,128,226,  6,192,140,226,
/* 0x0580 */   4, 16,141,229, 12, 48,141,229, 16,224,141,229,  8,  0,141,229,
/* 0x0590 */  31,  0,  0,234,  8,  0,157,229,  1, 27,160,227,176, 16,131,225,
/* 0x05a0 */  12,  0, 84,225,132, 48,160,225,  1, 64,132,226, 28,  0,  0, 26,
/* 0x05b0 */   4, 48,157,229,  0, 96,160,227,  2,144,131,224,  3,224,160,225,
/* 0x05c0 */   6, 32,160,225,  4, 80,157,229,  9, 48,101,224,  3,  0, 82,225,
/* 0x05d0 */   1,224,142,226, 73,  2,  0, 10,  5, 48,210,231,  1, 32,130,226,
/* 0x05e0 */   5,  0, 82,227,  6,100,131,225, 40,  0,  0, 26,  0,176,160,227,
/* 0x05f0 */   1,192,160,227, 11,112,160,225,  0,  0,224,227, 44,192,141,229,
/* 0x0600 */  24,176,141,229, 28,192,141,229, 32,192,141,229, 36,192,141,229,
/* 0x0610 */  57,  2,  0,234,255,132,224,227,  8,  0, 80,225, 68,  0,  0,138,
/* 0x0620 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  0,  4,160,225,
/* 0x0630 */   6,100,131,225, 12, 16,157,229, 24, 32,157,229,  1,160, 11,224,
/* 0x0640 */   2, 18,160,225,  1, 48,138,224,131, 80,160,225,  8, 48,157,229,
/* 0x0650 */ 181,192,147,225,160, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x0660 */ 185,  0,  0, 42, 20,  0,157,229,  8, 48, 96,226, 87, 51,160,225,
/* 0x0670 */  16, 16,157,229,  1, 32, 11,224, 18, 48,131,224,  8,  0,157,229,
/* 0x0680 */   6, 44,160,227,147,  2, 34,224, 24, 16,157,229,  2, 59,108,226,
/* 0x0690 */   6,  0, 81,227,195, 50,140,224,230,142,130,226,181, 48,128,225,
/* 0x06a0 */  12,128,136,226,  4,  0,160,209,  1, 16,160,211,164,  0,  0,218,
/* 0x06b0 */  44, 32,157,229, 84, 80,157,229, 11, 48, 98,224,  3,112,213,231,
/* 0x06c0 */   4,  0,160,225,  1, 16,160,227,135,112,160,225,  1, 92,  7,226,
/* 0x06d0 */ 129,160,160,225,133, 48,136,224, 10, 48,131,224,  1,  4, 80,227,
/* 0x06e0 */   2, 76,131,226,  1,192,129,226,119,  0,  0, 42,  9,  0, 94,225,
/* 0x06f0 */   0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,
/* 0x0700 */ 176, 48,212,225,160, 37,160,225, 12, 16,129,224,147,  2, 12,224,
/* 0x0710 */   2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,
/* 0x0720 */ 135,  0,  0, 42,  0,  0, 85,227, 12,  0,160,225,176, 32,196,225,
/* 0x0730 */  10, 16,160,225,140,  0,  0, 10, 12,  0,160,225,164,  0,  0,234,
/* 0x0740 */   0,  0, 85,227,176, 48,196,225,  6, 96,108,224,  0,  0,108,224,
/* 0x0750 */ 164,  0,  0, 10,255,  0, 81,227,168,  0,  0,202,105,  0,  0,234,
/* 0x0760 */   1,  4, 80,227,  3, 16,129,224,151,  0,  0, 42,  9,  0, 94,225,
/* 0x0770 */   0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,
/* 0x0780 */ 180, 48,152,225,160, 37,160,225,147,  2, 12,224,  2, 43, 99,226,
/* 0x0790 */  12,  0, 86,225,163, 82, 67,224,194, 50,131,224,180, 48,136, 49,
/* 0x07a0 */ 180, 80,136, 33,  0,  0,108,224,  4, 16,160, 49, 12,  0,160, 49,
/* 0x07b0 */   6, 96,108, 32,255,  0, 81,227,129, 64,160,225,  1, 48,129,226,
/* 0x07c0 */ 143,  0,  0,218, 24,192,157,229,255,112,  1,226,  3,  0, 92,227,
/* 0x07d0 */  84, 16,157,229,  0, 32,160,211, 11,112,193,231,  1,176,139,226,
/* 0x07e0 */  24, 32,141,213, 57,  2,  0,218, 24, 48,157,229,  9,  0, 83,227,
/* 0x07f0 */  24, 80,157,197,  3, 48, 67,210,  6, 80, 69,194, 24, 48,141,213,
/* 0x0800 */  24, 80,141,197, 57,  2,  0,234,172, 50, 76,224,  0, 32,100,224,
/* 0x0810 */   8,192,157,229,  8,  0, 82,225,181, 48,140,225,  6, 96,100,224,
/* 0x0820 */ 197,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0830 */   2, 36,160,225,  6,100,131,225,  8,  0,157,229, 24, 48,157,229,
/* 0x0840 */ 131,112,128,224,  6, 13,135,226,176,192,208,225,162, 53,160,225,
/* 0x0850 */ 156,  3,  4,224,  4,  0, 86,225,225,  0,  0, 42, 24, 32,157,229,
/* 0x0860 */   8, 80,157,229,  6,  0, 82,227,  2, 59,108,226,102, 30,133,226,
/* 0x0870 */   3, 32,160,195, 32, 80,157,229,  0, 32,160,211,195, 50,140,224,
/* 0x0880 */  24, 32,141,229, 28,192,157,229, 44, 32,157,229, 36, 80,141,229,
/* 0x0890 */   4, 16,129,226,  4, 80,160,225, 32,192,141,229, 28, 32,141,229,
/* 0x08a0 */ 176, 48,192,225, 98,  1,  0,234,  2, 32,100,224,172, 50, 76,224,
/* 0x08b0 */   8,  0, 82,225,176, 48,192,225,  6, 96,100,224,236,  0,  0,138,
/* 0x08c0 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,
/* 0x08d0 */   6,100,131,225,102, 95,135,226,176,192,213,225,162, 53,160,225,
/* 0x08e0 */ 156,  3,  4,224,  4,  0, 86,225, 26,  1,  0, 42,  2, 59,108,226,
/* 0x08f0 */ 195, 50,140,224,  8,  0, 84,225,176, 48,197,225,252,  0,  0,138,
/* 0x0900 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  4, 68,160,225,
/* 0x0910 */   6,100,131,225,  8, 80,157,229,129, 48,133,224,138, 48,131,224,
/* 0x0920 */  30, 30,131,226,176,192,209,225,164, 53,160,225,156,  3,  2,224,
/* 0x0930 */   2,  0, 86,225,  6, 96, 98, 32,172, 50, 76, 32,  4, 80, 98, 32,
/* 0x0940 */  50,  1,  0, 42,  2, 59,108,226,195, 50,140,224,  0,  0, 91,227,
/* 0x0950 */ 176, 48,193,225, 73,  2,  0, 10, 44,192,157,229, 24, 16,157,229,
/* 0x0960 */  84,  0,157,229, 11, 48,108,224,  3,112,208,231,  6,  0, 81,227,
/* 0x0970 */  11, 16,160,195,  9, 16,160,211, 24, 16,141,229, 11,112,192,231,
/* 0x0980 */   2,  0,160,225,  1,176,139,226, 57,  2,  0,234,  2, 32,100,224,
/* 0x0990 */ 172, 50, 76,224,  8,  0, 82,225,176, 48,197,225,  6, 96,100,224,
/* 0x09a0 */  37,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x09b0 */   2, 36,160,225,  6,100,131,225, 27, 30,135,226,176,192,209,225,
/* 0x09c0 */ 162, 53,160,225,156,  3,  4,224,  4,  0, 86,225, 52,  1,  0, 42,
/* 0x09d0 */  44, 80,157,229,  2, 59,108,226, 28, 32,157,229,195, 50,140,224,
/* 0x09e0 */  28, 80,141,229,  4, 80,160,225, 44, 32,141,229,176, 48,193,225,
/* 0x09f0 */  90,  1,  0,234,  2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,
/* 0x0a00 */ 176, 48,193,225,  6, 96,100,224, 63,  1,  0,138,  9,  0, 94,225,
/* 0x0a10 */  73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,
/* 0x0a20 */ 114, 31,135,226,176,192,209,225,162, 53,160,225,156,  3,  4,224,
/* 0x0a30 */   4,  0, 86,225, 78,  1,  0, 42,  2, 59,108,226, 32, 32,157,229,
/* 0x0a40 */ 195, 50,140,224, 44,  0,157,229, 28,192,157,229,  4, 80,160,225,
/* 0x0a50 */  32,192,141,229, 28,  0,141,229, 49,  1,  0,234,172, 50, 76,224,
/* 0x0a60 */ 176, 48,193,225, 44,192,157,229, 32, 16,141,226, 10,  0,145,232,
/* 0x0a70 */   2, 80,100,224, 28, 32,157,229, 36, 16,141,229, 32, 32,141,229,
/* 0x0a80 */  28,192,141,229, 44, 48,141,229,  6, 96,100,224, 24, 32,157,229,
/* 0x0a90 */   8,  0,157,229,  6,  0, 82,227, 11, 32,160,195,  8, 32,160,211,
/* 0x0aa0 */ 166, 30,128,226, 24, 32,141,229,  8, 16,129,226,255,116,224,227,
/* 0x0ab0 */   7,  0, 85,225,106,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x0ac0 */   1, 48,222,228,  5, 84,160,225,  6,100,131,225,176,192,209,225,
/* 0x0ad0 */ 165, 53,160,225,156,  3,  4,224,  4,  0, 86,225,120,  1,  0, 42,
/* 0x0ae0 */  10, 34,129,224,  2, 59,108,226,195, 50,140,224,  4, 80,130,226,
/* 0x0af0 */   4,  0,160,225,  3,160,160,227,  0,128,160,227,176, 48,193,225,
/* 0x0b00 */ 152,  1,  0,234,  5, 32,100,224,172, 50, 76,224,  7,  0, 82,225,
/* 0x0b10 */   6, 96,100,224,176, 48,193,225,131,  1,  0,138,  9,  0, 94,225,
/* 0x0b20 */  73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,
/* 0x0b30 */ 178,192,209,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x0b40 */ 145,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,195, 50,140,224,
/* 0x0b50 */  65, 95,130,226,  4,  0,160,225,  3,160,160,227,  8,128,160,227,
/* 0x0b60 */ 178, 48,193,225,152,  1,  0,234,172, 50, 76,224,178, 48,193,225,
/* 0x0b70 */   6, 96,100,224,  2,  0,100,224,129, 95,129,226,  8,160,160,227,
/* 0x0b80 */  16,128,160,227, 10,112,160,225,  1, 16,160,227,  1, 48,129,226,
/* 0x0b90 */   1,  4, 80,227,129, 64,160,225,  3, 16,129,224,164,  1,  0, 42,
/* 0x0ba0 */   9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0bb0 */   6,100,131,225,180, 48,149,225,160, 37,160,225,147,  2, 12,224,
/* 0x0bc0 */   2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,
/* 0x0bd0 */   0,  0,108,224,  4, 16,160, 49, 12,  0,160, 49,180, 32,133, 49,
/* 0x0be0 */   6, 96,108, 32,180, 48,133, 33,  1,112, 87,226,154,  1,  0, 26,
/* 0x0bf0 */   1, 32,160,227, 18, 58, 65,224, 24, 80,157,229,  8, 48,131,224,
/* 0x0c00 */   3,  0, 85,227, 40, 48,141,229, 36,  2,  0,202,  8,192,157,229,
/* 0x0c10 */   3,  0, 83,227,  3, 48,160,163,131, 51,140,224, 54, 94,131,226,
/* 0x0c20 */   2,112,160,225,  6,128,160,227,  1, 48,135,226,  1,  4, 80,227,
/* 0x0c30 */ 135, 64,160,225,  3,112,135,224,203,  1,  0, 42,  9,  0, 94,225,
/* 0x0c40 */   0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,
/* 0x0c50 */ 180, 48,149,225,160, 37,160,225,147,  2, 12,224,  2, 43, 99,226,
/* 0x0c60 */  12,  0, 86,225,194, 34,131,224,163, 50, 67,224,  0,  0,108,224,
/* 0x0c70 */   4,112,160, 49, 12,  0,160, 49,180, 32,133, 49,  6, 96,108, 32,
/* 0x0c80 */ 180, 48,133, 33,  1,128, 88,226,193,  1,  0, 26, 64, 32, 71,226,
/* 0x0c90 */   3,  0, 82,227,  2, 80,160,209, 30,  2,  0,218,194, 64,160,225,
/* 0x0ca0 */  13,  0, 82,227,  1, 48,  2,226,  1,112, 68,226,  2,192,131,227,
/* 0x0cb0 */   5, 64, 68,194,  8, 32,160,193,237,  1,  0,202, 28, 87,160,225,
/* 0x0cc0 */   8, 16,157,229,133, 48,129,224,130, 48, 67,224, 85, 78,131,226,
/* 0x0cd0 */  14, 64,132,226,  1,  2,  0,234,  1,  4, 80,227,  1, 32,130,226,
/* 0x0ce0 */ 245,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x0cf0 */   1, 48,222,228,  6,100,131,225,160,  0,160,225,  0,  0, 86,225,
/* 0x0d00 */ 140,192,160,225,  6, 96, 96, 32,  1,192,140, 35,  4,  0, 82,225,
/* 0x0d10 */ 237,  1,  0, 26,  8, 32,157,229, 25, 77,130,226,  4, 64,132,226,
/* 0x0d20 */  12, 82,160,225,  4,112,160,227,  1,160,160,227, 10,128,160,225,
/* 0x0d30 */   1,  4, 80,227,136, 16,160,225,  1,192,136,226, 12,  2,  0, 42,
/* 0x0d40 */   9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0d50 */   6,100,131,225,177, 48,148,225,160, 37,160,225, 12,128,136,224,
/* 0x0d60 */ 147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,
/* 0x0d70 */ 163, 50, 67,224, 10, 80,133, 33,  1,128,160, 49, 12,  0,160, 49,
/* 0x0d80 */ 177, 32,132, 49,177, 48,132, 33,  6, 96,108, 32,  0,  0,108, 32,
/* 0x0d90 */   1,112, 87,226,138,160,160,225,  3,  2,  0, 26,  1, 80,149,226,
/* 0x0da0 */  44, 80,141,229, 60,  2,  0, 10, 24, 48,157,229,  7, 48,131,226,
/* 0x0db0 */  24, 48,141,229, 44, 80,157,229, 11,  0, 85,225, 73,  2,  0,138,
/* 0x0dc0 */  40,192,157,229, 84, 16,157,229, 11, 48,101,224,  2, 32,140,226,
/* 0x0dd0 */   3, 64,129,224, 11,192,129,224,  1, 32, 82,226, 88, 80,157,229,
/* 0x0de0 */   0, 48,160,  3,  1, 48,160, 19,  1,176,139,226,  5,  0, 91,225,
/* 0x0df0 */   0, 48,160, 35,  1, 48,  3, 50,  1,112,212,228,  0,  0, 83,227,
/* 0x0e00 */   1,112,204,228, 45,  2,  0, 26, 88,192,157,229, 12,  0, 91,225,
/* 0x0e10 */  60,  0,  0, 58,  1,  4, 80,227, 65,  2,  0, 42,  9,  0, 94,225,
/* 0x0e20 */  73,  2,  0, 10,  1,224,142,226,  4,  0,157,229,  0, 16,157,229,
/* 0x0e30 */  92, 32,157,229, 14, 48, 96,224,  0,  0,160,227,  0, 48,129,229,
/* 0x0e40 */   0,176,130,229, 74,  2,  0,234,  1,  0,160,227, 48,208,141,226,
/* 0x0e50 */ 240,143,189,232,248, 79, 45,233,  1,192,130,224, 40,144,157,229,
/* 0x0e60 */  44,112,157,229,  1,128,160,225,  9,160,135,224,  4,176,128,226,
/* 0x0e70 */   0, 96,208,229,  1, 80,208,229,  2, 64,208,229,  6,224,133,224,
/* 0x0e80 */   0,112,224,227, 23, 85,224,225, 23, 68,224,225,  1, 48,160,227,
/* 0x0e90 */   1, 32,160,227,  1, 16,160,227,  1,  0,160,227,255, 95, 45,233,
/* 0x0ea0 */   0, 96,160,227, 28, 96,141,229,  3, 44,160,227, 18, 46,160,225,
/* 0x0eb0 */  54, 32,130,226,  7, 44,130,226, 11, 16,160,225,  1, 11,160,227,
/* 0x0ec0 */   1,  3,128,227,  4,  0,129,228,  2, 32, 82,226, 26,  0,  0,202,
/* 0x0ed0 */   5,  0,136,226,  5,  1,  0,235,  8,  0, 80,225, 30,  0,  0, 26,
/* 0x0ee0 */  36, 48,157,229, 16, 32,157,229,  3, 64, 73,224,  2,  0,  4,224,
/* 0x0ef0 */  44,  0,141,229,  6,  2,128,224,  0, 16,139,226,  9,  1,  0,235,
/* 0x0f00 */  80,  0,  0, 26, 20, 48,157,229, 24, 32,157,229,  4, 48,  3,224,
/* 0x0f10 */  28,  0,221,229, 19, 50,160,225,  8, 32, 98,226, 48, 50,131,224,
/* 0x0f20 */ 108,160,139,226,131, 48,131,224, 14,172,138,226,  1,  0,160,227,
/* 0x0f30 */ 131,164,138,224,  7,  0, 86,227, 69,  0,  0, 58,  0, 16,157,229,
/* 0x0f40 */   1, 80, 89,231,133, 80,160,225,  2, 28,138,226,  1, 76,  5,226,
/* 0x0f50 */ 132, 16,129,224, 11,  1,  0,235,  1, 48,  0,226, 36,  4, 83,225,
/* 0x0f60 */  71,  0,  0, 26,  1, 12, 80,227, 58,  0,  0, 58, 73,  0,  0,234,
/* 0x0f70 */  10, 16,160,225, 11,  1,  0,235,  1, 12, 80,227, 69,  0,  0, 58,
/* 0x0f80 */   6, 48,160,227, 10,  0, 86,227,  3, 48,160, 51,  4,  0, 86,227,
/* 0x0f90 */   6, 48,160, 49,  3, 96, 70,224,112,  0,  0,234,  6, 29,139,226,
/* 0x0fa0 */   8,  1,  0,235, 95,  0,  0, 26,  8, 48,157,229,  4, 32,157,229,
/* 0x0fb0 */   0, 16,157,229, 12, 48,141,229,  8, 32,141,229,  4, 16,141,229,
/* 0x0fc0 */   7,  0, 86,227,  3, 96,160,227,  0, 96,160, 51,100,160,139,226,
/* 0x0fd0 */   6,172,138,226,135,  0,  0,234,102, 31,139,226,  8,  1,  0,235,
/* 0x0fe0 */ 114,  0,  0, 26, 44, 48,157,229, 30, 30,139,226,  6,  2,131,224,
/* 0x0ff0 */   9,  1,  0,235,130,  0,  0, 26,  7,  0, 86,227, 11, 96,160,227,
/* 0x1000 */   9, 96,160, 51, 36, 48,157,229,  0, 16,157,229,  3, 64, 73,224,
/* 0x1010 */   1,  0, 84,225,253,  0,  0, 58,  1,  0, 89,231,  1,  0,201,228,
/* 0x1020 */ 237,  0,  0,234, 27, 30,139,226,  8,  1,  0,235,  4, 64,157,229,
/* 0x1030 */ 127,  0,  0, 10,114, 31,139,226,  8,  1,  0,235,  8, 64,157,229,
/* 0x1040 */ 125,  0,  0, 10,  8, 48,157,229, 12, 64,157,229, 12, 48,141,229,
/* 0x1050 */   4, 48,157,229,  8, 48,141,229,  0, 16,157,229,  0, 64,141,229,
/* 0x1060 */   4, 16,141,229,  7,  0, 86,227, 11, 96,160,227,  8, 96,160, 51,
/* 0x1070 */ 104,160,139,226, 10,172,138,226,  0, 16,138,226, 10,  1,  0,235,
/* 0x1080 */ 144,  0,  0, 26, 44, 48,157,229,  4, 80,138,226,  0, 32,160,227,
/* 0x1090 */   3, 82,133,224,  8, 64,160,227,156,  0,  0,234,  2, 16,138,226,
/* 0x10a0 */  10,  1,  0,235,153,  0,  0, 26, 44, 48,157,229, 65, 95,138,226,
/* 0x10b0 */   8, 32,160,227,  3, 82,133,224,  8, 64,160,227,156,  0,  0,234,
/* 0x10c0 */ 129, 95,138,226, 16, 32,160,227,  1, 76,160,227, 52, 32,141,229,
/* 0x10d0 */   1,  0,160,227,  5, 16,160,225, 11,  1,  0,235,  4, 48, 80,224,
/* 0x10e0 */ 158,  0,  0, 58, 52, 80,157,229,  3, 80,133,224, 52, 80,141,229,
/* 0x10f0 */   0, 16,157,229,  4,  0, 86,227,225,  0,  0, 42,  7, 96,134,226,
/* 0x1100 */   4,  0, 85,227,  3, 80,160, 35,133, 83,139,224, 54, 94,133,226,
/* 0x1110 */   1,  0,160,227, 64, 64,160,227,  5, 16,160,225, 11,  1,  0,235,
/* 0x1120 */   4, 48, 80,224,175,  0,  0, 58, 44, 48,141,229,  4,  0, 83,227,
/* 0x1130 */ 221,  0,  0, 58,163, 64,160,225,  1, 64, 68,226,  1, 16,  3,226,
/* 0x1140 */   2, 16,129,227, 14,  0, 83,227,194,  0,  0, 42, 17, 20,160,225,
/* 0x1150 */  94,160,139,226,  3, 48, 65,224,  5,172,138,226,131,160,138,224,
/* 0x1160 */ 206,  0,  0,234,  4, 64, 68,226,255,  0,  0,235,167,112,160,225,
/* 0x1170 */   7,  0, 92,225,  7,192, 76, 32,  1, 16,161,224,  1, 64, 84,226,
/* 0x1180 */ 195,  0,  0, 26, 68,160,139,226,  6,172,138,226,  1, 18,160,225,
/* 0x1190 */   4, 64,160,227,  0, 16,141,229,  1, 80,160,227,  1,  0,160,227,
/* 0x11a0 */  10, 16,160,225, 11,  1,  0,235,  1,  0, 16,227,216,  0,  0, 10,
/* 0x11b0 */   0, 16,157,229,  5, 16,129,225,  0, 16,141,229,133, 80,160,225,
/* 0x11c0 */   1, 64, 84,226,209,  0,  0, 26,  0, 16,157,229,222,  0,  0,234,
/* 0x11d0 */  44, 16,157,229,  1, 16,145,226,  0, 16,141,229, 52, 80,157,229,
/* 0x11e0 */  36, 48,157,229,  2, 80,133,226,  3, 48, 73,224,  3,  0, 81,225,
/* 0x11f0 */ 253,  0,  0,138, 40, 32,157,229,  1,  0, 89,231,  1,  0,201,228,
/* 0x1200 */   2,  0, 89,225,241,  0,  0, 42,  1, 80, 85,226,231,  0,  0, 26,
/* 0x1210 */  28,  0,205,229, 40, 32,157,229,  2,  0, 89,225, 33,  0,  0, 58,
/* 0x1220 */ 255,  0,  0,235,  0,  0,160,227, 32, 32,157,229,  2, 48, 72,224,
/* 0x1230 */  56, 32,157,229,  0, 48,130,229, 36, 32,157,229,  2, 48, 73,224,
/* 0x1240 */ 104, 32,157,229,  0, 48,130,229, 60,208,141,226,240,143,189,232,
/* 0x1250 */   1,  0,160,227,243,  0,  0,234,  1,  4, 87,227, 14,240,160, 33,
/* 0x1260 */  48, 48,157,229,  7,116,160,225,  8,  0, 83,225,253,  0,  0, 10,
/* 0x1270 */   1, 48,216,228, 12,196,131,225, 14,240,160,225,  6,  0,160,225,
/* 0x1280 */ 128, 16,129,224,  0,  0,160,227,128, 16,129,224,  1,  4, 87,227,
/* 0x1290 */  14, 32,160,225,  1,  1,  0, 59,176, 48,209,225,167,229,160,225,
/* 0x12a0 */ 147, 14, 14,224, 14,  0, 92,225, 14,112,160, 49, 14,112, 71, 32,
/* 0x12b0 */   2,235, 99, 50, 14,192, 76, 32,174, 50,131, 48,163, 50, 67, 32,
/* 0x12c0 */   0,  0,176,224,176, 48,193,225,  2,240,160,225, 30, 32,160,227,
/* 0x12d0 */  20, 16,143,226,  2,  0,160,227,  4,112,160,227,  0,  0,  0,239,
/* 0x12e0 */ 127,  0,160,227,  1,112,160,227,  0,  0,  0,239, 80, 82, 79, 84,
/* 0x12f0 */  95, 69, 88, 69, 67,124, 80, 82, 79, 84, 95, 87, 82, 73, 84, 69,
/* 0x1300 */  32,102, 97,105,108,101,100, 46, 10,  0,102,105,108,101, 32,102,
/* 0x1310 */ 111,114,109, 97,116, 32,101,108,102, 51, 50, 45,108,105,116,116,
/* 0x1320 */ 108,101, 97,114,109, 10, 10, 83,101, 99,116,105,111,110,115, 58,
/* 0x1330 */  10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32,
/* 0x1340 */  32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65,
/* 0x1350 */  32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32,
/* 0x1360 */  32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32,
/* 0x1370 */  32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 69, 76, 70, 77, 65,
/* 0x1380 */  73, 78, 88, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51,
/* 0x1390 */  52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x13a0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 52, 32,
/* 0x13b0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x13c0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x13d0 */  10, 32, 32, 49, 32, 76, 85, 78, 77, 80, 48, 48, 48, 32, 32, 32,
/* 0x13e0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48,
/* 0x13f0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1400 */  32, 48, 48, 48, 48, 48, 48, 54, 56, 32, 32, 50, 42, 42, 48, 32,
/* 0x1410 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x1420 */  78, 76, 89, 10, 32, 32, 50, 32, 76, 85, 78, 77, 80, 48, 48, 49,
/* 0x1430 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32,
/* 0x1440 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1450 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54, 99, 32, 32, 50, 42,
/* 0x1460 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1470 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 69, 76, 70, 77, 65,
/* 0x1480 */  73, 78, 88,117, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 97,
/* 0x1490 */  52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x14a0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 48, 32,
/* 0x14b0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x14c0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x14d0 */  10, 32, 32, 52, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32,
/* 0x14e0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x14f0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1500 */  32, 48, 48, 48, 48, 48, 49, 49, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x1510 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x1520 */  78, 76, 89, 10, 32, 32, 53, 32, 78, 82, 86, 95, 84, 65, 73, 76,
/* 0x1530 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1540 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1550 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 49, 52, 32, 32, 50, 42,
/* 0x1560 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1570 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 78, 82, 86, 50, 69,
/* 0x1580 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 51,
/* 0x1590 */  99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x15a0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 49, 52, 32,
/* 0x15b0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x15c0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x15d0 */  10, 32, 32, 55, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32,
/* 0x15e0 */  32, 32, 32, 48, 48, 48, 48, 48, 49, 50, 56, 32, 32, 48, 48, 48,
/* 0x15f0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1600 */  32, 48, 48, 48, 48, 48, 50, 53, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x1610 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x1620 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 78,
/* 0x1630 */  82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1640 */  48, 48, 48,101, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1650 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1660 */  51, 55, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1670 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x1680 */  79, 78, 76, 89, 10, 32, 32, 57, 32, 76, 90, 77, 65, 95, 69, 76,
/* 0x1690 */  70, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 98, 56, 32,
/* 0x16a0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x16b0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 54, 52, 32, 32, 50,
/* 0x16c0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x16d0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x16e0 */  49, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32,
/* 0x16f0 */  32, 48, 48, 48, 48, 48, 57, 51, 56, 32, 32, 48, 48, 48, 48, 48,
/* 0x1700 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1710 */  48, 48, 48, 48, 53, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1720 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x1730 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 76, 90, 77,
/* 0x1740 */  65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1750 */  52, 55, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1760 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,101, 53,
/* 0x1770 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1780 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1790 */  76, 89, 10, 32, 49, 50, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x17a0 */  48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x17b0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x17c0 */  48, 32, 32, 48, 48, 48, 48, 49, 50, 99, 99, 32, 32, 50, 42, 42,
/* 0x17d0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x17e0 */  68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 69, 76, 70, 77, 65, 73,
/* 0x17f0 */  78, 89, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51,101,
/* 0x1800 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1810 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 50, 99, 99, 32, 32,
/* 0x1820 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1830 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32, 69, 76, 70,
/* 0x1840 */  77, 65, 73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1850 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1860 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 51, 48,
/* 0x1870 */  97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1880 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66,
/* 0x1890 */  79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48,
/* 0x18a0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65,
/* 0x18b0 */  73, 78, 88,117,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76,
/* 0x18c0 */  70, 77, 65, 73, 78, 88,117, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x18d0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69,  9, 48,
/* 0x18e0 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x18f0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x1900 */  82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82,
/* 0x1910 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1920 */  32, 32,100, 32, 32, 78, 82, 86, 50, 66,  9, 48, 48, 48, 48, 48,
/* 0x1930 */  48, 48, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,
/* 0x1940 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x1950 */  69, 76, 70, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x1960 */  90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x1970 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x1980 */  68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x1990 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x19a0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x19b0 */  68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x19c0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x19d0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x19e0 */  68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x19f0 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x1a00 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65,
/* 0x1a10 */  73, 78, 89,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70,
/* 0x1a20 */  77, 65, 73, 78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1a30 */  32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,  9,
/* 0x1a40 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1a50 */  88, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1a60 */ 100, 32, 32, 76, 85, 78, 77, 80, 48, 48, 48,  9, 48, 48, 48, 48,
/* 0x1a70 */  48, 48, 48, 48, 32, 76, 85, 78, 77, 80, 48, 48, 48, 10, 48, 48,
/* 0x1a80 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x1a90 */  85, 78, 77, 80, 48, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1aa0 */  32, 76, 85, 78, 77, 80, 48, 48, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x1ab0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 72,
/* 0x1ac0 */  69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x1ad0 */  95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1ae0 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76,  9,
/* 0x1af0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 84, 65, 73,
/* 0x1b00 */  76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1b10 */ 100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,  9, 48, 48, 48, 48,
/* 0x1b20 */  48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x1b30 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x1b40 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 65, 68,
/* 0x1b50 */  82, 77, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x1b60 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x1b70 */  48, 48, 32, 76, 69, 78, 70, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,
/* 0x1b90 */  48, 48, 48, 48, 48, 48, 48, 32, 67, 80, 82, 48, 10, 48, 48, 48,
/* 0x1ba0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x1bb0 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 70, 76,
/* 0x1bc0 */  71, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32,103, 32, 32, 32, 32,
/* 0x1bd0 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,  9, 48, 48, 48, 48,
/* 0x1be0 */  48, 48, 48, 48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48,
/* 0x1bf0 */  48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86,
/* 0x1c00 */  50, 69,  9, 48, 48, 48, 48, 48, 49, 51, 99, 32,117, 99,108, 95,
/* 0x1c10 */ 110,114,118, 50,101, 95,100,101, 99,111,109,112,114,101,115,115,
/* 0x1c20 */  95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32,
/* 0x1c30 */  32, 32, 70, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 49,
/* 0x1c40 */  50, 56, 32,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,
/* 0x1c50 */ 111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48,
/* 0x1c60 */  48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 66,
/* 0x1c70 */   9, 48, 48, 48, 48, 48, 48,101, 99, 32,117, 99,108, 95,110,114,
/* 0x1c80 */ 118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,
/* 0x1c90 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x1ca0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48,
/* 0x1cb0 */  48, 48, 48, 48, 48, 32, 76,122,109, 97, 68,101, 99,111,100,101,
/* 0x1cc0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x1cd0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48,
/* 0x1ce0 */  48, 48, 48, 32,101,110,100, 95,100,101, 99,111,109,112,114,101,
/* 0x1cf0 */ 115,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32,
/* 0x1d00 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,  9, 48, 48, 48,
/* 0x1d10 */  48, 48, 48, 48, 48, 32, 99,112,114, 48, 10, 10, 82, 69, 76, 79,
/* 0x1d20 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x1d30 */  79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58, 10, 79,
/* 0x1d40 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x1d50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x1d60 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 65,
/* 0x1d70 */  66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 65, 68, 82, 77, 10,
/* 0x1d80 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 65, 82, 77, 95, 65,
/* 0x1d90 */  66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 76, 69, 78, 70, 10,
/* 0x1da0 */  48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95, 65,
/* 0x1db0 */  66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 67, 80, 82, 48, 10,
/* 0x1dc0 */  48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 65, 82, 77, 95, 65,
/* 0x1dd0 */  66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 77, 70, 76, 71, 10,
/* 0x1de0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x1df0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78,
/* 0x1e00 */  88,117, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x1e10 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e20 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 50, 52, 32, 82,
/* 0x1e30 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e40 */  32, 69, 76, 70, 77, 65, 73, 78, 89, 10, 48, 48, 48, 48, 48, 48,
/* 0x1e50 */  51, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1e60 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,117, 10, 10,
/* 0x1e70 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x1e80 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10,
/* 0x1e90 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x1ea0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x1eb0 */  10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x1ec0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x1ed0 */  69, 10, 48, 48, 48, 48, 48, 48, 54, 99, 32, 82, 95, 65, 82, 77,
/* 0x1ee0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1ef0 */  50, 69, 10, 48, 48, 48, 48, 48, 48, 55, 48, 32, 82, 95, 65, 82,
/* 0x1f00 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1f10 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65,
/* 0x1f20 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1f30 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95,
/* 0x1f40 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f50 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82,
/* 0x1f60 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f70 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32,
/* 0x1f80 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1f90 */  32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 97, 48,
/* 0x1fa0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1fb0 */  32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 97,
/* 0x1fc0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1fd0 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1fe0 */  98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1ff0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x2000 */  48, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2010 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x2020 */  48, 48, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2030 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x2040 */  48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2050 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x2060 */  48, 48, 48, 48,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2070 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x2080 */  48, 48, 48, 48, 48,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2090 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x20a0 */  48, 48, 48, 48, 48, 48,101, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x20b0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x20c0 */  10, 48, 48, 48, 48, 48, 48,101, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x20d0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x20e0 */  69, 10, 48, 48, 48, 48, 48, 48,102, 56, 32, 82, 95, 65, 82, 77,
/* 0x20f0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x2100 */  50, 69, 10, 48, 48, 48, 48, 48, 48,102, 99, 32, 82, 95, 65, 82,
/* 0x2110 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2120 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 48, 52, 32, 82, 95, 65,
/* 0x2130 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x2140 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32, 82, 95,
/* 0x2150 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2160 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 51, 52, 32, 82,
/* 0x2170 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2180 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 51, 56, 32,
/* 0x2190 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x21a0 */  32, 32, 78, 82, 86, 50, 69, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x21b0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x21c0 */  91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x21d0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x21e0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x21f0 */  49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2200 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x2210 */  48, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2220 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x2230 */  48, 48, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2240 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x2250 */  48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2260 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x2270 */  48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2280 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x2290 */  48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x22a0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,
/* 0x22b0 */  48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x22c0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,
/* 0x22d0 */  10, 48, 48, 48, 48, 48, 48, 97, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x22e0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x22f0 */  68, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77,
/* 0x2300 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x2310 */  50, 68, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82,
/* 0x2320 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2330 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 65,
/* 0x2340 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x2350 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95,
/* 0x2360 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2370 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,100, 56, 32, 82,
/* 0x2380 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2390 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,101, 48, 32,
/* 0x23a0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x23b0 */  32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,101, 99,
/* 0x23c0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x23d0 */  32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,102,
/* 0x23e0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x23f0 */  32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x2400 */ 102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2410 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x2420 */  49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2430 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x2440 */  48, 49, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2450 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 10, 82, 69,
/* 0x2460 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2470 */  32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70,
/* 0x2480 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x2490 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x24a0 */  48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x24b0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,
/* 0x24c0 */  48, 48, 48, 48, 48, 48, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x24d0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,
/* 0x24e0 */  10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x24f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x2500 */  66, 10, 48, 48, 48, 48, 48, 48, 55, 99, 32, 82, 95, 65, 82, 77,
/* 0x2510 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x2520 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82, 95, 65, 82,
/* 0x2530 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2540 */  86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65,
/* 0x2550 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x2560 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82, 95,
/* 0x2570 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2580 */  78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 97, 48, 32, 82,
/* 0x2590 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x25a0 */  32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32,
/* 0x25b0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x25c0 */  32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98, 52,
/* 0x25d0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x25e0 */  32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98,
/* 0x25f0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2600 */  32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,
/* 0x2610 */  99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2620 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,
/* 0x2630 */  48, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2640 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,
/* 0x2650 */  48, 48,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2660 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x2670 */  48, 48, 48,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2680 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 10, 82,
/* 0x2690 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x26a0 */  83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x26b0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x26c0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x26d0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95,
/* 0x26e0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x26f0 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x2700 */  48, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2710 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x2720 */  10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x2730 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2740 */  95, 69, 76, 70, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x2750 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x2760 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 93, 58, 10, 79, 70, 70,
/* 0x2770 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x2780 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x2790 */  48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x27a0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x27b0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65,
/* 0x27c0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x27d0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x27e0 */  98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x27f0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2800 */  48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2810 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2820 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,102, 52, 32, 82,
/* 0x2830 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2840 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2850 */  48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2860 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2870 */  48, 10, 48, 48, 48, 48, 48, 49, 48, 56, 32, 82, 95, 65, 82, 77,
/* 0x2880 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2890 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 52, 52,
/* 0x28a0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x28b0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x28c0 */  48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x28d0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x28e0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65,
/* 0x28f0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2900 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x2910 */ 100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2920 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2930 */  48, 48, 48, 48, 48, 50, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2940 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2950 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 49, 56, 32, 82,
/* 0x2960 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2970 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2980 */  48, 50, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2990 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x29a0 */  48, 10, 48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65, 82, 77,
/* 0x29b0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x29c0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 51, 99,
/* 0x29d0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x29e0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x29f0 */  48, 48, 48, 50, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2a00 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2a10 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82, 95, 65,
/* 0x2a20 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2a30 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x2a40 */  53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2a50 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2a60 */  48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2a70 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2a80 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56, 32, 82,
/* 0x2a90 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2aa0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2ab0 */  48, 50,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2ac0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2ad0 */  48, 10, 48, 48, 48, 48, 48, 51, 48, 52, 32, 82, 95, 65, 82, 77,
/* 0x2ae0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2af0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 48, 99,
/* 0x2b00 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2b10 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2b20 */  48, 48, 48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2b30 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2b40 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 56, 56, 32, 82, 95, 65,
/* 0x2b50 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2b60 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x2b70 */  97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2b80 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2b90 */  48, 48, 48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2ba0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2bb0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99, 32, 82,
/* 0x2bc0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2bd0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2be0 */  48, 51,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2bf0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2c00 */  48, 10, 48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95, 65, 82, 77,
/* 0x2c10 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2c20 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 50, 52,
/* 0x2c30 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2c40 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2c50 */  48, 48, 48, 52, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2c60 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2c70 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 54, 99, 32, 82, 95, 65,
/* 0x2c80 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2c90 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,
/* 0x2ca0 */  56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2cb0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2cc0 */  48, 48, 48, 48, 48, 52, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2cd0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2ce0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 98, 48, 32, 82,
/* 0x2cf0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2d00 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2d10 */  48, 52,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2d20 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2d30 */  48, 10, 48, 48, 48, 48, 48, 52,101, 99, 32, 82, 95, 65, 82, 77,
/* 0x2d40 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2d50 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,102, 52,
/* 0x2d60 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2d70 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2d80 */  48, 48, 48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2d90 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2da0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 51, 99, 32, 82, 95, 65,
/* 0x2db0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2dc0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,
/* 0x2dd0 */  57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2de0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2df0 */  48, 48, 48, 48, 48, 53, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2e00 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2e10 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 99, 48, 32, 82,
/* 0x2e20 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2e30 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2e40 */  48, 53,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2e50 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2e60 */  48, 10, 48, 48, 48, 48, 48, 53,102, 99, 32, 82, 95, 65, 82, 77,
/* 0x2e70 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2e80 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 48, 52,
/* 0x2e90 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2ea0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2eb0 */  48, 48, 48, 54, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2ec0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2ed0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 52, 56, 32, 82, 95, 65,
/* 0x2ee0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2ef0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,
/* 0x2f00 */  56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2f10 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2f20 */  48, 48, 48, 48, 48, 54, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2f30 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2f40 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,100, 48, 32, 82,
/* 0x2f50 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2f60 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2f70 */  48, 54,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2f80 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2f90 */  48, 10, 48, 48, 48, 48, 48, 55, 49, 99, 32, 82, 95, 65, 82, 77,
/* 0x2fa0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2fb0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 50, 56,
/* 0x2fc0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2fd0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2fe0 */  48, 48, 48, 55, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2ff0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3000 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 55, 99, 32, 82, 95, 65,
/* 0x3010 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3020 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,
/* 0x3030 */  57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3040 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x3050 */  48, 48, 48, 48, 48, 55, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3060 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3070 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 99, 52, 32, 82,
/* 0x3080 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3090 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x30a0 */  48, 55,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x30b0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x30c0 */  48, 10, 48, 48, 48, 48, 48, 55,102, 52, 32, 82, 95, 65, 82, 77,
/* 0x30d0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x30e0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 50, 48,
/* 0x30f0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3100 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x3110 */  48, 48, 48, 56, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3120 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3130 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 55, 99, 32, 82, 95, 65,
/* 0x3140 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3150 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,
/* 0x3160 */  56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3170 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x3180 */  48, 48, 48, 48, 48, 56, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3190 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x31a0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,101, 56, 32, 82,
/* 0x31b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x31c0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x31d0 */  48, 56,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x31e0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x31f0 */  48, 10, 48, 48, 48, 48, 48, 56,102, 99, 32, 82, 95, 65, 82, 77,
/* 0x3200 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3210 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 57, 48, 52,
/* 0x3220 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3230 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x3240 */  48, 48, 48, 57, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3250 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3260 */  67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x3270 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77,
/* 0x3280 */  65, 95, 68, 69, 67, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x3290 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x32a0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x32b0 */  48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x32c0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x32d0 */  10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x32e0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x32f0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 56, 56, 32,
/* 0x3300 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3310 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3320 */  48, 48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3330 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3340 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82,
/* 0x3350 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3360 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,101,
/* 0x3370 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3380 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3390 */  48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x33a0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x33b0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32, 82, 95,
/* 0x33c0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x33d0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x33e0 */  49, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x33f0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3400 */  10, 48, 48, 48, 48, 48, 49, 49, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x3410 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3420 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 50, 48, 32,
/* 0x3430 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3440 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3450 */  48, 48, 49, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3460 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3470 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 52, 52, 32, 82, 95, 65, 82,
/* 0x3480 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3490 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 52,
/* 0x34a0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x34b0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x34c0 */  48, 48, 48, 48, 49, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x34d0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x34e0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 56, 48, 32, 82, 95,
/* 0x34f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3500 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3510 */  49, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3520 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3530 */  10, 48, 48, 48, 48, 48, 49, 56, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x3540 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3550 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 57, 99, 32,
/* 0x3560 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3570 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3580 */  48, 48, 49, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3590 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x35a0 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 99, 48, 32, 82, 95, 65, 82,
/* 0x35b0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x35c0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 99,
/* 0x35d0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x35e0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x35f0 */  48, 48, 48, 48, 49,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3600 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3610 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,100, 99, 32, 82, 95,
/* 0x3620 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3630 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3640 */  49,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3650 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3660 */  10, 48, 48, 48, 48, 48, 49,101, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x3670 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3680 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 50, 56, 32,
/* 0x3690 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x36a0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x36b0 */  48, 48, 50, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x36c0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x36d0 */  49, 48, 10, 48, 48, 48, 48, 48, 50, 52, 52, 32, 82, 95, 65, 82,
/* 0x36e0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x36f0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 52,
/* 0x3700 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3710 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3720 */  48, 48, 48, 48, 50, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3730 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3740 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 54, 56, 32, 82, 95,
/* 0x3750 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3760 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3770 */  50, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3780 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3790 */  10, 48, 48, 48, 48, 48, 50, 56, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x37a0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x37b0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32,
/* 0x37c0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x37d0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x37e0 */  48, 48, 50, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x37f0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3800 */  49, 48, 10, 48, 48, 48, 48, 48, 50,100, 48, 32, 82, 95, 65, 82,
/* 0x3810 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3820 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,100,
/* 0x3830 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3840 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3850 */  48, 48, 48, 48, 50,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3860 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3870 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 48, 99, 32, 82, 95,
/* 0x3880 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3890 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x38a0 */  51, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x38b0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x38c0 */  10, 48, 48, 48, 48, 48, 51, 50, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x38d0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x38e0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 53, 48, 32,
/* 0x38f0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3900 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3910 */  48, 48, 51, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3920 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3930 */  49, 48, 10, 48, 48, 48, 48, 48, 51, 55, 48, 32, 82, 95, 65, 82,
/* 0x3940 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3950 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 55,
/* 0x3960 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3970 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3980 */  48, 48, 48, 48, 51, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3990 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x39a0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 98, 48, 32, 82, 95,
/* 0x39b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x39c0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x39d0 */  51, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x39e0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x39f0 */  10, 48, 48, 48, 48, 48, 51, 99, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x3a00 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3a10 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99, 32,
/* 0x3a20 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3a30 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3a40 */  48, 48, 52, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3a50 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3a60 */  49, 48, 10, 48, 48, 48, 48, 48, 52, 49, 56, 32, 82, 95, 65, 82,
/* 0x3a70 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3a80 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 52,
/* 0x3a90 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3aa0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10
};
