/*
   mmsdef.h

   Base definitions

   Copyright (C) 1996 Free Software Foundation, Inc.

   This file is part of the Windows32 API Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   If you are interested in a warranty or support for this source code,
   contact Scott Christley <scottc@net-community.com> for more information.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   -----------
   DAL 2003 - this file modified extensively for my compiler.  New
   definitionswnwn added as well.
*/
#define AUXCAPS_AUXIN (2)
#define AUXCAPS_CDAUDIO (1)
#define AUXCAPS_LRVOLUME (2)
#define AUXCAPS_VOLUME (1)

#define AUX_MAPPER (UINT) - 1

#define CALLBACK_EVENT (327680)
#define CALLBACK_FUNCTION (196608)
#define CALLBACK_NULL (0)
#define CALLBACK_TASK (131072)
#define CALLBACK_THREAD CALLBACK_TASK
#define CALLBACK_TYPEMASK (458752)
#define CALLBACK_WINDOW (65536)

#define CFSEPCHAR '+'

#define DRVCNF_CANCEL (0)
#define DRVCNF_OK (1)
#define DRVCNF_RESTART (2)

#define DRV_CANCEL DRVCNF_CANCEL
#define DRV_CLOSE (4)
#define DRV_CONFIGURE (7)
#define DRV_DISABLE (5)
#define DRV_ENABLE (2)
#define DRV_EXITSESSION (11)
#define DRV_FREE (6)
#define DRV_INSTALL (9)
#define DRV_LOAD (1)
#define DRV_OK DRVCNF_OK
#define DRV_OPEN (3)
#define DRV_POWER (15)
#define DRV_QUERYCONFIGURE (8)
#define DRV_REMOVE (10)
#define DRV_RESERVED (2048)
#define DRV_RESTART DRVCNF_RESTART
#define DRV_USER (16384)

#define DefDriverProc DrvDefDriverProc

#ifndef FAR
#    define FAR
#endif

#define FOURCC_DOS mmioFOURCC('D', 'O', 'S', ' ')
#define FOURCC_LIST mmioFOURCC('L', 'I', 'S', 'T')
#define FOURCC_MEM mmioFOURCC('M', 'E', 'M', ' ')
#define FOURCC_RIFF mmioFOURCC('R', 'I', 'F', 'F')

#define JOYCAPS_HASPOV (16)
#define JOYCAPS_HASR (2)
#define JOYCAPS_HASU (4)
#define JOYCAPS_HASV (8)
#define JOYCAPS_HASZ (1)
#define JOYCAPS_POV4DIR (32)
#define JOYCAPS_POVCTS (64)

#define JOYERR_BASE (160)
#define JOYERR_NOCANDO JOYERR_BASE + 6
#define JOYERR_NOERROR (0)
#define JOYERR_PARMS JOYERR_BASE + 5
#define JOYERR_UNPLUGGED JOYERR_BASE + 7

#define JOYSTICKID1 (0)

#define JOYSTICKID2 (1)

#define JOY_BUTTON1 (1)
#define JOY_BUTTON10 (512)
#define JOY_BUTTON11 (1024)
#define JOY_BUTTON12 (2048)
#define JOY_BUTTON13 (4096)
#define JOY_BUTTON14 (8192)
#define JOY_BUTTON15 (16384)
#define JOY_BUTTON16 (32768)
#define JOY_BUTTON17 (65536)
#define JOY_BUTTON18 (131072)
#define JOY_BUTTON19 (262144)
#define JOY_BUTTON1CHG (256)
#define JOY_BUTTON2 (2)
#define JOY_BUTTON20 (524288)
#define JOY_BUTTON21 (1048576)
#define JOY_BUTTON22 (2097152)
#define JOY_BUTTON23 (4194304)
#define JOY_BUTTON24 (8388608)
#define JOY_BUTTON25 (16777216)
#define JOY_BUTTON26 (33554432)
#define JOY_BUTTON27 (67108864)
#define JOY_BUTTON28 (134217728)
#define JOY_BUTTON29 (268435456)
#define JOY_BUTTON2CHG (512)
#define JOY_BUTTON3 (4)
#define JOY_BUTTON30 (536870912)
#define JOY_BUTTON31 (1073741824l)
#define JOY_BUTTON32 (2147483647l)
#define JOY_BUTTON3CHG (1024)
#define JOY_BUTTON4 (8)
#define JOY_BUTTON4CHG (2048)
#define JOY_BUTTON5 (16)
#define JOY_BUTTON6 (32)
#define JOY_BUTTON7 (64)
#define JOY_BUTTON8 (128)
#define JOY_BUTTON9 (256)
#define JOY_CAL_READ3 (262144)
#define JOY_CAL_READ4 (524288)
#define JOY_CAL_READ5 (4194304)
#define JOY_CAL_READ6 (8388608)
#define JOY_CAL_READALWAYS (65536)
#define JOY_CAL_READRONLY (33554432)
#define JOY_CAL_READUONLY (67108864)
#define JOY_CAL_READVONLY (134217728)
#define JOY_CAL_READXONLY (1048576)
#define JOY_CAL_READXYONLY (131072)
#define JOY_CAL_READYONLY (2097152)
#define JOY_CAL_READZONLY (16777216)
#define JOY_POVBACKWARD (18000)
#define JOY_POVCENTERED ((WORD)-1)
#define JOY_POVFORWARD (0)
#define JOY_POVLEFT (27000)
#define JOY_POVRIGHT (9000)
// #define JOY_RETURNALL (JOY_RETURNX | JOY_RETURNY | JOY_RETURNZ | \)
#define JOY_RETURNBUTTONS (128)
#define JOY_RETURNCENTERED (1024)
#define JOY_RETURNPOV (64)
#define JOY_RETURNPOVCTS (512)
#define JOY_RETURNR (8)
#define JOY_RETURNRAWDATA (256)
#define JOY_RETURNU (16)
#define JOY_RETURNV (32)
#define JOY_RETURNX (1)
#define JOY_RETURNY (2)
#define JOY_RETURNZ (4)
#define JOY_USEDEADZONE (2048)
#define JOY_RETURNALL \
    (JOY_RETURNX | JOY_RETURNY | JOY_RETURNZ | JOY_RETURNR | JOY_RETURNU | JOY_RETURNV | JOY_RETURNPOV | JOY_RETURNBUTTONS)

#define MAXERRORLENGTH (256)

#define MAXPNAMELEN (32)

#define MAX_JOYSTICKOEMVXDNAME (260)

#define MCIERR_BAD_CONSTANT MCIERR_BASE + 34
#define MCIERR_BAD_INTEGER MCIERR_BASE + 14
#define MCIERR_BAD_TIME_FORMAT MCIERR_BASE + 37
#define MCIERR_BASE (256)
#define MCIERR_CANNOT_LOAD_DRIVER MCIERR_BASE + 10
#define MCIERR_CANNOT_USE_ALL MCIERR_BASE + 23
#define MCIERR_CREATEWINDOW MCIERR_BASE + 91
#define MCIERR_CUSTOM_DRIVER_BASE MCIERR_BASE + 256
#define MCIERR_DEVICE_LENGTH MCIERR_BASE + 54
#define MCIERR_DEVICE_LOCKED MCIERR_BASE + 32
#define MCIERR_DEVICE_NOT_INSTALLED MCIERR_BASE + 50
#define MCIERR_DEVICE_NOT_READY MCIERR_BASE + 20
#define MCIERR_DEVICE_OPEN MCIERR_BASE + 9
#define MCIERR_DEVICE_ORD_LENGTH MCIERR_BASE + 55
#define MCIERR_DEVICE_TYPE_REQUIRED MCIERR_BASE + 31
#define MCIERR_DRIVER MCIERR_BASE + 22
#define MCIERR_DRIVER_INTERNAL MCIERR_BASE + 16
#define MCIERR_DUPLICATE_ALIAS MCIERR_BASE + 33
#define MCIERR_DUPLICATE_FLAGS MCIERR_BASE + 39
#define MCIERR_EXTENSION_NOT_FOUND MCIERR_BASE + 25
#define MCIERR_EXTRA_CHARACTERS MCIERR_BASE + 49
#define MCIERR_FILENAME_REQUIRED MCIERR_BASE + 48
#define MCIERR_FILE_NOT_FOUND MCIERR_BASE + 19
#define MCIERR_FILE_NOT_SAVED MCIERR_BASE + 30
#define MCIERR_FILE_READ MCIERR_BASE + 92
#define MCIERR_FILE_WRITE MCIERR_BASE + 93
#define MCIERR_FLAGS_NOT_COMPATIBLE MCIERR_BASE + 28
#define MCIERR_GET_CD MCIERR_BASE + 51
#define MCIERR_HARDWARE MCIERR_BASE + 6
#define MCIERR_ILLEGAL_FOR_AUTO_OPEN MCIERR_BASE + 47
#define MCIERR_INTERNAL MCIERR_BASE + 21
#define MCIERR_INVALID_DEVICE_ID MCIERR_BASE + 1
#define MCIERR_INVALID_DEVICE_NAME MCIERR_BASE + 7
#define MCIERR_INVALID_FILE MCIERR_BASE + 40
#define MCIERR_MISSING_COMMAND_STRING MCIERR_BASE + 11
#define MCIERR_MISSING_DEVICE_NAME MCIERR_BASE + 36
#define MCIERR_MISSING_PARAMETER MCIERR_BASE + 17
#define MCIERR_MISSING_STRING_ARGUMENT MCIERR_BASE + 13
#define MCIERR_MULTIPLE MCIERR_BASE + 24
#define MCIERR_MUST_USE_SHAREABLE MCIERR_BASE + 35
#define MCIERR_NEW_REQUIRES_ALIAS MCIERR_BASE + 43
#define MCIERR_NONAPPLICABLE_FUNCTION MCIERR_BASE + 46
#define MCIERR_NOTIFY_ON_AUTO_OPEN MCIERR_BASE + 44
#define MCIERR_NO_CLOSING_QUOTE MCIERR_BASE + 38
#define MCIERR_NO_ELEMENT_ALLOWED MCIERR_BASE + 45
#define MCIERR_NO_IDENTITY MCIERR_BASE + 94
#define MCIERR_NO_INTEGER MCIERR_BASE + 56
#define MCIERR_NO_WINDOW MCIERR_BASE + 90
#define MCIERR_NULL_PARAMETER_BLOCK MCIERR_BASE + 41
#define MCIERR_OUTOFRANGE MCIERR_BASE + 26
#define MCIERR_OUT_OF_MEMORY MCIERR_BASE + 8
#define MCIERR_PARAM_OVERFLOW MCIERR_BASE + 12
#define MCIERR_PARSER_INTERNAL MCIERR_BASE + 15
#define MCIERR_SEQ_DIV_INCOMPATIBLE MCIERR_BASE + 80
#define MCIERR_SEQ_NOMIDIPRESENT MCIERR_BASE + 87
#define MCIERR_SEQ_PORTUNSPECIFIED MCIERR_BASE + 86
#define MCIERR_SEQ_PORT_INUSE MCIERR_BASE + 81
#define MCIERR_SEQ_PORT_MAPNODEVICE MCIERR_BASE + 83
#define MCIERR_SEQ_PORT_MISCERROR MCIERR_BASE + 84
#define MCIERR_SEQ_PORT_NONEXISTENT MCIERR_BASE + 82
#define MCIERR_SEQ_TIMER MCIERR_BASE + 85
#define MCIERR_SET_CD MCIERR_BASE + 52
#define MCIERR_SET_DRIVE MCIERR_BASE + 53
#define MCIERR_UNNAMED_RESOURCE MCIERR_BASE + 42
#define MCIERR_UNRECOGNIZED_COMMAND MCIERR_BASE + 5
#define MCIERR_UNRECOGNIZED_KEYWORD MCIERR_BASE + 3
#define MCIERR_UNSUPPORTED_FUNCTION MCIERR_BASE + 18
#define MCIERR_WAVE_INPUTSINUSE MCIERR_BASE + 66
#define MCIERR_WAVE_INPUTSUNSUITABLE MCIERR_BASE + 72
#define MCIERR_WAVE_INPUTUNSPECIFIED MCIERR_BASE + 69
#define MCIERR_WAVE_OUTPUTSINUSE MCIERR_BASE + 64
#define MCIERR_WAVE_OUTPUTSUNSUITABLE MCIERR_BASE + 70
#define MCIERR_WAVE_OUTPUTUNSPECIFIED MCIERR_BASE + 68
#define MCIERR_WAVE_SETINPUTINUSE MCIERR_BASE + 67
#define MCIERR_WAVE_SETINPUTUNSUITABLE MCIERR_BASE + 73
#define MCIERR_WAVE_SETOUTPUTINUSE MCIERR_BASE + 65
#define MCIERR_WAVE_SETOUTPUTUNSUITABLE MCIERR_BASE + 71

#define MCI_ALL_DEVICE_ID MCIDEVICEID - 1
#define MCI_ANIM_GETDEVCAPS_CAN_REVERSE (16385)
#define MCI_ANIM_GETDEVCAPS_CAN_STRETCH (16391)
#define MCI_ANIM_GETDEVCAPS_FAST_RATE (16386)
#define MCI_ANIM_GETDEVCAPS_MAX_WINDOWS (16392)
#define MCI_ANIM_GETDEVCAPS_NORMAL_RATE (16388)
#define MCI_ANIM_GETDEVCAPS_PALETTES (16390)
#define MCI_ANIM_GETDEVCAPS_SLOW_RATE (16387)
#define MCI_ANIM_INFO_TEXT (65536)
#define MCI_ANIM_OPEN_NOSTATIC (262144)
#define MCI_ANIM_OPEN_PARENT (131072)
#define MCI_ANIM_OPEN_WS (65536)
#define MCI_ANIM_PLAY_FAST (262144)
#define MCI_ANIM_PLAY_REVERSE (131072)
#define MCI_ANIM_PLAY_SCAN (1048576)
#define MCI_ANIM_PLAY_SLOW (524288)
#define MCI_ANIM_PLAY_SPEED (65536)
#define MCI_ANIM_PUT_DESTINATION (262144)
#define MCI_ANIM_PUT_SOURCE (131072)
#define MCI_ANIM_REALIZE_BKGD (131072)
#define MCI_ANIM_REALIZE_NORM (65536)
#define MCI_ANIM_RECT (65536)
#define MCI_ANIM_STATUS_FORWARD (16386)
#define MCI_ANIM_STATUS_HPAL (16388)
#define MCI_ANIM_STATUS_HWND (16387)
#define MCI_ANIM_STATUS_SPEED (16385)
#define MCI_ANIM_STATUS_STRETCH (16389)
#define MCI_ANIM_STEP_FRAMES (131072)
#define MCI_ANIM_STEP_REVERSE (65536)
#define MCI_ANIM_UPDATE_HDC (131072)
#define MCI_ANIM_WHERE_DESTINATION (262144)
#define MCI_ANIM_WHERE_SOURCE (131072)
#define MCI_ANIM_WINDOW_DEFAULT (0)
#define MCI_ANIM_WINDOW_DISABLE_STRETCH (2097152)
#define MCI_ANIM_WINDOW_ENABLE_STRETCH (1048576)
#define MCI_ANIM_WINDOW_HWND (65536)
#define MCI_ANIM_WINDOW_STATE (262144)
#define MCI_ANIM_WINDOW_TEXT (524288)
#define MCI_BREAK (2065)
#define MCI_BREAK_HWND (512)
#define MCI_BREAK_KEY (256)
#define MCI_BREAK_OFF (1024)
#define MCI_CDA_STATUS_TYPE_TRACK (16385)
#define MCI_CDA_TRACK_AUDIO MCI_CD_OFFSET + 0
#define MCI_CDA_TRACK_OTHER MCI_CD_OFFSET + 1
#define MCI_CD_OFFSET (1088)
#define MCI_CLOSE (2052)
#define MCI_COPY (2130)
#define MCI_CUE (2096)
#define MCI_CUT (2129)
#define MCI_DELETE (2134)
#define MCI_DEVTYPE_ANIMATION (519)
#define MCI_DEVTYPE_CD_AUDIO (516)
#define MCI_DEVTYPE_DAT (517)
#define MCI_DEVTYPE_DIGITAL_VIDEO (520)
#define MCI_DEVTYPE_OTHER (521)
#define MCI_DEVTYPE_OVERLAY (515)
#define MCI_DEVTYPE_SCANNER (518)
#define MCI_DEVTYPE_SEQUENCER (523)
#define MCI_DEVTYPE_VCR (513)
#define MCI_DEVTYPE_VIDEODISC (514)
#define MCI_DEVTYPE_WAVEFORM_AUDIO (522)
#define MCI_ESCAPE (2053)
#define MCI_FORMAT_BYTES (8)
#define MCI_FORMAT_FRAMES (3)
#define MCI_FORMAT_HMS (1)
#define MCI_FORMAT_MILLISECONDS (0)
#define MCI_FORMAT_MSF (2)
#define MCI_FORMAT_SAMPLES (9)
#define MCI_FORMAT_SMPTE_24 (4)
#define MCI_FORMAT_SMPTE_25 (5)
#define MCI_FORMAT_SMPTE_30 (6)
#define MCI_FORMAT_SMPTE_30DROP (7)
#define MCI_FORMAT_TMSF (10)
#define MCI_FREEZE (2116)
#define MCI_FROM (4)
#define MCI_GETDEVCAPS (2059)
#define MCI_GETDEVCAPS_CAN_EJECT (7)
#define MCI_GETDEVCAPS_CAN_PLAY (8)
#define MCI_GETDEVCAPS_CAN_RECORD (1)
#define MCI_GETDEVCAPS_CAN_SAVE (9)
#define MCI_GETDEVCAPS_COMPOUND_DEVICE (6)
#define MCI_GETDEVCAPS_DEVICE_TYPE (4)
#define MCI_GETDEVCAPS_HAS_AUDIO (2)
#define MCI_GETDEVCAPS_HAS_VIDEO (3)
#define MCI_GETDEVCAPS_ITEM (256)
#define MCI_GETDEVCAPS_USES_FILES (5)
#define MCI_INFO (2058)
#define MCI_INFO_COPYRIGHT (8192)
#define MCI_INFO_FILE (512)
#define MCI_INFO_MEDIA_IDENTITY (2048)
#define MCI_INFO_MEDIA_UPC (1024)
#define MCI_INFO_NAME (4096)
#define MCI_INFO_PRODUCT (256)
#define MCI_LOAD (2128)
#define MCI_LOAD_FILE (256)
#define MCI_MODE_NOT_READY MCI_STRING_OFFSET + 12
#define MCI_MODE_OPEN MCI_STRING_OFFSET + 18
#define MCI_MODE_PAUSE MCI_STRING_OFFSET + 17
#define MCI_MODE_PLAY MCI_STRING_OFFSET + 14
#define MCI_MODE_RECORD MCI_STRING_OFFSET + 15
#define MCI_MODE_SEEK MCI_STRING_OFFSET + 16
#define MCI_MODE_STOP MCI_STRING_OFFSET + 13
#define MCI_NOTIFY (1)
#define MCI_NOTIFY_ABORTED (4)
#define MCI_NOTIFY_FAILURE (8)
#define MCI_NOTIFY_SUCCESSFUL (1)
#define MCI_NOTIFY_SUPERSEDED (2)
#define MCI_OPEN (2051)
#define MCI_OPEN_ALIAS (1024)
#define MCI_OPEN_ELEMENT (512)
#define MCI_OPEN_ELEMENT_ID (2048)
#define MCI_OPEN_SHAREABLE (256)
#define MCI_OPEN_TYPE (8192)
#define MCI_OPEN_TYPE_ID (4096)
#define MCI_OVLY_GETDEVCAPS_CAN_FREEZE (16386)
#define MCI_OVLY_GETDEVCAPS_CAN_STRETCH (16385)
#define MCI_OVLY_GETDEVCAPS_MAX_WINDOWS (16387)
#define MCI_OVLY_INFO_TEXT (65536)
#define MCI_OVLY_OPEN_PARENT (131072)
#define MCI_OVLY_OPEN_WS (65536)
#define MCI_OVLY_PUT_DESTINATION (262144)
#define MCI_OVLY_PUT_FRAME (524288)
#define MCI_OVLY_PUT_SOURCE (131072)
#define MCI_OVLY_PUT_VIDEO (1048576)
#define MCI_OVLY_RECT (65536)
#define MCI_OVLY_STATUS_HWND (16385)
#define MCI_OVLY_STATUS_STRETCH (16386)
#define MCI_OVLY_WHERE_DESTINATION (262144)
#define MCI_OVLY_WHERE_FRAME (524288)
#define MCI_OVLY_WHERE_SOURCE (131072)
#define MCI_OVLY_WHERE_VIDEO (1048576)
#define MCI_OVLY_WINDOW_DEFAULT (0)
#define MCI_OVLY_WINDOW_DISABLE_STRETCH (2097152)
#define MCI_OVLY_WINDOW_ENABLE_STRETCH (1048576)
#define MCI_OVLY_WINDOW_HWND (65536)
#define MCI_OVLY_WINDOW_STATE (262144)
#define MCI_OVLY_WINDOW_TEXT (524288)
#define MCI_PASTE (2131)
#define MCI_PAUSE (2057)
#define MCI_PLAY (2054)
#define MCI_PUT (2114)
#define MCI_REALIZE (2112)
#define MCI_RECORD (2063)
#define MCI_RECORD_INSERT (256)
#define MCI_RECORD_OVERWRITE (512)
#define MCI_RESUME (2133)
#define MCI_SAVE (2067)
#define MCI_SAVE_FILE (256)
#define MCI_SEEK (2055)
#define MCI_SEEK_TO_END (512)
#define MCI_SEEK_TO_START (256)
#define MCI_SEQ_DIV_PPQN (0)
#define MCI_SEQ_DIV_SMPTE_24 (1)
#define MCI_SEQ_DIV_SMPTE_25 (2)
#define MCI_SEQ_DIV_SMPTE_30 (4)
#define MCI_SEQ_DIV_SMPTE_30DROP (3)
#define MCI_SEQ_FILE (16386)
#define MCI_SEQ_FORMAT_SONGPTR (16385)
#define MCI_SEQ_MAPPER (65535)
#define MCI_SEQ_MIDI (16387)
#define MCI_SEQ_NONE (65533)
#define MCI_SEQ_OFFSET (1216)
#define MCI_SEQ_SET_MASTER (524288)
#define MCI_SEQ_SET_OFFSET (16777216)
#define MCI_SEQ_SET_PORT (131072)
#define MCI_SEQ_SET_SLAVE (262144)
#define MCI_SEQ_SET_TEMPO (65536)
#define MCI_SEQ_SMPTE (16388)
#define MCI_SEQ_STATUS_COPYRIGHT (16396)
#define MCI_SEQ_STATUS_DIVTYPE (16394)
#define MCI_SEQ_STATUS_MASTER (16392)
#define MCI_SEQ_STATUS_NAME (16395)
#define MCI_SEQ_STATUS_OFFSET (16393)
#define MCI_SEQ_STATUS_PORT (16387)
#define MCI_SEQ_STATUS_SLAVE (16391)
#define MCI_SEQ_STATUS_TEMPO (16386)
#define MCI_SET (2061)
#define MCI_SET_AUDIO (2048)
#define MCI_SET_AUDIO_ALL (0)
#define MCI_SET_AUDIO_LEFT (1)
#define MCI_SET_AUDIO_RIGHT (2)
#define MCI_SET_DOOR_CLOSED (512)
#define MCI_SET_DOOR_OPEN (256)
#define MCI_SET_OFF (16384)
#define MCI_SET_ON (8192)
#define MCI_SET_TIME_FORMAT (1024)
#define MCI_SET_VIDEO (4096)
#define MCI_SPIN (2060)
#define MCI_STATUS (2068)
#define MCI_STATUS_CURRENT_TRACK (8)
#define MCI_STATUS_ITEM (256)
#define MCI_STATUS_LENGTH (1)
#define MCI_STATUS_MEDIA_PRESENT (5)
#define MCI_STATUS_MODE (4)
#define MCI_STATUS_NUMBER_OF_TRACKS (3)
#define MCI_STATUS_POSITION (2)
#define MCI_STATUS_READY (7)
#define MCI_STATUS_START (512)
#define MCI_STATUS_TIME_FORMAT (6)
#define MCI_STEP (2062)
#define MCI_STOP (2056)
#define MCI_STRING_OFFSET (512)
#define MCI_SYSINFO (2064)
#define MCI_SYSINFO_INSTALLNAME (2048)
#define MCI_SYSINFO_NAME (1024)
#define MCI_SYSINFO_OPEN (512)
#define MCI_SYSINFO_QUANTITY (256)
#define MCI_TO (8)
#define MCI_TRACK (16)
#define MCI_UNFREEZE (2117)
#define MCI_UPDATE (2132)
#define MCI_USER_MESSAGES DRV_MCI_FIRST + 1024
#define MCI_VD_ESCAPE_STRING (256)
#define MCI_VD_FORMAT_TRACK (16385)
#define MCI_VD_GETDEVCAPS_CAN_REVERSE (16386)
#define MCI_VD_GETDEVCAPS_CAV (131072)
#define MCI_VD_GETDEVCAPS_CLV (65536)
#define MCI_VD_GETDEVCAPS_FAST_RATE (16387)
#define MCI_VD_GETDEVCAPS_NORMAL_RATE (16389)
#define MCI_VD_GETDEVCAPS_SLOW_RATE (16388)
#define MCI_VD_MEDIA_CAV MCI_VD_OFFSET + 3
#define MCI_VD_MEDIA_CLV MCI_VD_OFFSET + 2
#define MCI_VD_MEDIA_OTHER MCI_VD_OFFSET + 4
#define MCI_VD_MODE_PARK MCI_VD_OFFSET + 1
#define MCI_VD_OFFSET (1024)
#define MCI_VD_PLAY_FAST (131072)
#define MCI_VD_PLAY_REVERSE (65536)
#define MCI_VD_PLAY_SCAN (524288)
#define MCI_VD_PLAY_SLOW (1048576)
#define MCI_VD_PLAY_SPEED (262144)
#define MCI_VD_SEEK_REVERSE (65536)
#define MCI_VD_SPIN_DOWN (131072)
#define MCI_VD_SPIN_UP (65536)
#define MCI_VD_STATUS_DISC_SIZE (16390)
#define MCI_VD_STATUS_FORWARD (16387)
#define MCI_VD_STATUS_MEDIA_TYPE (16388)
#define MCI_VD_STATUS_SIDE (16389)
#define MCI_VD_STATUS_SPEED (16386)
#define MCI_VD_STEP_FRAMES (65536)
#define MCI_VD_STEP_REVERSE (131072)
#define MCI_WAIT (2)
#define MCI_WAVE_GETDEVCAPS_INPUTS (16385)
#define MCI_WAVE_GETDEVCAPS_OUTPUTS (16386)
#define MCI_WAVE_INPUT (4194304)
#define MCI_WAVE_MAPPER MCI_WAVE_OFFSET + 1
#define MCI_WAVE_OFFSET (1152)
#define MCI_WAVE_OPEN_BUFFER (65536)
#define MCI_WAVE_OUTPUT (8388608)
#define MCI_WAVE_PCM MCI_WAVE_OFFSET + 0
#define MCI_WAVE_SET_ANYINPUT (67108864)
#define MCI_WAVE_SET_ANYOUTPUT (134217728)
#define MCI_WAVE_SET_AVGBYTESPERSEC (524288)
#define MCI_WAVE_SET_BITSPERSAMPLE (2097152)
#define MCI_WAVE_SET_BLOCKALIGN (1048576)
#define MCI_WAVE_SET_CHANNELS (131072)
#define MCI_WAVE_SET_FORMATTAG (65536)
#define MCI_WAVE_SET_SAMPLESPERSEC (262144)
#define MCI_WAVE_STATUS_AVGBYTESPERSEC (16388)
#define MCI_WAVE_STATUS_BITSPERSAMPLE (16390)
#define MCI_WAVE_STATUS_BLOCKALIGN (16389)
#define MCI_WAVE_STATUS_CHANNELS (16386)
#define MCI_WAVE_STATUS_FORMATTAG (16385)
#define MCI_WAVE_STATUS_LEVEL (16391)
#define MCI_WAVE_STATUS_SAMPLESPERSEC (16387)
#define MCI_WHERE (2115)
#define MCI_WINDOW (2113)

#define MEVT_COMMENT BYTE 130
#define MEVT_F_CALLBACK (1073741824)
#define MEVT_F_LONG (2147483647)
#define MEVT_F_SHORT (0)
#define MEVT_LONGMSG BYTE 128
#define MEVT_NOP BYTE 2
#define MEVT_SHORTMSG BYTE 0
#define MEVT_TEMPO BYTE 1
#define MEVT_VERSION BYTE 132

#define MHDR_DONE (1)
#define MHDR_INQUEUE (4)
#define MHDR_ISSTRM (8)
#define MHDR_PREPARED (2)

#define MIDICAPS_CACHE (4)
#define MIDICAPS_LRVOLUME (2)
#define MIDICAPS_STREAM (8)
#define MIDICAPS_VOLUME (1)

#define MIDIERR_BADOPENMODE MIDIERR_BASE + 6
#define MIDIERR_BASE (64)
#define MIDIERR_DONT_CONTINUE MIDIERR_BASE + 7
#define MIDIERR_INVALIDSETUP MIDIERR_BASE + 5
#define MIDIERR_NODEVICE MIDIERR_BASE + 4
#define MIDIERR_NOMAP MIDIERR_BASE + 2
#define MIDIERR_NOTREADY MIDIERR_BASE + 3
#define MIDIERR_STILLPLAYING MIDIERR_BASE + 1
#define MIDIERR_UNPREPARED MIDIERR_BASE + 0

#define MIDIMAPPER (UINT) - 1

#define MIDIPATCHSIZE (128)

#define MIDIPROP_GET (1073741824)
#define MIDIPROP_SET (2147483647)
#define MIDIPROP_TEMPO (2)
#define MIDIPROP_TIMEDIV (1)

#define MIDISTRM_ERROR (-2)

#define MIDI_CACHE_ALL (1)
#define MIDI_CACHE_BESTFIT (2)
#define MIDI_CACHE_QUERY (3)
#define MIDI_IO_STATUS (32)
#define MIDI_MAPPER (UINT) - 1
#define MIDI_UNCACHE (4)

#define MIM_CLOSE MM_MIM_CLOSE
#define MIM_DATA MM_MIM_DATA
#define MIM_ERROR MM_MIM_ERROR
#define MIM_LONGDATA MM_MIM_LONGDATA
#define MIM_LONGERROR MM_MIM_LONGERROR
#define MIM_MOREDATA MM_MIM_MOREDATA
#define MIM_OPEN MM_MIM_OPEN

#define MIXERCONTROL_CONTROLF_DISABLED (2147483647)
#define MIXERCONTROL_CONTROLF_MULTIPLE (2)
#define MIXERCONTROL_CONTROLF_UNIFORM (1)
#define MIXERCONTROL_CONTROLTYPE_BASS MIXERCONTROL_CONTROLTYPE_FADER + 2
#define MIXERCONTROL_CONTROLTYPE_BOOLEAN \
    (MIXERCONTROL_CT_CLASS_SWITCH | MIXERCONTROL_CT_SC_SWITCH_BOOLEAN | MIXERCONTROL_CT_UNITS_BOOLEAN)
#define MIXERCONTROL_CONTROLTYPE_BOOLEANMETER \
    (MIXERCONTROL_CT_CLASS_METER | MIXERCONTROL_CT_SC_METER_POLLED | MIXERCONTROL_CT_UNITS_BOOLEAN)
#define MIXERCONTROL_CONTROLTYPE_BUTTON \
    (MIXERCONTROL_CT_CLASS_SWITCH | MIXERCONTROL_CT_SC_SWITCH_BUTTON | MIXERCONTROL_CT_UNITS_BOOLEAN)
#define MIXERCONTROL_CONTROLTYPE_CUSTOM (MIXERCONTROL_CT_CLASS_CUSTOM | MIXERCONTROL_CT_UNITS_CUSTOM)
#define MIXERCONTROL_CONTROLTYPE_DECIBELS (MIXERCONTROL_CT_CLASS_NUMBER | MIXERCONTROL_CT_UNITS_DECIBELS)
#define MIXERCONTROL_CONTROLTYPE_EQUALIZER MIXERCONTROL_CONTROLTYPE_FADER + 4
#define MIXERCONTROL_CONTROLTYPE_FADER (MIXERCONTROL_CT_CLASS_FADER | MIXERCONTROL_CT_UNITS_UNSIGNED)
#define MIXERCONTROL_CONTROLTYPE_LOUDNESS MIXERCONTROL_CONTROLTYPE_BOOLEAN + 4
#define MIXERCONTROL_CONTROLTYPE_MICROTIME \
    (MIXERCONTROL_CT_CLASS_TIME | MIXERCONTROL_CT_SC_TIME_MICROSECS | MIXERCONTROL_CT_UNITS_UNSIGNED)
#define MIXERCONTROL_CONTROLTYPE_MILLITIME \
    (MIXERCONTROL_CT_CLASS_TIME | MIXERCONTROL_CT_SC_TIME_MILLISECS | MIXERCONTROL_CT_UNITS_UNSIGNED)
#define MIXERCONTROL_CONTROLTYPE_MIXER MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT + 1
#define MIXERCONTROL_CONTROLTYPE_MONO MIXERCONTROL_CONTROLTYPE_BOOLEAN + 3
#define MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT \
    (MIXERCONTROL_CT_CLASS_LIST | MIXERCONTROL_CT_SC_LIST_MULTIPLE | MIXERCONTROL_CT_UNITS_BOOLEAN)
#define MIXERCONTROL_CONTROLTYPE_MUTE MIXERCONTROL_CONTROLTYPE_BOOLEAN + 2
#define MIXERCONTROL_CONTROLTYPE_MUX MIXERCONTROL_CONTROLTYPE_SINGLESELECT + 1
#define MIXERCONTROL_CONTROLTYPE_ONOFF MIXERCONTROL_CONTROLTYPE_BOOLEAN + 1
#define MIXERCONTROL_CONTROLTYPE_PAN MIXERCONTROL_CONTROLTYPE_SLIDER + 1
#define MIXERCONTROL_CONTROLTYPE_PEAKMETER MIXERCONTROL_CONTROLTYPE_SIGNEDMETER + 1
#define MIXERCONTROL_CONTROLTYPE_PERCENT (MIXERCONTROL_CT_CLASS_NUMBER | MIXERCONTROL_CT_UNITS_PERCENT)
#define MIXERCONTROL_CONTROLTYPE_QSOUNDPAN MIXERCONTROL_CONTROLTYPE_SLIDER + 2
#define MIXERCONTROL_CONTROLTYPE_SIGNED (MIXERCONTROL_CT_CLASS_NUMBER | MIXERCONTROL_CT_UNITS_SIGNED)
#define MIXERCONTROL_CONTROLTYPE_SIGNEDMETER \
    (MIXERCONTROL_CT_CLASS_METER | MIXERCONTROL_CT_SC_METER_POLLED | MIXERCONTROL_CT_UNITS_SIGNED)
#define MIXERCONTROL_CONTROLTYPE_SINGLESELECT \
    (MIXERCONTROL_CT_CLASS_LIST | MIXERCONTROL_CT_SC_LIST_SINGLE | MIXERCONTROL_CT_UNITS_BOOLEAN)
#define MIXERCONTROL_CONTROLTYPE_SLIDER (MIXERCONTROL_CT_CLASS_SLIDER | MIXERCONTROL_CT_UNITS_SIGNED)
#define MIXERCONTROL_CONTROLTYPE_STEREOENH MIXERCONTROL_CONTROLTYPE_BOOLEAN + 5
#define MIXERCONTROL_CONTROLTYPE_TREBLE MIXERCONTROL_CONTROLTYPE_FADER + 3
#define MIXERCONTROL_CONTROLTYPE_UNSIGNED (MIXERCONTROL_CT_CLASS_NUMBER | MIXERCONTROL_CT_UNITS_UNSIGNED)
#define MIXERCONTROL_CONTROLTYPE_UNSIGNEDMETER \
    (MIXERCONTROL_CT_CLASS_METER | MIXERCONTROL_CT_SC_METER_POLLED | MIXERCONTROL_CT_UNITS_UNSIGNED)
#define MIXERCONTROL_CONTROLTYPE_VOLUME MIXERCONTROL_CONTROLTYPE_FADER + 1
#define MIXERCONTROL_CT_CLASS_CUSTOM (0)
#define MIXERCONTROL_CT_CLASS_FADER (1342177280)
#define MIXERCONTROL_CT_CLASS_LIST (1879048192)
#define MIXERCONTROL_CT_CLASS_MASK (2147483647)
#define MIXERCONTROL_CT_CLASS_METER (268435456)
#define MIXERCONTROL_CT_CLASS_NUMBER (805306368)
#define MIXERCONTROL_CT_CLASS_SLIDER (1073741824)
#define MIXERCONTROL_CT_CLASS_SWITCH (536870912)
#define MIXERCONTROL_CT_CLASS_TIME (1610612736)
#define MIXERCONTROL_CT_SC_LIST_MULTIPLE (16777216)
#define MIXERCONTROL_CT_SC_LIST_SINGLE (0)
#define MIXERCONTROL_CT_SC_METER_POLLED (0)
#define MIXERCONTROL_CT_SC_SWITCH_BOOLEAN (0)
#define MIXERCONTROL_CT_SC_SWITCH_BUTTON (16777216)
#define MIXERCONTROL_CT_SC_TIME_MICROSECS (0)
#define MIXERCONTROL_CT_SC_TIME_MILLISECS (16777216)
#define MIXERCONTROL_CT_SUBCLASS_MASK (251658240)
#define MIXERCONTROL_CT_UNITS_BOOLEAN (65536)
#define MIXERCONTROL_CT_UNITS_CUSTOM (0)
#define MIXERCONTROL_CT_UNITS_DECIBELS (262144)
#define MIXERCONTROL_CT_UNITS_MASK (16711680)
#define MIXERCONTROL_CT_UNITS_PERCENT (327680)
#define MIXERCONTROL_CT_UNITS_SIGNED (131072)
#define MIXERCONTROL_CT_UNITS_UNSIGNED (196608)

#define MIXERLINE_COMPONENTTYPE_DST_DIGITAL MIXERLINE_COMPONENTTYPE_DST_FIRST + 1
#define MIXERLINE_COMPONENTTYPE_DST_HEADPHONES MIXERLINE_COMPONENTTYPE_DST_FIRST + 5
#define MIXERLINE_COMPONENTTYPE_DST_LINE MIXERLINE_COMPONENTTYPE_DST_FIRST + 2
#define MIXERLINE_COMPONENTTYPE_DST_MONITOR MIXERLINE_COMPONENTTYPE_DST_FIRST + 3
#define MIXERLINE_COMPONENTTYPE_DST_SPEAKERS MIXERLINE_COMPONENTTYPE_DST_FIRST + 4
#define MIXERLINE_COMPONENTTYPE_DST_TELEPHONE MIXERLINE_COMPONENTTYPE_DST_FIRST + 6
#define MIXERLINE_COMPONENTTYPE_DST_UNDEFINED MIXERLINE_COMPONENTTYPE_DST_FIRST + 0
#define MIXERLINE_COMPONENTTYPE_DST_VOICEIN MIXERLINE_COMPONENTTYPE_DST_FIRST + 8
#define MIXERLINE_COMPONENTTYPE_DST_WAVEIN MIXERLINE_COMPONENTTYPE_DST_FIRST + 7
#define MIXERLINE_COMPONENTTYPE_SRC_ANALOG MIXERLINE_COMPONENTTYPE_SRC_FIRST + 10
#define MIXERLINE_COMPONENTTYPE_SRC_AUXILIARY MIXERLINE_COMPONENTTYPE_SRC_FIRST + 9
#define MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC MIXERLINE_COMPONENTTYPE_SRC_FIRST + 5
#define MIXERLINE_COMPONENTTYPE_SRC_DIGITAL MIXERLINE_COMPONENTTYPE_SRC_FIRST + 1
#define MIXERLINE_COMPONENTTYPE_SRC_LINE MIXERLINE_COMPONENTTYPE_SRC_FIRST + 2
#define MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE MIXERLINE_COMPONENTTYPE_SRC_FIRST + 3
#define MIXERLINE_COMPONENTTYPE_SRC_PCSPEAKER MIXERLINE_COMPONENTTYPE_SRC_FIRST + 7
#define MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER MIXERLINE_COMPONENTTYPE_SRC_FIRST + 4
#define MIXERLINE_COMPONENTTYPE_SRC_TELEPHONE MIXERLINE_COMPONENTTYPE_SRC_FIRST + 6
#define MIXERLINE_COMPONENTTYPE_SRC_UNDEFINED MIXERLINE_COMPONENTTYPE_SRC_FIRST + 0
#define MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT MIXERLINE_COMPONENTTYPE_SRC_FIRST + 8
#define MIXERLINE_LINEF_ACTIVE (1)
#define MIXERLINE_LINEF_DISCONNECTED (32768)
#define MIXERLINE_LINEF_SOURCE (2147483647)
#define MIXERLINE_TARGETTYPE_AUX (5)
#define MIXERLINE_TARGETTYPE_MIDIIN (4)
#define MIXERLINE_TARGETTYPE_MIDIOUT (3)
#define MIXERLINE_TARGETTYPE_UNDEFINED (0)
#define MIXERLINE_TARGETTYPE_WAVEIN (2)
#define MIXERLINE_TARGETTYPE_WAVEOUT (1)

#define MIXERR_BASE (1024)
#define MIXERR_INVALCONTROL MIXERR_BASE + 1
#define MIXERR_INVALLINE MIXERR_BASE + 0
#define MIXERR_INVALVALUE MIXERR_BASE + 2

#define MIXER_GETCONTROLDETAILSF_LISTTEXT (1)
#define MIXER_GETCONTROLDETAILSF_QUERYMASK (15)
#define MIXER_GETCONTROLDETAILSF_VALUE (0)
#define MIXER_GETLINECONTROLSF_ALL (0)
#define MIXER_GETLINECONTROLSF_ONEBYID (1)
#define MIXER_GETLINECONTROLSF_ONEBYTYPE (2)
#define MIXER_GETLINECONTROLSF_QUERYMASK (15)
#define MIXER_GETLINEINFOF_COMPONENTTYPE (3)
#define MIXER_GETLINEINFOF_DESTINATION (0)
#define MIXER_GETLINEINFOF_LINEID (2)
#define MIXER_GETLINEINFOF_QUERYMASK (15)
#define MIXER_GETLINEINFOF_SOURCE (1)
#define MIXER_GETLINEINFOF_TARGETTYPE (4)
#define MIXER_LONG_NAME_CHARS (64)
#define MIXER_OBJECTF_AUX (1342177280)
#define MIXER_OBJECTF_HANDLE (2147483647)
#define MIXER_OBJECTF_HMIDIIN (MIXER_OBJECTF_HANDLE | MIXER_OBJECTF_MIDIIN)
#define MIXER_OBJECTF_HMIDIOUT (MIXER_OBJECTF_HANDLE | MIXER_OBJECTF_MIDIOUT)
#define MIXER_OBJECTF_HMIXER (MIXER_OBJECTF_HANDLE | MIXER_OBJECTF_MIXER)
#define MIXER_OBJECTF_HWAVEIN (MIXER_OBJECTF_HANDLE | MIXER_OBJECTF_WAVEIN)
#define MIXER_OBJECTF_HWAVEOUT (MIXER_OBJECTF_HANDLE | MIXER_OBJECTF_WAVEOUT)
#define MIXER_OBJECTF_MIDIIN (1073741824)
#define MIXER_OBJECTF_MIDIOUT (805306368)
#define MIXER_OBJECTF_MIXER (0)
#define MIXER_OBJECTF_WAVEIN (536870912)
#define MIXER_OBJECTF_WAVEOUT (268435456)
#define MIXER_SETCONTROLDETAILSF_CUSTOM (1)
#define MIXER_SETCONTROLDETAILSF_QUERYMASK (15)
#define MIXER_SETCONTROLDETAILSF_VALUE (0)
#define MIXER_SHORT_NAME_CHARS (16)

#define MMIOERR_ACCESSDENIED MMIOERR_BASE + 12
#define MMIOERR_BASE (256)
#define MMIOERR_CANNOTCLOSE MMIOERR_BASE + 4
#define MMIOERR_CANNOTEXPAND MMIOERR_BASE + 8
#define MMIOERR_CANNOTOPEN MMIOERR_BASE + 3
#define MMIOERR_CANNOTREAD MMIOERR_BASE + 5
#define MMIOERR_CANNOTSEEK MMIOERR_BASE + 7
#define MMIOERR_CANNOTWRITE MMIOERR_BASE + 6
#define MMIOERR_CHUNKNOTFOUND MMIOERR_BASE + 9
#define MMIOERR_FILENOTFOUND MMIOERR_BASE + 1
#define MMIOERR_INVALIDFILE MMIOERR_BASE + 16
#define MMIOERR_NETWORKERROR MMIOERR_BASE + 14
#define MMIOERR_OUTOFMEMORY MMIOERR_BASE + 2
#define MMIOERR_PATHNOTFOUND MMIOERR_BASE + 11
#define MMIOERR_SHARINGVIOLATION MMIOERR_BASE + 13
#define MMIOERR_TOOMANYOPENFILES MMIOERR_BASE + 15
#define MMIOERR_UNBUFFERED MMIOERR_BASE + 10

#define MMIOM_CLOSE (4)
#define MMIOM_OPEN (3)
#define MMIOM_READ MMIO_READ
#define MMIOM_RENAME (6)
#define MMIOM_SEEK (2)
#define MMIOM_USER (32768)
#define MMIOM_WRITE MMIO_WRITE
#define MMIOM_WRITEFLUSH (5)

#define MMIO_ALLOCBUF (65536)
#define MMIO_COMPAT (0)
#define MMIO_CREATE (4096)
#define MMIO_CREATELIST (64)
#define MMIO_CREATERIFF (32)
#define MMIO_DEFAULTBUFFER (8192)
#define MMIO_DELETE (512)
#define MMIO_DENYNONE (64)
#define MMIO_DENYREAD (48)
#define MMIO_DENYWRITE (32)
#define MMIO_DIRTY (268435456)
#define MMIO_EMPTYBUF (16)
#define MMIO_EXCLUSIVE (16)
#define MMIO_EXIST (16384)
#define MMIO_FHOPEN (16)
#define MMIO_FINDCHUNK (16)
#define MMIO_FINDLIST (64)
#define MMIO_FINDPROC (262144)
#define MMIO_FINDRIFF (32)
#define MMIO_GETTEMP (131072)
#define MMIO_GLOBALPROC (268435456)
#define MMIO_INSTALLPROC (65536)
#define MMIO_PARSE (256)
#define MMIO_READ (0)
#define MMIO_READWRITE (2)
#define MMIO_REMOVEPROC (131072)
#define MMIO_RWMODE (3)
#define MMIO_SHAREMODE (112)
#define MMIO_TOUPPER (16)
#define MMIO_UNICODEPROC (16777216)
#define MMIO_WRITE (1)

#define MMSYSERR_ALLOCATED MMSYSERR_BASE + 4
#define MMSYSERR_BADDB MMSYSERR_BASE + 14
#define MMSYSERR_BADDEVICEID MMSYSERR_BASE + 2
#define MMSYSERR_BADERRNUM MMSYSERR_BASE + 9
#define MMSYSERR_BASE (0)
#define MMSYSERR_DELETEERROR MMSYSERR_BASE + 18
#define MMSYSERR_ERROR MMSYSERR_BASE + 1
#define MMSYSERR_HANDLEBUSY MMSYSERR_BASE + 12
#define MMSYSERR_INVALFLAG MMSYSERR_BASE + 10
#define MMSYSERR_INVALHANDLE MMSYSERR_BASE + 5
#define MMSYSERR_INVALIDALIAS MMSYSERR_BASE + 13
#define MMSYSERR_INVALPARAM MMSYSERR_BASE + 11
#define MMSYSERR_KEYNOTFOUND MMSYSERR_BASE + 15
#define MMSYSERR_NODRIVER MMSYSERR_BASE + 6
#define MMSYSERR_NODRIVERCB MMSYSERR_BASE + 20
#define MMSYSERR_NOERROR (0)
#define MMSYSERR_NOMEM MMSYSERR_BASE + 7
#define MMSYSERR_NOTENABLED MMSYSERR_BASE + 3
#define MMSYSERR_NOTSUPPORTED MMSYSERR_BASE + 8
#define MMSYSERR_READERROR MMSYSERR_BASE + 16
#define MMSYSERR_VALNOTFOUND MMSYSERR_BASE + 19
#define MMSYSERR_WRITEERROR MMSYSERR_BASE + 17

#define MM_ADLIB (9)
#define MM_JOY1BUTTONDOWN (949)
#define MM_JOY1BUTTONUP (951)
#define MM_JOY1MOVE (928)
#define MM_JOY1ZMOVE (930)
#define MM_JOY2BUTTONDOWN (950)
#define MM_JOY2BUTTONUP (952)
#define MM_JOY2MOVE (929)
#define MM_JOY2ZMOVE (931)
#define MM_MCINOTIFY (953)
#define MM_MICROSOFT (1)
#define MM_MIDI_MAPPER (1)
#define MM_MIM_CLOSE (962)
#define MM_MIM_DATA (963)
#define MM_MIM_ERROR (965)
#define MM_MIM_LONGDATA (964)
#define MM_MIM_LONGERROR (966)
#define MM_MIM_MOREDATA (972)
#define MM_MIM_OPEN (961)
#define MM_MIXM_CONTROL_CHANGE (977)
#define MM_MIXM_LINE_CHANGE (976)
#define MM_MOM_CLOSE (968)
#define MM_MOM_DONE (969)
#define MM_MOM_OPEN (967)
#define MM_MOM_POSITIONCB (970)
#define MM_MPU401_MIDIIN (11)
#define MM_MPU401_MIDIOUT (10)
#define MM_PC_JOYSTICK (12)
#define MM_SNDBLST_MIDIIN (4)
#define MM_SNDBLST_MIDIOUT (3)
#define MM_SNDBLST_SYNTH (5)
#define MM_SNDBLST_WAVEIN (7)
#define MM_SNDBLST_WAVEOUT (6)
#define MM_STREAM_CLOSE (981)
#define MM_STREAM_DONE (982)
#define MM_STREAM_ERROR (983)
#define MM_STREAM_OPEN (980)
#define MM_WAVE_MAPPER (2)
#define MM_WIM_CLOSE (959)
#define MM_WIM_DATA (960)
#define MM_WIM_OPEN (958)
#define MM_WOM_CLOSE (956)
#define MM_WOM_DONE (957)
#define MM_WOM_OPEN (955)

#define MOD_FMSYNTH (4)
#define MOD_MAPPER (5)
#define MOD_MIDIPORT (1)
#define MOD_SQSYNTH (3)
#define MOD_SYNTH (2)

#define MOM_CLOSE MM_MOM_CLOSE
#define MOM_DONE MM_MOM_DONE
#define MOM_OPEN MM_MOM_OPEN
#define MOM_POSITIONCB MM_MOM_POSITIONCB

#define NEAR

#define OutputDebugStr OutputDebugString

#define SEEK_CUR 1
#define SEEK_END 2
#define SEEK_SET 0

#define SELECTDIB (41)

#define sndAlias(ch0, ch1)    (SND_ALIAS_START + (DWORD)(BYTE)(ch0) | ((DWORD)(BYTE)(ch1) << 8)) 
#define SND_ALIAS (65536)
#define SND_ALIAS_ID (1114112)
#define SND_ALIAS_START (0)
#define SND_ALIAS_SYSTEMASTERISK sndAlias('S', '*')
#define SND_ALIAS_SYSTEMDEFAULT sndAlias('S', 'D')
#define SND_ALIAS_SYSTEMEXCLAMATION sndAlias('S', '!')
#define SND_ALIAS_SYSTEMEXIT sndAlias('S', 'E')
#define SND_ALIAS_SYSTEMHAND sndAlias('S', 'H')
#define SND_ALIAS_SYSTEMQUESTION sndAlias('S', '?')
#define SND_ALIAS_SYSTEMSTART sndAlias('S', 'S')
#define SND_ALIAS_SYSTEMWELCOME sndAlias('S', 'W')
#define SND_APPLICATION (128)
#define SND_ASYNC (1)
#define SND_FILENAME (131072)
#define SND_LOOP (8)
#define SND_MEMORY (4)
#define SND_NODEFAULT (2)
#define SND_NOSTOP (16)
#define SND_NOWAIT (8192)
#define SND_PURGE (64)
#define SND_RESOURCE (262148)
#define SND_SYNC (0)

#define TIMERR_BASE (96)
#define TIMERR_NOCANDO TIMERR_BASE + 1
#define TIMERR_NOERROR (0)
#define TIMERR_STRUCT TIMERR_BASE + 33

#define TIME_BYTES (4)
#define TIME_CALLBACK_EVENT_PULSE (32)
#define TIME_CALLBACK_EVENT_SET (16)
#define TIME_CALLBACK_FUNCTION (0)
#define TIME_MIDI (16)
#define TIME_MS (1)
#define TIME_ONESHOT (0)
#define TIME_PERIODIC (1)
#define TIME_SAMPLES (2)
#define TIME_SMPTE (8)
#define TIME_TICKS (32)

#define WAVECAPS_DIRECTSOUND (64)
#define WAVECAPS_LRVOLUME (8)
#define WAVECAPS_PITCH (1)
#define WAVECAPS_PLAYBACKRATE (2)
#define WAVECAPS_SAMPLEACCURATE (32)
#define WAVECAPS_SYNC (16)
#define WAVECAPS_VOLUME (4)

#define WAVERR_BADFORMAT WAVERR_BASE + 0
#define WAVERR_BASE (32)
#define WAVERR_STILLPLAYING WAVERR_BASE + 1
#define WAVERR_SYNC WAVERR_BASE + 3
#define WAVERR_UNPREPARED WAVERR_BASE + 2

#define WAVE_ALLOWSYNC (2)
#define WAVE_FORMAT_1M08 (1)
#define WAVE_FORMAT_1M16 (4)
#define WAVE_FORMAT_1S08 (2)
#define WAVE_FORMAT_1S16 (8)
#define WAVE_FORMAT_2M08 (16)
#define WAVE_FORMAT_2M16 (64)
#define WAVE_FORMAT_2S08 (32)
#define WAVE_FORMAT_2S16 (128)
#define WAVE_FORMAT_4M08 (256)
#define WAVE_FORMAT_4M16 (1024)
#define WAVE_FORMAT_4S08 (512)
#define WAVE_FORMAT_4S16 (2048)
#define WAVE_FORMAT_DIRECT (8)
#define WAVE_FORMAT_DIRECT_QUERY (WAVE_FORMAT_QUERY | WAVE_FORMAT_DIRECT)
#define WAVE_FORMAT_PCM (1)
#define WAVE_FORMAT_QUERY (1)
#define WAVE_INVALIDFORMAT (0)
#define WAVE_MAPPED (4)
#define WAVE_MAPPER (UINT) - 1

#define WHDR_BEGINLOOP (4)
#define WHDR_DONE (1)
#define WHDR_ENDLOOP (8)
#define WHDR_INQUEUE (16)
#define WHDR_PREPARED (2)

#define WIM_CLOSE MM_WIM_CLOSE
#define WIM_DATA MM_WIM_DATA
#define WIM_OPEN MM_WIM_OPEN

#define WINMMAPI DECLSPEC_IMPORT

#define WOM_CLOSE MM_WOM_CLOSE
#define WOM_DONE MM_WOM_DONE
#define WOM_OPEN MM_WOM_OPEN
