#include "InstructionParser.h"
#include "x64Operand.h"
#include "x64Parser.h"

InstructionParser* InstructionParser::GetInstance() { return static_cast<InstructionParser*>(new x64Parser()); }
Coding x64Parser::stateCoding_eot[] = {{Coding::eot}};
Coding x64Parser::stateCoding1_1[] = {
    {CODING_NAME("addr16")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 103, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding1_2[] = {
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding2_1[] = {
    {CODING_NAME("addr32")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 103, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding2_2[] = {
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding3_1[] = {
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding4_1[] = {
    {CODING_NAME("data16")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 102, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding4_2[] = {
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding5_1[] = {
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding5_2[] = {
    {CODING_NAME("data32")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 102, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding6_1[] = {
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding7_1[] = {
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding7_2[] = {
    {CODING_NAME("no64") Coding::illegal},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding8_1[] = {
    {CODING_NAME("only64") Coding::illegal},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding8_2[] = {
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::stateCoding9_1[] = {
    {CODING_NAME("rex")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 4, 4, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding* x64Parser::StateFunc1()
{
    if (stateVars[0] != 16)
    {
        return stateCoding1_1;
    }
    if (stateVars[0] == 16)
    {
        return stateCoding1_2;
    }
    return stateCoding_eot;
}
Coding* x64Parser::StateFunc2()
{
    if (stateVars[0] != 32)
    {
        return stateCoding2_1;
    }
    if (stateVars[0] == 32)
    {
        return stateCoding2_2;
    }
    return stateCoding_eot;
}
Coding* x64Parser::StateFunc3()
{
    if (true)
    {
        return stateCoding3_1;
    }
    return stateCoding_eot;
}
Coding* x64Parser::StateFunc4()
{
    if (stateVars[0] != 16)
    {
        return stateCoding4_1;
    }
    if (stateVars[0] == 16)
    {
        return stateCoding4_2;
    }
    return stateCoding_eot;
}
Coding* x64Parser::StateFunc5()
{
    if (stateVars[0] != 16)
    {
        return stateCoding5_1;
    }
    if (stateVars[0] == 16)
    {
        return stateCoding5_2;
    }
    return stateCoding_eot;
}
Coding* x64Parser::StateFunc6()
{
    if (true)
    {
        return stateCoding6_1;
    }
    return stateCoding_eot;
}
Coding* x64Parser::StateFunc7()
{
    if (stateVars[0] != 64)
    {
        return stateCoding7_1;
    }
    if (stateVars[0] == 64)
    {
        return stateCoding7_2;
    }
    return stateCoding_eot;
}
Coding* x64Parser::StateFunc8()
{
    if (stateVars[0] != 64)
    {
        return stateCoding8_1;
    }
    if (stateVars[0] == 64)
    {
        return stateCoding8_2;
    }
    return stateCoding_eot;
}
Coding* x64Parser::StateFunc9()
{
    if (true)
    {
        return stateCoding9_1;
    }
    return stateCoding_eot;
}
x64Parser::StateFuncDispatchType x64Parser::stateFuncs[] = {
    &x64Parser::StateFunc1, &x64Parser::StateFunc2, &x64Parser::StateFunc3, &x64Parser::StateFunc4, &x64Parser::StateFunc5,
    &x64Parser::StateFunc6, &x64Parser::StateFunc7, &x64Parser::StateFunc8, &x64Parser::StateFunc9,
};
bool x64Parser::Number1(int tokenPos)
{
    bool rv = false;
    if (!rv)
    {
        rv = ParseNumber(0, 1, 8, 1, tokenPos);
    }
    return rv;
}
bool x64Parser::Number2(int tokenPos)
{
    bool rv = false;
    if (!rv)
    {
        rv = ParseNumber(0, 1, 8, 1, tokenPos);
    }
    return rv;
}
bool x64Parser::Number3(int tokenPos)
{
    bool rv = false;
    if (!rv)
    {
        rv = ParseNumber(0, 0, 6, 1, tokenPos);
    }
    return rv;
}
bool x64Parser::Number4(int tokenPos)
{
    bool rv = false;
    if (!rv)
    {
        rv = ParseNumber(0, 0, 8, 1, tokenPos);
    }
    return rv;
}
bool x64Parser::Number5(int tokenPos)
{
    bool rv = false;
    if (!rv)
    {
        rv = ParseNumber(0, 0, 16, 0, tokenPos);
    }
    return rv;
}
bool x64Parser::Number6(int tokenPos)
{
    bool rv = false;
    if (!rv)
    {
        rv = ParseNumber(0, 0, 32, 0, tokenPos);
    }
    return rv;
}
bool x64Parser::Number7(int tokenPos)
{
    bool rv = false;
    if (!rv && stateVars[0] == 16)
    {
        rv = ParseNumber(0, 0, 16, 0, tokenPos);
    }
    return rv;
}
bool x64Parser::Number8(int tokenPos)
{
    bool rv = false;
    if (!rv && stateVars[0] == 32)
    {
        rv = ParseNumber(0, 0, 32, 0, tokenPos);
    }
    return rv;
}
bool x64Parser::Number9(int tokenPos)
{
    bool rv = false;
    if (!rv && stateVars[0] == 64)
    {
        rv = ParseNumber(0, 0, 32, 0, tokenPos);
    }
    return rv;
}
bool x64Parser::Number10(int tokenPos)
{
    bool rv = false;
    if (!rv)
    {
        rv = ParseNumber(1, 1, 8, 0, tokenPos);
    }
    return rv;
}
bool x64Parser::Number11(int tokenPos)
{
    bool rv = false;
    if (!rv)
    {
        rv = ParseNumber(-1, 1, 8, 0, tokenPos);
    }
    return rv;
}
bool x64Parser::Number12(int tokenPos)
{
    bool rv = false;
    if (!rv && stateVars[0] == 16)
    {
        rv = ParseNumber(2, 1, 16, 0, tokenPos);
    }
    return rv;
}
bool x64Parser::Number13(int tokenPos)
{
    bool rv = false;
    if (!rv && stateVars[0] == 16)
    {
        rv = ParseNumber(-2, 1, 16, 0, tokenPos);
    }
    return rv;
}
bool x64Parser::Number14(int tokenPos)
{
    bool rv = false;
    if (!rv && stateVars[0] == 16)
    {
        rv = ParseNumber(2, 1, 16, 0, tokenPos);
    }
    return rv;
}
bool x64Parser::Number15(int tokenPos)
{
    bool rv = false;
    if (!rv && stateVars[0] == 16)
    {
        rv = ParseNumber(-2, 1, 16, 0, tokenPos);
    }
    return rv;
}
bool x64Parser::Number16(int tokenPos)
{
    bool rv = false;
    if (!rv && stateVars[0] != 16)
    {
        rv = ParseNumber(4, 1, 32, 0, tokenPos);
    }
    return rv;
}
bool x64Parser::Number17(int tokenPos)
{
    bool rv = false;
    if (!rv)
        rv = SetNumber(tokenPos, 1, 0);
    if (!rv)
        rv = SetNumber(tokenPos, 2, 1);
    if (!rv)
        rv = SetNumber(tokenPos, 4, 2);
    if (!rv)
        rv = SetNumber(tokenPos, 8, 3);
    return rv;
}
bool x64Parser::Number18(int tokenPos)
{
    bool rv = false;
    if (!rv)
        rv = SetNumber(tokenPos, 0, 0);
    return rv;
}
bool x64Parser::Number19(int tokenPos)
{
    bool rv = false;
    if (!rv)
        rv = SetNumber(tokenPos, 1, 1);
    return rv;
}
bool x64Parser::Number20(int tokenPos)
{
    bool rv = false;
    if (!rv)
        rv = SetNumber(tokenPos, 2, 2);
    return rv;
}
bool x64Parser::Number21(int tokenPos)
{
    bool rv = false;
    if (!rv)
        rv = SetNumber(tokenPos, 4, 4);
    return rv;
}
bool x64Parser::Number22(int tokenPos)
{
    bool rv = false;
    if (!rv)
        rv = SetNumber(tokenPos, 8, 8);
    return rv;
}
x64Parser::NumberDispatchType x64Parser::numberFuncs[] = {
    &x64Parser::Number1,  &x64Parser::Number2,  &x64Parser::Number3,  &x64Parser::Number4,  &x64Parser::Number5,
    &x64Parser::Number6,  &x64Parser::Number7,  &x64Parser::Number8,  &x64Parser::Number9,  &x64Parser::Number10,
    &x64Parser::Number11, &x64Parser::Number12, &x64Parser::Number13, &x64Parser::Number14, &x64Parser::Number15,
    &x64Parser::Number16, &x64Parser::Number17, &x64Parser::Number18, &x64Parser::Number19, &x64Parser::Number20,
    &x64Parser::Number21, &x64Parser::Number22,
};

unsigned char x64Parser::RegClassData1[] = {
    255,
    15,
    0,
    0,
};
unsigned char x64Parser::RegClassData2[] = {
    127,
    0,
    0,
    0,
};
unsigned char x64Parser::RegClassData3[] = {
    190,
    15,
    0,
    0,
};
unsigned char x64Parser::RegClassData4[] = {
    63,
    7,
    0,
    0,
};
unsigned char x64Parser::RegClassData5[] = {
    191,
    12,
    0,
    0,
};
unsigned char x64Parser::RegClassData6[] = {
    4,
    16,
    0,
    0,
};
unsigned char x64Parser::RegClassData7[] = {
    8,
    96,
    0,
    0,
};
unsigned char x64Parser::RegClassData8[] = {
    8,
    224,
    0,
    0,
};
unsigned char x64Parser::RegClassData9[] = {
    16,
    0,
    3,
    0,
};
unsigned char x64Parser::RegClassData10[] = {
    32,
    0,
    12,
    0,
};
unsigned char x64Parser::RegClassData11[] = {
    128,
    0,
    48,
    0,
};
unsigned char x64Parser::RegClassData12[] = {
    0,
    1,
    192,
    1,
};
unsigned char x64Parser::RegClassData13[] = {
    0,
    2,
    0,
    14,
};

unsigned char x64Parser::registerData17[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData13[] = {
    0, 0, 0, 32, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData6[] = {
    136, 16, 33, 66, 68, 68, 68, 68, 4, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData9[] = {
    16, 33, 66, 132, 136, 136, 136, 136, 8, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData22[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 7, 0, 0,
};
unsigned char x64Parser::registerData23[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 7, 0,
};
unsigned char x64Parser::registerData21[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 7, 0, 0, 0,
};
unsigned char x64Parser::registerData1[] = {
    255, 255, 255, 255, 15, 0, 240, 255, 15, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData4[] = {
    2, 4, 8, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData16[] = {
    0, 0, 0, 0, 0, 0, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData7[] = {
    136, 16, 33, 66, 4, 68, 68, 68, 4, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData10[] = {
    16, 33, 66, 132, 8, 136, 136, 136, 8, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData3[] = {
    33, 66, 132, 8, 17, 17, 17, 17, 1, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData12[] = {
    0, 0, 0, 120, 0, 0, 96, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData5[] = {
    68, 136, 16, 33, 34, 34, 34, 34, 2, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData8[] = {
    136, 16, 33, 66, 68, 68, 68, 68, 4, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData11[] = {
    16, 33, 66, 132, 136, 136, 136, 136, 8, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData2[] = {
    35, 70, 140, 24, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData15[] = {
    0, 0, 0, 0, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData19[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 32, 73, 146, 4, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData18[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 224, 255, 255, 31, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData20[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 7, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData14[] = {
    0, 0, 0, 0, 240, 255, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};
unsigned char x64Parser::registerData24[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 7,
};

unsigned char* x64Parser::registerDataIndirect[] = {
    registerData1,  registerData2,  registerData3,  registerData4,  registerData5,  registerData6,  registerData7,  registerData8,
    registerData9,  registerData10, registerData11, registerData12, registerData13, registerData14, registerData15, registerData16,
    registerData17, registerData18, registerData19, registerData20, registerData21, registerData22, registerData23, registerData24,
};

int x64Parser::registerValues[][8] = {
    {
        0,
        0,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        4,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        0,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        0,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        0,
        0,
        8,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        0,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        0,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        0,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        0,
        4,
        8,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        1,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        5,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        1,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        1,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        1,
        0,
        8,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        1,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        1,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        1,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        1,
        4,
        8,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        2,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        6,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        2,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        2,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        2,
        0,
        8,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        2,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        2,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        2,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        2,
        4,
        8,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        3,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        7,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        3,
        0,
        0,
        0,
        0,
        -1,
        -1,
    },
    {
        0,
        3,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        3,
        0,
        8,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        3,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        3,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        3,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        3,
        4,
        8,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        4,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        4,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        4,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        4,
        0,
        8,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        4,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        4,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        4,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        4,
        4,
        8,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        5,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        5,
        0,
        0,
        0,
        1,
        -1,
        -1,
    },
    {
        0,
        5,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        5,
        0,
        8,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        5,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        5,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        5,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        5,
        4,
        8,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        6,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        6,
        0,
        0,
        0,
        -1,
        0,
        -1,
    },
    {
        0,
        6,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        6,
        0,
        8,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        6,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        6,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        6,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        6,
        4,
        8,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        7,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        7,
        0,
        0,
        0,
        -1,
        1,
        -1,
    },
    {
        0,
        7,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        7,
        0,
        8,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        7,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        7,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        7,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        1,
        7,
        4,
        8,
        2,
        -1,
        -1,
        -1,
    },
    {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        0,
        0,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        0,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        0,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        1,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        1,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        1,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        2,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        2,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        2,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        3,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        3,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        3,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        4,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        4,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        4,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        5,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        5,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        5,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        6,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        6,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        6,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        0,
        7,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        0,
        7,
        0,
        0,
        0,
        -1,
        -1,
        -1,
    },
    {
        1,
        7,
        4,
        0,
        2,
        -1,
        -1,
        -1,
    },
    {
        -1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        38,
    },
    {
        -1,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        46,
    },
    {
        -1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        54,
    },
    {
        -1,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        62,
    },
    {
        -1,
        4,
        -1,
        -1,
        -1,
        -1,
        -1,
        100,
    },
    {
        -1,
        5,
        -1,
        -1,
        -1,
        -1,
        -1,
        101,
    },
    {
        -1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        4,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        5,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        6,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        7,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        4,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        5,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        6,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        7,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        4,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        5,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        6,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        7,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        4,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        5,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        6,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
    {
        -1,
        7,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
    },
};

void x64Parser::Init()
{
    memset(&stateVars, 0, sizeof(stateVars));
    stateVars[0] = 16;
    tokenTable[""] = 0;
    tokenTable["*"] = 5;
    tokenTable["+"] = 4;
    tokenTable[","] = 7;
    tokenTable[":"] = 3;
    tokenTable["["] = 1;
    tokenTable["]"] = 2;
    tokenTable["byte"] = 11;
    tokenTable["dword"] = 9;
    tokenTable["far"] = 15;
    tokenTable["near"] = 14;
    tokenTable["qword"] = 10;
    tokenTable["short"] = 13;
    tokenTable["tword"] = 12;
    tokenTable["word"] = 8;
    tokenTable["al"] = 1000;
    tokenTable["ah"] = 1001;
    tokenTable["ax"] = 1002;
    tokenTable["eax"] = 1003;
    tokenTable["rax"] = 1004;
    tokenTable["r8b"] = 1005;
    tokenTable["r8w"] = 1006;
    tokenTable["r8d"] = 1007;
    tokenTable["r8"] = 1008;
    tokenTable["cl"] = 1009;
    tokenTable["ch"] = 1010;
    tokenTable["cx"] = 1011;
    tokenTable["ecx"] = 1012;
    tokenTable["rcx"] = 1013;
    tokenTable["r9b"] = 1014;
    tokenTable["r9w"] = 1015;
    tokenTable["r9d"] = 1016;
    tokenTable["r9"] = 1017;
    tokenTable["dl"] = 1018;
    tokenTable["dh"] = 1019;
    tokenTable["dx"] = 1020;
    tokenTable["edx"] = 1021;
    tokenTable["rdx"] = 1022;
    tokenTable["r10b"] = 1023;
    tokenTable["r10w"] = 1024;
    tokenTable["r10d"] = 1025;
    tokenTable["r10"] = 1026;
    tokenTable["bl"] = 1027;
    tokenTable["bh"] = 1028;
    tokenTable["bx"] = 1029;
    tokenTable["ebx"] = 1030;
    tokenTable["rbx"] = 1031;
    tokenTable["r11b"] = 1032;
    tokenTable["r11w"] = 1033;
    tokenTable["r11d"] = 1034;
    tokenTable["r11"] = 1035;
    tokenTable["spl"] = 1036;
    tokenTable["sp"] = 1037;
    tokenTable["esp"] = 1038;
    tokenTable["rsp"] = 1039;
    tokenTable["r12b"] = 1040;
    tokenTable["r12w"] = 1041;
    tokenTable["r12d"] = 1042;
    tokenTable["r12"] = 1043;
    tokenTable["bpl"] = 1044;
    tokenTable["bp"] = 1045;
    tokenTable["ebp"] = 1046;
    tokenTable["rbp"] = 1047;
    tokenTable["r13b"] = 1048;
    tokenTable["r13w"] = 1049;
    tokenTable["r13d"] = 1050;
    tokenTable["r13"] = 1051;
    tokenTable["sil"] = 1052;
    tokenTable["si"] = 1053;
    tokenTable["esi"] = 1054;
    tokenTable["rsi"] = 1055;
    tokenTable["r14b"] = 1056;
    tokenTable["r14w"] = 1057;
    tokenTable["r14d"] = 1058;
    tokenTable["r14"] = 1059;
    tokenTable["dil"] = 1060;
    tokenTable["di"] = 1061;
    tokenTable["edi"] = 1062;
    tokenTable["rdi"] = 1063;
    tokenTable["r15b"] = 1064;
    tokenTable["r15w"] = 1065;
    tokenTable["r15d"] = 1066;
    tokenTable["r15"] = 1067;
    tokenTable["rip"] = 1068;
    tokenTable["mm0"] = 1069;
    tokenTable["xmm0"] = 1070;
    tokenTable["xmm8"] = 1071;
    tokenTable["mm1"] = 1072;
    tokenTable["xmm1"] = 1073;
    tokenTable["xmm9"] = 1074;
    tokenTable["mm2"] = 1075;
    tokenTable["xmm2"] = 1076;
    tokenTable["xmm10"] = 1077;
    tokenTable["mm3"] = 1078;
    tokenTable["xmm3"] = 1079;
    tokenTable["xmm11"] = 1080;
    tokenTable["mm4"] = 1081;
    tokenTable["xmm4"] = 1082;
    tokenTable["xmm12"] = 1083;
    tokenTable["mm5"] = 1084;
    tokenTable["xmm5"] = 1085;
    tokenTable["xmm13"] = 1086;
    tokenTable["mm6"] = 1087;
    tokenTable["xmm6"] = 1088;
    tokenTable["xmm14"] = 1089;
    tokenTable["mm7"] = 1090;
    tokenTable["xmm7"] = 1091;
    tokenTable["xmm15"] = 1092;
    tokenTable["es"] = 1093;
    tokenTable["cs"] = 1094;
    tokenTable["ss"] = 1095;
    tokenTable["ds"] = 1096;
    tokenTable["fs"] = 1097;
    tokenTable["gs"] = 1098;
    tokenTable["st0"] = 1099;
    tokenTable["st1"] = 1100;
    tokenTable["st2"] = 1101;
    tokenTable["st3"] = 1102;
    tokenTable["st4"] = 1103;
    tokenTable["st5"] = 1104;
    tokenTable["st6"] = 1105;
    tokenTable["st7"] = 1106;
    tokenTable["cr0"] = 1107;
    tokenTable["cr1"] = 1108;
    tokenTable["cr2"] = 1109;
    tokenTable["cr3"] = 1110;
    tokenTable["cr4"] = 1111;
    tokenTable["cr5"] = 1112;
    tokenTable["cr6"] = 1113;
    tokenTable["cr7"] = 1114;
    tokenTable["dr0"] = 1115;
    tokenTable["dr1"] = 1116;
    tokenTable["dr2"] = 1117;
    tokenTable["dr3"] = 1118;
    tokenTable["dr4"] = 1119;
    tokenTable["dr5"] = 1120;
    tokenTable["dr6"] = 1121;
    tokenTable["dr7"] = 1122;
    tokenTable["tr0"] = 1123;
    tokenTable["tr1"] = 1124;
    tokenTable["tr2"] = 1125;
    tokenTable["tr3"] = 1126;
    tokenTable["tr4"] = 1127;
    tokenTable["tr5"] = 1128;
    tokenTable["tr6"] = 1129;
    tokenTable["tr7"] = 1130;
    opcodeTable["aaa"] = 32;
    opcodeTable["aad"] = 33;
    opcodeTable["aam"] = 34;
    opcodeTable["aas"] = 35;
    opcodeTable["adc"] = 36;
    opcodeTable["add"] = 37;
    opcodeTable["and"] = 38;
    opcodeTable["arpl"] = 39;
    opcodeTable["bound"] = 40;
    opcodeTable["bsf"] = 41;
    opcodeTable["bsr"] = 42;
    opcodeTable["bswap"] = 43;
    opcodeTable["bt"] = 44;
    opcodeTable["btc"] = 45;
    opcodeTable["btr"] = 46;
    opcodeTable["bts"] = 47;
    opcodeTable["call"] = 48;
    opcodeTable["cbw"] = 49;
    opcodeTable["cdq"] = 50;
    opcodeTable["cdqe"] = 51;
    opcodeTable["clc"] = 52;
    opcodeTable["cld"] = 53;
    opcodeTable["cli"] = 54;
    opcodeTable["clts"] = 55;
    opcodeTable["cmc"] = 56;
    opcodeTable["cmova"] = 57;
    opcodeTable["cmovae"] = 58;
    opcodeTable["cmovb"] = 59;
    opcodeTable["cmovbe"] = 60;
    opcodeTable["cmovc"] = 61;
    opcodeTable["cmove"] = 62;
    opcodeTable["cmovg"] = 63;
    opcodeTable["cmovge"] = 64;
    opcodeTable["cmovl"] = 65;
    opcodeTable["cmovle"] = 66;
    opcodeTable["cmovna"] = 67;
    opcodeTable["cmovnae"] = 68;
    opcodeTable["cmovnb"] = 69;
    opcodeTable["cmovnbe"] = 70;
    opcodeTable["cmovnc"] = 71;
    opcodeTable["cmovne"] = 72;
    opcodeTable["cmovng"] = 73;
    opcodeTable["cmovnge"] = 74;
    opcodeTable["cmovnl"] = 75;
    opcodeTable["cmovnle"] = 76;
    opcodeTable["cmovno"] = 77;
    opcodeTable["cmovnp"] = 78;
    opcodeTable["cmovns"] = 79;
    opcodeTable["cmovnz"] = 80;
    opcodeTable["cmovo"] = 81;
    opcodeTable["cmovp"] = 82;
    opcodeTable["cmovpe"] = 83;
    opcodeTable["cmovpo"] = 84;
    opcodeTable["cmovs"] = 85;
    opcodeTable["cmovz"] = 86;
    opcodeTable["cmp"] = 87;
    opcodeTable["cmps"] = 88;
    opcodeTable["cmpsb"] = 89;
    opcodeTable["cmpsw"] = 90;
    opcodeTable["cmpsd"] = 91;
    opcodeTable["cmpsq"] = 92;
    opcodeTable["cmpxchg"] = 93;
    opcodeTable["cmpxchg8b"] = 94;
    opcodeTable["cmpxchg16b"] = 95;
    opcodeTable["cpuid"] = 96;
    opcodeTable["cqo"] = 97;
    opcodeTable["cwd"] = 98;
    opcodeTable["cwde"] = 99;
    opcodeTable["daa"] = 100;
    opcodeTable["das"] = 101;
    opcodeTable["dec"] = 102;
    opcodeTable["div"] = 103;
    opcodeTable["enter"] = 104;
    opcodeTable["esc"] = 105;
    opcodeTable["f2xm1"] = 106;
    opcodeTable["fabs"] = 107;
    opcodeTable["fadd"] = 108;
    opcodeTable["faddp"] = 109;
    opcodeTable["fbld"] = 110;
    opcodeTable["fbstp"] = 111;
    opcodeTable["fchs"] = 112;
    opcodeTable["fclex"] = 113;
    opcodeTable["fnclex"] = 114;
    opcodeTable["fcmovb"] = 115;
    opcodeTable["fcmovbe"] = 116;
    opcodeTable["fcmove"] = 117;
    opcodeTable["fcmovnb"] = 118;
    opcodeTable["fcmovnbe"] = 119;
    opcodeTable["fcmovne"] = 120;
    opcodeTable["fcmovnu"] = 121;
    opcodeTable["fcmovu"] = 122;
    opcodeTable["fcom"] = 123;
    opcodeTable["fcomi"] = 124;
    opcodeTable["fcomip"] = 125;
    opcodeTable["fcomp"] = 126;
    opcodeTable["fcompp"] = 127;
    opcodeTable["fcos"] = 128;
    opcodeTable["fdecstp"] = 129;
    opcodeTable["fdisi"] = 130;
    opcodeTable["fdiv"] = 131;
    opcodeTable["fdivp"] = 132;
    opcodeTable["fdivr"] = 133;
    opcodeTable["fdivrp"] = 134;
    opcodeTable["feni"] = 135;
    opcodeTable["ffree"] = 136;
    opcodeTable["ffreep"] = 137;
    opcodeTable["fiadd"] = 138;
    opcodeTable["ficom"] = 139;
    opcodeTable["ficomp"] = 140;
    opcodeTable["fidiv"] = 141;
    opcodeTable["fidivr"] = 142;
    opcodeTable["fild"] = 143;
    opcodeTable["fimul"] = 144;
    opcodeTable["fincstp"] = 145;
    opcodeTable["finit"] = 146;
    opcodeTable["fninit"] = 147;
    opcodeTable["fist"] = 148;
    opcodeTable["fistp"] = 149;
    opcodeTable["fisub"] = 150;
    opcodeTable["fisubr"] = 151;
    opcodeTable["fld"] = 152;
    opcodeTable["fld1"] = 153;
    opcodeTable["fldcw"] = 154;
    opcodeTable["fldenv"] = 155;
    opcodeTable["fldl2e"] = 156;
    opcodeTable["fldl2t"] = 157;
    opcodeTable["fldlg2"] = 158;
    opcodeTable["fldln2"] = 159;
    opcodeTable["fldpi"] = 160;
    opcodeTable["fldz"] = 161;
    opcodeTable["fmul"] = 162;
    opcodeTable["fmulp"] = 163;
    opcodeTable["fnop"] = 164;
    opcodeTable["fnsave"] = 165;
    opcodeTable["fpatan"] = 166;
    opcodeTable["fprem"] = 167;
    opcodeTable["fprem1"] = 168;
    opcodeTable["fptan"] = 169;
    opcodeTable["frndint"] = 170;
    opcodeTable["frstor"] = 171;
    opcodeTable["fsave"] = 172;
    opcodeTable["fscale"] = 173;
    opcodeTable["fsetpm"] = 174;
    opcodeTable["fsin"] = 175;
    opcodeTable["fsincos"] = 176;
    opcodeTable["fsqrt"] = 177;
    opcodeTable["fst"] = 178;
    opcodeTable["fstcw"] = 179;
    opcodeTable["fnstcw"] = 180;
    opcodeTable["fstenv"] = 181;
    opcodeTable["fnstenv"] = 182;
    opcodeTable["fstp"] = 183;
    opcodeTable["fstsw"] = 184;
    opcodeTable["fnstsw"] = 185;
    opcodeTable["fsub"] = 186;
    opcodeTable["fsubp"] = 187;
    opcodeTable["fsubr"] = 188;
    opcodeTable["fsubrp"] = 189;
    opcodeTable["ftst"] = 190;
    opcodeTable["fucom"] = 191;
    opcodeTable["fucomi"] = 192;
    opcodeTable["fucomip"] = 193;
    opcodeTable["fucomp"] = 194;
    opcodeTable["fucompp"] = 195;
    opcodeTable["fwait"] = 196;
    opcodeTable["fxam"] = 197;
    opcodeTable["fxch"] = 198;
    opcodeTable["fxch4"] = 199;
    opcodeTable["fxch7"] = 200;
    opcodeTable["fxrstor"] = 201;
    opcodeTable["fxsave"] = 202;
    opcodeTable["fxtract"] = 203;
    opcodeTable["fyl2x"] = 204;
    opcodeTable["fyl2xp1"] = 205;
    opcodeTable["hlt"] = 206;
    opcodeTable["icebp"] = 207;
    opcodeTable["idiv"] = 208;
    opcodeTable["imul"] = 209;
    opcodeTable["in"] = 210;
    opcodeTable["ins"] = 211;
    opcodeTable["insb"] = 212;
    opcodeTable["insw"] = 213;
    opcodeTable["insd"] = 214;
    opcodeTable["inc"] = 215;
    opcodeTable["int"] = 216;
    opcodeTable["int1"] = 217;
    opcodeTable["int3"] = 218;
    opcodeTable["into"] = 219;
    opcodeTable["invd"] = 220;
    opcodeTable["invlpg"] = 221;
    opcodeTable["iret"] = 222;
    opcodeTable["iretw"] = 223;
    opcodeTable["iretd"] = 224;
    opcodeTable["iretq"] = 225;
    opcodeTable["ja"] = 226;
    opcodeTable["jae"] = 227;
    opcodeTable["jb"] = 228;
    opcodeTable["jbe"] = 229;
    opcodeTable["jc"] = 230;
    opcodeTable["jcxz"] = 231;
    opcodeTable["jecxz"] = 232;
    opcodeTable["je"] = 233;
    opcodeTable["jg"] = 234;
    opcodeTable["jge"] = 235;
    opcodeTable["jl"] = 236;
    opcodeTable["jle"] = 237;
    opcodeTable["jmp"] = 238;
    opcodeTable["jna"] = 239;
    opcodeTable["jnae"] = 240;
    opcodeTable["jnb"] = 241;
    opcodeTable["jnbe"] = 242;
    opcodeTable["jnc"] = 243;
    opcodeTable["jne"] = 244;
    opcodeTable["jng"] = 245;
    opcodeTable["jnge"] = 246;
    opcodeTable["jnl"] = 247;
    opcodeTable["jnle"] = 248;
    opcodeTable["jno"] = 249;
    opcodeTable["jnp"] = 250;
    opcodeTable["jns"] = 251;
    opcodeTable["jnz"] = 252;
    opcodeTable["jo"] = 253;
    opcodeTable["jp"] = 254;
    opcodeTable["jpe"] = 255;
    opcodeTable["jpo"] = 256;
    opcodeTable["js"] = 257;
    opcodeTable["jz"] = 258;
    opcodeTable["lahf"] = 259;
    opcodeTable["lar"] = 260;
    opcodeTable["lds"] = 261;
    opcodeTable["lea"] = 262;
    opcodeTable["leave"] = 263;
    opcodeTable["les"] = 264;
    opcodeTable["lfence"] = 265;
    opcodeTable["lfs"] = 266;
    opcodeTable["lgdt"] = 267;
    opcodeTable["lgs"] = 268;
    opcodeTable["lidt"] = 269;
    opcodeTable["lldt"] = 270;
    opcodeTable["lmsw"] = 271;
    opcodeTable["lods"] = 272;
    opcodeTable["lodsb"] = 273;
    opcodeTable["lodsw"] = 274;
    opcodeTable["lodsd"] = 275;
    opcodeTable["lodsq"] = 276;
    opcodeTable["loop"] = 277;
    opcodeTable["loope"] = 278;
    opcodeTable["loopne"] = 279;
    opcodeTable["loopnz"] = 280;
    opcodeTable["loopz"] = 281;
    opcodeTable["lsl"] = 282;
    opcodeTable["lss"] = 283;
    opcodeTable["ltr"] = 284;
    opcodeTable["mov"] = 285;
    opcodeTable["movs"] = 286;
    opcodeTable["movbe"] = 287;
    opcodeTable["movsb"] = 288;
    opcodeTable["movsw"] = 289;
    opcodeTable["movsd"] = 290;
    opcodeTable["movsq"] = 291;
    opcodeTable["movsx"] = 292;
    opcodeTable["movzx"] = 293;
    opcodeTable["movsxd"] = 294;
    opcodeTable["mul"] = 295;
    opcodeTable["neg"] = 296;
    opcodeTable["nop"] = 297;
    opcodeTable["not"] = 298;
    opcodeTable["or"] = 299;
    opcodeTable["out"] = 300;
    opcodeTable["outs"] = 301;
    opcodeTable["outsb"] = 302;
    opcodeTable["outsw"] = 303;
    opcodeTable["outsd"] = 304;
    opcodeTable["pop"] = 305;
    opcodeTable["popa"] = 306;
    opcodeTable["popaw"] = 307;
    opcodeTable["popad"] = 308;
    opcodeTable["popcnt"] = 309;
    opcodeTable["popf"] = 310;
    opcodeTable["popfw"] = 311;
    opcodeTable["popfd"] = 312;
    opcodeTable["popfq"] = 313;
    opcodeTable["prefetchnta"] = 314;
    opcodeTable["prefetcht0"] = 315;
    opcodeTable["prefetcht1"] = 316;
    opcodeTable["prefetcht2"] = 317;
    opcodeTable["push"] = 318;
    opcodeTable["pusha"] = 319;
    opcodeTable["pushaw"] = 320;
    opcodeTable["pushad"] = 321;
    opcodeTable["pushf"] = 322;
    opcodeTable["pushfw"] = 323;
    opcodeTable["pushfd"] = 324;
    opcodeTable["pushfq"] = 325;
    opcodeTable["rcl"] = 326;
    opcodeTable["rcr"] = 327;
    opcodeTable["rdmsr"] = 328;
    opcodeTable["rdpmc"] = 329;
    opcodeTable["rdtsc"] = 330;
    opcodeTable["ret"] = 331;
    opcodeTable["retf"] = 332;
    opcodeTable["rol"] = 333;
    opcodeTable["ror"] = 334;
    opcodeTable["rsm"] = 335;
    opcodeTable["sahf"] = 336;
    opcodeTable["sal"] = 337;
    opcodeTable["sar"] = 338;
    opcodeTable["sbb"] = 339;
    opcodeTable["scas"] = 340;
    opcodeTable["scasb"] = 341;
    opcodeTable["scasw"] = 342;
    opcodeTable["scasd"] = 343;
    opcodeTable["scasq"] = 344;
    opcodeTable["seta"] = 345;
    opcodeTable["setae"] = 346;
    opcodeTable["setb"] = 347;
    opcodeTable["setbe"] = 348;
    opcodeTable["setc"] = 349;
    opcodeTable["sete"] = 350;
    opcodeTable["setg"] = 351;
    opcodeTable["setge"] = 352;
    opcodeTable["setl"] = 353;
    opcodeTable["setle"] = 354;
    opcodeTable["setna"] = 355;
    opcodeTable["setnae"] = 356;
    opcodeTable["setnb"] = 357;
    opcodeTable["setnbe"] = 358;
    opcodeTable["setnc"] = 359;
    opcodeTable["setne"] = 360;
    opcodeTable["setng"] = 361;
    opcodeTable["setnge"] = 362;
    opcodeTable["setnl"] = 363;
    opcodeTable["setnle"] = 364;
    opcodeTable["setno"] = 365;
    opcodeTable["setnp"] = 366;
    opcodeTable["setns"] = 367;
    opcodeTable["setnz"] = 368;
    opcodeTable["seto"] = 369;
    opcodeTable["setp"] = 370;
    opcodeTable["setpe"] = 371;
    opcodeTable["setpo"] = 372;
    opcodeTable["sets"] = 373;
    opcodeTable["setz"] = 374;
    opcodeTable["sfence"] = 375;
    opcodeTable["sgdt"] = 376;
    opcodeTable["shl"] = 377;
    opcodeTable["shld"] = 378;
    opcodeTable["shr"] = 379;
    opcodeTable["shrd"] = 380;
    opcodeTable["sidt"] = 381;
    opcodeTable["sldt"] = 382;
    opcodeTable["smsw"] = 383;
    opcodeTable["stc"] = 384;
    opcodeTable["std"] = 385;
    opcodeTable["sti"] = 386;
    opcodeTable["stos"] = 387;
    opcodeTable["stosb"] = 388;
    opcodeTable["stosw"] = 389;
    opcodeTable["stosd"] = 390;
    opcodeTable["stosq"] = 391;
    opcodeTable["str"] = 392;
    opcodeTable["sub"] = 393;
    opcodeTable["syscall"] = 394;
    opcodeTable["sysenter"] = 395;
    opcodeTable["sysexit"] = 396;
    opcodeTable["sysret"] = 397;
    opcodeTable["test"] = 398;
    opcodeTable["ud2"] = 399;
    opcodeTable["verr"] = 400;
    opcodeTable["verw"] = 401;
    opcodeTable["wait"] = 402;
    opcodeTable["wbinvd"] = 403;
    opcodeTable["wrmsr"] = 404;
    opcodeTable["xadd"] = 405;
    opcodeTable["xchg"] = 406;
    opcodeTable["xlat"] = 407;
    opcodeTable["xlatb"] = 408;
    opcodeTable["xor"] = 409;
    opcodeTable["xrstor"] = 410;
    opcodeTable["xrstor64"] = 411;
    opcodeTable["xsave"] = 412;
    opcodeTable["xsave64"] = 413;
    opcodeTable["xsetbv"] = 414;
    opcodeTable["addpd"] = 415;
    opcodeTable["addps"] = 416;
    opcodeTable["addsd"] = 417;
    opcodeTable["addss"] = 418;
    opcodeTable["addsubpd"] = 419;
    opcodeTable["addsubps"] = 420;
    opcodeTable["andnpd"] = 421;
    opcodeTable["andnps"] = 422;
    opcodeTable["andpd"] = 423;
    opcodeTable["andps"] = 424;
    opcodeTable["blendpd"] = 425;
    opcodeTable["blendps"] = 426;
    opcodeTable["cmppd"] = 427;
    opcodeTable["cmpps"] = 428;
    opcodeTable["comisd"] = 429;
    opcodeTable["comiss"] = 430;
    opcodeTable["cvtdq2pd"] = 431;
    opcodeTable["cvtdq2ps"] = 432;
    opcodeTable["cvtpd2dq"] = 433;
    opcodeTable["cvtpd2pi"] = 434;
    opcodeTable["cvtpd2ps"] = 435;
    opcodeTable["cvtpi2pd"] = 436;
    opcodeTable["cvtpi2ps"] = 437;
    opcodeTable["cvtps2dq"] = 438;
    opcodeTable["cvtps2pd"] = 439;
    opcodeTable["cvtps2pi"] = 440;
    opcodeTable["cvtsd2si"] = 441;
    opcodeTable["cvtsd2ss"] = 442;
    opcodeTable["cvtsi2sd"] = 443;
    opcodeTable["cvtsi2ss"] = 444;
    opcodeTable["cvtss2sd"] = 445;
    opcodeTable["cvtss2si"] = 446;
    opcodeTable["cvttpd2dq"] = 447;
    opcodeTable["cvttpd2pi"] = 448;
    opcodeTable["cvttps2dq"] = 449;
    opcodeTable["cvttps2pi"] = 450;
    opcodeTable["cvttsd2si"] = 451;
    opcodeTable["cvttss2si"] = 452;
    opcodeTable["divpd"] = 453;
    opcodeTable["divps"] = 454;
    opcodeTable["divsd"] = 455;
    opcodeTable["divss"] = 456;
    opcodeTable["dppd"] = 457;
    opcodeTable["dpps"] = 458;
    opcodeTable["hsubpd"] = 459;
    opcodeTable["hsubps"] = 460;
    opcodeTable["insertps"] = 461;
    opcodeTable["lddqu"] = 462;
    opcodeTable["maskmovdqu"] = 463;
    opcodeTable["maskmovq"] = 464;
    opcodeTable["maxpd"] = 465;
    opcodeTable["maxps"] = 466;
    opcodeTable["maxsd"] = 467;
    opcodeTable["maxss"] = 468;
    opcodeTable["mfence"] = 469;
    opcodeTable["minpd"] = 470;
    opcodeTable["minps"] = 471;
    opcodeTable["minsd"] = 472;
    opcodeTable["minss"] = 473;
    opcodeTable["monitor"] = 474;
    opcodeTable["movapd"] = 475;
    opcodeTable["movaps"] = 476;
    opcodeTable["movd"] = 477;
    opcodeTable["movq"] = 478;
    opcodeTable["movddup"] = 479;
    opcodeTable["movdq2q"] = 480;
    opcodeTable["movdqa"] = 481;
    opcodeTable["movdqu"] = 482;
    opcodeTable["movhlps"] = 483;
    opcodeTable["movhpd"] = 484;
    opcodeTable["movhps"] = 485;
    opcodeTable["movlhps"] = 486;
    opcodeTable["movlpd"] = 487;
    opcodeTable["movlps"] = 488;
    opcodeTable["movmskpd"] = 489;
    opcodeTable["movmskps"] = 490;
    opcodeTable["movntdq"] = 491;
    opcodeTable["movnti"] = 492;
    opcodeTable["movntpd"] = 493;
    opcodeTable["movntd"] = 494;
    opcodeTable["movntq"] = 495;
    opcodeTable["movq2dq"] = 496;
    opcodeTable["movshdup"] = 497;
    opcodeTable["movsldup"] = 498;
    opcodeTable["movss"] = 499;
    opcodeTable["movupd"] = 500;
    opcodeTable["movups"] = 501;
    opcodeTable["mpsadbw"] = 502;
    opcodeTable["mulpd"] = 503;
    opcodeTable["mulps"] = 504;
    opcodeTable["mulsd"] = 505;
    opcodeTable["mulss"] = 506;
    opcodeTable["orpd"] = 507;
    opcodeTable["orps"] = 508;
    opcodeTable["packssdw"] = 509;
    opcodeTable["packsswb"] = 510;
    opcodeTable["packusdw"] = 511;
    opcodeTable["paddb"] = 512;
    opcodeTable["paddd"] = 513;
    opcodeTable["paddq"] = 514;
    opcodeTable["paddsw"] = 515;
    opcodeTable["paddusb"] = 516;
    opcodeTable["paddusw"] = 517;
    opcodeTable["paddw"] = 518;
    opcodeTable["palignr"] = 519;
    opcodeTable["pand"] = 520;
    opcodeTable["pandn"] = 521;
    opcodeTable["pavgb"] = 522;
    opcodeTable["pavgw"] = 523;
    opcodeTable["pblendw"] = 524;
    opcodeTable["pcmpeqb"] = 525;
    opcodeTable["pcmpeqd"] = 526;
    opcodeTable["pcmpeqw"] = 527;
    opcodeTable["pcmpestri"] = 528;
    opcodeTable["pcmpestrm"] = 529;
    opcodeTable["pcmpgtb"] = 530;
    opcodeTable["pcmpgtd"] = 531;
    opcodeTable["pcmpgtw"] = 532;
    opcodeTable["pextrb"] = 533;
    opcodeTable["pextrd"] = 534;
    opcodeTable["pextrq"] = 535;
    opcodeTable["pextrw"] = 536;
    opcodeTable["pinsrb"] = 537;
    opcodeTable["pinsrd"] = 538;
    opcodeTable["pinsrq"] = 539;
    opcodeTable["pinsrw"] = 540;
    opcodeTable["pmaddwd"] = 541;
    opcodeTable["pmaxsw"] = 542;
    opcodeTable["pmaxub"] = 543;
    opcodeTable["pminsw"] = 544;
    opcodeTable["pminub"] = 545;
    opcodeTable["pmovmskb"] = 546;
    opcodeTable["pmulhuw"] = 547;
    opcodeTable["pmulhw"] = 548;
    opcodeTable["pmullw"] = 549;
    opcodeTable["pmuludq"] = 550;
    opcodeTable["psadbw"] = 551;
    opcodeTable["pshufd"] = 552;
    opcodeTable["pshufhw"] = 553;
    opcodeTable["pshuflw"] = 554;
    opcodeTable["pshufw"] = 555;
    opcodeTable["pslld"] = 556;
    opcodeTable["pslldq"] = 557;
    opcodeTable["psllq"] = 558;
    opcodeTable["psllw"] = 559;
    opcodeTable["psrad"] = 560;
    opcodeTable["psraw"] = 561;
    opcodeTable["psrld"] = 562;
    opcodeTable["psrldq"] = 563;
    opcodeTable["psrlq"] = 564;
    opcodeTable["psrlw"] = 565;
    opcodeTable["psubb"] = 566;
    opcodeTable["psubd"] = 567;
    opcodeTable["psubq"] = 568;
    opcodeTable["psubsb"] = 569;
    opcodeTable["psubsw"] = 570;
    opcodeTable["psubusb"] = 571;
    opcodeTable["psubusw"] = 572;
    opcodeTable["punpckhbw"] = 573;
    opcodeTable["punpckhdq"] = 574;
    opcodeTable["punpckhqdq"] = 575;
    opcodeTable["punpckhwd"] = 576;
    opcodeTable["punpcklbw"] = 577;
    opcodeTable["punpckldq"] = 578;
    opcodeTable["punpcklqdq"] = 579;
    opcodeTable["punpcklwd"] = 580;
    opcodeTable["pxor"] = 581;
    opcodeTable["rcpps"] = 582;
    opcodeTable["rcpss"] = 583;
    opcodeTable["roundpd"] = 584;
    opcodeTable["roundps"] = 585;
    opcodeTable["roundsd"] = 586;
    opcodeTable["roundss"] = 587;
    opcodeTable["rsqrtps"] = 588;
    opcodeTable["rsqrtss"] = 589;
    opcodeTable["shufpd"] = 590;
    opcodeTable["shufps"] = 591;
    opcodeTable["sqrtpd"] = 592;
    opcodeTable["sqrtps"] = 593;
    opcodeTable["sqrtsd"] = 594;
    opcodeTable["sqrtss"] = 595;
    opcodeTable["subpd"] = 596;
    opcodeTable["subps"] = 597;
    opcodeTable["subsd"] = 598;
    opcodeTable["subss"] = 599;
    opcodeTable["ucomisd"] = 600;
    opcodeTable["ucomiss"] = 601;
    opcodeTable["unpckhpd"] = 602;
    opcodeTable["unpckhps"] = 603;
    opcodeTable["unpcklpd"] = 604;
    opcodeTable["unpcklps"] = 605;
    opcodeTable["xorpd"] = 606;
    opcodeTable["xorps"] = 607;
    opcodeTable["invept"] = 608;
    opcodeTable["invvpid"] = 609;
    opcodeTable["vmcall"] = 610;
    opcodeTable["vmclear"] = 611;
    opcodeTable["vmlaunch"] = 612;
    opcodeTable["vmptrld"] = 613;
    opcodeTable["vmptrst"] = 614;
    opcodeTable["vmread"] = 615;
    opcodeTable["vmresume"] = 616;
    opcodeTable["vmwrite"] = 617;
    opcodeTable["vmxoff"] = 618;
    opcodeTable["vmxon"] = 619;
    prefixTable["a16"] = 0;
    prefixTable["a32"] = 1;
    prefixTable["lock"] = 2;
    prefixTable["o16"] = 3;
    prefixTable["o32"] = 4;
    prefixTable["rep"] = 5;
    prefixTable["repe"] = 6;
    prefixTable["repne"] = 7;
    prefixTable["repnz"] = 8;
    prefixTable["repz"] = 9;
}

void x64Parser::TokenFunc4(x64Operand& operand, int tokenPos) { operand.addressCoding = 0; }
x64Token x64Parser::tokenBranches3[] = {{
                                            x64Token::TOKEN,
                                            2,
                                            1,
                                            0,
                                            x64Parser::RegClassData2,
                                            &x64Parser::TokenFunc4,
                                        },
                                        {x64Token::EOT}};
void x64Parser::TokenFunc9(x64Operand& operand, int tokenPos) { operand.addressCoding = 1; }
x64Token x64Parser::tokenBranches8[] = {{
                                            x64Token::TOKEN,
                                            2,
                                            1,
                                            0,
                                            x64Parser::RegClassData2,
                                            &x64Parser::TokenFunc9,
                                        },
                                        {x64Token::EOT}};
void x64Parser::TokenFunc200(x64Operand& operand, int tokenPos) { operand.addressCoding = 19; }
x64Token x64Parser::tokenBranches199[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc200,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc346(x64Operand& operand, int tokenPos) { operand.addressCoding = 34; }
x64Token x64Parser::tokenBranches345[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc346,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc199(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc345(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches198[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc199, x64Parser::tokenBranches199},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc345, x64Parser::tokenBranches345},
    {x64Token::EOT}};
void x64Parser::TokenFunc36(x64Operand& operand, int tokenPos) { operand.addressCoding = 4; }
x64Token x64Parser::tokenBranches35[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc36,
                                         },
                                         {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches198},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc137(x64Operand& operand, int tokenPos) { operand.addressCoding = 13; }
x64Token x64Parser::tokenBranches136[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc137,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc283(x64Operand& operand, int tokenPos) { operand.addressCoding = 28; }
x64Token x64Parser::tokenBranches282[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc283,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc429(x64Operand& operand, int tokenPos) { operand.addressCoding = 43; }
x64Token x64Parser::tokenBranches428[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc429,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc35(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
void x64Parser::TokenFunc136(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc282(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc428(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches34[] = {
    {x64Token::REGISTERCLASS, 15, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc35, x64Parser::tokenBranches35},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc136, x64Parser::tokenBranches136},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc282, x64Parser::tokenBranches282},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc428, x64Parser::tokenBranches428},
    {x64Token::EOT}};
void x64Parser::TokenFunc97(x64Operand& operand, int tokenPos) { operand.addressCoding = 13; }
x64Token x64Parser::tokenBranches33[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches34},
                                         {
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc97,
                                         },
                                         {x64Token::EOT}};
void x64Parser::TokenFunc227(x64Operand& operand, int tokenPos) { operand.addressCoding = 22; }
x64Token x64Parser::tokenBranches226[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc227,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc373(x64Operand& operand, int tokenPos) { operand.addressCoding = 37; }
x64Token x64Parser::tokenBranches372[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc373,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc226(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc372(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches225[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc226, x64Parser::tokenBranches226},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc372, x64Parser::tokenBranches372},
    {x64Token::EOT}};
void x64Parser::TokenFunc57(x64Operand& operand, int tokenPos) { operand.addressCoding = 7; }
x64Token x64Parser::tokenBranches56[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc57,
                                         },
                                         {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches225},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc170(x64Operand& operand, int tokenPos) { operand.addressCoding = 17; }
x64Token x64Parser::tokenBranches169[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc170,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc316(x64Operand& operand, int tokenPos) { operand.addressCoding = 32; }
x64Token x64Parser::tokenBranches315[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc316,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc462(x64Operand& operand, int tokenPos) { operand.addressCoding = 47; }
x64Token x64Parser::tokenBranches461[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc462,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc56(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
void x64Parser::TokenFunc169(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc315(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc461(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches55[] = {
    {x64Token::REGISTERCLASS, 15, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc56, x64Parser::tokenBranches56},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc169, x64Parser::tokenBranches169},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc315, x64Parser::tokenBranches315},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc461, x64Parser::tokenBranches461},
    {x64Token::EOT}};
void x64Parser::TokenFunc120(x64Operand& operand, int tokenPos) { operand.addressCoding = 17; }
x64Token x64Parser::tokenBranches54[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches55},
                                         {
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc120,
                                         },
                                         {x64Token::EOT}};
void x64Parser::TokenFunc257(x64Operand& operand, int tokenPos) { operand.addressCoding = 25; }
x64Token x64Parser::tokenBranches256[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc257,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc403(x64Operand& operand, int tokenPos) { operand.addressCoding = 40; }
x64Token x64Parser::tokenBranches402[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc403,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc256(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc402(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches255[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc256, x64Parser::tokenBranches256},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc402, x64Parser::tokenBranches402},
    {x64Token::EOT}};
void x64Parser::TokenFunc79(x64Operand& operand, int tokenPos) { operand.addressCoding = 10; }
x64Token x64Parser::tokenBranches78[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc79,
                                         },
                                         {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches255},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc606(x64Operand& operand, int tokenPos) { operand.addressCoding = 57; }
x64Token x64Parser::tokenBranches605[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc606,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc702(x64Operand& operand, int tokenPos) { operand.addressCoding = 70; }
x64Token x64Parser::tokenBranches701[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc702,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc826(x64Operand& operand, int tokenPos) { operand.addressCoding = 84; }
x64Token x64Parser::tokenBranches825[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc826,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2121(x64Operand& operand, int tokenPos) { operand.addressCoding = 176; }
x64Token x64Parser::tokenBranches2120[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2121,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2680(x64Operand& operand, int tokenPos) { operand.addressCoding = 202; }
x64Token x64Parser::tokenBranches2679[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2680,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2951(x64Operand& operand, int tokenPos) { operand.addressCoding = 222; }
x64Token x64Parser::tokenBranches2950[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2951,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2120(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2679(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2950(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2119[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2120, x64Parser::tokenBranches2120},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2679, x64Parser::tokenBranches2679},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2950, x64Parser::tokenBranches2950},
    {x64Token::EOT}};
void x64Parser::TokenFunc2403(x64Operand& operand, int tokenPos) { operand.addressCoding = 176; }
x64Token x64Parser::tokenBranches2118[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2119},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2403,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2118(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2117[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2118, x64Parser::tokenBranches2118},
    {x64Token::EOT}};
void x64Parser::TokenFunc2130(x64Operand& operand, int tokenPos) { operand.addressCoding = 177; }
x64Token x64Parser::tokenBranches2129[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2130,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2689(x64Operand& operand, int tokenPos) { operand.addressCoding = 203; }
x64Token x64Parser::tokenBranches2688[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2689,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2960(x64Operand& operand, int tokenPos) { operand.addressCoding = 223; }
x64Token x64Parser::tokenBranches2959[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2960,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2129(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2688(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2959(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2128[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2129, x64Parser::tokenBranches2129},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2688, x64Parser::tokenBranches2688},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2959, x64Parser::tokenBranches2959},
    {x64Token::EOT}};
void x64Parser::TokenFunc2410(x64Operand& operand, int tokenPos) { operand.addressCoding = 177; }
x64Token x64Parser::tokenBranches2116[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2117},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2128},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2410,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc605(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc701(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc825(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2116(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches604[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc605, x64Parser::tokenBranches605},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc701, x64Parser::tokenBranches701},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc825, x64Parser::tokenBranches825},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2116, x64Parser::tokenBranches2116},
    {x64Token::EOT}};
void x64Parser::TokenFunc506(x64Operand& operand, int tokenPos) { operand.addressCoding = 57; }
x64Token x64Parser::tokenBranches505[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc506,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches604},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc613(x64Operand& operand, int tokenPos) { operand.addressCoding = 67; }
x64Token x64Parser::tokenBranches612[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc613,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc709(x64Operand& operand, int tokenPos) { operand.addressCoding = 71; }
x64Token x64Parser::tokenBranches708[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc709,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc833(x64Operand& operand, int tokenPos) { operand.addressCoding = 85; }
x64Token x64Parser::tokenBranches832[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc833,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2101(x64Operand& operand, int tokenPos) { operand.addressCoding = 174; }
x64Token x64Parser::tokenBranches2100[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2101,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2660(x64Operand& operand, int tokenPos) { operand.addressCoding = 200; }
x64Token x64Parser::tokenBranches2659[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2660,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2931(x64Operand& operand, int tokenPos) { operand.addressCoding = 220; }
x64Token x64Parser::tokenBranches2930[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2931,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2100(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2659(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2930(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2099[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2100, x64Parser::tokenBranches2100},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2659, x64Parser::tokenBranches2659},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2930, x64Parser::tokenBranches2930},
    {x64Token::EOT}};
void x64Parser::TokenFunc2387(x64Operand& operand, int tokenPos) { operand.addressCoding = 174; }
x64Token x64Parser::tokenBranches2098[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2099},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2387,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2098(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2097[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2098, x64Parser::tokenBranches2098},
    {x64Token::EOT}};
void x64Parser::TokenFunc2110(x64Operand& operand, int tokenPos) { operand.addressCoding = 175; }
x64Token x64Parser::tokenBranches2109[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2110,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2669(x64Operand& operand, int tokenPos) { operand.addressCoding = 201; }
x64Token x64Parser::tokenBranches2668[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2669,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2940(x64Operand& operand, int tokenPos) { operand.addressCoding = 221; }
x64Token x64Parser::tokenBranches2939[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2940,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2109(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2668(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2939(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2108[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2109, x64Parser::tokenBranches2109},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2668, x64Parser::tokenBranches2668},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2939, x64Parser::tokenBranches2939},
    {x64Token::EOT}};
void x64Parser::TokenFunc2394(x64Operand& operand, int tokenPos) { operand.addressCoding = 175; }
x64Token x64Parser::tokenBranches2096[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2097},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2108},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2394,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2219(x64Operand& operand, int tokenPos) { operand.addressCoding = 182; }
x64Token x64Parser::tokenBranches2218[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2219,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2631(x64Operand& operand, int tokenPos) { operand.addressCoding = 198; }
x64Token x64Parser::tokenBranches2630[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2631,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3009(x64Operand& operand, int tokenPos) { operand.addressCoding = 228; }
x64Token x64Parser::tokenBranches3008[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3009,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2218(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2630(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3008(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2217[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2218, x64Parser::tokenBranches2218},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2630, x64Parser::tokenBranches2630},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3008, x64Parser::tokenBranches3008},
    {x64Token::EOT}};
void x64Parser::TokenFunc2449(x64Operand& operand, int tokenPos) { operand.addressCoding = 182; }
x64Token x64Parser::tokenBranches2216[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2217},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2449,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc612(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc708(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc832(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2096(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches611[] = {
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2216},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc612, x64Parser::tokenBranches612},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc708, x64Parser::tokenBranches708},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc832, x64Parser::tokenBranches832},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2096, x64Parser::tokenBranches2096},
    {x64Token::EOT}};
void x64Parser::TokenFunc975(x64Operand& operand, int tokenPos) { operand.addressCoding = 99; }
x64Token x64Parser::tokenBranches974[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc975,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc984(x64Operand& operand, int tokenPos) { operand.addressCoding = 100; }
x64Token x64Parser::tokenBranches983[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc984,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc993(x64Operand& operand, int tokenPos) { operand.addressCoding = 101; }
x64Token x64Parser::tokenBranches992[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc993,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc974(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc983(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc992(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches973[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc974, x64Parser::tokenBranches974},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc983, x64Parser::tokenBranches983},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc992, x64Parser::tokenBranches992},
    {x64Token::EOT}};
void x64Parser::TokenFunc966(x64Operand& operand, int tokenPos) { operand.addressCoding = 99; }
x64Token x64Parser::tokenBranches965[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc966,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches973},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc1103(x64Operand& operand, int tokenPos) { operand.addressCoding = 108; }
x64Token x64Parser::tokenBranches1102[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1103,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1112(x64Operand& operand, int tokenPos) { operand.addressCoding = 109; }
x64Token x64Parser::tokenBranches1111[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1112,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1121(x64Operand& operand, int tokenPos) { operand.addressCoding = 110; }
x64Token x64Parser::tokenBranches1120[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1121,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1102(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1111(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1120(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1101[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1102, x64Parser::tokenBranches1102},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1111, x64Parser::tokenBranches1111},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1120, x64Parser::tokenBranches1120},
    {x64Token::EOT}};
void x64Parser::TokenFunc1094(x64Operand& operand, int tokenPos) { operand.addressCoding = 108; }
x64Token x64Parser::tokenBranches1093[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1094,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1101},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1480(x64Operand& operand, int tokenPos) { operand.addressCoding = 134; }
x64Token x64Parser::tokenBranches1479[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1480,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1489(x64Operand& operand, int tokenPos) { operand.addressCoding = 135; }
x64Token x64Parser::tokenBranches1488[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1489,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1479(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1488(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1478[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1479, x64Parser::tokenBranches1479},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1488, x64Parser::tokenBranches1488},
    {x64Token::EOT}};
void x64Parser::TokenFunc1471(x64Operand& operand, int tokenPos) { operand.addressCoding = 134; }
x64Token x64Parser::tokenBranches1470[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1471,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1478},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc965(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1093(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1470(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches964[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc965, x64Parser::tokenBranches965},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1093, x64Parser::tokenBranches1093},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1470, x64Parser::tokenBranches1470},
    {x64Token::EOT}};
void x64Parser::TokenFunc511(x64Operand& operand, int tokenPos) { operand.addressCoding = 58; }
x64Token x64Parser::tokenBranches510[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc511,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches611},
                                          {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches964},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc653(x64Operand& operand, int tokenPos) { operand.addressCoding = 53; }
x64Token x64Parser::tokenBranches652[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc653,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc777(x64Operand& operand, int tokenPos) { operand.addressCoding = 76; }
x64Token x64Parser::tokenBranches776[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc777,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc901(x64Operand& operand, int tokenPos) { operand.addressCoding = 90; }
x64Token x64Parser::tokenBranches900[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc901,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc652(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc776(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc900(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches651[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc652, x64Parser::tokenBranches652},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc776, x64Parser::tokenBranches776},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc900, x64Parser::tokenBranches900},
    {x64Token::EOT}};
void x64Parser::TokenFunc538(x64Operand& operand, int tokenPos) { operand.addressCoding = 53; }
x64Token x64Parser::tokenBranches537[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc538,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches651},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc644(x64Operand& operand, int tokenPos) { operand.addressCoding = 52; }
x64Token x64Parser::tokenBranches643[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc644,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc768(x64Operand& operand, int tokenPos) { operand.addressCoding = 75; }
x64Token x64Parser::tokenBranches767[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc768,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc892(x64Operand& operand, int tokenPos) { operand.addressCoding = 89; }
x64Token x64Parser::tokenBranches891[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc892,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2300(x64Operand& operand, int tokenPos) { operand.addressCoding = 185; }
x64Token x64Parser::tokenBranches2299[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2300,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2832(x64Operand& operand, int tokenPos) { operand.addressCoding = 214; }
x64Token x64Parser::tokenBranches2831[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2832,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3130(x64Operand& operand, int tokenPos) { operand.addressCoding = 236; }
x64Token x64Parser::tokenBranches3129[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3130,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2299(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2831(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3129(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2298[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2299, x64Parser::tokenBranches2299},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2831, x64Parser::tokenBranches2831},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3129, x64Parser::tokenBranches3129},
    {x64Token::EOT}};
void x64Parser::TokenFunc2544(x64Operand& operand, int tokenPos) { operand.addressCoding = 185; }
x64Token x64Parser::tokenBranches2297[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2298},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2544,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2297(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2296[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2297, x64Parser::tokenBranches2297},
    {x64Token::EOT}};
void x64Parser::TokenFunc2309(x64Operand& operand, int tokenPos) { operand.addressCoding = 186; }
x64Token x64Parser::tokenBranches2308[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2309,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2841(x64Operand& operand, int tokenPos) { operand.addressCoding = 211; }
x64Token x64Parser::tokenBranches2840[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2841,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3139(x64Operand& operand, int tokenPos) { operand.addressCoding = 237; }
x64Token x64Parser::tokenBranches3138[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3139,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2308(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2840(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3138(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2307[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2308, x64Parser::tokenBranches2308},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2840, x64Parser::tokenBranches2840},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3138, x64Parser::tokenBranches3138},
    {x64Token::EOT}};
void x64Parser::TokenFunc2551(x64Operand& operand, int tokenPos) { operand.addressCoding = 186; }
x64Token x64Parser::tokenBranches2295[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2296},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2307},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2551,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc643(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc767(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc891(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2295(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches536[] = {
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches537},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc643, x64Parser::tokenBranches643},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc767, x64Parser::tokenBranches767},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc891, x64Parser::tokenBranches891},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2295, x64Parser::tokenBranches2295},
    {x64Token::EOT}};
void x64Parser::TokenFunc1625(x64Operand& operand, int tokenPos) { operand.addressCoding = 52; }
x64Token x64Parser::tokenBranches1624[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1625,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1634(x64Operand& operand, int tokenPos) { operand.addressCoding = 75; }
x64Token x64Parser::tokenBranches1633[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1634,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1643(x64Operand& operand, int tokenPos) { operand.addressCoding = 89; }
x64Token x64Parser::tokenBranches1642[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1643,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1624(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1633(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1642(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1623[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1624, x64Parser::tokenBranches1624},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1633, x64Parser::tokenBranches1633},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1642, x64Parser::tokenBranches1642},
    {x64Token::EOT}};
void x64Parser::TokenFunc1616(x64Operand& operand, int tokenPos) { operand.addressCoding = 52; }
x64Token x64Parser::tokenBranches1615[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1616,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1623},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1753(x64Operand& operand, int tokenPos) { operand.addressCoding = 147; }
x64Token x64Parser::tokenBranches1752[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1753,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1762(x64Operand& operand, int tokenPos) { operand.addressCoding = 148; }
x64Token x64Parser::tokenBranches1761[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1762,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1771(x64Operand& operand, int tokenPos) { operand.addressCoding = 149; }
x64Token x64Parser::tokenBranches1770[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1771,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1752(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1761(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1770(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1751[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1752, x64Parser::tokenBranches1752},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1761, x64Parser::tokenBranches1761},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1770, x64Parser::tokenBranches1770},
    {x64Token::EOT}};
void x64Parser::TokenFunc1744(x64Operand& operand, int tokenPos) { operand.addressCoding = 147; }
x64Token x64Parser::tokenBranches1743[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1744,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1751},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1899(x64Operand& operand, int tokenPos) { operand.addressCoding = 156; }
x64Token x64Parser::tokenBranches1898[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1899,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1908(x64Operand& operand, int tokenPos) { operand.addressCoding = 157; }
x64Token x64Parser::tokenBranches1907[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1908,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1928(x64Operand& operand, int tokenPos) { operand.addressCoding = 158; }
x64Token x64Parser::tokenBranches1927[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1928,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1939(x64Operand& operand, int tokenPos) { operand.addressCoding = 159; }
x64Token x64Parser::tokenBranches1938[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1939,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1927(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1938(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1926[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1927, x64Parser::tokenBranches1927},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1938, x64Parser::tokenBranches1938},
    {x64Token::EOT}};
void x64Parser::TokenFunc1917(x64Operand& operand, int tokenPos) { operand.addressCoding = 158; }
x64Token x64Parser::tokenBranches1916[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1917,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1926},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1898(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1907(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1897[] = {
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1916},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1898, x64Parser::tokenBranches1898},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1907, x64Parser::tokenBranches1907},
    {x64Token::EOT}};
void x64Parser::TokenFunc1890(x64Operand& operand, int tokenPos) { operand.addressCoding = 156; }
x64Token x64Parser::tokenBranches1889[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1890,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1897},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1615(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1743(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1889(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1614[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1615, x64Parser::tokenBranches1615},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1743, x64Parser::tokenBranches1743},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1889, x64Parser::tokenBranches1889},
    {x64Token::EOT}};
void x64Parser::TokenFunc526(x64Operand& operand, int tokenPos) { operand.addressCoding = 52; }
x64Token x64Parser::tokenBranches525[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc526,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches536},
                                          {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1614},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc565(x64Operand& operand, int tokenPos) { operand.addressCoding = 64; }
x64Token x64Parser::tokenBranches564[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData4,
                                              &x64Parser::TokenFunc565,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc1231(x64Operand& operand, int tokenPos) { operand.addressCoding = 117; }
x64Token x64Parser::tokenBranches1230[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1231,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1240(x64Operand& operand, int tokenPos) { operand.addressCoding = 118; }
x64Token x64Parser::tokenBranches1239[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1240,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1249(x64Operand& operand, int tokenPos) { operand.addressCoding = 119; }
x64Token x64Parser::tokenBranches1248[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1249,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1230(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1239(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1248(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1229[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1230, x64Parser::tokenBranches1230},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1239, x64Parser::tokenBranches1239},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1248, x64Parser::tokenBranches1248},
    {x64Token::EOT}};
void x64Parser::TokenFunc1222(x64Operand& operand, int tokenPos) { operand.addressCoding = 117; }
x64Token x64Parser::tokenBranches1221[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1222,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1229},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1359(x64Operand& operand, int tokenPos) { operand.addressCoding = 126; }
x64Token x64Parser::tokenBranches1358[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1359,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1368(x64Operand& operand, int tokenPos) { operand.addressCoding = 127; }
x64Token x64Parser::tokenBranches1367[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1368,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1377(x64Operand& operand, int tokenPos) { operand.addressCoding = 128; }
x64Token x64Parser::tokenBranches1376[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1377,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1358(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1367(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1376(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1357[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1358, x64Parser::tokenBranches1358},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1367, x64Parser::tokenBranches1367},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1376, x64Parser::tokenBranches1376},
    {x64Token::EOT}};
void x64Parser::TokenFunc1350(x64Operand& operand, int tokenPos) { operand.addressCoding = 126; }
x64Token x64Parser::tokenBranches1349[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1350,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1357},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1221(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1349(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1220[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1221, x64Parser::tokenBranches1221},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1349, x64Parser::tokenBranches1349},
    {x64Token::EOT}};
x64Token x64Parser::tokenBranches1219[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1220},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3748(x64Operand& operand, int tokenPos) { operand.addressCoding = 309; }
x64Token x64Parser::tokenBranches3747[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3748,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3757(x64Operand& operand, int tokenPos) { operand.addressCoding = 310; }
x64Token x64Parser::tokenBranches3756[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3757,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3766(x64Operand& operand, int tokenPos) { operand.addressCoding = 311; }
x64Token x64Parser::tokenBranches3765[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3766,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3747(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3756(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3765(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3746[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3747, x64Parser::tokenBranches3747},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3756, x64Parser::tokenBranches3756},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3765, x64Parser::tokenBranches3765},
    {x64Token::EOT}};
void x64Parser::TokenFunc3739(x64Operand& operand, int tokenPos) { operand.addressCoding = 309; }
x64Token x64Parser::tokenBranches3738[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3739,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3746},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3876(x64Operand& operand, int tokenPos) { operand.addressCoding = 318; }
x64Token x64Parser::tokenBranches3875[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3876,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3885(x64Operand& operand, int tokenPos) { operand.addressCoding = 319; }
x64Token x64Parser::tokenBranches3884[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3885,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3894(x64Operand& operand, int tokenPos) { operand.addressCoding = 320; }
x64Token x64Parser::tokenBranches3893[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3894,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3875(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3884(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3893(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3874[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3875, x64Parser::tokenBranches3875},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3884, x64Parser::tokenBranches3884},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3893, x64Parser::tokenBranches3893},
    {x64Token::EOT}};
void x64Parser::TokenFunc3867(x64Operand& operand, int tokenPos) { operand.addressCoding = 318; }
x64Token x64Parser::tokenBranches3866[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3867,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3874},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3738(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3866(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3737[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3738, x64Parser::tokenBranches3738},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3866, x64Parser::tokenBranches3866},
    {x64Token::EOT}};
x64Token x64Parser::tokenBranches3736[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3737},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4004(x64Operand& operand, int tokenPos) { operand.addressCoding = 327; }
x64Token x64Parser::tokenBranches4003[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4004,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4013(x64Operand& operand, int tokenPos) { operand.addressCoding = 328; }
x64Token x64Parser::tokenBranches4012[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4013,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4022(x64Operand& operand, int tokenPos) { operand.addressCoding = 329; }
x64Token x64Parser::tokenBranches4021[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4022,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4003(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4012(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4021(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4002[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4003, x64Parser::tokenBranches4003},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4012, x64Parser::tokenBranches4012},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4021, x64Parser::tokenBranches4021},
    {x64Token::EOT}};
void x64Parser::TokenFunc3995(x64Operand& operand, int tokenPos) { operand.addressCoding = 327; }
x64Token x64Parser::tokenBranches3994[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3995,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4002},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4132(x64Operand& operand, int tokenPos) { operand.addressCoding = 336; }
x64Token x64Parser::tokenBranches4131[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4132,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4141(x64Operand& operand, int tokenPos) { operand.addressCoding = 337; }
x64Token x64Parser::tokenBranches4140[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4141,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4150(x64Operand& operand, int tokenPos) { operand.addressCoding = 338; }
x64Token x64Parser::tokenBranches4149[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4150,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4131(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4140(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4149(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4130[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4131, x64Parser::tokenBranches4131},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4140, x64Parser::tokenBranches4140},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4149, x64Parser::tokenBranches4149},
    {x64Token::EOT}};
void x64Parser::TokenFunc4123(x64Operand& operand, int tokenPos) { operand.addressCoding = 336; }
x64Token x64Parser::tokenBranches4122[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4123,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4130},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3994(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4122(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3993[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3994, x64Parser::tokenBranches3994},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4122, x64Parser::tokenBranches4122},
    {x64Token::EOT}};
x64Token x64Parser::tokenBranches3992[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3993},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc8(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc78(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
void x64Parser::TokenFunc525(x64Operand& operand, int tokenPos)
{
    operand.values[5] = new Coding[2];
    CleanupValues.push_back(operand.values[5]);
    operand.values[5]->type = Coding::reg;
    operand.values[5]->val = inputTokens[tokenPos]->val->ival;
    operand.values[5]->bits = 0;
    operand.values[5]->field = 0;
    operand.values[5]->unary = 0;
    operand.values[5]->binary = 0;
    operand.values[5][1].type = Coding::eot;
}
void x64Parser::TokenFunc564(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches7[] = {
    {x64Token::REGISTER, 29, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches33},
    {x64Token::REGISTER, 45, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches54},
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches505},
    {x64Token::REGISTER, 46, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches510},
    {x64Token::REGISTER, 50, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1219},
    {x64Token::REGISTER, 47, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3736},
    {x64Token::REGISTER, 51, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3992},
    {x64Token::NUMBER, 6, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc8, x64Parser::tokenBranches8},
    {x64Token::REGISTERCLASS, 15, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc78, x64Parser::tokenBranches78},
    {x64Token::REGISTERCLASS, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc525, x64Parser::tokenBranches525},
    {x64Token::NUMBER, 7, 0, 0, x64Parser::RegClassData4, &x64Parser::TokenFunc564, x64Parser::tokenBranches564},
    {x64Token::EOT}};
x64Token x64Parser::tokenBranches6[] = {{x64Token::TOKEN, 3, 0, 0, x64Parser::RegClassData1, NULL, x64Parser::tokenBranches7},
                                        {x64Token::EOT}};
void x64Parser::TokenFunc14(x64Operand& operand, int tokenPos) { operand.addressCoding = 2; }
x64Token x64Parser::tokenBranches13[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc14,
                                         },
                                         {x64Token::EOT}};
void x64Parser::TokenFunc209(x64Operand& operand, int tokenPos) { operand.addressCoding = 21; }
x64Token x64Parser::tokenBranches208[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc209,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc355(x64Operand& operand, int tokenPos) { operand.addressCoding = 36; }
x64Token x64Parser::tokenBranches354[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc355,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc208(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc354(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches207[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc208, x64Parser::tokenBranches208},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc354, x64Parser::tokenBranches354},
    {x64Token::EOT}};
void x64Parser::TokenFunc43(x64Operand& operand, int tokenPos) { operand.addressCoding = 6; }
x64Token x64Parser::tokenBranches42[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc43,
                                         },
                                         {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches207},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc144(x64Operand& operand, int tokenPos) { operand.addressCoding = 14; }
x64Token x64Parser::tokenBranches143[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc144,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc290(x64Operand& operand, int tokenPos) { operand.addressCoding = 29; }
x64Token x64Parser::tokenBranches289[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc290,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc436(x64Operand& operand, int tokenPos) { operand.addressCoding = 44; }
x64Token x64Parser::tokenBranches435[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc436,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc42(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
void x64Parser::TokenFunc143(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc289(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc435(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches41[] = {
    {x64Token::REGISTERCLASS, 15, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc42, x64Parser::tokenBranches42},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc143, x64Parser::tokenBranches143},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc289, x64Parser::tokenBranches289},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc435, x64Parser::tokenBranches435},
    {x64Token::EOT}};
void x64Parser::TokenFunc102(x64Operand& operand, int tokenPos) { operand.addressCoding = 14; }
x64Token x64Parser::tokenBranches40[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches41},
                                         {
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc102,
                                         },
                                         {x64Token::EOT}};
void x64Parser::TokenFunc218(x64Operand& operand, int tokenPos) { operand.addressCoding = 20; }
x64Token x64Parser::tokenBranches217[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc218,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc364(x64Operand& operand, int tokenPos) { operand.addressCoding = 35; }
x64Token x64Parser::tokenBranches363[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc364,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc217(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc363(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches216[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc217, x64Parser::tokenBranches217},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc363, x64Parser::tokenBranches363},
    {x64Token::EOT}};
void x64Parser::TokenFunc50(x64Operand& operand, int tokenPos) { operand.addressCoding = 5; }
x64Token x64Parser::tokenBranches49[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc50,
                                         },
                                         {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches216},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc163(x64Operand& operand, int tokenPos) { operand.addressCoding = 16; }
x64Token x64Parser::tokenBranches162[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc163,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc309(x64Operand& operand, int tokenPos) { operand.addressCoding = 31; }
x64Token x64Parser::tokenBranches308[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc309,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc455(x64Operand& operand, int tokenPos) { operand.addressCoding = 46; }
x64Token x64Parser::tokenBranches454[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc455,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc49(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
void x64Parser::TokenFunc162(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc308(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc454(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches48[] = {
    {x64Token::REGISTERCLASS, 15, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc49, x64Parser::tokenBranches49},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc162, x64Parser::tokenBranches162},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc308, x64Parser::tokenBranches308},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc454, x64Parser::tokenBranches454},
    {x64Token::EOT}};
void x64Parser::TokenFunc115(x64Operand& operand, int tokenPos) { operand.addressCoding = 16; }
x64Token x64Parser::tokenBranches47[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches48},
                                         {
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc115,
                                         },
                                         {x64Token::EOT}};
void x64Parser::TokenFunc264(x64Operand& operand, int tokenPos) { operand.addressCoding = 26; }
x64Token x64Parser::tokenBranches263[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc264,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc410(x64Operand& operand, int tokenPos) { operand.addressCoding = 41; }
x64Token x64Parser::tokenBranches409[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc410,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc263(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc409(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches262[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc263, x64Parser::tokenBranches263},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc409, x64Parser::tokenBranches409},
    {x64Token::EOT}};
void x64Parser::TokenFunc84(x64Operand& operand, int tokenPos) { operand.addressCoding = 11; }
x64Token x64Parser::tokenBranches83[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc84,
                                         },
                                         {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches262},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc592(x64Operand& operand, int tokenPos) { operand.addressCoding = 49; }
x64Token x64Parser::tokenBranches591[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc592,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc716(x64Operand& operand, int tokenPos) { operand.addressCoding = 68; }
x64Token x64Parser::tokenBranches715[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc716,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc840(x64Operand& operand, int tokenPos) { operand.addressCoding = 82; }
x64Token x64Parser::tokenBranches839[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc840,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2161(x64Operand& operand, int tokenPos) { operand.addressCoding = 172; }
x64Token x64Parser::tokenBranches2160[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2161,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2720(x64Operand& operand, int tokenPos) { operand.addressCoding = 196; }
x64Token x64Parser::tokenBranches2719[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2720,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2991(x64Operand& operand, int tokenPos) { operand.addressCoding = 226; }
x64Token x64Parser::tokenBranches2990[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2991,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2160(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2719(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2990(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2159[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2160, x64Parser::tokenBranches2160},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2719, x64Parser::tokenBranches2719},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2990, x64Parser::tokenBranches2990},
    {x64Token::EOT}};
void x64Parser::TokenFunc2435(x64Operand& operand, int tokenPos) { operand.addressCoding = 172; }
x64Token x64Parser::tokenBranches2158[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2159},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2435,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2158(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2157[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2158, x64Parser::tokenBranches2158},
    {x64Token::EOT}};
void x64Parser::TokenFunc2170(x64Operand& operand, int tokenPos) { operand.addressCoding = 173; }
x64Token x64Parser::tokenBranches2169[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2170,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2729(x64Operand& operand, int tokenPos) { operand.addressCoding = 197; }
x64Token x64Parser::tokenBranches2728[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2729,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3000(x64Operand& operand, int tokenPos) { operand.addressCoding = 227; }
x64Token x64Parser::tokenBranches2999[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3000,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2169(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2728(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2999(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2168[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2169, x64Parser::tokenBranches2169},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2728, x64Parser::tokenBranches2728},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2999, x64Parser::tokenBranches2999},
    {x64Token::EOT}};
void x64Parser::TokenFunc2442(x64Operand& operand, int tokenPos) { operand.addressCoding = 173; }
x64Token x64Parser::tokenBranches2156[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2157},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2168},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2442,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc591(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc715(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc839(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2156(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches590[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc591, x64Parser::tokenBranches591},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc715, x64Parser::tokenBranches715},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc839, x64Parser::tokenBranches839},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2156, x64Parser::tokenBranches2156},
    {x64Token::EOT}};
void x64Parser::TokenFunc516(x64Operand& operand, int tokenPos) { operand.addressCoding = 49; }
x64Token x64Parser::tokenBranches515[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc516,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches590},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc599(x64Operand& operand, int tokenPos) { operand.addressCoding = 50; }
x64Token x64Parser::tokenBranches598[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc599,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc723(x64Operand& operand, int tokenPos) { operand.addressCoding = 69; }
x64Token x64Parser::tokenBranches722[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc723,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc847(x64Operand& operand, int tokenPos) { operand.addressCoding = 83; }
x64Token x64Parser::tokenBranches846[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc847,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2141(x64Operand& operand, int tokenPos) { operand.addressCoding = 170; }
x64Token x64Parser::tokenBranches2140[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2141,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2700(x64Operand& operand, int tokenPos) { operand.addressCoding = 194; }
x64Token x64Parser::tokenBranches2699[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2700,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2971(x64Operand& operand, int tokenPos) { operand.addressCoding = 224; }
x64Token x64Parser::tokenBranches2970[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2971,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2140(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2699(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2970(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2139[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2140, x64Parser::tokenBranches2140},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2699, x64Parser::tokenBranches2699},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2970, x64Parser::tokenBranches2970},
    {x64Token::EOT}};
void x64Parser::TokenFunc2419(x64Operand& operand, int tokenPos) { operand.addressCoding = 170; }
x64Token x64Parser::tokenBranches2138[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2139},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2419,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2138(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2137[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2138, x64Parser::tokenBranches2138},
    {x64Token::EOT}};
void x64Parser::TokenFunc2150(x64Operand& operand, int tokenPos) { operand.addressCoding = 171; }
x64Token x64Parser::tokenBranches2149[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2150,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2709(x64Operand& operand, int tokenPos) { operand.addressCoding = 195; }
x64Token x64Parser::tokenBranches2708[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2709,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2980(x64Operand& operand, int tokenPos) { operand.addressCoding = 225; }
x64Token x64Parser::tokenBranches2979[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2980,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2149(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2708(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2979(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2148[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2149, x64Parser::tokenBranches2149},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2708, x64Parser::tokenBranches2708},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2979, x64Parser::tokenBranches2979},
    {x64Token::EOT}};
void x64Parser::TokenFunc2426(x64Operand& operand, int tokenPos) { operand.addressCoding = 171; }
x64Token x64Parser::tokenBranches2136[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2137},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2148},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2426,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2228(x64Operand& operand, int tokenPos) { operand.addressCoding = 169; }
x64Token x64Parser::tokenBranches2227[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2228,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2640(x64Operand& operand, int tokenPos) { operand.addressCoding = 193; }
x64Token x64Parser::tokenBranches2639[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2640,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3018(x64Operand& operand, int tokenPos) { operand.addressCoding = 219; }
x64Token x64Parser::tokenBranches3017[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3018,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2227(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2639(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3017(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2226[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2227, x64Parser::tokenBranches2227},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2639, x64Parser::tokenBranches2639},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3017, x64Parser::tokenBranches3017},
    {x64Token::EOT}};
void x64Parser::TokenFunc2456(x64Operand& operand, int tokenPos) { operand.addressCoding = 169; }
x64Token x64Parser::tokenBranches2225[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2226},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2456,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc598(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc722(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc846(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2136(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches597[] = {
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2225},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc598, x64Parser::tokenBranches598},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc722, x64Parser::tokenBranches722},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc846, x64Parser::tokenBranches846},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2136, x64Parser::tokenBranches2136},
    {x64Token::EOT}};
void x64Parser::TokenFunc1009(x64Operand& operand, int tokenPos) { operand.addressCoding = 96; }
x64Token x64Parser::tokenBranches1008[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1009,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1018(x64Operand& operand, int tokenPos) { operand.addressCoding = 97; }
x64Token x64Parser::tokenBranches1017[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1018,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1027(x64Operand& operand, int tokenPos) { operand.addressCoding = 98; }
x64Token x64Parser::tokenBranches1026[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1027,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1008(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1017(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1026(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1007[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1008, x64Parser::tokenBranches1008},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1017, x64Parser::tokenBranches1017},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1026, x64Parser::tokenBranches1026},
    {x64Token::EOT}};
void x64Parser::TokenFunc1000(x64Operand& operand, int tokenPos) { operand.addressCoding = 96; }
x64Token x64Parser::tokenBranches999[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc1000,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1007},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc1137(x64Operand& operand, int tokenPos) { operand.addressCoding = 105; }
x64Token x64Parser::tokenBranches1136[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1137,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1146(x64Operand& operand, int tokenPos) { operand.addressCoding = 106; }
x64Token x64Parser::tokenBranches1145[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1146,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1155(x64Operand& operand, int tokenPos) { operand.addressCoding = 107; }
x64Token x64Parser::tokenBranches1154[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1155,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1136(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1145(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1154(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1135[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1136, x64Parser::tokenBranches1136},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1145, x64Parser::tokenBranches1145},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1154, x64Parser::tokenBranches1154},
    {x64Token::EOT}};
void x64Parser::TokenFunc1128(x64Operand& operand, int tokenPos) { operand.addressCoding = 105; }
x64Token x64Parser::tokenBranches1127[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1128,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1135},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1505(x64Operand& operand, int tokenPos) { operand.addressCoding = 132; }
x64Token x64Parser::tokenBranches1504[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1505,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1514(x64Operand& operand, int tokenPos) { operand.addressCoding = 133; }
x64Token x64Parser::tokenBranches1513[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1514,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1504(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1513(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1503[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1504, x64Parser::tokenBranches1504},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1513, x64Parser::tokenBranches1513},
    {x64Token::EOT}};
void x64Parser::TokenFunc1496(x64Operand& operand, int tokenPos) { operand.addressCoding = 132; }
x64Token x64Parser::tokenBranches1495[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1496,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1503},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc999(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1127(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1495(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches998[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc999, x64Parser::tokenBranches999},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1127, x64Parser::tokenBranches1127},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1495, x64Parser::tokenBranches1495},
    {x64Token::EOT}};
void x64Parser::TokenFunc521(x64Operand& operand, int tokenPos) { operand.addressCoding = 50; }
x64Token x64Parser::tokenBranches520[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc521,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches597},
                                          {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches998},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc669(x64Operand& operand, int tokenPos) { operand.addressCoding = 60; }
x64Token x64Parser::tokenBranches668[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc669,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc793(x64Operand& operand, int tokenPos) { operand.addressCoding = 79; }
x64Token x64Parser::tokenBranches792[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc793,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc917(x64Operand& operand, int tokenPos) { operand.addressCoding = 93; }
x64Token x64Parser::tokenBranches916[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc917,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc668(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc792(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc916(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches667[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc668, x64Parser::tokenBranches668},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc792, x64Parser::tokenBranches792},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc916, x64Parser::tokenBranches916},
    {x64Token::EOT}};
void x64Parser::TokenFunc545(x64Operand& operand, int tokenPos) { operand.addressCoding = 60; }
x64Token x64Parser::tokenBranches544[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc545,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches667},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc660(x64Operand& operand, int tokenPos) { operand.addressCoding = 59; }
x64Token x64Parser::tokenBranches659[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc660,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc784(x64Operand& operand, int tokenPos) { operand.addressCoding = 78; }
x64Token x64Parser::tokenBranches783[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc784,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc908(x64Operand& operand, int tokenPos) { operand.addressCoding = 92; }
x64Token x64Parser::tokenBranches907[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc908,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2320(x64Operand& operand, int tokenPos) { operand.addressCoding = 189; }
x64Token x64Parser::tokenBranches2319[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2320,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2852(x64Operand& operand, int tokenPos) { operand.addressCoding = 215; }
x64Token x64Parser::tokenBranches2851[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2852,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3150(x64Operand& operand, int tokenPos) { operand.addressCoding = 240; }
x64Token x64Parser::tokenBranches3149[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3150,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2319(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2851(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3149(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2318[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2319, x64Parser::tokenBranches2319},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2851, x64Parser::tokenBranches2851},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3149, x64Parser::tokenBranches3149},
    {x64Token::EOT}};
void x64Parser::TokenFunc2560(x64Operand& operand, int tokenPos) { operand.addressCoding = 189; }
x64Token x64Parser::tokenBranches2317[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2318},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2560,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2317(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2316[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2317, x64Parser::tokenBranches2317},
    {x64Token::EOT}};
void x64Parser::TokenFunc2329(x64Operand& operand, int tokenPos) { operand.addressCoding = 190; }
x64Token x64Parser::tokenBranches2328[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2329,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2861(x64Operand& operand, int tokenPos) { operand.addressCoding = 216; }
x64Token x64Parser::tokenBranches2860[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2861,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3159(x64Operand& operand, int tokenPos) { operand.addressCoding = 241; }
x64Token x64Parser::tokenBranches3158[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3159,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2328(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2860(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3158(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2327[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2328, x64Parser::tokenBranches2328},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2860, x64Parser::tokenBranches2860},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3158, x64Parser::tokenBranches3158},
    {x64Token::EOT}};
void x64Parser::TokenFunc2567(x64Operand& operand, int tokenPos) { operand.addressCoding = 190; }
x64Token x64Parser::tokenBranches2315[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2316},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2327},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2567,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc659(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc783(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc907(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2315(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches543[] = {
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches544},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc659, x64Parser::tokenBranches659},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc783, x64Parser::tokenBranches783},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc907, x64Parser::tokenBranches907},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2315, x64Parser::tokenBranches2315},
    {x64Token::EOT}};
void x64Parser::TokenFunc1659(x64Operand& operand, int tokenPos) { operand.addressCoding = 141; }
x64Token x64Parser::tokenBranches1658[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1659,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1668(x64Operand& operand, int tokenPos) { operand.addressCoding = 142; }
x64Token x64Parser::tokenBranches1667[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1668,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1677(x64Operand& operand, int tokenPos) { operand.addressCoding = 143; }
x64Token x64Parser::tokenBranches1676[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1677,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1658(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1667(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1676(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1657[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1658, x64Parser::tokenBranches1658},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1667, x64Parser::tokenBranches1667},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1676, x64Parser::tokenBranches1676},
    {x64Token::EOT}};
void x64Parser::TokenFunc1650(x64Operand& operand, int tokenPos) { operand.addressCoding = 141; }
x64Token x64Parser::tokenBranches1649[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1650,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1657},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1787(x64Operand& operand, int tokenPos) { operand.addressCoding = 150; }
x64Token x64Parser::tokenBranches1786[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1787,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1796(x64Operand& operand, int tokenPos) { operand.addressCoding = 151; }
x64Token x64Parser::tokenBranches1795[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1796,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1805(x64Operand& operand, int tokenPos) { operand.addressCoding = 152; }
x64Token x64Parser::tokenBranches1804[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1805,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1786(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1795(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1804(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1785[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1786, x64Parser::tokenBranches1786},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1795, x64Parser::tokenBranches1795},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1804, x64Parser::tokenBranches1804},
    {x64Token::EOT}};
void x64Parser::TokenFunc1778(x64Operand& operand, int tokenPos) { operand.addressCoding = 150; }
x64Token x64Parser::tokenBranches1777[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1778,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1785},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1955(x64Operand& operand, int tokenPos) { operand.addressCoding = 161; }
x64Token x64Parser::tokenBranches1954[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1955,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1964(x64Operand& operand, int tokenPos) { operand.addressCoding = 162; }
x64Token x64Parser::tokenBranches1963[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1964,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1984(x64Operand& operand, int tokenPos) { operand.addressCoding = 163; }
x64Token x64Parser::tokenBranches1983[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1984,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1995(x64Operand& operand, int tokenPos) { operand.addressCoding = 164; }
x64Token x64Parser::tokenBranches1994[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1995,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1983(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1994(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1982[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1983, x64Parser::tokenBranches1983},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1994, x64Parser::tokenBranches1994},
    {x64Token::EOT}};
void x64Parser::TokenFunc1973(x64Operand& operand, int tokenPos) { operand.addressCoding = 163; }
x64Token x64Parser::tokenBranches1972[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1973,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1982},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1954(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1963(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1953[] = {
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1972},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1954, x64Parser::tokenBranches1954},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1963, x64Parser::tokenBranches1963},
    {x64Token::EOT}};
void x64Parser::TokenFunc1946(x64Operand& operand, int tokenPos) { operand.addressCoding = 160; }
x64Token x64Parser::tokenBranches1945[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1946,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1953},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1649(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1777(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1945(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1648[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1649, x64Parser::tokenBranches1649},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1777, x64Parser::tokenBranches1777},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1945, x64Parser::tokenBranches1945},
    {x64Token::EOT}};
void x64Parser::TokenFunc531(x64Operand& operand, int tokenPos) { operand.addressCoding = 59; }
x64Token x64Parser::tokenBranches530[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc531,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches543},
                                          {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1648},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc570(x64Operand& operand, int tokenPos) { operand.addressCoding = 65; }
x64Token x64Parser::tokenBranches569[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData4,
                                              &x64Parser::TokenFunc570,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc1265(x64Operand& operand, int tokenPos) { operand.addressCoding = 114; }
x64Token x64Parser::tokenBranches1264[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1265,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1274(x64Operand& operand, int tokenPos) { operand.addressCoding = 115; }
x64Token x64Parser::tokenBranches1273[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1274,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1283(x64Operand& operand, int tokenPos) { operand.addressCoding = 116; }
x64Token x64Parser::tokenBranches1282[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1283,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1264(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1273(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1282(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1263[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1264, x64Parser::tokenBranches1264},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1273, x64Parser::tokenBranches1273},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1282, x64Parser::tokenBranches1282},
    {x64Token::EOT}};
void x64Parser::TokenFunc1256(x64Operand& operand, int tokenPos) { operand.addressCoding = 114; }
x64Token x64Parser::tokenBranches1255[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1256,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1263},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1393(x64Operand& operand, int tokenPos) { operand.addressCoding = 123; }
x64Token x64Parser::tokenBranches1392[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1393,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1402(x64Operand& operand, int tokenPos) { operand.addressCoding = 124; }
x64Token x64Parser::tokenBranches1401[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1402,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1411(x64Operand& operand, int tokenPos) { operand.addressCoding = 125; }
x64Token x64Parser::tokenBranches1410[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1411,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1392(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1401(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1410(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1391[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1392, x64Parser::tokenBranches1392},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1401, x64Parser::tokenBranches1401},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1410, x64Parser::tokenBranches1410},
    {x64Token::EOT}};
void x64Parser::TokenFunc1384(x64Operand& operand, int tokenPos) { operand.addressCoding = 123; }
x64Token x64Parser::tokenBranches1383[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1384,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1391},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1255(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1383(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1254[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1255, x64Parser::tokenBranches1255},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1383, x64Parser::tokenBranches1383},
    {x64Token::EOT}};
x64Token x64Parser::tokenBranches1253[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1254},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3782(x64Operand& operand, int tokenPos) { operand.addressCoding = 306; }
x64Token x64Parser::tokenBranches3781[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3782,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3791(x64Operand& operand, int tokenPos) { operand.addressCoding = 307; }
x64Token x64Parser::tokenBranches3790[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3791,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3800(x64Operand& operand, int tokenPos) { operand.addressCoding = 308; }
x64Token x64Parser::tokenBranches3799[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3800,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3781(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3790(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3799(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3780[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3781, x64Parser::tokenBranches3781},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3790, x64Parser::tokenBranches3790},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3799, x64Parser::tokenBranches3799},
    {x64Token::EOT}};
void x64Parser::TokenFunc3773(x64Operand& operand, int tokenPos) { operand.addressCoding = 306; }
x64Token x64Parser::tokenBranches3772[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3773,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3780},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3910(x64Operand& operand, int tokenPos) { operand.addressCoding = 315; }
x64Token x64Parser::tokenBranches3909[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3910,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3919(x64Operand& operand, int tokenPos) { operand.addressCoding = 316; }
x64Token x64Parser::tokenBranches3918[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3919,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3928(x64Operand& operand, int tokenPos) { operand.addressCoding = 317; }
x64Token x64Parser::tokenBranches3927[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3928,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3909(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3918(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3927(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3908[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3909, x64Parser::tokenBranches3909},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3918, x64Parser::tokenBranches3918},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3927, x64Parser::tokenBranches3927},
    {x64Token::EOT}};
void x64Parser::TokenFunc3901(x64Operand& operand, int tokenPos) { operand.addressCoding = 315; }
x64Token x64Parser::tokenBranches3900[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3901,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3908},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3772(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3900(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3771[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3772, x64Parser::tokenBranches3772},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3900, x64Parser::tokenBranches3900},
    {x64Token::EOT}};
x64Token x64Parser::tokenBranches3770[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3771},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4038(x64Operand& operand, int tokenPos) { operand.addressCoding = 324; }
x64Token x64Parser::tokenBranches4037[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4038,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4047(x64Operand& operand, int tokenPos) { operand.addressCoding = 325; }
x64Token x64Parser::tokenBranches4046[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4047,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4056(x64Operand& operand, int tokenPos) { operand.addressCoding = 326; }
x64Token x64Parser::tokenBranches4055[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4056,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4037(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4046(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4055(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4036[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4037, x64Parser::tokenBranches4037},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4046, x64Parser::tokenBranches4046},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4055, x64Parser::tokenBranches4055},
    {x64Token::EOT}};
void x64Parser::TokenFunc4029(x64Operand& operand, int tokenPos) { operand.addressCoding = 324; }
x64Token x64Parser::tokenBranches4028[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4029,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4036},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4166(x64Operand& operand, int tokenPos) { operand.addressCoding = 333; }
x64Token x64Parser::tokenBranches4165[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4166,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4175(x64Operand& operand, int tokenPos) { operand.addressCoding = 334; }
x64Token x64Parser::tokenBranches4174[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4175,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4184(x64Operand& operand, int tokenPos) { operand.addressCoding = 335; }
x64Token x64Parser::tokenBranches4183[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4184,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4165(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4174(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4183(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4164[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4165, x64Parser::tokenBranches4165},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4174, x64Parser::tokenBranches4174},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4183, x64Parser::tokenBranches4183},
    {x64Token::EOT}};
void x64Parser::TokenFunc4157(x64Operand& operand, int tokenPos) { operand.addressCoding = 333; }
x64Token x64Parser::tokenBranches4156[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4157,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4164},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4028(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4156(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4027[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4028, x64Parser::tokenBranches4028},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4156, x64Parser::tokenBranches4156},
    {x64Token::EOT}};
x64Token x64Parser::tokenBranches4026[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4027},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc13(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc83(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
void x64Parser::TokenFunc530(x64Operand& operand, int tokenPos)
{
    operand.values[5] = new Coding[2];
    CleanupValues.push_back(operand.values[5]);
    operand.values[5]->type = Coding::reg;
    operand.values[5]->val = inputTokens[tokenPos]->val->ival;
    operand.values[5]->bits = 0;
    operand.values[5]->field = 0;
    operand.values[5]->unary = 0;
    operand.values[5]->binary = 0;
    operand.values[5][1].type = Coding::eot;
}
void x64Parser::TokenFunc569(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches12[] = {
    {x64Token::REGISTER, 29, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches40},
    {x64Token::REGISTER, 45, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches47},
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches515},
    {x64Token::REGISTER, 46, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches520},
    {x64Token::REGISTER, 50, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1253},
    {x64Token::REGISTER, 47, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3770},
    {x64Token::REGISTER, 51, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4026},
    {x64Token::NUMBER, 6, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc13, x64Parser::tokenBranches13},
    {x64Token::REGISTERCLASS, 15, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc83, x64Parser::tokenBranches83},
    {x64Token::REGISTERCLASS, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc530, x64Parser::tokenBranches530},
    {x64Token::NUMBER, 7, 0, 0, x64Parser::RegClassData4, &x64Parser::TokenFunc569, x64Parser::tokenBranches569},
    {x64Token::EOT}};
x64Token x64Parser::tokenBranches11[] = {{x64Token::TOKEN, 3, 0, 0, x64Parser::RegClassData1, NULL, x64Parser::tokenBranches12},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc19(x64Operand& operand, int tokenPos) { operand.addressCoding = 3; }
x64Token x64Parser::tokenBranches18[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc19,
                                         },
                                         {x64Token::EOT}};
void x64Parser::TokenFunc236(x64Operand& operand, int tokenPos) { operand.addressCoding = 23; }
x64Token x64Parser::tokenBranches235[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc236,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc382(x64Operand& operand, int tokenPos) { operand.addressCoding = 38; }
x64Token x64Parser::tokenBranches381[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc382,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc235(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc381(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches234[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc235, x64Parser::tokenBranches235},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc381, x64Parser::tokenBranches381},
    {x64Token::EOT}};
void x64Parser::TokenFunc64(x64Operand& operand, int tokenPos) { operand.addressCoding = 8; }
x64Token x64Parser::tokenBranches63[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc64,
                                         },
                                         {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches234},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc151(x64Operand& operand, int tokenPos) { operand.addressCoding = 15; }
x64Token x64Parser::tokenBranches150[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc151,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc297(x64Operand& operand, int tokenPos) { operand.addressCoding = 30; }
x64Token x64Parser::tokenBranches296[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc297,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc443(x64Operand& operand, int tokenPos) { operand.addressCoding = 45; }
x64Token x64Parser::tokenBranches442[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc443,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc63(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
void x64Parser::TokenFunc150(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc296(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc442(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches62[] = {
    {x64Token::REGISTERCLASS, 15, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc63, x64Parser::tokenBranches63},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc150, x64Parser::tokenBranches150},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc296, x64Parser::tokenBranches296},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc442, x64Parser::tokenBranches442},
    {x64Token::EOT}};
void x64Parser::TokenFunc107(x64Operand& operand, int tokenPos) { operand.addressCoding = 15; }
x64Token x64Parser::tokenBranches61[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches62},
                                         {
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc107,
                                         },
                                         {x64Token::EOT}};
void x64Parser::TokenFunc245(x64Operand& operand, int tokenPos) { operand.addressCoding = 24; }
x64Token x64Parser::tokenBranches244[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc245,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc391(x64Operand& operand, int tokenPos) { operand.addressCoding = 39; }
x64Token x64Parser::tokenBranches390[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc391,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc244(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc390(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches243[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc244, x64Parser::tokenBranches244},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc390, x64Parser::tokenBranches390},
    {x64Token::EOT}};
void x64Parser::TokenFunc71(x64Operand& operand, int tokenPos) { operand.addressCoding = 9; }
x64Token x64Parser::tokenBranches70[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc71,
                                         },
                                         {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches243},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc177(x64Operand& operand, int tokenPos) { operand.addressCoding = 18; }
x64Token x64Parser::tokenBranches176[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc177,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc323(x64Operand& operand, int tokenPos) { operand.addressCoding = 33; }
x64Token x64Parser::tokenBranches322[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc323,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc469(x64Operand& operand, int tokenPos) { operand.addressCoding = 48; }
x64Token x64Parser::tokenBranches468[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc469,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc70(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
void x64Parser::TokenFunc176(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc322(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc468(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches69[] = {
    {x64Token::REGISTERCLASS, 15, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc70, x64Parser::tokenBranches70},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc176, x64Parser::tokenBranches176},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc322, x64Parser::tokenBranches322},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc468, x64Parser::tokenBranches468},
    {x64Token::EOT}};
void x64Parser::TokenFunc125(x64Operand& operand, int tokenPos) { operand.addressCoding = 18; }
x64Token x64Parser::tokenBranches68[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches69},
                                         {
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc125,
                                         },
                                         {x64Token::EOT}};
void x64Parser::TokenFunc271(x64Operand& operand, int tokenPos) { operand.addressCoding = 27; }
x64Token x64Parser::tokenBranches270[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc271,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc417(x64Operand& operand, int tokenPos) { operand.addressCoding = 42; }
x64Token x64Parser::tokenBranches416[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc417,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc270(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc416(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches269[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc270, x64Parser::tokenBranches270},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc416, x64Parser::tokenBranches416},
    {x64Token::EOT}};
void x64Parser::TokenFunc89(x64Operand& operand, int tokenPos) { operand.addressCoding = 12; }
x64Token x64Parser::tokenBranches88[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc89,
                                         },
                                         {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches269},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc730(x64Operand& operand, int tokenPos) { operand.addressCoding = 72; }
x64Token x64Parser::tokenBranches729[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc730,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc854(x64Operand& operand, int tokenPos) { operand.addressCoding = 86; }
x64Token x64Parser::tokenBranches853[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc854,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2201(x64Operand& operand, int tokenPos) { operand.addressCoding = 180; }
x64Token x64Parser::tokenBranches2200[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2201,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2760(x64Operand& operand, int tokenPos) { operand.addressCoding = 206; }
x64Token x64Parser::tokenBranches2759[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2760,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3058(x64Operand& operand, int tokenPos) { operand.addressCoding = 232; }
x64Token x64Parser::tokenBranches3057[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3058,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2200(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2759(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3057(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2199[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2200, x64Parser::tokenBranches2200},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2759, x64Parser::tokenBranches2759},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3057, x64Parser::tokenBranches3057},
    {x64Token::EOT}};
void x64Parser::TokenFunc2488(x64Operand& operand, int tokenPos) { operand.addressCoding = 180; }
x64Token x64Parser::tokenBranches2198[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2199},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2488,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2198(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2197[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2198, x64Parser::tokenBranches2198},
    {x64Token::EOT}};
void x64Parser::TokenFunc2210(x64Operand& operand, int tokenPos) { operand.addressCoding = 181; }
x64Token x64Parser::tokenBranches2209[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2210,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2769(x64Operand& operand, int tokenPos) { operand.addressCoding = 207; }
x64Token x64Parser::tokenBranches2768[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2769,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3067(x64Operand& operand, int tokenPos) { operand.addressCoding = 233; }
x64Token x64Parser::tokenBranches3066[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3067,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2209(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2768(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3066(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2208[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2209, x64Parser::tokenBranches2209},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2768, x64Parser::tokenBranches2768},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3066, x64Parser::tokenBranches3066},
    {x64Token::EOT}};
void x64Parser::TokenFunc2495(x64Operand& operand, int tokenPos) { operand.addressCoding = 181; }
x64Token x64Parser::tokenBranches2196[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2197},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2208},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2495,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc729(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc853(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2196(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches728[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc729, x64Parser::tokenBranches729},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc853, x64Parser::tokenBranches853},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2196, x64Parser::tokenBranches2196},
    {x64Token::EOT}};
void x64Parser::TokenFunc491(x64Operand& operand, int tokenPos) { operand.addressCoding = 54; }
x64Token x64Parser::tokenBranches490[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc491,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches728},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc737(x64Operand& operand, int tokenPos) { operand.addressCoding = 73; }
x64Token x64Parser::tokenBranches736[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc737,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc861(x64Operand& operand, int tokenPos) { operand.addressCoding = 87; }
x64Token x64Parser::tokenBranches860[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc861,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2181(x64Operand& operand, int tokenPos) { operand.addressCoding = 178; }
x64Token x64Parser::tokenBranches2180[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2181,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2740(x64Operand& operand, int tokenPos) { operand.addressCoding = 204; }
x64Token x64Parser::tokenBranches2739[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2740,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3038(x64Operand& operand, int tokenPos) { operand.addressCoding = 230; }
x64Token x64Parser::tokenBranches3037[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3038,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2180(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2739(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3037(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2179[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2180, x64Parser::tokenBranches2180},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2739, x64Parser::tokenBranches2739},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3037, x64Parser::tokenBranches3037},
    {x64Token::EOT}};
void x64Parser::TokenFunc2472(x64Operand& operand, int tokenPos) { operand.addressCoding = 178; }
x64Token x64Parser::tokenBranches2178[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2179},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2472,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2178(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2177[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2178, x64Parser::tokenBranches2178},
    {x64Token::EOT}};
void x64Parser::TokenFunc2190(x64Operand& operand, int tokenPos) { operand.addressCoding = 179; }
x64Token x64Parser::tokenBranches2189[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2190,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2749(x64Operand& operand, int tokenPos) { operand.addressCoding = 205; }
x64Token x64Parser::tokenBranches2748[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2749,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3047(x64Operand& operand, int tokenPos) { operand.addressCoding = 231; }
x64Token x64Parser::tokenBranches3046[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3047,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2189(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2748(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3046(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2188[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2189, x64Parser::tokenBranches2189},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2748, x64Parser::tokenBranches2748},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3046, x64Parser::tokenBranches3046},
    {x64Token::EOT}};
void x64Parser::TokenFunc2479(x64Operand& operand, int tokenPos) { operand.addressCoding = 179; }
x64Token x64Parser::tokenBranches2176[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2177},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2188},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2479,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2237(x64Operand& operand, int tokenPos) { operand.addressCoding = 183; }
x64Token x64Parser::tokenBranches2236[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2237,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2649(x64Operand& operand, int tokenPos) { operand.addressCoding = 199; }
x64Token x64Parser::tokenBranches2648[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2649,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3027(x64Operand& operand, int tokenPos) { operand.addressCoding = 229; }
x64Token x64Parser::tokenBranches3026[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3027,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2236(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2648(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3026(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2235[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2236, x64Parser::tokenBranches2236},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2648, x64Parser::tokenBranches2648},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3026, x64Parser::tokenBranches3026},
    {x64Token::EOT}};
void x64Parser::TokenFunc2463(x64Operand& operand, int tokenPos) { operand.addressCoding = 183; }
x64Token x64Parser::tokenBranches2234[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2235},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2463,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc736(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc860(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2176(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches735[] = {
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2234},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc736, x64Parser::tokenBranches736},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc860, x64Parser::tokenBranches860},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2176, x64Parser::tokenBranches2176},
    {x64Token::EOT}};
void x64Parser::TokenFunc1043(x64Operand& operand, int tokenPos) { operand.addressCoding = 102; }
x64Token x64Parser::tokenBranches1042[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1043,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1052(x64Operand& operand, int tokenPos) { operand.addressCoding = 103; }
x64Token x64Parser::tokenBranches1051[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1052,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1061(x64Operand& operand, int tokenPos) { operand.addressCoding = 104; }
x64Token x64Parser::tokenBranches1060[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1061,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1042(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1051(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1060(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1041[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1042, x64Parser::tokenBranches1042},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1051, x64Parser::tokenBranches1051},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1060, x64Parser::tokenBranches1060},
    {x64Token::EOT}};
void x64Parser::TokenFunc1034(x64Operand& operand, int tokenPos) { operand.addressCoding = 102; }
x64Token x64Parser::tokenBranches1033[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1034,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1041},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1171(x64Operand& operand, int tokenPos) { operand.addressCoding = 111; }
x64Token x64Parser::tokenBranches1170[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1171,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1180(x64Operand& operand, int tokenPos) { operand.addressCoding = 112; }
x64Token x64Parser::tokenBranches1179[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1180,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1189(x64Operand& operand, int tokenPos) { operand.addressCoding = 113; }
x64Token x64Parser::tokenBranches1188[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1189,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1170(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1179(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1188(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1169[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1170, x64Parser::tokenBranches1170},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1179, x64Parser::tokenBranches1179},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1188, x64Parser::tokenBranches1188},
    {x64Token::EOT}};
void x64Parser::TokenFunc1162(x64Operand& operand, int tokenPos) { operand.addressCoding = 111; }
x64Token x64Parser::tokenBranches1161[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1162,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1169},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1530(x64Operand& operand, int tokenPos) { operand.addressCoding = 136; }
x64Token x64Parser::tokenBranches1529[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1530,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1539(x64Operand& operand, int tokenPos) { operand.addressCoding = 137; }
x64Token x64Parser::tokenBranches1538[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1539,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1529(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1538(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1528[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1529, x64Parser::tokenBranches1529},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1538, x64Parser::tokenBranches1538},
    {x64Token::EOT}};
void x64Parser::TokenFunc1521(x64Operand& operand, int tokenPos) { operand.addressCoding = 136; }
x64Token x64Parser::tokenBranches1520[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1521,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1528},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1033(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1161(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1520(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1032[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1033, x64Parser::tokenBranches1033},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1161, x64Parser::tokenBranches1161},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1520, x64Parser::tokenBranches1520},
    {x64Token::EOT}};
void x64Parser::TokenFunc496(x64Operand& operand, int tokenPos) { operand.addressCoding = 55; }
x64Token x64Parser::tokenBranches495[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc496,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches735},
                                          {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1032},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc637(x64Operand& operand, int tokenPos) { operand.addressCoding = 56; }
x64Token x64Parser::tokenBranches636[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc637,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc761(x64Operand& operand, int tokenPos) { operand.addressCoding = 77; }
x64Token x64Parser::tokenBranches760[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc761,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc885(x64Operand& operand, int tokenPos) { operand.addressCoding = 91; }
x64Token x64Parser::tokenBranches884[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc885,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2280(x64Operand& operand, int tokenPos) { operand.addressCoding = 187; }
x64Token x64Parser::tokenBranches2279[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2280,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2812(x64Operand& operand, int tokenPos) { operand.addressCoding = 212; }
x64Token x64Parser::tokenBranches2811[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2812,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3110(x64Operand& operand, int tokenPos) { operand.addressCoding = 238; }
x64Token x64Parser::tokenBranches3109[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3110,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2279(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2811(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3109(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2278[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2279, x64Parser::tokenBranches2279},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2811, x64Parser::tokenBranches2811},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3109, x64Parser::tokenBranches3109},
    {x64Token::EOT}};
void x64Parser::TokenFunc2528(x64Operand& operand, int tokenPos) { operand.addressCoding = 187; }
x64Token x64Parser::tokenBranches2277[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2278},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2528,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2277(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2276[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2277, x64Parser::tokenBranches2277},
    {x64Token::EOT}};
void x64Parser::TokenFunc2289(x64Operand& operand, int tokenPos) { operand.addressCoding = 188; }
x64Token x64Parser::tokenBranches2288[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2289,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2821(x64Operand& operand, int tokenPos) { operand.addressCoding = 213; }
x64Token x64Parser::tokenBranches2820[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2821,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3119(x64Operand& operand, int tokenPos) { operand.addressCoding = 239; }
x64Token x64Parser::tokenBranches3118[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3119,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2288(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2820(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3118(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2287[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2288, x64Parser::tokenBranches2288},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2820, x64Parser::tokenBranches2820},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3118, x64Parser::tokenBranches3118},
    {x64Token::EOT}};
void x64Parser::TokenFunc2535(x64Operand& operand, int tokenPos) { operand.addressCoding = 188; }
x64Token x64Parser::tokenBranches2275[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2276},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2287},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2535,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc636(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc760(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc884(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2275(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches635[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc636, x64Parser::tokenBranches636},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc760, x64Parser::tokenBranches760},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc884, x64Parser::tokenBranches884},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2275, x64Parser::tokenBranches2275},
    {x64Token::EOT}};
void x64Parser::TokenFunc1299(x64Operand& operand, int tokenPos) { operand.addressCoding = 120; }
x64Token x64Parser::tokenBranches1298[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1299,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1308(x64Operand& operand, int tokenPos) { operand.addressCoding = 121; }
x64Token x64Parser::tokenBranches1307[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1308,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1317(x64Operand& operand, int tokenPos) { operand.addressCoding = 122; }
x64Token x64Parser::tokenBranches1316[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1317,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1298(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1307(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1316(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1297[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1298, x64Parser::tokenBranches1298},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1307, x64Parser::tokenBranches1307},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1316, x64Parser::tokenBranches1316},
    {x64Token::EOT}};
void x64Parser::TokenFunc1290(x64Operand& operand, int tokenPos) { operand.addressCoding = 120; }
x64Token x64Parser::tokenBranches1289[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1290,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1297},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1427(x64Operand& operand, int tokenPos) { operand.addressCoding = 129; }
x64Token x64Parser::tokenBranches1426[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1427,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1436(x64Operand& operand, int tokenPos) { operand.addressCoding = 130; }
x64Token x64Parser::tokenBranches1435[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1436,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1445(x64Operand& operand, int tokenPos) { operand.addressCoding = 131; }
x64Token x64Parser::tokenBranches1444[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1445,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1426(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1435(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1444(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1425[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1426, x64Parser::tokenBranches1426},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1435, x64Parser::tokenBranches1435},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1444, x64Parser::tokenBranches1444},
    {x64Token::EOT}};
void x64Parser::TokenFunc1418(x64Operand& operand, int tokenPos) { operand.addressCoding = 129; }
x64Token x64Parser::tokenBranches1417[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1418,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1425},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1574(x64Operand& operand, int tokenPos) { operand.addressCoding = 139; }
x64Token x64Parser::tokenBranches1573[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1574,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1583(x64Operand& operand, int tokenPos) { operand.addressCoding = 140; }
x64Token x64Parser::tokenBranches1582[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1583,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1573(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1582(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1572[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1573, x64Parser::tokenBranches1573},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1582, x64Parser::tokenBranches1582},
    {x64Token::EOT}};
void x64Parser::TokenFunc1565(x64Operand& operand, int tokenPos) { operand.addressCoding = 139; }
x64Token x64Parser::tokenBranches1564[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1565,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1572},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1289(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1417(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1564(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1288[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1289, x64Parser::tokenBranches1289},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1417, x64Parser::tokenBranches1417},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1564, x64Parser::tokenBranches1564},
    {x64Token::EOT}};
void x64Parser::TokenFunc501(x64Operand& operand, int tokenPos) { operand.addressCoding = 56; }
x64Token x64Parser::tokenBranches500[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc501,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches635},
                                          {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1288},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc685(x64Operand& operand, int tokenPos) { operand.addressCoding = 62; }
x64Token x64Parser::tokenBranches684[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc685,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc809(x64Operand& operand, int tokenPos) { operand.addressCoding = 81; }
x64Token x64Parser::tokenBranches808[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc809,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc926(x64Operand& operand, int tokenPos) { operand.addressCoding = 94; }
x64Token x64Parser::tokenBranches925[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc926,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc684(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc808(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc925(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches683[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc684, x64Parser::tokenBranches684},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc808, x64Parser::tokenBranches808},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc925, x64Parser::tokenBranches925},
    {x64Token::EOT}};
void x64Parser::TokenFunc557(x64Operand& operand, int tokenPos) { operand.addressCoding = 62; }
x64Token x64Parser::tokenBranches556[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc557,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches683},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc676(x64Operand& operand, int tokenPos) { operand.addressCoding = 61; }
x64Token x64Parser::tokenBranches675[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc676,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc800(x64Operand& operand, int tokenPos) { operand.addressCoding = 80; }
x64Token x64Parser::tokenBranches799[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc800,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc933(x64Operand& operand, int tokenPos) { operand.addressCoding = 95; }
x64Token x64Parser::tokenBranches932[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc933,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2340(x64Operand& operand, int tokenPos) { operand.addressCoding = 191; }
x64Token x64Parser::tokenBranches2339[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2340,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2872(x64Operand& operand, int tokenPos) { operand.addressCoding = 217; }
x64Token x64Parser::tokenBranches2871[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2872,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3170(x64Operand& operand, int tokenPos) { operand.addressCoding = 242; }
x64Token x64Parser::tokenBranches3169[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3170,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2339(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2871(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3169(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2338[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2339, x64Parser::tokenBranches2339},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2871, x64Parser::tokenBranches2871},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3169, x64Parser::tokenBranches3169},
    {x64Token::EOT}};
void x64Parser::TokenFunc2576(x64Operand& operand, int tokenPos) { operand.addressCoding = 191; }
x64Token x64Parser::tokenBranches2337[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2338},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2576,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2337(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2336[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2337, x64Parser::tokenBranches2337},
    {x64Token::EOT}};
void x64Parser::TokenFunc2349(x64Operand& operand, int tokenPos) { operand.addressCoding = 192; }
x64Token x64Parser::tokenBranches2348[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2349,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2881(x64Operand& operand, int tokenPos) { operand.addressCoding = 218; }
x64Token x64Parser::tokenBranches2880[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2881,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3179(x64Operand& operand, int tokenPos) { operand.addressCoding = 243; }
x64Token x64Parser::tokenBranches3178[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3179,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2348(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2880(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3178(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2347[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2348, x64Parser::tokenBranches2348},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2880, x64Parser::tokenBranches2880},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3178, x64Parser::tokenBranches3178},
    {x64Token::EOT}};
void x64Parser::TokenFunc2583(x64Operand& operand, int tokenPos) { operand.addressCoding = 192; }
x64Token x64Parser::tokenBranches2335[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2336},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2347},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2583,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc675(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc799(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc932(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2335(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches555[] = {
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches556},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc675, x64Parser::tokenBranches675},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc799, x64Parser::tokenBranches799},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc932, x64Parser::tokenBranches932},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2335, x64Parser::tokenBranches2335},
    {x64Token::EOT}};
void x64Parser::TokenFunc1693(x64Operand& operand, int tokenPos) { operand.addressCoding = 144; }
x64Token x64Parser::tokenBranches1692[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1693,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1702(x64Operand& operand, int tokenPos) { operand.addressCoding = 145; }
x64Token x64Parser::tokenBranches1701[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1702,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1711(x64Operand& operand, int tokenPos) { operand.addressCoding = 146; }
x64Token x64Parser::tokenBranches1710[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1711,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1692(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1701(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1710(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1691[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1692, x64Parser::tokenBranches1692},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1701, x64Parser::tokenBranches1701},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1710, x64Parser::tokenBranches1710},
    {x64Token::EOT}};
void x64Parser::TokenFunc1684(x64Operand& operand, int tokenPos) { operand.addressCoding = 144; }
x64Token x64Parser::tokenBranches1683[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1684,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1691},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1821(x64Operand& operand, int tokenPos) { operand.addressCoding = 153; }
x64Token x64Parser::tokenBranches1820[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1821,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1830(x64Operand& operand, int tokenPos) { operand.addressCoding = 154; }
x64Token x64Parser::tokenBranches1829[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1830,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1839(x64Operand& operand, int tokenPos) { operand.addressCoding = 155; }
x64Token x64Parser::tokenBranches1838[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1839,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1820(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1829(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1838(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1819[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1820, x64Parser::tokenBranches1820},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1829, x64Parser::tokenBranches1829},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1838, x64Parser::tokenBranches1838},
    {x64Token::EOT}};
void x64Parser::TokenFunc1812(x64Operand& operand, int tokenPos) { operand.addressCoding = 153; }
x64Token x64Parser::tokenBranches1811[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1812,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1819},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2011(x64Operand& operand, int tokenPos) { operand.addressCoding = 165; }
x64Token x64Parser::tokenBranches2010[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2011,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2020(x64Operand& operand, int tokenPos) { operand.addressCoding = 166; }
x64Token x64Parser::tokenBranches2019[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2020,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2040(x64Operand& operand, int tokenPos) { operand.addressCoding = 167; }
x64Token x64Parser::tokenBranches2039[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2040,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2051(x64Operand& operand, int tokenPos) { operand.addressCoding = 168; }
x64Token x64Parser::tokenBranches2050[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2051,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2039(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2050(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2038[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2039, x64Parser::tokenBranches2039},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2050, x64Parser::tokenBranches2050},
    {x64Token::EOT}};
void x64Parser::TokenFunc2029(x64Operand& operand, int tokenPos) { operand.addressCoding = 167; }
x64Token x64Parser::tokenBranches2028[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2029,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2038},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2010(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2019(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2009[] = {
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2028},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2010, x64Parser::tokenBranches2010},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2019, x64Parser::tokenBranches2019},
    {x64Token::EOT}};
void x64Parser::TokenFunc2002(x64Operand& operand, int tokenPos) { operand.addressCoding = 165; }
x64Token x64Parser::tokenBranches2001[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2002,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2009},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1683(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1811(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2001(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1682[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1683, x64Parser::tokenBranches1683},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1811, x64Parser::tokenBranches1811},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2001, x64Parser::tokenBranches2001},
    {x64Token::EOT}};
void x64Parser::TokenFunc550(x64Operand& operand, int tokenPos) { operand.addressCoding = 61; }
x64Token x64Parser::tokenBranches549[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc550,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches555},
                                          {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1682},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc575(x64Operand& operand, int tokenPos) { operand.addressCoding = 66; }
x64Token x64Parser::tokenBranches574[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData4,
                                              &x64Parser::TokenFunc575,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc3277(x64Operand& operand, int tokenPos) { operand.addressCoding = 248; }
x64Token x64Parser::tokenBranches3276[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3277,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3368(x64Operand& operand, int tokenPos) { operand.addressCoding = 264; }
x64Token x64Parser::tokenBranches3367[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3368,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3460(x64Operand& operand, int tokenPos) { operand.addressCoding = 278; }
x64Token x64Parser::tokenBranches3459[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3460,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4569(x64Operand& operand, int tokenPos) { operand.addressCoding = 379; }
x64Token x64Parser::tokenBranches4568[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4569,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4945(x64Operand& operand, int tokenPos) { operand.addressCoding = 403; }
x64Token x64Parser::tokenBranches4944[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4945,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5157(x64Operand& operand, int tokenPos) { operand.addressCoding = 427; }
x64Token x64Parser::tokenBranches5156[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5157,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4568(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4944(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5156(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4567[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4568, x64Parser::tokenBranches4568},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4944, x64Parser::tokenBranches4944},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5156, x64Parser::tokenBranches5156},
    {x64Token::EOT}};
void x64Parser::TokenFunc4755(x64Operand& operand, int tokenPos) { operand.addressCoding = 379; }
x64Token x64Parser::tokenBranches4566[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4567},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4755,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4566(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4565[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4566, x64Parser::tokenBranches4566},
    {x64Token::EOT}};
void x64Parser::TokenFunc4578(x64Operand& operand, int tokenPos) { operand.addressCoding = 380; }
x64Token x64Parser::tokenBranches4577[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4578,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4954(x64Operand& operand, int tokenPos) { operand.addressCoding = 404; }
x64Token x64Parser::tokenBranches4953[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4954,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5166(x64Operand& operand, int tokenPos) { operand.addressCoding = 428; }
x64Token x64Parser::tokenBranches5165[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5166,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4577(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4953(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5165(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4576[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4577, x64Parser::tokenBranches4577},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4953, x64Parser::tokenBranches4953},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5165, x64Parser::tokenBranches5165},
    {x64Token::EOT}};
void x64Parser::TokenFunc4762(x64Operand& operand, int tokenPos) { operand.addressCoding = 380; }
x64Token x64Parser::tokenBranches4564[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4565},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4576},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4762,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3276(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3367(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3459(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4564(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches3275[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3276, x64Parser::tokenBranches3276},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3367, x64Parser::tokenBranches3367},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3459, x64Parser::tokenBranches3459},
    {x64Token::REGISTERCLASS, 9, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4564, x64Parser::tokenBranches4564},
    {x64Token::EOT}};
void x64Parser::TokenFunc3196(x64Operand& operand, int tokenPos) { operand.addressCoding = 248; }
x64Token x64Parser::tokenBranches3195[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3196,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3275},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3337(x64Operand& operand, int tokenPos) { operand.addressCoding = 256; }
x64Token x64Parser::tokenBranches3336[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3337,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3429(x64Operand& operand, int tokenPos) { operand.addressCoding = 273; }
x64Token x64Parser::tokenBranches3428[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3429,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3521(x64Operand& operand, int tokenPos) { operand.addressCoding = 287; }
x64Token x64Parser::tokenBranches3520[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3521,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3336(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3428(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3520(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3335[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3336, x64Parser::tokenBranches3336},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3428, x64Parser::tokenBranches3428},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3520, x64Parser::tokenBranches3520},
    {x64Token::EOT}};
void x64Parser::TokenFunc3236(x64Operand& operand, int tokenPos) { operand.addressCoding = 256; }
x64Token x64Parser::tokenBranches3235[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3236,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3335},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3375(x64Operand& operand, int tokenPos) { operand.addressCoding = 265; }
x64Token x64Parser::tokenBranches3374[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3375,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3467(x64Operand& operand, int tokenPos) { operand.addressCoding = 279; }
x64Token x64Parser::tokenBranches3466[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3467,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4589(x64Operand& operand, int tokenPos) { operand.addressCoding = 381; }
x64Token x64Parser::tokenBranches4588[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4589,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4965(x64Operand& operand, int tokenPos) { operand.addressCoding = 405; }
x64Token x64Parser::tokenBranches4964[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4965,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5177(x64Operand& operand, int tokenPos) { operand.addressCoding = 429; }
x64Token x64Parser::tokenBranches5176[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5177,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4588(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4964(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5176(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4587[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4588, x64Parser::tokenBranches4588},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4964, x64Parser::tokenBranches4964},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5176, x64Parser::tokenBranches5176},
    {x64Token::EOT}};
void x64Parser::TokenFunc4771(x64Operand& operand, int tokenPos) { operand.addressCoding = 381; }
x64Token x64Parser::tokenBranches4586[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4587},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4771,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4586(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4585[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4586, x64Parser::tokenBranches4586},
    {x64Token::EOT}};
void x64Parser::TokenFunc4598(x64Operand& operand, int tokenPos) { operand.addressCoding = 382; }
x64Token x64Parser::tokenBranches4597[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4598,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4974(x64Operand& operand, int tokenPos) { operand.addressCoding = 406; }
x64Token x64Parser::tokenBranches4973[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4974,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5186(x64Operand& operand, int tokenPos) { operand.addressCoding = 430; }
x64Token x64Parser::tokenBranches5185[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5186,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4597(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4973(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5185(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4596[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4597, x64Parser::tokenBranches4597},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4973, x64Parser::tokenBranches4973},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5185, x64Parser::tokenBranches5185},
    {x64Token::EOT}};
void x64Parser::TokenFunc4778(x64Operand& operand, int tokenPos) { operand.addressCoding = 382; }
x64Token x64Parser::tokenBranches4584[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4585},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4596},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4778,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3374(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3466(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4584(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches3234[] = {
    {x64Token::REGISTER, 39, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3235},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3374, x64Parser::tokenBranches3374},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3466, x64Parser::tokenBranches3466},
    {x64Token::REGISTERCLASS, 9, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4584, x64Parser::tokenBranches4584},
    {x64Token::EOT}};
void x64Parser::TokenFunc3283(x64Operand& operand, int tokenPos) { operand.addressCoding = 249; }
x64Token x64Parser::tokenBranches3282[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3283,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3572(x64Operand& operand, int tokenPos) { operand.addressCoding = 289; }
x64Token x64Parser::tokenBranches3571[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3572,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3581(x64Operand& operand, int tokenPos) { operand.addressCoding = 290; }
x64Token x64Parser::tokenBranches3580[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3581,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3590(x64Operand& operand, int tokenPos) { operand.addressCoding = 291; }
x64Token x64Parser::tokenBranches3589[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3590,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3571(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3580(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3589(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3570[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3571, x64Parser::tokenBranches3571},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3580, x64Parser::tokenBranches3580},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3589, x64Parser::tokenBranches3589},
    {x64Token::EOT}};
void x64Parser::TokenFunc3563(x64Operand& operand, int tokenPos) { operand.addressCoding = 289; }
x64Token x64Parser::tokenBranches3562[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3563,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3570},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3632(x64Operand& operand, int tokenPos) { operand.addressCoding = 295; }
x64Token x64Parser::tokenBranches3631[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3632,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3641(x64Operand& operand, int tokenPos) { operand.addressCoding = 296; }
x64Token x64Parser::tokenBranches3640[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3641,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3650(x64Operand& operand, int tokenPos) { operand.addressCoding = 297; }
x64Token x64Parser::tokenBranches3649[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3650,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3631(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3640(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3649(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3630[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3631, x64Parser::tokenBranches3631},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3640, x64Parser::tokenBranches3640},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3649, x64Parser::tokenBranches3649},
    {x64Token::EOT}};
void x64Parser::TokenFunc3623(x64Operand& operand, int tokenPos) { operand.addressCoding = 295; }
x64Token x64Parser::tokenBranches3622[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3623,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3630},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3678(x64Operand& operand, int tokenPos) { operand.addressCoding = 301; }
x64Token x64Parser::tokenBranches3677[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3678,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3677(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3676[] = {
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3677, x64Parser::tokenBranches3677},
    {x64Token::EOT}};
void x64Parser::TokenFunc3669(x64Operand& operand, int tokenPos) { operand.addressCoding = 300; }
x64Token x64Parser::tokenBranches3668[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3669,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3676},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3706(x64Operand& operand, int tokenPos) { operand.addressCoding = 305; }
x64Token x64Parser::tokenBranches3705[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3706,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3705(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3704[] = {
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3705, x64Parser::tokenBranches3705},
    {x64Token::EOT}};
void x64Parser::TokenFunc3697(x64Operand& operand, int tokenPos) { operand.addressCoding = 304; }
x64Token x64Parser::tokenBranches3696[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3697,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3704},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3562(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3622(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3668(x64Operand& operand, int tokenPos)
{
    operand.values[12] = new Coding[2];
    CleanupValues.push_back(operand.values[12]);
    operand.values[12]->type = Coding::number;
    operand.values[12]->val = operands.size();
    operand.values[12]->bits = 0;
    operand.values[12]->field = 0;
    operand.values[12]->unary = 0;
    operand.values[12]->binary = 0;
    operand.values[12][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3696(x64Operand& operand, int tokenPos)
{
    operand.values[13] = new Coding[2];
    CleanupValues.push_back(operand.values[13]);
    operand.values[13]->type = Coding::number;
    operand.values[13]->val = operands.size();
    operand.values[13]->bits = 0;
    operand.values[13]->field = 0;
    operand.values[13]->unary = 0;
    operand.values[13]->binary = 0;
    operand.values[13][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3561[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3562, x64Parser::tokenBranches3562},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3622, x64Parser::tokenBranches3622},
    {x64Token::NUMBER, 20, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3668, x64Parser::tokenBranches3668},
    {x64Token::NUMBER, 21, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3696, x64Parser::tokenBranches3696},
    {x64Token::EOT}};
void x64Parser::TokenFunc3201(x64Operand& operand, int tokenPos) { operand.addressCoding = 249; }
void x64Parser::TokenFunc3282(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3200[] = {
    {
        x64Token::TOKEN,
        2,
        1,
        0,
        x64Parser::RegClassData3,
        &x64Parser::TokenFunc3201,
    },
    {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3234},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3282, x64Parser::tokenBranches3282},
    {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3561},
    {x64Token::EOT}};
void x64Parser::TokenFunc3290(x64Operand& operand, int tokenPos) { operand.addressCoding = 250; }
x64Token x64Parser::tokenBranches3289[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3290,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3382(x64Operand& operand, int tokenPos) { operand.addressCoding = 266; }
x64Token x64Parser::tokenBranches3381[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3382,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3474(x64Operand& operand, int tokenPos) { operand.addressCoding = 280; }
x64Token x64Parser::tokenBranches3473[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3474,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4481(x64Operand& operand, int tokenPos) { operand.addressCoding = 369; }
x64Token x64Parser::tokenBranches4480[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4481,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4857(x64Operand& operand, int tokenPos) { operand.addressCoding = 393; }
x64Token x64Parser::tokenBranches4856[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4857,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5069(x64Operand& operand, int tokenPos) { operand.addressCoding = 417; }
x64Token x64Parser::tokenBranches5068[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5069,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4480(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4856(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5068(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4479[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4480, x64Parser::tokenBranches4480},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4856, x64Parser::tokenBranches4856},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5068, x64Parser::tokenBranches5068},
    {x64Token::EOT}};
void x64Parser::TokenFunc4687(x64Operand& operand, int tokenPos) { operand.addressCoding = 369; }
x64Token x64Parser::tokenBranches4478[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4479},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4687,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4549(x64Operand& operand, int tokenPos) { operand.addressCoding = 377; }
x64Token x64Parser::tokenBranches4548[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4549,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4925(x64Operand& operand, int tokenPos) { operand.addressCoding = 401; }
x64Token x64Parser::tokenBranches4924[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4925,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5137(x64Operand& operand, int tokenPos) { operand.addressCoding = 425; }
x64Token x64Parser::tokenBranches5136[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5137,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4548(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4924(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5136(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4547[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4548, x64Parser::tokenBranches4548},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4924, x64Parser::tokenBranches4924},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5136, x64Parser::tokenBranches5136},
    {x64Token::EOT}};
void x64Parser::TokenFunc4739(x64Operand& operand, int tokenPos) { operand.addressCoding = 377; }
x64Token x64Parser::tokenBranches4546[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4547},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4739,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4546(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4545[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4546, x64Parser::tokenBranches4546},
    {x64Token::EOT}};
void x64Parser::TokenFunc4558(x64Operand& operand, int tokenPos) { operand.addressCoding = 378; }
x64Token x64Parser::tokenBranches4557[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4558,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4934(x64Operand& operand, int tokenPos) { operand.addressCoding = 402; }
x64Token x64Parser::tokenBranches4933[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4934,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5146(x64Operand& operand, int tokenPos) { operand.addressCoding = 426; }
x64Token x64Parser::tokenBranches5145[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5146,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4557(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4933(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5145(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4556[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4557, x64Parser::tokenBranches4557},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4933, x64Parser::tokenBranches4933},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5145, x64Parser::tokenBranches5145},
    {x64Token::EOT}};
void x64Parser::TokenFunc4746(x64Operand& operand, int tokenPos) { operand.addressCoding = 378; }
x64Token x64Parser::tokenBranches4544[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4545},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4556},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4746,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3289(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3381(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3473(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4544(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches3288[] = {
    {x64Token::REGISTER, 39, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4478},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3289, x64Parser::tokenBranches3289},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3381, x64Parser::tokenBranches3381},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3473, x64Parser::tokenBranches3473},
    {x64Token::REGISTERCLASS, 9, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4544, x64Parser::tokenBranches4544},
    {x64Token::EOT}};
void x64Parser::TokenFunc3816(x64Operand& operand, int tokenPos) { operand.addressCoding = 312; }
x64Token x64Parser::tokenBranches3815[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3816,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3825(x64Operand& operand, int tokenPos) { operand.addressCoding = 313; }
x64Token x64Parser::tokenBranches3824[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3825,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3834(x64Operand& operand, int tokenPos) { operand.addressCoding = 314; }
x64Token x64Parser::tokenBranches3833[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3834,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3815(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3824(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3833(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3814[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3815, x64Parser::tokenBranches3815},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3824, x64Parser::tokenBranches3824},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3833, x64Parser::tokenBranches3833},
    {x64Token::EOT}};
void x64Parser::TokenFunc3807(x64Operand& operand, int tokenPos) { operand.addressCoding = 312; }
x64Token x64Parser::tokenBranches3806[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3807,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3814},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3944(x64Operand& operand, int tokenPos) { operand.addressCoding = 321; }
x64Token x64Parser::tokenBranches3943[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3944,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3953(x64Operand& operand, int tokenPos) { operand.addressCoding = 322; }
x64Token x64Parser::tokenBranches3952[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3953,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3962(x64Operand& operand, int tokenPos) { operand.addressCoding = 323; }
x64Token x64Parser::tokenBranches3961[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3962,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3943(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3952(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3961(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3942[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3943, x64Parser::tokenBranches3943},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3952, x64Parser::tokenBranches3952},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3961, x64Parser::tokenBranches3961},
    {x64Token::EOT}};
void x64Parser::TokenFunc3935(x64Operand& operand, int tokenPos) { operand.addressCoding = 321; }
x64Token x64Parser::tokenBranches3934[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3935,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3942},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4246(x64Operand& operand, int tokenPos) { operand.addressCoding = 345; }
x64Token x64Parser::tokenBranches4245[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4246,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4245(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4244[] = {
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4245, x64Parser::tokenBranches4245},
    {x64Token::EOT}};
void x64Parser::TokenFunc4237(x64Operand& operand, int tokenPos) { operand.addressCoding = 344; }
x64Token x64Parser::tokenBranches4236[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4237,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4244},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3806(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3934(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4236(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3805[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3806, x64Parser::tokenBranches3806},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3934, x64Parser::tokenBranches3934},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4236, x64Parser::tokenBranches4236},
    {x64Token::EOT}};
void x64Parser::TokenFunc3206(x64Operand& operand, int tokenPos) { operand.addressCoding = 250; }
x64Token x64Parser::tokenBranches3205[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3206,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3288},
                                           {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3805},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3321(x64Operand& operand, int tokenPos) { operand.addressCoding = 251; }
x64Token x64Parser::tokenBranches3320[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3321,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3413(x64Operand& operand, int tokenPos) { operand.addressCoding = 271; }
x64Token x64Parser::tokenBranches3412[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3413,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3505(x64Operand& operand, int tokenPos) { operand.addressCoding = 285; }
x64Token x64Parser::tokenBranches3504[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3505,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4490(x64Operand& operand, int tokenPos) { operand.addressCoding = 370; }
x64Token x64Parser::tokenBranches4489[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4490,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4866(x64Operand& operand, int tokenPos) { operand.addressCoding = 394; }
x64Token x64Parser::tokenBranches4865[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4866,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5078(x64Operand& operand, int tokenPos) { operand.addressCoding = 418; }
x64Token x64Parser::tokenBranches5077[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5078,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4489(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4865(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5077(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4488[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4489, x64Parser::tokenBranches4489},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4865, x64Parser::tokenBranches4865},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5077, x64Parser::tokenBranches5077},
    {x64Token::EOT}};
void x64Parser::TokenFunc4694(x64Operand& operand, int tokenPos) { operand.addressCoding = 370; }
x64Token x64Parser::tokenBranches4487[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4488},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4694,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4641(x64Operand& operand, int tokenPos) { operand.addressCoding = 387; }
x64Token x64Parser::tokenBranches4640[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4641,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5017(x64Operand& operand, int tokenPos) { operand.addressCoding = 411; }
x64Token x64Parser::tokenBranches5016[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5017,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5229(x64Operand& operand, int tokenPos) { operand.addressCoding = 435; }
x64Token x64Parser::tokenBranches5228[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5229,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4640(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5016(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5228(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4639[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4640, x64Parser::tokenBranches4640},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5016, x64Parser::tokenBranches5016},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5228, x64Parser::tokenBranches5228},
    {x64Token::EOT}};
void x64Parser::TokenFunc4811(x64Operand& operand, int tokenPos) { operand.addressCoding = 387; }
x64Token x64Parser::tokenBranches4638[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4639},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4811,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4638(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4637[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4638, x64Parser::tokenBranches4638},
    {x64Token::EOT}};
void x64Parser::TokenFunc4650(x64Operand& operand, int tokenPos) { operand.addressCoding = 388; }
x64Token x64Parser::tokenBranches4649[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4650,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5026(x64Operand& operand, int tokenPos) { operand.addressCoding = 412; }
x64Token x64Parser::tokenBranches5025[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5026,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5238(x64Operand& operand, int tokenPos) { operand.addressCoding = 436; }
x64Token x64Parser::tokenBranches5237[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5238,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4649(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5025(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5237(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4648[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4649, x64Parser::tokenBranches4649},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5025, x64Parser::tokenBranches5025},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5237, x64Parser::tokenBranches5237},
    {x64Token::EOT}};
void x64Parser::TokenFunc4818(x64Operand& operand, int tokenPos) { operand.addressCoding = 388; }
x64Token x64Parser::tokenBranches4636[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4637},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4648},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4818,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3320(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3412(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3504(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4636(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches3319[] = {
    {x64Token::REGISTER, 39, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4487},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3320, x64Parser::tokenBranches3320},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3412, x64Parser::tokenBranches3412},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3504, x64Parser::tokenBranches3504},
    {x64Token::REGISTERCLASS, 9, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4636, x64Parser::tokenBranches4636},
    {x64Token::EOT}};
void x64Parser::TokenFunc4072(x64Operand& operand, int tokenPos) { operand.addressCoding = 330; }
x64Token x64Parser::tokenBranches4071[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4072,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4081(x64Operand& operand, int tokenPos) { operand.addressCoding = 331; }
x64Token x64Parser::tokenBranches4080[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4081,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4090(x64Operand& operand, int tokenPos) { operand.addressCoding = 332; }
x64Token x64Parser::tokenBranches4089[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4090,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4071(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4080(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4089(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4070[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4071, x64Parser::tokenBranches4071},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4080, x64Parser::tokenBranches4080},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4089, x64Parser::tokenBranches4089},
    {x64Token::EOT}};
void x64Parser::TokenFunc4063(x64Operand& operand, int tokenPos) { operand.addressCoding = 330; }
x64Token x64Parser::tokenBranches4062[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4063,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4070},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4200(x64Operand& operand, int tokenPos) { operand.addressCoding = 339; }
x64Token x64Parser::tokenBranches4199[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4200,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4209(x64Operand& operand, int tokenPos) { operand.addressCoding = 340; }
x64Token x64Parser::tokenBranches4208[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4209,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4218(x64Operand& operand, int tokenPos) { operand.addressCoding = 341; }
x64Token x64Parser::tokenBranches4217[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4218,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4199(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4208(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4217(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4198[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4199, x64Parser::tokenBranches4199},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4208, x64Parser::tokenBranches4208},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4217, x64Parser::tokenBranches4217},
    {x64Token::EOT}};
void x64Parser::TokenFunc4191(x64Operand& operand, int tokenPos) { operand.addressCoding = 339; }
x64Token x64Parser::tokenBranches4190[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4191,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4198},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4274(x64Operand& operand, int tokenPos) { operand.addressCoding = 349; }
x64Token x64Parser::tokenBranches4273[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4274,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4273(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4272[] = {
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4273, x64Parser::tokenBranches4273},
    {x64Token::EOT}};
void x64Parser::TokenFunc4265(x64Operand& operand, int tokenPos) { operand.addressCoding = 348; }
x64Token x64Parser::tokenBranches4264[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4265,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4272},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4062(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4190(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4264(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4061[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4062, x64Parser::tokenBranches4062},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4190, x64Parser::tokenBranches4190},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4264, x64Parser::tokenBranches4264},
    {x64Token::EOT}};
void x64Parser::TokenFunc3211(x64Operand& operand, int tokenPos) { operand.addressCoding = 251; }
x64Token x64Parser::tokenBranches3210[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3211,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3319},
                                           {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4061},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3346(x64Operand& operand, int tokenPos) { operand.addressCoding = 257; }
x64Token x64Parser::tokenBranches3345[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3346,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3438(x64Operand& operand, int tokenPos) { operand.addressCoding = 274; }
x64Token x64Parser::tokenBranches3437[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3438,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3530(x64Operand& operand, int tokenPos) { operand.addressCoding = 288; }
x64Token x64Parser::tokenBranches3529[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3530,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3345(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3437(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3529(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3344[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3345, x64Parser::tokenBranches3345},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3437, x64Parser::tokenBranches3437},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3529, x64Parser::tokenBranches3529},
    {x64Token::EOT}};
void x64Parser::TokenFunc3243(x64Operand& operand, int tokenPos) { operand.addressCoding = 257; }
x64Token x64Parser::tokenBranches3242[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3243,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3344},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3328(x64Operand& operand, int tokenPos) { operand.addressCoding = 255; }
x64Token x64Parser::tokenBranches3327[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3328,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3420(x64Operand& operand, int tokenPos) { operand.addressCoding = 272; }
x64Token x64Parser::tokenBranches3419[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3420,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3512(x64Operand& operand, int tokenPos) { operand.addressCoding = 286; }
x64Token x64Parser::tokenBranches3511[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3512,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4661(x64Operand& operand, int tokenPos) { operand.addressCoding = 389; }
x64Token x64Parser::tokenBranches4660[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4661,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5037(x64Operand& operand, int tokenPos) { operand.addressCoding = 413; }
x64Token x64Parser::tokenBranches5036[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5037,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5249(x64Operand& operand, int tokenPos) { operand.addressCoding = 437; }
x64Token x64Parser::tokenBranches5248[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5249,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4660(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5036(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5248(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4659[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4660, x64Parser::tokenBranches4660},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5036, x64Parser::tokenBranches5036},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5248, x64Parser::tokenBranches5248},
    {x64Token::EOT}};
void x64Parser::TokenFunc4827(x64Operand& operand, int tokenPos) { operand.addressCoding = 389; }
x64Token x64Parser::tokenBranches4658[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4659},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4827,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4658(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4657[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4658, x64Parser::tokenBranches4658},
    {x64Token::EOT}};
void x64Parser::TokenFunc4670(x64Operand& operand, int tokenPos) { operand.addressCoding = 390; }
x64Token x64Parser::tokenBranches4669[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4670,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5046(x64Operand& operand, int tokenPos) { operand.addressCoding = 414; }
x64Token x64Parser::tokenBranches5045[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5046,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5258(x64Operand& operand, int tokenPos) { operand.addressCoding = 438; }
x64Token x64Parser::tokenBranches5257[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5258,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4669(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5045(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5257(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4668[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4669, x64Parser::tokenBranches4669},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5045, x64Parser::tokenBranches5045},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5257, x64Parser::tokenBranches5257},
    {x64Token::EOT}};
void x64Parser::TokenFunc4834(x64Operand& operand, int tokenPos) { operand.addressCoding = 390; }
x64Token x64Parser::tokenBranches4656[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4657},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4668},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4834,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3327(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3419(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3511(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4656(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches3241[] = {
    {x64Token::REGISTER, 39, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3242},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3327, x64Parser::tokenBranches3327},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3419, x64Parser::tokenBranches3419},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3511, x64Parser::tokenBranches3511},
    {x64Token::REGISTERCLASS, 9, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4656, x64Parser::tokenBranches4656},
    {x64Token::EOT}};
void x64Parser::TokenFunc4316(x64Operand& operand, int tokenPos) { operand.addressCoding = 350; }
x64Token x64Parser::tokenBranches4315[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4316,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4325(x64Operand& operand, int tokenPos) { operand.addressCoding = 351; }
x64Token x64Parser::tokenBranches4324[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4325,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4334(x64Operand& operand, int tokenPos) { operand.addressCoding = 352; }
x64Token x64Parser::tokenBranches4333[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4334,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4315(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4324(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4333(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4314[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4315, x64Parser::tokenBranches4315},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4324, x64Parser::tokenBranches4324},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4333, x64Parser::tokenBranches4333},
    {x64Token::EOT}};
void x64Parser::TokenFunc4307(x64Operand& operand, int tokenPos) { operand.addressCoding = 350; }
x64Token x64Parser::tokenBranches4306[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4307,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4314},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4376(x64Operand& operand, int tokenPos) { operand.addressCoding = 356; }
x64Token x64Parser::tokenBranches4375[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4376,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4385(x64Operand& operand, int tokenPos) { operand.addressCoding = 357; }
x64Token x64Parser::tokenBranches4384[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4385,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4394(x64Operand& operand, int tokenPos) { operand.addressCoding = 358; }
x64Token x64Parser::tokenBranches4393[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4394,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4375(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4384(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4393(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4374[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4375, x64Parser::tokenBranches4375},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4384, x64Parser::tokenBranches4384},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4393, x64Parser::tokenBranches4393},
    {x64Token::EOT}};
void x64Parser::TokenFunc4367(x64Operand& operand, int tokenPos) { operand.addressCoding = 356; }
x64Token x64Parser::tokenBranches4366[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4367,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4374},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4438(x64Operand& operand, int tokenPos) { operand.addressCoding = 364; }
x64Token x64Parser::tokenBranches4437[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4438,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4458(x64Operand& operand, int tokenPos) { operand.addressCoding = 366; }
x64Token x64Parser::tokenBranches4457[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4458,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4457(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4456[] = {
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4457, x64Parser::tokenBranches4457},
    {x64Token::EOT}};
void x64Parser::TokenFunc4447(x64Operand& operand, int tokenPos) { operand.addressCoding = 365; }
x64Token x64Parser::tokenBranches4446[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4447,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4456},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4437(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4436[] = {
    {x64Token::REGISTER, 39, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4446},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4437, x64Parser::tokenBranches4437},
    {x64Token::EOT}};
void x64Parser::TokenFunc4429(x64Operand& operand, int tokenPos) { operand.addressCoding = 363; }
x64Token x64Parser::tokenBranches4428[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4429,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4436},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4306(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4366(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4428(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4305[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4306, x64Parser::tokenBranches4306},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4366, x64Parser::tokenBranches4366},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4428, x64Parser::tokenBranches4428},
    {x64Token::EOT}};
void x64Parser::TokenFunc3229(x64Operand& operand, int tokenPos) { operand.addressCoding = 255; }
x64Token x64Parser::tokenBranches3228[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3229,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3241},
                                           {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4305},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3256(x64Operand& operand, int tokenPos) { operand.addressCoding = 260; }
x64Token x64Parser::tokenBranches3255[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData5,
                                               &x64Parser::TokenFunc3256,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc18(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc88(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
void x64Parser::TokenFunc549(x64Operand& operand, int tokenPos)
{
    operand.values[5] = new Coding[2];
    CleanupValues.push_back(operand.values[5]);
    operand.values[5]->type = Coding::reg;
    operand.values[5]->val = inputTokens[tokenPos]->val->ival;
    operand.values[5]->bits = 0;
    operand.values[5]->field = 0;
    operand.values[5]->unary = 0;
    operand.values[5]->binary = 0;
    operand.values[5][1].type = Coding::eot;
}
void x64Parser::TokenFunc574(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3228(x64Operand& operand, int tokenPos)
{
    operand.values[5] = new Coding[2];
    CleanupValues.push_back(operand.values[5]);
    operand.values[5]->type = Coding::reg;
    operand.values[5]->val = inputTokens[tokenPos]->val->ival;
    operand.values[5]->bits = 0;
    operand.values[5]->field = 0;
    operand.values[5]->unary = 0;
    operand.values[5]->binary = 0;
    operand.values[5][1].type = Coding::eot;
}
void x64Parser::TokenFunc3255(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches17[] = {
    {x64Token::REGISTER, 29, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches61},
    {x64Token::REGISTER, 45, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches68},
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches490},
    {x64Token::REGISTER, 46, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches495},
    {x64Token::REGISTER, 50, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches500},
    {x64Token::REGISTER, 39, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3195},
    {x64Token::REGISTER, 43, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3200},
    {x64Token::REGISTER, 47, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3205},
    {x64Token::REGISTER, 51, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3210},
    {x64Token::NUMBER, 6, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc18, x64Parser::tokenBranches18},
    {x64Token::REGISTERCLASS, 15, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc88, x64Parser::tokenBranches88},
    {x64Token::REGISTERCLASS, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc549, x64Parser::tokenBranches549},
    {x64Token::NUMBER, 7, 0, 0, x64Parser::RegClassData4, &x64Parser::TokenFunc574, x64Parser::tokenBranches574},
    {x64Token::REGISTERCLASS, 8, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3228, x64Parser::tokenBranches3228},
    {x64Token::NUMBER, 8, 0, 0, x64Parser::RegClassData5, &x64Parser::TokenFunc3255, x64Parser::tokenBranches3255},
    {x64Token::EOT}};
x64Token x64Parser::tokenBranches16[] = {{x64Token::TOKEN, 3, 0, 0, x64Parser::RegClassData1, NULL, x64Parser::tokenBranches17},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc184(x64Operand& operand, int tokenPos) { operand.addressCoding = 19; }
x64Token x64Parser::tokenBranches183[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc184,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc330(x64Operand& operand, int tokenPos) { operand.addressCoding = 34; }
x64Token x64Parser::tokenBranches329[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc330,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc183(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc329(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches182[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc183, x64Parser::tokenBranches183},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc329, x64Parser::tokenBranches329},
    {x64Token::EOT}};
void x64Parser::TokenFunc24(x64Operand& operand, int tokenPos) { operand.addressCoding = 4; }
x64Token x64Parser::tokenBranches23[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc24,
                                         },
                                         {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches182},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc130(x64Operand& operand, int tokenPos) { operand.addressCoding = 13; }
x64Token x64Parser::tokenBranches129[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc130,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc276(x64Operand& operand, int tokenPos) { operand.addressCoding = 28; }
x64Token x64Parser::tokenBranches275[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc276,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc422(x64Operand& operand, int tokenPos) { operand.addressCoding = 43; }
x64Token x64Parser::tokenBranches421[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc422,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc23(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
void x64Parser::TokenFunc129(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc275(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc421(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches22[] = {
    {x64Token::REGISTERCLASS, 15, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc23, x64Parser::tokenBranches23},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc129, x64Parser::tokenBranches129},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc275, x64Parser::tokenBranches275},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc421, x64Parser::tokenBranches421},
    {x64Token::EOT}};
void x64Parser::TokenFunc92(x64Operand& operand, int tokenPos) { operand.addressCoding = 13; }
x64Token x64Parser::tokenBranches21[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches22},
                                         {
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc92,
                                         },
                                         {x64Token::EOT}};
void x64Parser::TokenFunc191(x64Operand& operand, int tokenPos) { operand.addressCoding = 20; }
x64Token x64Parser::tokenBranches190[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc191,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc337(x64Operand& operand, int tokenPos) { operand.addressCoding = 35; }
x64Token x64Parser::tokenBranches336[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc337,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc190(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc336(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches189[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc190, x64Parser::tokenBranches190},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc336, x64Parser::tokenBranches336},
    {x64Token::EOT}};
void x64Parser::TokenFunc29(x64Operand& operand, int tokenPos) { operand.addressCoding = 5; }
x64Token x64Parser::tokenBranches28[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc29,
                                         },
                                         {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches189},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc156(x64Operand& operand, int tokenPos) { operand.addressCoding = 16; }
x64Token x64Parser::tokenBranches155[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc156,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc302(x64Operand& operand, int tokenPos) { operand.addressCoding = 31; }
x64Token x64Parser::tokenBranches301[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc302,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc448(x64Operand& operand, int tokenPos) { operand.addressCoding = 46; }
x64Token x64Parser::tokenBranches447[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc448,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc28(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
void x64Parser::TokenFunc155(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc301(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc447(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches27[] = {
    {x64Token::REGISTERCLASS, 15, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc28, x64Parser::tokenBranches28},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc155, x64Parser::tokenBranches155},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc301, x64Parser::tokenBranches301},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc447, x64Parser::tokenBranches447},
    {x64Token::EOT}};
void x64Parser::TokenFunc110(x64Operand& operand, int tokenPos) { operand.addressCoding = 16; }
x64Token x64Parser::tokenBranches26[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches27},
                                         {
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc110,
                                         },
                                         {x64Token::EOT}};
void x64Parser::TokenFunc250(x64Operand& operand, int tokenPos) { operand.addressCoding = 25; }
x64Token x64Parser::tokenBranches249[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc250,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc396(x64Operand& operand, int tokenPos) { operand.addressCoding = 40; }
x64Token x64Parser::tokenBranches395[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData2,
                                              &x64Parser::TokenFunc396,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc249(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc395(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches248[] = {
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc249, x64Parser::tokenBranches249},
    {x64Token::NUMBER, 4, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc395, x64Parser::tokenBranches395},
    {x64Token::EOT}};
void x64Parser::TokenFunc74(x64Operand& operand, int tokenPos) { operand.addressCoding = 10; }
x64Token x64Parser::tokenBranches73[] = {{
                                             x64Token::TOKEN,
                                             2,
                                             1,
                                             0,
                                             x64Parser::RegClassData2,
                                             &x64Parser::TokenFunc74,
                                         },
                                         {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches248},
                                         {x64Token::EOT}};
void x64Parser::TokenFunc580(x64Operand& operand, int tokenPos) { operand.addressCoding = 49; }
x64Token x64Parser::tokenBranches579[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc580,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc690(x64Operand& operand, int tokenPos) { operand.addressCoding = 68; }
x64Token x64Parser::tokenBranches689[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc690,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc814(x64Operand& operand, int tokenPos) { operand.addressCoding = 82; }
x64Token x64Parser::tokenBranches813[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc814,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2083(x64Operand& operand, int tokenPos) { operand.addressCoding = 172; }
x64Token x64Parser::tokenBranches2082[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2083,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2615(x64Operand& operand, int tokenPos) { operand.addressCoding = 196; }
x64Token x64Parser::tokenBranches2614[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2615,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2913(x64Operand& operand, int tokenPos) { operand.addressCoding = 222; }
x64Token x64Parser::tokenBranches2912[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2913,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2082(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2614(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2912(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2081[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2082, x64Parser::tokenBranches2082},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2614, x64Parser::tokenBranches2614},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2912, x64Parser::tokenBranches2912},
    {x64Token::EOT}};
void x64Parser::TokenFunc2373(x64Operand& operand, int tokenPos) { operand.addressCoding = 172; }
x64Token x64Parser::tokenBranches2080[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2081},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2373,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2080(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2079[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2080, x64Parser::tokenBranches2080},
    {x64Token::EOT}};
void x64Parser::TokenFunc2090(x64Operand& operand, int tokenPos) { operand.addressCoding = 173; }
x64Token x64Parser::tokenBranches2089[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2090,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2622(x64Operand& operand, int tokenPos) { operand.addressCoding = 197; }
x64Token x64Parser::tokenBranches2621[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2622,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2920(x64Operand& operand, int tokenPos) { operand.addressCoding = 223; }
x64Token x64Parser::tokenBranches2919[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2920,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2089(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2621(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2919(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2088[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2089, x64Parser::tokenBranches2089},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2621, x64Parser::tokenBranches2621},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2919, x64Parser::tokenBranches2919},
    {x64Token::EOT}};
void x64Parser::TokenFunc2378(x64Operand& operand, int tokenPos) { operand.addressCoding = 173; }
x64Token x64Parser::tokenBranches2078[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2079},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2088},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2378,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc579(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc689(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc813(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2078(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches578[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc579, x64Parser::tokenBranches579},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc689, x64Parser::tokenBranches689},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc813, x64Parser::tokenBranches813},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2078, x64Parser::tokenBranches2078},
    {x64Token::EOT}};
void x64Parser::TokenFunc472(x64Operand& operand, int tokenPos) { operand.addressCoding = 49; }
x64Token x64Parser::tokenBranches471[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc472,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches578},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc585(x64Operand& operand, int tokenPos) { operand.addressCoding = 50; }
x64Token x64Parser::tokenBranches584[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc585,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc695(x64Operand& operand, int tokenPos) { operand.addressCoding = 69; }
x64Token x64Parser::tokenBranches694[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc695,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc819(x64Operand& operand, int tokenPos) { operand.addressCoding = 83; }
x64Token x64Parser::tokenBranches818[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc819,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2058(x64Operand& operand, int tokenPos) { operand.addressCoding = 169; }
x64Token x64Parser::tokenBranches2057[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2058,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2590(x64Operand& operand, int tokenPos) { operand.addressCoding = 193; }
x64Token x64Parser::tokenBranches2589[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2590,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2888(x64Operand& operand, int tokenPos) { operand.addressCoding = 219; }
x64Token x64Parser::tokenBranches2887[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2888,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2057(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2589(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2887(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2056[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2057, x64Parser::tokenBranches2057},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2589, x64Parser::tokenBranches2589},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2887, x64Parser::tokenBranches2887},
    {x64Token::EOT}};
void x64Parser::TokenFunc2354(x64Operand& operand, int tokenPos) { operand.addressCoding = 169; }
x64Token x64Parser::tokenBranches2055[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2056},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2354,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2067(x64Operand& operand, int tokenPos) { operand.addressCoding = 170; }
x64Token x64Parser::tokenBranches2066[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2067,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2599(x64Operand& operand, int tokenPos) { operand.addressCoding = 194; }
x64Token x64Parser::tokenBranches2598[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2599,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2897(x64Operand& operand, int tokenPos) { operand.addressCoding = 220; }
x64Token x64Parser::tokenBranches2896[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2897,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2066(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2598(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2896(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2065[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2066, x64Parser::tokenBranches2066},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2598, x64Parser::tokenBranches2598},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2896, x64Parser::tokenBranches2896},
    {x64Token::EOT}};
void x64Parser::TokenFunc2361(x64Operand& operand, int tokenPos) { operand.addressCoding = 170; }
x64Token x64Parser::tokenBranches2064[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2065},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2361,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2064(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2063[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2064, x64Parser::tokenBranches2064},
    {x64Token::EOT}};
void x64Parser::TokenFunc2074(x64Operand& operand, int tokenPos) { operand.addressCoding = 171; }
x64Token x64Parser::tokenBranches2073[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2074,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2606(x64Operand& operand, int tokenPos) { operand.addressCoding = 195; }
x64Token x64Parser::tokenBranches2605[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2606,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2904(x64Operand& operand, int tokenPos) { operand.addressCoding = 221; }
x64Token x64Parser::tokenBranches2903[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2904,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2073(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2605(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2903(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2072[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2073, x64Parser::tokenBranches2073},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2605, x64Parser::tokenBranches2605},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2903, x64Parser::tokenBranches2903},
    {x64Token::EOT}};
void x64Parser::TokenFunc2366(x64Operand& operand, int tokenPos) { operand.addressCoding = 171; }
x64Token x64Parser::tokenBranches2062[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2063},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2072},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2366,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc584(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc694(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc818(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2062(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches583[] = {
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2055},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc584, x64Parser::tokenBranches584},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc694, x64Parser::tokenBranches694},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc818, x64Parser::tokenBranches818},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2062, x64Parser::tokenBranches2062},
    {x64Token::EOT}};
void x64Parser::TokenFunc945(x64Operand& operand, int tokenPos) { operand.addressCoding = 96; }
x64Token x64Parser::tokenBranches944[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc945,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc952(x64Operand& operand, int tokenPos) { operand.addressCoding = 97; }
x64Token x64Parser::tokenBranches951[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc952,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc959(x64Operand& operand, int tokenPos) { operand.addressCoding = 98; }
x64Token x64Parser::tokenBranches958[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc959,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc944(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc951(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc958(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches943[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc944, x64Parser::tokenBranches944},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc951, x64Parser::tokenBranches951},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc958, x64Parser::tokenBranches958},
    {x64Token::EOT}};
void x64Parser::TokenFunc938(x64Operand& operand, int tokenPos) { operand.addressCoding = 96; }
x64Token x64Parser::tokenBranches937[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc938,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches943},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc1073(x64Operand& operand, int tokenPos) { operand.addressCoding = 105; }
x64Token x64Parser::tokenBranches1072[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1073,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1080(x64Operand& operand, int tokenPos) { operand.addressCoding = 106; }
x64Token x64Parser::tokenBranches1079[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1080,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1087(x64Operand& operand, int tokenPos) { operand.addressCoding = 107; }
x64Token x64Parser::tokenBranches1086[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1087,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1072(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1079(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1086(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1071[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1072, x64Parser::tokenBranches1072},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1079, x64Parser::tokenBranches1079},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1086, x64Parser::tokenBranches1086},
    {x64Token::EOT}};
void x64Parser::TokenFunc1066(x64Operand& operand, int tokenPos) { operand.addressCoding = 105; }
x64Token x64Parser::tokenBranches1065[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1066,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1071},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1457(x64Operand& operand, int tokenPos) { operand.addressCoding = 132; }
x64Token x64Parser::tokenBranches1456[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1457,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1464(x64Operand& operand, int tokenPos) { operand.addressCoding = 133; }
x64Token x64Parser::tokenBranches1463[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1464,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1456(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1463(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1455[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1456, x64Parser::tokenBranches1456},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1463, x64Parser::tokenBranches1463},
    {x64Token::EOT}};
void x64Parser::TokenFunc1450(x64Operand& operand, int tokenPos) { operand.addressCoding = 132; }
x64Token x64Parser::tokenBranches1449[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1450,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1455},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc937(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1065(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1449(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches936[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc937, x64Parser::tokenBranches937},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1065, x64Parser::tokenBranches1065},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1449, x64Parser::tokenBranches1449},
    {x64Token::EOT}};
void x64Parser::TokenFunc475(x64Operand& operand, int tokenPos) { operand.addressCoding = 50; }
x64Token x64Parser::tokenBranches474[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc475,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches583},
                                          {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches936},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc618(x64Operand& operand, int tokenPos) { operand.addressCoding = 51; }
x64Token x64Parser::tokenBranches617[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc618,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc742(x64Operand& operand, int tokenPos) { operand.addressCoding = 74; }
x64Token x64Parser::tokenBranches741[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc742,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc866(x64Operand& operand, int tokenPos) { operand.addressCoding = 88; }
x64Token x64Parser::tokenBranches865[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc866,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2246(x64Operand& operand, int tokenPos) { operand.addressCoding = 170; }
x64Token x64Parser::tokenBranches2245[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2246,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2778(x64Operand& operand, int tokenPos) { operand.addressCoding = 208; }
x64Token x64Parser::tokenBranches2777[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2778,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3076(x64Operand& operand, int tokenPos) { operand.addressCoding = 234; }
x64Token x64Parser::tokenBranches3075[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3076,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2245(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2777(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3075(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2244[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2245, x64Parser::tokenBranches2245},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2777, x64Parser::tokenBranches2777},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3075, x64Parser::tokenBranches3075},
    {x64Token::EOT}};
void x64Parser::TokenFunc2502(x64Operand& operand, int tokenPos) { operand.addressCoding = 170; }
x64Token x64Parser::tokenBranches2243[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2244},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2502,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2243(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2242[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2243, x64Parser::tokenBranches2243},
    {x64Token::EOT}};
void x64Parser::TokenFunc2253(x64Operand& operand, int tokenPos) { operand.addressCoding = 184; }
x64Token x64Parser::tokenBranches2252[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2253,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2785(x64Operand& operand, int tokenPos) { operand.addressCoding = 209; }
x64Token x64Parser::tokenBranches2784[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2785,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3083(x64Operand& operand, int tokenPos) { operand.addressCoding = 235; }
x64Token x64Parser::tokenBranches3082[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3083,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2252(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2784(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3082(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2251[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2252, x64Parser::tokenBranches2252},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2784, x64Parser::tokenBranches2784},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3082, x64Parser::tokenBranches3082},
    {x64Token::EOT}};
void x64Parser::TokenFunc2507(x64Operand& operand, int tokenPos) { operand.addressCoding = 184; }
x64Token x64Parser::tokenBranches2241[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2242},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2251},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2507,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc617(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc741(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc865(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2241(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches616[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc617, x64Parser::tokenBranches617},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc741, x64Parser::tokenBranches741},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc865, x64Parser::tokenBranches865},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2241, x64Parser::tokenBranches2241},
    {x64Token::EOT}};
void x64Parser::TokenFunc1201(x64Operand& operand, int tokenPos) { operand.addressCoding = 114; }
x64Token x64Parser::tokenBranches1200[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1201,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1208(x64Operand& operand, int tokenPos) { operand.addressCoding = 115; }
x64Token x64Parser::tokenBranches1207[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1208,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1215(x64Operand& operand, int tokenPos) { operand.addressCoding = 116; }
x64Token x64Parser::tokenBranches1214[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1215,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1200(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1207(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1214(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1199[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1200, x64Parser::tokenBranches1200},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1207, x64Parser::tokenBranches1207},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1214, x64Parser::tokenBranches1214},
    {x64Token::EOT}};
void x64Parser::TokenFunc1194(x64Operand& operand, int tokenPos) { operand.addressCoding = 114; }
x64Token x64Parser::tokenBranches1193[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1194,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1199},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1329(x64Operand& operand, int tokenPos) { operand.addressCoding = 123; }
x64Token x64Parser::tokenBranches1328[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1329,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1336(x64Operand& operand, int tokenPos) { operand.addressCoding = 124; }
x64Token x64Parser::tokenBranches1335[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1336,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1343(x64Operand& operand, int tokenPos) { operand.addressCoding = 125; }
x64Token x64Parser::tokenBranches1342[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1343,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1328(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1335(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1342(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1327[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1328, x64Parser::tokenBranches1328},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1335, x64Parser::tokenBranches1335},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1342, x64Parser::tokenBranches1342},
    {x64Token::EOT}};
void x64Parser::TokenFunc1322(x64Operand& operand, int tokenPos) { operand.addressCoding = 123; }
x64Token x64Parser::tokenBranches1321[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1322,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1327},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1551(x64Operand& operand, int tokenPos) { operand.addressCoding = 138; }
x64Token x64Parser::tokenBranches1550[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1551,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1558(x64Operand& operand, int tokenPos) { operand.addressCoding = 133; }
x64Token x64Parser::tokenBranches1557[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1558,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1550(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1557(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1549[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1550, x64Parser::tokenBranches1550},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1557, x64Parser::tokenBranches1557},
    {x64Token::EOT}};
void x64Parser::TokenFunc1544(x64Operand& operand, int tokenPos) { operand.addressCoding = 138; }
x64Token x64Parser::tokenBranches1543[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1544,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1549},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1193(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1321(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1543(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1192[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1193, x64Parser::tokenBranches1193},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1321, x64Parser::tokenBranches1321},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1543, x64Parser::tokenBranches1543},
    {x64Token::EOT}};
void x64Parser::TokenFunc478(x64Operand& operand, int tokenPos) { operand.addressCoding = 51; }
x64Token x64Parser::tokenBranches477[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc478,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches616},
                                          {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1192},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc630(x64Operand& operand, int tokenPos) { operand.addressCoding = 53; }
x64Token x64Parser::tokenBranches629[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc630,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc754(x64Operand& operand, int tokenPos) { operand.addressCoding = 76; }
x64Token x64Parser::tokenBranches753[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc754,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc878(x64Operand& operand, int tokenPos) { operand.addressCoding = 90; }
x64Token x64Parser::tokenBranches877[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc878,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc629(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc753(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc877(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches628[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc629, x64Parser::tokenBranches629},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc753, x64Parser::tokenBranches753},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc877, x64Parser::tokenBranches877},
    {x64Token::EOT}};
void x64Parser::TokenFunc486(x64Operand& operand, int tokenPos) { operand.addressCoding = 53; }
x64Token x64Parser::tokenBranches485[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc486,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches628},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc623(x64Operand& operand, int tokenPos) { operand.addressCoding = 52; }
x64Token x64Parser::tokenBranches622[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc623,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc747(x64Operand& operand, int tokenPos) { operand.addressCoding = 75; }
x64Token x64Parser::tokenBranches746[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc747,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc871(x64Operand& operand, int tokenPos) { operand.addressCoding = 89; }
x64Token x64Parser::tokenBranches870[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc871,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc2262(x64Operand& operand, int tokenPos) { operand.addressCoding = 185; }
x64Token x64Parser::tokenBranches2261[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2262,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2794(x64Operand& operand, int tokenPos) { operand.addressCoding = 210; }
x64Token x64Parser::tokenBranches2793[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2794,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3092(x64Operand& operand, int tokenPos) { operand.addressCoding = 236; }
x64Token x64Parser::tokenBranches3091[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3092,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2261(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2793(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3091(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2260[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2261, x64Parser::tokenBranches2261},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2793, x64Parser::tokenBranches2793},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3091, x64Parser::tokenBranches3091},
    {x64Token::EOT}};
void x64Parser::TokenFunc2514(x64Operand& operand, int tokenPos) { operand.addressCoding = 185; }
x64Token x64Parser::tokenBranches2259[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2260},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2514,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2259(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2258[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2259, x64Parser::tokenBranches2259},
    {x64Token::EOT}};
void x64Parser::TokenFunc2269(x64Operand& operand, int tokenPos) { operand.addressCoding = 186; }
x64Token x64Parser::tokenBranches2268[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2269,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2801(x64Operand& operand, int tokenPos) { operand.addressCoding = 211; }
x64Token x64Parser::tokenBranches2800[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2801,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3099(x64Operand& operand, int tokenPos) { operand.addressCoding = 237; }
x64Token x64Parser::tokenBranches3098[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3099,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc2268(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2800(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3098(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2267[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2268, x64Parser::tokenBranches2268},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2800, x64Parser::tokenBranches2800},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3098, x64Parser::tokenBranches3098},
    {x64Token::EOT}};
void x64Parser::TokenFunc2519(x64Operand& operand, int tokenPos) { operand.addressCoding = 186; }
x64Token x64Parser::tokenBranches2257[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2258},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches2267},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc2519,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc622(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc746(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc870(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc2257(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches484[] = {
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches485},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc622, x64Parser::tokenBranches622},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc746, x64Parser::tokenBranches746},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc870, x64Parser::tokenBranches870},
    {x64Token::REGISTERCLASS, 6, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc2257, x64Parser::tokenBranches2257},
    {x64Token::EOT}};
void x64Parser::TokenFunc1595(x64Operand& operand, int tokenPos) { operand.addressCoding = 52; }
x64Token x64Parser::tokenBranches1594[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1595,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1602(x64Operand& operand, int tokenPos) { operand.addressCoding = 75; }
x64Token x64Parser::tokenBranches1601[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1602,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1609(x64Operand& operand, int tokenPos) { operand.addressCoding = 89; }
x64Token x64Parser::tokenBranches1608[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1609,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1594(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1601(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1608(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1593[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1594, x64Parser::tokenBranches1594},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1601, x64Parser::tokenBranches1601},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1608, x64Parser::tokenBranches1608},
    {x64Token::EOT}};
void x64Parser::TokenFunc1588(x64Operand& operand, int tokenPos) { operand.addressCoding = 52; }
x64Token x64Parser::tokenBranches1587[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1588,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1593},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1723(x64Operand& operand, int tokenPos) { operand.addressCoding = 147; }
x64Token x64Parser::tokenBranches1722[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1723,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1730(x64Operand& operand, int tokenPos) { operand.addressCoding = 148; }
x64Token x64Parser::tokenBranches1729[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1730,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1737(x64Operand& operand, int tokenPos) { operand.addressCoding = 149; }
x64Token x64Parser::tokenBranches1736[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1737,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1722(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1729(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1736(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1721[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1722, x64Parser::tokenBranches1722},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1729, x64Parser::tokenBranches1729},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1736, x64Parser::tokenBranches1736},
    {x64Token::EOT}};
void x64Parser::TokenFunc1716(x64Operand& operand, int tokenPos) { operand.addressCoding = 147; }
x64Token x64Parser::tokenBranches1715[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1716,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1721},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1851(x64Operand& operand, int tokenPos) { operand.addressCoding = 156; }
x64Token x64Parser::tokenBranches1850[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1851,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1858(x64Operand& operand, int tokenPos) { operand.addressCoding = 157; }
x64Token x64Parser::tokenBranches1857[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1858,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1874(x64Operand& operand, int tokenPos) { operand.addressCoding = 158; }
x64Token x64Parser::tokenBranches1873[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1874,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1883(x64Operand& operand, int tokenPos) { operand.addressCoding = 159; }
x64Token x64Parser::tokenBranches1882[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1883,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1873(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1882(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1872[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1873, x64Parser::tokenBranches1873},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1882, x64Parser::tokenBranches1882},
    {x64Token::EOT}};
void x64Parser::TokenFunc1865(x64Operand& operand, int tokenPos) { operand.addressCoding = 158; }
x64Token x64Parser::tokenBranches1864[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1865,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1872},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1850(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1857(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1849[] = {
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1864},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1850, x64Parser::tokenBranches1850},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1857, x64Parser::tokenBranches1857},
    {x64Token::EOT}};
void x64Parser::TokenFunc1844(x64Operand& operand, int tokenPos) { operand.addressCoding = 156; }
x64Token x64Parser::tokenBranches1843[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc1844,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1849},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc1587(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1715(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc1843(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches1586[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1587, x64Parser::tokenBranches1587},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1715, x64Parser::tokenBranches1715},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc1843, x64Parser::tokenBranches1843},
    {x64Token::EOT}};
void x64Parser::TokenFunc481(x64Operand& operand, int tokenPos) { operand.addressCoding = 52; }
x64Token x64Parser::tokenBranches480[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData3,
                                              &x64Parser::TokenFunc481,
                                          },
                                          {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches484},
                                          {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches1586},
                                          {x64Token::EOT}};
void x64Parser::TokenFunc560(x64Operand& operand, int tokenPos) { operand.addressCoding = 63; }
x64Token x64Parser::tokenBranches559[] = {{
                                              x64Token::TOKEN,
                                              2,
                                              1,
                                              0,
                                              x64Parser::RegClassData4,
                                              &x64Parser::TokenFunc560,
                                          },
                                          {x64Token::EOT}};
void x64Parser::TokenFunc3261(x64Operand& operand, int tokenPos) { operand.addressCoding = 244; }
x64Token x64Parser::tokenBranches3260[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3261,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3351(x64Operand& operand, int tokenPos) { operand.addressCoding = 261; }
x64Token x64Parser::tokenBranches3350[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3351,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3443(x64Operand& operand, int tokenPos) { operand.addressCoding = 275; }
x64Token x64Parser::tokenBranches3442[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3443,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4515(x64Operand& operand, int tokenPos) { operand.addressCoding = 373; }
x64Token x64Parser::tokenBranches4514[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4515,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4891(x64Operand& operand, int tokenPos) { operand.addressCoding = 397; }
x64Token x64Parser::tokenBranches4890[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4891,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5103(x64Operand& operand, int tokenPos) { operand.addressCoding = 421; }
x64Token x64Parser::tokenBranches5102[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5103,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4514(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4890(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5102(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4513[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4514, x64Parser::tokenBranches4514},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4890, x64Parser::tokenBranches4890},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5102, x64Parser::tokenBranches5102},
    {x64Token::EOT}};
void x64Parser::TokenFunc4713(x64Operand& operand, int tokenPos) { operand.addressCoding = 373; }
x64Token x64Parser::tokenBranches4512[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4513},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4713,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4512(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4511[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4512, x64Parser::tokenBranches4512},
    {x64Token::EOT}};
void x64Parser::TokenFunc4522(x64Operand& operand, int tokenPos) { operand.addressCoding = 374; }
x64Token x64Parser::tokenBranches4521[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4522,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4898(x64Operand& operand, int tokenPos) { operand.addressCoding = 398; }
x64Token x64Parser::tokenBranches4897[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4898,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5110(x64Operand& operand, int tokenPos) { operand.addressCoding = 422; }
x64Token x64Parser::tokenBranches5109[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5110,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4521(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4897(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5109(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4520[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4521, x64Parser::tokenBranches4521},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4897, x64Parser::tokenBranches4897},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5109, x64Parser::tokenBranches5109},
    {x64Token::EOT}};
void x64Parser::TokenFunc4718(x64Operand& operand, int tokenPos) { operand.addressCoding = 374; }
x64Token x64Parser::tokenBranches4510[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4511},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4520},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4718,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3260(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3350(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3442(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4510(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches3259[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3260, x64Parser::tokenBranches3260},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3350, x64Parser::tokenBranches3350},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3442, x64Parser::tokenBranches3442},
    {x64Token::REGISTERCLASS, 9, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4510, x64Parser::tokenBranches4510},
    {x64Token::EOT}};
void x64Parser::TokenFunc3182(x64Operand& operand, int tokenPos) { operand.addressCoding = 244; }
x64Token x64Parser::tokenBranches3181[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3182,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3259},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3307(x64Operand& operand, int tokenPos) { operand.addressCoding = 253; }
x64Token x64Parser::tokenBranches3306[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3307,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3399(x64Operand& operand, int tokenPos) { operand.addressCoding = 269; }
x64Token x64Parser::tokenBranches3398[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3399,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3491(x64Operand& operand, int tokenPos) { operand.addressCoding = 283; }
x64Token x64Parser::tokenBranches3490[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3491,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3306(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3398(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3490(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3305[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3306, x64Parser::tokenBranches3306},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3398, x64Parser::tokenBranches3398},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3490, x64Parser::tokenBranches3490},
    {x64Token::EOT}};
void x64Parser::TokenFunc3219(x64Operand& operand, int tokenPos) { operand.addressCoding = 253; }
x64Token x64Parser::tokenBranches3218[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3219,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3305},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3356(x64Operand& operand, int tokenPos) { operand.addressCoding = 262; }
x64Token x64Parser::tokenBranches3355[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3356,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3448(x64Operand& operand, int tokenPos) { operand.addressCoding = 276; }
x64Token x64Parser::tokenBranches3447[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3448,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4531(x64Operand& operand, int tokenPos) { operand.addressCoding = 375; }
x64Token x64Parser::tokenBranches4530[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4531,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4907(x64Operand& operand, int tokenPos) { operand.addressCoding = 399; }
x64Token x64Parser::tokenBranches4906[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4907,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5119(x64Operand& operand, int tokenPos) { operand.addressCoding = 423; }
x64Token x64Parser::tokenBranches5118[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5119,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4530(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4906(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5118(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4529[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4530, x64Parser::tokenBranches4530},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4906, x64Parser::tokenBranches4906},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5118, x64Parser::tokenBranches5118},
    {x64Token::EOT}};
void x64Parser::TokenFunc4725(x64Operand& operand, int tokenPos) { operand.addressCoding = 375; }
x64Token x64Parser::tokenBranches4528[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4529},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4725,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4528(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4527[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4528, x64Parser::tokenBranches4528},
    {x64Token::EOT}};
void x64Parser::TokenFunc4538(x64Operand& operand, int tokenPos) { operand.addressCoding = 376; }
x64Token x64Parser::tokenBranches4537[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4538,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4914(x64Operand& operand, int tokenPos) { operand.addressCoding = 400; }
x64Token x64Parser::tokenBranches4913[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4914,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5126(x64Operand& operand, int tokenPos) { operand.addressCoding = 424; }
x64Token x64Parser::tokenBranches5125[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5126,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4537(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4913(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5125(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4536[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4537, x64Parser::tokenBranches4537},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4913, x64Parser::tokenBranches4913},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5125, x64Parser::tokenBranches5125},
    {x64Token::EOT}};
void x64Parser::TokenFunc4730(x64Operand& operand, int tokenPos) { operand.addressCoding = 376; }
x64Token x64Parser::tokenBranches4526[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4527},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4536},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4730,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3355(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3447(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4526(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches3217[] = {
    {x64Token::REGISTER, 39, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3218},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3355, x64Parser::tokenBranches3355},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3447, x64Parser::tokenBranches3447},
    {x64Token::REGISTERCLASS, 9, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4526, x64Parser::tokenBranches4526},
    {x64Token::EOT}};
void x64Parser::TokenFunc3265(x64Operand& operand, int tokenPos) { operand.addressCoding = 245; }
x64Token x64Parser::tokenBranches3264[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3265,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3542(x64Operand& operand, int tokenPos) { operand.addressCoding = 245; }
x64Token x64Parser::tokenBranches3541[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3542,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3549(x64Operand& operand, int tokenPos) { operand.addressCoding = 262; }
x64Token x64Parser::tokenBranches3548[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3549,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3556(x64Operand& operand, int tokenPos) { operand.addressCoding = 276; }
x64Token x64Parser::tokenBranches3555[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3556,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3541(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3548(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3555(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3540[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3541, x64Parser::tokenBranches3541},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3548, x64Parser::tokenBranches3548},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3555, x64Parser::tokenBranches3555},
    {x64Token::EOT}};
void x64Parser::TokenFunc3535(x64Operand& operand, int tokenPos) { operand.addressCoding = 245; }
x64Token x64Parser::tokenBranches3534[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3535,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3540},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3602(x64Operand& operand, int tokenPos) { operand.addressCoding = 292; }
x64Token x64Parser::tokenBranches3601[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3602,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3609(x64Operand& operand, int tokenPos) { operand.addressCoding = 293; }
x64Token x64Parser::tokenBranches3608[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3609,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3616(x64Operand& operand, int tokenPos) { operand.addressCoding = 294; }
x64Token x64Parser::tokenBranches3615[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3616,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3601(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3608(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3615(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3600[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3601, x64Parser::tokenBranches3601},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3608, x64Parser::tokenBranches3608},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3615, x64Parser::tokenBranches3615},
    {x64Token::EOT}};
void x64Parser::TokenFunc3595(x64Operand& operand, int tokenPos) { operand.addressCoding = 292; }
x64Token x64Parser::tokenBranches3594[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3595,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3600},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3662(x64Operand& operand, int tokenPos) { operand.addressCoding = 299; }
x64Token x64Parser::tokenBranches3661[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3662,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3661(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3660[] = {
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3661, x64Parser::tokenBranches3661},
    {x64Token::EOT}};
void x64Parser::TokenFunc3655(x64Operand& operand, int tokenPos) { operand.addressCoding = 298; }
x64Token x64Parser::tokenBranches3654[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3655,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3660},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3690(x64Operand& operand, int tokenPos) { operand.addressCoding = 303; }
x64Token x64Parser::tokenBranches3689[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3690,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3689(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3688[] = {
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3689, x64Parser::tokenBranches3689},
    {x64Token::EOT}};
void x64Parser::TokenFunc3683(x64Operand& operand, int tokenPos) { operand.addressCoding = 302; }
x64Token x64Parser::tokenBranches3682[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3683,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3688},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3534(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3594(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3654(x64Operand& operand, int tokenPos)
{
    operand.values[12] = new Coding[2];
    CleanupValues.push_back(operand.values[12]);
    operand.values[12]->type = Coding::number;
    operand.values[12]->val = operands.size();
    operand.values[12]->bits = 0;
    operand.values[12]->field = 0;
    operand.values[12]->unary = 0;
    operand.values[12]->binary = 0;
    operand.values[12][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3682(x64Operand& operand, int tokenPos)
{
    operand.values[13] = new Coding[2];
    CleanupValues.push_back(operand.values[13]);
    operand.values[13]->type = Coding::number;
    operand.values[13]->val = operands.size();
    operand.values[13]->bits = 0;
    operand.values[13]->field = 0;
    operand.values[13]->unary = 0;
    operand.values[13]->binary = 0;
    operand.values[13][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3533[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3534, x64Parser::tokenBranches3534},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3594, x64Parser::tokenBranches3594},
    {x64Token::NUMBER, 20, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3654, x64Parser::tokenBranches3654},
    {x64Token::NUMBER, 21, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3682, x64Parser::tokenBranches3682},
    {x64Token::EOT}};
void x64Parser::TokenFunc3185(x64Operand& operand, int tokenPos) { operand.addressCoding = 245; }
void x64Parser::TokenFunc3264(x64Operand& operand, int tokenPos)
{
    operand.values[11] = new Coding[2];
    CleanupValues.push_back(operand.values[11]);
    operand.values[11]->type = Coding::number;
    operand.values[11]->val = operands.size();
    operand.values[11]->bits = 0;
    operand.values[11]->field = 0;
    operand.values[11]->unary = 0;
    operand.values[11]->binary = 0;
    operand.values[11][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3184[] = {
    {
        x64Token::TOKEN,
        2,
        1,
        0,
        x64Parser::RegClassData3,
        &x64Parser::TokenFunc3185,
    },
    {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3217},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3264, x64Parser::tokenBranches3264},
    {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3533},
    {x64Token::EOT}};
void x64Parser::TokenFunc3270(x64Operand& operand, int tokenPos) { operand.addressCoding = 246; }
x64Token x64Parser::tokenBranches3269[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3270,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3361(x64Operand& operand, int tokenPos) { operand.addressCoding = 263; }
x64Token x64Parser::tokenBranches3360[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3361,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3453(x64Operand& operand, int tokenPos) { operand.addressCoding = 277; }
x64Token x64Parser::tokenBranches3452[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3453,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4465(x64Operand& operand, int tokenPos) { operand.addressCoding = 367; }
x64Token x64Parser::tokenBranches4464[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4465,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4841(x64Operand& operand, int tokenPos) { operand.addressCoding = 391; }
x64Token x64Parser::tokenBranches4840[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4841,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5053(x64Operand& operand, int tokenPos) { operand.addressCoding = 415; }
x64Token x64Parser::tokenBranches5052[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5053,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4464(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4840(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5052(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4463[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4464, x64Parser::tokenBranches4464},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4840, x64Parser::tokenBranches4840},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5052, x64Parser::tokenBranches5052},
    {x64Token::EOT}};
void x64Parser::TokenFunc4675(x64Operand& operand, int tokenPos) { operand.addressCoding = 367; }
x64Token x64Parser::tokenBranches4462[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4463},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4675,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4499(x64Operand& operand, int tokenPos) { operand.addressCoding = 371; }
x64Token x64Parser::tokenBranches4498[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4499,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4875(x64Operand& operand, int tokenPos) { operand.addressCoding = 395; }
x64Token x64Parser::tokenBranches4874[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4875,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5087(x64Operand& operand, int tokenPos) { operand.addressCoding = 419; }
x64Token x64Parser::tokenBranches5086[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5087,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4498(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4874(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5086(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4497[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4498, x64Parser::tokenBranches4498},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4874, x64Parser::tokenBranches4874},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5086, x64Parser::tokenBranches5086},
    {x64Token::EOT}};
void x64Parser::TokenFunc4701(x64Operand& operand, int tokenPos) { operand.addressCoding = 371; }
x64Token x64Parser::tokenBranches4496[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4497},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4701,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4496(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4495[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4496, x64Parser::tokenBranches4496},
    {x64Token::EOT}};
void x64Parser::TokenFunc4506(x64Operand& operand, int tokenPos) { operand.addressCoding = 372; }
x64Token x64Parser::tokenBranches4505[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4506,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4882(x64Operand& operand, int tokenPos) { operand.addressCoding = 396; }
x64Token x64Parser::tokenBranches4881[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4882,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5094(x64Operand& operand, int tokenPos) { operand.addressCoding = 420; }
x64Token x64Parser::tokenBranches5093[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5094,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4505(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4881(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5093(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4504[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4505, x64Parser::tokenBranches4505},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4881, x64Parser::tokenBranches4881},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5093, x64Parser::tokenBranches5093},
    {x64Token::EOT}};
void x64Parser::TokenFunc4706(x64Operand& operand, int tokenPos) { operand.addressCoding = 372; }
x64Token x64Parser::tokenBranches4494[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4495},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4504},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4706,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3269(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3360(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3452(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4494(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches3268[] = {
    {x64Token::REGISTER, 39, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4462},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3269, x64Parser::tokenBranches3269},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3360, x64Parser::tokenBranches3360},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3452, x64Parser::tokenBranches3452},
    {x64Token::REGISTERCLASS, 9, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4494, x64Parser::tokenBranches4494},
    {x64Token::EOT}};
void x64Parser::TokenFunc3718(x64Operand& operand, int tokenPos) { operand.addressCoding = 306; }
x64Token x64Parser::tokenBranches3717[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3718,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3725(x64Operand& operand, int tokenPos) { operand.addressCoding = 307; }
x64Token x64Parser::tokenBranches3724[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3725,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3732(x64Operand& operand, int tokenPos) { operand.addressCoding = 308; }
x64Token x64Parser::tokenBranches3731[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3732,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3717(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3724(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3731(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3716[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3717, x64Parser::tokenBranches3717},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3724, x64Parser::tokenBranches3724},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3731, x64Parser::tokenBranches3731},
    {x64Token::EOT}};
void x64Parser::TokenFunc3711(x64Operand& operand, int tokenPos) { operand.addressCoding = 306; }
x64Token x64Parser::tokenBranches3710[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3711,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3716},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3846(x64Operand& operand, int tokenPos) { operand.addressCoding = 315; }
x64Token x64Parser::tokenBranches3845[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3846,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3853(x64Operand& operand, int tokenPos) { operand.addressCoding = 316; }
x64Token x64Parser::tokenBranches3852[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3853,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3860(x64Operand& operand, int tokenPos) { operand.addressCoding = 317; }
x64Token x64Parser::tokenBranches3859[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3860,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3845(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3852(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3859(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3844[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3845, x64Parser::tokenBranches3845},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3852, x64Parser::tokenBranches3852},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3859, x64Parser::tokenBranches3859},
    {x64Token::EOT}};
void x64Parser::TokenFunc3839(x64Operand& operand, int tokenPos) { operand.addressCoding = 315; }
x64Token x64Parser::tokenBranches3838[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3839,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3844},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4230(x64Operand& operand, int tokenPos) { operand.addressCoding = 343; }
x64Token x64Parser::tokenBranches4229[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4230,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4229(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4228[] = {
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4229, x64Parser::tokenBranches4229},
    {x64Token::EOT}};
void x64Parser::TokenFunc4223(x64Operand& operand, int tokenPos) { operand.addressCoding = 342; }
x64Token x64Parser::tokenBranches4222[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4223,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4228},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3710(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3838(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4222(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3709[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3710, x64Parser::tokenBranches3710},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3838, x64Parser::tokenBranches3838},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4222, x64Parser::tokenBranches4222},
    {x64Token::EOT}};
void x64Parser::TokenFunc3188(x64Operand& operand, int tokenPos) { operand.addressCoding = 246; }
x64Token x64Parser::tokenBranches3187[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3188,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3268},
                                           {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3709},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3295(x64Operand& operand, int tokenPos) { operand.addressCoding = 247; }
x64Token x64Parser::tokenBranches3294[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3295,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3387(x64Operand& operand, int tokenPos) { operand.addressCoding = 267; }
x64Token x64Parser::tokenBranches3386[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3387,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3479(x64Operand& operand, int tokenPos) { operand.addressCoding = 281; }
x64Token x64Parser::tokenBranches3478[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3479,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4472(x64Operand& operand, int tokenPos) { operand.addressCoding = 368; }
x64Token x64Parser::tokenBranches4471[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4472,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4848(x64Operand& operand, int tokenPos) { operand.addressCoding = 392; }
x64Token x64Parser::tokenBranches4847[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4848,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5060(x64Operand& operand, int tokenPos) { operand.addressCoding = 416; }
x64Token x64Parser::tokenBranches5059[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5060,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4471(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4847(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5059(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4470[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4471, x64Parser::tokenBranches4471},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4847, x64Parser::tokenBranches4847},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5059, x64Parser::tokenBranches5059},
    {x64Token::EOT}};
void x64Parser::TokenFunc4680(x64Operand& operand, int tokenPos) { operand.addressCoding = 368; }
x64Token x64Parser::tokenBranches4469[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4470},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4680,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4607(x64Operand& operand, int tokenPos) { operand.addressCoding = 383; }
x64Token x64Parser::tokenBranches4606[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4607,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4983(x64Operand& operand, int tokenPos) { operand.addressCoding = 407; }
x64Token x64Parser::tokenBranches4982[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4983,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5195(x64Operand& operand, int tokenPos) { operand.addressCoding = 431; }
x64Token x64Parser::tokenBranches5194[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5195,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4606(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4982(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5194(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4605[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4606, x64Parser::tokenBranches4606},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4982, x64Parser::tokenBranches4982},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5194, x64Parser::tokenBranches5194},
    {x64Token::EOT}};
void x64Parser::TokenFunc4785(x64Operand& operand, int tokenPos) { operand.addressCoding = 383; }
x64Token x64Parser::tokenBranches4604[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4605},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4785,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4604(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4603[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4604, x64Parser::tokenBranches4604},
    {x64Token::EOT}};
void x64Parser::TokenFunc4614(x64Operand& operand, int tokenPos) { operand.addressCoding = 384; }
x64Token x64Parser::tokenBranches4613[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4614,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4990(x64Operand& operand, int tokenPos) { operand.addressCoding = 408; }
x64Token x64Parser::tokenBranches4989[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4990,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5202(x64Operand& operand, int tokenPos) { operand.addressCoding = 432; }
x64Token x64Parser::tokenBranches5201[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5202,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4613(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4989(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5201(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4612[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4613, x64Parser::tokenBranches4613},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4989, x64Parser::tokenBranches4989},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5201, x64Parser::tokenBranches5201},
    {x64Token::EOT}};
void x64Parser::TokenFunc4790(x64Operand& operand, int tokenPos) { operand.addressCoding = 384; }
x64Token x64Parser::tokenBranches4602[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4603},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4612},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4790,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3294(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3386(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3478(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4602(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches3293[] = {
    {x64Token::REGISTER, 39, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4469},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3294, x64Parser::tokenBranches3294},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3386, x64Parser::tokenBranches3386},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3478, x64Parser::tokenBranches3478},
    {x64Token::REGISTERCLASS, 9, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4602, x64Parser::tokenBranches4602},
    {x64Token::EOT}};
void x64Parser::TokenFunc3974(x64Operand& operand, int tokenPos) { operand.addressCoding = 324; }
x64Token x64Parser::tokenBranches3973[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3974,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3981(x64Operand& operand, int tokenPos) { operand.addressCoding = 325; }
x64Token x64Parser::tokenBranches3980[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3981,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3988(x64Operand& operand, int tokenPos) { operand.addressCoding = 326; }
x64Token x64Parser::tokenBranches3987[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3988,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3973(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3980(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3987(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3972[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3973, x64Parser::tokenBranches3973},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3980, x64Parser::tokenBranches3980},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3987, x64Parser::tokenBranches3987},
    {x64Token::EOT}};
void x64Parser::TokenFunc3967(x64Operand& operand, int tokenPos) { operand.addressCoding = 324; }
x64Token x64Parser::tokenBranches3966[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3967,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3972},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4102(x64Operand& operand, int tokenPos) { operand.addressCoding = 333; }
x64Token x64Parser::tokenBranches4101[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4102,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4109(x64Operand& operand, int tokenPos) { operand.addressCoding = 334; }
x64Token x64Parser::tokenBranches4108[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4109,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4116(x64Operand& operand, int tokenPos) { operand.addressCoding = 335; }
x64Token x64Parser::tokenBranches4115[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4116,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4101(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4108(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4115(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4100[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4101, x64Parser::tokenBranches4101},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4108, x64Parser::tokenBranches4108},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4115, x64Parser::tokenBranches4115},
    {x64Token::EOT}};
void x64Parser::TokenFunc4095(x64Operand& operand, int tokenPos) { operand.addressCoding = 333; }
x64Token x64Parser::tokenBranches4094[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4095,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4100},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4258(x64Operand& operand, int tokenPos) { operand.addressCoding = 347; }
x64Token x64Parser::tokenBranches4257[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4258,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4257(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4256[] = {
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4257, x64Parser::tokenBranches4257},
    {x64Token::EOT}};
void x64Parser::TokenFunc4251(x64Operand& operand, int tokenPos) { operand.addressCoding = 346; }
x64Token x64Parser::tokenBranches4250[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4251,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4256},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3966(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4094(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4250(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3965[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3966, x64Parser::tokenBranches3966},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4094, x64Parser::tokenBranches4094},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4250, x64Parser::tokenBranches4250},
    {x64Token::EOT}};
void x64Parser::TokenFunc3191(x64Operand& operand, int tokenPos) { operand.addressCoding = 247; }
x64Token x64Parser::tokenBranches3190[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3191,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3293},
                                           {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3965},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3314(x64Operand& operand, int tokenPos) { operand.addressCoding = 254; }
x64Token x64Parser::tokenBranches3313[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3314,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3406(x64Operand& operand, int tokenPos) { operand.addressCoding = 270; }
x64Token x64Parser::tokenBranches3405[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3406,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3498(x64Operand& operand, int tokenPos) { operand.addressCoding = 284; }
x64Token x64Parser::tokenBranches3497[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3498,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3313(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3405(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3497(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3312[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3313, x64Parser::tokenBranches3313},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3405, x64Parser::tokenBranches3405},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3497, x64Parser::tokenBranches3497},
    {x64Token::EOT}};
void x64Parser::TokenFunc3224(x64Operand& operand, int tokenPos) { operand.addressCoding = 254; }
x64Token x64Parser::tokenBranches3223[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3224,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3312},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3300(x64Operand& operand, int tokenPos) { operand.addressCoding = 252; }
x64Token x64Parser::tokenBranches3299[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3300,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3392(x64Operand& operand, int tokenPos) { operand.addressCoding = 268; }
x64Token x64Parser::tokenBranches3391[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3392,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3484(x64Operand& operand, int tokenPos) { operand.addressCoding = 282; }
x64Token x64Parser::tokenBranches3483[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3484,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4623(x64Operand& operand, int tokenPos) { operand.addressCoding = 385; }
x64Token x64Parser::tokenBranches4622[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4623,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4999(x64Operand& operand, int tokenPos) { operand.addressCoding = 409; }
x64Token x64Parser::tokenBranches4998[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4999,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5211(x64Operand& operand, int tokenPos) { operand.addressCoding = 433; }
x64Token x64Parser::tokenBranches5210[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5211,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4622(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4998(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5210(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4621[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4622, x64Parser::tokenBranches4622},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4998, x64Parser::tokenBranches4998},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5210, x64Parser::tokenBranches5210},
    {x64Token::EOT}};
void x64Parser::TokenFunc4797(x64Operand& operand, int tokenPos) { operand.addressCoding = 385; }
x64Token x64Parser::tokenBranches4620[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4621},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4797,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4620(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4619[] = {
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4620, x64Parser::tokenBranches4620},
    {x64Token::EOT}};
void x64Parser::TokenFunc4630(x64Operand& operand, int tokenPos) { operand.addressCoding = 386; }
x64Token x64Parser::tokenBranches4629[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4630,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5006(x64Operand& operand, int tokenPos) { operand.addressCoding = 410; }
x64Token x64Parser::tokenBranches5005[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5006,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5218(x64Operand& operand, int tokenPos) { operand.addressCoding = 434; }
x64Token x64Parser::tokenBranches5217[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc5218,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4629(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5005(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc5217(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4628[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4629, x64Parser::tokenBranches4629},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5005, x64Parser::tokenBranches5005},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc5217, x64Parser::tokenBranches5217},
    {x64Token::EOT}};
void x64Parser::TokenFunc4802(x64Operand& operand, int tokenPos) { operand.addressCoding = 386; }
x64Token x64Parser::tokenBranches4618[] = {{x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4619},
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4628},
                                           {
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4802,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3299(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3391(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3483(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4618(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches3222[] = {
    {x64Token::REGISTER, 39, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3223},
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3299, x64Parser::tokenBranches3299},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3391, x64Parser::tokenBranches3391},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3483, x64Parser::tokenBranches3483},
    {x64Token::REGISTERCLASS, 9, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4618, x64Parser::tokenBranches4618},
    {x64Token::EOT}};
void x64Parser::TokenFunc4286(x64Operand& operand, int tokenPos) { operand.addressCoding = 252; }
x64Token x64Parser::tokenBranches4285[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4286,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4293(x64Operand& operand, int tokenPos) { operand.addressCoding = 268; }
x64Token x64Parser::tokenBranches4292[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4293,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4300(x64Operand& operand, int tokenPos) { operand.addressCoding = 282; }
x64Token x64Parser::tokenBranches4299[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4300,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4285(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4292(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4299(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4284[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4285, x64Parser::tokenBranches4285},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4292, x64Parser::tokenBranches4292},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4299, x64Parser::tokenBranches4299},
    {x64Token::EOT}};
void x64Parser::TokenFunc4279(x64Operand& operand, int tokenPos) { operand.addressCoding = 252; }
x64Token x64Parser::tokenBranches4278[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4279,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4284},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4346(x64Operand& operand, int tokenPos) { operand.addressCoding = 353; }
x64Token x64Parser::tokenBranches4345[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4346,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4353(x64Operand& operand, int tokenPos) { operand.addressCoding = 354; }
x64Token x64Parser::tokenBranches4352[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4353,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4360(x64Operand& operand, int tokenPos) { operand.addressCoding = 355; }
x64Token x64Parser::tokenBranches4359[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4360,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4345(x64Operand& operand, int tokenPos)
{
    operand.values[3] = new Coding[2];
    CleanupValues.push_back(operand.values[3]);
    operand.values[3]->type = Coding::number;
    operand.values[3]->val = operands.size();
    operand.values[3]->bits = 0;
    operand.values[3]->field = 0;
    operand.values[3]->unary = 0;
    operand.values[3]->binary = 0;
    operand.values[3][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4352(x64Operand& operand, int tokenPos)
{
    operand.values[4] = new Coding[2];
    CleanupValues.push_back(operand.values[4]);
    operand.values[4]->type = Coding::number;
    operand.values[4]->val = operands.size();
    operand.values[4]->bits = 0;
    operand.values[4]->field = 0;
    operand.values[4]->unary = 0;
    operand.values[4]->binary = 0;
    operand.values[4][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4359(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4344[] = {
    {x64Token::NUMBER, 17, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4345, x64Parser::tokenBranches4345},
    {x64Token::NUMBER, 0, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4352, x64Parser::tokenBranches4352},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4359, x64Parser::tokenBranches4359},
    {x64Token::EOT}};
void x64Parser::TokenFunc4339(x64Operand& operand, int tokenPos) { operand.addressCoding = 353; }
x64Token x64Parser::tokenBranches4338[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4339,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4344},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4406(x64Operand& operand, int tokenPos) { operand.addressCoding = 360; }
x64Token x64Parser::tokenBranches4405[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4406,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4422(x64Operand& operand, int tokenPos) { operand.addressCoding = 362; }
x64Token x64Parser::tokenBranches4421[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4422,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4421(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4420[] = {
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4421, x64Parser::tokenBranches4421},
    {x64Token::EOT}};
void x64Parser::TokenFunc4413(x64Operand& operand, int tokenPos) { operand.addressCoding = 361; }
x64Token x64Parser::tokenBranches4412[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4413,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4420},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4405(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4404[] = {
    {x64Token::REGISTER, 39, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4412},
    {x64Token::NUMBER, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4405, x64Parser::tokenBranches4405},
    {x64Token::EOT}};
void x64Parser::TokenFunc4399(x64Operand& operand, int tokenPos) { operand.addressCoding = 359; }
x64Token x64Parser::tokenBranches4398[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc4399,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4404},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc4278(x64Operand& operand, int tokenPos)
{
    operand.values[6] = new Coding[2];
    CleanupValues.push_back(operand.values[6]);
    operand.values[6]->type = Coding::number;
    operand.values[6]->val = operands.size();
    operand.values[6]->bits = 0;
    operand.values[6]->field = 0;
    operand.values[6]->unary = 0;
    operand.values[6]->binary = 0;
    operand.values[6][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4338(x64Operand& operand, int tokenPos)
{
    operand.values[7] = new Coding[2];
    CleanupValues.push_back(operand.values[7]);
    operand.values[7]->type = Coding::number;
    operand.values[7]->val = operands.size();
    operand.values[7]->bits = 0;
    operand.values[7]->field = 0;
    operand.values[7]->unary = 0;
    operand.values[7]->binary = 0;
    operand.values[7][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc4398(x64Operand& operand, int tokenPos)
{
    operand.values[8] = new Coding[2];
    CleanupValues.push_back(operand.values[8]);
    operand.values[8]->type = Coding::number;
    operand.values[8]->val = operands.size();
    operand.values[8]->bits = 0;
    operand.values[8]->field = 0;
    operand.values[8]->unary = 0;
    operand.values[8]->binary = 0;
    operand.values[8][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches4277[] = {
    {x64Token::NUMBER, 18, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4278, x64Parser::tokenBranches4278},
    {x64Token::NUMBER, 19, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4338, x64Parser::tokenBranches4338},
    {x64Token::NUMBER, 16, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc4398, x64Parser::tokenBranches4398},
    {x64Token::EOT}};
void x64Parser::TokenFunc3214(x64Operand& operand, int tokenPos) { operand.addressCoding = 252; }
x64Token x64Parser::tokenBranches3213[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData3,
                                               &x64Parser::TokenFunc3214,
                                           },
                                           {x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3222},
                                           {x64Token::TOKEN, 5, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches4277},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3248(x64Operand& operand, int tokenPos) { operand.addressCoding = 258; }
x64Token x64Parser::tokenBranches3247[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData5,
                                               &x64Parser::TokenFunc3248,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3247(x64Operand& operand, int tokenPos)
{
    operand.values[10] = new Coding[2];
    CleanupValues.push_back(operand.values[10]);
    operand.values[10]->type = Coding::number;
    operand.values[10]->val = operands.size();
    operand.values[10]->bits = 0;
    operand.values[10]->field = 0;
    operand.values[10]->unary = 0;
    operand.values[10]->binary = 0;
    operand.values[10][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches3246[] = {
    {x64Token::NUMBER, 15, 0, 0, x64Parser::RegClassData5, &x64Parser::TokenFunc3247, x64Parser::tokenBranches3247},
    {x64Token::EOT}};
x64Token x64Parser::tokenBranches3245[] = {{x64Token::TOKEN, 4, 0, 0, x64Parser::RegClassData5, NULL, x64Parser::tokenBranches3246},
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3251(x64Operand& operand, int tokenPos) { operand.addressCoding = 259; }
x64Token x64Parser::tokenBranches3250[] = {{
                                               x64Token::TOKEN,
                                               2,
                                               1,
                                               0,
                                               x64Parser::RegClassData5,
                                               &x64Parser::TokenFunc3251,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc3(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc16(x64Operand& operand, int tokenPos)
{
    operand.values[1] = new Coding[2];
    CleanupValues.push_back(operand.values[1]);
    operand.values[1]->type = Coding::reg;
    operand.values[1]->val = inputTokens[tokenPos]->val->ival;
    operand.values[1]->bits = 0;
    operand.values[1]->field = 0;
    operand.values[1]->unary = 0;
    operand.values[1]->binary = 0;
    operand.values[1][1].type = Coding::eot;
}
void x64Parser::TokenFunc73(x64Operand& operand, int tokenPos)
{
    operand.values[2] = new Coding[2];
    CleanupValues.push_back(operand.values[2]);
    operand.values[2]->type = Coding::reg;
    operand.values[2]->val = inputTokens[tokenPos]->val->ival;
    operand.values[2]->bits = 0;
    operand.values[2]->field = 0;
    operand.values[2]->unary = 0;
    operand.values[2]->binary = 0;
    operand.values[2][1].type = Coding::eot;
}
void x64Parser::TokenFunc480(x64Operand& operand, int tokenPos)
{
    operand.values[5] = new Coding[2];
    CleanupValues.push_back(operand.values[5]);
    operand.values[5]->type = Coding::reg;
    operand.values[5]->val = inputTokens[tokenPos]->val->ival;
    operand.values[5]->bits = 0;
    operand.values[5]->field = 0;
    operand.values[5]->unary = 0;
    operand.values[5]->binary = 0;
    operand.values[5][1].type = Coding::eot;
}
void x64Parser::TokenFunc559(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
void x64Parser::TokenFunc3213(x64Operand& operand, int tokenPos)
{
    operand.values[5] = new Coding[2];
    CleanupValues.push_back(operand.values[5]);
    operand.values[5]->type = Coding::reg;
    operand.values[5]->val = inputTokens[tokenPos]->val->ival;
    operand.values[5]->bits = 0;
    operand.values[5]->field = 0;
    operand.values[5]->unary = 0;
    operand.values[5]->binary = 0;
    operand.values[5][1].type = Coding::eot;
}
void x64Parser::TokenFunc3250(x64Operand& operand, int tokenPos)
{
    operand.values[0] = new Coding[2];
    CleanupValues.push_back(operand.values[0]);
    operand.values[0]->type = Coding::number;
    operand.values[0]->val = operands.size();
    operand.values[0]->bits = 0;
    operand.values[0]->field = 0;
    operand.values[0]->unary = 0;
    operand.values[0]->binary = 0;
    operand.values[0][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches2[] = {
    {x64Token::REGISTER, 96, 0, 0, x64Parser::RegClassData1, NULL, x64Parser::tokenBranches6},
    {x64Token::REGISTER, 95, 0, 0, x64Parser::RegClassData1, NULL, x64Parser::tokenBranches11},
    {x64Token::REGISTER, 29, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches21},
    {x64Token::REGISTER, 45, 0, 0, x64Parser::RegClassData2, NULL, x64Parser::tokenBranches26},
    {x64Token::REGISTER, 38, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches471},
    {x64Token::REGISTER, 46, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches474},
    {x64Token::REGISTER, 50, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches477},
    {x64Token::REGISTER, 39, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3181},
    {x64Token::REGISTER, 43, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3184},
    {x64Token::REGISTER, 47, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3187},
    {x64Token::REGISTER, 51, 0, 0, x64Parser::RegClassData3, NULL, x64Parser::tokenBranches3190},
    {x64Token::REGISTER, 68, 0, 0, x64Parser::RegClassData5, NULL, x64Parser::tokenBranches3245},
    {x64Token::NUMBER, 6, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc3, x64Parser::tokenBranches3},
    {x64Token::REGISTERCLASS, 19, 0, 0, x64Parser::RegClassData1, &x64Parser::TokenFunc16, x64Parser::tokenBranches16},
    {x64Token::REGISTERCLASS, 15, 0, 0, x64Parser::RegClassData2, &x64Parser::TokenFunc73, x64Parser::tokenBranches73},
    {x64Token::REGISTERCLASS, 5, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc480, x64Parser::tokenBranches480},
    {x64Token::NUMBER, 7, 0, 0, x64Parser::RegClassData4, &x64Parser::TokenFunc559, x64Parser::tokenBranches559},
    {x64Token::REGISTERCLASS, 8, 0, 0, x64Parser::RegClassData3, &x64Parser::TokenFunc3213, x64Parser::tokenBranches3213},
    {x64Token::NUMBER, 8, 0, 0, x64Parser::RegClassData5, &x64Parser::TokenFunc3250, x64Parser::tokenBranches3250},
    {x64Token::EOT}};
void x64Parser::TokenFunc5259(x64Operand& operand, int tokenPos)
{
    operand.addressCoding = 439;
    operand.values[14] = new Coding[2];
    CleanupValues.push_back(operand.values[14]);
    operand.values[14]->type = Coding::reg;
    operand.values[14]->val = inputTokens[tokenPos]->val->ival;
    operand.values[14]->bits = 0;
    operand.values[14]->field = 0;
    operand.values[14]->unary = 0;
    operand.values[14]->binary = 0;
    operand.values[14][1].type = Coding::eot;
}
void x64Parser::TokenFunc5260(x64Operand& operand, int tokenPos)
{
    operand.addressCoding = 440;
    operand.values[14] = new Coding[2];
    CleanupValues.push_back(operand.values[14]);
    operand.values[14]->type = Coding::reg;
    operand.values[14]->val = inputTokens[tokenPos]->val->ival;
    operand.values[14]->bits = 0;
    operand.values[14]->field = 0;
    operand.values[14]->unary = 0;
    operand.values[14]->binary = 0;
    operand.values[14][1].type = Coding::eot;
}
void x64Parser::TokenFunc5261(x64Operand& operand, int tokenPos)
{
    operand.addressCoding = 441;
    operand.values[14] = new Coding[2];
    CleanupValues.push_back(operand.values[14]);
    operand.values[14]->type = Coding::reg;
    operand.values[14]->val = inputTokens[tokenPos]->val->ival;
    operand.values[14]->bits = 0;
    operand.values[14]->field = 0;
    operand.values[14]->unary = 0;
    operand.values[14]->binary = 0;
    operand.values[14][1].type = Coding::eot;
}
void x64Parser::TokenFunc5262(x64Operand& operand, int tokenPos)
{
    operand.addressCoding = 440;
    operand.values[14] = new Coding[2];
    CleanupValues.push_back(operand.values[14]);
    operand.values[14]->type = Coding::reg;
    operand.values[14]->val = inputTokens[tokenPos]->val->ival;
    operand.values[14]->bits = 0;
    operand.values[14]->field = 0;
    operand.values[14]->unary = 0;
    operand.values[14]->binary = 0;
    operand.values[14][1].type = Coding::eot;
}
void x64Parser::TokenFunc5263(x64Operand& operand, int tokenPos)
{
    operand.addressCoding = 440;
    operand.values[14] = new Coding[2];
    CleanupValues.push_back(operand.values[14]);
    operand.values[14]->type = Coding::reg;
    operand.values[14]->val = inputTokens[tokenPos]->val->ival;
    operand.values[14]->bits = 0;
    operand.values[14]->field = 0;
    operand.values[14]->unary = 0;
    operand.values[14]->binary = 0;
    operand.values[14][1].type = Coding::eot;
}
void x64Parser::TokenFunc5264(x64Operand& operand, int tokenPos)
{
    operand.addressCoding = 440;
    operand.values[14] = new Coding[2];
    CleanupValues.push_back(operand.values[14]);
    operand.values[14]->type = Coding::reg;
    operand.values[14]->val = inputTokens[tokenPos]->val->ival;
    operand.values[14]->bits = 0;
    operand.values[14]->field = 0;
    operand.values[14]->unary = 0;
    operand.values[14]->binary = 0;
    operand.values[14][1].type = Coding::eot;
}
void x64Parser::TokenFunc5265(x64Operand& operand, int tokenPos)
{
    operand.addressCoding = 442;
    operand.values[14] = new Coding[2];
    CleanupValues.push_back(operand.values[14]);
    operand.values[14]->type = Coding::reg;
    operand.values[14]->val = inputTokens[tokenPos]->val->ival;
    operand.values[14]->bits = 0;
    operand.values[14]->field = 0;
    operand.values[14]->unary = 0;
    operand.values[14]->binary = 0;
    operand.values[14][1].type = Coding::eot;
}
void x64Parser::TokenFunc5266(x64Operand& operand, int tokenPos)
{
    operand.addressCoding = 440;
    operand.values[14] = new Coding[2];
    CleanupValues.push_back(operand.values[14]);
    operand.values[14]->type = Coding::reg;
    operand.values[14]->val = inputTokens[tokenPos]->val->ival;
    operand.values[14]->bits = 0;
    operand.values[14]->field = 0;
    operand.values[14]->unary = 0;
    operand.values[14]->binary = 0;
    operand.values[14][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches1[] = {{x64Token::TOKEN, 1, 0, 0, x64Parser::RegClassData1, NULL, x64Parser::tokenBranches2},
                                        {
                                            x64Token::REGISTERCLASS,
                                            20,
                                            1,
                                            0,
                                            x64Parser::RegClassData6,
                                            &x64Parser::TokenFunc5259,
                                        },
                                        {
                                            x64Token::REGISTERCLASS,
                                            1,
                                            1,
                                            0,
                                            x64Parser::RegClassData7,
                                            &x64Parser::TokenFunc5260,
                                        },
                                        {
                                            x64Token::REGISTERCLASS,
                                            14,
                                            1,
                                            0,
                                            x64Parser::RegClassData8,
                                            &x64Parser::TokenFunc5261,
                                        },
                                        {
                                            x64Token::REGISTERCLASS,
                                            4,
                                            1,
                                            0,
                                            x64Parser::RegClassData9,
                                            &x64Parser::TokenFunc5262,
                                        },
                                        {
                                            x64Token::REGISTERCLASS,
                                            7,
                                            1,
                                            0,
                                            x64Parser::RegClassData10,
                                            &x64Parser::TokenFunc5263,
                                        },
                                        {
                                            x64Token::REGISTERCLASS,
                                            10,
                                            1,
                                            0,
                                            x64Parser::RegClassData11,
                                            &x64Parser::TokenFunc5264,
                                        },
                                        {
                                            x64Token::REGISTERCLASS,
                                            18,
                                            1,
                                            0,
                                            x64Parser::RegClassData12,
                                            &x64Parser::TokenFunc5265,
                                        },
                                        {
                                            x64Token::REGISTERCLASS,
                                            17,
                                            1,
                                            0,
                                            x64Parser::RegClassData13,
                                            &x64Parser::TokenFunc5266,
                                        },
                                        {x64Token::EOT}};
void x64Parser::TokenFunc5268(x64Operand& operand, int tokenPos) { operand.operandCoding = 443; }
x64Token x64Parser::tokenBranches5267[] = {{
                                               x64Token::EMPTY,
                                               0,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5268,
                                           },
                                           {x64Token::EOT}};
void x64Parser::TokenFunc5270(x64Operand& operand, int tokenPos) { operand.operandCoding = 444; }
x64Token x64Parser::tokenBranches5269[] = {{
                                               x64Token::EMPTY,
                                               0,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5270,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5275_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5275_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5275_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5275_18[] = {
    {CODING_NAME("rm") Coding::stateFunc, 3},
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 35, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5275(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5275_15;
    operand.values[16] = tokenCoding5275_16;
    operand.values[17] = tokenCoding5275_17;
    operand.values[18] = tokenCoding5275_18;
}
Coding x64Parser::tokenCoding5287_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5287_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5287_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5287_18[] = {
    {CODING_NAME("rm") Coding::stateFunc, 3},
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 35, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5287(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5287_15;
    operand.values[16] = tokenCoding5287_16;
    operand.values[17] = tokenCoding5287_17;
    operand.values[18] = tokenCoding5287_18;
}
x64Token x64Parser::tokenBranches5274[] = {{
                                               x64Token::ADDRESSCLASS,
                                               17,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5275,
                                           },
                                           {
                                               x64Token::ADDRESSCLASS,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5287,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5273[] = {{x64Token::TOKEN, 8, 0, 1, NULL, NULL, x64Parser::tokenBranches5274}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5272[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5273}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5279_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5279_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5279_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5279_18[] = {
    {CODING_NAME("rm") Coding::stateFunc, 4},
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 35, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5279(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5279_15;
    operand.values[16] = tokenCoding5279_16;
    operand.values[17] = tokenCoding5279_17;
    operand.values[18] = tokenCoding5279_18;
}
Coding x64Parser::tokenCoding5291_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5291_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5291_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5291_18[] = {
    {CODING_NAME("rm") Coding::stateFunc, 4},
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 35, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5291(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5291_15;
    operand.values[16] = tokenCoding5291_16;
    operand.values[17] = tokenCoding5291_17;
    operand.values[18] = tokenCoding5291_18;
}
x64Token x64Parser::tokenBranches5278[] = {{
                                               x64Token::ADDRESSCLASS,
                                               19,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5279,
                                           },
                                           {
                                               x64Token::ADDRESSCLASS,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5291,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5277[] = {{x64Token::TOKEN, 9, 0, 1, NULL, NULL, x64Parser::tokenBranches5278}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5276[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5277}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5283_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5283_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5283_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5283_18[] = {
    {CODING_NAME("rm") Coding::stateFunc, 5},
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 35, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5283(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5283_15;
    operand.values[16] = tokenCoding5283_16;
    operand.values[17] = tokenCoding5283_17;
    operand.values[18] = tokenCoding5283_18;
}
Coding x64Parser::tokenCoding5295_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5295_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5295_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5295_18[] = {
    {CODING_NAME("rm") Coding::stateFunc, 5},
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 35, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5295(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5295_15;
    operand.values[16] = tokenCoding5295_16;
    operand.values[17] = tokenCoding5295_17;
    operand.values[18] = tokenCoding5295_18;
}
x64Token x64Parser::tokenBranches5282[] = {{
                                               x64Token::ADDRESSCLASS,
                                               21,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5283,
                                           },
                                           {
                                               x64Token::ADDRESSCLASS,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5295,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5281[] = {{x64Token::TOKEN, 10, 0, 1, NULL, NULL, x64Parser::tokenBranches5282}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5280[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5281}, {x64Token::EOT}};
void x64Parser::TokenFunc5272(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
}
void x64Parser::TokenFunc5276(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
}
void x64Parser::TokenFunc5280(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches5271[] = {
    {x64Token::REGISTERCLASS, 4, 0, 0, NULL, &x64Parser::TokenFunc5272, x64Parser::tokenBranches5272},
    {x64Token::REGISTERCLASS, 7, 0, 0, NULL, &x64Parser::TokenFunc5276, x64Parser::tokenBranches5276},
    {x64Token::REGISTERCLASS, 10, 0, 0, NULL, &x64Parser::TokenFunc5280, x64Parser::tokenBranches5280},
    {x64Token::EOT}};
Coding x64Parser::tokenCoding5300_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5300_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5300_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5300_18[] = {
    {CODING_NAME("rm") Coding::stateFunc, 3},
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 35, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5300(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5300_15;
    operand.values[16] = tokenCoding5300_16;
    operand.values[17] = tokenCoding5300_17;
    operand.values[18] = tokenCoding5300_18;
}
x64Token x64Parser::tokenBranches5299[] = {{
                                               x64Token::ADDRESSCLASS,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5300,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5298[] = {{x64Token::TOKEN, 8, 0, 1, NULL, NULL, x64Parser::tokenBranches5299}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5297[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5298}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5304_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5304_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5304_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5304_18[] = {
    {CODING_NAME("rm") Coding::stateFunc, 4},
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 35, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5304(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5304_15;
    operand.values[16] = tokenCoding5304_16;
    operand.values[17] = tokenCoding5304_17;
    operand.values[18] = tokenCoding5304_18;
}
x64Token x64Parser::tokenBranches5303[] = {{
                                               x64Token::ADDRESSCLASS,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5304,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5302[] = {{x64Token::TOKEN, 9, 0, 1, NULL, NULL, x64Parser::tokenBranches5303}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5301[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5302}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5308_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5308_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5308_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5308_18[] = {
    {CODING_NAME("rm") Coding::stateFunc, 5},
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 35, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5308(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5308_15;
    operand.values[16] = tokenCoding5308_16;
    operand.values[17] = tokenCoding5308_17;
    operand.values[18] = tokenCoding5308_18;
}
x64Token x64Parser::tokenBranches5307[] = {{
                                               x64Token::ADDRESSCLASS,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5308,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5306[] = {{x64Token::TOKEN, 10, 0, 1, NULL, NULL, x64Parser::tokenBranches5307}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5305[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5306}, {x64Token::EOT}};
void x64Parser::TokenFunc5297(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
}
void x64Parser::TokenFunc5301(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
}
void x64Parser::TokenFunc5305(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches5296[] = {
    {x64Token::REGISTERCLASS, 4, 0, 0, NULL, &x64Parser::TokenFunc5297, x64Parser::tokenBranches5297},
    {x64Token::REGISTERCLASS, 7, 0, 0, NULL, &x64Parser::TokenFunc5301, x64Parser::tokenBranches5301},
    {x64Token::REGISTERCLASS, 10, 0, 0, NULL, &x64Parser::TokenFunc5305, x64Parser::tokenBranches5305},
    {x64Token::EOT}};
void x64Parser::TokenFunc5313(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 445;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches5312[] = {{
                                               x64Token::NUMBER,
                                               3,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5313,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5311[] = {{x64Token::TOKEN, 11, 0, 1, NULL, NULL, x64Parser::tokenBranches5312}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5310[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5311}, {x64Token::EOT}};
void x64Parser::TokenFunc5317(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 446;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches5316[] = {{
                                               x64Token::NUMBER,
                                               4,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5317,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5315[] = {{x64Token::TOKEN, 8, 0, 1, NULL, NULL, x64Parser::tokenBranches5316}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5314[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5315}, {x64Token::EOT}};
void x64Parser::TokenFunc5321(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 447;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches5320[] = {{
                                               x64Token::NUMBER,
                                               5,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5321,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5319[] = {{x64Token::TOKEN, 9, 0, 1, NULL, NULL, x64Parser::tokenBranches5320}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5318[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5319}, {x64Token::EOT}};
void x64Parser::TokenFunc5325(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 448;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
}
x64Token x64Parser::tokenBranches5324[] = {{
                                               x64Token::NUMBER,
                                               5,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5325,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5323[] = {{x64Token::TOKEN, 10, 0, 1, NULL, NULL, x64Parser::tokenBranches5324}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5322[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5323}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5329_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5329_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5329_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5329_18[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 36, 0, 0, 0, '+'},
    {CODING_NAME("rm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 2, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5329(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5329_15;
    operand.values[16] = tokenCoding5329_16;
    operand.values[17] = tokenCoding5329_17;
    operand.values[18] = tokenCoding5329_18;
}
x64Token x64Parser::tokenBranches5328[] = {{
                                               x64Token::ADDRESSCLASS,
                                               3,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5329,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5327[] = {{x64Token::TOKEN, 11, 0, 1, NULL, NULL, x64Parser::tokenBranches5328}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5326[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5327}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5333_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5333_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5333_22[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::valSpecified), 64, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5333_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5333_18[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 36, 0, 0, 0, '+'},
    {CODING_NAME("rm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 2, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5333(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5333_15;
    operand.values[16] = tokenCoding5333_16;
    operand.values[22] = tokenCoding5333_22;
    operand.values[17] = tokenCoding5333_17;
    operand.values[18] = tokenCoding5333_18;
}
x64Token x64Parser::tokenBranches5332[] = {{
                                               x64Token::ADDRESSCLASS,
                                               3,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5333,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5331[] = {{x64Token::TOKEN, 11, 0, 1, NULL, NULL, x64Parser::tokenBranches5332}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5330[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5331}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5337_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5337_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5337_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5337_18[] = {
    {CODING_NAME("rm") Coding::stateFunc, 3},
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 36, 0, 0, 0, '+'},
    {CODING_NAME("rm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 3, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5337(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5337_15;
    operand.values[16] = tokenCoding5337_16;
    operand.values[17] = tokenCoding5337_17;
    operand.values[18] = tokenCoding5337_18;
}
x64Token x64Parser::tokenBranches5336[] = {{
                                               x64Token::ADDRESSCLASS,
                                               4,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5337,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5335[] = {{x64Token::TOKEN, 8, 0, 1, NULL, NULL, x64Parser::tokenBranches5336}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5334[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5335}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5341_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5341_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5341_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5341_18[] = {
    {CODING_NAME("rm") Coding::stateFunc, 4},
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 36, 0, 0, 0, '+'},
    {CODING_NAME("rm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 3, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5341(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5341_15;
    operand.values[16] = tokenCoding5341_16;
    operand.values[17] = tokenCoding5341_17;
    operand.values[18] = tokenCoding5341_18;
}
x64Token x64Parser::tokenBranches5340[] = {{
                                               x64Token::ADDRESSCLASS,
                                               5,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5341,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5339[] = {{x64Token::TOKEN, 9, 0, 1, NULL, NULL, x64Parser::tokenBranches5340}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5338[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5339}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5345_15[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5345_16[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5345_17[] = {
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5345_18[] = {
    {CODING_NAME("rm") Coding::stateFunc, 5},
    {CODING_NAME("rm")(Coding::Type)(Coding::indirect), 36, 0, 0, 0, '+'},
    {CODING_NAME("rm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 3, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5345(x64Operand& operand, int tokenPos)
{
    operand.values[15] = tokenCoding5345_15;
    operand.values[16] = tokenCoding5345_16;
    operand.values[17] = tokenCoding5345_17;
    operand.values[18] = tokenCoding5345_18;
}
x64Token x64Parser::tokenBranches5344[] = {{
                                               x64Token::ADDRESSCLASS,
                                               7,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5345,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5343[] = {{x64Token::TOKEN, 10, 0, 1, NULL, NULL, x64Parser::tokenBranches5344}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5342[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5343}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5349_15[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5349_16[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5349_17[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5349_18[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::bitSpecified | Coding::indirect), 36, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5349(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
    operand.values[15] = tokenCoding5349_15;
    operand.values[16] = tokenCoding5349_16;
    operand.values[17] = tokenCoding5349_17;
    operand.values[18] = tokenCoding5349_18;
}
Coding x64Parser::tokenCoding5353_15[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5353_16[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5353_22[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::valSpecified), 64, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5353_17[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5353_18[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::bitSpecified | Coding::indirect), 36, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5353(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
    operand.values[15] = tokenCoding5353_15;
    operand.values[16] = tokenCoding5353_16;
    operand.values[22] = tokenCoding5353_22;
    operand.values[17] = tokenCoding5353_17;
    operand.values[18] = tokenCoding5353_18;
}
x64Token x64Parser::tokenBranches5348[] = {{
                                               x64Token::REGISTERCLASS,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5349,
                                           },
                                           {
                                               x64Token::REGISTERCLASS,
                                               14,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5353,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5347[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5348}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5346[] = {{x64Token::ADDRESSCLASS, 3, 0, 0, NULL, NULL, x64Parser::tokenBranches5347},
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5357_15[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5357_16[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5357_17[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5357_18[] = {
    {CODING_NAME("modreg") Coding::stateFunc, 3},
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect), 36, 0, 0, 0, '+'},
    {CODING_NAME("modreg")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 1, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5357(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
    operand.values[15] = tokenCoding5357_15;
    operand.values[16] = tokenCoding5357_16;
    operand.values[17] = tokenCoding5357_17;
    operand.values[18] = tokenCoding5357_18;
}
x64Token x64Parser::tokenBranches5356[] = {{
                                               x64Token::REGISTERCLASS,
                                               4,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5357,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5355[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5356}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5354[] = {{x64Token::ADDRESSCLASS, 4, 0, 0, NULL, NULL, x64Parser::tokenBranches5355},
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5361_15[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5361_16[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5361_17[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5361_18[] = {
    {CODING_NAME("modreg") Coding::stateFunc, 4},
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect), 36, 0, 0, 0, '+'},
    {CODING_NAME("modreg")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 1, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5361(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
    operand.values[15] = tokenCoding5361_15;
    operand.values[16] = tokenCoding5361_16;
    operand.values[17] = tokenCoding5361_17;
    operand.values[18] = tokenCoding5361_18;
}
x64Token x64Parser::tokenBranches5360[] = {{
                                               x64Token::REGISTERCLASS,
                                               7,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5361,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5359[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5360}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5358[] = {{x64Token::ADDRESSCLASS, 5, 0, 0, NULL, NULL, x64Parser::tokenBranches5359},
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5365_15[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5365_16[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5365_17[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5365_18[] = {
    {CODING_NAME("modreg") Coding::stateFunc, 5},
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect), 36, 0, 0, 0, '+'},
    {CODING_NAME("modreg")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 1, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5365(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
    operand.values[15] = tokenCoding5365_15;
    operand.values[16] = tokenCoding5365_16;
    operand.values[17] = tokenCoding5365_17;
    operand.values[18] = tokenCoding5365_18;
}
x64Token x64Parser::tokenBranches5364[] = {{
                                               x64Token::REGISTERCLASS,
                                               10,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5365,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5363[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5364}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5362[] = {{x64Token::ADDRESSCLASS, 5, 0, 0, NULL, NULL, x64Parser::tokenBranches5363},
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5370_15[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5370_16[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5370_18[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 128, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5370(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 449;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5370_15;
    operand.values[16] = tokenCoding5370_16;
    operand.values[18] = tokenCoding5370_18;
}
x64Token x64Parser::tokenBranches5369[] = {{
                                               x64Token::NUMBER,
                                               3,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5370,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5368[] = {{x64Token::TOKEN, 11, 0, 1, NULL, NULL, x64Parser::tokenBranches5369}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5367[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5368}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5366[] = {{x64Token::ADDRESSCLASS, 3, 0, 0, NULL, NULL, x64Parser::tokenBranches5367},
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5375_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5375_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5375_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5375(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 450;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5375_15;
    operand.values[16] = tokenCoding5375_16;
    operand.values[18] = tokenCoding5375_18;
}
x64Token x64Parser::tokenBranches5374[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5375,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5380_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5380_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5380_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5380(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 450;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5380_15;
    operand.values[16] = tokenCoding5380_16;
    operand.values[18] = tokenCoding5380_18;
}
Coding x64Parser::tokenCoding5385_15[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5385_16[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5385_18[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 129, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5385(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 451;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5385_15;
    operand.values[16] = tokenCoding5385_16;
    operand.values[18] = tokenCoding5385_18;
}
x64Token x64Parser::tokenBranches5379[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5380,
                                           },
                                           {
                                               x64Token::NUMBER,
                                               4,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5385,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5373[] = {{x64Token::TOKEN, 11, 0, 1, NULL, NULL, x64Parser::tokenBranches5374},
                                           {x64Token::TOKEN, 8, 0, 1, NULL, NULL, x64Parser::tokenBranches5379},
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5372[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5373}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5371[] = {{x64Token::ADDRESSCLASS, 4, 0, 0, NULL, NULL, x64Parser::tokenBranches5372},
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5390_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5390_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5390_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5390(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 452;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5390_15;
    operand.values[16] = tokenCoding5390_16;
    operand.values[18] = tokenCoding5390_18;
}
x64Token x64Parser::tokenBranches5389[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5390,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5395_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5395_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5395_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5395(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 452;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5395_15;
    operand.values[16] = tokenCoding5395_16;
    operand.values[18] = tokenCoding5395_18;
}
x64Token x64Parser::tokenBranches5394[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5395,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5400_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5400_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5400_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5400(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 452;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5400_15;
    operand.values[16] = tokenCoding5400_16;
    operand.values[18] = tokenCoding5400_18;
}
Coding x64Parser::tokenCoding5405_15[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5405_16[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5405_18[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 129, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5405(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 453;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5405_15;
    operand.values[16] = tokenCoding5405_16;
    operand.values[18] = tokenCoding5405_18;
}
x64Token x64Parser::tokenBranches5399[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5400,
                                           },
                                           {
                                               x64Token::NUMBER,
                                               5,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5405,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5388[] = {{x64Token::TOKEN, 11, 0, 1, NULL, NULL, x64Parser::tokenBranches5389},
                                           {x64Token::TOKEN, 8, 0, 1, NULL, NULL, x64Parser::tokenBranches5394},
                                           {x64Token::TOKEN, 9, 0, 1, NULL, NULL, x64Parser::tokenBranches5399},
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5387[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5388}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5386[] = {{x64Token::ADDRESSCLASS, 5, 0, 0, NULL, NULL, x64Parser::tokenBranches5387},
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5410_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5410_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 8, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5410_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5410(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 452;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5410_15;
    operand.values[16] = tokenCoding5410_16;
    operand.values[18] = tokenCoding5410_18;
}
x64Token x64Parser::tokenBranches5409[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5410,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5415_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5415_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 8, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5415_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5415(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 452;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5415_15;
    operand.values[16] = tokenCoding5415_16;
    operand.values[18] = tokenCoding5415_18;
}
x64Token x64Parser::tokenBranches5414[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5415,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5420_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5420_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 8, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5420_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5420(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 452;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5420_15;
    operand.values[16] = tokenCoding5420_16;
    operand.values[18] = tokenCoding5420_18;
}
x64Token x64Parser::tokenBranches5419[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5420,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5425_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5425_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 8, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5425_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5425(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 452;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5425_15;
    operand.values[16] = tokenCoding5425_16;
    operand.values[18] = tokenCoding5425_18;
}
Coding x64Parser::tokenCoding5430_15[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5430_16[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5430_18[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 129, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5430(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 453;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5430_15;
    operand.values[16] = tokenCoding5430_16;
    operand.values[18] = tokenCoding5430_18;
}
x64Token x64Parser::tokenBranches5424[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5425,
                                           },
                                           {
                                               x64Token::NUMBER,
                                               5,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5430,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5408[] = {{x64Token::TOKEN, 11, 0, 1, NULL, NULL, x64Parser::tokenBranches5409},
                                           {x64Token::TOKEN, 8, 0, 1, NULL, NULL, x64Parser::tokenBranches5414},
                                           {x64Token::TOKEN, 9, 0, 1, NULL, NULL, x64Parser::tokenBranches5419},
                                           {x64Token::TOKEN, 10, 0, 1, NULL, NULL, x64Parser::tokenBranches5424},
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5407[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5408}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5406[] = {{x64Token::ADDRESSCLASS, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5407},
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5434_15[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5434_16[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5434_18[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 128, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5434(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 449;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5434_15;
    operand.values[16] = tokenCoding5434_16;
    operand.values[18] = tokenCoding5434_18;
}
x64Token x64Parser::tokenBranches5433[] = {{
                                               x64Token::NUMBER,
                                               3,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5434,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5432[] = {{x64Token::TOKEN, 11, 0, 1, NULL, NULL, x64Parser::tokenBranches5433}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5431[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5432}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5438_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5438_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5438_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5438(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 450;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5438_15;
    operand.values[16] = tokenCoding5438_16;
    operand.values[18] = tokenCoding5438_18;
}
x64Token x64Parser::tokenBranches5437[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5438,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5442_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5442_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5442_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5442(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 450;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5442_15;
    operand.values[16] = tokenCoding5442_16;
    operand.values[18] = tokenCoding5442_18;
}
Coding x64Parser::tokenCoding5446_15[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5446_16[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5446_18[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 129, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5446(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 451;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5446_15;
    operand.values[16] = tokenCoding5446_16;
    operand.values[18] = tokenCoding5446_18;
}
x64Token x64Parser::tokenBranches5441[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5442,
                                           },
                                           {
                                               x64Token::NUMBER,
                                               4,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5446,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5436[] = {{x64Token::TOKEN, 11, 0, 1, NULL, NULL, x64Parser::tokenBranches5437},
                                           {x64Token::TOKEN, 8, 0, 1, NULL, NULL, x64Parser::tokenBranches5441},
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5435[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5436}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5450_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5450_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5450_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5450(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 452;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5450_15;
    operand.values[16] = tokenCoding5450_16;
    operand.values[18] = tokenCoding5450_18;
}
x64Token x64Parser::tokenBranches5449[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5450,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5454_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5454_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5454_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5454(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 452;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5454_15;
    operand.values[16] = tokenCoding5454_16;
    operand.values[18] = tokenCoding5454_18;
}
x64Token x64Parser::tokenBranches5453[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5454,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5458_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5458_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5458_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5458(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 452;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5458_15;
    operand.values[16] = tokenCoding5458_16;
    operand.values[18] = tokenCoding5458_18;
}
Coding x64Parser::tokenCoding5462_15[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5462_16[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5462_18[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 129, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5462(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 453;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5462_15;
    operand.values[16] = tokenCoding5462_16;
    operand.values[18] = tokenCoding5462_18;
}
x64Token x64Parser::tokenBranches5457[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5458,
                                           },
                                           {
                                               x64Token::NUMBER,
                                               5,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5462,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5448[] = {{x64Token::TOKEN, 11, 0, 1, NULL, NULL, x64Parser::tokenBranches5449},
                                           {x64Token::TOKEN, 8, 0, 1, NULL, NULL, x64Parser::tokenBranches5453},
                                           {x64Token::TOKEN, 9, 0, 1, NULL, NULL, x64Parser::tokenBranches5457},
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5447[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5448}, {x64Token::EOT}};
Coding x64Parser::tokenCoding5466_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5466_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 8, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5466_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5466(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 454;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5466_15;
    operand.values[16] = tokenCoding5466_16;
    operand.values[18] = tokenCoding5466_18;
}
x64Token x64Parser::tokenBranches5465[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5466,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5470_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5470_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 8, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5470_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5470(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 454;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5470_15;
    operand.values[16] = tokenCoding5470_16;
    operand.values[18] = tokenCoding5470_18;
}
x64Token x64Parser::tokenBranches5469[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5470,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5474_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5474_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 8, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5474_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5474(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 454;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5474_15;
    operand.values[16] = tokenCoding5474_16;
    operand.values[18] = tokenCoding5474_18;
}
x64Token x64Parser::tokenBranches5473[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5474,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5478_15[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5478_16[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::valSpecified), 8, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5478_18[] = {
    {CODING_NAME("signedimm")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 131, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5478(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 454;
    operand.values[23] = new Coding[2];
    CleanupValues.push_back(operand.values[23]);
    operand.values[23]->type = Coding::number;
    operand.values[23]->val = operands.size();
    operand.values[23]->bits = 0;
    operand.values[23]->field = 0;
    operand.values[23]->unary = 0;
    operand.values[23]->binary = 0;
    operand.values[23][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5478_15;
    operand.values[16] = tokenCoding5478_16;
    operand.values[18] = tokenCoding5478_18;
}
Coding x64Parser::tokenCoding5482_15[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5482_16[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 8, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5482_18[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::bitSpecified | Coding::valSpecified), 129, 8, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5482(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 455;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5482_15;
    operand.values[16] = tokenCoding5482_16;
    operand.values[18] = tokenCoding5482_18;
}
x64Token x64Parser::tokenBranches5477[] = {{
                                               x64Token::NUMBER,
                                               1,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5478,
                                           },
                                           {
                                               x64Token::NUMBER,
                                               5,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5482,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5464[] = {{x64Token::TOKEN, 11, 0, 1, NULL, NULL, x64Parser::tokenBranches5465},
                                           {x64Token::TOKEN, 8, 0, 1, NULL, NULL, x64Parser::tokenBranches5469},
                                           {x64Token::TOKEN, 9, 0, 1, NULL, NULL, x64Parser::tokenBranches5473},
                                           {x64Token::TOKEN, 10, 0, 1, NULL, NULL, x64Parser::tokenBranches5477},
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5463[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5464}, {x64Token::EOT}};
void x64Parser::TokenFunc5326(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
}
void x64Parser::TokenFunc5330(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
}
void x64Parser::TokenFunc5334(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
}
void x64Parser::TokenFunc5338(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
}
void x64Parser::TokenFunc5342(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
}
x64Token x64Parser::tokenBranches5309[] = {
    {x64Token::REGISTER, 0, 0, 0, NULL, NULL, x64Parser::tokenBranches5310},
    {x64Token::REGISTER, 2, 0, 0, NULL, NULL, x64Parser::tokenBranches5314},
    {x64Token::REGISTER, 3, 0, 0, NULL, NULL, x64Parser::tokenBranches5318},
    {x64Token::REGISTER, 4, 0, 0, NULL, NULL, x64Parser::tokenBranches5322},
    {x64Token::REGISTERCLASS, 1, 0, 0, NULL, &x64Parser::TokenFunc5326, x64Parser::tokenBranches5326},
    {x64Token::REGISTERCLASS, 14, 0, 0, NULL, &x64Parser::TokenFunc5330, x64Parser::tokenBranches5330},
    {x64Token::REGISTERCLASS, 4, 0, 0, NULL, &x64Parser::TokenFunc5334, x64Parser::tokenBranches5334},
    {x64Token::REGISTERCLASS, 7, 0, 0, NULL, &x64Parser::TokenFunc5338, x64Parser::tokenBranches5338},
    {x64Token::REGISTERCLASS, 10, 0, 0, NULL, &x64Parser::TokenFunc5342, x64Parser::tokenBranches5342},
    {x64Token::TOKEN, 11, 0, 1, NULL, NULL, x64Parser::tokenBranches5346},
    {x64Token::TOKEN, 8, 0, 1, NULL, NULL, x64Parser::tokenBranches5354},
    {x64Token::TOKEN, 9, 0, 1, NULL, NULL, x64Parser::tokenBranches5358},
    {x64Token::TOKEN, 10, 0, 1, NULL, NULL, x64Parser::tokenBranches5362},
    {x64Token::TOKEN, 11, 0, 0, NULL, NULL, x64Parser::tokenBranches5366},
    {x64Token::TOKEN, 8, 0, 0, NULL, NULL, x64Parser::tokenBranches5371},
    {x64Token::TOKEN, 9, 0, 0, NULL, NULL, x64Parser::tokenBranches5386},
    {x64Token::TOKEN, 10, 0, 0, NULL, NULL, x64Parser::tokenBranches5406},
    {x64Token::ADDRESSCLASS, 14, 0, 0, NULL, NULL, x64Parser::tokenBranches5431},
    {x64Token::ADDRESSCLASS, 17, 0, 0, NULL, NULL, x64Parser::tokenBranches5435},
    {x64Token::ADDRESSCLASS, 19, 0, 0, NULL, NULL, x64Parser::tokenBranches5447},
    {x64Token::ADDRESSCLASS, 21, 0, 0, NULL, NULL, x64Parser::tokenBranches5463},
    {x64Token::EOT}};
Coding x64Parser::tokenCoding5488_15[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5488_16[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5488_18[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::indirect), 35, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5488(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 456;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5488_15;
    operand.values[16] = tokenCoding5488_16;
    operand.values[18] = tokenCoding5488_18;
}
x64Token x64Parser::tokenBranches5487[] = {{
                                               x64Token::NUMBER,
                                               3,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5488,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5502_15[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5502_16[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5502_17[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5502_18[] = {
    {CODING_NAME("modreg") Coding::stateFunc, 3},
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect), 36, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5502(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
    operand.values[15] = tokenCoding5502_15;
    operand.values[16] = tokenCoding5502_16;
    operand.values[17] = tokenCoding5502_17;
    operand.values[18] = tokenCoding5502_18;
}
x64Token x64Parser::tokenBranches5486[] = {{x64Token::TOKEN, 8, 0, 1, NULL, NULL, x64Parser::tokenBranches5487},
                                           {
                                               x64Token::REGISTERCLASS,
                                               4,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5502,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5485[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5486}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5484[] = {{x64Token::ADDRESSCLASS, 4, 0, 0, NULL, NULL, x64Parser::tokenBranches5485},
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5493_15[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5493_16[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::valSpecified), 0, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5493_18[] = {
    {CODING_NAME("omem")(Coding::Type)(Coding::indirect), 35, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5493(x64Operand& operand, int tokenPos)
{
    operand.operandCoding = 457;
    operand.values[21] = new Coding[2];
    CleanupValues.push_back(operand.values[21]);
    operand.values[21]->type = Coding::number;
    operand.values[21]->val = operands.size();
    operand.values[21]->bits = 0;
    operand.values[21]->field = 0;
    operand.values[21]->unary = 0;
    operand.values[21]->binary = 0;
    operand.values[21][1].type = Coding::eot;
    operands.push_back(numeric);
    operand.values[15] = tokenCoding5493_15;
    operand.values[16] = tokenCoding5493_16;
    operand.values[18] = tokenCoding5493_18;
}
x64Token x64Parser::tokenBranches5492[] = {{
                                               x64Token::NUMBER,
                                               3,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5493,
                                           },
                                           {x64Token::EOT}};
Coding x64Parser::tokenCoding5506_15[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 2, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5506_16[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 3, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5506_17[] = {
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect | Coding::fieldSpecified), 19, 0, 1, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
Coding x64Parser::tokenCoding5506_18[] = {
    {CODING_NAME("modreg") Coding::stateFunc, 4},
    {CODING_NAME("modreg")(Coding::Type)(Coding::indirect), 36, 0, 0, 0, 0},
    {CODING_NAME("eot") Coding::eot},
};
void x64Parser::TokenFunc5506(x64Operand& operand, int tokenPos)
{
    operand.values[19] = new Coding[2];
    CleanupValues.push_back(operand.values[19]);
    operand.values[19]->type = Coding::reg;
    operand.values[19]->val = inputTokens[tokenPos]->val->ival;
    operand.values[19]->bits = 0;
    operand.values[19]->field = 0;
    operand.values[19]->unary = 0;
    operand.values[19]->binary = 0;
    operand.values[19][1].type = Coding::eot;
    operand.values[15] = tokenCoding5506_15;
    operand.values[16] = tokenCoding5506_16;
    operand.values[17] = tokenCoding5506_17;
    operand.values[18] = tokenCoding5506_18;
}
x64Token x64Parser::tokenBranches5491[] = {{x64Token::TOKEN, 9, 0, 1, NULL, NULL, x64Parser::tokenBranches5492},
                                           {
                                               x64Token::REGISTERCLASS,
                                               7,
                                               1,
                                               0,
                                               NULL,
                                               &x64Parser::TokenFunc5506,
                                           },
                                           {x64Token::EOT}};
x64Token x64Parser::tokenBranches5490[] = {{x64Token::TOKEN, 7, 0, 0, NULL, NULL, x64Parser::tokenBranches5491}, {x64Token::EOT}};
x64Token x64Parser::tokenBranches5489[] = {{x64Token::ADDRESSCLASS, 5, 0, 0, NULL, NULL,