#!/bin/sh
#
# Copyright (c) 2023 TK Chia
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#   * Redistributions of source code must retain the above copyright notice,
#     this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the developer(s) nor the names of its contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
# IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# Create a header file <FOO.h> (for some FOO) which hands over to
# <libi86/FOO.h>, for cases where the underlying ACK toolchain lacks <FOO.h>.

set -e

if [ $# != 1 ]; then
  echo "usage: `basename "$0"` (hdr)" >&2
  exit 1
fi

hdr="$1"
cap_hdr="`echo "$hdr" \
	  | tr abcdefghijklmnopqrstuvwxyz- ABCDEFGHIJKLMNOPQRSTUVWXYZ_ \
	  | tr -d -c ABCDEFGHIJKLMNOPQRSTUVWXYZ_`"

cat <<FIN
/* Automatically generated by `basename "$0"` on `TZ=UTC0 date +%Y%m%d`. */

#ifndef _LIBI86_${cap_hdr}_H_
#define _LIBI86_${cap_hdr}_H_
#ifdef _LIBI86_CONFIGURING_
# error
#endif
#ifndef __STRICT_ANSI__
# include <libi86/$hdr.h>
#endif
#endif
FIN
