BEGIN {
	print "// This file is automatically generated from syscall.dat";
	print "// See syscall.awk for details\n";
	print "\t.code16\n";
	print "\t.text\n";
	print "\t.extern _syscall_0";
	print "\t.extern _syscall_1";
	print "\t.extern _syscall_2";
	print "\t.extern _syscall_2p";
	print "\t.extern _syscall_3";
	print "\t.extern _syscall_4";
	print "\t.extern _syscall_5\n";
}
/^[	 ]*#/ { next; }
/^[	 ]*$/ { next; }
{
	callno = $2;
	if (!(callno in calltab))
		callwas [callno] = $1;

	if ($3 == "x" || $3 == "") next;
	else if ($4 == "@" || $4 == "-") next;
	else if ($4 == "*") funcname = "_" $1;
	else funcname = $1;

	if (callno > max_call) max_call = callno;
	calltab [callno] = $1;
	
	printf ("// CALL %s \n\n", $0);
	printf ("\t.global %s\n\n", funcname);
	printf ("%s:\n", funcname);
	printf ("\tmov $%d,%%ax\n", callno);
	if ($4 != "!" || $3 < 1) printf ("\tjmp _syscall_%d\n\n", $3);
	else printf ("\tjmp _syscall_%dp\n\n", $3 - 1);
}
END {
	for (i = 0; i <= max_call; i++)
		if (i in calltab) {
			printf ("#ifndef sys_%s\n", calltab [i]) > "defn_tab.v";
			printf ("#define sys_%s sys_enosys\n", calltab [i]) > "defn_tab.v";
			printf ("#endif\n\n") > "defn_tab.v";
			
			printf ("/* %3d */  sys_%s,\n", i, calltab [i]) > "call_tab.v";
		}
		else
			printf("/* %3d */  sys_enosys, /* %s */\n", i, callwas [i]) > "call_tab.v";
}