''
''
'' wininet -- header translated with help of SWIG FB wrapper
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#ifndef __win_wininet_bi__
#define __win_wininet_bi__

#include once "windows.bi"

#inclib "wininet"

#define INTERNET_INVALID_PORT_NUMBER 0
#define INTERNET_DEFAULT_FTP_PORT 21
#define INTERNET_DEFAULT_GOPHER_PORT 70
#define INTERNET_DEFAULT_HTTP_PORT 80
#define INTERNET_DEFAULT_HTTPS_PORT 443
#define INTERNET_DEFAULT_SOCKS_PORT 1080
#define MAX_CACHE_ENTRY_INFO_SIZE 4096
#define INTERNET_MAX_HOST_NAME_LENGTH 256
#define INTERNET_MAX_USER_NAME_LENGTH 128
#define INTERNET_MAX_PASSWORD_LENGTH 128
#define INTERNET_MAX_PORT_NUMBER_LENGTH 5
#define INTERNET_MAX_PORT_NUMBER_VALUE 65535
#define INTERNET_MAX_PATH_LENGTH 2048
#define INTERNET_MAX_SCHEME_LENGTH 32
#define INTERNET_MAX_URL_LENGTH (INTERNET_MAX_SCHEME_LENGTH+sizeof("://")+INTERNET_MAX_PATH_LENGTH)
#define INTERNET_KEEP_ALIVE_UNKNOWN cuint(-1)
#define INTERNET_KEEP_ALIVE_ENABLED 1
#define INTERNET_KEEP_ALIVE_DISABLED 0
#define INTERNET_REQFLAG_FROM_CACHE 1
#define INTERNET_REQFLAG_ASYNC 2
#define INTERNET_FLAG_RELOAD &h80000000
#define INTERNET_FLAG_RAW_DATA &h40000000
#define INTERNET_FLAG_EXISTING_CONNECT &h20000000
#define INTERNET_FLAG_ASYNC &h10000000
#define INTERNET_FLAG_PASSIVE &h08000000
#define INTERNET_FLAG_NO_CACHE_WRITE &h04000000
#define INTERNET_FLAG_DONT_CACHE &h04000000
#define INTERNET_FLAG_MAKE_PERSISTENT &h02000000
#define INTERNET_FLAG_OFFLINE &h1000000
#define INTERNET_FLAG_SECURE &h800000
#define INTERNET_FLAG_KEEP_CONNECTION &h400000
#define INTERNET_FLAG_NO_AUTO_REDIRECT &h200000
#define INTERNET_FLAG_READ_PREFETCH &h100000
#define INTERNET_FLAG_NO_COOKIES &h80000
#define INTERNET_FLAG_NO_AUTH &h40000
#define INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP &h8000
#define INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS &h4000
#define INTERNET_FLAG_IGNORE_CERT_DATE_INVALID &h2000
#define INTERNET_FLAG_IGNORE_CERT_CN_INVALID &h1000
#define INTERNET_FLAG_MUST_CACHE_REQUEST 16
#define INTERNET_FLAG_RESYNCHRONIZE &h800
#define INTERNET_FLAG_HYPERLINK &h400
#define INTERNET_FLAG_NO_UI &h200
#define INTERNET_FLAG_PRAGMA_NOCACHE &h100
#define SECURITY_INTERNET_MASK (&h1000 or &h2000 or &h4000 or &h8000)
#define SECURITY_SET_MASK (&h1000 or &h2000 or &h4000 or &h8000)
#define INTERNET_FLAGS_MASK (INTERNET_FLAG_RELOAD or INTERNET_FLAG_RAW_DATA or INTERNET_FLAG_EXISTING_CONNECT or INTERNET_FLAG_ASYNC or INTERNET_FLAG_PASSIVE or INTERNET_FLAG_NO_CACHE_WRITE or INTERNET_FLAG_MAKE_PERSISTENT or INTERNET_FLAG_OFFLINE or INTERNET_FLAG_SECURE or INTERNET_FLAG_KEEP_CONNECTION or INTERNET_FLAG_NO_AUTO_REDIRECT or INTERNET_FLAG_READ_PREFETCH or INTERNET_FLAG_NO_COOKIES or INTERNET_FLAG_NO_AUTH or SECURITY_INTERNET_MASK or INTERNET_FLAG_TRANSFER_ASCII or INTERNET_FLAG_TRANSFER_BINARY or INTERNET_FLAG_RESYNCHRONIZE or INTERNET_FLAG_MUST_CACHE_REQUEST or INTERNET_FLAG_HYPERLINK or INTERNET_FLAG_NO_UI)
#define INTERNET_OPTIONS_MASK (not INTERNET_FLAGS_MASK)
#define INTERNET_NO_CALLBACK 0
#define INTERNET_RFC1123_FORMAT 0
#define INTERNET_RFC1123_BUFSIZE 30
#define ICU_ESCAPE &h80000000
#define ICU_USERNAME &h40000000
#define ICU_NO_ENCODE &h20000000
#define ICU_DECODE &h10000000
#define ICU_NO_META &h08000000
#define ICU_ENCODE_SPACES_ONLY &h04000000
#define ICU_BROWSER_MODE &h02000000
#define INTERNET_OPEN_TYPE_PRECONFIG 0
#define INTERNET_OPEN_TYPE_DIRECT 1
#define INTERNET_OPEN_TYPE_PROXY 3
#define PRE_CONFIG_INTERNET_ACCESS 0
#define LOCAL_INTERNET_ACCESS 1
#define GATEWAY_INTERNET_ACCESS 2
#define CERN_PROXY_INTERNET_ACCESS 3
#define ISO_GLOBAL 1
#define ISO_REGISTRY 2
#define ISO_VALID_FLAGS (1 or 2)
#define INTERNET_OPTION_CALLBACK 1
#define INTERNET_OPTION_CONNECT_TIMEOUT 2
#define INTERNET_OPTION_CONNECT_RETRIES 3
#define INTERNET_OPTION_CONNECT_BACKOFF 4
#define INTERNET_OPTION_SEND_TIMEOUT 5
#define INTERNET_OPTION_CONTROL_SEND_TIMEOUT 5
#define INTERNET_OPTION_RECEIVE_TIMEOUT 6
#define INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT 6
#define INTERNET_OPTION_DATA_SEND_TIMEOUT 7
#define INTERNET_OPTION_DATA_RECEIVE_TIMEOUT 8
#define INTERNET_OPTION_HANDLE_TYPE 9
#define INTERNET_OPTION_CONTEXT_VALUE 10
#define INTERNET_OPTION_LISTEN_TIMEOUT 11
#define INTERNET_OPTION_READ_BUFFER_SIZE 12
#define INTERNET_OPTION_WRITE_BUFFER_SIZE 13
#define INTERNET_OPTION_ASYNC_ID 15
#define INTERNET_OPTION_ASYNC_PRIORITY 16
#define INTERNET_OPTION_PARENT_HANDLE 21
#define INTERNET_OPTION_KEEP_CONNECTION 22
#define INTERNET_OPTION_REQUEST_FLAGS 23
#define INTERNET_OPTION_EXTENDED_ERROR 24
#define INTERNET_OPTION_OFFLINE_MODE 26
#define INTERNET_OPTION_CACHE_STREAM_HANDLE 27
#define INTERNET_OPTION_USERNAME 28
#define INTERNET_OPTION_PASSWORD 29
#define INTERNET_OPTION_ASYNC 30
#define INTERNET_OPTION_SECURITY_FLAGS 31
#define INTERNET_OPTION_SECURITY_CERTIFICATE_STRUCT 32
#define INTERNET_OPTION_DATAFILE_NAME 33
#define INTERNET_OPTION_URL 34
#define INTERNET_OPTION_SECURITY_CERTIFICATE 35
#define INTERNET_OPTION_SECURITY_KEY_BITNESS 36
#define INTERNET_OPTION_REFRESH 37
#define INTERNET_OPTION_PROXY 38
#define INTERNET_OPTION_SETTINGS_CHANGED 39
#define INTERNET_OPTION_VERSION 40
#define INTERNET_OPTION_USER_AGENT 41
#define INTERNET_OPTION_END_BROWSER_SESSION 42
#define INTERNET_OPTION_PROXY_USERNAME 43
#define INTERNET_OPTION_PROXY_PASSWORD 44
#define INTERNET_FIRST_OPTION 1
#define INTERNET_LAST_OPTION 41
#define INTERNET_PRIORITY_FOREGROUND 1000
#define INTERNET_HANDLE_TYPE_INTERNET 1
#define INTERNET_HANDLE_TYPE_CONNECT_FTP 2
#define INTERNET_HANDLE_TYPE_CONNECT_GOPHER 3
#define INTERNET_HANDLE_TYPE_CONNECT_HTTP 4
#define INTERNET_HANDLE_TYPE_FTP_FIND 5
#define INTERNET_HANDLE_TYPE_FTP_FIND_HTML 6
#define INTERNET_HANDLE_TYPE_FTP_FILE 7
#define INTERNET_HANDLE_TYPE_FTP_FILE_HTML 8
#define INTERNET_HANDLE_TYPE_GOPHER_FIND 9
#define INTERNET_HANDLE_TYPE_GOPHER_FIND_HTML 10
#define INTERNET_HANDLE_TYPE_GOPHER_FILE 11
#define INTERNET_HANDLE_TYPE_GOPHER_FILE_HTML 12
#define INTERNET_HANDLE_TYPE_HTTP_REQUEST 13
#define SECURITY_FLAG_SECURE 1
#define SECURITY_FLAG_SSL 2
#define SECURITY_FLAG_SSL3 4
#define SECURITY_FLAG_PCT 8
#define SECURITY_FLAG_PCT4 16
#define SECURITY_FLAG_IETFSSL4 &h20
#define SECURITY_FLAG_IGNORE_REVOCATION &h00000080
#define SECURITY_FLAG_IGNORE_UNKNOWN_CA &h00000100
#define SECURITY_FLAG_IGNORE_WRONG_USAGE &h00000200
#define SECURITY_FLAG_40BIT &h10000000
#define SECURITY_FLAG_128BIT &h20000000
#define SECURITY_FLAG_56BIT &h40000000
#define SECURITY_FLAG_UNKNOWNBIT &h80000000
#define SECURITY_FLAG_NORMALBITNESS &h10000000
#define SECURITY_FLAG_IGNORE_CERT_CN_INVALID &h1000
#define SECURITY_FLAG_IGNORE_CERT_DATE_INVALID &h2000
#define SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTPS &h4000
#define SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTP &h8000
#define INTERNET_SERVICE_FTP 1
#define INTERNET_SERVICE_GOPHER 2
#define INTERNET_SERVICE_HTTP 3
#define INTERNET_STATUS_RESOLVING_NAME 10
#define INTERNET_STATUS_NAME_RESOLVED 11
#define INTERNET_STATUS_CONNECTING_TO_SERVER 20
#define INTERNET_STATUS_CONNECTED_TO_SERVER 21
#define INTERNET_STATUS_SENDING_REQUEST 30
#define INTERNET_STATUS_REQUEST_SENT 31
#define INTERNET_STATUS_RECEIVING_RESPONSE 40
#define INTERNET_STATUS_RESPONSE_RECEIVED 41
#define INTERNET_STATUS_CTL_RESPONSE_RECEIVED 42
#define INTERNET_STATUS_PREFETCH 43
#define INTERNET_STATUS_CLOSING_CONNECTION 50
#define INTERNET_STATUS_CONNECTION_CLOSED 51
#define INTERNET_STATUS_HANDLE_CREATED 60
#define INTERNET_STATUS_HANDLE_CLOSING 70
#define INTERNET_STATUS_REQUEST_COMPLETE 100
#define INTERNET_STATUS_REDIRECT 110
#define INTERNET_INVALID_STATUS_CALLBACK cptr(INTERNET_STATUS_CALLBACK,-1L)
#define FTP_TRANSFER_TYPE_UNKNOWN 0
#define FTP_TRANSFER_TYPE_ASCII 1
#define FTP_TRANSFER_TYPE_BINARY 2
#define FTP_TRANSFER_TYPE_MASK (1 or 2)
#define MAX_GOPHER_DISPLAY_TEXT 128
#define MAX_GOPHER_SELECTOR_TEXT 256
#define MAX_GOPHER_HOST_NAME 256
#define MAX_GOPHER_LOCATOR_LENGTH (1+128+1+256+1+256+1+5+1+1+2)
#define GOPHER_TYPE_TEXT_FILE 1
#define GOPHER_TYPE_DIRECTORY 2
#define GOPHER_TYPE_CSO 4
#define GOPHER_TYPE_ERROR 8
#define GOPHER_TYPE_MAC_BINHEX 16
#define GOPHER_TYPE_DOS_ARCHIVE 32
#define GOPHER_TYPE_UNIX_UUENCODED 64
#define GOPHER_TYPE_INDEX_SERVER 128
#define GOPHER_TYPE_TELNET 256
#define GOPHER_TYPE_BINARY 512
#define GOPHER_TYPE_REDUNDANT 1024
#define GOPHER_TYPE_TN3270 &h800
#define GOPHER_TYPE_GIF &h1000
#define GOPHER_TYPE_IMAGE &h2000
#define GOPHER_TYPE_BITMAP &h4000
#define GOPHER_TYPE_MOVIE &h8000
#define GOPHER_TYPE_SOUND &h10000
#define GOPHER_TYPE_HTML &h20000
#define GOPHER_TYPE_PDF &h40000
#define GOPHER_TYPE_CALENDAR &h80000
#define GOPHER_TYPE_INLINE &h100000
#define GOPHER_TYPE_UNKNOWN &h20000000
#define GOPHER_TYPE_ASK &h40000000
#define GOPHER_TYPE_GOPHER_PLUS &h80000000
#define IS_GOPHER_FILE(t) iif(t and GOPHER_TYPE_FILE_MASK, TRUE, FALSE)
#define IS_GOPHER_DIRECTORYt iif(t and GOPHER_TYPE_DIRECTORY, TRUE, FALSE)
#define IS_GOPHER_PHONE_SERVERt iif(t and GOPHER_TYPE_CSO, TRUE, FALSE)
#define IS_GOPHER_ERRORt iif(t and GOPHER_TYPE_ERROR, TRUE, FALSE)
#define IS_GOPHER_INDEX_SERVERt iif(t and GOPHER_TYPE_INDEX_SERVER, TRUE, FALSE)
#define IS_GOPHER_TELNET_SESSIONt iif(t and GOPHER_TYPE_TELNET, TRUE, FALSE)
#define IS_GOPHER_BACKUP_SERVERt iif(t and GOPHER_TYPE_REDUNDANT, TRUE, FALSE)
#define IS_GOPHER_TN3270_SESSIONt iif(t and GOPHER_TYPE_TN3270, TRUE, FALSE)
#define IS_GOPHER_ASKt iif(t and GOPHER_TYPE_ASK, TRUE, FALSE)
#define IS_GOPHER_PLUSt iif(t and GOPHER_TYPE_GOPHER_PLUS, TRUE, FALSE)
#define IS_GOPHER_TYPE_KNOWNt iif(t and GOPHER_TYPE_UNKNOWN, FALSE, TRUE)
#define GOPHER_TYPE_FILE_MASK (1 or 16 or 32 or 64 or 512 or &h1000 or &h2000 or &h4000 or &h8000 or &h10000 or &h20000 or &h40000 or &h80000 or &h100000)
#define MAX_GOPHER_CATEGORY_NAME 128
#define MAX_GOPHER_ATTRIBUTE_NAME 128
#define MIN_GOPHER_ATTRIBUTE_LENGTH 256
#define GOPHER_INFO_CATEGORY "+INFO"
#define GOPHER_ADMIN_CATEGORY "+ADMIN"
#define GOPHER_VIEWS_CATEGORY "+VIEWS"
#define GOPHER_ABSTRACT_CATEGORY "+ABSTRACT"
#define GOPHER_VERONICA_CATEGORY "+VERONICA"
#define GOPHER_ADMIN_ATTRIBUTE "Admin"
#define GOPHER_MOD_DATE_ATTRIBUTE "Mod-Date"
#define GOPHER_TTL_ATTRIBUTE "TTL"
#define GOPHER_SCORE_ATTRIBUTE "Score"
#define GOPHER_RANGE_ATTRIBUTE "Score-range"
#define GOPHER_SITE_ATTRIBUTE "Site"
#define GOPHER_ORG_ATTRIBUTE "Org"
#define GOPHER_LOCATION_ATTRIBUTE "Loc"
#define GOPHER_GEOG_ATTRIBUTE "Geog"
#define GOPHER_TIMEZONE_ATTRIBUTE "TZ"
#define GOPHER_PROVIDER_ATTRIBUTE "Provider"
#define GOPHER_VERSION_ATTRIBUTE "Version"
#define GOPHER_ABSTRACT_ATTRIBUTE "Abstract"
#define GOPHER_VIEW_ATTRIBUTE "View"
#define GOPHER_TREEWALK_ATTRIBUTE "treewalk"
#define GOPHER_ATTRIBUTE_ID_BASE &habcccc00
#define GOPHER_CATEGORY_ID_ALL (&habcccc00+1)
#define GOPHER_CATEGORY_ID_INFO (&habcccc00+2)
#define GOPHER_CATEGORY_ID_ADMIN (&habcccc00+3)
#define GOPHER_CATEGORY_ID_VIEWS (&habcccc00+4)
#define GOPHER_CATEGORY_ID_ABSTRACT (&habcccc00+5)
#define GOPHER_CATEGORY_ID_VERONICA (&habcccc00+6)
#define GOPHER_CATEGORY_ID_ASK (&habcccc00+7)
#define GOPHER_CATEGORY_ID_UNKNOWN (&habcccc00+8)
#define GOPHER_ATTRIBUTE_ID_ALL (&habcccc00+9)
#define GOPHER_ATTRIBUTE_ID_ADMIN (&habcccc00+10)
#define GOPHER_ATTRIBUTE_ID_MOD_DATE (&habcccc00+11)
#define GOPHER_ATTRIBUTE_ID_TTL (&habcccc00+12)
#define GOPHER_ATTRIBUTE_ID_SCORE (&habcccc00+13)
#define GOPHER_ATTRIBUTE_ID_RANGE (&habcccc00+14)
#define GOPHER_ATTRIBUTE_ID_SITE (&habcccc00+15)
#define GOPHER_ATTRIBUTE_ID_ORG (&habcccc00+16)
#define GOPHER_ATTRIBUTE_ID_LOCATION (&habcccc00+17)
#define GOPHER_ATTRIBUTE_ID_GEOG (&habcccc00+18)
#define GOPHER_ATTRIBUTE_ID_TIMEZONE (&habcccc00+19)
#define GOPHER_ATTRIBUTE_ID_PROVIDER (&habcccc00+20)
#define GOPHER_ATTRIBUTE_ID_VERSION (&habcccc00+21)
#define GOPHER_ATTRIBUTE_ID_ABSTRACT (&habcccc00+22)
#define GOPHER_ATTRIBUTE_ID_VIEW (&habcccc00+23)
#define GOPHER_ATTRIBUTE_ID_TREEWALK (&habcccc00+24)
#define GOPHER_ATTRIBUTE_ID_UNKNOWN (&habcccc00+25)
#define HTTP_MAJOR_VERSION 1
#define HTTP_MINOR_VERSION 0
#define HTTP_VERSION "HTTP/1.0"
#define HTTP_QUERY_MIME_VERSION 0
#define HTTP_QUERY_CONTENT_TYPE 1
#define HTTP_QUERY_CONTENT_TRANSFER_ENCODING 2
#define HTTP_QUERY_CONTENT_ID 3
#define HTTP_QUERY_CONTENT_DESCRIPTION 4
#define HTTP_QUERY_CONTENT_LENGTH 5
#define HTTP_QUERY_CONTENT_LANGUAGE 6
#define HTTP_QUERY_ALLOW 7
#define HTTP_QUERY_PUBLIC 8
#define HTTP_QUERY_DATE 9
#define HTTP_QUERY_EXPIRES 10
#define HTTP_QUERY_LAST_MODIFIED 11
#define HTTP_QUERY_MESSAGE_ID 12
#define HTTP_QUERY_URI 13
#define HTTP_QUERY_DERIVED_FROM 14
#define HTTP_QUERY_COST 15
#define HTTP_QUERY_LINK 16
#define HTTP_QUERY_PRAGMA 17
#define HTTP_QUERY_VERSION 18
#define HTTP_QUERY_STATUS_CODE 19
#define HTTP_QUERY_STATUS_TEXT 20
#define HTTP_QUERY_RAW_HEADERS 21
#define HTTP_QUERY_RAW_HEADERS_CRLF 22
#define HTTP_QUERY_CONNECTION 23
#define HTTP_QUERY_ACCEPT 24
#define HTTP_QUERY_ACCEPT_CHARSET 25
#define HTTP_QUERY_ACCEPT_ENCODING 26
#define HTTP_QUERY_ACCEPT_LANGUAGE 27
#define HTTP_QUERY_AUTHORIZATION 28
#define HTTP_QUERY_CONTENT_ENCODING 29
#define HTTP_QUERY_FORWARDED 30
#define HTTP_QUERY_FROM 31
#define HTTP_QUERY_IF_MODIFIED_SINCE 32
#define HTTP_QUERY_LOCATION 33
#define HTTP_QUERY_ORIG_URI 34
#define HTTP_QUERY_REFERER 35
#define HTTP_QUERY_RETRY_AFTER 36
#define HTTP_QUERY_SERVER 37
#define HTTP_QUERY_TITLE 38
#define HTTP_QUERY_USER_AGENT 39
#define HTTP_QUERY_WWW_AUTHENTICATE 40
#define HTTP_QUERY_PROXY_AUTHENTICATE 41
#define HTTP_QUERY_ACCEPT_RANGES 42
#define HTTP_QUERY_SET_COOKIE 43
#define HTTP_QUERY_COOKIE 44
#define HTTP_QUERY_REQUEST_METHOD 45
#define HTTP_QUERY_MAX 45
#define HTTP_QUERY_CUSTOM 65535
#define HTTP_QUERY_FLAG_REQUEST_HEADERS &h80000000
#define HTTP_QUERY_FLAG_SYSTEMTIME &h40000000
#define HTTP_QUERY_FLAG_NUMBER &h20000000
#define HTTP_QUERY_FLAG_COALESCE &h10000000
#define HTTP_QUERY_MODIFIER_FLAGS_MASK (&h80000000 or &h40000000 or &h20000000 or &h10000000)
#define HTTP_QUERY_HEADER_MASK ( not HTTP_QUERY_MODIFIER_FLAGS_MASK)
#define HTTP_STATUS_OK 200
#define HTTP_STATUS_CREATED 201
#define HTTP_STATUS_ACCEPTED 202
#define HTTP_STATUS_PARTIAL 203
#define HTTP_STATUS_NO_CONTENT 204
#define HTTP_STATUS_AMBIGUOUS 300
#define HTTP_STATUS_MOVED 301
#define HTTP_STATUS_REDIRECT 302
#define HTTP_STATUS_REDIRECT_METHOD 303
#define HTTP_STATUS_NOT_MODIFIED 304
#define HTTP_STATUS_BAD_REQUEST 400
#define HTTP_STATUS_DENIED 401
#define HTTP_STATUS_PAYMENT_REQ 402
#define HTTP_STATUS_FORBIDDEN 403
#define HTTP_STATUS_NOT_FOUND 404
#define HTTP_STATUS_BAD_METHOD 405
#define HTTP_STATUS_NONE_ACCEPTABLE 406
#define HTTP_STATUS_PROXY_AUTH_REQ 407
#define HTTP_STATUS_REQUEST_TIMEOUT 408
#define HTTP_STATUS_CONFLICT 409
#define HTTP_STATUS_GONE 410
#define HTTP_STATUS_AUTH_REFUSED 411
#define HTTP_STATUS_SERVER_ERROR 500
#define HTTP_STATUS_NOT_SUPPORTED 501
#define HTTP_STATUS_BAD_GATEWAY 502
#define HTTP_STATUS_SERVICE_UNAVAIL 503
#define HTTP_STATUS_GATEWAY_TIMEOUT 504
#define INTERNET_PREFETCH_PROGRESS 0
#define INTERNET_PREFETCH_COMPLETE 1
#define INTERNET_PREFETCH_ABORTED 2
#define FLAGS_ERROR_UI_FILTER_FOR_ERRORS &h01
#define FLAGS_ERROR_UI_FLAGS_CHANGE_OPTIONS &h02
#define FLAGS_ERROR_UI_FLAGS_GENERATE_DATA &h04
#define FLAGS_ERROR_UI_FLAGS_NO_UI &h08
#define HTTP_ADDREQ_INDEX_MASK &h0000FFFF
#define HTTP_ADDREQ_FLAGS_MASK &hFFFF0000
#define HTTP_ADDREQ_FLAG_ADD_IF_NEW &h10000000
#define HTTP_ADDREQ_FLAG_ADD &h20000000
#define HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA &h40000000
#define HTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON &h01000000
#define HTTP_ADDREQ_FLAG_COALESCE &h40000000
#define HTTP_ADDREQ_FLAG_REPLACE &h80000000
#define INTERNET_ERROR_BASE 12000
#define ERROR_INTERNET_OUT_OF_HANDLES (12000+1)
#define ERROR_INTERNET_TIMEOUT (12000+2)
#define ERROR_INTERNET_EXTENDED_ERROR (12000+3)
#define ERROR_INTERNET_INTERNAL_ERROR (12000+4)
#define ERROR_INTERNET_INVALID_URL (12000+5)
#define ERROR_INTERNET_UNRECOGNIZED_SCHEME (12000+6)
#define ERROR_INTERNET_NAME_NOT_RESOLVED (12000+7)
#define ERROR_INTERNET_PROTOCOL_NOT_FOUND (12000+8)
#define ERROR_INTERNET_INVALID_OPTION (12000+9)
#define ERROR_INTERNET_BAD_OPTION_LENGTH (12000+10)
#define ERROR_INTERNET_OPTION_NOT_SETTABLE (12000+11)
#define ERROR_INTERNET_SHUTDOWN (12000+12)
#define ERROR_INTERNET_INCORRECT_USER_NAME (12000+13)
#define ERROR_INTERNET_INCORRECT_PASSWORD (12000+14)
#define ERROR_INTERNET_LOGIN_FAILURE (12000+15)
#define ERROR_INTERNET_INVALID_OPERATION (12000+16)
#define ERROR_INTERNET_OPERATION_CANCELLED (12000+17)
#define ERROR_INTERNET_INCORRECT_HANDLE_TYPE (12000+18)
#define ERROR_INTERNET_INCORRECT_HANDLE_STATE (12000+19)
#define ERROR_INTERNET_NOT_PROXY_REQUEST (12000+20)
#define ERROR_INTERNET_REGISTRY_VALUE_NOT_FOUND (12000+21)
#define ERROR_INTERNET_BAD_REGISTRY_PARAMETER (12000+22)
#define ERROR_INTERNET_NO_DIRECT_ACCESS (12000+23)
#define ERROR_INTERNET_NO_CONTEXT (12000+24)
#define ERROR_INTERNET_NO_CALLBACK (12000+25)
#define ERROR_INTERNET_REQUEST_PENDING (12000+26)
#define ERROR_INTERNET_INCORRECT_FORMAT (12000+27)
#define ERROR_INTERNET_ITEM_NOT_FOUND (12000+28)
#define ERROR_INTERNET_CANNOT_CONNECT (12000+29)
#define ERROR_INTERNET_CONNECTION_ABORTED (12000+30)
#define ERROR_INTERNET_CONNECTION_RESET (12000+31)
#define ERROR_INTERNET_FORCE_RETRY (12000+32)
#define ERROR_INTERNET_INVALID_PROXY_REQUEST (12000+33)
#define ERROR_INTERNET_NEED_UI (12000+34)
#define ERROR_INTERNET_HANDLE_EXISTS (12000+36)
#define ERROR_INTERNET_SEC_CERT_DATE_INVALID (12000+37)
#define ERROR_INTERNET_SEC_CERT_CN_INVALID (12000+38)
#define ERROR_INTERNET_HTTP_TO_HTTPS_ON_REDIR (12000+39)
#define ERROR_INTERNET_HTTPS_TO_HTTP_ON_REDIR (12000+40)
#define ERROR_INTERNET_MIXED_SECURITY (12000+41)
#define ERROR_INTERNET_CHG_POST_IS_NON_SECURE (12000+42)
#define ERROR_INTERNET_POST_IS_NON_SECURE (12000+43)
#define ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED (12000+44)
#define ERROR_INTERNET_INVALID_CA (12000+45)
#define ERROR_INTERNET_CLIENT_AUTH_NOT_SETUP (12000+46)
#define ERROR_INTERNET_ASYNC_THREAD_FAILED (12000+47)
#define ERROR_INTERNET_REDIRECT_SCHEME_CHANGE (12000+48)
#define ERROR_FTP_TRANSFER_IN_PROGRESS (12000+110)
#define ERROR_FTP_DROPPED (12000+111)
#define ERROR_GOPHER_PROTOCOL_ERROR (12000+130)
#define ERROR_GOPHER_NOT_FILE (12000+131)
#define ERROR_GOPHER_DATA_ERROR (12000+132)
#define ERROR_GOPHER_END_OF_DATA (12000+133)
#define ERROR_GOPHER_INVALID_LOCATOR (12000+134)
#define ERROR_GOPHER_INCORRECT_LOCATOR_TYPE (12000+135)
#define ERROR_GOPHER_NOT_GOPHER_PLUS (12000+136)
#define ERROR_GOPHER_ATTRIBUTE_NOT_FOUND (12000+137)
#define ERROR_GOPHER_UNKNOWN_LOCATOR (12000+138)
#define ERROR_HTTP_HEADER_NOT_FOUND (12000+150)
#define ERROR_HTTP_DOWNLEVEL_SERVER (12000+151)
#define ERROR_HTTP_INVALID_SERVER_RESPONSE (12000+152)
#define ERROR_HTTP_INVALID_HEADER (12000+153)
#define ERROR_HTTP_INVALID_QUERY_REQUEST (12000+154)
#define ERROR_HTTP_HEADER_ALREADY_EXISTS (12000+155)
#define ERROR_HTTP_REDIRECT_FAILED (12000+156)
#define ERROR_HTTP_NOT_REDIRECTED (12000+160)
#define ERROR_INTERNET_SECURITY_CHANNEL_ERROR (12000+157)
#define ERROR_INTERNET_UNABLE_TO_CACHE_FILE (12000+158)
#define ERROR_INTERNET_TCPIP_NOT_INSTALLED (12000+159)
#define INTERNET_ERROR_LAST (12000+159)
#define NORMAL_CACHE_ENTRY 1
#define STABLE_CACHE_ENTRY 2
#define STICKY_CACHE_ENTRY 4
#define SPARSE_CACHE_ENTRY &h10000
#define OCX_CACHE_ENTRY &h20000
#define COOKIE_CACHE_ENTRY &h100000
#define URLHISTORY_CACHE_ENTRY &h200000
#define CACHE_ENTRY_ATTRIBUTE_FC 4
#define CACHE_ENTRY_HITRATE_FC &h10
#define CACHE_ENTRY_MODTIME_FC &h40
#define CACHE_ENTRY_EXPTIME_FC &h80
#define CACHE_ENTRY_ACCTIME_FC &h100
#define CACHE_ENTRY_SYNCTIME_FC &h200
#define CACHE_ENTRY_HEADERINFO_FC &h400
#define IRF_NO_WAIT 8
#define HSR_INITIATE 8
#define HSR_DOWNLOAD 16
#define HSR_CHUNKED 32
#define INTERNET_DIAL_UNATTENDED &h8000
#define INTERNET_DIALSTATE_DISCONNECTED 1
#define INTERENT_GOONLINE_REFRESH 1
#define INTERENT_GOONLINE_MASK 1
#define INTERNET_AUTODIAL_FORCE_ONLINE 1
#define INTERNET_AUTODIAL_FORCE_UNATTENDED 2
#define INTERNET_AUTODIAL_FAILIFSECURITYCHECK 4
#define INTERNET_CONNECTION_MODEM &h01
#define INTERNET_CONNECTION_LAN &h02
#define INTERNET_CONNECTION_PROXY &h04
#define INTERNET_CONNECTION_MODEM_BUSY &h08
#define INTERNET_RAS_INSTALLED &h10
#define INTERNET_CONNECTION_OFFLINE &h20
#define INTERNET_CONNECTION_CONFIGURED &h40
#define CACHEGROUP_SEARCH_ALL 0
#define CACHEGROUP_SEARCH_BYURL 1
#define INTERNET_CACHE_GROUP_ADD 0
#define INTERNET_CACHE_GROUP_REMOVE 1
#define WININET_API_FLAG_ASYNC &h00000001
#define WININET_API_FLAG_SYNC &h00000004
#define WININET_API_FLAG_USE_CONTEXT &h00000008

type HINTERNET as PVOID
type LPHINTERNET as HINTERNET ptr
type INTERNET_PORT as WORD
type LPINTERNET_PORT as WORD ptr
type GROUPID as LONGLONG

enum INTERNET_SCHEME
	INTERNET_SCHEME_PARTIAL = -2
	INTERNET_SCHEME_UNKNOWN = -1
	INTERNET_SCHEME_DEFAULT = 0
	INTERNET_SCHEME_FTP
	INTERNET_SCHEME_GOPHER
	INTERNET_SCHEME_HTTP
	INTERNET_SCHEME_HTTPS
	INTERNET_SCHEME_FILE
	INTERNET_SCHEME_NEWS
	INTERNET_SCHEME_MAILTO
	INTERNET_SCHEME_SOCKS
	INTERNET_SCHEME_FIRST = INTERNET_SCHEME_FTP
	INTERNET_SCHEME_LAST = INTERNET_SCHEME_SOCKS
end enum


type INTERNET_ASYNC_RESULT
	dwResult as DWORD
	dwError as DWORD
end type

type LPINTERNET_ASYNC_RESULT as INTERNET_ASYNC_RESULT ptr

type INTERNET_PREFETCH_STATUS
	dwStatus as DWORD
	dwSize as DWORD
end type

type LPINTERNET_PREFETCH_STATUS as INTERNET_PREFETCH_STATUS ptr

type INTERNET_PROXY_INFO
	dwAccessType as DWORD
	lpszProxy as LPCTSTR
	lpszProxyBypass as LPCTSTR
end type

type LPINTERNET_PROXY_INFO as INTERNET_PROXY_INFO ptr

type INTERNET_VERSION_INFO
	dwMajorVersion as DWORD
	dwMinorVersion as DWORD
end type

type LPINTERNET_VERSION_INFO as INTERNET_VERSION_INFO ptr

#ifndef UNICODE
type URL_COMPONENTSA
	dwStructSize as DWORD
	lpszScheme as LPSTR
	dwSchemeLength as DWORD
	nScheme as INTERNET_SCHEME
	lpszHostName as LPSTR
	dwHostNameLength as DWORD
	nPort as INTERNET_PORT
	lpszUserName as LPSTR
	dwUserNameLength as DWORD
	lpszPassword as LPSTR
	dwPasswordLength as DWORD
	lpszUrlPath as LPSTR
	dwUrlPathLength as DWORD
	lpszExtraInfo as LPSTR
	dwExtraInfoLength as DWORD
end type

type LPURL_COMPONENTSA as URL_COMPONENTSA ptr

type GOPHER_FIND_DATAA
	DisplayString as zstring * 128+1
	GopherType as DWORD
	SizeLow as DWORD
	SizeHigh as DWORD
	LastModificationTime as FILETIME
	Locator as zstring * MAX_GOPHER_LOCATOR_LENGTH +1
end type

type LPGOPHER_FIND_DATAA as GOPHER_FIND_DATAA ptr

#else ''UNICODE
type URL_COMPONENTSW
	dwStructSize as DWORD
	lpszScheme as LPWSTR
	dwSchemeLength as DWORD
	nScheme as INTERNET_SCHEME
	lpszHostName as LPWSTR
	dwHostNameLength as DWORD
	nPort as INTERNET_PORT
	lpszUserName as LPWSTR
	dwUserNameLength as DWORD
	lpszPassword as LPWSTR
	dwPasswordLength as DWORD
	lpszUrlPath as LPWSTR
	dwUrlPathLength as DWORD
	lpszExtraInfo as LPWSTR
	dwExtraInfoLength as DWORD
end type

type LPURL_COMPONENTSW as URL_COMPONENTSW ptr

type GOPHER_FIND_DATAW
	DisplayString as wstring * 128+1
	GopherType as DWORD
	SizeLow as DWORD
	SizeHigh as DWORD
	LastModificationTime as FILETIME
	Locator as wstring * MAX_GOPHER_LOCATOR_LENGTH+1
end type

type LPGOPHER_FIND_DATAW as GOPHER_FIND_DATAW ptr

#endif ''UNICODE

type INTERNET_CERTIFICATE_INFO
	ftExpiry as FILETIME
	ftStart as FILETIME
	lpszSubjectInfo as LPTSTR
	lpszIssuerInfo as LPTSTR
	lpszProtocolName as LPTSTR
	lpszSignatureAlgName as LPTSTR
	lpszEncryptionAlgName as LPTSTR
	dwKeySize as DWORD
end type

type LPINTERNET_CERTIFICATE_INFO as INTERNET_CERTIFICATE_INFO ptr
type INTERNET_STATUS_CALLBACK as sub (byval as HINTERNET, byval as DWORD, byval as DWORD, byval as PVOID, byval as DWORD)
type LPINTERNET_STATUS_CALLBACK as INTERNET_STATUS_CALLBACK ptr

type GOPHER_ADMIN_ATTRIBUTE_TYPE
	Comment as LPCTSTR
	EmailAddress as LPCTSTR
end type

type LPGOPHER_ADMIN_ATTRIBUTE_TYPE as GOPHER_ADMIN_ATTRIBUTE_TYPE ptr

type GOPHER_MOD_DATE_ATTRIBUTE_TYPE
	DateAndTime as FILETIME
end type

type LPGOPHER_MOD_DATE_ATTRIBUTE_TYPE as GOPHER_MOD_DATE_ATTRIBUTE_TYPE ptr

type GOPHER_TTL_ATTRIBUTE_TYPE
	Ttl as DWORD
end type

type LPGOPHER_TTL_ATTRIBUTE_TYPE as GOPHER_TTL_ATTRIBUTE_TYPE ptr

type GOPHER_SCORE_ATTRIBUTE_TYPE
	Score as INT_
end type

type LPGOPHER_SCORE_ATTRIBUTE_TYPE as GOPHER_SCORE_ATTRIBUTE_TYPE ptr

type GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE
	LowerBound as INT_
	UpperBound as INT_
end type

type LPGOPHER_SCORE_RANGE_ATTRIBUTE_TYPE as GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE ptr

type GOPHER_SITE_ATTRIBUTE_TYPE
	Site as LPCTSTR
end type

type LPGOPHER_SITE_ATTRIBUTE_TYPE as GOPHER_SITE_ATTRIBUTE_TYPE ptr

type GOPHER_ORGANIZATION_ATTRIBUTE_TYPE
	Organization as LPCTSTR
end type

type LPGOPHER_ORGANIZATION_ATTRIBUTE_TYPE as GOPHER_ORGANIZATION_ATTRIBUTE_TYPE ptr

type GOPHER_LOCATION_ATTRIBUTE_TYPE
	Location as LPCTSTR
end type

type LPGOPHER_LOCATION_ATTRIBUTE_TYPE as GOPHER_LOCATION_ATTRIBUTE_TYPE ptr

type GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE
	DegreesNorth as INT_
	MinutesNorth as INT_
	SecondsNorth as INT_
	DegreesEast as INT_
	MinutesEast as INT_
	SecondsEast as INT_
end type

type LPGOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE as GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE ptr

type GOPHER_TIMEZONE_ATTRIBUTE_TYPE
	Zone as INT_
end type

type LPGOPHER_TIMEZONE_ATTRIBUTE_TYPE as GOPHER_TIMEZONE_ATTRIBUTE_TYPE ptr

type GOPHER_PROVIDER_ATTRIBUTE_TYPE
	Provider as LPCTSTR
end type

type LPGOPHER_PROVIDER_ATTRIBUTE_TYPE as GOPHER_PROVIDER_ATTRIBUTE_TYPE ptr

type GOPHER_VERSION_ATTRIBUTE_TYPE
	Version as LPCTSTR
end type

type LPGOPHER_VERSION_ATTRIBUTE_TYPE as GOPHER_VERSION_ATTRIBUTE_TYPE ptr

type GOPHER_ABSTRACT_ATTRIBUTE_TYPE
	ShortAbstract as LPCTSTR
	AbstractFile as LPCTSTR
end type

type LPGOPHER_ABSTRACT_ATTRIBUTE_TYPE as GOPHER_ABSTRACT_ATTRIBUTE_TYPE ptr

type GOPHER_VIEW_ATTRIBUTE_TYPE
	ContentType as LPCTSTR
	Language as LPCTSTR
	Size as DWORD
end type

type LPGOPHER_VIEW_ATTRIBUTE_TYPE as GOPHER_VIEW_ATTRIBUTE_TYPE ptr

type GOPHER_VERONICA_ATTRIBUTE_TYPE
	TreeWalk as BOOL
end type

type LPGOPHER_VERONICA_ATTRIBUTE_TYPE as GOPHER_VERONICA_ATTRIBUTE_TYPE ptr

type GOPHER_ASK_ATTRIBUTE_TYPE
	QuestionType as LPCTSTR
	QuestionText as LPCTSTR
end type

type LPGOPHER_ASK_ATTRIBUTE_TYPE as GOPHER_ASK_ATTRIBUTE_TYPE ptr

type GOPHER_UNKNOWN_ATTRIBUTE_TYPE
	Text as LPCTSTR
end type

type LPGOPHER_UNKNOWN_ATTRIBUTE_TYPE as GOPHER_UNKNOWN_ATTRIBUTE_TYPE ptr

union GOPHER_ATTRIBUTE_TYPE_AttributeType
	Admin as GOPHER_ADMIN_ATTRIBUTE_TYPE
	ModDate as GOPHER_MOD_DATE_ATTRIBUTE_TYPE
	Ttl as GOPHER_TTL_ATTRIBUTE_TYPE
	Score as GOPHER_SCORE_ATTRIBUTE_TYPE
	ScoreRange as GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE
	Site as GOPHER_SITE_ATTRIBUTE_TYPE
	Organization as GOPHER_ORGANIZATION_ATTRIBUTE_TYPE
	Location as GOPHER_LOCATION_ATTRIBUTE_TYPE
	GeographicalLocation as GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE
	TimeZone as GOPHER_TIMEZONE_ATTRIBUTE_TYPE
	Provider as GOPHER_PROVIDER_ATTRIBUTE_TYPE
	Version as GOPHER_VERSION_ATTRIBUTE_TYPE
	Abstract as GOPHER_ABSTRACT_ATTRIBUTE_TYPE
	View as GOPHER_VIEW_ATTRIBUTE_TYPE
	Veronica as GOPHER_VERONICA_ATTRIBUTE_TYPE
	Ask as GOPHER_ASK_ATTRIBUTE_TYPE
	Unknown as GOPHER_UNKNOWN_ATTRIBUTE_TYPE
end union

type GOPHER_ATTRIBUTE_TYPE
	CategoryId as DWORD
	AttributeId as DWORD
	AttributeType as GOPHER_ATTRIBUTE_TYPE_AttributeType
end type

type LPGOPHER_ATTRIBUTE_TYPE as GOPHER_ATTRIBUTE_TYPE ptr

type GOPHER_ATTRIBUTE_ENUMERATOR as function (byval as LPGOPHER_ATTRIBUTE_TYPE, byval as DWORD) as BOOL

#ifndef UNICODE
type INTERNET_CACHE_ENTRY_INFOA
	dwStructSize as DWORD
	lpszSourceUrlName as LPSTR
	lpszLocalFileName as LPSTR
	CacheEntryType as DWORD
	dwUseCount as DWORD
	dwHitRate as DWORD
	dwSizeLow as DWORD
	dwSizeHigh as DWORD
	LastModifiedTime as FILETIME
	ExpireTime as FILETIME
	LastAccessTime as FILETIME
	LastSyncTime as FILETIME
	lpHeaderInfo as PBYTE
	dwHeaderInfoSize as DWORD
	lpszFileExtension as LPSTR
	dwReserved as DWORD
end type

type LPINTERNET_CACHE_ENTRY_INFOA as INTERNET_CACHE_ENTRY_INFOA ptr

type INTERNET_BUFFERSA
	dwStructSize as DWORD
	Next as INTERNET_BUFFERSA ptr
	lpcszHeader as LPCSTR
	dwHeadersLength as DWORD
	dwHeadersTotal as DWORD
	lpvBuffer as LPVOID
	dwBufferLength as DWORD
	dwBufferTotal as DWORD
	dwOffsetLow as DWORD
	dwOffsetHigh as DWORD
end type

type LPINTERNET_BUFFERSA as INTERNET_BUFFERSA ptr

type URL_COMPONENTS as URL_COMPONENTSA
type LPURL_COMPONENTS as LPURL_COMPONENTSA
type GOPHER_FIND_DATA as GOPHER_FIND_DATAA
type LPGOPHER_FIND_DATA as LPGOPHER_FIND_DATAA
type INTERNET_CACHE_ENTRY_INFO as INTERNET_CACHE_ENTRY_INFOA
type LPINTERNET_CACHE_ENTRY_INFO as LPINTERNET_CACHE_ENTRY_INFOA
type INTERNET_BUFFERS as INTERNET_BUFFERSA
type LPINTERNET_BUFFERS as INTERNET_BUFFERSA ptr

#else ''UNICODE

type INTERNET_CACHE_ENTRY_INFOW
	dwStructSize as DWORD
	lpszSourceUrlName as LPSTR
	lpszLocalFileName as LPWSTR
	CacheEntryType as DWORD
	dwUseCount as DWORD
	dwHitRate as DWORD
	dwSizeLow as DWORD
	dwSizeHigh as DWORD
	LastModifiedTime as FILETIME
	ExpireTime as FILETIME
	LastAccessTime as FILETIME
	LastSyncTime as FILETIME
	lpHeaderInfo as PBYTE
	dwHeaderInfoSize as DWORD
	lpszFileExtension as LPWSTR
	dwReserved as DWORD
end type

type LPINTERNET_CACHE_ENTRY_INFOW as INTERNET_CACHE_ENTRY_INFOW ptr

type INTERNET_BUFFERSW
	dwStructSize as DWORD
	Next as INTERNET_BUFFERSW ptr
	lpcszHeader as LPCWSTR
	dwHeadersLength as DWORD
	dwHeadersTotal as DWORD
	lpvBuffer as LPVOID
	dwBufferLength as DWORD
	dwBufferTotal as DWORD
	dwOffsetLow as DWORD
	dwOffsetHigh as DWORD
end type

type LPINTERNET_BUFFERSW as INTERNET_BUFFERSW ptr

type URL_COMPONENTS as URL_COMPONENTSW
type LPURL_COMPONENTS as LPURL_COMPONENTSW
type GOPHER_FIND_DATA as GOPHER_FIND_DATAW
type LPGOPHER_FIND_DATA as LPGOPHER_FIND_DATAW
type INTERNET_CACHE_ENTRY_INFO as INTERNET_CACHE_ENTRY_INFOW
type LPINTERNET_CACHE_ENTRY_INFO as LPINTERNET_CACHE_ENTRY_INFOW
type INTERNET_BUFFERS as INTERNET_BUFFERSW
type LPINTERNET_BUFFERS as INTERNET_BUFFERSW ptr

#endif '' UNICODE

#define GROUP_OWNER_STORAGE_SIZE 4
#define GROUPNAME_MAX_LENGTH 120

#ifndef UNICODE
type INTERNET_CACHE_GROUP_INFOA
	dwGroupSize as DWORD
	dwGroupFlags as DWORD
	dwGroupType as DWORD
	dwDiskUsage as DWORD
	dwDiskQuota as DWORD
	dwOwnerStorage(0 to 4-1) as DWORD
	szGroupName as zstring * 120
end type

type LPINTERNET_CACHE_GROUP_INFOA as INTERNET_CACHE_GROUP_INFOA ptr

#else
type INTERNET_CACHE_GROUP_INFOW
	dwGroupSize as DWORD
	dwGroupFlags as DWORD
	dwGroupType as DWORD
	dwDiskUsage as DWORD
	dwDiskQuota as DWORD
	dwOwnerStorage(0 to 4-1) as DWORD
	szGroupName as wstring * 120
end type

type LPINTERNET_CACHE_GROUP_INFOW as INTERNET_CACHE_GROUP_INFOW ptr
#endif ''UNICODE


declare function InternetTimeFromSystemTime alias "InternetTimeFromSystemTime" (byval as SYSTEMTIME ptr, byval as DWORD, byval as LPSTR, byval as DWORD) as BOOL
declare function InternetTimeToSystemTime alias "InternetTimeToSystemTime" (byval as LPCSTR, byval as SYSTEMTIME ptr, byval as DWORD) as BOOL
declare function InternetDebugGetLocalTime alias "InternetDebugGetLocalTime" (byval as SYSTEMTIME ptr, byval as PDWORD) as BOOL
declare function InternetCloseHandle alias "InternetCloseHandle" (byval as HINTERNET) as BOOL
declare function InternetReadFile alias "InternetReadFile" (byval as HINTERNET, byval as PVOID, byval as DWORD, byval as PDWORD) as BOOL
declare function InternetSetFilePointer alias "InternetSetFilePointer" (byval as HINTERNET, byval as LONG, byval as PVOID, byval as DWORD, byval as DWORD) as DWORD
declare function InternetWriteFile alias "InternetWriteFile" (byval as HINTERNET, byval as LPCVOID, byval as DWORD, byval as PDWORD) as BOOL
declare function InternetQueryDataAvailable alias "InternetQueryDataAvailable" (byval as HINTERNET, byval as PDWORD, byval as DWORD, byval as DWORD) as BOOL
declare function InternetSetStatusCallback alias "InternetSetStatusCallback" (byval as HINTERNET, byval as INTERNET_STATUS_CALLBACK) as INTERNET_STATUS_CALLBACK
declare function FtpGetFileSize alias "FtpGetFileSize" (byval as HINTERNET, byval as LPDWORD) as DWORD
declare function InternetAttemptConnect alias "InternetAttemptConnect" (byval as DWORD) as DWORD
declare function InternetErrorDlg alias "InternetErrorDlg" (byval as HWND, byval as HINTERNET, byval as DWORD, byval as DWORD, byval as PVOID ptr) as DWORD
declare function InternetConfirmZoneCrossing alias "InternetConfirmZoneCrossing" (byval as HWND, byval as LPSTR, byval as LPSTR, byval as BOOL) as DWORD
declare function UnlockUrlCacheEntryFile alias "UnlockUrlCacheEntryFile" (byval as LPCSTR, byval as DWORD) as BOOL
declare function ReadUrlCacheEntryStream alias "ReadUrlCacheEntryStream" (byval as HANDLE, byval as DWORD, byval as PVOID, byval as PDWORD, byval as DWORD) as BOOL
declare function UnlockUrlCacheEntryStream alias "UnlockUrlCacheEntryStream" (byval as HANDLE, byval as DWORD) as BOOL
declare function FindCloseUrlCache alias "FindCloseUrlCache" (byval as HANDLE) as BOOL
declare function DeleteUrlCacheEntry alias "DeleteUrlCacheEntry" (byval as LPCSTR) as BOOL
declare function AuthenticateUser alias "AuthenticateUser" (byval as PVOID ptr, byval as LPSTR, byval as LPSTR, byval as DWORD, byval as LPSTR, byval as DWORD, byval as LPSTR, byval as LPSTR) as DWORD
declare function InternetDial alias "InternetDial" (byval as HWND, byval as LPTSTR, byval as DWORD, byval as LPDWORD, byval as DWORD) as DWORD
declare function InternetHangUp alias "InternetHangUp" (byval as DWORD, byval as DWORD) as DWORD
declare function InternetGoOnline alias "InternetGoOnline" (byval as LPTSTR, byval as HWND, byval as DWORD) as BOOL
declare function InternetAutodial alias "InternetAutodial" (byval as DWORD, byval as DWORD) as BOOL
declare function InternetAutodialHangup alias "InternetAutodialHangup" (byval as DWORD) as BOOL
declare function InternetGetConnectedState alias "InternetGetConnectedState" (byval as LPDWORD, byval as DWORD) as BOOL
declare function InternetSetDialState alias "InternetSetDialState" (byval as LPCTSTR, byval as DWORD, byval as DWORD) as BOOL
declare function CreateUrlCacheGroup alias "CreateUrlCacheGroup" (byval as DWORD, byval as LPVOID) as GROUPID
declare function DeleteUrlCacheGroup alias "DeleteUrlCacheGroup" (byval as GROUPID, byval as DWORD, byval as LPVOID) as BOOL
declare function FindFirstUrlCacheGroup alias "FindFirstUrlCacheGroup" (byval as DWORD, byval as DWORD, byval as LPVOID, byval as DWORD, byval as GROUPID ptr, byval as LPVOID) as HANDLE
declare function FindNextUrlCacheGroup alias "FindNextUrlCacheGroup" (byval as HANDLE, byval as GROUPID ptr, byval as LPVOID) as BOOL

#ifdef UNICODE
type INTERNET_CACHE_GROUP_INFO as INTERNET_CACHE_GROUP_INFOW
type LPINTERNET_CACHE_GROUP_INFO as LPINTERNET_CACHE_GROUP_INFOW

declare function InternetCrackUrl alias "InternetCrackUrlW" (byval as LPCWSTR, byval as DWORD, byval as DWORD, byval as LPURL_COMPONENTSW) as BOOL
declare function InternetCreateUrl alias "InternetCreateUrlW" (byval as LPURL_COMPONENTSW, byval as DWORD, byval as LPWSTR, byval as PDWORD) as BOOL
declare function InternetCanonicalizeUrl alias "InternetCanonicalizeUrlW" (byval as LPCWSTR, byval as LPWSTR, byval as PDWORD, byval as DWORD) as BOOL
declare function InternetCheckConnection alias "InternetCheckConnectionW" (byval as LPCWSTR, byval as DWORD, byval as DWORD) as BOOL
declare function InternetCombineUrl alias "InternetCombineUrlW" (byval as LPCWSTR, byval as LPCWSTR, byval as LPWSTR, byval as PDWORD, byval as DWORD) as BOOL
declare function InternetOpen alias "InternetOpenW" (byval as LPCWSTR, byval as DWORD, byval as LPCWSTR, byval as LPCWSTR, byval as DWORD) as HINTERNET
declare function InternetConnect alias "InternetConnectW" (byval as HINTERNET, byval as LPCWSTR, byval as INTERNET_PORT, byval as LPCWSTR, byval as LPCWSTR, byval as DWORD, byval as DWORD, byval as DWORD) as HINTERNET
declare function InternetOpenUrl alias "InternetOpenUrlW" (byval as HINTERNET, byval as LPCWSTR, byval as LPCWSTR, byval as DWORD, byval as DWORD, byval as DWORD) as HINTERNET
declare function InternetFindNextFile alias "InternetFindNextFileW" (byval as HINTERNET, byval as PVOID) as BOOL
declare function InternetQueryOption alias "InternetQueryOptionW" (byval as HINTERNET, byval as DWORD, byval as PVOID, byval as PDWORD) as BOOL
declare function InternetSetOption alias "InternetSetOptionW" (byval as HINTERNET, byval as DWORD, byval as PVOID, byval as DWORD) as BOOL
declare function InternetSetOptionEx alias "InternetSetOptionExW" (byval as HINTERNET, byval as DWORD, byval as PVOID, byval as DWORD, byval as DWORD) as BOOL
declare function InternetGetLastResponseInfo alias "InternetGetLastResponseInfoW" (byval as PDWORD, byval as LPWSTR, byval as PDWORD) as BOOL
declare function FtpFindFirstFile alias "FtpFindFirstFileW" (byval as HINTERNET, byval as LPCWSTR, byval as LPWIN32_FIND_DATA, byval as DWORD, byval as DWORD) as HINTERNET
declare function FtpGetFile alias "FtpGetFileW" (byval as HINTERNET, byval as LPCWSTR, byval as LPCWSTR, byval as BOOL, byval as DWORD, byval as DWORD, byval as DWORD) as BOOL
declare function FtpPutFile alias "FtpPutFileW" (byval as HINTERNET, byval as LPCWSTR, byval as LPCWSTR, byval as DWORD, byval as DWORD) as BOOL
declare function FtpDeleteFile alias "FtpDeleteFileW" (byval as HINTERNET, byval as LPCWSTR) as BOOL
declare function FtpRenameFile alias "FtpRenameFileW" (byval as HINTERNET, byval as LPCWSTR, byval as LPCWSTR) as BOOL
declare function FtpOpenFile alias "FtpOpenFileW" (byval as HINTERNET, byval as LPCWSTR, byval as DWORD, byval as DWORD, byval as DWORD) as HINTERNET
declare function FtpCreateDirectory alias "FtpCreateDirectoryW" (byval as HINTERNET, byval as LPCWSTR) as BOOL
declare function FtpRemoveDirectory alias "FtpRemoveDirectoryW" (byval as HINTERNET, byval as LPCWSTR) as BOOL
declare function FtpSetCurrentDirectory alias "FtpSetCurrentDirectoryW" (byval as HINTERNET, byval as LPCWSTR) as BOOL
declare function FtpGetCurrentDirectory alias "FtpGetCurrentDirectoryW" (byval as HINTERNET, byval as LPWSTR, byval as PDWORD) as BOOL
declare function FtpCommand alias "FtpCommandW" (byval as HINTERNET, byval as BOOL, byval as DWORD, byval as LPCWSTR, byval as DWORD_PTR, byval as HINTERNET ptr) as BOOL
declare function GopherCreateLocator alias "GopherCreateLocatorW" (byval as LPCWSTR, byval as INTERNET_PORT, byval as LPCWSTR, byval as LPCWSTR, byval as DWORD, byval as LPWSTR, byval as PDWORD) as BOOL
declare function GopherGetLocatorType alias "GopherGetLocatorTypeW" (byval as LPCWSTR, byval as PDWORD) as BOOL
declare function GopherFindFirstFile alias "GopherFindFirstFileW" (byval as HINTERNET, byval as LPCWSTR, byval as LPCWSTR, byval as LPGOPHER_FIND_DATAW, byval as DWORD, byval as DWORD) as HINTERNET
declare function GopherOpenFile alias "GopherOpenFileW" (byval as HINTERNET, byval as LPCWSTR, byval as LPCWSTR, byval as DWORD, byval as DWORD) as HINTERNET
declare function GopherGetAttribute alias "GopherGetAttributeW" (byval as HINTERNET, byval as LPCWSTR, byval as LPCWSTR, byval as LPBYTE, byval as DWORD, byval as PDWORD, byval as GOPHER_ATTRIBUTE_ENUMERATOR, byval as DWORD) as BOOL
declare function HttpOpenRequest alias "HttpOpenRequestW" (byval as HINTERNET, byval as LPCWSTR, byval as LPCWSTR, byval as LPCWSTR, byval as LPCWSTR, byval lplpszAcceptTypes as LPCWSTR ptr, byval dwFlags as DWORD, byval dwContext as DWORD) as HINTERNET
declare function HttpAddRequestHeaders alias "HttpAddRequestHeadersW" (byval as HINTERNET, byval as LPCWSTR, byval as DWORD, byval as DWORD) as BOOL
declare function HttpSendRequest alias "HttpSendRequestW" (byval as HINTERNET, byval as LPCWSTR, byval as DWORD, byval as PVOID, byval as DWORD) as BOOL
declare function HttpQueryInfo alias "HttpQueryInfoW" (byval as HINTERNET, byval as DWORD, byval as PVOID, byval as PDWORD, byval as PDWORD) as BOOL
declare function InternetSetCookie alias "InternetSetCookieW" (byval as LPCSTR, byval as LPCWSTR, byval as LPCWSTR) as BOOL
declare function InternetGetCookie alias "InternetGetCookieW" (byval as LPCSTR, byval as LPCWSTR, byval as LPWSTR, byval as PDWORD) as BOOL
declare function CreateUrlCacheEntry alias "CreateUrlCacheEntryW" (byval as LPCSTR, byval as DWORD, byval as LPCSTR, byval as LPWSTR, byval as DWORD) as BOOL
declare function CommitUrlCacheEntry alias "CommitUrlCacheEntryW" (byval as LPCSTR, byval as LPCWSTR, byval as FILETIME, byval as FILETIME, byval as DWORD, byval as LPBYTE, byval as DWORD, byval as LPCWSTR, byval as DWORD) as BOOL
declare function RetrieveUrlCacheEntryFile alias "RetrieveUrlCacheEntryFileW" (byval as LPCSTR, byval as LPINTERNET_CACHE_ENTRY_INFOW, byval as PDWORD, byval as DWORD) as BOOL
declare function RetrieveUrlCacheEntryStream alias "RetrieveUrlCacheEntryStreamW" (byval as LPCSTR, byval as LPINTERNET_CACHE_ENTRY_INFOW, byval as PDWORD, byval as BOOL, byval as DWORD) as HANDLE
declare function GetUrlCacheEntryInfo alias "GetUrlCacheEntryInfoW" (byval as LPCSTR, byval as LPINTERNET_CACHE_ENTRY_INFOW, byval as PDWORD) as BOOL
declare function SetUrlCacheEntryInfo alias "SetUrlCacheEntryInfoW" (byval as LPCSTR, byval as LPINTERNET_CACHE_ENTRY_INFOW, byval as DWORD) as BOOL
declare function FindFirstUrlCacheEntry alias "FindFirstUrlCacheEntryW" (byval as LPCSTR, byval as LPINTERNET_CACHE_ENTRY_INFOW, byval as PDWORD) as HANDLE
declare function FindNextUrlCacheEntry alias "FindNextUrlCacheEntryW" (byval as HANDLE, byval as LPINTERNET_CACHE_ENTRY_INFOW, byval as PDWORD) as BOOL
declare function HttpSendRequestEx alias "HttpSendRequestExW" (byval as HINTERNET, byval as LPINTERNET_BUFFERSW, byval as LPINTERNET_BUFFERSW, byval as DWORD, byval as DWORD) as BOOL
declare function HttpEndRequest alias "HttpEndRequestW" (byval as HINTERNET, byval as LPINTERNET_BUFFERSW, byval as DWORD, byval as DWORD) as BOOL
declare function InternetReadFileEx alias "InternetReadFileExW" (byval as HINTERNET, byval as LPINTERNET_BUFFERSW, byval as DWORD, byval as DWORD_PTR) as BOOL
declare function GetUrlCacheGroupAttribute alias "GetUrlCacheGroupAttributeW" (byval as GROUPID, byval as DWORD, byval as DWORD, byval as LPINTERNET_CACHE_GROUP_INFOW, byval as LPDWORD, byval as LPVOID) as BOOL
declare function SetUrlCacheGroupAttribute alias "SetUrlCacheGroupAttributeW" (byval as GROUPID, byval as DWORD, byval as DWORD, byval as LPINTERNET_CACHE_GROUP_INFOW, byval as LPVOID) as BOOL

#else ''UNICODE
type INTERNET_CACHE_GROUP_INFO as INTERNET_CACHE_GROUP_INFOA
type LPINTERNET_CACHE_GROUP_INFO as LPINTERNET_CACHE_GROUP_INFOA

declare function InternetCrackUrl alias "InternetCrackUrlA" (byval as LPCSTR, byval as DWORD, byval as DWORD, byval as LPURL_COMPONENTSA) as BOOL
declare function InternetCreateUrl alias "InternetCreateUrlA" (byval as LPURL_COMPONENTSA, byval as DWORD, byval as LPSTR, byval as PDWORD) as BOOL
declare function InternetCanonicalizeUrl alias "InternetCanonicalizeUrlA" (byval as LPCSTR, byval as LPSTR, byval as PDWORD, byval as DWORD) as BOOL
declare function InternetCheckConnection alias "InternetCheckConnectionA" (byval as LPCSTR, byval as DWORD, byval as DWORD) as BOOL
declare function InternetCombineUrl alias "InternetCombineUrlA" (byval as LPCSTR, byval as LPCSTR, byval as LPSTR, byval as PDWORD, byval as DWORD) as BOOL
declare function InternetOpen alias "InternetOpenA" (byval as LPCSTR, byval as DWORD, byval as LPCSTR, byval as LPCSTR, byval as DWORD) as HINTERNET
declare function InternetConnect alias "InternetConnectA" (byval as HINTERNET, byval as LPCSTR, byval as INTERNET_PORT, byval as LPCSTR, byval as LPCSTR, byval as DWORD, byval as DWORD, byval as DWORD) as HINTERNET
declare function InternetOpenUrl alias "InternetOpenUrlA" (byval as HINTERNET, byval as LPCSTR, byval as LPCSTR, byval as DWORD, byval as DWORD, byval as DWORD) as HINTERNET
declare function InternetFindNextFile alias "InternetFindNextFileA" (byval as HINTERNET, byval as PVOID) as BOOL
declare function InternetQueryOption alias "InternetQueryOptionA" (byval as HINTERNET, byval as DWORD, byval as PVOID, byval as PDWORD) as BOOL
declare function InternetSetOption alias "InternetSetOptionA" (byval as HINTERNET, byval as DWORD, byval as PVOID, byval as DWORD) as BOOL
declare function InternetSetOptionEx alias "InternetSetOptionExA" (byval as HINTERNET, byval as DWORD, byval as PVOID, byval as DWORD, byval as DWORD) as BOOL
declare function InternetGetLastResponseInfo alias "InternetGetLastResponseInfoA" (byval as PDWORD, byval as LPSTR, byval as PDWORD) as BOOL
declare function FtpFindFirstFile alias "FtpFindFirstFileA" (byval as HINTERNET, byval as LPCSTR, byval as LPWIN32_FIND_DATA, byval as DWORD, byval as DWORD) as HINTERNET
declare function FtpGetFile alias "FtpGetFileA" (byval as HINTERNET, byval as LPCSTR, byval as LPCSTR, byval as BOOL, byval as DWORD, byval as DWORD, byval as DWORD) as BOOL
declare function FtpPutFile alias "FtpPutFileA" (byval as HINTERNET, byval as LPCSTR, byval as LPCSTR, byval as DWORD, byval as DWORD) as BOOL
declare function FtpDeleteFile alias "FtpDeleteFileA" (byval as HINTERNET, byval as LPCSTR) as BOOL
declare function FtpRenameFile alias "FtpRenameFileA" (byval as HINTERNET, byval as LPCSTR, byval as LPCSTR) as BOOL
declare function FtpOpenFile alias "FtpOpenFileA" (byval as HINTERNET, byval as LPCSTR, byval as DWORD, byval as DWORD, byval as DWORD) as HINTERNET
declare function FtpCreateDirectory alias "FtpCreateDirectoryA" (byval as HINTERNET, byval as LPCSTR) as BOOL
declare function FtpRemoveDirectory alias "FtpRemoveDirectoryA" (byval as HINTERNET, byval as LPCSTR) as BOOL
declare function FtpSetCurrentDirectory alias "FtpSetCurrentDirectoryA" (byval as HINTERNET, byval as LPCSTR) as BOOL
declare function FtpGetCurrentDirectory alias "FtpGetCurrentDirectoryA" (byval as HINTERNET, byval as LPSTR, byval as PDWORD) as BOOL
declare function FtpCommand alias "FtpCommandA" (byval as HINTERNET, byval as BOOL, byval as DWORD, byval as LPCSTR, byval as DWORD_PTR, byval as HINTERNET ptr) as BOOL
declare function GopherCreateLocator alias "GopherCreateLocatorA" (byval as LPCSTR, byval as INTERNET_PORT, byval as LPCSTR, byval as LPCSTR, byval as DWORD, byval as LPSTR, byval as PDWORD) as BOOL
declare function GopherGetLocatorType alias "GopherGetLocatorTypeA" (byval as LPCSTR, byval as PDWORD) as BOOL
declare function GopherFindFirstFile alias "GopherFindFirstFileA" (byval as HINTERNET, byval as LPCSTR, byval as LPCSTR, byval as LPGOPHER_FIND_DATAA, byval as DWORD, byval as DWORD) as HINTERNET
declare function GopherOpenFile alias "GopherOpenFileA" (byval as HINTERNET, byval as LPCSTR, byval as LPCSTR, byval as DWORD, byval as DWORD) as HINTERNET
declare function GopherGetAttribute alias "GopherGetAttributeA" (byval as HINTERNET, byval as LPCSTR, byval as LPCSTR, byval as LPBYTE, byval as DWORD, byval as PDWORD, byval as GOPHER_ATTRIBUTE_ENUMERATOR, byval as DWORD) as BOOL
declare function HttpOpenRequest alias "HttpOpenRequestA" (byval as HINTERNET, byval as LPCSTR, byval as LPCSTR, byval as LPCSTR, byval as LPCSTR, byval as LPCSTR ptr, byval as DWORD, byval as DWORD) as HINTERNET
declare function HttpAddRequestHeaders alias "HttpAddRequestHeadersA" (byval as HINTERNET, byval as LPCSTR, byval as DWORD, byval as DWORD) as BOOL
declare function HttpSendRequest alias "HttpSendRequestA" (byval as HINTERNET, byval as LPCSTR, byval as DWORD, byval as PVOID, byval as DWORD) as BOOL
declare function HttpQueryInfo alias "HttpQueryInfoA" (byval as HINTERNET, byval as DWORD, byval as PVOID, byval as PDWORD, byval as PDWORD) as BOOL
declare function InternetSetCookie alias "InternetSetCookieA" (byval as LPCSTR, byval as LPCSTR, byval as LPCSTR) as BOOL
declare function InternetGetCookie alias "InternetGetCookieA" (byval as LPCSTR, byval as LPCSTR, byval as LPSTR, byval as PDWORD) as BOOL
declare function CreateUrlCacheEntry alias "CreateUrlCacheEntryA" (byval as LPCSTR, byval as DWORD, byval as LPCSTR, byval as LPSTR, byval as DWORD) as BOOL
declare function CommitUrlCacheEntry alias "CommitUrlCacheEntryA" (byval as LPCSTR, byval as LPCSTR, byval as FILETIME, byval as FILETIME, byval as DWORD, byval as LPBYTE, byval as DWORD, byval as LPCSTR, byval as DWORD) as BOOL
declare function RetrieveUrlCacheEntryFile alias "RetrieveUrlCacheEntryFileA" (byval as LPCSTR, byval as LPINTERNET_CACHE_ENTRY_INFOA, byval as PDWORD, byval as DWORD) as BOOL
declare function RetrieveUrlCacheEntryStream alias "RetrieveUrlCacheEntryStreamA" (byval as LPCSTR, byval as LPINTERNET_CACHE_ENTRY_INFOA, byval as PDWORD, byval as BOOL, byval as DWORD) as HANDLE
declare function GetUrlCacheEntryInfo alias "GetUrlCacheEntryInfoA" (byval as LPCSTR, byval as LPINTERNET_CACHE_ENTRY_INFOA, byval as PDWORD) as BOOL
declare function SetUrlCacheEntryInfo alias "SetUrlCacheEntryInfoA" (byval as LPCSTR, byval as LPINTERNET_CACHE_ENTRY_INFOA, byval as DWORD) as BOOL
declare function FindFirstUrlCacheEntry alias "FindFirstUrlCacheEntryA" (byval as LPCSTR, byval as LPINTERNET_CACHE_ENTRY_INFOA, byval as PDWORD) as HANDLE
declare function FindNextUrlCacheEntry alias "FindNextUrlCacheEntryA" (byval as HANDLE, byval as LPINTERNET_CACHE_ENTRY_INFOA, byval as PDWORD) as BOOL
declare function HttpSendRequestEx alias "HttpSendRequestExA" (byval as HINTERNET, byval as LPINTERNET_BUFFERSA, byval as LPINTERNET_BUFFERSA, byval as DWORD, byval as DWORD) as BOOL
declare function HttpEndRequest alias "HttpEndRequestA" (byval as HINTERNET, byval as LPINTERNET_BUFFERSA, byval as DWORD, byval as DWORD) as BOOL
declare function InternetReadFileEx alias "InternetReadFileExA" (byval as HINTERNET, byval as LPINTERNET_BUFFERSA, byval as DWORD, byval as DWORD_PTR) as BOOL
declare function GetUrlCacheGroupAttribute alias "GetUrlCacheGroupAttributeA" (byval as GROUPID, byval as DWORD, byval as DWORD, byval as LPINTERNET_CACHE_GROUP_INFOA, byval as LPDWORD, byval as LPVOID) as BOOL
declare function SetUrlCacheGroupAttribute alias "SetUrlCacheGroupAttributeA" (byval as GROUPID, byval as DWORD, byval as DWORD, byval as LPINTERNET_CACHE_GROUP_INFOA, byval as LPVOID) as BOOL

#endif ''UNICODE

#endif
