@echo off

set BUILD_SELF=%0
if "%1" == "clean" goto CLEAN
if not "%1" == "upx" goto NoUPX
set MAIN_UPX=yes
shift
:NoUPX
set MAIN_SOURCE=DRVDIAG

if "%1" == "" deltree /y FAILED >NUL
if exist FAILED goto ErrorDone

if errorlevel 1 goto ZeroErrorLevel
verrlvl 0
if errorlevel 1 goto MissingV8PT
:ZeroErrorLevel
verrlvl 1
if not errorlevel 1 goto MissingV8PT
verrlvl 0

:Repeat
set ASM=NASM.EXE
set TPC=TPC.EXE
if exist %DOSDIR%\LINKS\NASM.BAT set ASM=call NASM.BAT
if exist %DOSDIR%\LINKS\NASM.COM set ASM=NASM.COM
if exist %DOSDIR%\LINKS\TPC.BAT set TPC=call TPC.BAT
if exist %DOSDIR%\LINKS\TPC.COM set TPC=TPC.COM

if not exist BIN\NUL mkdir BIN
if not exist BIN\NUL goto Error

if "%1" == "" goto BUILD-ALL
goto %1

:NASM-COM
shift
vecho compile /fCyan %1.ASM /fGray to /fWhite %1.COM /fGray
if exist BIN\%1.COM del BIN\%1.COM
%ASM% %1.ASM -fbin -O9 -o BIN\%1.COM
if errorlevel 1 goto Error
if not exist BIN\%1.COM goto Error
vecho binary executable /fLightGreen %1 /fGray created
goto End

:NASM-OBJ
shift
if exist %1.OBJ goto End
vecho compile /fCyan %1.ASM /fGray to /fWhite %1.OBJ /fGray
%ASM% %1.ASM -fobj -O9 -o %1.OBJ
if errorlevel 1 goto Error
if not exist %1.OBJ goto Error
vecho binary obj /fLightGreen %1 /fGray created
goto End

:NASM-SUB
if "%2" == "" goto Error
set PROG=
vfdutil /n %2 | set /p PROG=
if "%PROG%" == "" goto End
call %BUILD_SELF% NASM-OBJ %PROG%
goto End

:TPC-TPU
shift
if exist %1.TPU goto End
vecho compile /fCyan %1.PAS /fGray to /fWhite %1.TPU /fGray
%TPC% -M %1.PAS
if errorlevel 1 goto Error
if not exist %1.TPU goto Error
vecho binary obj /fLightGreen %1 /fGray created
goto End

:TPC-SUB
if "%2" == "" goto Error
set PROG=
vfdutil /n %2 | set /p PROG=
if "%PROG%" == "%MAIN_SOURCE%" goto End
call %BUILD_SELF% TPC-TPU %PROG%
goto End

:BUILD-ALL
call %BUILD_SELF% clean
veach /d *.asm /x %BUILD_SELF% NASM-SUB *
if errorlevel 1 goto Error
if exist FAILED goto ErrorDone
veach /d *.pas /x %BUILD_SELF% TPC-SUB *
if errorlevel 1 goto Error
if exist FAILED goto ErrorDone

vecho compile /fCyan %MAIN_SOURCE%.PAS /fGray to /fWhite %MAIN_SOURCE%.EXE /fGray
%TPC% %MAIN_SOURCE%.PAS -EBIN
if not exist BIN\%MAIN_SOURCE%.EXE goto Error
if exist FAILED goto ErrorDone
vecho executable /fLightGreen %MAIN_SOURCE%.EXE /fGray created
if not "%MAIN_UPX%" == "yes" goto SkipUPX
upx --8086 BIN\*.EXE
:SkipUPX
set MAIN_UPX=
set BUILD_SELF=
dir BIN\*.EXE | vstr /l 4
goto Done

:MissingV8PT
echo Missing required V8Power Tools for DOS.
echo visit http://up.lod.bz/V8Power
goto End

:CLEAN
deltree /y FAILED >NUL
deltree /y BIN >NUL
deltree /y *.OBJ >NUL
deltree /y *.TPU >NUL
goto End

:Error
vecho /fLightRed ERROR! /fGray %1
echo Build Failed>FAILED

:ErrorDone
verrlvl 1
set MAIN_UPX=
set BUILD_SELF=

:Done
set ASM=
set TPC=
set SOURCES=
set PROG=
set MAIN_SOURCE=

:End
